#ifdef MSS
#include <mss.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "allegro.h"
#include "vb_types.h"
#include "v810_ins.h" //Needed for sign_16()
#include "v810_cpu.h"
#include "v810cpuD.h"
#include "vb_dspD.h" //Debug code
#include "vb_vbt.h"
#include "vb_vbtD.h"
#include "vb_set.h"
#include "vb_dsp.h"
#include "vb_gui.h"  //for w_title
#include "vb_dsp.h"

////////////////////////////////////////////////////////////////////
// Globals
int pCnt = 0;
int isDsp =0;
int CurObj=3;
int MaxBrt = 30;
RGB pallete[256];  //keep a global pall, so we dont have to clear the whole thing....
unsigned short vbpalette[256] ;
int exit_flag=0;
//Instead we Blit the first n Bitmaps, instead of a masked blit...

VB_DSPCACHE tDSPCACHE; //Array of Display Cache info...

BITMAP *world_bmp;
BITMAP *world_bmp2;
BITMAP *dsp_bmp;

//Offset into Chr ram for the given chr#
WORD ChrOff[4] = {0x00006000,0x0000E000,0x00016000,0x0001E000};

////////////////////////////////////////////////////////////////////
// Keybd Fn's     had to put it somewhere!

unsigned int xbox_read_port( int which );

//Read the Controller, Fix Me....
HWORD V810_RControll() {
	int t1 = 0;
/*
	if(key[KEY_0])    tVBOpt.FRMSKIP=0;    //Handle Frame Skip
	if(key[KEY_1])    tVBOpt.FRMSKIP=1;
	if(key[KEY_2])    tVBOpt.FRMSKIP=2;
	if(key[KEY_3])    tVBOpt.FRMSKIP=3;
	if(key[KEY_4])    tVBOpt.FRMSKIP=4;
	if(key[KEY_5])    tVBOpt.FRMSKIP=5;
	if(key[KEY_6])    tVBOpt.FRMSKIP=6;
	if(key[KEY_7])    tVBOpt.FRMSKIP=7;
	if(key[KEY_8])    tVBOpt.FRMSKIP=8;
	if(key[KEY_9])    tVBOpt.FRMSKIP=9;

	if(key[KEY_OPENBRACE])    tVBOpt.DSPSWAP=0; //Flip 3D display
	if(key[KEY_CLOSEBRACE])   tVBOpt.DSPSWAP=1;
*/
#if 0
	if (key[vbkey[14]])		t1=t1|0x0001;	// Batery Low
	if (key[vbkey[13]])		t1=t1|0x0010;	// L Trigger
	if (key[vbkey[12]])		t1=t1|0x0020;	// R Trigger
	if (key[vbkey[11]])		t1=t1|0x2000;	// Select Button
	if (key[vbkey[10]])		t1=t1|0x1000;	// Start Button
	if (key[vbkey[9]])		t1=t1|0x0008;	// B Button
	if (key[vbkey[8]])		t1=t1|0x0004;	// A Button
	if (key[vbkey[7]])		t1=t1|0x0080;	// Right Pad, Right
	else if (key[vbkey[6]])	t1=t1|0x4000;	// Right Pad, Left
	if (key[vbkey[5]])		t1=t1|0x8000;	// Right Pad, Down
	else if (key[vbkey[4]])	t1=t1|0x0040;	// Right Pad, Up
	if (key[vbkey[3]])		t1=t1|0x0100;	// Left Pad, Right
	else if (key[vbkey[2]])	t1=t1|0x0200;	// Left Pad, Left
	if (key[vbkey[1]])		t1=t1|0x0400;	// Left Pad, Down
	else if (key[vbkey[0]])	t1=t1|0x0800;	// Left Pad, Up
#endif

	t1 = xbox_read_port( 0 ) ;

	t1=t1|0x0002;							// Always set bit1, ctrl ID

	return t1;
}

////////////////////////////////////////////////////////////////////
//Blit a bgmap to the screen buffer, wraping around if we take an immage
// past the edge of the source bmp.. Also handle sources in the negative...
// dt_blit(&tDSPCACHE.BGCacheBMP[bgm], wPlane, WORLD_Buff[wNum].MX+MPX, WORLD_Buff[wNum].MY, 7+WORLD_Buff[wNum].GX+GPX, 7+WORLD_Buff[wNum].GY, WORLD_Buff[wNum].W, WORLD_Buff[wNum].H,WORLD_Buff[wNum].SCX,WORLD_Buff[wNum].SCY);

//TODO: Remove additional overhead by passing a pointer to the WORLD_Buff struct, rather than all of it's contents!
VB_INLINE void dt_blit(BITMAP *source[], BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height, int source_width, int source_height) {
    int SX;
    int SY;
    int tWidth;
    int tHeight;
    int startOff;
    int neg_x=0, neg_y=0;
    BITMAP *src_array[4];

    //Handle rotations over the end of the screen, wrap to the begining. //mod by this...
    SX = (1<<source_width)<<9;
    SY = (1<<source_height)<<9;

	if (source_x < 0) source_x = (((unsigned int)source_x & (SX-1)) | ~(SX-1));
	else source_x &= (SX-1);
    if (source_y < 0) source_y = (((unsigned int)source_y & (SY-1)) | ~(SY-1));
    else source_y &= (SY-1);


	if ((dest_x > 512) || (dest_x < -512)) dest_x &= 0x01FF;
	if ((dest_y > 512) || (dest_y < -512)) dest_y &= 0x01FF;
/*
	//old ... incorrect?
	if (dest_x>512)
	    dest_x=dest_x&511;
	if (dest_y>512)
    	dest_y=dest_y&511;
*/

	//Funky code to support negative sources!
    if (source_x < 0) {
		dest_x += (neg_x = -source_x);
		source_x = 0;
		tWidth = SX;
	}
	else tWidth = (SX-source_x);

	if (source_y < 0) {
		dest_y += (neg_y = -source_y);
		source_y = 0;
		tHeight = SY;
	}
	else tHeight = (SY-source_y);

	if (tWidth > width) tWidth = width;
	if (tHeight > height) tHeight = height;

    startOff = (source_x>>9)+((source_y>>9)<<source_width);
    src_array[0] = source[startOff];
    src_array[1] = source[startOff];//Next right or wrap to first
    src_array[2] = source[startOff];//Next down or wrap to top
    src_array[3] = source[startOff];//next right and down, or wrap to top


    masked_blit(src_array[0], dest, source_x&511, source_y&511, dest_x, dest_y, tWidth, tHeight);

//TODO: Add support for overplane
// [character(s) drawn outside of BGMap if overplane is enabled, else wrap BGMap around world]
	if (neg_x)
		masked_blit(src_array[1], dest, 512-neg_x, 0, dest_x-neg_x, dest_y, neg_x, tHeight);
	if (neg_y)
		masked_blit(src_array[2], dest, 0, 512-neg_y, dest_x, 7, tWidth, neg_y);
    if ((neg_x) && (neg_y))
		masked_blit(src_array[3], dest, 512-neg_x, 512-neg_y, dest_x-neg_x, 7, neg_x, neg_y);

    if((source_x+width) > SX)
      masked_blit(src_array[1], dest, 0, source_y&511, dest_x+tWidth, dest_y, (width - tWidth), tHeight);
    if((source_y+height) > SY)
      masked_blit(src_array[2], dest, source_x&511, 0, dest_x, (dest_y+tHeight), tWidth, (height - tHeight));
    if(((source_x+width) > SX) && ((source_y+height) > SY))
      masked_blit(src_array[3], dest, 0, 0, dest_x+tWidth, (dest_y+tHeight), (width - tWidth), (height - tHeight));

}


//similar to dt_blit, but edited for scaling (and soon rotation)
//works on one scanline at a time  (requires negative source patches -- see dt_blit())
//affine_blit(&tDSPCACHE.BGCacheBMP[bgm], wPlane, XSrc/*+Prlx*/, YSrc, 7+WORLD_Buff[wNum].GX+GPX+Prlx, 7+WORLD_Buff[wNum].GY+t, WORLD_Buff[wNum].W, WORLD_Buff[wNum].SCX, WORLD_Buff[wNum].SCY, XScl, YSkw);
//new function -- includes SOME rotation support.
VB_INLINE void affine_blit(BITMAP *source[], BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int source_width, int source_height, float scale, int skew) {
	int SX,SY;
	int tWidth,sWidth;
	int startOff;
	int sign=1,width_x;
	int i;
	//BITMAP *src_array[4];

	//Handle rotations over the end of the screen, wrap to the begining. //mod by this...
	SX = (1<<source_width)<<9;
	SY = (1<<source_height)<<9;

	source_x &= (SX-1);
	source_y &= (SY-1);

	//AHHHH! That -512 thing was giving me a headache! Wish I had my flash programmer right about now! :)  - Parasyte
	if ((dest_x > 512) || (dest_x < -512)) dest_x &= 0x01FF;
	if ((dest_y > 512) || (dest_y < -512)) dest_y &= 0x01FF;


	if ((width_x=(dest_x+width)) > 383) width_x=383;

	if (skew) { //this is for rotation
		if (skew >> 15) {
			skew = -skew; //negate skew if negative
			sign = -1;
		}
		if (skew <= 512) {
			sWidth = (512/skew);
			tWidth = (int)(sWidth/scale);
			//all this should be replaced with a nice, fast function to grab the correct
			//pixels, and send them to the dest bitmap!! (Allegro's stretch functions do
			//not support negative widths!! >_<
			for (i = 0; i < skew; i++) {
				source_x &= 0x01FF;
				source_y &= 0x01FF;
				startOff = (source_x>>9)+((source_y>>9)<<source_width);
				masked_stretch_blit(source[startOff], dest, source_x, source_y, tWidth, 1, dest_x, dest_y, sWidth, 1);
				source_x += sWidth;
				source_y += sign;
				dest_x += sWidth;
				if (dest_x >= width_x) break;
			}
		}
		else {
			startOff = (source_x>>9)+((source_y>>9)<<source_width);
			masked_blit(source[startOff], dest, source_x, source_y, dest_x, dest_y, width, 1);
		}
	}
	else {
		//tWidth =  SX-source_x; //(width-((source_x+width)-SX));
		//tHeight = SY-source_y; //(height-((source_y+height)-SY));
		tWidth = (int)(width/scale);

		//if(tWidth > width) tWidth = width;
		//if(tHeight > height) tHeight = height;

		startOff = (source_x>>9)+((source_y>>9)<<source_width);
		//src_array[0] = source[startOff];
		//src_array[1] = source[startOff];//Next right or wrap to first
		//src_array[2] = source[startOff];//Next down or wrap to top
		//src_array[3] = source[startOff];//next right and down, or wrap to top

		//masked_stretch_blit(source[startOff], dest, source_x, source_y, tWidth, 1, dest_x, dest_y, width, 1);
		masked_stretch_blit(source[startOff], dest, (source_x & 0x01FF), (source_y & 0x01FF), tWidth, 1, dest_x, dest_y, width, 1);
/*
		if((source_x+width) > SX)
			masked_stretch_blit(src_array[1], dest, 0, source_y&511, width, 1, dest_x+tWidth, dest_y, (width - tWidth), tHeight);
		if((source_y+height) > SY)
			masked_stretch_blit(src_array[2], dest, source_x&511, 0, width, 1, dest_x, (dest_y+tHeight), tWidth, (height - tHeight));
		if(((source_x+width) > SX) && ((source_y+height) > SY))
			masked_stretch_blit(src_array[3], dest, 0, 0, width, 1, dest_x+tWidth, (dest_y+tHeight), (width - tWidth), (height - tHeight));
*/
	}
}

/*
//similar to dt_blit, but edited for scaling (and soon rotation)
//works on one scanline at a time
//old function!
VB_INLINE void affine_blit(BITMAP *source[], BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int source_width, int source_height, float scale) {
    int SX;
    int SY;
    int tWidth;
    int tHeight=1;
    int startOff;
    int height=1;
    BITMAP *src_array[4];

    //Handle rotations over the end of the screen, wrap to the begining. //mod by this...
    SX = (1<<source_width)<<9;
    SY = (1<<source_height)<<9;

    source_x &= (SX-1);
    source_y &= (SY-1);

	if (dest_x>512)
	    dest_x=dest_x&511;
	if (dest_y>512)
    	dest_y=dest_y&511;

    //tWidth =  SX-source_x; //(width-((source_x+width)-SX));
    //tHeight = SY-source_y; //(height-((source_y+height)-SY));
    tWidth = (int)(width/scale);

    //if(tWidth > width) tWidth = width;
    //if(tHeight > height) tHeight = height;


    startOff = (source_x>>9)+((source_y>>9)<<source_width);
    src_array[0] = source[startOff];
    src_array[1] = source[startOff];//Next right or wrap to first
    src_array[2] = source[startOff];//Next down or wrap to top
    src_array[3] = source[startOff];//next right and down, or wrap to top

    masked_stretch_blit(src_array[0], dest, source_x&511, source_y&511, tWidth, 1, dest_x, dest_y, width, 1);
/*    if((source_x+width) > SX)
      masked_stretch_blit(src_array[1], dest, 0, source_y&511, width, 1, dest_x+tWidth, dest_y, (width - tWidth), tHeight);
    if((source_y+height) > SY)
      masked_stretch_blit(src_array[2], dest, source_x&511, 0, width, 1, dest_x, (dest_y+tHeight), tWidth, (height - tHeight));
    if(((source_x+width) > SX) && ((source_y+height) > SY))
      masked_stretch_blit(src_array[3], dest, 0, 0, width, 1, dest_x+tWidth, (dest_y+tHeight), (width - tWidth), (height - tHeight));
* /
}
*/

////////////////////////////////////////////////////////////////////
// Retreaves a character(Sprite) from the character table, Only used for DisplayRom()
// Now directly acesses the video ram (Scary)
void getChr(HWORD num, HWORD chr[]) {
    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    WORD offset =ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF));
    if((offset < V810_DISPLAY_RAM.lowaddr)||(offset+CHR_SIZE > V810_DISPLAY_RAM.highaddr))
    offset = ChrOff[0]; //Set to a known value (Chr0)
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    ((WORD *)chr)[0] = ((WORD *)(offset))[0];
    ((WORD *)chr)[1] = ((WORD *)(offset))[1];
    ((WORD *)chr)[2] = ((WORD *)(offset))[2];
    ((WORD *)chr)[3] = ((WORD *)(offset))[3];
}

// Translates a chr to a sprite, Only used for DisplayRom()
void chr2sprite(HWORD chr[],BITMAP *sprt) {
    int i;
    for(i = 0; i < 8; i++) {// we want words not bytes
        sprt->line[i][0] = ((chr[i] >>  0) & 3)+1;
        sprt->line[i][1] = ((chr[i] >>  2) & 3)+1;
        sprt->line[i][2] = ((chr[i] >>  4) & 3)+1;
        sprt->line[i][3] = ((chr[i] >>  6) & 3)+1;
        sprt->line[i][4] = ((chr[i] >>  8) & 3)+1;
        sprt->line[i][5] = ((chr[i] >> 10) & 3)+1;
        sprt->line[i][6] = ((chr[i] >> 12) & 3)+1;
        sprt->line[i][7] = ((chr[i] >> 14) & 3)+1;
    }
}

//Replaces the two Fn's Above (Faster?)
void fchr2sprite(HWORD num,BITMAP *sprt, bool hflp, bool vflp,BYTE pal[]) {
    int i;

    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) + V810_DISPLAY_RAM.off;

    if (!hflp && !vflp){
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][0] = pal[((((HWORD *)(offset))[i] >>  0) & 3)]; //replace "<<4) & 0x3f);" with cPal[#]
            sprt->line[i][1] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][2] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][3] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][4] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][5] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][6] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][7] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if (hflp && vflp){
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][7] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][6] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][5] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][4] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][3] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][2] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][1] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][0] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(hflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][7] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[i][6] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][5] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][4] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][3] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][2] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][1] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][0] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(vflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][0] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][1] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][2] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][3] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][4] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][5] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][6] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][7] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////
// vRenderCharacter
//
// Jason -
// Renders a given character number into the byte buffer provided at
// The starting X and Y locations.  Note that p_wBitmapWidth is the width of the
// buffer into which we are rendering.
// Non allegro version of fchr2sprite for sub bitmaps
// Review-- Why do we need the Palette Pointer?
//
VB_INLINE void vRenderCharacter(HWORD p_hwCharacterNumber,// The number of the character to display
				 BYTE *p_pbSpriteData, // The raw byte buffer to render the sprite into.
				 WORD p_wStartingX,// Starting X offset within the byte buffer
				 WORD p_wStartingY,// Starting Y offset in the byte buffer
				 WORD p_wBitmapWidth, // How wide the bitmap we're rendering on is.
				 bool p_fFlipHorizontally,
				 bool p_fFlipVertically,
				 BYTE p_rgbPalette[])
{// vRenderCharacter
    int l_nRowCounter;

    WORD l_wDataOffset = ChrOff[(p_hwCharacterNumber>>9)&0x03] + (CHR_SIZE * (p_hwCharacterNumber & 0x01FF)) + V810_DISPLAY_RAM.off;
	//WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) + V810_DISPLAY_RAM.off;
	HWORD * l_phwLineData = ((HWORD *)(l_wDataOffset));
	HWORD l_hwCurrentData; // We use this to store the current data.

	p_pbSpriteData += ((p_wStartingX) + (p_wStartingY*p_wBitmapWidth));

	l_nRowCounter = 0;
    if (!p_fFlipHorizontally && !p_fFlipVertically)
		{// Normal Character
        for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++)
			{// For Each Line
			l_hwCurrentData = *l_phwLineData;
			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
			l_phwLineData++;
			}// End for Each Line
		}// End Normal Character
	else
	if (p_fFlipHorizontally && p_fFlipVertically)
		{// Flip both
		l_phwLineData+=7;
        for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++)
			{// For Each Line
			l_hwCurrentData = *l_phwLineData;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  14) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  12) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  10) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  8) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  6) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  4) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  2) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  0) & 3)];
			p_pbSpriteData++;
			p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
			l_phwLineData--;
			}// End For Each Line

		}// End Flip both
	else
	if(p_fFlipHorizontally)
		{// Flip Horizontal
        for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++)
			{// For Each Line
			l_hwCurrentData = *l_phwLineData;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  14) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  12) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  10) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  8) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  6) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  4) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  2) & 3)];
			p_pbSpriteData++;
			*p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  0) & 3)];
			p_pbSpriteData++;
			p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
			l_phwLineData++;
			}// End For Each Line
		}// End Flip Horizontal
	else
	if(p_fFlipVertically)
		{// Vertically flipped
		l_phwLineData+=7;
        for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++)
			{// For Each Line
			l_hwCurrentData = *l_phwLineData;
			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			l_hwCurrentData>>=2;

			*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
			p_pbSpriteData++;
			p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
			l_phwLineData--;
			}// End for Each Line
		}// End vertical flip
}// end vRenderCharacter

////////////////////////////////////////////////////////////////////////////////////////
// vRenderCharacterTransparent
//
// Jason -
// Renders a given character number into the byte buffer provided at
// The starting X and Y locations.  Note that p_wBitmapWidth is the width of the
// buffer into which we are rendering.
// Non allegro version of fchr2sprite for sub bitmaps
// This version supports transparencies.  This is a major slowdown, so
// we'll keep two versions.
// Still Review-- Why do we need the Palette Pointer?
//
VB_INLINE void vRenderCharacterTransparent(HWORD p_hwCharacterNumber,// The number of the character to display
				 BYTE *p_pbSpriteData, // The raw byte buffer to render the sprite into.
				 WORD p_wStartingX,// Starting X offset within the byte buffer
				 WORD p_wStartingY,// Starting Y offset in the byte buffer
				 WORD p_wBitmapWidth, // How wide the bitmap we're rendering on is.
				 bool p_fFlipHorizontally,
				 bool p_fFlipVertically,
				 BYTE p_rgbPalette[])
{// vRenderCharacterTransparent
    int l_nRowCounter;

    WORD l_wDataOffset = ChrOff[(p_hwCharacterNumber>>9)&0x03] + (CHR_SIZE * (p_hwCharacterNumber & 0x01FF)) + V810_DISPLAY_RAM.off;
        //WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) + V810_DISPLAY_RAM.off;
        HWORD * l_phwLineData = ((HWORD *)(l_wDataOffset));
        HWORD l_hwCurrentData; // We use this to store the current data.

        p_pbSpriteData += ((p_wStartingX) + (p_wStartingY*p_wBitmapWidth));

        l_nRowCounter = 0;

        if (!p_fFlipHorizontally && !p_fFlipVertically) {// Normal Character
            for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++) {// For Each Line
                l_hwCurrentData = *l_phwLineData;
                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData &3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
                l_phwLineData++;
            }// End for Each Line
        } else  if (p_fFlipHorizontally && p_fFlipVertically) {// Flip both
            l_phwLineData+=7;
            for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++) {// For Each Line
                l_hwCurrentData = *l_phwLineData;
                if (p_rgbPalette[((l_hwCurrentData >>  14) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  14) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>  12) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  12) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>  10) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  10) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   8) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  8) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   6) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  6) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   4) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  4) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   2) & 3)])  *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  2) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   0) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  0) & 3)];
                p_pbSpriteData++;
                p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
                l_phwLineData--;
            }// End For Each Line
        } else if(p_fFlipHorizontally) {// Flip Horizontal
            for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++) {// For Each Line
                l_hwCurrentData = *l_phwLineData;
                if (p_rgbPalette[((l_hwCurrentData >>  14) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  14) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>  12) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  12) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>  10) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  10) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   8) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  8) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   6) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  6) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   4) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  4) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>  2) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  2) & 3)];
                p_pbSpriteData++;

                if (p_rgbPalette[((l_hwCurrentData >>   0) & 3)]) *p_pbSpriteData= p_rgbPalette[((l_hwCurrentData >>  0) & 3)];
                p_pbSpriteData++;
                p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
                l_phwLineData++;
            }// End For Each Line
        } else if(p_fFlipVertically) {// Vertically flipped
            l_phwLineData+=7;
            for(l_nRowCounter = 0; l_nRowCounter < 8; l_nRowCounter++) {// For Each Line
                l_hwCurrentData = *l_phwLineData;
                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                l_hwCurrentData>>=2;

                if (p_rgbPalette[(l_hwCurrentData & 3)]) *p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
                p_pbSpriteData++;
                p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.
                l_phwLineData--;
            }// End for Each Line
        }// End vertical flip
}// end vRenderCharacterTransparent

////////////////////////////////////////////////////////////////////
// returns a BGMap Buffer VB_BGMAP BGMap_Buff[4096]
// Now directly acesses the video ram (Scary)
VB_INLINE void getBGmap(HWORD num, VB_BGMAP BGMap_Buff[]) {
    int i;
    HWORD thword;

    WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF));// only 14 posible bg's, this is 16 but whos counting?
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    for(i=0; i< (BGMAP_SIZE>>1); i++) {
        // Make shure we only grab num's from 0-4095...
        thword = ((HWORD *)(offset))[i];
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
    }
}

// Converts a BG Map Buffer to a World Picture, With Chrs in place.
VB_INLINE void BGMap2World(HWORD num, BITMAP *wPlane) {
    int i;
    VB_BGMAP BGMap_Buff[4096];
    HWORD thword;
    WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF))+V810_DISPLAY_RAM.off;// only 14 posible bg's, this is 16 but whos counting?

    //Grab the BGMap info...
    for(i=0; i< (BGMAP_SIZE>>1); i++) {
        // Make shure we only grab num's from 0-4095...
        thword = ((HWORD *)(offset))[i];
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
    }


    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.BgmPALMod>0) { //If cache is invalid
            for(i=0; i<4; i++) {
                tDSPCACHE.BgmPAL[i][0]=((tVIPREG.GPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.BgmPAL[i][1]=((tVIPREG.GPLT[i]>>2)&3)+1;
                tDSPCACHE.BgmPAL[i][2]=((tVIPREG.GPLT[i]>>4)&3)+1;
                tDSPCACHE.BgmPAL[i][3]=((tVIPREG.GPLT[i]>>6)&3)+1;
                tDSPCACHE.BgmPAL[i][0]=0; //Fill in the transparent char
            }
            tDSPCACHE.BgmPALMod=0;
        }
    } else { //If in debug land (make this better!)
        for(i=0; i<4; i++) {
            tDSPCACHE.BgmPAL[i][0]=1;
            tDSPCACHE.BgmPAL[i][1]=2;
            tDSPCACHE.BgmPAL[i][2]=3;
            tDSPCACHE.BgmPAL[i][3]=4;
        }
    }

    for(i = 0; i < (BGMAP_SIZE >> 1); i++) {// For each character in the map
        vRenderCharacter(BGMap_Buff[i].BCA, *wPlane->line, ((i&63)<<3), ((i>>6)<<3), wPlane->w, BGMap_Buff[i].HFLP, BGMap_Buff[i].VFLP, tDSPCACHE.BgmPAL[(BGMap_Buff[i].BPLTS&0x3)]);
    }// End for each character in the map

}

////////////////////////////////////////////////////////////////////
// returns a OBJ_buf Buffer VB_OBJ OBJ_Buff[0x400]
// Now directly acesses the video ram (Scary)
VB_INLINE void getObj(HWORD num, VB_OBJ OBJ_Buff[]) {
    WORD tword;
    WORD offset = OBJ_OFFSET + (OBJ_SIZE*(num & 0x03FF)); // 1024 posible obj...
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    OBJ_Buff[num].JX = (int)sign_16(((HWORD *)(offset))[0]);
    tword = ((HWORD *)(offset))[1];
    OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
    OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
    OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
    OBJ_Buff[num].JY = (int)sign_16(((HWORD *)(offset))[2]);
    tword = ((HWORD *)(offset))[3];
    OBJ_Buff[num].JCA = tword & 0x7FF;
    OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
    OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
    OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
}

////////////////////////////////////////////////////////////////////
// vGetAllObjects
// Returns all objects
//
VB_INLINE void vGetAllObjects(VB_OBJ OBJ_Buff[]) {
    WORD tword;
    int num;
    WORD offset = OBJ_OFFSET + V810_DISPLAY_RAM.off;
    for(num=0; num<0x400; num++) {
        OBJ_Buff[num].JX = (int)sign_16(((HWORD *)(offset))[0]);
        tword = ((HWORD *)(offset))[1];
        OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
        OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
        OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
        OBJ_Buff[num].JY = (int)sign_16(((HWORD *)(offset))[2]);
        tword = ((HWORD *)(offset))[3];
        OBJ_Buff[num].JCA = tword & 0x7FF;
        OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
        OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
        OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
        offset+=OBJ_SIZE;//Increment the pointer
    }
}

// Converts a OBJ_buf Buffer to a World Picture, With Chrs in place.
//Pass in int spt0-3 for the world num....
//Note modified tSprt for Blits to screen, enabling Transparency.
VB_INLINE void Obj2World(VB_OBJ OBJ_Buff[], BITMAP *wPlane, int spt_num, int img_n) {
    int i;
    int end = 0;
    BITMAP* tSprt = create_bitmap(8,8);
    if(spt_num > 0) {
        if((tVIPREG.SPT[spt_num]&0x3FF) >= (tVIPREG.SPT[spt_num-1]&0x3FF)) {
            end = (tVIPREG.SPT[spt_num-1]&0x3FF);
        }
    }

    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.ObjPALMod>0) { //If cache is invalid
            for(i=0; i<4; i++) {
                tDSPCACHE.ObjPAL[i][0]=((tVIPREG.JPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.ObjPAL[i][1]=((tVIPREG.JPLT[i]>>2)&3)+1;
                tDSPCACHE.ObjPAL[i][2]=((tVIPREG.JPLT[i]>>4)&3)+1;
                tDSPCACHE.ObjPAL[i][3]=((tVIPREG.JPLT[i]>>6)&3)+1;
                tDSPCACHE.ObjPAL[i][0]=0; //Fill in the transparent char
            }
            tDSPCACHE.ObjPALMod=0;
        }
    } else { //If in debug land (make this better!)
        for(i=0; i<4; i++) {
            tDSPCACHE.ObjPAL[i][0]=0;
            tDSPCACHE.ObjPAL[i][1]=1;
            tDSPCACHE.ObjPAL[i][2]=2;
            tDSPCACHE.ObjPAL[i][3]=3;
        }
    }

    for(i = tVIPREG.SPT[spt_num]&0x3FF; i >= end ; i--) { //No!!!
        if((img_n==0)&&(OBJ_Buff[i].JLON)) { //Default, no paralax
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7), (OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==1)&&(OBJ_Buff[i].JLON)) { //Left Image
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)-OBJ_Buff[i].JP, (OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==2)&&(OBJ_Buff[i].JRON)) { //Right Immage
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)+OBJ_Buff[i].JP, (OBJ_Buff[i].JY+7), 8, 8);
        }
//        if((img_n==0)&&(OBJ_Buff[i].JLON)) { //Default, no paralax
//            vRenderCharacterTransparent(OBJ_Buff[i].JCA, *wPlane->line, (OBJ_Buff[i].JX+7), (OBJ_Buff[i].JY+7), wPlane->w, OBJ_Buff[i].JHFLP, OBJ_Buff[i].JVFLP, tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]);
//        } else if((img_n==1)&&(OBJ_Buff[i].JLON)) { //Left Immage
//            vRenderCharacterTransparent(OBJ_Buff[i].JCA, *wPlane->line, (OBJ_Buff[i].JX+7)-OBJ_Buff[i].JP, (OBJ_Buff[i].JY+7), wPlane->w, OBJ_Buff[i].JHFLP, OBJ_Buff[i].JVFLP, tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]);
//        } else if((img_n==2)&&(OBJ_Buff[i].JRON)) { //Right Immage
//            vRenderCharacterTransparent(OBJ_Buff[i].JCA, *wPlane->line, (OBJ_Buff[i].JX+7)+OBJ_Buff[i].JP, (OBJ_Buff[i].JY+7), wPlane->w, OBJ_Buff[i].JHFLP, OBJ_Buff[i].JVFLP, tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]);
//        }
    }
    destroy_bitmap(tSprt);
}

//Display teh direct screen draws
//Pass in the mem buffer (0-3) and the world bitmap to draw on
//This clears the mem, as it should keep that in mind
//0-1 left dsp, 2-3 right dsp
VB_INLINE void DSP2World(int num, BITMAP *wPlane ) {
    HWORD chr;
    int y, x;
    int chr_x = 384+7;
    int chr_y = 256+7;
    WORD toffset = 0;
    WORD offset = (0x00008000*num); //Select Bitmap 0-3, Fix Me
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    for(x=7; x < chr_x; x++) {
        for(y=7; y < chr_y; y+=8) {
            chr = ((HWORD *)(offset))[0];
            //Display it
            if((chr >> 0)  & 3) wPlane->line[y+0][x] = ((chr >>  0) & 3)+1;
            if((chr >> 2)  & 3) wPlane->line[y+1][x] = ((chr >>  2) & 3)+1;
            if((chr >> 4)  & 3) wPlane->line[y+2][x] = ((chr >>  4) & 3)+1;
            if((chr >> 6)  & 3) wPlane->line[y+3][x] = ((chr >>  6) & 3)+1;
            if((chr >> 8)  & 3) wPlane->line[y+4][x] = ((chr >>  8) & 3)+1;
            if((chr >> 10) & 3) wPlane->line[y+5][x] = ((chr >> 10) & 3)+1;
            if((chr >> 12) & 3) wPlane->line[y+6][x] = ((chr >> 12) & 3)+1;
            if((chr >> 14) & 3) wPlane->line[y+7][x] = ((chr >> 14) & 3)+1;

#ifdef FBHACK
			if (tDSPCACHE.DDSPDataWrite) ((HWORD *)(offset))[0] = 0;
#else
            //Clear it, if needed
            //if (!(tVIPREG.XPCTRL&2)) ((HWORD *)(offset))[0] = 0;
            if (tVIPREG.XPCTRL&2) ((HWORD *)(offset))[0] = 0;
#endif //FBHACK
            offset+=2;
        }
    }
#ifdef FBHACK
    tDSPCACHE.DDSPDataWrite = 0;
#endif //FBHACK
}

////////////////////////////////////////////////////////////////////
// returns a WORLD_buf Buffer VB_WORLD WORLD_Buff[32]
// Now directly acesses the video ram (Scary)
VB_INLINE void getWorld(HWORD num, VB_WORLD WORLD_Buff[]) {
    WORD tword;

    WORD offset = WORLD_OFFSET + (WORLD_SIZE*(num & 0x01F)); // only 32 posible worlds...
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    tword = ((HWORD *)(offset))[0];
    WORLD_Buff[num].LON = ((tword >> 15) & 0x01);
    WORLD_Buff[num].RON = ((tword >> 14) & 0x01);
    WORLD_Buff[num].BGM = ((tword >> 12) & 0x03);
    WORLD_Buff[num].SCX = ((tword >> 10) & 0x03);
    WORLD_Buff[num].SCY = ((tword >>  8) & 0x03);
    WORLD_Buff[num].OVER= ((tword >>  7) & 0x01);
    WORLD_Buff[num].END = ((tword >>  6) & 0x01);
    WORLD_Buff[num].BGMAP_BASE =  (tword & 0x0F);

//Are negative values allowed in displaying objects????
//YES!
    WORLD_Buff[num].GX = (int)sign_16(((HWORD *)(offset))[1]);
    WORLD_Buff[num].GP = (int)sign_16(((HWORD *)(offset))[2]);
    WORLD_Buff[num].GY = (int)sign_16(((HWORD *)(offset))[3]);

    WORLD_Buff[num].MX = (int)sign_16(((HWORD *)(offset))[4]);
    WORLD_Buff[num].MP = (int)sign_16(((HWORD *)(offset))[5]);
    WORLD_Buff[num].MY = (int)sign_16(((HWORD *)(offset))[6]);

    ////WORLD_Buff[num].MX = (((HWORD *)(offset))[4])&0x0FFF;
    ////WORLD_Buff[num].MP = (int)sign_12(((HWORD *)(offset))[5]);
    ////WORLD_Buff[num].MY = (((HWORD *)(offset))[6])&0x0FFF;

    //WORLD_Buff[num].W = ((((HWORD *)(offset))[7])&(((1<<WORLD_Buff[num].SCX)*511)-1))+2; //Limit the max...
    //WORLD_Buff[num].H = ((((HWORD *)(offset))[8])&(((1<<WORLD_Buff[num].SCY)*511)-1))+2;
    WORLD_Buff[num].PARAM_BASE = (((HWORD *)(offset))[9]);
    WORLD_Buff[num].OVERP_CHR = ((HWORD *)(offset))[10];

    WORLD_Buff[num].W = (((HWORD *)(offset))[7]+1);
    WORLD_Buff[num].H = (((HWORD *)(offset))[8]+1);
}

////////////////////////////////////////////////////////////////////
// Render a Display Screen on a Screen Bitmap, pass in an array
//  of type World Obj.
//bool World2Display(VB_WORLD WORLD_Buff[], BITMAP *sPlane, int DispLR) {
VB_INLINE void World2Display(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, int img_n) {
    int p, t;
    int bgm;
    int curscr;
    int ty, tx, ny, nx;
    WORD offset;
    int GPX = 0;//Global Paralax setings...
    int MPX = 0;
    int XSrc,Prlx,YSrc,YSkw;  	//for affine
    float XScl;			//for affine

    //Kill it if were trying to display the wrong screen type...
    if(((!img_n)||(img_n==1))&&(!WORLD_Buff[wNum].LON)) return;
    if((img_n==2)&&(!WORLD_Buff[wNum].RON)) return;

    if(img_n==1) {
        GPX = -WORLD_Buff[wNum].GP;//Global Paralax setings...
        MPX = -WORLD_Buff[wNum].MP;
    }else if(img_n==2) {
        GPX = WORLD_Buff[wNum].GP;//Global Paralax setings...
        MPX = WORLD_Buff[wNum].MP;
    }

    if(WORLD_Buff[wNum].BGM==3) {  //Obj
        if(tDSPCACHE.ObjDataCacheInvalid==1) { //Cash the Obj Info...
            vGetAllObjects(tDSPCACHE.ObjDataCache);
            tDSPCACHE.ObjDataCacheInvalid=0;
        }
        //Dont mess around with sub bitmaps, just blast it to the world plane
        Obj2World(tDSPCACHE.ObjDataCache, wPlane,CurObj,img_n);
        CurObj = (CurObj-1)&3; //(CurObj-1)%4;
    } else {
        //Grab the BGMaps, we can have several so grab them all...
        bgm = WORLD_Buff[wNum].BGMAP_BASE;
        nx = (1<<WORLD_Buff[wNum].SCX);
        ny = (1<<WORLD_Buff[wNum].SCY);
        for(ty = 0; ty<ny; ty++) { // 1,2,4,8 bgmaps in the y dir
            for(tx = 0; tx<nx; tx++) { //1,2,4,8 bgmaps in the x dir
                curscr = tx+(ty*nx);
                if(tDSPCACHE.BGCacheInvalid[bgm+curscr]==1) {
                    BGMap2World(bgm+curscr, tDSPCACHE.BGCacheBMP[bgm+curscr]);
                    tDSPCACHE.BGCacheInvalid[bgm+curscr]=0;
                }
            }
        }

   if(WORLD_Buff[wNum].BGM==2) {  //Affine BGMap (Incomplete!)
	   //dt_blit(&tDSPCACHE.BGCacheBMP[bgm], wPlane, WORLD_Buff[wNum].MX+MPX, WORLD_Buff[wNum].MY, 7+WORLD_Buff[wNum].GX+GPX, 7+WORLD_Buff[wNum].GY, WORLD_Buff[wNum].W, WORLD_Buff[wNum].H,WORLD_Buff[wNum].SCX,WORLD_Buff[wNum].SCY);
	   offset = ((WORLD_Buff[wNum].PARAM_BASE*2)+BGMAP_OFFSET )&0xFFFFFFFE; //BGMAP_OFFSET
	   for(t=0;t<WORLD_Buff[wNum].H;t++) { //Factor in the Shift Index....
		   if ((XScl = (int)sign_16((((HWORD *)(offset + 6 + V810_DISPLAY_RAM.off))[0])&0xFFFF)) != 0) {
			   XSrc = (int)(sign_16((((HWORD *)(offset + V810_DISPLAY_RAM.off))[0])&0xFFFF)>>3);
			   Prlx = (int)sign_16((((HWORD *)(offset + 2 + V810_DISPLAY_RAM.off))[0])&0xFFFF);
			   YSrc = (int)(sign_16((((HWORD *)(offset + 4 + V810_DISPLAY_RAM.off))[0])&0xFFFF)>>3);
			   YSkw = (int)sign_16((((HWORD *)(offset + 8 + V810_DISPLAY_RAM.off))[0])&0xFFFF);
			   XScl = (512.0 / XScl);

			   // FIXME! parallax is not 100%

			   //XSrc = (int)(XSrc / XScl);
			   //YSrc = (int)(YSrc / XScl);
			   //Prlx = (int)(Prlx / XScl); //almost works

			   if (img_n == 2) Prlx = -Prlx; //fix parallax for right screen

			   affine_blit(&tDSPCACHE.BGCacheBMP[bgm], wPlane, XSrc/*+Prlx*/, YSrc, 7+WORLD_Buff[wNum].GX+GPX+Prlx, 7+WORLD_Buff[wNum].GY+t, WORLD_Buff[wNum].W, WORLD_Buff[wNum].SCX, WORLD_Buff[wNum].SCY, XScl, YSkw);
			   offset += 16;
		   }
	   }


        } else if(WORLD_Buff[wNum].BGM==1) {  //H-Biased BGMap
            offset = (WORLD_Buff[wNum].PARAM_BASE*2)+BGMAP_OFFSET + V810_DISPLAY_RAM.off;
            if(img_n==2) offset += 2; // Shift by 2 if right screen (Read the right offset table, instead of left)

            for(t=0;t<WORLD_Buff[wNum].H;t ++) { //Factor in the Shift Index....
                masked_blit(tDSPCACHE.BGCacheBMP[bgm], wPlane, WORLD_Buff[wNum].MX+MPX+(((short *)(offset))[(t<<1)]), WORLD_Buff[wNum].MY+t, 7+WORLD_Buff[wNum].GX+GPX, 7+WORLD_Buff[wNum].GY+t, WORLD_Buff[wNum].W, 1);
            }
        } else {  //Normal BGMap
            dt_blit(&tDSPCACHE.BGCacheBMP[bgm], wPlane, WORLD_Buff[wNum].MX+MPX, WORLD_Buff[wNum].MY, 7+WORLD_Buff[wNum].GX+GPX, 7+WORLD_Buff[wNum].GY, WORLD_Buff[wNum].W, WORLD_Buff[wNum].H,WORLD_Buff[wNum].SCX,WORLD_Buff[wNum].SCY);
        }
    }
}

void click_close(void)
{
	exit_flag = 1;
	want_kill = 1;
	//if(guiop&GUISTATUS)
		//broadcast_dialog_message(, 0);
}

////////////////////////////////////////////////////////////////////
//Initialize the display, and get the video mode (from wherever)
bool V810_DSP_Init() {
    int i;
    int aDspM;
    //RGB temp;
    int done = 0;
    char bob;

    //Alegro Code
    //allegro_init();
    //install_keyboard();
    //clear_keybuf();
    //install_mouse();
    //install_timer();
    //set_window_title(w_title);
    //set_window_close_hook(click_close);


    if(tVBOpt.DEBUG==0) { //If not Debug
        //if(set_gfx_mode(tVBOpt.SCR_MODE, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
            //printf("Screen failed to initialize, exiting\n");
            //V810_DSP_Quit();
            //return(false);
        //}
    }else { //Debug
        if(!V810_DSPD_Init()) return false;
    }


    for(i=0;i<14;i++) {
        tDSPCACHE.BGCacheBMP[i] = create_bitmap(512,512); //Create our temp Bitmap...
    }
    world_bmp = create_bitmap(512+8,512+8); //Make them a bit bigger for the Obj's
    world_bmp2 = create_bitmap(512+8,512+8);
    dsp_bmp = create_bitmap(384*2,224*2);
    for(i=0;i<4;i++) {
        tDSPCACHE.ObjCacheBMP[i] = create_bitmap(512,512); //Create our temp Bitmap...
    }

    clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1);                    // zero the memory bitmap
    clear_to_color(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                   // zero the memory bitmap
    clear_to_color(dsp_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap

    //End Alegro Code

    return true;
}

VB_INLINE void V810_SetPal(int BRTA, int BRTB, int BRTC) {
    int i,j;
    //int tPal[] = {0, 0, 21, 42, 63};
    int tPal[] = {0, 0, 10, 20, 31};

    if (!tVBOpt.FIXPAL) {
		tPal[2] = BRTA;
		tPal[3] = BRTB;
		tPal[4] = BRTC;
		//if (tPal[4] > 63) tPal[4]=63;
		//if (tPal[3] > 63) tPal[3]=63;
		//if (tPal[2] > 63) tPal[2]=63;
		if (tPal[4] > 31) tPal[4]=31;
		if (tPal[3] > 31) tPal[3]=31;
		if (tPal[2] > 31) tPal[2]=31;
    }

    //Normal Pallet
    if (tVBOpt.DSPMODE == dm_RedBlue) {//Red/Blue Pallet...
        for(i=0;i<4;i++) {
            for(j=0;j<4;j++) {
                pallete[i+(j*4)+8].r = tPal[i+1];//tpal goes from 0-4, with 0 and 1 being black (What a Cluge)
                if(tVBOpt.PALMODE == pal_RB) { //Red_Blue Pallet
                    pallete[i+(j*4)+8].g = 0; //tPal[j+1];
                    pallete[i+(j*4)+8].b = tPal[j+1];
                } else if(tVBOpt.PALMODE == pal_RG) { //Red_Green Pallet
                    pallete[i+(j*4)+8].g = tPal[j+1];
                    pallete[i+(j*4)+8].b = 0; //tPal[j+1];
                } else if(tVBOpt.PALMODE == pal_RBG) { //Red_BlueGreen Pallet
                    pallete[i+(j*4)+8].g = tPal[j+1];
                    pallete[i+(j*4)+8].b = tPal[j+1];
                }
            }
        }
    } else { // standard palette
        if(tVBOpt.PALMODE == pal_RED) { //Red Pallet
            for(i=0;i<5;i++) {
                pallete[i].r = tPal[i];
                pallete[i].g = 0;
                pallete[i].b = 0;
            }
        } else { //Standard Pallet
            for(i=0;i<5;i++) {
                pallete[i].r = tPal[i];
                pallete[i].g = tPal[i];
                pallete[i].b = tPal[i];
            }
        }
    }// end Standard palette

    //standard text color
    //pallete[252].r = 63;
    //pallete[252].g = 63;
    //pallete[252].b = 63;
    pallete[252].r = 31;
    pallete[252].g = 31;
    pallete[252].b = 31;

	for ( i = 0 ; i < 256 ; i++ )
	{
		vbpalette[i] = ( pallete[i].r << 11 ) | ( pallete[i].g << 6 ) | pallete[i].b ;

	}

    //set_pallete(pallete);
}


void V810_DSP_Quit() {
    int i=0;

    for(i=0;i<14;i++) {
        destroy_bitmap(tDSPCACHE.BGCacheBMP[i]);
    }
    destroy_bitmap(world_bmp);
    destroy_bitmap(world_bmp2);
    destroy_bitmap(dsp_bmp);
    for(i=0;i<4;i++) {
        destroy_bitmap(tDSPCACHE.ObjCacheBMP[i]);
    }

//    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    //clear_keybuf();
    //remove_keyboard();
    //allegro_exit();
}

//Collect all the display init code together...
void V810_DSP() {
	//if(!V810_DSP_Init()) return;
	if(!tVBOpt.DEBUG) {
		//V810_dsp_pal();
		V810_Dsp_Go();
	}
	else {
		V810_Dsp_Debug();
	}
}
/*
void V810_dsp_pal(void)
{
	int i;

	Clear our pallet, to a default collor...
	for(i=0;i<256;i++) {
		pallete[i].r = 0;
		pallete[i].g = 0;
		pallete[i].b = 0;
	}

    //Add the display Color (Text Color)
	pallete[255].r = 63;
	pallete[255].g = 63;
	pallete[255].b = 63;

    // fill our pallete with a gradually altering sequence of colors
	V810_SetPal(21,42,63);
}
*/
int xbox_check_events() ;
unsigned long xbox_gettime2();
void xSleep( unsigned int dw ) ;


unsigned int startticks ;
unsigned int vbframes ;
extern int doaudio  ;

//Run the CPU and display (Start the real emu...
void V810_Dsp_Go() {
    int qwe, i, err=0;
    static int Left = 0;
    int skip = 0;

    exit_flag=0;

    clearCache();

	startticks = xbox_gettime2() ;
	vbframes = 0 ;
	doaudio = 1 ;

	while (1) {
		if (!err) {
			for (qwe=0;qwe<=tVBOpt.FRMSKIP;qwe++) {
				//Trace
				if ( xbox_check_events() )
					exit_flag = 1 ;

				err = v810_trc(0,0);
				vbframes++ ;
				//if (tVBOpt.SOUND) vb_snd_main();

				// Display a frame, only after the right number of 'skips'
				if((tVIPREG.FRMCYC & 0x00FF) < skip) {
					skip = 0;
					Left ^= 1;
				}

				// Increment skip
				skip+=1;
			}

			// Display
			if (tVIPREG.DPCTRL & 0x0002) {
				V810_Dsp_Frame(Left); //Temporary...
			}
			//else clear_to_color(screen,0);

			// Error display
			//if (err) {
				////textout_centre(screen,font, errmsg, tVBOpt.SCR_X/2, tVBOpt.SCR_Y-text_height(font)-10, 252);
				//if (tVBOpt.SOUND) vb_play_silence();
			//}
			//else if (tVBOpt.SOUND) vb_snd_main();

			// Apply RAM cheats (if any)
			//cheat_patch_ram();
		}

		//if (key[KEY_ESC]) {
			//while (key[KEY_ESC]); //Silly hack, so you can hold the esc key down...
			//exit_flag=1;
			//clear_keybuf(); // Make sure were not killing the returning prog!
		//}
		if (exit_flag) {
			if (tVBOpt.SOUND)  //Stuck sound samples never sound good
				vb_play_silence();
			clearCache();
			//clear_to_color(screen,0); //
			break; //Enough already!
		}
	}

	doaudio = 0 ;
	xSleep( 100 ) ;


/*    exit_flag=0;

    for(;;) {
        //do 400,000 cycles / frame
	//calculated by speed of VB CPU / frames per second =
	//20,000,000 / 50 = 400,000
	for(qwe=0;qwe<=tVBOpt.FRMSKIP;qwe++) {
            //tVIPREG.XPSTTS=(tVIPREG.XPSTTS^0x0C);
            //v810_trc(1000,1);
	    v810_trc(100000,1);
            if(!(tHReg.SCR & 0x81)) { //if KBD Int Enabled
                if(tVIPREG.INTENB&0xBFF7) { //Whats the magic number?
                    if(V810_RControll()&0xFFFC) { //If Key Pressed
                        v810_int(0); //Controller Int
                    }
                }
            }
		// Display a frame, only after the right number of 'skips'
		if((tVIPREG.FRMCYC & 0x00FF) < skip) {
			skip = 0;
			// Status
			if(Left) {
				tVIPREG.XPSTTS=0x1f0C;
				//tVIPREG.DPSTTS=0x0040;
				Left = 0;
			} else {
				tVIPREG.XPSTTS=0x1f12;
				//tVIPREG.DPSTTS=0x003C; //hear or in the VIP reg? neither!
				//Updates hear make VTetris happy, but SSquash sad,  SSquash gets to win
				//for now
				Left = 1;
			}
			//Frame Interupt
      	      if(tVIPREG.INTENB&0x4008) { //Whats the magic number? //4008
            	    v810_int(4); //Display Int
	            }
		}
		// Increment skip
		skip+=1;
		//Trace
		if(0) {
			for(i=0;i<3;i++) {
	      	      v810_trc(1000,1);
				tVIPREG.DPSTTS=0x003C; //hear or in the VIP reg? neither!
	           		v810_trc(1000,1);
				tVIPREG.DPSTTS=0x0040;
			}
		} else {
           		//v810_trc(6000,1);
			v810_trc(300000,1);
		}
        }
	  // Display
	  if(tVIPREG.XPCTRL & 0x0002) {
		V810_Dsp_Frame(Left); //Temporary...
	  }

	  cheat_patch_ram();   //Apply RAM cheats (if any)

        if(key[KEY_ESC]) {
            while(key[KEY_ESC]); //Silly hack, so you can hold the esc key down...
            exit_flag=1;
            clear_keybuf(); // Make shure were not killing the returning prog!
        }
        if(exit_flag) {
            set_palette(default_palette); //Restore Palette
	    //V810_SetPal(21,42,63); //Restor Pallet...
		clearCache();
            break; //Enough already!
        }
    }*/
}

void xbox_put_image( unsigned char *pix, int spitch ) ;

//Display one frame of graphics...
void V810_Dsp_Frame(int dNum) {
    BITMAP *tmp_bmp = NULL;
    VB_WORLD WORLD_Buff[32];
    int i, j;
    int T_X,T_Y,T_X2,T_Y2;
    char buffer [200];
    PALETTE pal;
    int tObj=0;

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 384) T_X = 384;
    if (T_Y > 224) T_Y = 224;
    T_X2 = T_X*2;
    T_Y2 = T_Y*2;
    isDsp=1; //Secret flag...
    CurObj=3;

#ifdef FBHACK
    //FIX ME!
    //dNum = (tVIPREG.tFrame & 1);
    dNum = (tVIPREG.tFrame - 1);
#endif //FBHACK

    //Normalize the Pallete, Is this to slow??? (tVIPREG.BRTA*64)/MaxBrt
    if(tDSPCACHE.BrtPALMod>0) { //If pallet changed
        // If we want a fixed pallet (no brightness adjustment...)
        //V810_SetPal(tVIPREG.BRTA, tVIPREG.BRTB, tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC);

        // Figure out later, what is the true MaxBright....
        /*
        MaxBrt = 64;
        if((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)>63) MaxBrt = (tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC);
        if(tVBOpt.BFACTOR<=64) { //Darken it non linear
            V810_SetPal((tVIPREG.BRTA*tVBOpt.BFACTOR)/MaxBrt, ((tVIPREG.BRTA+tVIPREG.BRTB)*tVBOpt.BFACTOR)/MaxBrt, ((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)*tVBOpt.BFACTOR)/MaxBrt);
        } else { //briten it linear
            V810_SetPal(((tVIPREG.BRTA*64)/MaxBrt)+(tVBOpt.BFACTOR-64),
                        (((tVIPREG.BRTA+tVIPREG.BRTB)*64)/MaxBrt)+(tVBOpt.BFACTOR-64),
                        (((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)*64)/MaxBrt)+(tVBOpt.BFACTOR-64));
        }
        */
        /*
        MaxBrt = MAXBRIGHT;
        if((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)>(MAXBRIGHT-1)) MaxBrt = (tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC);
        if(tVBOpt.BFACTOR<=MAXBRIGHT) { //Darken it non linear
            V810_SetPal((tVIPREG.BRTA*tVBOpt.BFACTOR)/MaxBrt, ((tVIPREG.BRTA+tVIPREG.BRTB)*tVBOpt.BFACTOR)/MaxBrt, ((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)*tVBOpt.BFACTOR)/MaxBrt);
        } else { //briten it linear
            V810_SetPal(((tVIPREG.BRTA*MAXBRIGHT)/MaxBrt)+(tVBOpt.BFACTOR-MAXBRIGHT),
                        (((tVIPREG.BRTA+tVIPREG.BRTB)*MAXBRIGHT)/MaxBrt)+(tVBOpt.BFACTOR-MAXBRIGHT),
                        (((tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC)*MAXBRIGHT)/MaxBrt)+(tVBOpt.BFACTOR-MAXBRIGHT));
        }
        */

        V810_SetPal((tVIPREG.BRTA&0xFF)/2, (tVIPREG.BRTB&0xFF)/2, ((tVIPREG.BRTA&0xFF)+(tVIPREG.BRTB&0xFF)+(tVIPREG.BRTC&0xFF))/2);
        //V810_SetPal((tVIPREG.BRTA&0xFF), (tVIPREG.BRTB&0xFF), ((tVIPREG.BRTA&0xFF)+(tVIPREG.BRTB&0xFF)+(tVIPREG.BRTC&0xFF)));

        tDSPCACHE.BrtPALMod=0;
    }

    if(tVBOpt.DSPMODE == dm_NORMAL) {  //Normal
        clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap
        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            World2Display(i, WORLD_Buff, world_bmp,0);
        }

        //if(tDSPCACHE.DDSPDataWrite) {
            DSP2World(dNum,world_bmp);
        //    tDSPCACHE.DDSPDataWrite = 0;
        //}

        //tmp_bmp = create_sub_bitmap(world_bmp, 7, 7, 384, 224);
		//if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X, T_Y, 0, 0, T_X2, T_Y2);
		//blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
    } else { // 3D Mode...
        clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap
        clear_to_color(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap
        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            tObj = CurObj; // Save Curent Obj
            World2Display(i, WORLD_Buff, world_bmp,1+tVBOpt.DSPSWAP);
            CurObj = tObj; //Reset it..
            World2Display(i, WORLD_Buff, world_bmp2,2-tVBOpt.DSPSWAP);
        }

        //if(tDSPCACHE.DDSPDataWrite) {
            DSP2World((dNum&1),world_bmp);
            DSP2World((dNum&1)+2,world_bmp2);
        //    tDSPCACHE.DDSPDataWrite = 0;
        //}

        if(tVBOpt.DSPMODE == dm_INTERLACED) {  //Interlaced
            //for(i=0;i<=224;i++) {
                //blit(world_bmp, dsp_bmp, 7, i+7, 0, (i*2), 384, 1);
                //blit(world_bmp2, dsp_bmp, 7, i+7, 0, (i*2)+1, 384, 1);
            //}
            //tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
            //if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X, T_Y*2, 0, 0, T_X2, T_Y2*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        } else if(tVBOpt.DSPMODE == dm_OVRUNDR) { // Over/Under
            //blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            //blit(world_bmp2, dsp_bmp, 7, 7, 0, 224, 384, 224);
            //tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
            //if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X, T_Y*2, 0, 0, T_X2, T_Y2*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        } else if(tVBOpt.DSPMODE == dm_RedBlue) {
            for(i=0;i<225;i++){
                for(j=0;j<385;j++) {
                    if(world_bmp->line[i+7][j+7] >0) world_bmp->line[i+7][j+7] -= 1;   //Normalize the display
                    if(world_bmp2->line[i+7][j+7] >0) world_bmp2->line[i+7][j+7] -= 1;
                    world_bmp->line[i][j] =  (world_bmp->line[i+7][j+7] + (world_bmp2->line[i+7][j+7]*4))+8;
                    //dsp_bmp->line[i][j] =  (world_bmp->line[i+7][j+7] + (world_bmp2->line[i+7][j+7]*4))+8;
                }
            }
            //tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
            //if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X, T_Y, 0, 0, T_X2, T_Y2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
        } else if(tVBOpt.DSPMODE == dm_SIDESIDE) { // Side-by-Side
            //blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            //blit(world_bmp2, dsp_bmp, 7, 7, 384, 0, 384, 224);
            //tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384*2, 224);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X*2, T_Y);
            //if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X*2, T_Y, 0, 0, T_X2*2, T_Y2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X*2, T_Y);
        } else if(tVBOpt.DSPMODE == dm_CYBERSCOPE) { // CyberScope (Fix Me)
            //blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            //blit(world_bmp2, dsp_bmp, 7, 7, 0, 224, 384, 224);
            //tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
            //if (tVBOpt.DSP2X) stretch_blit(tmp_bmp, screen, 0, 0, T_X, T_Y*2, 0, 0, T_X2, T_Y2*2);
            //blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        }
    }

    //if(key[KEY_P])  {
        //get_palette(pal);
        //sprintf(buffer, "dsp%d.bmp",pCnt);
        //save_bmp(buffer,tmp_bmp,pal);
        //pCnt +=1;
        //while(key[KEY_P]); //Wait till they release the key!
    //}

	xbox_put_image( world_bmp->dat, world_bmp->w ) ;
    //destroy_bitmap(tmp_bmp);
    isDsp=0; //Secret flag...
}

void clearCache() {
      int i;
	tDSPCACHE.BgmPALMod=1;			//World Pallet Changed
	tDSPCACHE.ObjPALMod=1;			//Obj Pallet Changed
	tDSPCACHE.BrtPALMod=1;			//Britness for Pallet Changed
	tDSPCACHE.ObjDataCacheInvalid=1;	//Object Cache Is invalid
	tDSPCACHE.ObjCacheInvalid=1;		//Object Cache Is invalid
	for(i=0;i<14;i++) tDSPCACHE.BGCacheInvalid[i]=1;//Object Cache Is invalid
	tDSPCACHE.DDSPDataWrite=1;		//Direct Screen Draw changed
}

