//Defenition file of Instruction handler routines for
//the V810 processor

#ifndef V810_INST_H_
#define V810_INST_H_

#include "vb_types.h"

/*
// Funcs to  sign extend for us...
extern INT64U sign_32(WORD num);
extern WORD sign_26(WORD num);
extern WORD sign_16(HWORD num);
extern WORD sign_14(HWORD num);
extern WORD sign_12(HWORD num);
extern WORD sign_9(HWORD num);
extern WORD sign_8(BYTE num);
extern WORD sign_5(BYTE num);
*/

#define sign_32(num) (((num) & 0x80000000) ? (INT64)((num)|0xFFFFFFFF00000000LL) : (num))
#define sign_26(num) (((num) & 0x02000000) ? (WORD)((num)|0xFC000000) : (num))
#define sign_16(num) (((num) & 0x8000) ? (WORD)((num)|0xFFFF0000) : (num))
#define sign_14(num) (((num) & 0x2000) ? (WORD)((num)|0xFFFFC000) : (num))
#define sign_12(num) (((num) & 0x0800) ? (WORD)((num)|0xFFFFF000) : (num))
#define sign_9(num) (((num) & 0x0100) ? (WORD)((num)|0xFFFFFE00) : (num))
#define sign_8(num) (((num) & 0x0080) ? (WORD)((num)|0xFFFFFF00) : (num))
#define sign_5(num) (((num) & 0x0010) ? (WORD)((num)|0xFFFFFFE0) : (num))


extern void ins_err   (int arg1, int arg2, int tos3); //Special handler?
/*
extern void ins_mov   (int arg1, int arg2, int tos3); //Mode1/2
extern void ins_add   (int arg1, int arg2, int tos3);
extern void ins_sub   (int arg1, int arg2, int tos3);
extern void ins_cmp   (int arg1, int arg2, int tos3);
extern void ins_shl   (int arg1, int arg2, int tos3);
extern void ins_shr   (int arg1, int arg2, int tos3);
extern void ins_jmp   (int arg1, int arg2, int tos3);
extern void ins_sar   (int arg1, int arg2, int tos3);
extern void ins_mul   (int arg1, int arg2, int tos3);
extern void ins_div   (int arg1, int arg2, int tos3);
extern void ins_mulu  (int arg1, int arg2, int tos3);
extern void ins_divu  (int arg1, int arg2, int tos3);
extern void ins_or    (int arg1, int arg2, int tos3);
extern void ins_and   (int arg1, int arg2, int tos3);
extern void ins_xor   (int arg1, int arg2, int tos3);
extern void ins_not   (int arg1, int arg2, int tos3);
extern void ins_mov_i (int arg1, int arg2, int tos3);
extern void ins_add_i (int arg1, int arg2, int tos3);
extern void ins_setf  (int arg1, int arg2, int tos3);
extern void ins_cmp_i (int arg1, int arg2, int tos3);
extern void ins_shl_i (int arg1, int arg2, int tos3);
extern void ins_shr_i (int arg1, int arg2, int tos3);
extern void ins_ei    (int arg1, int arg2, int tos3);   //Undefined
extern void ins_sar_i (int arg1, int arg2, int tos3);
extern void ins_trap  (int arg1, int arg2, int tos3);

extern void ins_reti  (int arg1, int tos2, int tos3);  //Mode 9  takes a 1 bit mode arg
extern void ins_halt  (int arg1, int tos2, int tos3);

extern void ins_ldsr  (int arg1, int arg2, int tos3); //Mode 2
extern void ins_stsr  (int arg1, int arg2, int tos3);
extern void ins_di    (int arg1, int arg2, int tos3);

extern void ins_bstr  (int arg1, int arg2, int tos3); //Special ????

extern void ins_movea (int arg1, int arg2, int arg3); //Mode 5/6
extern void ins_addi  (int arg1, int arg2, int arg3);
extern void ins_jr    (int arg1, int tos2, int tos3);  //Mode 4
extern void ins_jal   (int arg1, int tos2, int tos3);
extern void ins_ori   (int arg1, int arg2, int arg3); //Mode 5/6
extern void ins_andi  (int arg1, int arg2, int arg3);
extern void ins_xori  (int arg1, int arg2, int arg3);
extern void ins_movhi (int arg1, int arg2, int arg3);
extern void ins_ld_b  (int arg1, int arg2, int arg3);
extern void ins_ld_h  (int arg1, int arg2, int arg3);
extern void ins_muli  (int arg1, int arg2, int arg3);
extern void ins_ld_w  (int arg1, int arg2, int arg3);
extern void ins_st_b  (int arg1, int arg2, int arg3);
extern void ins_st_h  (int arg1, int arg2, int arg3);
extern void ins_maci  (int arg1, int arg2, int arg3);
extern void ins_st_w  (int arg1, int arg2, int arg3);
extern void ins_in_b  (int arg1, int arg2, int arg3);
extern void ins_in_h  (int arg1, int arg2, int arg3);
extern void ins_caxi  (int arg1, int arg2, int arg3);
extern void ins_in_w  (int arg1, int arg2, int arg3);
extern void ins_out_b (int arg1, int arg2, int arg3);
extern void ins_out_h (int arg1, int arg2, int arg3);
extern void ins_fpp   (int arg1, int arg2, int arg3); //Special
extern void ins_out_w (int arg1, int arg2, int arg3);

extern void ins_bv    (int arg1, int arg2, int tos3);   //Branch Inst (Mode3)
extern void ins_bl    (int arg1, int arg2, int tos3);
extern void ins_be    (int arg1, int arg2, int tos3);
extern void ins_bnh   (int arg1, int arg2, int tos3);
extern void ins_bn    (int arg1, int arg2, int tos3);
extern void ins_br    (int arg1, int arg2, int tos3);
extern void ins_blt   (int arg1, int arg2, int tos3);
extern void ins_ble   (int arg1, int arg2, int tos3);
extern void ins_bnv   (int arg1, int arg2, int tos3);
extern void ins_bnl   (int arg1, int arg2, int tos3);
extern void ins_bne   (int arg1, int arg2, int tos3);
extern void ins_bh    (int arg1, int arg2, int tos3);
extern void ins_bp    (int arg1, int arg2, int tos3);
extern void ins_nop   (int arg1, int arg2, int tos3);
extern void ins_bge   (int arg1, int arg2, int tos3);
extern void ins_bgt   (int arg1, int arg2, int tos3);
*/
//Bitstring SubOpcodes
extern void ins_sch0bsu (int arg1, int arg2, int arg3);
extern void ins_sch0bsd (int arg1, int arg2, int arg3);
extern void ins_sch1bsu (int arg1, int arg2, int arg3);
extern void ins_sch1bsd (int arg1, int arg2, int arg3);
extern void ins_orbsu   (int arg1, int arg2, int arg3);
extern void ins_andbsu  (int arg1, int arg2, int arg3);
extern void ins_xorbsu  (int arg1, int arg2, int arg3);
extern void ins_movbsu  (int arg1, int arg2, int arg3);
extern void ins_ornbsu  (int arg1, int arg2, int arg3);
extern void ins_andnbsu (int arg1, int arg2, int arg3);
extern void ins_xornbsu (int arg1, int arg2, int arg3);
extern void ins_notbsu  (int arg1, int arg2, int arg3);

//FPU SubOpcodes
extern void ins_cmpf_s  (int arg1, int arg2, int arg3);
extern void ins_cvt_ws  (int arg1, int arg2, int arg3);
extern void ins_cvt_sw  (int arg1, int arg2, int arg3);
extern void ins_addf_s  (int arg1, int arg2, int arg3);
extern void ins_subf_s  (int arg1, int arg2, int arg3);
extern void ins_mulf_s  (int arg1, int arg2, int arg3);
extern void ins_divf_s  (int arg1, int arg2, int arg3);
extern void ins_trnc_sw (int arg1, int arg2, int arg3);
extern void ins_xb      (int arg1, int arg2, int arg3); //Undocumented opcode XB (non-FPU)
extern void ins_xh      (int arg1, int arg2, int arg3); //Undocumented opcode XH (non-FPU)
extern void ins_rev     (int arg1, int arg2, int arg3); //Undocumented opcode REV (non-FPU)
extern void ins_mpyhw   (int arg1, int arg2, int arg3); //Undocumented opcode MPYHW (non-FPU)

#endif

