#include <xtl.h>
#include <allegro.h>
#include <math.h>

BITMAP *create_bitmap(int width, int height)
{
   GFX_VTABLE *vtable;
   BITMAP *bitmap;
   int i;

   //vtable = _get_vtable(color_depth);
   //if (!vtable)
      //return NULL;

   bitmap = malloc(sizeof(BITMAP) + (sizeof(char *) * height));
   if (!bitmap)
      return 0;

   bitmap->dat = malloc(width * height );
   if (!bitmap->dat) {
      free(bitmap);
      return 0;
   }

   bitmap->w = bitmap->cr = width;
   bitmap->h = bitmap->cb = height;
   bitmap->clip = 1;
   bitmap->cl = bitmap->ct = 0;
   bitmap->vtable = 0;
   //bitmap->write_bank = bitmap->read_bank = _stub_bank_switch;
   //bitmap->id = 0;
   bitmap->extra = 0;
   //bitmap->x_ofs = 0;
   //bitmap->y_ofs = 0;
   //bitmap->seg = _default_ds();

   if (height > 0) {
      bitmap->line[0] = bitmap->dat;
      for (i=1; i<height; i++)
         bitmap->line[i] = bitmap->line[i-1] + width ;
   }


   return bitmap;
}

void destroy_bitmap(BITMAP *bitmap)
{

   if (bitmap) {

      if (bitmap->dat)
	 free(bitmap->dat);

      free(bitmap);
   }
}

void clear_to_color(struct BITMAP *bitmap, int color)
{
	int i ;
	unsigned char c ;
	unsigned char *p ;

	if ( bitmap == 0 )
		return ;

	c = color ;
	p = bitmap->dat ;
	for ( i = 0 ; i < bitmap->w * bitmap->h ; i++ )
	{
		p[i] = c ;
	}
}

BITMAP* create_video_bitmap()     { return 0 ;}

#define BLIT_CLIP()                                                          \
   /* check for ridiculous cases */                                          \
   if ((s_x >= src->w) || (s_y >= src->h) ||                                 \
       (d_x >= dest->cr) || (d_y >= dest->cb))                               \
      return;                                                                \
                                                                             \
   /* clip src left */                                                       \
   if (s_x < 0) {                                                            \
      w += s_x;                                                              \
      d_x -= s_x;                                                            \
      s_x = 0;                                                               \
   }                                                                         \
                                                                             \
   /* clip src top */                                                        \
   if (s_y < 0) {                                                            \
      h += s_y;                                                              \
      d_y -= s_y;                                                            \
      s_y = 0;                                                               \
   }                                                                         \
                                                                             \
   /* clip src right */                                                      \
   if (s_x+w > src->w)                                                       \
      w = src->w - s_x;                                                      \
                                                                             \
   /* clip src bottom */                                                     \
   if (s_y+h > src->h)                                                       \
      h = src->h - s_y;                                                      \
                                                                             \
   /* clip dest left */                                                      \
   if (d_x < dest->cl) {                                                     \
      d_x -= dest->cl;                                                       \
      w += d_x;                                                              \
      s_x -= d_x;                                                            \
      d_x = dest->cl;                                                        \
   }                                                                         \
                                                                             \
   /* clip dest top */                                                       \
   if (d_y < dest->ct) {                                                     \
      d_y -= dest->ct;                                                       \
      h += d_y;                                                              \
      s_y -= d_y;                                                            \
      d_y = dest->ct;                                                        \
   }                                                                         \
                                                                             \
   /* clip dest right */                                                     \
   if (d_x+w > dest->cr)                                                     \
      w = dest->cr - d_x;                                                    \
                                                                             \
   /* clip dest bottom */                                                    \
   if (d_y+h > dest->cb)                                                     \
      h = dest->cb - d_y;                                                    \
                                                                             \
   /* bottle out if zero size */                                             \
   if ((w <= 0) || (h <= 0))                                                 \
      return;


void masked_blit(BITMAP *src, BITMAP *dst, int sx, int sy,
		      int dx, int dy, int w, int h)
{
   int x, y;

   //BLIT_CLIP() ;

   if (dy<0) return;
   for (y = 0; y < h; y++) {
      unsigned char* s = ((unsigned char*) src->line[(sy + y) % src->h] + sx);
      unsigned char* d = ((unsigned char*) dst->line[(dy + y) % dst->h] + dx);

      for (x = w - 1; x >= 0; s++, d++, x--) {
	    if ((*s) != 0) {
		  *d=*s;
		}
     }
   }
}


void masked_stretch_blit(BITMAP *src, BITMAP *dst, int sx, int sy, int sw, int sh,
                         int dx, int dy, int dw, int dh)
{
   masked_blit(src,dst,sx,sy,dx,dy,min(dw,sw),min(dh,sh));
}

