#ifndef ALLEGRO_H
#define ALLEGRO_H

#define FONT char

typedef struct RGB_STRUCT
{
	unsigned char r ;
	unsigned char g ;
	unsigned char b ;
	unsigned char filler ;
} RGB ;

typedef PALETTE (RGB[256] ) ;

struct BITMAP ;

typedef struct GFX_VTABLE        /* functions for drawing onto bitmaps */
{
   int bitmap_type;
   int color_depth;
   int mask_color;

   int  (*getpixel)(struct BITMAP *bmp, int x, int y);
   void (*putpixel)(struct BITMAP *bmp, int x, int y, int color);
   void (*vline)(struct BITMAP *bmp, int x, int y1, int y2, int color);
   void (*hline)(struct BITMAP *bmp, int x1, int y, int x2, int color);
   void (*line)(struct BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
   void (*rectfill)(struct BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
   void (*draw_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_256_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_sprite_v_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_sprite_h_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_sprite_vh_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_trans_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (*draw_lit_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y, int color);
   void (*draw_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y);
   void (*draw_trans_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y);
   void (*draw_lit_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y, int color);
   void (*draw_character)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y, int color);
   void (*textout_fixed)(struct BITMAP *bmp, void *f, int h, unsigned char *str, int x, int y, int color);
   void (*blit_from_memory)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*blit_to_memory)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*blit_to_self)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*blit_to_self_forward)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*blit_to_self_backward)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*masked_blit)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (*clear_to_color)(struct BITMAP *bitmap, int color);
   void (*draw_sprite_end)(void);
   void (*blit_end)(void);
} GFX_VTABLE;

   int  (getpixel)(struct BITMAP *bmp, int x, int y);
   void (putpixel)(struct BITMAP *bmp, int x, int y, int color);
   void (vline)(struct BITMAP *bmp, int x, int y1, int y2, int color);
   void (hline)(struct BITMAP *bmp, int x1, int y, int x2, int color);
   void (line)(struct BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
   void (rectfill)(struct BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
   void (draw_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_256_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_sprite_v_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_sprite_h_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_sprite_vh_flip)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_trans_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y);
   void (draw_lit_sprite)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y, int color);
   void (draw_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y);
   void (draw_trans_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y);
   void (draw_lit_rle_sprite)(struct BITMAP *bmp, struct RLE_SPRITE *sprite, int x, int y, int color);
   void (draw_character)(struct BITMAP *bmp, struct BITMAP *sprite, int x, int y, int color);
   void (textout_fixed)(struct BITMAP *bmp, void *f, int h, unsigned char *str, int x, int y, int color);
   void (blit_from_memory)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (blit_to_memory)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (blit_to_self)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (blit)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (blit_to_self_forward)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (blit_to_self_backward)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (masked_blit)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
   void (masked_stretch_blit)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int source_w, int source_h, int dest_x, int dest_y, int width, int height);
   void (stretch_blit)(struct BITMAP *source, struct BITMAP *dest, int source_x, int source_y, int source_w, int source_h, int dest_x, int dest_y, int width, int height);
   void (clear_to_color)(struct BITMAP *bitmap, int color);
   void (draw_sprite_end)(void);
   void (blit_end)(void);

typedef struct BITMAP            /* a bitmap structure */
{
   int w, h;                     /* width and height in pixels */
   int clip;                     /* flag if clipping is turned on */
   int cl, cr, ct, cb;           /* clip left, right, top and bottom values */
   GFX_VTABLE *vtable;           /* drawing functions */
   void (*write_bank)();         /* write bank selector, see bank.s */
   void (*read_bank)();          /* read bank selector, see bank.s */
   void *dat;                    /* the memory we allocated for the bitmap */
   int bitmap_id;                /* for identifying sub-bitmaps */
   void *extra;                  /* points to a structure with more info */
   int line_ofs;                 /* line offset (for screen sub-bitmaps) */
   int seg;                      /* bitmap segment */
   unsigned char *line[0];       /* pointers to the start of each line */
} BITMAP;

#define set_pallete set_palette

BITMAP *create_bitmap(int width, int height);
BITMAP *create_sub_bitmap( BITMAP *bitmap, int x, int y, int w, int h );
void destroy_bitmap(BITMAP *bitmap);
void set_palette(RGB *p) ;
extern BITMAP *screen ;
struct BITMAP * create_sub_bitmap (struct BITMAP *parent, int x, int y, int width, int height);
#endif
