#ifdef MSS
#include <mss.h>
#endif


////////////////////////////////////////////////////////////////////
//Display Deug code, not needed for the ports...

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "vb_types.h"
#include "v810_cpu.h"
#include "vb_vbt.h"
#include "vb_vbtD.h"
#include "allegro.h"
#include "vb_dsp.h"
#include "vb_set.h"
#include "vb_dspD.h" //Debug code


char *worldtypes[4] = {
	"BGMap",
	"H-Bias",
	"Affine",
	"Obj"
};

int V810_DSPD_Init() {
    int done = 0;
    char bob;

/*    printf("Select graphics mode:\n 1) 320x200 (VGA)\n 2) 640x480 (Vesa1)\n 3) 640x480 (Vesa2L)\n 4) 800x600 (Vesa1)\n 5) 800x600 (Vesa2L)\n");
    while (!done) {
        bob = (readkey() & 0xFF);
        if(bob == '1') {
            tVBOpt.SCR_X = 320;
            tVBOpt.SCR_Y = 200;
            if(set_gfx_mode(GFX_VGA, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
                V810_DSP_Quit();
                return(false);
            }
            done = 1;
        } else if(bob == '2') {
            tVBOpt.SCR_X = 640;
            tVBOpt.SCR_Y = 480;
            if(set_gfx_mode(GFX_VESA1, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
                V810_DSP_Quit();
                return(false);
            }
            done = 1;
        } else if(bob == '3') {
            tVBOpt.SCR_X = 640;
            tVBOpt.SCR_Y = 480;
            if(set_gfx_mode(GFX_VESA2L, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
                V810_DSP_Quit();
                return(false);
            }
            done = 1;
        } else if(bob == '4') {
            tVBOpt.SCR_X = 800;
            tVBOpt.SCR_Y = 600;
            if(set_gfx_mode(GFX_VESA1, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
                V810_DSP_Quit();
                return(false);
            }
            done = 1;
        } else if(bob == '5') {
            tVBOpt.SCR_X = 800;
            tVBOpt.SCR_Y = 600;
            if(set_gfx_mode(GFX_VESA2L, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
                V810_DSP_Quit();
                return(false);
            }
            done = 1;
        }
    } */
    return(true);
}
////////////////////////////////////////////////////////////////////
void V810_Dsp_Debug() {
    //Remove me (Maby not???)
    //int qwe, i;
    char a;
    char buffer [200];
    BITMAP *disp_bmp; // a of screen buffer for writes to the screen

    disp_bmp = create_bitmap(tVBOpt.SCR_X, tVBOpt.SCR_Y); // make a bitmap in system RAM
    while(1) {
        clearCache(); //Clear out the cache
        clear(disp_bmp);                    // zero the memory bitmap
        sprintf(buffer, "Please chose:");
        textout(disp_bmp, font, buffer, 10, 10, 252);
        sprintf(buffer, " (C)har, (O)bj, (B)G Obj, (R)om (W)orld");
        textout(disp_bmp, font, buffer, 10, 20, 252);
        sprintf(buffer, " R(a)m, (P)rint Buff, (D)isplay");
        textout(disp_bmp, font, buffer, 10, 30, 252);
        sprintf(buffer, " <ESC> exits, 'P' saves a Picture, 'S' Scale Info");
        textout(disp_bmp, font, buffer, 10, 40, 252);
        blit(disp_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);

        a = (readkey() & 0xFF);
        a = (a & 0xFF);
        a = toupper(a);

        if (a=='C') V810_DSP_Chr();
        else if (a=='O') V810_DSP_Obj();
        else if (a=='B') V810_DSP_BGMap();
        else if (a=='R') V810_DSP_Rom();
        else if (a=='A') V810_DSP_Ram();
        else if (a=='W') V810_DSP_World();
        else if (a=='P') V810_PRNBUFF();
        else if (a=='D') V810_DspD_Go();
        else if (a=='S') VB_PRN_AFFIN();
        else if ((a==27)||(a=='Q')) break;
    }
    destroy_bitmap(disp_bmp);
}

void V810_DspD_Go() {
    int qwe, i;
    char a;
    char buffer [200];

    clearCache(); //Reset the Cache
    clear(dsp_bmp);                    // zero the memory bitmap
    sprintf(buffer, "Select display mode:");
    textout(dsp_bmp, font, buffer, 10, 10, 252);
    sprintf(buffer, " 0) Normal 1) Red/Blue 2)Interlaced");
    textout(dsp_bmp, font, buffer, 10, 20, 252);
    sprintf(buffer, " 3) Over/Under 4) Side-by-Side 5) CyberScope");
    textout(dsp_bmp, font, buffer, 10, 30, 252);
    blit(dsp_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);
    a = (readkey() & 0xFF);
    if((a & 0x30)==0x30) tVBOpt.DSPMODE = (a & 0x0F);
    if(tVBOpt.DSPMODE > 5) tVBOpt.DSPMODE = dm_NORMAL;

    V810_Dsp_Go();
}

// Need to scroll and generaly handle changes in screen res better!
// Display the rom graphicaly...
void V810_DSP_Rom() {
    char buffer [200];
    unsigned long romStrt = 0x07000000;
    BITMAP *world_bmp = create_bitmap(tVBOpt.SCR_X,tVBOpt.SCR_Y);
    int j;
    HWORD chr[8];
    BITMAP *tSprt;
    char a;
    PALETTE pal;
    int y, x;
    int done = 0;
    WORD offset = romStrt;// only 14 posible bg's, this is 16 but whos counting?
    int chr_x = tVBOpt.SCR_X >>3;
    int chr_y = tVBOpt.SCR_Y >>3;

    while(!done) {
        clear(world_bmp); // zero the memory bitmap
        for(y = 0; y < chr_y; y++) {
            for(x=0; x < chr_x;x++) {
                // Grab a chr from chr ram
                for(j=0; j<8;j++) {
                    chr[j] = mem_rhword(((y*chr_x + x) * 16) + offset+ (j <<1));
                }

                //Now convert the chr to a sprite a put it on the world plane...
                //First grab a sub bitmap off of the world Bitmap
                tSprt = create_sub_bitmap(world_bmp, (x<<3), (y<<3), 8, 8); //(i/64)*8)
                //Then copy the chr to the sub bitmap, this should copy it to the world bitmap by default (Very Nice)
                chr2sprite(chr, tSprt);
                destroy_bitmap(tSprt);
            }
        }

        blit(world_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);

        while(1) {
            a = (readkey() & 0xFF);

            //save a Picture of the screen.... (In the current screen resolution)
            if (toupper(a)=='P') {
                get_palette(pal);
                save_bmp("rom1.bmp",world_bmp,pal);
                //Print Help....
            } else if (toupper(a)=='H') {
                clear(world_bmp); // zero the memory bitmap
                sprintf(buffer, "Please chose:");
                textout(world_bmp, font, buffer, 5, 10, 252);
                sprintf(buffer, "save a (P)ic, (H)elp, (Q)uit or <ESC>");
                textout(world_bmp, font, buffer, 5, 20, 252);
                sprintf(buffer, "(u)p/(d)own 1 line, (U)p/(D)own 1 page");
                textout(world_bmp, font, buffer, 5, 30, 252);
                sprintf(buffer, "(<)/(>)L/R 1 Block, (+)/(-)move 1 byte");
                textout(world_bmp, font, buffer, 5, 40, 252);
                sprintf(buffer, "(1)/(2)shrink/expand the colums");
                textout(world_bmp, font, buffer, 5, 50, 252);
                blit(world_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);

                a = (readkey() & 0xFF);
                break;
            // Move 1 Page (Screen)....
            } else if (a == 'D') {
                offset += chr_x*chr_y*16;
                break;
            } else if (a == 'U') {
                offset -= chr_x*chr_y*16;
                if (offset < romStrt) offset = romStrt;
                break;
                // Move 1 line....
            } else if (a == 'd') {
                offset += chr_x*16;
                break;
            } else if (a == 'u') {
                offset -= chr_x*16;
                if (offset < romStrt) offset = romStrt;
                break;
                // Move 1 picture....
            } else if ((a == '<')||(a == ',')) {
                offset += 16;
                break;
            } else if ((a == '>')||(a == '.')) {
                offset -= 16;
                if (offset < romStrt) offset = romStrt;
                break;
            //Adjust by 1 byte, usfull when the immages arent aligned on evin boundrys...
            } else if ((a == '+')||(a=='=')) {
                offset++;
                break;
            } else if ((a == '-')||(a == '_')) {
                offset--;
                if (offset < romStrt) offset = romStrt;
                break;
            //Shrink\grow the columbs, good to get tiles to align... (So Im wierd....)
            } else if ((a == '1')||(a=='!')) {
                chr_x--;
                if (chr_x < 0) chr_x=0;
                break;
            } else if ((a == '2')||(a == '@')) {
                chr_x++;
                if (chr_x > (tVBOpt.SCR_X >>3)) chr_x = (tVBOpt.SCR_X >>3);
                break;
            //Quit of cource (Duh...)
            } else if ((a==27)||(toupper(a)=='Q')) {
                done = 1;
                break;
            }
        }
    }

    destroy_bitmap(world_bmp);
}

void V810_DSP_Ram() {
    char buffer [200];
    unsigned long ramStrt = 0x00000000;
    int i;
    HWORD chr;
    BITMAP *tSprt;
    char a;
    PALETTE pal;
    int y, x;
    int done = 0;
    WORD offset = ramStrt;// only 14 posible bg's, this is 16 but whos counting?
    int chr_x = 512;
    int chr_y = 256;
    BITMAP *world_bmp = create_bitmap(chr_x,chr_y);
    while(!done) {
        clear(world_bmp); // zero the memory bitmap
        for(x=0; x < chr_x; x++) {
            for(y=0; y < chr_y; y+=8) {
                chr = mem_rhword((x*(chr_y/4)+(y/4)) + offset);
                world_bmp->line[y+0][x] = ((chr >>  0) & 3)+1;
                world_bmp->line[y+1][x] = ((chr >>  2) & 3)+1;
                world_bmp->line[y+2][x] = ((chr >>  4) & 3)+1;
                world_bmp->line[y+3][x] = ((chr >>  6) & 3)+1;
                world_bmp->line[y+4][x] = ((chr >>  8) & 3)+1;
                world_bmp->line[y+5][x] = ((chr >> 10) & 3)+1;
                world_bmp->line[y+6][x] = ((chr >> 12) & 3)+1;
                world_bmp->line[y+7][x] = ((chr >> 14) & 3)+1;
            }
        }

		scare_mouse();
        blit(world_bmp, screen, 0, 0, 0, 0, chr_x, chr_y);
        unscare_mouse();

        while(1) {
            a = (readkey() & 0xFF);

            //save a Picture of the screen.... (In the current screen resolution)
            if (toupper(a)=='P') {
                get_palette(pal);
                save_bmp("rom1.bmp",world_bmp,pal);
                //Print Help....
            } else if (toupper(a)=='H') {
                clear(world_bmp); // zero the memory bitmap
                sprintf(buffer, "Please chose:");
                textout(world_bmp, font, buffer, 5, 10, 252);
                sprintf(buffer, "save a (P)ic, (H)elp, (Q)uit or <ESC>");
                textout(world_bmp, font, buffer, 5, 20, 252);
                sprintf(buffer, "(u)p/(d)own 1 line, (U)p/(D)own 1 page");
                textout(world_bmp, font, buffer, 5, 30, 252);
                sprintf(buffer, "(<)/(>)L/R 1 Block, (+)/(-)move 1 byte");
                textout(world_bmp, font, buffer, 5, 40, 252);
                sprintf(buffer, "(1)/(2)shrink/expand the colums");
                textout(world_bmp, font, buffer, 5, 50, 252);
                blit(world_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);

                a = (readkey() & 0xFF);
                break;
            // Move 1 Page (Screen)....
            } else if (a == 'D') {
                offset += (chr_y/4)*chr_x;
                break;
            } else if (a == 'U') {
                offset -= (chr_y/4)*chr_x;
                if (offset < ramStrt) offset = ramStrt;
                break;
                // Move 1 line....
            } else if (a == 'd') {
                offset += (chr_y/4);
                break;
            } else if (a == 'u') {
                offset -= (chr_y/4);
                if (offset < ramStrt) offset = ramStrt;
                break;
                // Move 1 picture....
            } else if ((a == '<')||(a == ',')) {
                offset += 2;
                break;
            } else if ((a == '>')||(a == '.')) {
                offset -= 2;
                if (offset < ramStrt) offset = ramStrt;
                break;
            //Adjust by 1 byte, usfull when the immages arent aligned on evin boundrys...
            } else if ((a == '+')||(a=='=')) {
                offset++;
                break;
            } else if ((a == '-')||(a == '_')) {
                offset--;
                if (offset < ramStrt) offset = ramStrt;
                break;
            //Shrink\grow the columbs, good to get tiles to align... (So Im wierd....)
            } else if ((a == '1')||(a=='!')) {
                chr_x--;
                if (chr_x < 0) chr_x=0;
                break;
            } else if ((a == '2')||(a == '@')) {
                chr_x++;
                if (chr_x > 384) chr_x = 384;
                break;
            //Quit of cource (Duh...)
            } else if ((a==27)||(toupper(a)=='Q')) {
                done = 1;
                break;
            }
        }
    }

    destroy_bitmap(world_bmp);
}


// Need to scroll and generaly handle changes in screen res better!
// Display a table of chr's
void V810_DSP_Chr() {
    BITMAP *world_bmp = create_bitmap(512,512);
    BITMAP *tmp_bmp;  // a of screen buffer for writes to the screen
    int i;
    //HWORD chr[8];
    BITMAP *tSprt;
    BYTE tPal[4]={1,2,3,4};
    int T_X, T_Y;
    char a;
    PALETTE pal;

    clear(world_bmp); // zero the memory bitmap

    for(i = 0; i < 2048; i++) {
        //First grab a sub bitmap off of the world Bitmap
        tSprt = create_sub_bitmap(world_bmp, ((i&63)<<3), ((i>>6)<<3), 8, 8); //(i/64)*8)
        //Then copy the chr to the sub bitmap, this should copy it to the world bitmap by default (Very Nice)
        fchr2sprite(i, tSprt,0,0,tPal);
        destroy_bitmap(tSprt);
    }

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 512) T_X = 512;
    if (T_Y > 512) T_Y = 512;

	scare_mouse();
    tmp_bmp = create_sub_bitmap(world_bmp, 0, 0, T_X, T_Y);
    blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
    destroy_bitmap(tmp_bmp);
    unscare_mouse();

    while(1) {
        a = (readkey() & 0xFF);
        a = toupper(a);

        if (a=='P') {
            get_palette(pal);
            save_bmp("chr1.bmp",world_bmp,pal);
        }
        if (a=='Q') break;
        if (a==27) break;
    }

    destroy_bitmap(world_bmp);
}


// Display all the Obj files, need to look for SPTx registers...
void V810_DSP_Obj(){
    BITMAP *world_bmp = create_bitmap(512,512);
    BITMAP *tmp_bmp; // a of screen buffer for writes to the screen
    VB_OBJ OBJ_Buff[0x400];
    int p = 0;
    int done = 0;
    char buffer [80];
    int T_X, T_Y;
    char a;
    PALETTE pal;

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 512) T_X = 512;
    if (T_Y > 512) T_Y = 512;

    vGetAllObjects(OBJ_Buff);
    for(p = 0; p < 4; p++) {
        clear(world_bmp);                      // zero the memory bitmap
        Obj2World(OBJ_Buff, world_bmp,p,0);

		scare_mouse();
        tmp_bmp = create_sub_bitmap(world_bmp, 7, 7, T_X+7, T_Y+7);
        sprintf(buffer, "%d",p);
        textout(tmp_bmp, font, buffer, 2, 2, 252);
        blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
        destroy_bitmap(tmp_bmp);
        unscare_mouse();

        while(1) {
          done = 0;
          a = (readkey() & 0xFF);
          a = toupper(a);

          if (a=='P') {
            get_palette(pal);
            save_bmp("obj1.bmp",world_bmp,pal);
          } else if ((a==27)||(a=='Q')) {
            done = 1;
            break;
          } else {
            done = 0;
            break;
          }
        }
        if(done) break;
    }

    destroy_bitmap(world_bmp);
}

// Display all the BG maps
void V810_DSP_BGMap(){
    int T_X, T_Y, i;
    BITMAP *world_bmp = create_bitmap(512,512);
    BITMAP *tmp_bmp; // a of screen buffer for writes to the screen
    int done = 0;
    char a;
    char buffer[200];
    PALETTE pal;
    int p;

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 512) T_X = 512;
    if (T_Y > 512) T_Y = 512;

    for(i=0;i<14;i++) {
        tDSPCACHE.BGCacheInvalid[i]=1;
    }

    for (p = 0; p < 14; p++) {
        clear(world_bmp);                      // zero the memory bitmap
        BGMap2World(p, world_bmp);

        scare_mouse();
        tmp_bmp = create_sub_bitmap(world_bmp, 0, 0, T_X, T_Y);
        sprintf(buffer, "%d",p);
        textout(tmp_bmp, font, buffer, 2, 2, 252);
        blit(tmp_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);
        destroy_bitmap(tmp_bmp);
        unscare_mouse();

        while(1) {
            done = 0;
            a = (readkey() & 0xFF);
            a = toupper(a);

            if (a=='P') {
                get_palette(pal);
                sprintf(buffer, "bg_map%d.bmp",p);
                save_bmp(buffer,world_bmp,pal);
            } else if ((a==27)||(a=='Q')) {
                done = 1;
                break;
            } else {
                done = 0;
                break;
            }
        }
        if(done) break;
    }

    destroy_bitmap(world_bmp);
}

void V810_DSP_World(){
    VB_WORLD WORLD_Buff[32];
    BITMAP *world_bmp = create_bitmap(512,512);
    BITMAP *tmp_bmp; // a of screen buffer for writes to the screen
    //char bob;
    char a;
    char buffer [200];
    PALETTE pal;
    int T_X = tVBOpt.SCR_X;
    int T_Y = tVBOpt.SCR_Y;
    int p;
    int done = 0;

    if (T_X > 512) T_X = 512;
    if (T_Y > 512) T_Y = 512;

    for(p = 0; p < 32; p++) {
        clear(world_bmp);                      // zero the memory bitmap
        getWorld(p,WORLD_Buff);
        World2Display(p, WORLD_Buff, world_bmp,0);

		scare_mouse();
        tmp_bmp = create_sub_bitmap(world_bmp, 0, 0, T_X, T_Y);
        sprintf(buffer, "%d [%s]",p,worldtypes[WORLD_Buff[p].BGM]);
        textout(tmp_bmp, font, buffer, 2, 2, 252);
        blit(tmp_bmp, screen, 0, 0, 0, 0, tVBOpt.SCR_X, tVBOpt.SCR_Y);
        destroy_bitmap(tmp_bmp);
        unscare_mouse();

        while(1) {
            done = 0;
            a = (readkey() & 0xFF);
            a = toupper(a);

            if (a=='P') {
                get_palette(pal);
                sprintf(buffer, "world%d.bmp",p);
                save_bmp(buffer,world_bmp,pal);
            } else if ((a==27)||(a=='Q')) {
                done = 1;
                break;
            } else {
                done = 0;
                break;
            }
        }
        if(done) break;
    }
    destroy_bitmap(world_bmp);
}

void V810_PRNBUFF() {
    int i = 0;
    //VB_OBJ OB[1024];
    VB_WORLD WB[32];
    //VB_BGMAP BG[4096];

    //for (i = 0; i < 14; i++) {
    //    getBGmap(i,BG);
    //    fprintf(ferr,"\nBGBuff BPLTS %d",BG[0].BPLTS);
    //}

    //for (i = 0; i < 0x400; i++) {
    //    getObj(i,OB);
    //}

#ifndef DBG_PRINT
	//v810_err.txt
	if ((ferr = fopen("world_vip.txt", "wt")) == NULL) {
        return;
    }
#endif

    for(i = 0; i<32; i++) {
        getWorld(i,WB);
    }
    for(i=0; i<32; i++) {
        fprintf(ferr,"\nWorld Buff %d",i);
        fprintf(ferr,"\n Lon: %d Ron: %d BGM: %d SCX: %d SCY: %d OVER: %d End: %d BGMBase %d",WB[i].LON,WB[i].RON,WB[i].BGM,WB[i].SCX,WB[i].SCY,WB[i].OVER,WB[i].END,WB[i].BGMAP_BASE);
        fprintf(ferr,"\n GX: %d GP: %d GY: %d",WB[i].GX,WB[i].GP,WB[i].GY);
        fprintf(ferr,"\n MX: %d MP: %d MY: %d",WB[i].MX,WB[i].MP,WB[i].MY);
        fprintf(ferr,"\n W: %d H: %d",WB[i].W,WB[i].H);
        fprintf(ferr,"\n PARAM_BASE: %d OVERPLANE_CHARACTER: %d",WB[i].PARAM_BASE,WB[i].OVERP_CHR);
    }

    //for(i=0; i<0x400; i++) {
    //  fprintf(ferr,"\nObjBuff Buff %d",i);
    //  fprintf(ferr,"\n JLon: %d JRon: %d JP: %d JX: %d JY:",OB[i].JLON,OB[i].JRON,OB[i].JP,OB[i].JX,OB[i].JY);
    //  fprintf(ferr,"\n JPLTS: %d JHFLP: %d JVFLP: %d JCA: %d",OB[i].JPLTS,OB[i].JHFLP,OB[i].JVFLP,OB[i].JCA);
    //}

    fprintf(ferr,"\n");

    fprintf(ferr,"\nBRTA 0x%02x",tVIPREG.BRTA&0xFF);
    fprintf(ferr,"\nBRTB 0x%02x",tVIPREG.BRTB&0xFF);
    fprintf(ferr,"\nBRTC 0x%02x",tVIPREG.BRTC&0xFF);
    fprintf(ferr,"\nREST 0x%02x",tVIPREG.REST);

    fprintf(ferr,"\nGPLT[0] 0x%02x",tVIPREG.GPLT[0]);
    fprintf(ferr,"\nGPLT[1] 0x%02x",tVIPREG.GPLT[1]);
    fprintf(ferr,"\nGPLT[2] 0x%02x",tVIPREG.GPLT[2]);
    fprintf(ferr,"\nGPLT[3] 0x%02x",tVIPREG.GPLT[3]);

    fprintf(ferr,"\nJPLT[0] 0x%02x",tVIPREG.JPLT[0]);
    fprintf(ferr,"\nJPLT[1] 0x%02x",tVIPREG.JPLT[1]);
    fprintf(ferr,"\nJPLT[2] 0x%02x",tVIPREG.JPLT[2]);
    fprintf(ferr,"\nJPLT[3] 0x%02x",tVIPREG.JPLT[3]);

    fprintf(ferr,"\nBKCOL 0x%02x",tVIPREG.BKCOL);

    fflush(ferr);

#ifndef DBG_PRINT
    fclose(ferr);
#endif
}

void VB_PRN_AFFIN() {
    int i,j,k;
    long PBaseOffset = 0;
    long OvPlaneOffset = 0;
    VB_WORLD WB[32];

#ifndef DBG_PRINT
	//v810_err.txt
	if ((ferr = fopen("affine.txt", "wt")) == NULL) {
        return;
    }
#endif

    for(i = 0; i<32; i++) {
        getWorld(i,WB);
    }
    for(i=0; i<32; i++) {
        if(WB[i].BGM==2) {
            fprintf(ferr,"\n\n//-------------------------------------");
            fprintf(ferr,"\nWorld Buff %d",i);
            fprintf(ferr,"\n Lon: %d Ron: %d BGM: %d SCX: %d SCY: %d OVER: %d End: %d BGMBase %d",WB[i].LON,WB[i].RON,WB[i].BGM,WB[i].SCX,WB[i].SCY,WB[i].OVER,WB[i].END,WB[i].BGMAP_BASE);
            fprintf(ferr,"\n GX: %d GP: %d GY: %d",WB[i].GX,WB[i].GP,WB[i].GY);
            fprintf(ferr,"\n MX: %d MP: %d MY: %d",WB[i].MX,WB[i].MP,WB[i].MY);
            fprintf(ferr,"\n W: %d H: %d ",WB[i].W,WB[i].H);
            fprintf(ferr,"\n PARAM_BASE: %d OVERPLANE_CHARACTER: %d ",WB[i].PARAM_BASE,WB[i].OVERP_CHR);

            PBaseOffset = WB[i].PARAM_BASE*2+0x00020000;
            fprintf(ferr,"\n\n PARAM_Offset: %ld ",PBaseOffset);
            v810_dumpD(PBaseOffset,(WB[i].H));
            if(WB[i].OVERP_CHR > 1) {
                OvPlaneOffset = WB[i].OVERP_CHR*2+0x00020000;
                fprintf(ferr,"\n\n OVERPLANE_Offset: %ld ",OvPlaneOffset);
                v810_dumpD(OvPlaneOffset,(WB[i].H));
            }
        }
    }
    fflush(ferr);

#ifndef DBG_PRINT
    fclose(ferr);
#endif
}

void v810_dumpD(long tPC, int num) {
    HWORD t1, t2, t3, t4;
    int i = 0;
    int j = 0;

#ifndef DBG_PRINT
	//v810_err.txt
	if ((ferr = fopen("disasm.txt", "wt")) == NULL) {
        return;
    }
#endif

    for(i = 0; i< num; i++) {
        fprintf(ferr,"\n%08lx",tPC);
        for (j = 0; j < 16; j+=8) {
            t1 = mem_rhword(tPC+j);
            t2 = mem_rhword(tPC+j+2);
            t3 = mem_rhword(tPC+j+4);
            t4 = mem_rhword(tPC+j+6);
            //fprintf(ferr,"  %04x %04x %04x %04x", t1, t2, t3, t4);
            fprintf(ferr,"  %04d %04d %04d %04d", ((short)t1), ((short)t2), ((short)t3), ((short)t4));
        }
        tPC +=16;
    }

    fflush(ferr);

#ifndef DBG_PRINT
    fclose(ferr);
#endif
}

