#define CHT_EQL         0
#define CHT_GRT         1
#define CHT_GRE         2
#define CHT_LST         3
#define CHT_LSE         4
#define CHT_NOT         5

struct VB_CHEAT;

typedef struct VB_CHEAT
{
    char title[32];

    unsigned short lines;
    unsigned short type[16];
    unsigned int address[16];
    unsigned int argument[16];
    unsigned short enabled;
    unsigned int old_ram[16];
} VB_CHEAT;




extern WORD mem_list[2][2048];

extern char vb_cht_titles[64][32];
extern VB_CHEAT vb_cheats[2][64];
extern unsigned char cheat_list_ready;
extern unsigned char cheat_old_ram_ready;
extern short cheat_number_games;
extern short cheat_number_cheats[];




void cheat_init_list(void);
void cheat_init_old_ram(void);
void cheat_save_old_ram(void);
void cheat_reset_list(void);
void cheat_search_comp(int command);
int cheat_number_hits(void);
int cheat_get_hit(int number);
int cheat_get_value(int address);
int cheat_get_old_value(int address);
void cheat_search_exact(int value);
int cheat_load_db(void);
int cheat_load_game(int num, unsigned short a);
void cheat_clear_temp(void);
void cheat_copy_struct(int src, int dest);
void cheat_unpatch_rom(void);
void cheat_patch_rom(void);
void cheat_show_struct(int n, int c);

int cheat_search_byte(BYTE arg, int list);
int cheat_search_hword(HWORD arg, int list);
void cheat_write_list(int list);
int cheat_merge_lists(void);
void cheat_erase_list(int list);

