////////////////////////////////////////////////////////////
//Instruction handler routines for
//the V810 processor

#ifdef MSS
#include <mss.h>
#endif

#include "vb_types.h"
#include "v810_opt.h"
#include "v810_cpu.h"
#include "vb_vbt.h"  //Remove Me!!!
#include "vb_vbtD.h"  //Remove Me!!!
#include <stdio.h> //Remove Me!!!
#include "v810_ins.h"

//http://www.rt66.com/~brennan/djgpp/djgpp_asm.html
//info gcc "C Extensions" "Extended Asm"

/*
// Routines to automate the mundane task of sign extending...
VB_INLINE INT64U sign_32(WORD num) {
	return((num & 0x80000000) ? (INT64)(num|0xFFFFFFFF00000000LL) : num);
}

VB_INLINE WORD sign_26(WORD num) {
	return((num & 0x02000000) ? (WORD)(num|0xFC000000) : num);
}

VB_INLINE WORD sign_16(HWORD num) {
	return((num & 0x8000) ? (WORD)(num|0xFFFF0000) : num);
}

VB_INLINE WORD sign_14(HWORD num) {
	return((num & 0x2000) ? (WORD)(num|0xFFFFC000) : num);
}

VB_INLINE WORD sign_12(HWORD num) {
	return((num & 0x0800) ? (WORD)(num|0xFFFFF000) : num);
}

VB_INLINE WORD sign_9(HWORD num) {
	return((num & 0x0100) ? (WORD)(num|0xFFFFFE00) : num);
}

VB_INLINE WORD sign_8(BYTE num) {
	return((num & 0x0080) ? (WORD)(num|0xFFFFFF00) : num);
}

VB_INLINE WORD sign_5(BYTE num) {
	return((num & 0x0010) ? (WORD)(num|0xFFFFFFE0) : num);
}
*/

//The Instructions
void ins_err(int arg1, int arg2, int tos3) { //Mode1/2
	//dtprintf(6,ferr,"\nInvalid code! err");
}
/*
void ins_mov(int arg1, int arg2, int tos3) {
	P_REG[arg2] = P_REG[arg1];
}
void ins_add(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64 temp = P_REG[arg2] + P_REG[arg1];
	// Set Flags
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	if(temp != ((long)temp)) flags = flags | PSW_CY; // Old
    if(((P_REG[arg2]^(~P_REG[arg1]))&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;

	//if ((temp >> 32) == 1) flags = flags | PSW_CY; // New
	//if ((temp >> 32)!=0) flags = flags | PSW_OV; // Old

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
	P_REG[arg2] = (long)temp;

}
void ins_sub(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64 temp = P_REG[arg2] - P_REG[arg1];

	// Set Flags
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
    if(((P_REG[arg2]^P_REG[arg1])&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;
	if(temp != ((long)temp)) flags = flags | PSW_CY; // & 0x80000000

	//if ((temp >> 32)!=0) flags = flags | PSW_OV; //Old
	//if ((temp >> 32) == 1) flags = flags | PSW_CY; // New

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
	P_REG[arg2] = (long)temp;
}

void ins_cmp(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64 temp = P_REG[arg2]-P_REG[arg1];

	// Set Flags
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
    if(((P_REG[arg2]^P_REG[arg1])&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;
	if(temp != ((long)temp)) flags = flags | PSW_CY;

	//if ((temp >> 32)!=0) flags = flags | PSW_OV; // Old
	//if ((temp >> 32) == 1) flags = flags | PSW_CY; // New

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}

void ins_shl(int arg1, int arg2, int tos3) {
	int flags = 0;
	int val = P_REG[arg1] & 0x1F;
	// set CY before we destroy the regisrer info....
	if((val != 0)&&(P_REG[arg2] >> (32 - val))&0x01) flags = flags | PSW_CY;
	P_REG[arg2] = P_REG[arg2] << val;
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_shr(int arg1, int arg2, int tos3) {
	int flags = 0;
	int val = P_REG[arg1] & 0x1F;
	// set CY before we destroy the regisrer info....
	if((val != 0)&&(P_REG[arg2] >> (val-1))&0x01) flags = flags | PSW_CY;
	P_REG[arg2] = P_REG[arg2] >> val;
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_jmp(int arg1, int arg2, int tos3) {
	PC = (P_REG[arg1] & 0xFFFFFFFE);
}
void ins_sar(int arg1, int arg2, int tos3) {
	int flags = 0;
	int i = 0;
	int val = P_REG[arg1] & 0x1F;
	WORD msb = P_REG[arg2] & 0x80000000; // Grab the MSB

	for(i = 0; i < val; i++) {
	  // set CY before we destroy the regisrer info....
	  if((val != 0)&&(P_REG[arg2] >> (val-1))&0x01) flags = flags | PSW_CY; //Makes no sence to me =)

	  P_REG[arg2] = (P_REG[arg2] >> 1)|msb; // Apend the MSB to the end
	}
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_mul(int arg1, int arg2, int tos3) {
	int flags=0;
	INT64 temp= (INT64)P_REG[arg1] * (INT64)P_REG[arg2];
	P_REG[30]   = temp >> 32;
	// Set Flags
	if((P_REG[30]!=0x00000000)&&(P_REG[30]!=0xFFFFFFFF)&&(arg2!=30)) flags = flags |PSW_OV;
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;

	P_REG[arg2] = (long)temp;
}
void ins_div(int arg1, int arg2, int tos3) {
	int flags = 0;
	if(P_REG[arg1] == 0) { // Div by zero error
		// Generate exception!
	} else {
		if((P_REG[arg2]==0x80000000)&&(P_REG[arg1]==0xFFFFFFFF)) flags = flags |PSW_OV;
		P_REG[30]   = (long)P_REG[arg2] % (long)P_REG[arg1];
		P_REG[arg2] = (long)P_REG[arg2] / (long)P_REG[arg1];
		// Set Flags
		if (P_REG[arg2] == 0) flags = flags | PSW_Z;
		if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
		S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
	}
}
void ins_mulu(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64U temp= (INT64U)P_REG[arg1] * (INT64U)P_REG[arg2];
	P_REG[30]   = temp >> 32;
	// Set Flags
	if((P_REG[30]!=0x00000000)&&(arg2 != 30)) flags = flags |PSW_OV;
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
	P_REG[arg2] = (WORD)temp;
}
void ins_divu(int arg1, int arg2, int tos3) {
	int flags = 0;
	if(P_REG[arg1] == 0) { // Div by zero error
		// Generate exception!
	} else {
		P_REG[30]   = (WORD)P_REG[arg2] % (WORD)P_REG[arg1];
		P_REG[arg2] = (WORD)P_REG[arg2] / (WORD)P_REG[arg1];
		// Set Flags
		if (P_REG[arg2] == 0) flags = flags | PSW_Z;
		if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
		S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
	}
}
void ins_or(int arg1, int arg2, int tos3) {
	int flags = 0;
	P_REG[arg2] = P_REG[arg1] | P_REG[arg2];
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_and(int arg1, int arg2, int tos3) {
	int flags = 0;
	P_REG[arg2] = P_REG[arg1] & P_REG[arg2];
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_xor(int arg1, int arg2, int tos3) {
	int flags = 0;
	P_REG[arg2] = P_REG[arg1] ^ P_REG[arg2];
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_not(int arg1, int arg2, int tos3) {
	int flags = 0;
	P_REG[arg2] = 0xFFFFFFFF - P_REG[arg1];
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}

void ins_mov_i(int arg1, int arg2, int tos3) {
	P_REG[arg2] = sign_5(arg1);
}
void ins_add_i(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64 temp = P_REG[arg2] + sign_5(arg1);
	// Set Flags
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	if(((P_REG[arg2]^(~sign_5(arg1)))&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;
	if(temp != ((long)temp)) flags = flags | PSW_CY; // & 0x80000000

	//if((temp >> 32) == 1) flags = flags | PSW_CY; // New
	//if ((temp >> 32)!=0) flags = flags | PSW_OV;

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
	P_REG[arg2] = (WORD)temp;
}
void ins_setf(int arg1, int arg2, int tos3) {
	//dtprintf(6,ferr,"\nUnhandled opcode! setf");
}
void ins_cmp_i(int arg1, int arg2, int tos3) {
	int flags = 0;
	INT64 temp = P_REG[arg2]-sign_5(arg1);
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	if(((P_REG[arg2]^(sign_5(arg1)))&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;
	if(temp != ((long)temp)) flags = flags | PSW_CY;

	//if ((temp >> 32)!=0) flags = flags | PSW_OV;
	//if((temp >> 32) == 1) flags = flags | PSW_CY; // New

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_shl_i(int arg1, int arg2, int tos3) {
	int flags = 0;
	if((arg1)&&(P_REG[arg2] >> (32 - arg1))&0x01) flags = flags | PSW_CY;
	// set CY before we destroy the regisrer info....
	P_REG[arg2] = P_REG[arg2] << arg1;
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_shr_i(int arg1, int arg2, int tos3) {
	int flags = 0;
	if((arg1)&&(P_REG[arg2] >> (arg1-1))&0x01) flags = flags | PSW_CY;
	// set CY before we destroy the regisrer info....
	P_REG[arg2] = P_REG[arg2] >> arg1;
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_ei(int arg1, int arg2, int tos3) {
	S_REG[PSW] = S_REG[PSW] & (0xFFFFFFFF - PSW_ID);
}
void ins_sar_i(int arg1, int arg2, int tos3) {
	int flags = 0;
	int i = 0;
	WORD msb = P_REG[arg2] & 0x80000000; // Grab the MSB

	for(i = 0; i < arg1; i++) {
		// set CY before we destroy the regisrer info....
		if((arg1)&&(P_REG[arg2] >> (arg1-1))&0x01) flags = flags | PSW_CY;
		//Shift!
		P_REG[arg2] = (P_REG[arg2] >> 1) | msb; //Keep sticking the msb on the end
	}
	// Set Flags
	if (!P_REG[arg2]) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}

void ins_trap(int arg1, int arg2, int tos3) {
	//dtprintf(6,ferr,"\nUnhandled opcode! trap");
}

void ins_reti(int arg1, int tos2, int tos3) {	   //Mode 9  takes a 1 bit mode arg
	//Return from Trap/Interupt
	if(S_REG[PSW] & PSW_NP) { // Read the FE Reg
		PC = S_REG[FEPC];
		S_REG[PSW] = S_REG[FEPSW];
	} else { 	//Read the EI Reg Interupt
		PC = S_REG[EIPC];
		S_REG[PSW] = S_REG[EIPSW];
	}
}

void ins_halt(int arg1, int tos2, int tos3) {
	//dtprintf(6,ferr,"\nUnhandled opcode! halt");
}
void ins_ldsr(int arg1, int arg2, int tos3) { //Mode 2, seems to be broken!!!!
	//dtprintf(6,ferr,"\nUnhandled opcode! ldsr");
	S_REG[arg1] = P_REG[arg2];  										//Bug
}
void ins_stsr(int arg1, int arg2, int tos3) {
	P_REG[arg1] = S_REG[arg2];
}
void ins_di(int arg1, int arg2, int tos3) {
	S_REG[PSW] = S_REG[PSW] | PSW_ID;
}
void ins_bstr(int arg1, int arg2, int tos3) { //Special BitString
	(*bssuboptable[arg2].func)(arg1, 0, 0);
}
void ins_movea(int arg1, int arg2, int arg3) {  //Mode 5/6
	P_REG[arg3] = P_REG[arg2] + sign_16(arg1);
}
void ins_addi(int arg1, int arg2, int arg3) {
	int flags = 0;
	INT64 temp = P_REG[arg2] + sign_16(arg1);
	// Set Flags
	if ((long)temp == 0) flags = flags | PSW_Z;
	if ((long)temp & 0x80000000)  flags = flags | PSW_S;
	if (((P_REG[arg2]^(~sign_16(arg1)))&(P_REG[arg2]^temp))&0x80000000) flags = flags | PSW_OV;
	if (temp != ((long)temp)) flags = flags | PSW_CY;

	//if ((temp >> 32)!=0) flags = flags | PSW_OV;
	//if((temp >> 32) == 1) flags = flags | PSW_CY; // New

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
	P_REG[arg3] = (long)temp;
}
void ins_jr(int arg1, int tos2, int tos3) {   //Mode 4
	//if(arg1 & 0x02000000) arg1 +=0xFC000000;
	PC += (sign_26(arg1) & 0xFFFFFFFE);
}
void ins_jal(int arg1, int tos2, int tos3) {
	P_REG[31]=PC+4;
	PC += (sign_26(arg1) & 0xFFFFFFFE);
}
void ins_ori(int arg1, int arg2, int arg3) {	   //Mode 5/6
	int flags = 0;
	P_REG[arg3] = arg1 | P_REG[arg2];
	// Set Flags
	if (P_REG[arg3] == 0) flags = flags | PSW_Z;
	if (P_REG[arg3] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_andi(int arg1, int arg2, int arg3) {
	int flags = 0;
	P_REG[arg3] = (arg1 & P_REG[arg2]);
	// Set Flags
	if (P_REG[arg3] == 0) flags = (flags | PSW_Z);
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_xori(int arg1, int arg2, int arg3) {
	int flags = 0;
	P_REG[arg2] = arg1 ^ P_REG[arg2];
	// Set Flags
	if (P_REG[arg2] == 0) flags = flags | PSW_Z;
	if (P_REG[arg2] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & (0xFFFFFFF0|PSW_CY))|flags;
}
void ins_movhi(int arg1, int arg2, int arg3) {
	P_REG[arg3] = (arg1 << 16) + P_REG[arg2];
}
void ins_ld_b(int arg1, int arg2, int arg3) {
	P_REG[arg3] = sign_8(mem_rbyte(sign_16(arg1)+P_REG[arg2]));
}
void ins_ld_h(int arg1, int arg2, int arg3) {
	P_REG[arg3] = sign_16(mem_rhword((sign_16(arg1)+P_REG[arg2]) & 0xFFFFFFFE));
}
void ins_muli(int arg1, int arg2, int arg3) {
	INT64 temp= (INT64)P_REG[arg1] * (INT64)sign_16(arg3);
	//P_REG[30]   = temp >> 32;
	// Set Flags
	if ( (long)temp != temp) {
		S_REG[PSW] = S_REG[PSW] | PSW_SAT;
	}
	P_REG[arg2] = (long)temp;
}
void ins_ld_w(int arg1, int arg2, int arg3) {
	P_REG[arg3] = mem_rword((sign_16(arg1)+P_REG[arg2]) & 0xFFFFFFFC);
}
void ins_st_b(int arg1, int arg2, int arg3) {
	mem_wbyte(sign_16(arg2)+P_REG[arg3],P_REG[arg1]&0xFF);
}
void ins_st_h(int arg1, int arg2, int arg3) {
	mem_whword((sign_16(arg2)+P_REG[arg3])&0xFFFFFFFE,P_REG[arg1]&0xFFFF);
}
void ins_maci(int arg1, int arg2, int arg3) {
	//dtprintf(6,ferr,"\nUnhandled opcode! maci");
}
void ins_st_w(int arg1, int arg2, int arg3) {
	mem_wword((sign_16(arg2)+P_REG[arg3])&0xFFFFFFFC,P_REG[arg1]);
}
void ins_in_b(int arg1, int arg2, int arg3) {
	P_REG[arg3] = port_rbyte(sign_16(arg1)+P_REG[arg2]);
}
void ins_in_h(int arg1, int arg2, int arg3) {
	P_REG[arg3] = port_rhword((sign_16(arg1)+P_REG[arg2]) & 0xFFFFFFFE);
}
void ins_caxi(int arg1, int arg2, int arg3) {
	//dtprintf(6,ferr,"\nUnhandled opcode! caxi");
}
void ins_in_w(int arg1, int arg2, int arg3) {
	P_REG[arg3] = port_rword((sign_16(arg1)+P_REG[arg2]) & 0xFFFFFFFC);
}
void ins_out_b(int arg1, int arg2, int arg3) {
	port_wbyte(sign_16(arg2)+P_REG[arg3],P_REG[arg1]&0xFF);
}
void ins_out_h(int arg1, int arg2, int arg3) {
	port_whword((sign_16(arg2)+P_REG[arg3])&0xFFFFFFFE,P_REG[arg1]&0xFFFF);
}
void ins_fpp(int arg1, int arg2, int arg3) { //Special
	(*fpsuboptable[arg3].func)(arg1, arg2, 0);
}
void ins_out_w(int arg1, int arg2, int arg3) {
	port_wword((sign_16(arg2)+P_REG[arg3])&0xFFFFFFFC,P_REG[arg1]);
}

void ins_bv(int arg1, int arg2, int tos3) { //Branch Inst (Mode3)
	if(S_REG[PSW]&PSW_OV) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bl(int arg1, int arg2, int tos3) {
	if(S_REG[PSW]&PSW_CY) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_be(int arg1, int arg2, int tos3) {
	if(S_REG[PSW]&PSW_Z) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bnh(int arg1, int arg2, int tos3) {
	if((S_REG[PSW]&PSW_Z)||(S_REG[PSW]&PSW_CY)) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bn(int arg1, int arg2, int tos3) {
	if(S_REG[PSW]&PSW_S) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_br(int arg1, int arg2, int tos3) {
	PC += (sign_9(arg1) & 0xFFFFFFFE);
}
void ins_blt(int arg1, int arg2, int tos3) {
	if((!!(S_REG[PSW]&PSW_S))^(!!(S_REG[PSW]&PSW_OV))) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_ble(int arg1, int arg2, int tos3) {
	if(((!!(S_REG[PSW]&PSW_S))^(!!(S_REG[PSW]&PSW_OV)))||(S_REG[PSW]&PSW_Z)) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bnv(int arg1, int arg2, int tos3) {
	if(!(S_REG[PSW]&PSW_OV)) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bnl(int arg1, int arg2, int tos3) {
	if(!(S_REG[PSW]&PSW_CY)) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bne(int arg1, int arg2, int tos3) {
	if((S_REG[PSW]&PSW_Z) == PSW_Z) {
		PC +=2;
	} else {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	}
}
void ins_bh(int arg1, int arg2, int tos3) {
	if(!((S_REG[PSW]&PSW_Z)||(S_REG[PSW]&PSW_CY))) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bp(int arg1, int arg2, int tos3) {
	if(!(S_REG[PSW] & PSW_S)) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_nop(int arg1, int arg2, int tos3) {
	//Its a NOP do nothing =)
	PC +=2;
}
void ins_bge(int arg1, int arg2, int tos3) {
	if(!((!!(S_REG[PSW]&PSW_S))^(!!(S_REG[PSW]&PSW_OV)))) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
void ins_bgt(int arg1, int arg2, int tos3) {
	if(!(((!!(S_REG[PSW]&PSW_S))^(!!(S_REG[PSW]&PSW_OV)))||(S_REG[PSW]&PSW_Z))) {
		PC += (sign_9(arg1) & 0xFFFFFFFE);
	} else {
		PC +=2;
	}
}
*/

//Bitstring routines, wrapper functions for bitstring instructions!
void get_bitstr(WORD *str, WORD src, WORD srcoff, WORD len) {
	WORD i=0,tword,tmp;

	memset(str,0,(((len>>5)+1)<<2)); //clear bitstring data

	tmp = ((i+srcoff)>>5);
	tword = mem_rword(src+(tmp<<2));
	while (i < len) {
		if (((i+srcoff)>>5) != tmp) {
			tmp = ((i+srcoff)>>5);
			tword = mem_rword(src+(tmp<<2));
		}
		str[i>>5] |= (((tword >> ((srcoff+i)&0x1F)) & 1) << (i&0x1F));
		i++;
	}
}
void set_bitstr(WORD *str, WORD dst, WORD dstoff, WORD len) {
	WORD i=0,tword,tmp;

	tmp = ((i+dstoff)>>5);
	tword = mem_rword(dst+(tmp<<2));
	while (i < len) {
		if (((i+dstoff)>>5) != tmp) {
			tmp = ((i+dstoff)>>5);
			tword = mem_rword(dst+(tmp<<2));
		}
		tword &= (~(1<<((dstoff+i)&0x1F)));
		tword |= (((str[i>>5]>>(i&0x1F))&1)<<((dstoff+i)&0x1F));
		i++;
		if (!((i+dstoff)&0x1F)) mem_wword(dst+(tmp<<2),tword);
	}
	mem_wword(dst+(tmp<<2),tword);

}

//Bitstring SubOpcodes
void ins_sch0bsu (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	dtprintf(10,ferr,"\nSCH0BSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);
}
void ins_sch0bsd (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	dtprintf(10,ferr,"\nSCH0BSD, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);
}
void ins_sch1bsu (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	dtprintf(10,ferr,"\nSCH1BSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);
}
void ins_sch1bsd (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	dtprintf(10,ferr,"\nSCH1BSD, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);
}
void ins_orbsu   (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	//dtprintf(10,ferr,"\nORBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] |= tmp2[i];
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_andbsu  (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	//dtprintf(10,ferr,"\nANDBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] &= tmp2[i];
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_xorbsu  (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	dtprintf(10,ferr,"\nXORBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] ^= tmp2[i];
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_movbsu  (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD tmp[8192];

	//dtprintf(10,ferr,"\nMOVBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	set_bitstr(tmp,dst,dstoff,len);

/*
	WORD l_wSourceAddress = P_REG[30]&0xFFFFFFFC;
	WORD l_wSourceBitOffset = P_REG[26]&0x1C;
	WORD l_wDestinationAddress = P_REG[29]&0xFFFFFFFC;
	WORD l_wDestinationBitOffset = P_REG[27]&0x1C;
	WORD l_wCountofBits = P_REG[28];

	// variables that get set each time through the loop.
	WORD l_wBitsToTransfer;

	WORD l_wSourceData;
	WORD l_wDestinationData;

	WORD l_wSourceMask;
	WORD l_wDestinationMask;

dtprintf(6,ferr,"\nMove BITSTR, sAddr: %04x, sOff: %04x, dAddr: %04x, dOff: %04x, Count: %04x",l_wSourceAddress,l_wSourceBitOffset,l_wDestinationAddress,l_wDestinationBitOffset,l_wCountofBits);

dtprintf(6,ferr,"\nUnhandled opcode! movbsu");

	while(0) {
	// We can only transfer the greatest starting bit offset worth of bits at a time.
//	while (l_wCountofBits) {// While more bits
		// In the case where the two bit offsets are identical,
		// letting the else handle it is not bad.
		if (l_wSourceBitOffset > l_wDestinationBitOffset) {
			l_wBitsToTransfer = 32 - l_wSourceBitOffset;
		} else {
			l_wBitsToTransfer = 32 - l_wDestinationBitOffset;
		}
		// First, retrieve the source data and destination data
		l_wSourceData = mem_rword(l_wSourceAddress);
		l_wDestinationData = mem_rword(l_wDestinationAddress);

		// Build masks so that we only affect the bits to be transfered.
		l_wSourceMask = ((0xFFFFFFFF >> l_wBitsToTransfer) << l_wSourceBitOffset);
		l_wDestinationMask = !((0xFFFFFFFF >> l_wBitsToTransfer) << l_wDestinationBitOffset);

		// Mask off (clear) the bits in the desintation data.
		// Clear anything we aren't using in the source
		l_wDestinationData &= l_wDestinationMask;
		l_wSourceData &= l_wSourceMask;

		// Now fix it so that the bit windows line up.
		if (l_wSourceBitOffset != l_wDestinationBitOffset) {// if they are unaligned
			if (l_wSourceBitOffset > l_wDestinationBitOffset) {
				l_wSourceData >>= l_wSourceBitOffset - l_wDestinationBitOffset;
			} else {
				l_wSourceData <<= l_wSourceBitOffset - l_wDestinationBitOffset;
			}
		}// end unaligned

		// Instruction specific code. Replace this with each operations' appropriate code
		l_wDestinationData |= l_wSourceData; // That'll move it over.
		// End instruction specific code

		mem_wword(l_wDestinationAddress, l_wDestinationData);

		// Then, update the bit offsets, addresses,
		// The one we used as bits to transfer now aligns on a word.
		l_wDestinationBitOffset += l_wBitsToTransfer;
		if (l_wDestinationBitOffset > 31) {
			l_wSourceBitOffset -= 31;
			l_wDestinationAddress++;
		}

		l_wSourceBitOffset += l_wBitsToTransfer;
		if (l_wSourceBitOffset > 31) {
			l_wSourceBitOffset -= 31;
			l_wSourceAddress++;
		}
		// and reduce the count of bits approriately.
		l_wCountofBits -= l_wBitsToTransfer;
	}// end more bits
*/
}
void ins_ornbsu  (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	dtprintf(10,ferr,"\nORNBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] = (~tmp[i] | tmp2[i]);
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_andnbsu (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	dtprintf(10,ferr,"\nANDNBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] = (~tmp[i] & tmp2[i]);
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_xornbsu (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192],tmp2[8192];

	dtprintf(10,ferr,"\nXORNBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	get_bitstr(tmp2,dst,dstoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] = (~tmp[i] ^ tmp2[i]);
	set_bitstr(tmp,dst,dstoff,len);
}
void ins_notbsu  (int arg1, int arg2, int arg3) {
	WORD dstoff = (P_REG[26] & 0x1F);
	WORD srcoff = (P_REG[27] & 0x1F);
	WORD len =     P_REG[28];
	WORD dst =    (P_REG[29] & 0xFFFFFFFC);
	WORD src =    (P_REG[30] & 0xFFFFFFFC);

	WORD i,tmp[8192];

	dtprintf(10,ferr,"\nNOTBSU, len: %08X, src: %08X, srcoff: %08X, dst: %08X, dstoff: %08X",len,src,srcoff,dst,dstoff);

	get_bitstr(tmp,src,srcoff,len);
	for (i = 0; i < ((len>>5)+1); i++) tmp[i] = ~tmp[i];
	set_bitstr(tmp,dst,dstoff,len);
}

//FPU SubOpcodes
//How do we convert from INT to Float without changing the Number (BitWise)?
void ins_cmpf_s  (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, OV set to Zero
	double temp = (double)(*((float *)&P_REG[arg1])) - (double)(*((float *)&P_REG[arg2]));

	if (temp == 0.0F) flags = flags | PSW_Z;
	if (temp < 0.0F)  flags = flags | PSW_S;
	if (temp > ((float)temp)) flags = flags | PSW_CY; //How???
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;
}
void ins_cvt_ws  (int arg1, int arg2, int arg3) {   //Int to Float
	int flags = 0; // Set Flags, OV set to Zero
	float temp = (float)((long)P_REG[arg2]);

	if (temp == 0) flags = flags | PSW_Z;
	if (temp < 0.0F)  flags = flags | PSW_S;
	if (P_REG[arg2] != temp) flags = flags | PSW_CY; //How???
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;

	P_REG[arg1] = *((WORD *)&temp);
}
void ins_cvt_sw  (int arg1, int arg2, int arg3) {  //Float To Int
	int flags = 0; // Set Flags, CY unchanged, OV set to Zero
	P_REG[arg1] = (long)(*((float *)&P_REG[arg2])+0.5F);

	if (P_REG[arg1] == 0) flags = flags | PSW_Z;
	if (P_REG[arg1] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF7)|flags;
}
void ins_addf_s  (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, OV set to Zero
	float temp2;
	double temp = (double)(*((float *)&P_REG[arg1])) + (double)(*((float *)&P_REG[arg2]));

	if (temp == 0.0F) flags = flags | (PSW_Z | PSW_CY);  //changed by frostgiant based on NEC docs
	if (temp < 0.0F)  flags = flags | PSW_S;

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;

    temp2 = ((float)temp);
	P_REG[arg1] = *((WORD *)&temp2);
}
void ins_subf_s  (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, OV set to Zero
	float temp2;
	double temp = (double)(*((float *)&P_REG[arg1])) - (double)(*((float *)&P_REG[arg2]));

	if (temp == 0.0F) flags = flags | (PSW_Z | PSW_CY);  //changed by frostgiant based on NEC docs
	if (temp < 0.0F)  flags = flags | PSW_S;

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;

    temp2 = ((float)temp);
	P_REG[arg1] = *((WORD *)&temp2);
}
void ins_mulf_s  (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, OV set to Zero
	float temp2;
	double temp = (double)(*((float *)&P_REG[arg1])) * (double)(*((float *)&P_REG[arg2]));

	if (temp == 0.0F) flags = flags | (PSW_Z | PSW_CY);  //changed by frostgiant based on NEC docs
	if (temp < 0.0F)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;

    temp2 = ((float)temp);
	P_REG[arg1] = *((WORD *)&temp2);
}
void ins_divf_s  (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, OV set to Zero
	float temp2;
	double temp = (double)(*((float *)&P_REG[arg1])) / (double)(*((float *)&P_REG[arg2]));

	if (temp == 0.0F) flags = flags | (PSW_Z | PSW_CY);  //changed by frostgiant based on NEC docs
	if (temp < 0.0F)  flags = flags | PSW_S;

	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF0)|flags;

	temp2 = ((float)temp);
	P_REG[arg1] = *((WORD *)&temp2);
}
void ins_trnc_sw (int arg1, int arg2, int arg3) {
	int flags = 0; // Set Flags, CY unchanged, OV set to Zero
	P_REG[arg1] = (WORD)(*((float *)&P_REG[arg2])+0.5F);

	if (!P_REG[arg1]) flags = flags | PSW_Z;
	if (P_REG[arg1] & 0x80000000)  flags = flags | PSW_S;
	S_REG[PSW] = (S_REG[PSW] & 0xFFFFFFF7)|flags;
}

void ins_xb       (int arg1, int arg2, int arg3) {
	if (arg2) dtprintf(0,ferr,"\nXB Instruction, arg2 = r%d",arg2);
	P_REG[arg1] = ((P_REG[arg1]&0xFFFF0000) | (((P_REG[arg1]<<8)&0xFF00) | ((P_REG[arg1]>>8)&0xFF)));
}

void ins_xh       (int arg1, int arg2, int arg3) {
	if (arg2) dtprintf(0,ferr,"\nXH Instruction, arg2 = r%d",arg2);
	P_REG[arg1] = (P_REG[arg1]<<16)|(P_REG[arg1]>>16);
}

void ins_rev      (int arg1, int arg2, int arg3) {
	WORD temp = 0;
	int i;

	for (i = 0; i < 32; i++) temp = ((temp << 1) | ((P_REG[arg2] >> i) & 1));
	P_REG[arg1] = temp;
}

void ins_mpyhw    (int arg1, int arg2, int arg3) {
	if (P_REG[arg1] & 0xFFFF0000) dtprintf(0,ferr,"\nMPYHW Instruction, arg1 = %08X",P_REG[arg1]);
	if (P_REG[arg2] & 0xFFFF0000) dtprintf(0,ferr,"\nMPYHW Instruction, arg2 = %08X",P_REG[arg2]);
	P_REG[arg1] = P_REG[arg1] * P_REG[arg2];
}
