#define CHEAT5000
//#define LIGHTGUN 1
//#define USE_DEBUGCLIENT
//#define NO_CONFIGURATION
//#define SUPPORT_4X
#define USE4X_BLITBUF
#define USE_NETPLAY
//#define DEBUG_KEYBOARD
#define DEBUG_MOUSE 
#define GAMEBASE

#include <xtl.h>
#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
//#include "CDDAXbox.h"
#include <stdio.h>
#include <vector>
#include "zlib.h"
#include "unzip.h"
#include "debugclient.h"
#include "Mp3Player.h"
#include <XBSound.h>
#include "undocumented.h"
#include "iosupport.h"
#include "panel.h"
#include "fonthelper.h"
#include "plaything.h"
#include "smb++.h"
#include "custom_launch_params.h"
#include "colormap.h"
#include "arrow.h"
#include "numpad.h"
#include "numpadg.h"
#include "png.h"
#include "gamescreen.h"
#include "keyboard_api.h"
#include "mouse.h"

#ifdef LIGHTGUN
#include "lightgun.h"
#endif



#ifdef __cplusplus
extern "C" {
#endif

#include "video.h"
#include "videoarch.h"
#include "kbd.h"
#include "machine.h"
#include "autostart.h"
#include "maincpu.h"
#include "vsync.h"
#include "sound.h"
#include "resources.h"
#include "interrupt.h"
#include "imagecontents.h"

extern BYTE mem_ram[0x10000];
extern unsigned char WINPOS_VKM[] ;
unsigned char DOS2031_ROM[] = { 0 } ;

int vdrive_internal_create_format_disk_image(const char *filename, const char *diskname, unsigned int type);
void keyboard_clear_keymatrix();
void cartridge_trigger_freeze();
void cartridge_detach_image(void);
int tape_image_detach(unsigned int unit);
int file_system_attach_disk(unsigned int unit, const char *filename);
int set_warp_mode(resource_value_t v, void *param) ;
void file_system_detach_disk(int unit);
int cartridge_attach_image(int type, const char *filename);

extern int gAllDone ;

int main_program(int argc, char **argv) ;

void xbox_set_RAM_location( char *ptr) ;

#include "writepng.h"

int Init_2xSaI(uint32 BitFormat);

void _2xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void _2xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagle(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagleScanline(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super2xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super2xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Scale2x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScale(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScaleScanline(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Eagle(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void EagleScanline(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);

void Simple2x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanlines) ;
void AdMame2x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanline) ;


unsigned int xbox_get_pitch();
unsigned char * xbox_get_screen_buffer() ;
int xbox_read_sector_type( unsigned int sector, unsigned int sector_type ) ;
void sprintfx( const char *fmt, ... );
//extern int iFastFwd ;
//int LoadState(char *file) ;
//int SaveState(char *file) ;
//extern int Running;
//int psx_WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) ;

//_CRTIMP extern int * __cdecl errno(void);
char gxmsg[2050] ;

//int errno ;
int throttle ;
int need_full_redraw = 0 ;

#ifdef __cplusplus
}
#endif

//_CRTIMP int * __cdecl _errno(void);
//_CRTIMP int errno;

#pragma warning(disable:4244)
#pragma warning(disable:4018)
#pragma warning(disable:4101)



#define PLATFORM_NAME "C64"
#define PLATFORM_SAV L"C64SAV"
#define READING_ROMS_STRING L"Reading c64disks directory...please wait."
#define PLATFORM_INI "vice64x.ini"
#define PLAYTHING_INI "plaything.cfg"
//#define PLATFORM_MEMORY_POINTER internalRAM
#define PLATFORM_MEMORY_POINTER mem_ram
#define THEMEMUSIC "D:\\VICE64XTHEME.MP3"
#define PLATFORM_FILE_DIR m_defaultRomDir
//#define CONSOLE_MEMORY_SIZE 0x8000
#define CONSOLE_MEMORY_SIZE 0x10000
#define DEFAULT_PARENT_DIR "D:\\c64disks\\*"
#define CD_BUF_SECTORS 1
#define CD_DATA_BUFFER_SIZE CD_BUF_SECTORS*2352
#define PROJECTILE_DEF 4 
#define DEFAULT_SKIN "default_vice64x"
#define DEFAULT_SKIN_DIR "D:\\EMUSKINS"
#define MAIN_MENU_STRING L"Vice64X Main Menu"
#define MLINE 
#define DEFAULT_SAVE_PATH "E:\\SAVES\\VICE64X"
//#define GAME_GENIE 1
#define EMU_RECORDING_SIZE ( sizeof(DWORD)*4*60*60*10 )


int CODE_LENGTHS[] = { 12  } ;


unsigned char *m_memory_locations[] = { mem_ram  } ;
unsigned int  m_memory_sizes[] = { 0x10000 } ;

#define NUM_MEMORY_LOCATIONS 1

byte keyboard_keystate[256] ;

typedef struct _gamebaseentry
{
	char *name ;
	char *filename ;
	unsigned int uk ;
} GAMEBASE_ENTRY ;


struct { char *keyname ; int keynum ; } validKeystrokes[75] = 
{
	{ "Space", 0x20 },
	{ "Enter", 0x0D },
	{ "Backspace", 0x08 },
	{ "Tab", 0x09 },
	{ "Escape", 0x1B },
	{ "PgUp", 0x21 },
	{ "PgDn", 0x22 },
	{ "End", 0x23 },
	{ "Home", 0x24 },
	{ "Left", 0x25 },
	{ "Up", 0x26 },
	{ "Right", 0x27 },
	{ "Down", 0x28 },
	{ "Insert", 0x2d },
	{ "Delete", 0x2e },
	{ "0", 0x30 },
	{ "1", 0x31 },
	{ "2", 0x32 },
	{ "3", 0x33 },
	{ "4", 0x34 },
	{ "5", 0x35 },
	{ "6", 0x36 },
	{ "7", 0x37 },
	{ "8", 0x38 },
	{ "9", 0x39 },
	{ "A", 0x41 },
	{ "B", 0x42 },
	{ "C", 0x43 },
	{ "D", 0x44 },
	{ "E", 0x45 },
	{ "F", 0x46 },
	{ "G", 0x47 },
	{ "H", 0x48 },
	{ "I", 0x49 },
	{ "J", 0x4A },
	{ "K", 0x4B },
	{ "L", 0x4C },
	{ "M", 0x4D },
	{ "N", 0x4E },
	{ "O", 0x4F },
	{ "P", 0x50 },
	{ "Q", 0x51 },
	{ "R", 0x52 },
	{ "S", 0x53 },
	{ "T", 0x54 },
	{ "U", 0x55 },
	{ "V", 0x56 },
	{ "W", 0x57 },
	{ "X", 0x58 },
	{ "Y", 0x59 },
	{ "Z", 0x5A },
	{ "F1", 0x70 },
	{ "F2", 0x71 },
	{ "F3", 0x72 },
	{ "F4", 0x73 },
	{ "F5", 0x74 },
	{ "F6", 0x75 },
	{ "F7", 0x76 },
	{ "F8", 0x77 },
	{ "F9", 0x78 },
	{ "F10", 0x79 },
	{ "LShift", 0xA0 },
	{ "RShift", 0xA1 },
	{ "LCtrl", 0xA2 },
	{ "RCtrl", 0xA3 },
	{ ";", 0xBA },
	{ "+", 0xBB },
	{ ",", 0xBC },
	{ "-", 0xBD },
	{ ".", 0xBE },
	{ "/", 0xBF },
	{ "[", 0xDB },
	{ "\\", 0xDC },
	{ "]", 0xDD },
	{ "'", 0xDE }
} ;


typedef struct
{

	unsigned int mapping ;
	unsigned int moves[32] ;
	unsigned char endmove ;
	unsigned char delay ;
	unsigned char currmove ;
	unsigned char currdelay ;
} COMBO ;

typedef struct
{
	unsigned int analog_sensitivity ;
	unsigned int emu_buttons[32] ;
	unsigned char emu_buttons_autofire[32] ;
	unsigned char emu_buttons_autofire_last[32] ;
	unsigned int emu_buttons_definition[32] ;
	unsigned int sfx_vol_up ;
	unsigned int sfx_vol_down ;
	unsigned int bgm_vol_up ;
	unsigned int bgm_vol_down ;
	unsigned int throttle ;
	unsigned int save_state ;
	unsigned int load_state ;
	unsigned int change_save_slot ;
	unsigned int screenshot ;
	unsigned int options_menu ;
	unsigned int change_gfx_filter;
	unsigned int toggle_bgm ;
	unsigned int start_recording ;
	unsigned int stop_recording ;
	unsigned int start_playing ;
	unsigned int stop_playing ;
	unsigned int capture_mode ;
	unsigned int virtual_keyboard ;
	COMBO combos[10] ;

} MAPPINGS ;

typedef struct _PLAYTHING_CONFIG
{
	SPRITE_PARAMS sprites[20] ;
	EFFECT_PARAMS effects[3] ;

} PLAYTHING_CONFIG ;

typedef struct _MENU_PARAMS
{
	char bkg[100] ;
	CPanel *panel ;
	int  transparency ;
	int  borderWidth ;
	int  halign ;
	int  valign ;
	int  offsetx ;
	int  offsety ;
	int  maxTextWidth ;
	int  maxNumLines ;
	DWORD normalColor ;
	DWORD selectedColor ;
	DWORD selectedAndNotedColor ;
	DWORD notedColor ;
	DWORD selectBarColor ;
	unsigned int  size ;
	unsigned int  lineHeight; 
	int screenshotX ;
	int screenshotY ;
	int screenshotW ;
	int screenshotH ;
	int screenshotTransparency ;
	int animationDelay ;

	PLAYTHING_CONFIG ptConfig ;

} MENU_PARAMS ;

typedef struct _SKIN_PARAMS
{
	char loadEmuSplash[100] ;
	char loadGameSplash[100] ;
	char menuMoveSound[100] ;
	char menuCancelSound[100] ;
	char menuSelectSound[100] ;
	char menuBkgMusic[100] ;
	char font[100] ;
	int  fade ;
	int  transition ;
	int  loopbgm ;

	MENU_PARAMS mainMenu ;
	MENU_PARAMS gameSelectMenu ;
	MENU_PARAMS otherMenu ;
	MENU_PARAMS popupMenu ;
	MENU_PARAMS loadingMenu ;

} SKIN_PARAMS ;

typedef struct _BUTTON_DEFINITION
{
	char name[40] ;
	unsigned int  value ;
} BUTTON_DEFINITION ;


#define XBOX_DPAD_UP          0x00000001
#define XBOX_DPAD_DOWN        0x00000002
#define XBOX_DPAD_LEFT        0x00000004
#define XBOX_DPAD_RIGHT       0x00000008
#define XBOX_START            0x00000010
#define XBOX_BACK             0x00000020
#define XBOX_LEFT_THUMB       0x00000040
#define XBOX_RIGHT_THUMB      0x00000080

#define XBOX_A                0x00000100
#define XBOX_B                0x00000200
#define XBOX_X                0x00000400
#define XBOX_Y                0x00000800
#define XBOX_BLACK            0x00001000
#define XBOX_WHITE            0x00002000
#define XBOX_LEFT_TRIGGER     0x00004000
#define XBOX_RIGHT_TRIGGER    0x00008000

#define XBOX_LTHUMB_UP        0x00010000
#define XBOX_LTHUMB_DOWN      0x00020000
#define XBOX_LTHUMB_LEFT      0x00040000
#define XBOX_LTHUMB_RIGHT     0x00080000

#define XBOX_RTHUMB_UP        0x00100000
#define XBOX_RTHUMB_DOWN      0x00200000
#define XBOX_RTHUMB_LEFT      0x00400000
#define XBOX_RTHUMB_RIGHT     0x00800000


	BUTTON_DEFINITION g_xboxButtonDefinitions[] = {
		{ "DPad Up", XBOX_DPAD_UP },
		{ "DPad Down", XBOX_DPAD_DOWN },
		{ "DPad Left", XBOX_DPAD_LEFT },
		{ "DPad Right", XBOX_DPAD_RIGHT },
		{ "Start", XBOX_START },
		{ "Back", XBOX_BACK },
		{ "Left Thumb", XBOX_LEFT_THUMB },
		{ "Right Thumb", XBOX_RIGHT_THUMB },
		{ "A", XBOX_A },
		{ "B", XBOX_B },
		{ "X", XBOX_X },
		{ "Y", XBOX_Y },
		{ "Black", XBOX_BLACK },
		{ "White", XBOX_WHITE },
		{ "LTrigger", XBOX_LEFT_TRIGGER },
		{ "RTrigger", XBOX_RIGHT_TRIGGER },
		{ "LThumb Up", XBOX_LTHUMB_UP },
		{ "LThumb Down", XBOX_LTHUMB_DOWN },
		{ "LThumb Left", XBOX_LTHUMB_LEFT },
		{ "LThumb Right", XBOX_LTHUMB_RIGHT },
		{ "RThumb Up", XBOX_RTHUMB_UP },
		{ "RThumb Down", XBOX_RTHUMB_DOWN },
		{ "RThumb Left", XBOX_RTHUMB_LEFT },
		{ "RThumb Right", XBOX_RTHUMB_RIGHT },
		{ "Nothing", 0 },
	} ;

#define NUM_XBOX_BUTTONS ( sizeof( g_xboxButtonDefinitions ) / sizeof(BUTTON_DEFINITION) )


#define VK_BACK           0x08
#define VK_TAB            0x09

#define VK_CLEAR          0x0C
#define VK_RETURN         0x0D
#define VK_SHIFT          0x10
#define VK_CONTROL        0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL        0x14

#define VK_ESCAPE         0x1B


#define VK_SPACE          0x20
#define VK_PRIOR          0x21
#define VK_NEXT           0x22
#define VK_END            0x23
#define VK_HOME           0x24
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28
#define VK_SELECT         0x29
#define VK_PRINT          0x2A
#define VK_INSERT         0x2D
#define VK_DELETE         0x2E
#define VK_HELP           0x2F



#define VK_MULTIPLY       0x6A
#define VK_ADD            0x6B
#define VK_SEPARATOR      0x6C
#define VK_SUBTRACT       0x6D
#define VK_DECIMAL        0x6E
#define VK_DIVIDE         0x6F
#define VK_F1             0x70
#define VK_F2             0x71
#define VK_F3             0x72
#define VK_F4             0x73
#define VK_F5             0x74
#define VK_F6             0x75
#define VK_F7             0x76
#define VK_F8             0x77

#define VK_LSHIFT         0xA0
#define VK_RSHIFT         0xA1
#define VK_LCONTROL       0xA2
#define VK_RCONTROL       0xA3
#define VK_OEM_1          0xBA   // ';:' for US
#define VK_OEM_PLUS       0xBB   // '+' any country
#define VK_OEM_COMMA      0xBC   // ',' any country
#define VK_OEM_MINUS      0xBD   // '-' any country
#define VK_OEM_PERIOD     0xBE   // '.' any country
#define VK_OEM_2          0xBF   // '/?' for US
#define VK_OEM_3          0xC0   // '`~' for US
#define VK_OEM_4          0xDB  //  '[{' for US
#define VK_OEM_5          0xDC  //  '\|' for US
#define VK_OEM_6          0xDD  //  ']}' for US
#define VK_OEM_7          0xDE  //  ''"' for US

#define JOY_UP           0x01
#define JOY_DOWN         0x02
#define JOY_LEFT         0x04
#define JOY_RIGHT        0x08
#define JOY_A            0x10
#define JOY_SWAP         0x100
#define CART_FREEZE      0x200


	BUTTON_DEFINITION g_emuButtonDefinitions[] = {
		{ "Up", JOY_UP },
		{ "Down", JOY_DOWN },
		{ "Left", JOY_LEFT },
		{ "Right", JOY_RIGHT },
		{ "Joystick Button", JOY_A },

	{ "Space", 0x80000000 | VK_SPACE },
	{ "Return", 0x80000000 | VK_RETURN },
	{ "Swap Joystick Ports", JOY_SWAP },
	{ "Cartridge Freeze", CART_FREEZE },
	{ "Del", 0x80000000 | VK_BACK },
	{ "F1", 0x80000000 | VK_F1 },
	{ "F2", 0x80000000 | VK_F2 },
	{ "F3", 0x80000000 | VK_F3 },
	{ "F4", 0x80000000 | VK_F4 },
	{ "F5", 0x80000000 | VK_F5 },
	{ "F6", 0x80000000 | VK_F6 },
	{ "F7", 0x80000000 | VK_F7 },
	{ "F8", 0x80000000 | VK_F8 },
	{ "0", 0x80000000 | '0' },
	{ "1", 0x80000000 | '1' },
	{ "2", 0x80000000 | '2' },
	{ "3", 0x80000000 | '3' },
	{ "4", 0x80000000 | '4' },
	{ "5", 0x80000000 | '5' },
	{ "6", 0x80000000 | '6' },
	{ "7", 0x80000000 | '7' },
	{ "8", 0x80000000 | '8' },
	{ "9", 0x80000000 | '9' },
	{ "A", 0x80000000 | 'A' },
	{ "B", 0x80000000 | 'B' },
	{ "C", 0x80000000 | 'C' },
	{ "D", 0x80000000 | 'D' },
	{ "E", 0x80000000 | 'E' },
	{ "F", 0x80000000 | 'F' },
	{ "G", 0x80000000 | 'G' },
	{ "H", 0x80000000 | 'H' },
	{ "I", 0x80000000 | 'I' },
	{ "J", 0x80000000 | 'J' },
	{ "K", 0x80000000 | 'K' },
	{ "L", 0x80000000 | 'L' },
	{ "M", 0x80000000 | 'M' },
	{ "N", 0x80000000 | 'N' },
	{ "O", 0x80000000 | 'O' },
	{ "P", 0x80000000 | 'P' },
	{ "Q", 0x80000000 | 'Q' },
	{ "R", 0x80000000 | 'R' },
	{ "S", 0x80000000 | 'S' },
	{ "T", 0x80000000 | 'T' },
	{ "U", 0x80000000 | 'U' },
	{ "V", 0x80000000 | 'V' },
	{ "W", 0x80000000 | 'W' },
	{ "X", 0x80000000 | 'X' },
	{ "Y", 0x80000000 | 'Y' },
	{ "Z", 0x80000000 | 'Z' },
	{ "Run Stop", 0x80000000 | VK_ESCAPE },
	{ "Restore", 0x80000000 | VK_PRIOR },
	{ "Clear/Home", 0x80000000 | VK_HOME },
	{ "Cursor Up", 0x80000000 | VK_UP },
	{ "Cursor Down", 0x80000000 | VK_DOWN },
	{ "Cursor Left", 0x80000000 | VK_LEFT },
	{ "Cursor Right", 0x80000000 | VK_RIGHT },
	{ "Pound", 0x80000000 | VK_INSERT },
	{ "Up Arrow", 0x80000000 | VK_DELETE },
	{ "Left Arrow", 0x80000000 | VK_OEM_3 },
	{ "Left Shift", 0x80000000 | VK_LSHIFT },
	{ "Right Shift", 0x80000000 | VK_RSHIFT },
	{ "CBM Key", 0x80000000 | VK_LCONTROL },
	{ "Ctrl", 0x80000000 | VK_TAB },
	{ "Colon", 0x80000000 | VK_OEM_1 },
	{ "Minus", 0x80000000 | VK_OEM_PLUS },
	{ "Comma", 0x80000000 | VK_OEM_COMMA },
	{ "Plus", 0x80000000 | VK_OEM_MINUS },
	{ "Period", 0x80000000 | VK_OEM_PERIOD },
	{ "Slash", 0x80000000 | VK_OEM_2 },
	{ "At Sign", 0x80000000 | VK_OEM_4 },
	{ "Equals", 0x80000000 | VK_OEM_5 },
	{ "Star", 0x80000000 | VK_OEM_6 },
	{ "Semicolon", 0x80000000 | VK_OEM_7 },
	{ "Nothing", 0 },
	} ;

#define NUM_EMU_BUTTONS ( sizeof( g_emuButtonDefinitions ) / sizeof(BUTTON_DEFINITION) )

#define DEFAULT_BUTTON1  XBOX_DPAD_UP
#define DEFAULT_BUTTON2  XBOX_DPAD_DOWN
#define DEFAULT_BUTTON3  XBOX_DPAD_LEFT
#define DEFAULT_BUTTON4  XBOX_DPAD_RIGHT
#define DEFAULT_BUTTON5  XBOX_A
#define DEFAULT_BUTTON6  XBOX_B
#define DEFAULT_BUTTON7  XBOX_Y
#define DEFAULT_BUTTON8  XBOX_LEFT_TRIGGER
#define DEFAULT_BUTTON9  XBOX_WHITE
#define DEFAULT_BUTTON10 0
#define DEFAULT_BUTTON11 0
#define DEFAULT_BUTTON12 0
#define DEFAULT_BUTTON13 0
#define DEFAULT_BUTTON14 0
#define DEFAULT_BUTTON15 0
#define DEFAULT_BUTTON16 0
#define DEFAULT_BUTTON17 0
#define DEFAULT_BUTTON18 0
#define DEFAULT_BUTTON19 0
#define DEFAULT_BUTTON20 0
#define DEFAULT_BUTTON21 0
#define DEFAULT_BUTTON22 0
#define DEFAULT_BUTTON23 0
#define DEFAULT_BUTTON24 0
#define DEFAULT_BUTTON25 0
#define DEFAULT_BUTTON26 0
#define DEFAULT_BUTTON27 0
#define DEFAULT_BUTTON28 0
#define DEFAULT_BUTTON29 0
#define DEFAULT_BUTTON30 0
#define DEFAULT_BUTTON31 0
#define DEFAULT_BUTTON32 0

typedef struct _cheat_code { 
	char code[20] ;
	byte type ;
	UINT32 adr ;
	UINT32 val ;
	byte   enabled ;
	char desc[100] ;
} CHEAT_CODE;

typedef struct _NETPLAY_SERVER {
	char ip[16] ; 
} NETPLAY_SERVER;

typedef struct _favoritestruct {
	char filename[MAX_PATH] ;
} FAVORITE ;



//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual void    InitializeEmuSpecific();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx, int isFavorite, int forceConfig, int isGamebase ) ;
	virtual void    cleanupConsole( ) ;
	int             handleEvents( int port );
	virtual int     init_texture() ;
	virtual void    copyOldSaves() ;
	virtual BOOL    SetRefreshRate(INT iRefreshRate);
	virtual int		init_white_texture();
	virtual int		render_to_texture( video_canvas_t *canvas, int width,
                         int height, int xs, int ys, int xt, int yt, int fillbuff) ;
	virtual void	FindAvailRoms(char *dir) ;
	void            renderMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup ) ;
	int             renderMenuTextWrapper( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, CPanel *panel, int menuChoice, int dualColumn, int colSpacing ) ;
	void            renderDualMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, int colSpacing ) ;
	int             getValuePopup( char *title, int oldValue, int minval, int maxval, CPanel *panel );
	virtual void    doStartSearchMenu() ;
	virtual void	saveKeys( char *keyfile ) ;
	virtual void	loadKeys( char *keyfile ) ;
	virtual void    doCodeListMenu() ;
	virtual int     unzipC64( char *zipfile, char *newfilename );
	virtual int     receiveNetworkData( );
	virtual void    doChangeHWFilter() ;
	virtual void    applyGameGenie( byte *ROM, unsigned int romsize);
	virtual void    doChangeSWFilter() ;
#ifdef LIGHTGUN
	virtual void    doZapper();
	virtual void    doCalibrateLightgun() ;
#endif
	virtual void    doPlaythingClear( );
	virtual void    saveSettings( char *filename );
	virtual int     loadSettings( char *filename );
	virtual void    doAutofireConfig( int port );
	virtual void    doMainMenu() ;
	virtual int     encodeGameGenie( CHEAT_CODE *code ) ;
	virtual int     decodeGameGenie( CHEAT_CODE *code ) ;
	virtual int     validateCode( char *code, CHEAT_CODE *ccode, int codetype ) ;
	virtual void    checkGeneralEvents() ;
	void            loadMostRecentSaveState( );
	virtual void    loadControllerSettings( char *buf ) ;
	virtual void    saveControllerSettings( FILE *outfile ) ;
	virtual void    doManageCheatCode( int selected );
	virtual void    doConfigureSkin() ;
	virtual void    updateEmuSpecificCheats() ;
	virtual void    doBrowseScreenshots( ) ;
	virtual void    performEmuSpecificOption( int start, int menuChoice ) ;
	int             addEmuSpecificOptions( int start ) ;
	virtual int		showScreenshot( int screenNum, int currSelection, int onlyFavorites, MENU_PARAMS *menu, int isGamebase = 0  ) ;
	virtual void    saveGameSpecificSettings() ;
	virtual void    doDeleteCode( int selected );
	virtual void    doGraphicsFiltering() ;
	virtual void    doSelectColor( DWORD *pColor, MENU_PARAMS *menuParams );
	virtual void    doTransition( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
	virtual void    emuLaunch( unsigned int gameSelected, unsigned int isFavorite, int forceConfig, int isGamebase = 0 ) ;
	virtual void    getNewRoot( char *szRoot) ;
	unsigned int    getNewDefinition( unsigned int oldMapping );
	unsigned int    doSelectGame( int onlyFavorites, int canChangeDir, int getPath=0 ) ;
	virtual void    SetupPlaything( );
	virtual void    doLoadNewDisk( int which, int gamebase ) ;
	virtual void    xboxStartRecording() ;
	virtual void    xboxStopRecording() ;
	virtual void    xboxStartPlaying() ;
	virtual void    xboxStopPlaying() ;
	virtual void    xboxOptionsMenu() ;
	virtual void    doSelectBackground( char *bkgfile, CPanel *ppanel ) ;
	virtual void    doSelectSound( char *soundfile, CXBSound *psound ) ;
	virtual void    doSelectBGM( char *bgmfile ) ;
	virtual void    doSelectFont( char *fontfile ) ;
	virtual void    doConfigureSkinMenu( MENU_PARAMS *menuparams, char *title ) ;
	virtual void    doMenuBackgroundSettings( MENU_PARAMS *menuparams) ;
	virtual void    doMenuTextSettings( MENU_PARAMS *menuparams) ;
	virtual void    doMenuSpriteSettings( MENU_PARAMS *menuparams) ;
	virtual void    doScreenshotSize( MENU_PARAMS *menu );
	virtual void    doSelectTransition() ;
	virtual void    doChangeVideoMode() ;
	virtual void    doSavePlaything() ;
	virtual int     setupNetplay() ;
	virtual void    getKeyboardString( char *buf, int bufsize ) ;
	virtual void    doLoadPlaything() ;
	void            doDefaultDirs();
	virtual void    ColorBar( int xpos, int ypos, int xlen, int ylen, DWORD color );
	virtual void    renderPopupBkg( int numlines ) ;
	unsigned int    getNewMapping( unsigned int oldMapping ) ;
	virtual void    doConfigureControllers() ;
	virtual void    doConfigureController( int port ) ;
	virtual void    doEmulatorDefinitions( int port ) ;
	virtual void    doConfigureGame( char *settingsname, char *keysname, char *filename ) ;
	virtual void    doJoypadMappings( int port ) ;
	unsigned int    getNewEmuMapping( unsigned int port, unsigned int combo, unsigned int oldMapping );
	void			playSID( int selection );
	virtual void    doChangeCombo( int port, int combo );
	virtual void    doChangeComboMoves( int port, int combo );
	virtual void    doComboConfig( int port );
	virtual void    doGameJoypadMappings( int port ) ;
	virtual void    doUIJoypadMappings( int port ) ;
	void            doAddGamesharkCodes( char *filepos, char *codedesc);
	void            doShowGamesharkCodes( int which);
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCodeListMenu2() ;
	virtual int     pollXBoxControllers( );
	virtual int     pollNetworkControllers( );
	virtual void    doAddFoundCodes2() ;
	void            doSelectC64File( char *filename);
	void            doGamebase64( );
	unsigned char	selectLetter( );
	unsigned int	selectGenre( );
	unsigned int	selectPublisher( unsigned char letter );
	int				gamebaseGameList( int searchType, unsigned char letter, unsigned int uk ) ;


	
	virtual void    changeMenu( MENU_PARAMS *menuparams1, MENU_PARAMS *menuparams2 ) ;
	virtual void    doConfigureSprite( MENU_PARAMS *menuparams, int which ) ;
	virtual void    doConfigureEffects(MENU_PARAMS *menuparams, int which) ;
	virtual void    doEditCode2( int selected, int numpositions, int codetype ) ;
	virtual void    doContinueSearchMenu2() ;
	virtual void	popupMsg( char *msg, CPanel *panel, int onetime=0 ) ;
	virtual void    doCheatMenu() ;
	virtual void    doEmulatorOptions() ;
	virtual void    doEditGameGenie( int selected ) ;
	virtual void    doFontSize() ;
	virtual void    xboxSaveState() ;
	virtual void    xboxThrottle( int throttle ) ;
	virtual void    xboxLoadState() ;
	virtual void    xboxChangeFilter() ;
	virtual void    xboxScreenshot() ;
	virtual void    xboxChangeState() ;
	virtual void    doLoadSkin( char *skinname, int forceRoot ) ;
	virtual void    doSaveSkin( ) ;
	virtual void    loadSkinMenuSettings( char *szbuf, char *basesection, MENU_PARAMS *menu );
	virtual void    saveSkinMenuSettings( FILE *outfile, char *basesection, MENU_PARAMS *menu );
	virtual void    doSelectSkin() ;
	virtual void    doLoadIni( int forceRoot ) ;
	virtual void    doSaveIni() ;
	virtual void    doLoadEmuSpecificIni( char *szbuf) ;
	virtual void    doSaveEmuSpecificIni( FILE *outfile ) ;
	virtual void    doSaveConfig() ;
	virtual void    doScreenSize() ;
	virtual void    doNetplayOptions();
	virtual void    addNewNetplayServer( );
	virtual void    saveFavorites();
	void            handleScreenKeyboard( );
	void            renderScreenKeyboard( );
	virtual void    addFavorite( char *favorite ) ;
	virtual void    removeFavorite( unsigned int whichfav) ;
	virtual void    loadFavorites();
	virtual int     yesNoMenu( char *msg, CPanel *panel ) ;
	void            musicControlMenu( CPanel *panel );
	virtual int     selectNetplayServer() ;
	void            doGamebaseInfo( int selection );
	virtual void    doTextOffset() ;
	virtual int     addGameGenieCode() ;
	void            ClearScreen() ;
	virtual void    doConfiguration() ;
	void            createBlankDisk( ) ;
	virtual void    updateCheats() ;
	virtual void    updateCheats2() ;
	void            doSwapDrive();
	virtual void    processEmu( BOOL render ) ;
	virtual void    fillPresentationParams() ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    deleteSaveFiles( int which ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip( char *hugozipfile ) ;
	virtual void    QuickSort( int start, int end ) ;
	void			MenuBar( int xpos, int ypos, int xlen, int ylen ) ;
	virtual void    GetPalette(uint8 i, uint8 *r, uint8 *g, uint8 *b);
	void            SetPalette( const unsigned int *p, const unsigned char numentries );
	void            renderImage( unsigned char *image) ;
	virtual void    putImage() ;

	

    //Bliss32 m_bliss32;
	DWORD m_startTime ;
	int m_changedGenie ;
	DWORD m_joypad ;
	DWORD m_zapperDat[3] ;
	D3DCOLOR			color_palette[256];
	int                 PaletteChanged ;	
	DWORD m_xboxControllers[4] ;
	DWORD m_prevEmuControllers[4] ;
	DWORD m_emuControllers[4] ;
	DWORD m_networkEmuControllers[4] ;
	DWORD m_networkStatus ;
	NETPLAY_SERVER m_netplayServers[32] ;
	char m_screenshotDir[MAX_PATH] ;
	int m_defaultScreenshots ;

	D3DXVECTOR2 m_gameVecScale ; 
	D3DXVECTOR2 m_gameVecTranslate ; 
	RECT m_gameRectSource ;
	int m_throttle ;
	int   m_mousePosX, m_mousePosY ;

	SMB m_smb;
	Util m_smbUtil ;
	int m_stateNumber ;
	int  m_smbCdFile ;
	int  m_bUsingSamba ;
	int m_xboxHFilter ;
	int m_timesWithoutUpdate ;
	int m_screenUpdated ;
	int m_xboxSFilter ;
	char m_smbShare[500] ;
	float m_fFrameTime ;
	UINT32 m_numFrames ;
	int  m_scrollSpeed ; 
	int   keyTime ;
	unsigned int m_pitch ;
	DWORD  m_bRealCD ;
	DWORD  m_currentStartSector ;
	unsigned char *m_ptrCdBuf ;
	char m_cdromID[11]; 
	DWORD m_bitDepth ;
	DWORD m_lineHeight ;
	unsigned int m_zapperNum ;
	unsigned int m_vandalFix ;

	int m_c64SwapJoysticks;
	int m_c64TrueDrive;
	int m_c64VideoMode;
	int m_c64SIDModel;
	int m_c64SIDFilters;
	int m_c64SIDStereo;
	int m_c64SIDMethod;
	int m_c64DetachCart ;
	//int m_c64CartType ;
	char m_c64Filename[100] ;

	unsigned int m_psxfix_Xa ;
	unsigned int m_psxfix_Sio ;
	unsigned int m_psxfix_Mdec ;
	unsigned int m_psxfix_Cdda ;
	unsigned int m_psxfix_Cpu ;
	unsigned int m_psxfix_SpuIrq ;
	unsigned int m_psxfix_VSyncWA ;

#ifdef USE_NETPLAY
	CXBSocket m_sockListener ;
	CDebugClient m_sockNetplay;
#endif

	int       m_bNetplay ;
	unsigned int m_bNetworkCD ;
	char m_szSkin[100] ;
	char m_szSkinDir[MAX_PATH] ;
	SKIN_PARAMS m_skin ;
	MENU_PARAMS *pmenuParams ;


	unsigned int m_changedSettings ;
	WCHAR *m_menuText[200] ;

	CPlayThing m_plaything ;



	//PLAYTHING_CONFIG m_ptConfig ;

	PLAYTHING_CONFIG m_ptConfig ;


	MAPPINGS m_mappings[4] ;

	UINT32 topIdx  ;
	UINT32 curr  ;
	CDebugClient m_debugClient ;
	D3DPalette			*m_pd3dPalette ;
	BOOL m_bIsDDrive ;
	//CDDAXbox m_cdda ;

    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen
	D3DPRESENT_PARAMETERS	m_origPP ;


    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface
	DWORD               m_graphicsFixes ;
	DWORD               m_frameskip, m_framelimit ;
	DWORD				m_numtracks ;
	int m_bMappingCircle ;
	int m_bMappingSquare ;
	int m_bMappingTriangle ;
	int m_bMappingCross ;
	int m_bMappingR1 ;
	int m_bMappingL1 ;
	int m_bMappingR2 ;
	int m_bMappingL2 ;
	int m_bMappingStart ;
	int m_bMappingSelect ;
	int m_bMappingThrottle ;
	CPanel m_pnlBackgroundMain ;
	CPanel m_pnlBackgroundSelect ;
	CPanel m_pnlBackgroundOther ;
	CPanel m_pnlSplashEmu ;
	CPanel m_pnlSplashGame ;
	CPanel m_pnlPopup ;
	CPanel m_pnlGameScreen ;
	CPanel m_pnlGameScreen2 ;

	CFontHelper m_Font ;

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;
	unsigned char *m_cdDataBuffer ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
		char isDir ;
	} FILENAME ;


	FILENAME *files ;
	FAVORITE *m_filesFavorites ;
	unsigned long m_numFavorites ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;
	DWORD    m_dwStartPause ;
	int		m_nbytes ;
	int		m_nXOffset, m_nYOffset, m_nFontHeight ;
	int		m_namesPerPage ;
	char    m_szCurrentDir[MAX_PATH];
	CIoSupport m_io ;
	HANDLE m_hCdrom ;
	unsigned char m_cdbuffer[2352*4] ;
	gzFile m_cdfile ;
	unsigned char m_memcard1[MAX_PATH] ;
	unsigned char m_memcard2[MAX_PATH] ;
	int m_memcardnum1, m_memcardnum2 ;
	unsigned char m_biosfile[100] ;


	LPDIRECT3DTEXTURE8	m_pd3dBackgroundTexture;
	LPDIRECT3DTEXTURE8	Texture;
	LPDIRECT3DTEXTURE8	Texture2;
	LPDIRECT3DTEXTURE8	WhiteTexture;
	LPD3DXSPRITE			Sprite;
	LPD3DXSPRITE			MenuSprite;
	byte*				g_pBlitBuff ;
	byte*				g_pUnpaletteBuff ;
	byte*				g_pAlignBuff ;
	byte*				g_pDeltaBuff ;
	int					m_droppedFrames ;	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	Mp3Player			m_mp3player;
	CXBSound			m_sfxMenuMove;
	CXBSound			m_sfxMenuSelect;
	CXBSound			m_sfxMenuCancel;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_bramfile[500] ;
	char				g_cuefile[500] ;
	char				g_rtcfile[500] ;
	char				g_chtfile[500] ;
	char				g_statefile[500] ;
	char				g_keysfile[500] ;
	char				g_settingsfile[500] ;
	FILE                *m_logfile ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;

	int					m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ;


	CHEAT_CODE *m_cheatCodes;

	typedef struct _cheatdbentry 
	{
		char gamename[100] ;
		char slus[11] ;
		unsigned int numcodes ;
		char *filepos ;
	} CHEATDBENTRY ;


	GAMEBASE_ENTRY *m_gameBaseEntries  ;
	unsigned int m_numGameBaseEntries  ;
	unsigned int m_bDoingGamebase ;
	unsigned int m_gamebaseHoldCurr ;
	unsigned int m_gamebaseHoldIdx ;
	unsigned int m_gamebaseOnlyAvailable  ;
	unsigned int m_gamebaseForceConfig  ;
	char m_gamebasePath[500] ;

	char *m_cheatfile ;
	unsigned int m_numDBCheats ;

	UINT32 m_numCheats ;


};


#include "..\common\commonfuncs.cpp"


struct { char *keyname ; int keynum ; } validKeys[11] = 
{
	{ "XBOX A", 0 },
	{ "XBOX B", 1 },
	{ "XBOX X", 2 },
	{ "XBOX Y", 3 },
	{ "XBOX BLACK", 4 },
	{ "XBOX WHITE", 5 },
	{ "XBOX START", 6 },
	{ "XBOX BACK", 7 },
	{ "XBOX LTRIGGER", 8 },
	{ "XBOX RTRIGGER", 9 },
	{ "UNMAPPED", 10 },
};




void CXBoxSample::doLoadEmuSpecificIni( char *szbuf ) 
{


	m_gamebaseOnlyAvailable = GetIniInt( szbuf, "EMU_SPECIFIC", "only_existing", 0 ) ;
	m_gamebaseForceConfig = GetIniInt( szbuf, "EMU_SPECIFIC", "force_config", 0 ) ;
	GetIniString( szbuf, m_gamebasePath, 500, "EMU_SPECIFIC", "gamebase_path", "D:\\GAMEBASE" ) ;
}

void CXBoxSample::doSaveEmuSpecificIni( FILE *outfile ) 
{


	fprintf( outfile, "[EMU_SPECIFIC]\r\n" ) ;
	fprintf( outfile, "only_existing=%u\r\n", m_gamebaseOnlyAvailable ) ;
	fprintf( outfile, "gamebase_path=%s\r\n", m_gamebasePath) ;
	fprintf( outfile, "force_config=%u\r\n", m_gamebaseForceConfig ) ;
	fprintf( outfile, "\r\n" ) ;


}


int CXBoxSample::init_texture()
{
//	return 1  ;

	D3DCOLOR *palette ;


	sprintfx( "begin inittext\r\n") ;
	xbox_print_memory() ;

	// Release any previous texture
	if (Texture) 
	{ 
		return 1 ;
		Texture->BlockUntilNotBusy() ;
		Texture->Release();
		Texture = NULL;
	}
	
	theWidth = 384*2 ;
	theHeight = 272*2 ;

	xbox_print_memory() ;



	// Create the texture
	if (D3DXCreateTextureFromFileInMemoryEx(m_pd3dDevice, GAMESCREEN_FILE, sizeof(GAMESCREEN_FILE),
		 theWidth, theHeight, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &Texture)==D3D_OK)
	{
		m_pnlGameScreen.m_pTexture = NULL ;
		if ( FAILED(m_pnlGameScreen.Create(m_pd3dDevice, Texture, FALSE, theWidth, theHeight)) )
		{
			popupMsg( "no create panel", &m_pnlBackgroundOther ) ;
		}
	}
	else
	{
		popupMsg( "no load texture", &m_pnlBackgroundOther ) ;
	}
	
/*
	// Create the texture
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "D:\\gamescreen.png",
		 theWidth, theHeight, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &Texture)==D3D_OK)
	{
		if ( FAILED(m_pnlGameScreen.Create(m_pd3dDevice, Texture, FALSE, theWidth, theHeight)) )
		{
			popupMsg( "no create panel", &m_pnlBackgroundOther ) ;
		}
	}
	else
	{
		popupMsg( "no load texture", &m_pnlBackgroundOther ) ;
	}

	xbox_print_memory() ;
*/	
/*
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_DEFAULT, &Texture);
		if ( FAILED(m_pnlGameScreen.Create(m_pd3dDevice, Texture, FALSE, theWidth, theHeight)) )
		{
			popupMsg( "no create panel", &m_pnlBackgroundOther ) ;
		}

*/
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_P8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	sprintfx( "before inittex\r\n") ;

	xbox_print_memory() ;
	
	
	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[ desc.Size ];

//	XBuf = g_pBlitBuff ;

	xbox_print_memory() ;

	/*
	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];

	xbox_print_memory() ;

	if (g_pUnpaletteBuff != NULL)
	{
		delete [] g_pUnpaletteBuff ;
		g_pUnpaletteBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pUnpaletteBuff = new byte[desc.Size];
*/

	xbox_print_memory() ;

	if (g_pDeltaBuff != NULL)
	{
		delete [] g_pDeltaBuff;
		g_pDeltaBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pDeltaBuff = new byte[desc.Size];

	xbox_print_memory() ;

	if ( g_pDeltaBuff == NULL )
		return 1 ;

	memset( g_pDeltaBuff, 0xFF, desc.Size ) ;

	sprintfx( "aft inittex\r\n") ;
	

	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	m_pitch = d3dlr.Pitch ;

	// Unlock our texture
	Texture->UnlockRect(0);

	xbox_print_memory() ;

	//m_pd3dDevice->CreatePalette( D3DPALETTE_256 , &m_pd3dPalette ) ;
	//m_pd3dPalette->Lock( &palette, 0 ) ;
	//memset( palette, 44, 256* sizeof( D3DCOLOR ) ) ;
	//m_pd3dPalette->Unlock() ;

	//m_pd3dDevice->SetPalette( 0, m_pd3dPalette ) ;

	sprintfx( "end inittex\r\n") ;

	return 0;
}












void CXBoxSample::emuLaunch( unsigned int gameSelected, unsigned int isFavorite, int forceConfig, int isGamebase  )
{
	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;


	initConsole(gameSelected, isFavorite, forceConfig, isGamebase) ;


	if ( g_autoLaunchGame )
	{
		changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
	}
	else
	{
		changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
	}

	if ( !m_bBgmInGame )
	{
		m_mp3player.pause( FALSE ) ;
	}

	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;

}





void CXBoxSample::GetPalette(uint8 i, uint8 *r, uint8 *g, uint8 *b)
{
	*r=( color_palette[i] >> 16 ) & 0xFF ;
	*g=( color_palette[i] >> 8 ) & 0xFF ;
	*b=( color_palette[i]  ) & 0xFF ;
}

void CXBoxSample::SetPalette( const unsigned int *p, const unsigned char numentries )
{

	sprintfx( "setpalette\r\n") ;

	int r,g,b ;
	//m_pd3dPalette->Lock( &color_palette, 0 ) ;


	for ( int i = 0 ; i < numentries ; i++ )
	{
		DWORD color = p[i] ;

		r = ( color >> 19 ) & 0x1F ;
		g = ( color >> 10 ) & 0x3F  ;
		b = ( color >> 3 ) & 0x1F ;

		color_palette[i] = (r << 11 ) | ( g << 5 ) | b ;
	}

	//m_pd3dPalette->Unlock() ;

	//m_pd3dDevice->SetPalette( 0, m_pd3dPalette ) ;

}



void CXBoxSample::saveSettings( char *filename )
{

	FILE *setfile ;



	setfile = fopen( filename, "wb" ) ;

	if ( !setfile )
		return ;

	fwrite( &m_xboxSFilter, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64SwapJoysticks, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64TrueDrive, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64VideoMode, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64SIDModel, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64SIDFilters, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64SIDStereo, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_c64SIDMethod, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_nScreenX, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_nScreenY, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_nScreenMaxX, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_nScreenMaxY, sizeof(unsigned int), 1, setfile ) ;
	fwrite( m_c64Filename, 100, 1, setfile ) ;
	fwrite( &m_c64DetachCart, sizeof(unsigned int), 1, setfile ) ;

	fclose( setfile ) ;

}

int CXBoxSample::loadSettings( char *filename )
{

	FILE *setfile ;

	m_changedSettings = 0 ;

	//m_xboxSFilter = 0 ;

	m_c64SwapJoysticks = 1;
	m_c64TrueDrive = 0 ;
	m_c64VideoMode = 0 ;
	m_c64SIDModel = 1 ;
	m_c64SIDFilters = 1;
	m_c64SIDStereo = 0;
	m_c64SIDMethod = 0;
	m_c64Filename[0] = 0 ;
	m_c64DetachCart = 1 ;


	setfile = fopen( filename, "rb" ) ;

	if ( !setfile )
	{
		saveSettings( filename ) ;
		return 1;
	}


	fread( &m_xboxSFilter, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64SwapJoysticks, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64TrueDrive, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64VideoMode, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64SIDModel, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64SIDFilters, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64SIDStereo, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_c64SIDMethod, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_nScreenX, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_nScreenY, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_nScreenMaxX, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_nScreenMaxY, sizeof(unsigned int), 1, setfile ) ;
	fread( m_c64Filename, 100, 1, setfile ) ;
	fread( &m_c64DetachCart, sizeof(unsigned int), 1, setfile ) ;

	fclose( setfile ) ;
	
	if ( ( m_xboxSFilter < 0 ) || ( m_xboxSFilter > NUM_SOFTWARE_FILTERS-1 ) )
		m_xboxSFilter = 0 ;

	return 0 ;
}






struct genietable
{
	byte nibble ;
	char code ;
} GENIETABLE[] = 
{
	{ 0x0, 'A' },
	{ 0x1, 'E' },
	{ 0x2, 'P' },
	{ 0x3, 'O' },
	{ 0x4, 'Z' },
	{ 0x5, 'X' },
	{ 0x6, 'L' },
	{ 0x7, 'U' },
	{ 0x8, 'G' },
	{ 0x9, 'K' },
	{ 0xA, 'I' },
	{ 0xB, 'S' },
	{ 0xC, 'T' },
	{ 0xD, 'V' },
	{ 0xE, 'Y' },
	{ 0xF, 'N' }
} ;

int CXBoxSample::encodeGameGenie( CHEAT_CODE *code ) 
{
	DWORD encodedVal ;
	int codesize ;
	byte andVal ;
	byte shiftval ;
	byte codeofs ;
	byte highbit ;

	codesize = 6 ;

	code->adr &= 0xFFFF ;
	code->val &=0xFF ;

	encodedVal = ( ( code->adr & 0xF000 ) >> 4 ) |
				 ( ( code->adr & 0x0F00 ) >> 8 ) |
				 ( ( code->adr & 0x00F0 ) << 8 ) |
				 ( ( code->adr & 0x000F ) << 4 ) |
				 ( ( code->val & 0x00F0 ) << 12 ) |
				 ( ( code->val & 0x000F ) << 20 )  ;


	if ( code->type == 0x98 ) //8 char code
	{
		codesize = 8 ;

		encodedVal |= 0x800 ; //8 char codes must have high bit of adr set to 1

		encodedVal = encodedVal << 8 ;
		encodedVal = encodedVal |
				 ( ( code->code[16] & 0x00F0 ) >> 4 ) |
				 ( ( code->code[16] & 0x000F ) << 4 )  ;

		highbit = ( encodedVal & 0x80000000 ) >> 31;
	}
	else
	{
		encodedVal &= ~0x800 ; //6 char codes must have high bit of adr set to 0
		highbit = ( encodedVal & 0x800000 ) >> 23;
	}

	encodedVal = (encodedVal << 1) | highbit;

	andVal = 0xF ;
	shiftval = 0 ;

	if ( codesize == 6 )
		codeofs = 2 ;

	for ( int i = codesize-1 ; i >= 0 ; i-- )
	{
		code->code[i] = GENIETABLE[ ( ( encodedVal & andVal ) >> shiftval ) & 0xF ].code ;
		andVal = andVal << 4 ;
		shiftval += 4 ;

	}

	code->code[codesize] = 0 ;

	return 0 ;
}

int CXBoxSample::decodeGameGenie( CHEAT_CODE *code ) 
{
	DWORD encodedVal ;
	int codesize ;
	byte andVal ;
	byte shiftval ;
	byte codeofs ;
	byte nibble;
	DWORD highbit ;

	codesize = strlen( code->code ) ;
	strupr( code->code ) ;


	encodedVal = 0 ;
	shiftval = 0 ;

	for ( int i = codesize-1 ; i >= 0 ; i-- )
	{
		for ( int j = 0 ; j < 16 ; j++ )
		{
			if ( code->code[i] == GENIETABLE[j].code ) 
			{
				nibble = GENIETABLE[j].nibble ;
				break ; 
			}
		}

		encodedVal |= ( nibble << shiftval ) ;
		shiftval += 4 ;

	}


	if ( codesize == 8 )
	{
		highbit = ( encodedVal & 0x01 ) << 31 ;
	}
	else
	{
		highbit = ( encodedVal & 0x01 ) << 23 ;
	}

	encodedVal = encodedVal >> 1 ;

	encodedVal &= 0x7FFFFFFF ;

	encodedVal |= highbit ;

	if ( codesize == 8 )
	{
		code->type = 0x98 ;
		code->code[16] = ( ( encodedVal & 0x0F ) << 4 ) |
						 ( ( encodedVal & 0xF0 ) >> 4 ) ;
		encodedVal = encodedVal >> 8 ;
	}
	else
	{
		code->type = 0x99 ;
	}



	code->adr = ( ( encodedVal & 0x0F00 ) << 4 ) |
				( ( encodedVal & 0x000F ) << 8 ) |
				( ( encodedVal & 0xF000 ) >> 8 ) |
				( ( encodedVal & 0x00F0 ) >> 4 )  ;

	code->val = ( ( encodedVal & 0x0F0000 ) >> 12 ) |
				( ( encodedVal & 0xF00000 ) >> 20 ) ;

	code->desc[0] = 0 ;

	if ( code->adr >= 0x8000 )
		code->adr -= 0x8000 ;

	return 0 ;
}

int CXBoxSample::addGameGenieCode()
{
	int value ;
	int menuChoice = 0 ;
	int numitems ;

	value = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"Add Game Genie Code"  );
		swprintf( m_menuText[1], L"Add 6-Char Code");
		swprintf( m_menuText[2], L"Add 8-Char Code");

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			return 1  ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			m_changedGenie = 1 ;

			CHEAT_CODE code ;

			code.adr = 0 ;
			code.val = 0 ;
			code.enabled = 0 ;
			code.desc[0] = 0 ;
			memset( code.code, 0, sizeof(code.code) ) ;

			code.type = menuChoice == 0 ? 0x99 : 0x98 ;

			encodeGameGenie( &code ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

			return 0 ;
		}
	}

	return 1 ;
}


void CXBoxSample::doEditGameGenie( int selected )
{
	char szNewDir[MAX_PATH] ;
	DWORD color ;
	int numpositions ;
	CHEAT_CODE editedCode ;
	FILE *outfile ;
	int numpad ;
	int pos ;
	int panelx, panely ;
	CPanel panel ;
	LPDIRECT3DTEXTURE8	panelTexture ;
	int charspacing ;
	char truncCode[30] ;
	WCHAR msg[50] ;
	WCHAR *lines[100] = { L"L/R Trigger - Change Position", 
							L"A - Select Digit",
							L"START - Save Code",
							L"B - Cancel" } ;
	int posx[4] ;



	if ( selected == -1 )
	{
		return ;
	}


	for ( int i = 0 ; i < 4 ; i++ )
	{
		posx[i] = (640-m_Font.GetWidth( lines[i] )) / 2 ;
	}


	numpad = 0 ;
	pos = 0 ;

	outfile = fopen( "Z:\\NUMPADG.PNG", "wb" ) ;
	if ( outfile == NULL )
		return ;

	fwrite( NUMPADG_PNG, sizeof(char), sizeof(NUMPADG_PNG), outfile ) ;
	fclose( outfile ) ;



	pmenuParams = &(m_skin.otherMenu) ;
	
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "Z:\\NUMPADG.PNG",
		 NUMPADG_WIDTH, NUMPADG_HEIGHT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture )==D3D_OK)
	{
		if ( FAILED(panel.Create(m_pd3dDevice, panelTexture , FALSE, NUMPADG_WIDTH, NUMPADG_HEIGHT)) )
		{
			panelTexture->Release() ;
			return  ;
		}
	}
	else
	{
		return  ;
	}
	
	charspacing = 0 ;

	for ( int i = 0 ; i < 10 ; i++ )
	{
		swprintf( msg, L"%c", '0' + i ) ;
		if ( m_Font.GetWidth( msg ) > charspacing )
			charspacing = m_Font.GetWidth( msg ) ;
	}
	for ( int i = 0 ; i < 6 ; i++ )
	{
		swprintf( msg, L"%c", 'A' + i ) ;
		if ( m_Font.GetWidth( msg ) > charspacing )
			charspacing = m_Font.GetWidth( msg ) ;
	}






	truncCode[0] = 0 ;
	int cnt = 0 ;

	if ( m_cheatCodes[selected].type == 0x98 )
	{
		numpositions = 8 ;
	}
	else
	{
		numpositions = 6 ;
	}

	for ( int i = 0 ; ( cnt < numpositions ) && ( i<19) ; i++ )
	{
		if ( m_cheatCodes[selected].code[i] != ' ' ) 
		{
			truncCode[cnt] = m_cheatCodes[selected].code[i] ;
			cnt++ ;
		}
	}

	truncCode[cnt] = 0 ;

	charspacing += 5 ;
	
	LPDIRECT3DTEXTURE8	colorSquareTexture;

	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &colorSquareTexture);
	
	D3DSURFACE_DESC desc;
    colorSquareTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	D3DLOCKED_RECT d3dlr;


	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);


	color = 0x800066CC ;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

	colorSquareTexture->UnlockRect(0);

	panelx = (640-NUMPAD_WIDTH)/2 ;
	panely = 82 ; 

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
		//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
		pmenuParams->panel->Render( );
		m_pnlGameScreen.SetAlpha( 0x80) ;
		m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
		m_pnlGameScreen.SetAlpha( 0xFF) ;

		//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;

		panel.Render( panelx, panely, NUMPAD_WIDTH, NUMPAD_HEIGHT ) ;


		m_mp3player.process() ;


		D3DXVECTOR2 vecScale( 1, 1 ) ;
		D3DXVECTOR2 vecTranslate( panelx + 4 + ( 53 * ( numpad % 4 )), panely + 4 + ( 53 * ( numpad / 4 ) ) ) ;
		D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 49;
		rectSource.right  = 49 ;

		MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);

		for ( int i = 0 ; i < numpositions ; i++ )
		{
			swprintf( msg, L"%c", truncCode[i] ) ;
			m_Font.DrawText( ((640-(charspacing*numpositions))/2) + i*charspacing, (panely-pmenuParams->lineHeight)-10, 
				pos==i ? pmenuParams->selectedColor : pmenuParams->normalColor, msg, pmenuParams->selectBarColor, pos==i, 0, 0, 0, 0) ;
		}

		for ( int i = 0 ; i < 4 ; i++ )
		{
			m_Font.DrawText( posx[i], panely+NUMPAD_HEIGHT+10 + (pmenuParams->lineHeight*i), 
				pmenuParams->normalColor, lines[i], pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;
		}


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			switch ( numpad )
			{
				case 0 : truncCode[pos] = 'A' ; break ; 
				case 1 : truncCode[pos] = 'E' ; break ; 
				case 2 : truncCode[pos] = 'G' ; break ; 
				case 3 : truncCode[pos] = 'I' ; break ; 
				case 4 : truncCode[pos] = 'K' ; break ; 
				case 5 : truncCode[pos] = 'L' ; break ; 
				case 6 : truncCode[pos] = 'N' ; break ; 
				case 7 : truncCode[pos] = 'O' ; break ; 
				case 8 : truncCode[pos] = 'P' ; break ; 
				case 9 : truncCode[pos] = 'S' ; break ; 
				case 10 : truncCode[pos] = 'T' ; break ; 
				case 11 : truncCode[pos] = 'U' ; break ; 
				case 12 : truncCode[pos] = 'V' ; break ; 
				case 13 : truncCode[pos] = 'X' ; break ; 
				case 14 : truncCode[pos] = 'Y' ; break ; 
				case 15 : truncCode[pos] = 'Z' ; break ; 
			}

			pos = (pos+1)%numpositions ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 3 )
				numpad -= 3 ;
			else
				numpad++ ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 0 )
				numpad += 3 ;
			else
				numpad-- ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad < 4 )
				numpad += 12 ;
			else
				numpad -= 4 ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad > 11 )
				numpad -= 12 ;
			else
				numpad += 4 ;

		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+1)%numpositions ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+(numpositions-1))%numpositions ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_START )
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			memcpy( &editedCode, &(m_cheatCodes[selected]), sizeof(CHEAT_CODE) ) ;
			strcpy( editedCode.code, truncCode ) ;

			if ( ! decodeGameGenie( &editedCode ) )
			{
				memcpy( &(m_cheatCodes[selected]), &editedCode, sizeof(CHEAT_CODE) ) ;
				m_changedGenie = 1 ;
				break ;
			}
			else
			{
				popupMsg( "The code you entered is invalid.", &m_pnlBackgroundOther ) ;
			}
		}
	}

	panelTexture->Release() ;
	colorSquareTexture->Release() ;

}



void CXBoxSample::handleScreenKeyboard( )
{
	DWORD color ;

	XBInput_GetInput();
	if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
	{
		m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;

		while ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_B] )
			XBInput_GetInput();

		m_bKeyboardMode = 0 ;

		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
		}
		if ( m_currKeyboardKey & KEYCAPS )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x30],KEYBOARD_VKMAP[0x30] ) ;
		}
		if ( m_currKeyboardKey & KEYLSHIFT )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x40],KEYBOARD_VKMAP[0x40] ) ;
		}
		if ( m_currKeyboardKey & KEYRSHIFT )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x4D],KEYBOARD_VKMAP[0x4D] ) ;
		}
		if ( m_currKeyboardKey & KEYLCTRL )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x50],KEYBOARD_VKMAP[0x50] ) ;
		}
		if ( m_currKeyboardKey & KEYRCTRL )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x5A],KEYBOARD_VKMAP[0x5A] ) ;
		}
		if ( m_currKeyboardKey & KEYLALT )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x53],KEYBOARD_VKMAP[0x53] ) ;
		}
		if ( m_currKeyboardKey & KEYRALT )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[0x58],KEYBOARD_VKMAP[0x58] ) ;
		}

		m_currKeyboardKey &= 0x000000FF ;

		return ;
	}

	if(g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
	{
		if ( (m_currKeyboardKey&0xFF) == 13 )
		{
			int currAlpha = (m_pnlKeyboard.m_colDiffuse >> 24 )&0xFF ;

			currAlpha += 1 ;

			if ( currAlpha > 0xFF )
				currAlpha = 0xFF ;

			m_pnlKeyboard.SetAlpha( currAlpha ) ;
		}

		if ( (m_currKeyboardKey&0xFF) == 14 )
		{
			int currAlpha = (m_pnlKeyboard.m_colDiffuse >> 24 )&0xFF ;

			currAlpha -= 1 ;

			if ( currAlpha < 0  )
				currAlpha = 0 ;

			m_pnlKeyboard.SetAlpha( currAlpha ) ;
		}

		if ( m_currKeyboardKey & KEYPRESSING )
		{
		}
		else
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			
			switch( m_currKeyboardKey&0xFF )
			{
				case 0x30 : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYCAPS ) )
						{
							m_currKeyboardKey |= KEYCAPS ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYCAPS ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x40 :
				case 0x41 : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYLSHIFT ) )
						{
							m_currKeyboardKey |= KEYLSHIFT ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYLSHIFT ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x4C :
				case 0x4D : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYRSHIFT ) )
						{
							m_currKeyboardKey |= KEYRSHIFT ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYRSHIFT ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x50 :
				case 0x51 : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYLCTRL ) )
						{
							m_currKeyboardKey |= KEYLCTRL ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYLCTRL ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x5A :
				case 0x5B : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYRCTRL ) )
						{
							m_currKeyboardKey |= KEYRCTRL ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYRCTRL ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x52 :
				case 0x53 : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYLALT ) )
						{
							m_currKeyboardKey |= KEYLALT ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYLALT ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				case 0x58 :
				case 0x59 : 
				{
					if ( g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
					{
						if ( ! ( m_currKeyboardKey & KEYRALT ) )
						{
							m_currKeyboardKey |= KEYRALT ; 
							kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
						else
						{
							m_currKeyboardKey &= ~KEYRALT ; 
							kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
						}
					}
					break ;
				}
				default : 
				{
					m_currKeyboardKey |= KEYPRESSING ; 
					m_currKeyboardKey |= (( m_currKeyboardKey&0xFF)<<8) ;
					kbd_handle_keydown( KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey)&0xFF] ) ;
					break ;
				}
			}
		}
	}
	else
	{
		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
			m_currKeyboardKey &= ~KEYPRESSING ;
			m_currKeyboardKey &= 0xFFFF00FF ;
		}
	}

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
	{
		m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;

		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
			m_currKeyboardKey &= ~KEYPRESSING ;
			m_currKeyboardKey &= 0xFFFF00FF ;
		}

		if ( ( m_currKeyboardKey%16 ) == 15 )
			m_currKeyboardKey -= 15 ;
		else
			m_currKeyboardKey++ ;

	}
	else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
	{
		m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
			m_currKeyboardKey &= ~KEYPRESSING ;
			m_currKeyboardKey &= 0xFFFF00FF ;
		}
		if ( ( m_currKeyboardKey%16 ) == 0 )
			m_currKeyboardKey += 15 ;
		else
			m_currKeyboardKey-- ;

	}
	else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
	{
		m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
			m_currKeyboardKey &= ~KEYPRESSING ;
			m_currKeyboardKey &= 0xFFFF00FF ;
		}
		if ( (m_currKeyboardKey&0xFF) < 16 )
			m_currKeyboardKey += (5*16) ;
		else
			m_currKeyboardKey -= 16 ;

	}
	else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
	{
		m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
		if ( m_currKeyboardKey & KEYPRESSING )
		{
			kbd_handle_keyup( KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF],KEYBOARD_VKMAP[(m_currKeyboardKey>>8)&0xFF] ) ;
			m_currKeyboardKey &= ~KEYPRESSING ;
			m_currKeyboardKey &= 0xFFFF00FF ;
		}
		if ( (m_currKeyboardKey&0xFF) > (5*16)-1 )
			m_currKeyboardKey -= 5*16 ;
		else
			m_currKeyboardKey += 16 ;

	}

}


int CXBoxSample::addEmuSpecificOptions( int start )
{

	swprintf( m_menuText[start], L"Change Disk in Drive 8 - Standard");
	swprintf( m_menuText[start+1], L"Change Disk in Drive 8 - From Gamebase");
	swprintf( m_menuText[start+2], L"Create Blank Disk In Directory");

	return start+3 ;

}

void CXBoxSample::saveGameSpecificSettings( )
{
	saveKeys( g_keysfile ) ;
	saveSettings( g_settingsfile ) ;

}


unsigned char CXBoxSample::selectLetter( )
{
	int menuChoice = 0 ;
	char letter ;

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Select Letter" );
		swprintf( m_menuText[1], L"0" );
		swprintf( m_menuText[2], L"A" );
		swprintf( m_menuText[3], L"B" );
		swprintf( m_menuText[4], L"C" );
		swprintf( m_menuText[5], L"D" );
		swprintf( m_menuText[6], L"E" );
		swprintf( m_menuText[7], L"F" );
		swprintf( m_menuText[8], L"G" );
		swprintf( m_menuText[9], L"H" );
		swprintf( m_menuText[10], L"I" );
		swprintf( m_menuText[11], L"J" );
		swprintf( m_menuText[12], L"K" );
		swprintf( m_menuText[13], L"L" );
		swprintf( m_menuText[14], L"M" );
		swprintf( m_menuText[15], L"N" );
		swprintf( m_menuText[16], L"O" );
		swprintf( m_menuText[17], L"P" );
		swprintf( m_menuText[18], L"Q" );
		swprintf( m_menuText[19], L"R" );
		swprintf( m_menuText[20], L"S" );
		swprintf( m_menuText[21], L"T" );
		swprintf( m_menuText[22], L"U" );
		swprintf( m_menuText[23], L"V" );
		swprintf( m_menuText[24], L"W" );
		swprintf( m_menuText[25], L"X" );
		swprintf( m_menuText[26], L"Y" );
		swprintf( m_menuText[27], L"Z" );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 28, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			return 0 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : return '0' ;
				default : return 'A' + menuChoice - 1;
			}
		}


	}

}

int readDataFile( char *filename, GAMEBASE_ENTRY **entries, unsigned int *numentries, unsigned char letter ) 
{
	FILE *infile ;
	int numfields ;
	unsigned char fletter ;
	int recordlength, value ;
	int desclen, descofs, numrecords  ;

	infile = fopen( filename, "rb" ) ;

	if( infile == NULL )
		return 0;


	fread( &numfields, sizeof(int), 1, infile ) ;

	recordlength = 0 ;

	for ( int i = 0 ; i < numfields ; i++ )
	{
		fread( &value, sizeof(int), 1, infile ) ;

		if ( i == 1 )
		{
			descofs = recordlength ;
			desclen = value ;
		}

		recordlength += value ;

	}

	fseek( infile, 0, SEEK_END ) ;

	numrecords = (ftell(infile) - ( 4*(numfields+1))) / recordlength ;

	if ( letter )
		letter = tolower(letter ) ;

	for ( int i = 0 ; i < numrecords ; i++ )
	{
		if ( letter )
		{
			fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+4, SEEK_SET ) ;
			fread( &fletter, 1, 1, infile ) ;

			if ( letter == '0' )
			{
				if ( isalpha( fletter ) )
					continue ;
			}
			else
			{
				if ( tolower( fletter ) != letter )
					continue ;
			}
		}

		fseek( infile, ( 4*(numfields+1)) + (i*recordlength), SEEK_SET ) ;

		*entries = (GAMEBASE_ENTRY*)realloc( *entries, sizeof(GAMEBASE_ENTRY) * ( *numentries + 1 ) ) ;
		
		if ( *entries == NULL )
		{
			xbox_print_memory() ;
		}

		(*entries)[*numentries].name = (char*)malloc( desclen+1 ) ;
		(*entries)[*numentries].filename = NULL ;

		memset( (*entries)[*numentries].name, 0, desclen+1 ) ;

		fread( &((*entries)[*numentries].uk), sizeof(int), 1, infile ) ;
		fread( (*entries)[*numentries].name, desclen, 1, infile ) ;
		
		(*numentries)++ ;

	}

	fclose(infile) ;

	return 1 ;
}


void readDescription( char *filename, char *svalue, unsigned int uk )
{
	FILE *infile ;
	int numfields ;
	unsigned char fletter ;
	int recordlength, value ;
	int desclen, descofs, numrecords  ;

	infile = fopen( filename, "rb" ) ;

	if( infile == NULL )
		return ;


	fread( &numfields, sizeof(int), 1, infile ) ;

	recordlength = 0 ;

	for ( int i = 0 ; i < numfields ; i++ )
	{
		fread( &value, sizeof(int), 1, infile ) ;

		if ( i == 1 )
		{
			descofs = recordlength ;
			desclen = value ;
		}

		recordlength += value ;

	}

	fseek( infile, 0, SEEK_END ) ;

	numrecords = (ftell(infile) - ( 4*(numfields+1))) / recordlength ;

	for ( int i = 0 ; i < numrecords ; i++ )
	{

		fseek( infile, ( 4*(numfields+1)) + (i*recordlength), SEEK_SET ) ;
		
		fread( &value, sizeof(int), 1, infile ) ;

		if ( value == uk )
		{
			fread( svalue, desclen, 1, infile ) ;
			fclose(infile) ;
			return ;
		}

	}

	fclose(infile) ;
}


#define GAME_NAME_FIELD 0
#define GAME_YEAR_FIELD 1
#define GAME_COMMENT_FIELD 2
#define GAME_FILE_FIELD 3
#define GAME_SCRFILE_FIELD 4
#define GAME_MUSICIAN_FIELD 5
#define GAME_GENRE_FIELD 6
#define GAME_PUBLISHER_FIELD 7
#define GAME_CRACKER_FIELD 8
#define GAME_SID_FIELD 9
#define GAME_PROGRAMMER_FIELD 10
#define GAME_LANGUAGE_FIELD 11
#define GAME_PALNTSC_FIELD 12
#define GAME_TRUEDRIVE_FIELD 13
#define GAME_LENGTH_FIELD 14
#define GAME_TRAINERS_FIELD 15
#define GAME_COMMENT2_FIELD 16
#define GAME_LENGTHTYPE_FIELD 17
#define GAME_MULTI_FIELD 18
#define GAME_CONTROL_FIELD 19

#define SEARCH_GAME 1
#define SEARCH_GENRE 2
#define SEARCH_PUBLISHER 3
#define SEARCH_MULTIPLAYER 4

int readGameDataFile( char *filename, GAMEBASE_ENTRY **entries, unsigned int *numentries, int searchType, int uk, unsigned char letter, int onlyAvail, char *basepath ) 
{
	FILE *infile ;
	struct stat s ;
	int numfields ;
	int fuk ;
	unsigned char fletter ;
	int recordlength, value ;
	int filelen, fileofs, desclen, descofs, numrecords  ;
	int pubofs, genreofs, multiofs ;
	char afilename[500] ;

	infile = fopen( filename, "rb" ) ;

	if( infile == NULL )
		return 0;


	fread( &numfields, sizeof(int), 1, infile ) ;

	recordlength = 0 ;

	for ( int i = 0 ; i < numfields ; i++ )
	{
		fread( &value, sizeof(int), 1, infile ) ;

		switch ( i )
		{
			case GAME_NAME_FIELD :
			{
				descofs = recordlength ;
				desclen = value ;
				break ;
			}
			case GAME_FILE_FIELD :
			{
				fileofs = recordlength ;
				filelen = value ;
				break ;
			}
			case GAME_GENRE_FIELD :
			{
				genreofs = recordlength ;
				break ;
			}
			case GAME_PUBLISHER_FIELD :
			{
				pubofs = recordlength ;
				break ;
			}
			case GAME_MULTI_FIELD :
			{
				multiofs = recordlength ;
				break ;
			}
			default : break ;
		}


		recordlength += value ;

	}

	fseek( infile, 0, SEEK_END ) ;

	numrecords = (ftell(infile) - ( 4*(numfields+1))) / recordlength ;

	if ( letter )
		letter = tolower(letter ) ;






	for ( int i = 0 ; i < numrecords ; i++ )
	{
		switch( searchType )
		{
			case SEARCH_GAME :
			{
				fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+descofs, SEEK_SET ) ;
				fread( &fletter, 1, 1, infile ) ;
				if ( letter == '0' )
				{
					if ( isalpha( fletter ) )
						continue ;
				}
				else
				{
					if ( tolower( fletter ) != letter )
						continue ;
				}
				break ;
			}
			case SEARCH_GENRE :
			{
				fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+genreofs, SEEK_SET ) ;
				fread( &fuk, sizeof(int), 1, infile ) ;

				if ( fuk != uk )
					continue ;
				break ;
			}
			case SEARCH_PUBLISHER :
			{
				fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+pubofs, SEEK_SET ) ;
				fread( &fuk, sizeof(int), 1, infile ) ;

				if ( fuk != uk )
					continue ;
				break ;
			}
			case SEARCH_MULTIPLAYER :
			{
				fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+multiofs, SEEK_SET ) ;
				fread( &fuk, sizeof(int), 1, infile ) ;

				if ( fuk < 2 )
					continue ;
				break ;
			}
		}

		if ( onlyAvail )
		{
			fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+fileofs, SEEK_SET ) ;

			memset(afilename, 0, 500 ) ;

			sprintf( afilename, "%s\\GAMES\\", basepath ) ;
			fread( afilename+strlen(afilename), filelen, 1, infile ) ;

			if ( stat( afilename, &s ) )
				continue ;
		}

		fseek( infile, ( 4*(numfields+1)) + (i*recordlength), SEEK_SET ) ;

		*entries = (GAMEBASE_ENTRY*)realloc( *entries, sizeof(GAMEBASE_ENTRY) * ( *numentries + 1 ) ) ;
		
		(*entries)[*numentries].name = (char*)malloc( desclen+1 ) ;
		(*entries)[*numentries].filename = (char*)malloc( filelen+1 ) ;

		memset( (*entries)[*numentries].name, 0, desclen+1 ) ;
		memset( (*entries)[*numentries].filename, 0, filelen+1 ) ;

		(*entries)[*numentries].uk = i ;
		fread( (*entries)[*numentries].name, desclen, 1, infile ) ;
		fseek( infile, ( 4*(numfields+1)) + (i*recordlength)+fileofs, SEEK_SET ) ;

		fread( (*entries)[*numentries].filename, filelen, 1, infile ) ;
		
		(*numentries)++ ;

	}

	fclose(infile) ;
	return 1 ;
}

#define FREE_GAMEBASE 		{ for ( int i = 0 ; i < m_numGameBaseEntries ; i++ ) \
		{ \
			if ( m_gameBaseEntries[i].name ) \
				free( m_gameBaseEntries[i].name ) ; \
			if ( m_gameBaseEntries[i].filename ) \
				free( m_gameBaseEntries[i].filename ) ; \
		} \
		free( m_gameBaseEntries ) ; m_gameBaseEntries = NULL ; m_numGameBaseEntries = 0 ; } \

unsigned int CXBoxSample::selectGenre( )
{
	int menuChoice = 0 ;
	char filename[500] ;
	FILE *infile ;

	sprintf( filename, "%s\\GENRES.DAT", m_gamebasePath ) ;

	if ( m_gameBaseEntries )
	{
		FREE_GAMEBASE ;
	}



	while ( 1 )
	{

		if ( m_gameBaseEntries == NULL )
		{
			if ( ! readDataFile( filename, &m_gameBaseEntries, &m_numGameBaseEntries, 0 ) )
			{
				return 0 ;
			}
		}

		if ( m_numGameBaseEntries == 0 )
			return 0 ;

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Select Genre" );

		for ( int i = 0 ; i < m_numGameBaseEntries ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", m_gameBaseEntries[i].name );
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, m_numGameBaseEntries+1, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			return 0 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			return m_gameBaseEntries[menuChoice].uk ;
		}


	}

}

unsigned int CXBoxSample::selectPublisher( unsigned char letter )
{
	int menuChoice = 0 ;
	char filename[500] ;
	FILE *infile ;

	sprintf( filename, "%s\\PUBLISHERS.DAT", m_gamebasePath ) ;

	if ( m_gameBaseEntries )
	{
		FREE_GAMEBASE ;
	}



	while ( 1 )
	{

		if ( m_gameBaseEntries == NULL )
		{
			if ( ! readDataFile( filename, &m_gameBaseEntries, &m_numGameBaseEntries, letter ) )
			{
				return 0 ;
			}
		}

		if ( m_numGameBaseEntries == 0 )
			return 0 ;

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Select Publisher" );

		for ( int i = 0 ; i < m_numGameBaseEntries ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", m_gameBaseEntries[i].name );
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, m_numGameBaseEntries+1, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			return 0 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			return m_gameBaseEntries[menuChoice].uk ;
		}


	}

}



void CXBoxSample::doGamebaseInfo( int selection )
{
	int  uk ;
	int menuChoice = 0 ;
	char filename[500] ;
	char svalue[500] ;
	FILE *infile ;
	int numfields ;
	int blocks ;
	int recordlength, value ;
	int lengths[32] ;

	sprintf( filename, "%s\\GAMES.DAT", m_gamebasePath ) ;

	infile = fopen( filename, "rb" ) ;

	if ( infile == NULL )
	{
		sprintf( filename, "Could not open %s\\GAMES.DAT - check your settings.", m_gamebasePath ) ;
		popupMsg( filename, &m_pnlBackgroundOther ) ;
		return ;
	}



	fread( &numfields, sizeof(int), 1, infile ) ;

	recordlength = 0 ;

	for ( int i = 0 ; i < numfields ; i++ )
	{
		fread( &(lengths[i]), sizeof(int), 1, infile ) ;

		recordlength += lengths[i] ;

	}

	fseek( infile, (4*(numfields+1)) + ( recordlength * m_gameBaseEntries[selection].uk ), SEEK_SET ) ;

	swprintf( m_menuText[0], L"%S", m_gameBaseEntries[selection].name );

	fseek( infile, lengths[0], SEEK_CUR ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	if ( value > 9000 )
		value -= 8000 ;

	swprintf( m_menuText[1], L"Year - %d", value ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_COMMENT_FIELD], 1, infile ) ;

	swprintf( m_menuText[2], L"Comment - %S", svalue ) ;


	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_FILE_FIELD], 1, infile ) ;

	swprintf( m_menuText[3], L"Filename - %S", svalue ) ;

	fread( svalue, lengths[GAME_SCRFILE_FIELD], 1, infile ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_MUSICIAN_FIELD], 1, infile ) ;

	swprintf( m_menuText[4], L"Musician - %S", svalue ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	memset(svalue,0,500) ;

	sprintf( filename, "%s\\GENRES.DAT", m_gamebasePath ) ;

	readDescription( filename, svalue, value ) ;

	swprintf( m_menuText[5], L"Genre - %S", svalue ) ;


	fread( &value, sizeof(int), 1, infile ) ;

	memset(svalue,0,500) ;
	sprintf( filename, "%s\\PUBLISHERS.DAT", m_gamebasePath ) ;

	readDescription( filename, svalue, value ) ;

	swprintf( m_menuText[6], L"Publisher - %S", svalue ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_CRACKER_FIELD], 1, infile ) ;

	swprintf( m_menuText[7], L"Cracker - %S", svalue ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_SID_FIELD], 1, infile ) ;

	swprintf( m_menuText[17], L"SID File - %S", strlen(svalue) < 2 ? "None" : svalue ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_PROGRAMMER_FIELD], 1, infile ) ;

	swprintf( m_menuText[9], L"Programmer - %S", svalue ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_LANGUAGE_FIELD], 1, infile ) ;

	swprintf( m_menuText[10], L"Language - %S", svalue ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	switch ( value )
	{
		case 0 : swprintf( m_menuText[11], L"Video Mode - PAL" ) ; break ;
		case 1 : swprintf( m_menuText[11], L"Video Mode - PAL+NTSC" ) ; break ;
		case 2 : swprintf( m_menuText[11], L"Video Mode - NTSC" ) ; break ;
		default :
		case 3 : swprintf( m_menuText[11], L"Video Mode - PAL(+NTSC?)" ) ; break ;

	}

	fread( &value, sizeof(int), 1, infile ) ;

	swprintf( m_menuText[12], L"TrueDrive Emulation - %S", value ? "Yes" : "No" ) ;

	fread( &blocks, sizeof(int), 1, infile ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	swprintf( m_menuText[13], L"Trainers - %d", value  ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_COMMENT2_FIELD], 1, infile ) ;

	swprintf( m_menuText[14], L"Version Comments - %S", svalue ) ;


	fread( &value, sizeof(int), 1, infile ) ;

	swprintf( m_menuText[15], L"Length - %d %S", blocks, value ? "Disk(s)" : "Block(s)" ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	swprintf( m_menuText[16], L"Max Players - %d", value ) ;

	fread( &value, sizeof(int), 1, infile ) ;

	switch ( value )
	{
		case 1 : swprintf( m_menuText[8], L"Primary Controller - Joystick Port 1" ) ; break ;
		case 2 : swprintf( m_menuText[8], L"Primary Controller - Keyboard" ) ; break ;
		case 3 : swprintf( m_menuText[8], L"Primary Controller - Paddle Port 2" ) ; break ;
		case 5 : swprintf( m_menuText[8], L"Primary Controller - Mouse" ) ; break ;
		case 6 : swprintf( m_menuText[8], L"Primary Controller - Light Pen" ) ; break ;
		case 7 : swprintf( m_menuText[8], L"Primary Controller - Koala Pad" ) ; break ;
		case 8 : swprintf( m_menuText[8], L"Primary Controller - Light Gun" ) ; break ;
		case 0 : 
		default : swprintf( m_menuText[8], L"Primary Controller - Joystick Port 2" ) ; break ;
	}
	

	fclose(infile) ;

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 18, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
		}
	}
}


void CXBoxSample::playSID( int selection )
{
	int  uk ;
	int menuChoice = 0 ;
	char filename[500] ;
	char svalue[500] ;
	FILE *infile ;
	int numfields ;
	int blocks ;
	int recordlength, value ;
	int lengths[32] ;

	sprintf( filename, "%s\\GAMES.DAT", m_gamebasePath ) ;

	infile = fopen( filename, "rb" ) ;

	if ( infile == NULL )
	{
		sprintf( filename, "Could not open %s\\GAMES.DAT - check your settings.", m_gamebasePath ) ;
		popupMsg( filename, &m_pnlBackgroundOther ) ;
		return ;
	}



	fread( &numfields, sizeof(int), 1, infile ) ;

	recordlength = 0 ;

	for ( int i = 0 ; i < numfields ; i++ )
	{
		fread( &(lengths[i]), sizeof(int), 1, infile ) ;

		recordlength += lengths[i] ;

	}

	fseek( infile, (4*(numfields+1)) + ( recordlength * m_gameBaseEntries[selection].uk ), SEEK_SET ) ;

	for ( int i = 0 ; i < GAME_SID_FIELD ; i++ )
		fseek( infile, lengths[i], SEEK_CUR ) ;

	memset(svalue,0,500) ;
	fread( svalue, lengths[GAME_SID_FIELD], 1, infile ) ;

	fclose(infile) ;

	struct stat s ;
	sprintf( filename, "%s\\MUSIC\\%s", m_gamebasePath, svalue ) ;

	if ( strlen(svalue) == 0 )
	{
		popupMsg( "That game has no SID file associated with it.", &m_pnlBackgroundSelect ) ;
	}
	else if ( stat(filename, &s ) )
	{
		sprintf( filename, "Cannot open %s\\MUSIC\\%s", m_gamebasePath, svalue ) ;
		popupMsg( filename, &m_pnlBackgroundSelect ) ;
	}
	else
	{
		if ( m_mp3player.loadFile( filename, 1, 0,9999999 ) )
		{
			//writexbox( "nonomp3\r\n") ;
		}
		else
		{
			//m_mp3player.insertSilence( 22050 ) ;
			m_mp3player.pause( FALSE ) ;
		}
	}

}


int CXBoxSample::gamebaseGameList( int searchType, unsigned char letter, unsigned int uk ) 
{
	int numonscreen ;
	int iTime  ;
	unsigned int retval ;
	unsigned int currSelection ;
	unsigned int oldselection ;
	unsigned int currTopIdx ;
	unsigned int totNumFiles ;
	int screenNum ;
	int didChangeScreen ;
	char filename[500] ;

	sprintf( filename, "%s\\GAMES.DAT", m_gamebasePath ) ;


	if ( !m_bDoingGamebase )
	{
		if ( m_gameBaseEntries )
		{
			FREE_GAMEBASE ;
		}

		popupMsg( "Generating List...", &m_pnlBackgroundOther, 1 ) ;
		if ( ! readGameDataFile( filename, &m_gameBaseEntries, &m_numGameBaseEntries, searchType, uk, letter, m_gamebaseOnlyAvailable, m_gamebasePath ) )
			return 0xFFFFFFFF;
		changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
	}



	if ( m_numGameBaseEntries == 0 )
	{
		popupMsg( "No results!", &m_pnlBackgroundSelect ) ;
		return  0xFFFFFFFF;
	}



	retval = 0xFFFFFFFF ;
	screenNum = m_defaultScreenshots ? 1 : 0 ;
	didChangeScreen = 0 ;


	iTime = 0 ;

	if ( m_bDoingGamebase )
	{
		currSelection = m_gamebaseHoldCurr ;
		currTopIdx = m_gamebaseHoldIdx ;
	}
	else
	{
		currSelection = 0 ;
		currTopIdx = 0 ;
	}

	totNumFiles = m_numGameBaseEntries ;
	oldselection = currSelection ;


	while ( 1 )
	{
		if ( m_gameBaseEntries == NULL )
		{
			popupMsg( "Generating List...", &m_pnlBackgroundSelect, 1 ) ;
			if ( ! readGameDataFile( filename, &m_gameBaseEntries, &m_numGameBaseEntries, searchType, uk, letter, m_gamebaseOnlyAvailable, m_gamebasePath ) )
				return retval;
		}

		if ( m_numGameBaseEntries == 0 )
		{
			popupMsg( "No results!", &m_pnlBackgroundSelect ) ;
			return  retval;
		}

		pmenuParams = &(m_skin.gameSelectMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );

		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_plaything.Render( 0,0,0 ) ;

		screenNum = showScreenshot( screenNum, currSelection, 0, pmenuParams, 1 ) ;

		m_mp3player.process() ;




		numonscreen = 0 ;
		swprintf( m_menuText[0], L"LThumb Left/Right For Screenshots" ) ;

		for ( unsigned int idx = currTopIdx ; ( idx < totNumFiles ) && ( idx < currTopIdx+pmenuParams->maxNumLines) ; idx++ )
		{
			swprintf( m_menuText[idx-currTopIdx+1], L"%S", m_gameBaseEntries[idx].name ) ;
			numonscreen++ ;
		}
		
		
		renderMenuText( 1, currSelection-currTopIdx, m_menuText, numonscreen+1, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return retval ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( currSelection == currTopIdx + (pmenuParams->maxNumLines-1) )
			{
				if ( currSelection+1 < totNumFiles  )
				{
					currTopIdx++ ;
					currSelection++ ;
				}
			}
			else
			{
				if ( currSelection+1 < totNumFiles )
					currSelection++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( currSelection == currTopIdx )
			{
				if ( currSelection > 0 )
				{
					currTopIdx-- ;
					currSelection-- ;
				}
			}
			else
			{
				if ( currSelection > 0 )
					currSelection-- ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			char c ;
			int lcv ;

			c = tolower( m_gameBaseEntries[currSelection].name[0]) ;

			lcv = currSelection ;

			while ( ( lcv < totNumFiles ) && ( tolower( m_gameBaseEntries[lcv].name[0] ) <= c ) )
				lcv++ ;

			if ( lcv < totNumFiles )
			{
				currTopIdx = lcv ;
				currSelection = lcv ;
			}
			else
			{
				currTopIdx = totNumFiles - 1 ;
				currSelection = totNumFiles - 1 ;
			}
				
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			char c ;
			int lcv ;

			c = tolower( m_gameBaseEntries[currSelection].name[0] ) ;

			lcv = currSelection ;

			while ( ( lcv >= 0 ) && ( tolower( m_gameBaseEntries[lcv].name[0] ) >= c ) )
				lcv-- ;

			if ( lcv >= 0  )
			{
				currTopIdx = lcv ;
				currSelection = lcv ;
			}
			else
			{
				currTopIdx = 0 ;
				currSelection =  0;
			}

				
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER];

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				if ( currSelection == currTopIdx + (pmenuParams->maxNumLines-1) )
				{
					if ( currSelection < totNumFiles - 1 )
					{
						currTopIdx++ ;
						currSelection++ ;
					}
				}
				else
				{
					if ( currSelection < totNumFiles-1 )
						currSelection++ ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				if ( currSelection == currTopIdx )
				{
					if ( currSelection > 0 )
					{
						currTopIdx-- ;
						currSelection-- ;
					}
				}
				else
				{
					if ( currSelection > 0 )
						currSelection-- ;
				}
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			//launch game

			struct stat s ;
			sprintf( filename, "%s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[currSelection].filename ) ;
			if ( stat(filename, &s ) )
			{
				sprintf( filename, "Cannot open %s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[currSelection].filename ) ;
				popupMsg( filename, &m_pnlBackgroundSelect ) ;
			}
			else
			{
				if ( m_bDoingGamebase )
				{
					return currSelection ;
				}
				else
				{
					m_bDoingGamebase = 1;

					m_gamebaseHoldCurr = currSelection ;
					m_gamebaseHoldIdx = currTopIdx ;
					m_bAutoLoaded = 0 ;
					m_bInCaptureMode = 0 ;
					emuLaunch( currSelection, 0, m_gamebaseForceConfig, 1 ) ;
					m_bDoingGamebase = 0;

					retval = currSelection ;
				}
			}

		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			struct stat s ;
			sprintf( filename, "%s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[currSelection].filename ) ;
			if ( stat(filename, &s ) )
			{
				sprintf( filename, "Cannot find %s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[currSelection].filename ) ;
				popupMsg( filename, &m_pnlBackgroundSelect ) ;
			}
			else
			{
				addFavorite( filename ) ;
				saveFavorites() ;

				popupMsg( "File Added To Your Favorites List", &m_pnlBackgroundSelect ) ;
			}

		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			//play SID

			playSID( currSelection ) ;

		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
			doGamebaseInfo( currSelection ) ;
			changeMenu( &m_skin.otherMenu , &m_skin.gameSelectMenu ) ;
			//show INFO

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
		{
			musicControlMenu( &m_pnlBackgroundSelect) ;
		}

		if ( g_Gamepads[0].hDevice && ( g_Gamepads[0].fX1 > 0.30f ) ) 
		{
			if ( !didChangeScreen )
			{
				screenNum++ ;
				didChangeScreen = 1 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && ( g_Gamepads[0].fX1 < -0.30f ) ) 
		{
			if ( !didChangeScreen )
			{
				screenNum-- ;
				didChangeScreen = 1 ;
			}
		}
		else
		{
			didChangeScreen = 0 ;
		}

		if ( oldselection != currSelection )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			screenNum = m_defaultScreenshots ? 1  : 0;
		}

		oldselection = currSelection ;
	}


	return retval ;
}

void CXBoxSample::doGamebase64( )
{
	unsigned char letter ;
	int  uk ;
	int menuChoice = 0 ;
	char filename[500] ;
	FILE *infile ;

	sprintf( filename, "%s\\GAMES.DAT", m_gamebasePath ) ;

	infile = fopen( filename, "rb" ) ;

	if ( infile == NULL )
	{
		sprintf( filename, "Could not open %s\\GAMES.DAT - check your settings.", m_gamebasePath ) ;
		popupMsg( filename, &m_pnlBackgroundOther ) ;
	}
	else
	{
		fclose( infile ) ;
	}


	sprintf( filename, "%s\\GENRES.DAT", m_gamebasePath ) ;

	infile = fopen( filename, "rb" ) ;

	if ( infile == NULL )
	{
		sprintf( filename, "Could not open %s\\GENRES.DAT - check your settings.", m_gamebasePath ) ;
		popupMsg( filename, &m_pnlBackgroundOther ) ;
	}
	else
	{
		fclose( infile ) ;
	}

	sprintf( filename, "%s\\PUBLISHERS.DAT", m_gamebasePath ) ;

	infile = fopen( filename, "rb" ) ;

	if ( infile == NULL )
	{
		sprintf( filename, "Could not open %s\\PUBLISHERS.DAT - check your settings.", m_gamebasePath ) ;
		popupMsg( filename, &m_pnlBackgroundOther ) ;
	}
	else
	{
		fclose( infile ) ;
	}



	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Gamebase64" );
		swprintf( m_menuText[1], L"Browse by Game Name");
		swprintf( m_menuText[2], L"Browse by Genre");
		swprintf( m_menuText[3], L"Browse by Publisher");
		swprintf( m_menuText[4], L"Browse Multiplayer Games");
		swprintf( m_menuText[5], L"Only Show Available Games - %S", m_gamebaseOnlyAvailable ? "Yes" : "No" ) ;
		swprintf( m_menuText[6], L"Force Configuration Before Each Load - %S", m_gamebaseForceConfig ? "Yes" : "No" ) ;
		swprintf( m_menuText[7], L"Change Gamebase Directory");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 8, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					while ( letter = selectLetter() )
					{
						gamebaseGameList( SEARCH_GAME, letter, 0 ) ;
						changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					}
					break ;
				}
				case 1 : 
				{
					while ( uk = selectGenre() )
					{
						gamebaseGameList( SEARCH_GENRE, 0, uk ) ;
						changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					}
					break ;
				}
				case 2 : 
				{
					while ( letter = selectLetter() )
					{
						while ( uk = selectPublisher( letter ) )
						{
							gamebaseGameList( SEARCH_PUBLISHER, 0, uk ) ;
							changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
						}
					}
					break ;
				}
				case 3 : 
				{
					gamebaseGameList( SEARCH_MULTIPLAYER, 0, 0 ) ;
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				case 4 : m_gamebaseOnlyAvailable = ! m_gamebaseOnlyAvailable ; break ;
				case 5 : m_gamebaseForceConfig= ! m_gamebaseForceConfig; break ;
				case 6 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_gamebasePath, m_szCurrentDir ) ;
						while ( strlen( m_gamebasePath) && ( m_gamebasePath[strlen(m_gamebasePath)-1] == '\\' ) )
						{
							m_gamebasePath[strlen(m_gamebasePath)-1] = 0 ;
						}
						doSaveIni() ;
					}
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				default : break ;
			}
		}


	}

	if ( m_gameBaseEntries )
	{
		FREE_GAMEBASE ;
	}

}



void CXBoxSample::doDeleteCode( int selected )
{
	CHEAT_CODE *tempbuf ;

	tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

	memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

	if ( selected < m_numCheats-1 )
	{
		memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
	}

	free( m_cheatCodes ) ;

	m_cheatCodes = tempbuf ;
	m_numCheats-- ;
}


void CXBoxSample::updateEmuSpecificCheats( ) 
{
}
void CXBoxSample::doLoadNewDisk( int which, int gamebase )
{

	char filename[500] ;
	char shortpath[500] ;
	int isOther = 0 ;
	DWORD selectedGame ;

	if ( gamebase && !m_bDoingGamebase )
	{
		popupMsg("You are not currently in Gamebase mode.", &m_pnlBackgroundOther ) ;
		return ;
	}

	changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;

	if ( ( gamebase && ( ( selectedGame = gamebaseGameList( 0, 0,0 ) ) != 0xFFFFFFFF ) ) ||
		 ( !gamebase && ( ( selectedGame = doSelectGame( 0, 1 ) ) != 0xFFFFFFFF )  ) )
	{
		if ( gamebase )
		{
			sprintf( (char*)filename, "%s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[selectedGame].filename ) ;
		}
		else
		{
			strcpy((char*)filename, m_szCurrentDir ) ;
			strcat( (char*)filename, (const char*)files[selectedGame].filename ) ;
		}

		m_bUsingSamba = ( strncmp( filename, "SMB:", 4 ) == 0 ) || ( strncmp( filename, "smb:", 4 ) == 0 ) ;
		m_bUsingRelax = ( strncmp( filename, "RLX:", 4 ) == 0 ) || ( strncmp( filename, "rlx:", 4 ) == 0 ) ;

		xbox_print_memory() ;
		if ( (strstr (filename, ".MP3")) || (strstr (filename, ".mp3")) )
		{
			if ( m_mp3player.loadFile( filename, 1, 0, 9999999 ) )
			{
				//writexbox( "nonomp3\r\n") ;
			}
			else
			{
				//m_mp3player.insertSilence( 22050 ) ;
				m_mp3player.pause( FALSE ) ;
				return  ;
			}
		}

		if ( (strstr (filename, ".M3U")) || (strstr (filename, ".m3u")) )
		{
			if ( m_mp3player.loadPlaylist( filename ) )
			{
				//writexbox( "nonomp3\r\n") ;
			}
			else
			{
				//m_mp3player.insertSilence( 22050 ) ;
				m_mp3player.pause( FALSE ) ;
				return  ;
			}
		}

		cht_save() ;
		xbox_print_memory() ;

		char *p ;

		sprintfx("init\r\n") ;

		if ( strlen( strrchr( filename, '\\' )+1 ) > 42 )
		{
			strncpy( shortpath, strrchr( filename, '\\' )+1, 42 ) ;
			shortpath[42] = 0 ;

			p = strrchr( filename, '.' ) ;

			if ( p )
			{
				strcpy( shortpath+( 41 - strlen(p) ), p ) ;
			}
		}
		else
		{
			strcpy( shortpath, strrchr( filename, '\\' )+1 ) ;
		}


		while( strchr( shortpath, ',' ) )
			*strchr( shortpath, ',' ) = '_' ;


		strcpy( g_saveprefix, g_savePath ) ;
		strcat( g_saveprefix, "\\" ) ;
		strcat( g_saveprefix, shortpath ) ;
		//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
		p = strchr(g_saveprefix, '.');
		if (p) *p = 0;

		strcpy(g_settingsfile, g_saveprefix);
		strcat(g_settingsfile, ".stg");

		strcpy(g_keysfile, g_saveprefix);
		strcat(g_keysfile, ".key");

		strcpy(g_sramfile, g_saveprefix);
		strcat(g_sramfile, ".sav");

		strcpy(g_statefile, g_saveprefix);
		strcat(g_statefile, ".st0");

		strcpy(g_chtfile, g_saveprefix);
		strcat(g_chtfile, ".cht");

		sprintfx("init\r\n") ;


		memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

		xbox_print_memory() ;


		memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

		xbox_print_memory() ;
		sprintfx("init\r\n") ;

		global_error_message[0] = 0 ;



		if ( !m_bBgmInGame )
		{
			m_mp3player.pause( TRUE ) ;
		}




		xbox_print_memory() ;


		if ( m_bUsingSamba )
		{
			char smbfilename[1024] ;
			char *smbp ;
			int sambafile ;
			FILE *outfile ;


			sprintf( smbfilename, "%s%s", m_smbShare, filename+4 ) ;

			while ( smbp = strchr( smbfilename, '\\' ) )
				*smbp = '/' ;


			sambafile = m_smb.open( smbfilename,O_RDONLY|O_BINARY);

			sprintfx( "%s\r\n", smbfilename ) ;



			if ( sambafile <= 0 )
			{
				return ;
			}

			sprintf( smbfilename, "Z:\\%s", shortpath ) ;
			strcpy(filename, smbfilename) ;

			outfile = fopen(filename, "wb") ;

			if ( outfile == NULL )
			{
				m_smb.close( sambafile ) ;
				return ;
			}

			int filesize = m_smb.lseek(sambafile,0,SEEK_END);
			m_smb.lseek(sambafile,0,SEEK_SET);

			char *fbuf = (char*) malloc( filesize ) ;

			m_smb.read(sambafile,fbuf, filesize) ;
			fwrite( fbuf, sizeof(char), filesize, outfile ) ;

			fclose(outfile) ;
			m_smb.close( sambafile ) ;

			free(fbuf) ;

		}
		else if ( m_bUsingRelax )
		{
			char rlxfilename[1024] ;
			FILE *outfile ;
			int filesize ;
			char *fbuf ;

			if ( m_relax.Open( filename ) )
			{
				sprintfx( "opened rlx %s\r\n", filename ) ;
				filesize = m_relax.GetLength() ;


				sprintf( rlxfilename, "Z:\\%s", shortpath) ;
				strcpy(filename, rlxfilename) ;

				outfile = fopen(filename, "wb") ;

				if ( outfile == NULL )
				{
					m_relax.Close( ) ;
					return ;
				}


				fbuf = (char*) malloc( filesize ) ;

				if ( !fbuf )
				{
					m_relax.Close() ;
					return ;
				}

				if ( ! m_relax.ReadAll( fbuf, filesize ) )
				{
					free(fbuf) ;
					m_relax.Close() ;
					return ;
				}

				m_relax.Close() ;

				fwrite( fbuf, 1, filesize, outfile ) ;
				fclose( outfile ) ;
				free(fbuf) ;
			}
			else
			{
				return ;
			}


		}

		cht_load();



		sprintfx("init\r\n") ;

		m_fAppTime = 0.0f ;

		g_dwStartTime = GetTickCount() ;
		g_dwTimePaused = 0 ;
		m_dwStartPause = 0 ;

		m_steps = 0 ;
		m_sound.pause( FALSE ) ;

		sprintfx( "about to vba_main %s\r\n", filename ) ;

		char uprfilename[500] ;

		strcpy( uprfilename, filename ) ;
		strupr( uprfilename ) ;

		file_system_detach_disk(8);

		if ( strstr( uprfilename, ".ZIP" ) )
		{
			unzipC64( uprfilename, filename ) ;
			strcpy( uprfilename, filename ) ;
			strupr( uprfilename ) ;
		}

		if ( loadSettings( g_settingsfile ) )
		{
			changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
			doConfigureGame( g_settingsfile, g_keysfile, filename ) ;
			isOther = 1 ;
		}

		if ( !isOther )
		{
			loadKeys( g_keysfile ) ;
		}

		m_startTime = GetTickCount() ;

		file_system_attach_disk(8, filename) ;

	}

	if ( isOther == 0 )
		changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;

}

#define DISK_IMAGE_TYPE_D64 1541

void CXBoxSample::createBlankDisk( ) 
{
	DWORD selectedGame ;
	char name[100] ;
	char filename[500] ;

	changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
	selectedGame = doSelectGame( 0,1,1 ) ;
	changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;

	if ( selectedGame  != 0xFFFFFFFF ) 
	{
		popupMsg( "Now enter the filename (without path)", &m_pnlBackgroundOther ) ;

		memset(name, 0, 100) ;
		getKeyboardString( name, 100 ) ;

		if( strlen(name) )
		{
			strcpy( filename, m_szCurrentDir ) ;
			while ( strlen( filename) && ( filename[strlen(filename)-1] == '\\' ) )
			{
				filename[strlen(filename)-1] = 0 ;
			}
			strcat( filename, "\\" ) ;
			strcat( filename, name ) ;

			if ( strrchr( filename, '.' ) )
				*strrchr( filename, '.') = 0 ;

			strcat( filename, ".D64" ) ;

			struct stat s ;

			if ( !stat(filename, &s) )
			{
				if ( yesNoMenu( "Do you wish to overwrite the existing file?", &m_pnlBackgroundOther ) == 1 )
					return ;
			}

            if (vdrive_internal_create_format_disk_image(filename,
                "vice,1a", DISK_IMAGE_TYPE_D64) < 0) {
				popupMsg( "Could not create blank image.", &m_pnlBackgroundOther ) ;
                return ;
            }

			if ( strrchr( filename, '\\' ) )
				*strrchr(filename, '\\' ) = 0 ;

			strcat(filename, "\\*" ) ;
			FindAvailRoms(filename) ;

		}

	}
}

void CXBoxSample::performEmuSpecificOption( int start, int menuChoice ) 
{
	if ( menuChoice == start )
	{
		doLoadNewDisk( 8,0 ) ;
	}
	else if ( menuChoice == start+1 )
	{
		doLoadNewDisk( 8,1 ) ;
	}
	else if ( menuChoice == start+2 )
	{
		createBlankDisk() ;
	}
}

int charToHex( char c )
{
	if ( ( c >= '0' ) && ( c <= '9' ) )
		return c-'0' ;
	else
		return c-'A'+10 ;
}

int strToHex( char *str, int len )
{
	int base ;
	int val ;

	base = 1 ;

	val = 0 ;

	for ( int i = len-1 ; i >= 0 ; i-- )
	{
		val += charToHex(str[i])*base ;
		base *= 16 ;
	}

	return val ;
}

int CXBoxSample::validateCode( char *code, CHEAT_CODE *ccode, int codetype )
{

			ccode->type = strToHex( code, 2 ) ;
			ccode->adr = strToHex( code+2, 6 ) ;
			ccode->val = strToHex( code+8, 4 ) ;


			sprintf( ccode->code, "%02.2X%06.6X %04.4X", ccode->type, ccode->adr, ccode->val & 0xFFFF ) ;

			if ( ( ccode->adr >= CONSOLE_MEMORY_SIZE ) )
			{
				return 0 ;
			}
			else if ( ! ( ( ccode->type == 0x80 ) || ( ccode->type == 0x30 ) || ( ccode->type == 0xD0 ) || ( ccode->type == 0xD1 ) || 
								( ccode->type == 0xD2 ) || ( ccode->type == 0xD3 ) || ( ccode->type == 0xE0 ) || ( ccode->type == 0xE1 ) || 
								( ccode->type == 0xE2 ) || ( ccode->type == 0xE3 ) || ( ccode->type == 0x10 ) || ( ccode->type == 0x11 ) || 
								( ccode->type == 0x20 ) || ( ccode->type == 0x21 ) ) )
			{
				return 0 ;
			}


	return 1 ;
}









//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	InitializeWithScreen() ;
    return S_OK;
}


int CXBoxSample::render_to_texture( video_canvas_t *canvas, int width,
                         int height, int xs, int ys, int xt, int yt, int fillbuff )
{
	RECT src, dst;
	byte *curr1 ; 
	byte *curr2 ;
	DWORD pitchDiff ; 
	D3DCOLOR *palette ;
	char palstr[200] ;
	DWORD pixel ;
	byte r,g,b ;
	int w,h ;

	if ( gAllDone )
		return 0 ;

	w = 384 ;
	h = 272 ;

	m_numFrames++ ;

	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	if ( fillbuff )
	{
		m_screenUpdated= 1 ;
		// Lock the rect in our texture
		D3DLOCKED_RECT d3dlr;
		Texture->LockRect(0, &d3dlr, &rectSource, 0);




		if ( m_xboxSFilter == 0 )
		{
			video_canvas_render(canvas,
								(unsigned char*)d3dlr.pBits,
								width, height,
								xs,ys,
								xt,yt,
								m_pitch,
								16); 

		}
		else
		{
			video_canvas_render(canvas,
								g_pBlitBuff,
								width, height,
								xs,ys,
								xt,yt,
								m_pitch,
								16); 
			SOFTWARE_FILTERS[m_xboxSFilter].blitfunc(g_pBlitBuff + m_pitch,m_pitch, g_pDeltaBuff, ((unsigned char*)d3dlr.pBits)+d3dlr.Pitch, d3dlr.Pitch, w, h, 0 ) ;
		}

		float mx, my ;

		if ( m_xboxSFilter )
		{
			//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);
			//memcpy( d3dlr.pBits, g_pBlitBuff, desc.Size ) ;
			Texture->UnlockRect(0);
			//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );
			g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
			g_pd3dDevice->BeginScene();

			//memcpy( g_pDeltaBuff, g_pUnpaletteBuff, 240*512 ) ;
			mx = (float)m_nScreenMaxX / ((float)w*SOFTWARE_FILTERS[m_xboxSFilter].multiplier) ;
			my = (float)m_nScreenMaxY / ((float)h*SOFTWARE_FILTERS[m_xboxSFilter].multiplier);

			m_gameRectSource.top = 0;
			m_gameRectSource.left = 0;
			m_gameRectSource.bottom = (h - 1)*SOFTWARE_FILTERS[m_xboxSFilter].multiplier ;
			m_gameRectSource.right  = (w - 1)*SOFTWARE_FILTERS[m_xboxSFilter].multiplier;
		}
		else
		{
			//systemDrawScreenNoFilter( (unsigned char*)d3dlr.pBits) ;
			//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);
			//memcpy( d3dlr.pBits, g_pBlitBuff, desc.Size ) ;
			Texture->UnlockRect(0);
			//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );
			g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
			g_pd3dDevice->BeginScene();

			mx = (float)m_nScreenMaxX / ((float)w) ;
			my = (float)m_nScreenMaxY / ((float)h);

			m_gameRectSource.top = 0;
			m_gameRectSource.left = 0;
			m_gameRectSource.bottom = (h - 1) ;
			m_gameRectSource.right  = (w - 1);
		}

		m_gameVecScale.x = mx ; m_gameVecScale.y = my;
	}
	else
	{
			g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
			g_pd3dDevice->BeginScene();
	}

	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	m_gameVecTranslate.x = m_nScreenX ; m_gameVecTranslate.y = m_nScreenY ;




	m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
	//m_pnlGameScreen.Render(m_nScreenX ,m_nScreenY,m_nScreenMaxX*mx,m_nScreenMaxY*my) ;

//	Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
/*
	if ( global_error_message[0] )
	{
		if ( m_msgDelay > 0 )
		{
			WCHAR msg[500] ;
			m_msgDelay-- ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}
	*/
	if ( global_error_message[0] )
	{
		WCHAR msg[500] ;
		m_msgDelay-- ;
		swprintf( msg, L"%S", global_error_message ) ;

		m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;

		if ( m_msgDelay <= 0 )
		{
			global_error_message[0] = 0 ;
		}
	}
	/*
	else
	{
		if ( GetTickCount() - m_startTime > 0 )
		{
			sprintf( global_error_message, "%2.2f FPS - %u frames in %3.2f sec", ((float)m_numFrames*1000.0f)/((float)( GetTickCount() - m_startTime )), m_numFrames, ((float)( GetTickCount() - m_startTime ))/1000.0f ) ;
			m_msgDelay = 1 ;
			WCHAR msg[500] ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
		else
		{
			sprintf( global_error_message, "<inf> FPS" ) ;
			m_msgDelay = 1 ;
			WCHAR msg[500] ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}
*/

#ifdef LIGHTGUN
	if ( m_zapperNum )
	{
		if ( m_lightgun.wButtons & XINPUT_LIGHTGUN_ONSCREEN  )
		{
			FLOAT fWidth = 640.0f ;
			FLOAT fHeight = 480.0f ;
			FLOAT fThumbLX = (fWidth/2) + (fWidth/2)*(m_lightgun.sThumbLX+0.5f)/32767.5f;
			FLOAT fThumbLY = (fHeight/2) - (fHeight/2)*(m_lightgun.sThumbLY+0.5f)/32767.5f;
		    ColorBar( fThumbLX-10, fThumbLY-10, 20,20, 0xFF00FF00 );
		}
	}
#endif

	renderScreenKeyboard() ;

	// End the scene.
	g_pd3dDevice->EndScene();

	//if ( ! m_throttle )
		//g_pd3dDevice->BlockUntilVerticalBlank();

	g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

/*
	float FPS, desiredFPS ;

	desiredFPS = 60.0f;

	if ( m_throttle )
		desiredFPS = desiredFPS * 3.0f ;


	//do
	{
		QueryPerformanceCounter((union _LARGE_INTEGER *) m_performanceCurr);

		if (m_performanceCurr[0] != m_performancePrev[0])
		{					
			FPS = (float) (m_performanceFreq[0])  / (float) (m_performanceCurr[0] - m_performancePrev[0]);
			sprintf( global_error_message, "fps=%.1f %.1f\r\n", FPS, desiredFPS);
		}
		else
		{
			FPS = 100.0f ;
			sprintf( global_error_message, "fps=too much...\r\n");
		}

		//view_fps = 0;
	} //while ( FPS > desiredFPS ) ;

	m_performancePrev[0] = m_performanceCurr[0];
*/

	return 1;
	
	// Swizzle the blittled surface back to the texture
	//XGSwizzleRect(g_pAlignBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 1);


	// Swizzle the blittled surface back to the texture
//	XGSwizzleRect(XBuf+8, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 1);
	//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 4);
/*
	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;


	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 0;
	src.bottom = theHeight + 1;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;


	float mx, my ;

	mx = (float)m_nScreenMaxX / (float)theWidth ;
	my = (float)m_nScreenMaxY / (float)theHeight ;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(mx, my);
	D3DXVECTOR2 vecTranslate(m_nScreenX, m_nScreenY );


	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	//D3DXVECTOR2 vecScale(2, 2);
	//D3DXVECTOR2 vecTranslate(56, 0 );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	if ( global_error_message[0] )
	{
		if ( m_msgDelay > 0 )
		{
			WCHAR msg[500] ;
			m_msgDelay-- ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}

	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
	*/
}






void CXBoxSample::renderImage( unsigned char *image) 
{
	RECT src, dst;
	WORD *curr1 ; 
	byte *curr2 ;
	DWORD pitchDiff ; 
	D3DCOLOR *palette ;
	char palstr[200] ;
	DWORD pixel ;
	byte r,g,b ;
	int w,h ;

	//sprintfx( "renderimage\r\n") ;

	w = 160 ;
	h = 192 ;

	m_numFrames++ ;

	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);



	for ( unsigned int y = 0 ; y < 192 ; y++ )
	{
		DWORD color ;

		if ( m_xboxSFilter )
			curr1 = (WORD*)( g_pBlitBuff + ( y*d3dlr.Pitch )) ;
		else
			curr1 = (WORD*)( (unsigned char*)d3dlr.pBits + ( y*d3dlr.Pitch )) ;

		curr2 = ((byte*)image) + ( y*160 )  ;

		for ( int x = 0 ; x < 160 ; x++ )
		{
			*curr1++ = (color_palette[*curr2++])&0xFFFF ;
		}
		//memcpy( curr1, curr2, theWidth ) ;
	}



	SOFTWARE_FILTERS[m_xboxSFilter].blitfunc(g_pBlitBuff + d3dlr.Pitch,d3dlr.Pitch, g_pDeltaBuff, ((unsigned char*)d3dlr.pBits)+m_pitch, m_pitch, 160, 192, 0 ) ;

	float mx, my ;

	Texture->UnlockRect(0);



}

void CXBoxSample::putImage( ) 
{
	RECT src, dst;
	WORD *curr1 ; 
	byte *curr2 ;
	DWORD pitchDiff ; 
	D3DCOLOR *palette ;
	char palstr[200] ;
	DWORD pixel ;
	byte r,g,b ;
	int w,h ;

	//sprintfx( "putimage\r\n") ;

	w = 160 ;
	h = 192 ;

	m_numFrames++ ;


	float mx, my ;

	if ( m_xboxSFilter )
	{
		//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);
		//memcpy( d3dlr.pBits, g_pBlitBuff, desc.Size ) ;
		//Texture->UnlockRect(0);
		//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
		g_pd3dDevice->BeginScene();

		//memcpy( g_pDeltaBuff, g_pUnpaletteBuff, 240*512 ) ;
		mx = (float)m_nScreenMaxX / ((float)w*SOFTWARE_FILTERS[m_xboxSFilter].multiplier) ;
		my = (float)m_nScreenMaxY / ((float)h*SOFTWARE_FILTERS[m_xboxSFilter].multiplier);

		m_gameRectSource.top = 0;
		m_gameRectSource.left = 0;
		m_gameRectSource.bottom = (h - 1)*SOFTWARE_FILTERS[m_xboxSFilter].multiplier ;
		m_gameRectSource.right  = (w - 1)*SOFTWARE_FILTERS[m_xboxSFilter].multiplier;
	}
	else
	{
		//systemDrawScreenNoFilter( (unsigned char*)d3dlr.pBits) ;
		//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);
		//memcpy( d3dlr.pBits, g_pBlitBuff, desc.Size ) ;
		//Texture->UnlockRect(0);
		//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
		g_pd3dDevice->BeginScene();

		mx = (float)m_nScreenMaxX / ((float)w) ;
		my = (float)m_nScreenMaxY / ((float)h);

		m_gameRectSource.top = 0;
		m_gameRectSource.left = 0;
		m_gameRectSource.bottom = (h - 1) ;
		m_gameRectSource.right  = (w - 1);
	}



	m_gameVecScale.x = mx ; m_gameVecScale.y = my;
	m_gameVecTranslate.x = m_nScreenX ; m_gameVecTranslate.y = m_nScreenY ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);




	m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
	//m_pnlGameScreen.Render(m_nScreenX ,m_nScreenY,m_nScreenMaxX*mx,m_nScreenMaxY*my) ;

//	Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
/*
	if ( global_error_message[0] )
	{
		if ( m_msgDelay > 0 )
		{
			WCHAR msg[500] ;
			m_msgDelay-- ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}
	*/
	if ( global_error_message[0] )
	{
		WCHAR msg[500] ;
		m_msgDelay-- ;
		swprintf( msg, L"%S", global_error_message ) ;

		m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;

		if ( m_msgDelay <= 0 )
		{
			global_error_message[0] = 0 ;
		}
	}
	/*
	else
	{
		if ( GetTickCount() - m_startTime > 0 )
		{
			sprintf( global_error_message, "%2.2f FPS - %u frames in %3.2f sec", ((float)m_numFrames*1000.0f)/((float)( GetTickCount() - m_startTime )), m_numFrames, ((float)( GetTickCount() - m_startTime ))/1000.0f ) ;
			m_msgDelay = 1 ;
			WCHAR msg[500] ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
		else
		{
			sprintf( global_error_message, "<inf> FPS" ) ;
			m_msgDelay = 1 ;
			WCHAR msg[500] ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}
*/

#ifdef LIGHTGUN
	if ( m_zapperNum )
	{
		if ( m_lightgun.wButtons & XINPUT_LIGHTGUN_ONSCREEN  )
		{
			FLOAT fWidth = 640.0f ;
			FLOAT fHeight = 480.0f ;
			FLOAT fThumbLX = (fWidth/2) + (fWidth/2)*(m_lightgun.sThumbLX+0.5f)/32767.5f;
			FLOAT fThumbLY = (fHeight/2) - (fHeight/2)*(m_lightgun.sThumbLY+0.5f)/32767.5f;
		    ColorBar( fThumbLX-10, fThumbLY-10, 20,20, 0xFF00FF00 );
		}
	}
#endif
	// End the scene.
	g_pd3dDevice->EndScene();

	//if ( ! m_throttle )
		//g_pd3dDevice->BlockUntilVerticalBlank();

	g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

/*
	float FPS, desiredFPS ;

	desiredFPS = 60.0f;

	if ( m_throttle )
		desiredFPS = desiredFPS * 3.0f ;


	//do
	{
		QueryPerformanceCounter((union _LARGE_INTEGER *) m_performanceCurr);

		if (m_performanceCurr[0] != m_performancePrev[0])
		{					
			FPS = (float) (m_performanceFreq[0])  / (float) (m_performanceCurr[0] - m_performancePrev[0]);
			sprintf( global_error_message, "fps=%.1f %.1f\r\n", FPS, desiredFPS);
		}
		else
		{
			FPS = 100.0f ;
			sprintf( global_error_message, "fps=too much...\r\n");
		}

		//view_fps = 0;
	} //while ( FPS > desiredFPS ) ;

	m_performancePrev[0] = m_performanceCurr[0];
*/

	
}

void CXBoxSample::InitializeEmuSpecific()
{

    //m_bliss32.setProgramName("bliss");

	g_pUnpaletteBuff = NULL ;
	m_gameBaseEntries = NULL ;
	m_numGameBaseEntries = 0 ;
	m_gamebaseOnlyAvailable = 0 ;
	m_gamebaseForceConfig = 0 ;
	m_bDoingGamebase = 0 ;



	//m_cdda.dsound = m_sound.dsound ;
	//m_cdda.dsound_init() ;
	//m_cdda.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;

//	LoadCheatDB() ;


	FILE *outfile ;

	outfile = fopen( "Z:\\WIN_POS.VKM", "wb" ) ;

	if (outfile)
	{
		fwrite( WINPOS_VKM, 7668, 1, outfile ) ;
		fclose( outfile ) ;
	}

	int margc = 0 ;
	int origmargc = 0 ;
	char *margv[100] ;
	char *origmargv[100] ;

	margv[margc++] = (char*)malloc(20) ;
	strcpy( margv[margc-1], "vicex64.xbe" ) ;

	//margv[margc++] = (char*)malloc(500) ;
	//strcpy( margv[margc-1], filename ) ;

	origmargc = margc ;

	for ( int i = 0 ; i < margc ; i++ )
	{
		origmargv[i] = margv[i] ;
	}


	gAllDone = 1 ;

	main_program(margc, margv) ;

	gAllDone = 0 ;

	for ( int i = 0 ; i < origmargc ; i++ )
	{
		free( origmargv[i] ) ;
	}

}


//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{


    return S_OK;
}





#ifdef LIGHTGUN

void CXBoxSample::doZapper()
{
	BOOL bShotFired;
	BOOL bShotHitScreen;
	BOOL bShotMissedScreen;
	int foundgun = 0 ;

	// Check all ports for a lightgun
	for( DWORD i=0; i<4; i++ )
	{
		if( g_Gamepads[i].hDevice && g_Gamepads[i].caps.SubType == XINPUT_DEVSUBTYPE_GC_LIGHTGUN )
		{
			// Copy the gamepad input to the lightgun structure.
			// Note: This is just for convenience so we can refer to a 
			// "lightgun" instead of a "gamepad".
			m_lightgun.CopyInput( &g_Gamepads[i], i );
			foundgun = 1 ;
			break ;

		}
	}

	if ( foundgun == 0 )
	{
		return ;
	}

	//m_lightgun.DisplayWhiteField() ;

	// Make sure the gun is properly calibrated. Note that this is called every
	// frame in case the state of the display changes
	m_lightgun.VerifyCalibrationState( FALSE );

	// Set the vibration motors
	//m_Lightgun.SetVibrationMotors( m_wLeftMotorSpeed, m_wRightMotorSpeed );


	m_lightgun.Update( &bShotFired, &bShotHitScreen, &bShotMissedScreen );

	m_zapperDat[2] = 0 ;

	if ( bShotFired )
	{
		m_zapperDat[2] |= 1 ;
		if ( bShotMissedScreen )
		{
			m_zapperDat[2] |= 2 ;
		}
	}

	FLOAT fWidth = 640.0f ;
	FLOAT fHeight = 480.0f ;
    FLOAT fThumbLX = (fWidth/2) + (fWidth/2)*(m_lightgun.sThumbLX+0.5f)/32767.5f;
    FLOAT fThumbLY = (fHeight/2) - (fHeight/2)*(m_lightgun.sThumbLY+0.5f)/32767.5f;


	if ( ( fThumbLX > m_nScreenX ) && ( fThumbLX < m_nScreenX + m_nScreenMaxX ) &&
		 ( fThumbLY > m_nScreenY ) && ( fThumbLY < m_nScreenY + m_nScreenMaxY ) )
	{
		m_zapperDat[0] = ((fThumbLX - m_nScreenX)*256)/m_nScreenMaxX ;
		m_zapperDat[1] = ((fThumbLY - m_nScreenY)*240)/m_nScreenMaxY ;
	}
	else
	{
		m_zapperDat[0] = 0 ;
		m_zapperDat[1] = 0 ;
	}

	/*
   *x=*x*VNSWID/(t.right?t.right:1);
   *y=*y*totallines/(t.bottom?t.bottom:1);
  }
  else
  {
   *x/=winsizemul;
   *y/=winsizemul;
  }
  *x+=VNSCLIP;
 }

 *y+=srendline;
*/
}

#endif

void trap_exitcpu(WORD unused_addr, void *unused_data)
{
	gAllDone = 1 ;
}

int CXBoxSample::handleEvents( int port )
{

    INT32 resistance ;
	float newRes ;
	DWORD vcode ;
	int lmousedown, rmousedown ;
	//XINPUT_DEBUG_KEYSTROKE   keystroke ;
	char stkey ;
	byte held_keys[256] ;
	static int didswap = 0 ;
	int doswap = 0 ;
	static int didfreeze = 0 ;
	int dofreeze = 0 ;
	int gotKey = 0 ;

	//xbox_print_memory() ;

	updateCheats2() ;

	memset( held_keys, 0, 256 ) ;

	if ( !m_screenUpdated )
	{
		m_timesWithoutUpdate++ ;
	}
	else
	{
		m_screenUpdated = 0 ;
		m_timesWithoutUpdate = 0 ;
	}

	if ( m_timesWithoutUpdate > 5 )
	{
		m_timesWithoutUpdate = 0 ;
		render_to_texture( NULL, 0,0,0,0,0,0,0 ) ;
	}

	if( m_bKeyboardMode )
	{
		handleScreenKeyboard() ;
		return 0 ;
	}

	if ( g_app->pollXBoxControllers() )
	{
		m_state = MAIN_MENU ;
		interrupt_maincpu_trigger_trap(trap_exitcpu, 0);
		return 1;
	}
	
	g_app->checkGeneralEvents() ;	

	if ( g_app->m_bNetplay )
	{
		if ( m_netplayCurr == m_netplaySkip ) //we have read some network data
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_emuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}
		else //we did not poll network - use last values
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[0] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}
	}

	DWORD mmoved = XBInput_GetMouseInput();

	rmousedown = lmousedown = 0 ;

	for ( int i = 0 ; i < 4 ; i++ )
	{
		if ( g_app->m_emuControllers[i] & JOY_SWAP )
		{
			doswap = 1 ;
		}
		if ( g_app->m_emuControllers[i] & CART_FREEZE )
		{
			dofreeze = 1 ;
		}

		if ( g_hMouseDevice[i] )
		{
			if ( g_MouseState[i].DebugMouse.bButtons & XINPUT_DEBUG_MOUSE_LEFT_BUTTON )
			{
				lmousedown = 1 ;
			}

			if ( g_MouseState[i].DebugMouse.bButtons & XINPUT_DEBUG_MOUSE_RIGHT_BUTTON )
			{
				rmousedown = 1 ;
			}

			if ( mmoved & ( 1 << i ) )
			{
				//KeyboardProcessor.Rel.X += g_MouseState[i].DebugMouse.cMickeysX  ;
				//KeyboardProcessor.Rel.Y += g_MouseState[i].DebugMouse.cMickeysY  ;
			}

		} 
		if(g_Gamepads[i].hDevice )
		{

				//KeyboardProcessor.Rel.X += g_Gamepads[i].fX1*8.5;
				//KeyboardProcessor.Rel.Y -= g_Gamepads[i].fY1*8.5;


				if ( i==0)
				{
					if ( g_Gamepads[i].fX2 > 0.10 )
					{
						rmousedown = 1 ;
					}

					if ( g_Gamepads[i].fX2 < -0.10 )
					{
						lmousedown = 1 ;
					}
				}
		}

		for ( int j = 0 ; j < 32 && !gotKey ; j++ )
		{
			if ( g_keystroke_queue[i][j] )
			{
				vcode = g_keystroke_queue[i][j] & ~0x80000000 ;
				held_keys[vcode] = 1 ;
				if ( keyboard_keystate[vcode]==0 )
				{
					kbd_handle_keydown( vcode, vcode ) ;
					keyboard_keystate[vcode] = 2 ;
					return 0 ;
					//gotKey = 1 ;
				}
			}
			else
			{
				break ;
			}
		}

	}

	if ( doswap )
	{
		if ( !didswap )
		{
			m_c64SwapJoysticks = !m_c64SwapJoysticks ;
			didswap = 1 ;
			sprintf( global_error_message, "Joysticks Swapped" ) ;
			m_msgDelay = 120 ;

		}
	}
	else
	{
		didswap = 0 ;
	}

	if ( dofreeze )
	{
		if ( !didfreeze )
		{
			keyboard_clear_keymatrix();
			cartridge_trigger_freeze();
			didswap = 1 ;
			sprintf( global_error_message, "Cartridge Freeze" ) ;
			m_msgDelay = 120 ;

		}
	}
	else
	{
		didfreeze = 0 ;
	}

	//if ( lmousedown )
		//Keyboard.bLButtonDown |= BUTTON_MOUSE;	// Set button down flag
	//else
		//Keyboard.bLButtonDown &= ~BUTTON_MOUSE;	// Set button down flag

	//if ( rmousedown )
		//Keyboard.bRButtonDown |= BUTTON_MOUSE;	// Set button down flag
	//else
		//Keyboard.bRButtonDown &= ~BUTTON_MOUSE;	// Set button down flag


	if ( Keyboard_GetVKInput() )
	//while( ERROR_SUCCESS == XInputDebugGetKeystroke( &keystroke ) )
	{
		if ( g_keyboardStroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_KEYUP )
		{
			if ( keyboard_keystate[g_keyboardStroke.VirtualKey] == 1 )
			{
				kbd_handle_keyup( g_keyboardStroke.VirtualKey,g_keyboardStroke.VirtualKey) ;
				keyboard_keystate[g_keyboardStroke.VirtualKey] = 0 ;
				return 0 ;
			}
		}
		else
		{
			if ( g_keyboardStroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_REPEAT )
			{
				if ( keyboard_keystate[g_keyboardStroke.VirtualKey] == 1 )
				{
					kbd_handle_keydown( g_keyboardStroke.VirtualKey,g_keyboardStroke.VirtualKey) ;
					keyboard_keystate[g_keyboardStroke.VirtualKey] = 1 ;
					return 0 ;
				}
			}
			else
			{
				if ( !keyboard_keystate[g_keyboardStroke.VirtualKey] )
				{
					kbd_handle_keydown( g_keyboardStroke.VirtualKey,g_keyboardStroke.VirtualKey) ;
					keyboard_keystate[g_keyboardStroke.VirtualKey] = 1 ;
					return 0 ;
				}
			}
		}

	}

	for ( int j = 0 ; j < 256 ; j++ )
	{
		if ( (keyboard_keystate[j]==2) && ( held_keys[j] == 0 ) )
		{
			kbd_handle_keyup( j, j ) ;
			keyboard_keystate[j] = 0 ;
			return 0 ;
		}
	}

//	m_joypad = ( g_app->m_emuControllers[0] & 0xFF ) | ( ( g_app->m_emuControllers[1] & 0xFF ) << 8 )  | 
				//( ( g_app->m_emuControllers[2] & 0xFF ) << 16 ) | ( ( g_app->m_emuControllers[3] & 0xFF ) << 24 ) ;


#ifdef LIGHTGUN
	if ( m_zapperNum )
	{
		doZapper() ;
	}
#endif

	return g_app->m_emuControllers[port] & 0xFF ;
}


void trap_writestate(WORD unused_addr, void *unused_data)
{
		machine_write_snapshot(g_app->g_statefile, 0,0, 0) ;
}
void trap_readstate(WORD unused_addr, void *unused_data)
{
		machine_read_snapshot(g_app->g_statefile, 0) ;
}


void CXBoxSample::xboxSaveState() 
{
	if ( g_statefile && strlen( g_statefile ) )
	{
		g_statefile[ strlen(g_statefile)-1 ] = '0' + m_stateNumber ;

		//machine_write_snapshot("D:\\savestate.vsf", 0,0, 0) ;
		interrupt_maincpu_trigger_trap(trap_writestate, 0);

		sprintf( global_error_message, "State %u Saved", m_stateNumber+1 ) ;
		m_msgDelay = 120 ;
	}
}


void CXBoxSample::xboxLoadState() 
{
		
	char szholder[500] ;

	if ( g_statefile && strlen( g_statefile ) )
	{
		if ( m_stateNumber == 0 )
		{
			g_statefile[ strlen(g_statefile)-1 ] = 'A' ;
			strcpy( szholder, g_statefile ) ;
			g_statefile[ strlen(g_statefile)-1 ] = '0' ;
			MoveFileEx( szholder, g_statefile, MOVEFILE_REPLACE_EXISTING ) ;
		}

		g_statefile[ strlen(g_statefile)-1 ] = '0' + m_stateNumber ;

		sprintfx( "before loadstate %u\r\n", m_stateNumber ) ;

		interrupt_maincpu_trigger_trap(trap_readstate, 0);

		//machine_read_snapshot(g_statefile, 0) ;
	
		sprintfx( "after loadstate %u\r\n", m_stateNumber ) ;

		sprintf( global_error_message, "State %u Loaded", m_stateNumber+1 ) ;
		m_msgDelay = 120 ;
	}
	
}

void CXBoxSample::xboxChangeFilter() 
{
	g_app->m_xboxSFilter = (g_app->m_xboxSFilter+1)%NUM_SOFTWARE_FILTERS ;

	memset( g_pDeltaBuff, 0xFF, m_pitch*theHeight ) ;

	sprintf( global_error_message, "%s Filtering", SOFTWARE_FILTERS[m_xboxSFilter].name ) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxScreenshot() 
{
	mainprog_info wpng_info;
	char scr_filename[MAX_PATH] ;
	char scr_prefix[MAX_PATH] ;
	char dir[MAX_PATH] ;
	char letter ;
	int maxnum = 0 ;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;

	if ( isalpha( *(strrchr(g_saveprefix, '\\')+1) ) )
	{
		letter = *(strrchr(g_saveprefix, '\\')+1) ;
	}
	else
	{
		letter = '0' ;
	}

	sprintf( scr_prefix, "%s\\%s\\%c\\%s", m_screenshotDir, PLATFORM_NAME, letter, strrchr(g_saveprefix, '\\')+1 ) ;

	CreateDirectory( scr_prefix, NULL ) ;

	sprintf( dir, "%s\\*.png", scr_prefix ) ;

	hFind = FindFirstFile( dir, &oFindData);

	if ( hFind != INVALID_HANDLE_VALUE) 
	{
		do
		{
			strcpy( scr_filename, oFindData.cFileName ) ;

			if ( strchr( scr_filename, '.' ) == NULL )
				continue ;

			*(strchr( scr_filename, '.' )) = 0 ;

			//sprintfx( "%s %u %s\r\n", scr_filename, strlen(scr_prefix), scr_filename + strlen(scr_prefix) ) ;

			if ( atoi( scr_filename ) > maxnum )
			{
				maxnum = atoi( scr_filename ) ;
			}
			
		} while (FindNextFile(hFind, &oFindData) ) ;
		FindClose( hFind );
	}

	maxnum++ ;

	if ( maxnum > 9999 )
		return ;

	sprintf( scr_filename, "%s\\%04.4u.png", scr_prefix, maxnum ) ;


	memset( &wpng_info, 0, sizeof( wpng_info ) ) ;

	wpng_info.width = ((float)m_nScreenMaxX/m_gameVecScale.x);
	wpng_info.height = ((float)m_nScreenMaxY/m_gameVecScale.y) ;

	wpng_info.sample_depth = 8;

	wpng_info.bpp = 24 ;

	wpng_info.outfile = NULL;
	wpng_info.image_data = NULL;
	wpng_info.row_pointers = NULL;
	wpng_info.interlaced = false;
	wpng_info.have_bg = false;
	wpng_info.have_time = false;
	wpng_info.have_text = 0;
	wpng_info.gamma = 1.0;

    /* open the output file, or register an error and abort */
	if ((wpng_info.outfile = fopen( scr_filename, "wb") ) == NULL)
	{
		return ;
    }
	
	// allocate libpng stuff, initialize transformations, write pre-IDAT data
	

	int rc ;
	if ((rc=writepng_init(&wpng_info)) != 0)
	{
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		switch (rc)
		{
			case 2:
				fprintf(stderr, "WritePNG: libpng initialization problem (longjmp)\n");
			break;
			case 4:
				fprintf(stderr, "WritePNG: insufficient memory\n");
				break;
			case 11:
				fprintf(stderr, "WritePNG: internal logic error (unexpected PNM type)\n");
				break;
			default:
				fprintf(stderr, "WritePNG: unknown writepng_init() error\n");
				break;
        }
        exit(rc); */
    }
	
	long j;
	
	wpng_info.image_data = (unsigned char *)malloc( (wpng_info.bpp/8) * wpng_info.width);
		
	if (wpng_info.image_data == NULL)
	{
		writepng_cleanup(&wpng_info);
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		fprintf(stderr, "WritePNG:  insufficient memory for row data\n");
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(5);
		*/
	}
		
	unsigned char *data ;

	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);


	data = (unsigned char*)d3dlr.pBits;

	WORD pixel ;
		
	for (j = wpng_info.height;  j > 0L;  --j)
	{
		unsigned char* img_data = wpng_info.image_data;
		WORD *wdata = (WORD*)data;

		int i=0;

		for ( i = 0 ; i < wpng_info.width ; i++ )
		{
			pixel = wdata[i] ;
			img_data[2] = (pixel<<3) & 0xFF ;
			img_data[1] = ((pixel>>5)<<2) & 0xFF ;
			img_data[0] = ((pixel>>11)<<3) & 0xFF ;
			img_data += 3 ;
		}

		data += d3dlr.Pitch;
			
	
			
		if( writepng_encode_row(&wpng_info) != 0)
		{
			writepng_cleanup(&wpng_info);
			free(wpng_info.image_data) ;
			fclose( wpng_info.outfile )  ;
			Texture->UnlockRect(0) ;
			return ; 

/*			fprintf(stderr, "WritePNG:  libpng problem (longjmp) while writing row %ld\n",
			wpng_info.height-j);
			++error;
			break;*/
		}
	}
	Texture->UnlockRect(0) ;
		
		/*
	if (error)
	{
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(2);
	}
	*/
	if (writepng_encode_finish(&wpng_info) != 0)
	{
		//fprintf(stderr, "WritePNG:  error on final libpng call\n");
		writepng_cleanup(&wpng_info);
		free(wpng_info.image_data) ;
		fclose( wpng_info.outfile )  ;
		return ;
	}
	
	/* OK, we're done (successfully):  clean up all resources and quit */

	writepng_cleanup(&wpng_info);
	free(wpng_info.image_data) ;
	fclose( wpng_info.outfile )  ;

	sprintf( global_error_message, "%s", scr_filename) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxThrottle( int xthrottle ) 
{
	int warp = 0 ;

	if ( xthrottle ) 
	{
		//resources_set_value( "Speed", (resource_value_t)400 ) ;
		resources_get_value( "WarpMode", &warp ) ;

		if ( warp == 0 )
			resources_set_value( "WarpMode", (resource_value_t)1 ) ;

		if ( throttle <= 0 )
			throttle = m_throttleSpeed ;
	}
	else
	{
		//resources_set_value( "Speed", (resource_value_t)100 ) ;
		resources_get_value( "WarpMode", &warp ) ;

		if ( warp == 1 )
			resources_set_value( "WarpMode", (resource_value_t)0 ) ;

		throttle = 0 ;
	}
	//m_throttle = throttle ;
	//SpeedThrottle() ;
}

void CXBoxSample::xboxChangeState() 
{
	m_stateNumber = (m_stateNumber+1)%10 ;

	sprintf( global_error_message, "Switched to State Slot %u", m_stateNumber+1 ) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxOptionsMenu( )
{
	g_app->m_state = IN_GAME_PAUSED ;
	g_app->m_sound.pause( TRUE ) ;
	//g_app->m_cdda.pause(TRUE) ;
	//g_app->m_mp3player.pause( TRUE ) ;
	g_app->m_dwStartPause = GetTickCount();

	g_app->doCheatMenu() ;


	g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
	g_pd3dDevice->Present( NULL, NULL, NULL, NULL ) ;

	g_app->m_sound.pause( FALSE ) ;
	m_startTime = GetTickCount() ;
	m_numFrames = 0 ;

}

void CXBoxSample::xboxStartRecording( )
{
	if ( m_emuRecording || m_emuPlaying )
		return ;


	m_sound.pause(TRUE ) ;
	FILE *checkfile ;

	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Confirm Start Recording" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"WARNING" ) ;
		swprintf( m_menuText[3], L"This function is going to load the currently" ) ;
		swprintf( m_menuText[4], L"selected save state and start recording."   ) ;
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"Press B if you want to cancel this action." ) ;
		swprintf( m_menuText[7], L"Press Y to load the state and start recording.") ;

		renderPopupBkg( 8 ) ;
		renderMenuText( 0, 0, m_menuText, 8, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			m_sound.pause(FALSE) ;
			return ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
	}

	xboxLoadState() ;

	checkfile = fopen( g_statefile, "rb" ) ;

	if ( checkfile == NULL )
	{
		xboxSaveState() ;
	}
	else
	{
		fclose( checkfile ) ;
	}

	m_emuRecordSlot = m_stateNumber ;
	m_emuRecordPosition = 0 ;
	m_emuRecording = 1 ;

	m_sound.pause(FALSE) ;

	sprintf( global_error_message, "Started Recording at Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;

}
void CXBoxSample::xboxStopRecording( )
{
	if ( ! m_emuRecording )
		return ;

	char recname[500] ;
	FILE *recfile ;

	sprintf( recname, "%s.sr0", g_saveprefix ) ;

	recname[ strlen(recname)-1 ] = '0' + m_emuRecordSlot  ;


	recfile = fopen( recname, "wb") ;

	if ( recfile == NULL )
	{
		sprintf( global_error_message, "Could not open %s for writing", recname ) ;
		m_msgDelay = 120 ;
		return ;
	}

	fwrite( m_szEmuRecorder, sizeof(char), m_emuRecordPosition, recfile  ) ;
	fclose( recfile ) ;

	m_emuRecording = 0 ;

	sprintf( global_error_message, "Stopped Recording at Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;

}
void CXBoxSample::xboxStartPlaying( )
{
	if ( m_emuPlaying || m_emuRecording )
		return ;

	char recname[500] ;
	FILE *recfile ;
	unsigned int filesize ;

	m_sound.pause(TRUE) ;
	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Confirm Start Playing" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"WARNING" ) ;
		swprintf( m_menuText[3], L"This function is going to load the currently" ) ;
		swprintf( m_menuText[4], L"selected save state and start playing the recording."   ) ;
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"Press B if you want to cancel this action." ) ;
		swprintf( m_menuText[7], L"Press Y to load the state and start playing.") ;

		renderPopupBkg( 8 ) ;
		renderMenuText( 0, 0, m_menuText, 8, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			m_sound.pause(FALSE) ;
			return ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
	}

	m_emuRecordSlot = m_stateNumber ;

	sprintf( recname, "%s.sr0", g_saveprefix ) ;

	recname[ strlen(recname)-1 ] = '0' + m_emuRecordSlot  ;


	recfile = fopen( recname, "rb") ;

	if ( recfile == NULL )
	{
		sprintf( global_error_message, "Could not open %s for reading", recname ) ;
		m_msgDelay = 120 ;
		m_sound.pause(FALSE) ;
		return ;
	}

	fseek( recfile, 0, SEEK_END ) ;
	m_emuPlaySize = ftell( recfile ) ;
	fseek( recfile, 0, SEEK_SET ) ;

	fread( m_szEmuRecorder, sizeof(char), m_emuPlaySize, recfile ) ;
	fclose( recfile ) ;

	m_emuPlayPosition = 0 ;

	m_emuPlaying = 1 ;

	xboxLoadState() ;

	m_sound.pause(FALSE) ;
	sprintf( global_error_message, "Started Playing Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxStopPlaying( )
{
	if ( ! m_emuPlaying )
		return ;

	m_emuPlaying = 0 ;

	sprintf( global_error_message, "Stopped Playing Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;
}





void CXBoxSample::doConfigureGame( char *settingsname, char *keysname, char *filename )
{

	int menuChoice ;

	menuChoice = 0 ;

	loadSettings( settingsname ) ;
	loadKeys( keysname ) ;


	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"Game Configuration" );
		swprintf( m_menuText[1], L"Swap Joysticks - %S", m_c64SwapJoysticks ? "Yes" : "No" );
		swprintf( m_menuText[2], L"File to Run : %S", strlen(m_c64Filename) == 0 ? "<Default>" : m_c64Filename ) ;
		swprintf( m_menuText[3], L"True Drive Emulation - %S", m_c64TrueDrive ? "Yes" : "No" );
		swprintf( m_menuText[4], L"Detach Cart Before Starting - %S", m_c64DetachCart ? "Yes" : "No" ) ;
		swprintf( m_menuText[5], L"Video Mode - %S", m_c64VideoMode ? "NTSC" : "PAL" );
		swprintf( m_menuText[6], L"SID Model - %S", m_c64SIDModel ? "6581 (Old)" : "8580 (New)" );
		swprintf( m_menuText[7], L"SID Filters - %S", m_c64SIDFilters ? "Yes" : "No" );
		//swprintf( m_menuText[7], L"Stereo SID - %S", m_c64SIDStereo ? "Yes" : "No" );
		swprintf( m_menuText[8], L"SID Method - %S", m_c64SIDMethod ? "fastSID" : "reSID" );
		swprintf( m_menuText[9], L"Configure Controllers"  );
		swprintf( m_menuText[10], L"Set Graphics Filter"  );

		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText,11, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
	        XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			switch ( menuChoice )
			{
				case 0 : m_c64SwapJoysticks = !m_c64SwapJoysticks ; break ; 
				case 1 : doSelectC64File( filename ) ; break ; 
				case 2 : m_c64TrueDrive = !m_c64TrueDrive ; break ; 
				case 3 : m_c64DetachCart = !m_c64DetachCart ; break ; 
				case 4 : m_c64VideoMode = !m_c64VideoMode ; break ; 
				case 5 : m_c64SIDModel = !m_c64SIDModel ; break ; 
				case 6 : m_c64SIDFilters = !m_c64SIDFilters ; break ; 
				//case 5 : m_c64SIDStereo = !m_c64SIDStereo ; break ; 
				case 7 : m_c64SIDMethod = !m_c64SIDMethod ; break ; 
				case 8 : doConfigureControllers() ; break ; 
				case 9 : doChangeSWFilter() ; break ; 
				default : break ;
			}
		}


	}

	saveSettings( settingsname ) ;
	saveKeys( keysname ) ;

}

void CXBoxSample::doSelectC64File( char *filename)
{
	DWORD dwTime  ;
    image_contents_t *contents;
	int menuChoice = 0 ;
	int numlines = 0 ;
    image_contents_file_list_t *p;

    contents = image_contents_read(IMAGE_CONTENTS_AUTO, filename, 0);

	swprintf( m_menuText[numlines++], L"Select C64 File" ) ;
	swprintf( m_menuText[numlines++], L"<Default>" ) ;

    if (contents != NULL)
	{
	    for (p = contents->file_list; p != NULL; p = p->next) 
		{
			char print_name[IMAGE_CONTENTS_FILE_NAME_LEN + 1];

			memset(print_name, 0, IMAGE_CONTENTS_FILE_NAME_LEN + 1);
			for (int i = 0; i < IMAGE_CONTENTS_FILE_NAME_LEN; i++) {
				if (p->name[i] == 0xa0)
					break;           
				print_name[i] = (char)p->name[i];
			}

			swprintf( m_menuText[numlines++], L"%S", print_name ) ;
		}

	    image_contents_destroy(contents);
	}


	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, numlines, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( menuChoice == 0 )
				strcpy( m_c64Filename, "" ) ;
			else
				sprintf( m_c64Filename, "%S", m_menuText[menuChoice+1] ) ;
			break ;
		}


	}

}

#define CD_SECS 60
#define CD_FRAMES 75


void CXBoxSample::initConsole( UINT32 idx, int isFavorite, int forceConfig, int isGamebase )
{
	char                filename[500] ;
	char				shortpath[100] ;
	unsigned char       *gimage ;
	int                 ntsccol ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	int isOther ;


	sprintfx( "begin initcons\r\n") ;

	xbox_print_memory() ;

	isOther = 0 ;
	m_bKeyboardMode = 0 ;

	m_throttle = 0 ;
	m_timesWithoutUpdate = 0;
	m_screenUpdated = 0;

	for ( int i = 0 ; i < 4 ; i++ )
	{
		m_emuControllers[i] = 0 ;
	}


	if ( isFavorite )
	{
		strcpy( (char*)filename, m_filesFavorites[idx].filename ) ;
	}
	else if ( isGamebase )
	{
		sprintf( (char*)filename, "%s\\GAMES\\%s", m_gamebasePath, m_gameBaseEntries[idx].filename ) ;
	}
	else
	{
		if ( g_autoLaunchGame )
		{
			strcpy( (char*)filename, g_launchData.szFilename ) ;
		}
		else
		{
			strcpy((char*)filename, m_szCurrentDir ) ;
			strcat( (char*)filename, (const char*)files[idx].filename ) ;
		}
	}

	m_bUsingSamba = ( strncmp( filename, "SMB:", 4 ) == 0 ) || ( strncmp( filename, "smb:", 4 ) == 0 ) ;
	m_bUsingRelax = ( strncmp( filename, "RLX:", 4 ) == 0 ) || ( strncmp( filename, "rlx:", 4 ) == 0 ) ;

	xbox_print_memory() ;
	if ( (strstr (filename, ".MP3")) || (strstr (filename, ".mp3")) || (strstr (filename, ".sid")) || (strstr (filename, ".SID")) )
	{
		if ( m_mp3player.loadFile( filename, 1, 0, 9999999 ) )
		{
			//writexbox( "nonomp3\r\n") ;
		}
		else
		{
			//m_mp3player.insertSilence( 22050 ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = MAIN_MENU ;
			return  ;
		}
	}

	if ( (strstr (filename, ".M3U")) || (strstr (filename, ".m3u")) )
	{
		if ( m_mp3player.loadPlaylist( filename ) )
		{
			//writexbox( "nonomp3\r\n") ;
		}
		else
		{
			//m_mp3player.insertSilence( 22050 ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = MAIN_MENU ;
			return  ;
		}
	}

	xbox_print_memory() ;

	char *p ;

	sprintfx("init\r\n") ;

	if ( strlen( strrchr( filename, '\\' )+1 ) > 42 )
	{
		strncpy( shortpath, strrchr( filename, '\\' )+1, 42 ) ;
		shortpath[42] = 0 ;

		p = strrchr( filename, '.' ) ;

		if ( p )
		{
			strcpy( shortpath+( 41 - strlen(p) ), p ) ;
		}
	}
	else
	{
		strcpy( shortpath, strrchr( filename, '\\' )+1 ) ;
	}


	while( strchr( shortpath, ',' ) )
		*strchr( shortpath, ',' ) = '_' ;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, shortpath ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_settingsfile, g_saveprefix);
	strcat(g_settingsfile, ".stg");

	strcpy(g_keysfile, g_saveprefix);
	strcat(g_keysfile, ".key");

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_statefile, g_saveprefix);
	strcat(g_statefile, ".st0");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintfx("init\r\n") ;


	memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	xbox_print_memory() ;


	memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	xbox_print_memory() ;
	sprintfx("init\r\n") ;

	global_error_message[0] = 0 ;




	if ( g_autoLaunchGame )
	{
		m_pnlSplashGame.Render() ;
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else
	{
		if ( m_bNetplay )
		{
			changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
			if ( setupNetplay() )
				return ;
			doTransition( &m_pnlBackgroundOther, &m_pnlSplashGame, m_skin.fade, 1 ) ;
		}
		else
		{
			if ( isOther )
			{
				doTransition( &m_pnlBackgroundOther, &m_pnlSplashGame, m_skin.fade, 1 ) ;
			}
			else
			{
				doTransition( &m_pnlBackgroundSelect, &m_pnlSplashGame, m_skin.fade, 1 ) ;
			}
		}
	}

	xbox_print_memory() ;
	memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	if ( !m_bBgmInGame )
	{
		m_mp3player.pause( TRUE ) ;
	}



	xbox_print_memory() ;


	m_numFrames = 0 ;

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;
	//xbox_set_RAM_location() ;

	sprintfx("init\r\n") ;

	//PaletteChanged = 0 ;


	m_sound.init() ;

	sprintfx("init\r\n") ;

	xbox_print_memory() ;
	// Create our texture
	init_texture();

	//popupMsg( "is this panel on?", &m_pnlBackgroundOther) ;
	//popupMsg( "is this panel on?", &m_pnlGameScreen2) ;

	//m_pnlGameScreen.m_pTexture = NULL ;
	//m_pnlGameScreen.Create( m_pd3dDevice, Texture, FALSE, theWidth, theHeight ) ;

	sprintfx("init\r\n") ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	

	sprintfx("init\r\n") ;



	if ( m_bUsingSamba )
	{
		char smbfilename[1024] ;
		char *smbp ;
		int sambafile ;
		FILE *outfile ;


		sprintf( smbfilename, "%s%s", m_smbShare, filename+4 ) ;

		while ( smbp = strchr( smbfilename, '\\' ) )
			*smbp = '/' ;


		sambafile = m_smb.open( smbfilename,O_RDONLY|O_BINARY);

		sprintfx( "%s\r\n", smbfilename ) ;



		if ( sambafile <= 0 )
		{
			return ;
		}

		sprintf( smbfilename, "Z:\\%s", shortpath ) ;
		strcpy(filename, smbfilename) ;

		outfile = fopen(filename, "wb") ;

		if ( outfile == NULL )
		{
			m_smb.close( sambafile ) ;
			return ;
		}

		int filesize = m_smb.lseek(sambafile,0,SEEK_END);
		m_smb.lseek(sambafile,0,SEEK_SET);

		char *fbuf = (char*) malloc( filesize ) ;

		m_smb.read(sambafile,fbuf, filesize) ;
		fwrite( fbuf, sizeof(char), filesize, outfile ) ;

		fclose(outfile) ;
		m_smb.close( sambafile ) ;

		free(fbuf) ;

	}
	else if ( m_bUsingRelax )
	{
		char rlxfilename[1024] ;
		FILE *outfile ;
		int filesize ;
		char *fbuf ;

		if ( m_relax.Open( filename ) )
		{
			sprintfx( "opened rlx %s\r\n", filename ) ;
			filesize = m_relax.GetLength() ;


			sprintf( rlxfilename, "Z:\\%s", shortpath) ;
			strcpy(filename, rlxfilename) ;

			outfile = fopen(filename, "wb") ;

			if ( outfile == NULL )
			{
				m_relax.Close( ) ;
				return ;
			}


			fbuf = (char*) malloc( filesize ) ;

			if ( !fbuf )
			{
				m_relax.Close() ;
				return ;
			}

			if ( ! m_relax.ReadAll( fbuf, filesize ) )
			{
				free(fbuf) ;
				m_relax.Close() ;
				return ;
			}

			m_relax.Close() ;

			fwrite( fbuf, 1, filesize, outfile ) ;
			fclose( outfile ) ;
			free(fbuf) ;
		}
		else
		{
			return ;
		}


	}

	cht_load();


	m_state = IN_GAME ;



	sprintfx("init\r\n") ;

	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;

	m_steps = 0 ;
	m_sound.pause( FALSE ) ;

	sprintfx( "about to vba_main %s\r\n", filename ) ;


	m_startTime = GetTickCount() ;

	//m_plaything.FreeSprites() ;
	freeTextures() ;


	if ( Keyboard_Init( 25, 500, 50 ) )
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard success\n" );
	}
	else
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard failure\n" );
	}

	memset(keyboard_keystate, 0, 256 ) ;
	m_mousePosX = 0 ;
	m_mousePosY = 0 ;


	char uprfilename[500] ;

	strcpy( uprfilename, filename ) ;
	strupr( uprfilename ) ;

	if ( strstr( uprfilename, ".ZIP" ) )
	{
		unzipC64( uprfilename, filename ) ;
		strcpy( uprfilename, filename ) ;
		strupr( uprfilename ) ;
	}

	if ( forceConfig || loadSettings( g_settingsfile ) )
	{
		changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
		doConfigureGame( g_settingsfile, g_keysfile, filename ) ;
		isOther = 1 ;
	}


	if ( !isOther )
	{
		loadKeys( g_keysfile ) ;
	}


	QueryPerformanceCounter((union _LARGE_INTEGER *) m_performancePrev);


	gAllDone = 0 ;


	if ( m_c64TrueDrive )
		resources_set_value( "DriveTrueEmulation", (resource_value_t)1 ) ;
	else
		resources_set_value( "DriveTrueEmulation", (resource_value_t)0 ) ;

	if ( m_c64VideoMode )
		resources_set_value( "MachineVideoStandard", (resource_value_t)MACHINE_SYNC_NTSC ) ;
	else
		resources_set_value( "MachineVideoStandard", (resource_value_t)MACHINE_SYNC_PAL ) ;
		
	xbox_set_refreshrate( m_c64VideoMode ? 60 : 50 ) ;

	if ( m_c64SIDMethod )
		resources_set_value( "SidEngine", (resource_value_t)0 ) ;
	else
		resources_set_value( "SidEngine", (resource_value_t)1 ) ;

	//if ( m_c64SIDStereo )
		//resources_set_value( "SidStereo", (resource_value_t)1 ) ;
	//else
		//resources_set_value( "SidStereo", (resource_value_t)0 ) ;

	if ( m_c64SIDFilters )
		resources_set_value( "SidFilters", (resource_value_t)1 ) ;
	else
		resources_set_value( "SidFilters", (resource_value_t)0 ) ;

	if ( m_c64SIDModel )
		resources_set_value( "SidModel", (resource_value_t)0 ) ;
	else
		resources_set_value( "SidModel", (resource_value_t)1 ) ;

	if ( m_c64DetachCart )
		cartridge_detach_image();

	resources_set_value("SoundSampleRate", (resource_value_t)44100);
	keyboard_clear_keymatrix();
	m_currKeyboardKey &= 0xFFFF00FF ;
	m_currKeyboardKey &= ~KEYPRESSING ;

	machine_trigger_reset(MACHINE_RESET_MODE_HARD);

	if ( strstr( uprfilename, ".CRT" ) )
	{
        if (cartridge_attach_image(0, filename) < 0)
		{
			popupMsg( "Could not load .CRT file.", &m_pnlBackgroundOther ) ;
			return ;
		}
	}
	else
	{
		autostart_autodetect(filename, strlen(m_c64Filename)==0 ? NULL : m_c64Filename, 0, AUTOSTART_MODE_RUN) ;
	}

	//autostart_autodetect(filename, NULL, 0, AUTOSTART_MODE_RUN) ;


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	memset( d3dlr.pBits, 0, d3dlr.Pitch*theHeight ) ;


	// Unlock our texture
	Texture->UnlockRect(0);


	maincpu_mainloop() ;

	tape_image_detach(1) ;
	file_system_detach_disk(8);
	//winston_main(filename) ;
    //m_bliss32.run(filename) ;

	sprintfx( "done bliss\r\n") ;

	saveKeys( g_keysfile ) ;
	sprintfx( "done bliss\r\n") ;
	cleanupConsole() ;

	char tmpfilename[1024] ;

	//sprintf( tmpfilename, "%s\\%s\\SPRITES\\*", m_szSkinDir, m_szSkin) ;
	//m_plaything.LoadSprites( tmpfilename ) ;

	m_sound.cleanup() ;
	sprintfx( "done bliss\r\n") ;
	m_state = MAIN_MENU ;
#ifdef USE_NETPLAY
	m_sockNetplay.m_debugClientSock.Close() ;
#endif
	sprintfx( "done bliss\r\n") ;

}



void CXBoxSample::cleanupConsole( )
{
	sprintfx( "done2\r\n") ;
	cht_save() ;
	sprintfx( "done2\r\n") ;


	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	sprintfx( "done2\r\n") ;
	//see loader_unload() for other things to free
}


void CXBoxSample::applyGameGenie( unsigned char *ROM, unsigned int romsize )
{
	unsigned char *currpos ;


/*
	for ( unsigned int i = 0 ; i < m_numCheats ; i++ )
	{

		if ( ! m_cheatCodes[i].enabled )
			continue ;

		if ( ( m_cheatCodes[i].type & 0xF0 ) != 0x90 )
			continue ;

		if ( m_cheatCodes[i].type == 0x99 )   //6char code
		{
			currpos = ROM + m_cheatCodes[i].adr ; 

			while ( romsize > ( currpos-ROM) )
			{
				*currpos = ( m_cheatCodes[i].val & 0xFF) ;
				currpos += 0x8000 ;
			}
		}
		else  //8char code
		{
			currpos = ROM + ( m_cheatCodes[i].adr & 0x1FFF ) ; 

			while ( romsize > ( currpos-ROM ) )
			{
				//sprintfx( "checking for %u at %04.4X\r\n", ((unsigned char)m_cheatCodes[i].code[16]), currpos-ROM ) ;
				if ( *currpos == ((unsigned char)m_cheatCodes[i].code[16]) )
				{
				//sprintfx( "writing %u to %04.4X\r\n", m_cheatCodes[i].val, currpos-ROM ) ;
					*currpos = ( m_cheatCodes[i].val & 0xFF) ;
				}
				currpos += 0x2000 ;
			}
		}

	}
	*/
}



#ifdef __cplusplus
extern "C" {
#endif


void sprintfx( const char *fmt, ... )
{
    va_list	va;
    va_start(va, fmt);
	vsprintf( gxmsg, fmt, va);
	va_end( va ) ;
	writexbox(gxmsg) ;
}


void xbox_process_sound(  short *sampleBuffer, unsigned short sampleCount ) 
{
	//g_app->m_mp3player.process() ;
	//g_app->m_sound.process( (unsigned short*)sampleBuffer, sampleCount ) ;
}


void xbox_render( unsigned char *image ) 
{
	//writexbox( "renderimage\r\n") ;
	g_app->renderImage( image ) ;
}

void xbox_set_palette(const unsigned int* p, const unsigned char numEntries) 
{
	//writexbox( "setpal\r\n") ;
	g_app->SetPalette( p, numEntries ) ;

}

int xbox_quit() 
{
	return  ( g_app->m_state == MAIN_MENU ) ;
}

void xbox_set_memory_ptr( unsigned char *ptr )
{
}


void xbox_clear_screen()
{
	g_app->ClearScreen() ;
}

unsigned char* xbox_get_biosfile() 
{
	return g_app->m_biosfile ;
}

unsigned char* xbox_get_memcard1() 
{
	return g_app->m_memcard1 ;
}

unsigned char* xbox_get_memcard2() 
{
	return g_app->m_memcard2 ;
}

unsigned char* xbox_get_saveprefix()
{
	return (unsigned char*)g_app->g_saveprefix ;
}

unsigned long xbox_get_bytes_buffered() 
{
//	return g_app->m_sound.get_buffered_bytes() ;
	return 0 ;
}

unsigned int xbox_get_pitch()
{
	return g_app->m_pitch ;
}

unsigned char *xbox_cdbuffer() 
{

	return (g_app->m_ptrCdBuf)+12 ;
}


void xbox_feed_stream(unsigned char* pSound,long lBytes) 
{
	//sprintfx( "before feed\r\n") ;
	//g_app->m_sound.process(pSound, lBytes ) ;
	g_app->m_mp3player.process() ;
	//sprintfx( "after feed\r\n") ;
	//g_app->m_cdda.process() ;
}



unsigned long xbox_gettime()
{
	
	FILETIME ft ;

	GetSystemTimeAsFileTime( &ft ) ;

	return 0 ;
	//return ft.dwLowDateTime / 100 ;
	
	//return GetTickCount() ;
}
unsigned long xbox_gettime2()
{
	
	return GetTickCount() ;
}

void xbox_loading_msg( LPCTSTR msg ) 
{
//	g_app->WriteLoadMessage(msg) ;

}

void xbox_exception_msg( LPCTSTR msg ) 
{
//	g_app->WriteExceptionMessage(msg) ;

}
unsigned int xbox_get_controller_value( int port ) 
{
	if ( g_app->m_c64SwapJoysticks )
		return (g_app->m_emuControllers[(port+1)%2])&0xFF ;
	else
		return (g_app->m_emuControllers[port])&0xFF ;
}

unsigned int xbox_read_input(int port) 
{
	//writexbox( "before readinput") ;

	//return 0 ;

	//MEMORYSTATUS stat;

    // Get the memory status.
    //GlobalMemoryStatus( &stat );

	//sprintfx("available memory = %u\r\n", stat.dwAvailPhys  ) ;


//	return ReadJoypad( port ) ;

	//writexbox( "after readinput") ;
	return 0 ;
}

unsigned char * xbox_get_screen_buffer()
{
	return g_app->g_pBlitBuff ;

}
int xbox_check_events( int id)
{
	//writexbox( "before events") ;
	return g_app->handleEvents(id) ;
	//writexbox( "after events") ;
	//return 0 ;
}

void xbox_Sleep( int d )
{
	Sleep( d ) ;
}

unsigned int xbox_read_port( int which )
{
	return g_app->m_emuControllers[which] ;
}

unsigned int xbox_get_throttle()
{
	return g_app->m_throttle ;
}


void xbox_put_image(  video_canvas_t *canvas, int width,
                         int height, int xs, int ys, int xt, int yt )
{
	//writexbox( "before render") ;
	//g_sound->process() ;
	//g_mp3player->process() ;
	//g_app->m_cdda.process() ;
	//sprintfx("renderbegin\r\n") ;
	g_app->render_to_texture( canvas, width, height, xs, ys, xt, yt, 1 ) ;
	//sprintfx("renderend\r\n") ;
	//writexbox( "after render") ;
}

void xbox_process_audio( char *buf, int length )
{
	//OutputDebugString( "procesaudio\n") ;
	g_sound->process( buf, length ) ;
	g_app->m_mp3player.process() ;
	

}

void xbox_open_zip( char *hugozipfile )
{
	//writexbox( "before zip") ;
	//g_app->rom_load_zip( hugozipfile ) ;
	//writexbox( "after zip") ;
}
void xbox_set_RAM_location( char *ptr ) 
{

	m_memory_locations[0] = (byte*)( ptr ) ;

}
unsigned char* xbox_get_screenbuf()
{
	return (unsigned char*)g_app->g_pBlitBuff ;
}

int xbox_get_filter()
{
	return g_app->m_xboxSFilter ;
}

void xbox_apply_game_genie( byte *ROM, unsigned int romsize)
{
	sprintfx( "about to apply gg\r\n") ;
	g_app->applyGameGenie( ROM, romsize ) ;

	//http://www.monmouth.com/~colonel/videogames/nes/genie.html
	/*
Game Genie code = SLXPLOVS (SMB3: infinite lives)
The following info is derived from SMB3.PAT:
CPU address: $9123
Compare value: $DE
Patch value: $BD

ROM address to start comparing: $9123 & $1FFF + $10 = $1133.

The value at offset $1133 in the ROM doesn't match, so move on to the next bank at $1133+$2000.
Doesn't match here either, so move on to the next bank. Continue like so and you will eventually reach
$3D133, where the value is indeed our compare value, $DE. Change it to $BD, and Mario will have a
minimum of 4 lives next time you play the game.
*/
}

#ifdef __cplusplus
}
#endif
void CXBoxSample::processEmu( BOOL render )
{
	/*
	static int whichframe = 0 ;

		
			updateCheats2() ;

			handleEvents();
			m_mp3player.process() ;

			//EmLoopOnce();  //makes callback to the audio

			if ( render )
			{
				if ( m_throttle )
				{
					if ( whichframe++ % 4 == 0 )
					{
						render_to_texture();
						m_numFrames++ ;
					}
				}
				else
				{
					render_to_texture();
					m_numFrames++ ;
				}
			}

			while ( m_sound.m_bDanger && ( m_state != MAIN_MENU ))
			{
				handleEvents();
				m_mp3player.process() ;
				//EmLoopOnce();  //makes callback to the audio
			}
			//m_sound.process( m_fAppTime, m_numFrames ) ;
 			
*/

}


int CXBoxSample::rom_load_zip( char *hugozipfile )
{
	return 1;
}




















int CXBoxSample::unzipC64( char *zipfile, char *newfilename )
{
	byte c, *data, *header;
	int len = 0, rlen;
	int menuChoice = 0 ;
	int numlines = 0 ;

	OUTPUT_DEBUG_STRING( "unzipping\n") ;

	//writexbox( "ttt\r\n" ) ;
    unzFile file = unzOpen(zipfile);

    if(file == NULL)
		return 0 ;

	//writexbox( "ttt\r\n" ) ;

    char filename[132];
    int filesize = 0;
    int port = unzGoToFirstFile(file);
    unz_file_info info;

	swprintf( m_menuText[numlines++], L"Select File From ZIP" ) ;

	//writexbox( "ttt\r\n" ) ;
    while(port == UNZ_OK)
    {
		char name[132];
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ( strrchr(name, '.' ) )
			strcpy( filename, strrchr(name,'.')+1 ) ;

		strupr(filename) ;

		if ( ( strcmp( filename, "NFO" ) == 0 ) ||
			 ( strcmp( filename, "TXT" ) == 0 ) ||
			 ( strcmp( filename, "DIZ" ) == 0 ) )
		{
		}
		else
		{
			swprintf( m_menuText[numlines++], L"%S", name ) ;
		}

		port = unzGoToNextFile(file);
    }

	//writexbox( "ttt\r\n" ) ;
    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) )
    {
		unzClose(file) ;
		return 0 ;
    }
	//writexbox( "ttt\r\n" ) ;

	sprintfx( "found zipfile %s\r\n", filename ) ;


	if ( numlines < 3 )
		menuChoice = 0 ;
	else
	{
		while ( 1 )
		{
			pmenuParams = &(m_skin.popupMenu) ;


			menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, numlines, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();
				menuChoice = 0 ;
				break ;
			}
			else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();
				break ;
			}


		}
	}


	sprintf( filename, "%S", m_menuText[menuChoice+1] ) ;

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
	//writexbox( "ttt\r\n" ) ;
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		return 0 ;
    }

	//writexbox( "ttt\r\n" ) ;

	data = (byte*)malloc( info.uncompressed_size ) ;

	//writexbox( "ttt\r\n" ) ;

	int l = unzReadCurrentFile(file,data,info.uncompressed_size);
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(data) ;
	    unzClose(file);
		return 0 ;
	}

	//writexbox( "ttt\r\n" ) ;
    unzClose(file);

	sprintfx( "loadeddata\n" ) ;

	char *fptr = strrchr( zipfile, '\\' ) ;
	char *eptr = strrchr( filename, '.' ) ;
	char *gptr = strrchr( zipfile, '.' ) ;

	if ( gptr )
		*gptr = 0 ;

	if ( fptr )
	{
		sprintf( newfilename, "Z:\\%s%s", fptr+1,eptr  ) ;
	}
	else
	{
		sprintf( newfilename, "Z:\\%s%s", zipfile,eptr  ) ;
	}

	sprintfx( "newfile %s\n", newfilename );

	DeleteFile( newfilename ) ;

	FILE *outfile = fopen( newfilename, "wb") ;

	if ( outfile )
	{
		sprintfx( "opened file %s\n", newfilename );
		fwrite( data, 1, info.uncompressed_size, outfile ) ;
		fclose( outfile ) ;
	}

	free(data) ;


	return 1;
}
void xbox_sidstart()
{
	g_mp3player->pause( 0 ) ;
}
void xbox_sidpause()
{
	g_mp3player->pause( 1 ) ;
}
void xbox_sidstop()
{
	g_mp3player->pause( 1 ) ;
}
void xbox_setsidspecs( int channels, int frequency, int precision, int framebytes ) 
{
	g_mp3player->setNewFormatSID( precision, channels, frequency, framebytes ) ;
}
