#define DWORDBIG(x) ((x>>16)&0xFFFF)|(x<<16)

#define	MEMCON1 *(WORD*)(MEM+0xF00000)	// Memory Configuration Register 1
#define MEMCON2 *(WORD*)(MEM+0xF00002)	// Memory Configuration Register 2
#define HC      *(WORD*)(MEM+0xF00004)	// Horizontal Counter
#define VC		*(WORD*)(MEM+0xF00006)	// Vertical Counter
#define LPH		*(WORD*)(MEM+0xF00008)	// Horizontal Light-pen
#define LPV		*(WORD*)(MEM+0xF0000A)	// Vertical Light-pen
#define OB0		*(WORD*)(MEM+0xF00010)	// Object Code
#define OB1		*(WORD*)(MEM+0xF00012)	
#define OB2		*(WORD*)(MEM+0xF00014)
#define OB3		*(WORD*)(MEM+0xF00016)
#define	OB		*(LONGLONG*)(MEM+0xF00010)	// 64-bit Object Code
#define OLP		*(DWORD*)(MEM+0xF00020)	// Object List Pointer
#define OBF		*(WORD*)(MEM+0xF00026)	// Object Processor Flag
#define VMODE	*(WORD*)(MEM+0xF00028)	// Video Mode
#define BORD1	*(WORD*)(MEM+0xF0002A)	// Border Colour (Red & Green)
#define BORD2	*(WORD*)(MEM+0xF0002C)	// Border Colour (Blue)
#define BORD	*(DWORD*)(MEM+0xF0002A)  // Border Colour 32-bit
#define HP		*(WORD*)(MEM+0xF0002E)	// Horizontal Period
#define HBB		*(WORD*)(MEM+0xF00030)	// Horizontal Blanking Begin
#define HBE		*(WORD*)(MEM+0xF00032)	// Horizontal Blanking End
#define HS		*(WORD*)(MEM+0xF00034)	// Horizontal Sync
#define HVS		*(WORD*)(MEM+0xF00036)	// Horizontal Vertical Sync
#define HDB1	*(WORD*)(MEM+0xF00038)	// Horizontal Display Begin 1
#define HDB2	*(WORD*)(MEM+0xF0003A)	// Horizontal Display Begin 2
#define HDE		*(WORD*)(MEM+0xF0003C)	// Horizontal Display End
#define VP		*(WORD*)(MEM+0xF0003E)	// Vertical Period
#define VBB		*(WORD*)(MEM+0xF00040)	// Vertical Blanking Begin
#define VBE		*(WORD*)(MEM+0xF00042)	// Vertical Blanking End
#define VS		*(WORD*)(MEM+0xF00044)	// Vertical Sync
#define VDB		*(WORD*)(MEM+0xF00046)	// Vertical Display Begin
#define VDE		*(WORD*)(MEM+0xF00048)	// Vertical Display End
#define VEB		*(WORD*)(MEM+0xF0004A)	// Vertical Equalization Begin
#define VEE		*(WORD*)(MEM+0xF0004C)	// Vertical Equalization End
#define VI		*(WORD*)(MEM+0xF0004E)	// Vertical Interrupt
#define PIT0	*(WORD*)(MEM+0xF00050)	// Programmable Interrupt Timer
#define PIT1	*(WORD*)(MEM+0xF00052)
#define HEQ		*(WORD*)(MEM+0xF00054)	// Horizontal Equalization End
#define BG		*(WORD*)(MEM+0xF00058)	// Background Color
#define INT1	*(WORD*)(MEM+0xF000E0)	// CPU Interrupt Control Register
#define INT2	*(WORD*)(MEM+0xF000E2)	// CPU Interrupt Resume Register
	
	// Jerry Registers
#define CLK1	*(WORD*)(MEM+0xF10010)	// Processor Clock Divider
#define CLK2	*(WORD*)(MEM+0xF10012)	// Video Clock Divider
#define CLK3	*(WORD*)(MEM+0xF10014)	// Chroma Clock Divider
#define JPIT1	*(WORD*)(MEM+0xF10000)	// Timer 1 Pre-Scaler
#define JPIT2	*(WORD*)(MEM+0xF10002)	// Timer 1 Divider
#define JPIT3	*(WORD*)(MEM+0xF10004)	// Timer 2 Pre-Scaler
#define JPIT4	*(WORD*)(MEM+0xF10006)	// Timer 2 Divider
#define JINTCTRL *(WORD*)(MEM+0xF10020)	// Interrupt Control Register
#define SCLK	*(WORD*)(MEM+0xF1A150) // Serial Clock Frequency
#define SMODE	*(WORD*)(MEM+0xF1A152)	// Serial Mode
#define R_DAC	*(WORD*)(MEM+0xF1A148)	// Right Transmit Data to DACs
#define L_DAC	*(WORD*)(MEM+0xF1A14C)	// Left Transmit Data to DACs



// Blitter Registers

#define A1_BASE			*(DWORD*)(MEM+0xF02200)
#define A1_FLAGS		*(DWORD*)(MEM+0xF02204)
#define A1_CLIP			*(DWORD*)(MEM+0xF02208)
#define A1_CLIP_X		*(WORD*)(MEM+0xF0220A)
#define A1_CLIP_Y		*(WORD*)(MEM+0xF02208)
#define A1_PIXEL		*(DWORD*)(MEM+0xF0220C)
#define A1_PIXEL_Y		*(WORD*)(MEM+0xF0220C)
#define A1_PIXEL_X		*(WORD*)(MEM+0xF0220E)
#define A1_STEP			*(DWORD*)(MEM+0xF02210)
#define A1_STEP_Y		*(WORD*)(MEM+0xF02210)
#define A1_STEP_X		*(WORD*)(MEM+0xF02212)
#define A1_FSTEP		*(DWORD*)(MEM+0xF02214)
#define A1_FSTEP_Y		*(WORD*)(MEM+0xF02214)
#define A1_FSTEP_X		*(WORD*)(MEM+0xF02216)
#define A1_FPIXEL		*(DWORD*)(MEM+0xF02218)
#define A1_FPIXEL_Y		*(WORD*)(MEM+0xF02218)
#define A1_FPIXEL_X		*(WORD*)(MEM+0xF0221A)
#define A1_INC			*(DWORD*)(MEM+0xF0221C)
#define A1_INC_Y		*(WORD*)(MEM+0xF0221C)
#define A1_INC_X		*(WORD*)(MEM+0xF0221E)
#define A1_FINC			*(DWORD*)(MEM+0xF02220)
#define A1_FINC_Y		*(WORD*)(MEM+0xF02220)
#define A1_FINC_X		*(WORD*)(MEM+0xF02222)
#define A2_BASE			*(DWORD*)(MEM+0xF02224)
#define A2_FLAGS		*(DWORD*)(MEM+0xF02228)
#define A2_MASK			*(DWORD*)(MEM+0xF0222C)
#define A2_MASK_Y		*(WORD*)(MEM+0xF0222C)
#define A2_MASK_X		*(WORD*)(MEM+0xF0222E)
#define A2_PIXEL		*(DWORD*)(MEM+0xF02230)
#define A2_PIXEL_Y		*(WORD*)(MEM+0xF02230)
#define A2_PIXEL_X		*(WORD*)(MEM+0xF02232)
#define A2_STEP			*(DWORD*)(MEM+0xF02234)
#define A2_STEP_Y		*(WORD*)(MEM+0xF02234)
#define A2_STEP_X		*(WORD*)(MEM+0xF02236)
#define B_CMD			*(DWORD*)(MEM+0xF02238)
#define B_COUNT			*(DWORD*)(MEM+0xF0223C)
#define B_COUNT_OUT		*(WORD*)(MEM+0xF0223C)
#define B_COUNT_IN		*(WORD*)(MEM+0xF0223E)
#define B_SRCD			*(LONGLONG*)(MEM+0xF02240)
#define B_SRCD0			*(DWORD*)(MEM+0xF02240)
#define B_SRCD1			*(DWORD*)(MEM+0xF02244)
#define B_DSTD			*(LONGLONG*)(MEM+0xF02248)
#define B_DSTD0			*(DWORD*)(MEM+0xF02248)
#define B_DSTD1			*(DWORD*)(MEM+0xF0224C)
#define B_DSTZ			*(LONGLONG*)(MEM+0xF02250)
#define B_DSTZ0			*(DWORD*)(MEM+0xF02250)
#define B_DSTZ1			*(DWORD*)(MEM+0xF02254)
#define B_SRCZ			*(LONGLONG*)(MEM+0xF02258)   // Source Z Integer
#define B_SRCZ0			*(DWORD*)(MEM+0xF02258)
#define B_SRCZ1			*(DWORD*)(MEM+0xF0225C)
#define B_SRCZF			*(LONGLONG*)(MEM+0xF02260)   // Source Z Fraction
#define B_SRCZF0		*(DWORD*)(MEM+0xF02260)
#define B_SRCZF1		*(DWORD*)(MEM+0xF02264)
#define B_PATD			*(LONGLONG*)(MEM+0xF02268)
#define B_PATD0			*(DWORD*)(MEM+0xF02268)
#define B_PATD1			*(DWORD*)(MEM+0xF0226C)
#define B_IINC			*(DWORD*)(MEM+0xF02270)
#define B_IINC_I		*(WORD*)(MEM+0xF02270)
#define B_IINC_F		*(WORD*)(MEM+0xF02272)
#define B_ZINC			*(DWORD*)(MEM+0xF02274)
#define B_ZINC_I		*(WORD*)(MEM+0xF02274)
#define B_ZINC_F		*(WORD*)(MEM+0xF02276)
#define B_STOP			*(DWORD*)(MEM+0xF02278)
#define B_I3			*(DWORD*)(MEM+0xF0227C)
#define B_I3_I			*(WORD*)(MEM+0xF0227C)
#define B_I3_F			*(WORD*)(MEM+0xF0227E)
#define B_I2			*(DWORD*)(MEM+0xF02280)
#define B_I2_I			*(WORD*)(MEM+0xF02280)
#define B_I2_F			*(WORD*)(MEM+0xF02282)
#define B_I1			*(DWORD*)(MEM+0xF02284)
#define B_I1_I			*(WORD*)(MEM+0xF02284)
#define B_I1_F			*(WORD*)(MEM+0xF02286)
#define B_I0			*(DWORD*)(MEM+0xF02288)
#define B_I0_I			*(WORD*)(MEM+0xF02288)
#define B_I0_F			*(WORD*)(MEM+0xF0228A)
#define B_Z3			*(DWORD*)(MEM+0xF0228C)
#define B_Z3_I			*(WORD*)(MEM+0xF0228C)
#define B_Z3_F			*(WORD*)(MEM+0xF0228E)
#define B_Z2			*(DWORD*)(MEM+0xF02290)
#define B_Z2_I			*(WORD*)(MEM+0xF02290)
#define B_Z2_F			*(WORD*)(MEM+0xF02292)
#define B_Z1			*(DWORD*)(MEM+0xF02294)
#define B_Z1_I			*(WORD*)(MEM+0xF02294)
#define B_Z1_F			*(WORD*)(MEM+0xF02296)
#define B_Z0			*(DWORD*)(MEM+0xF02298)
#define B_Z0_I			*(WORD*)(MEM+0xF02298)
#define B_Z0_F			*(WORD*)(MEM+0xF0229A)


// GPU Registers

#define G_FLAGS			*(DWORD*)(MEM+0xF02100)
#define G_FLAGSW		*(WORD*)(MEM+0xF02102)
#define G_MTXC			*(DWORD*)(MEM+0xF02104)
#define G_MTXA			*(DWORD*)(MEM+0xF02108)
#define G_END			*(DWORD*)(MEM+0xF0210C)
#define G_PC			*(DWORD*)(MEM+0xF02110)
#define G_CTRL			*(DWORD*)(MEM+0xF02114)
#define G_HIDATA		*(DWORD*)(MEM+0xF02118)
#define G_DIVCTRL		*(DWORD*)(MEM+0xF0211C)

typedef struct {
	DWORD video;
	DWORD gpu;
	DWORD op;
	DWORD timer;
	DWORD jerry;
	DWORD video_active;
	DWORD gpu_active;
	DWORD op_active;
	DWORD timer_active;
	DWORD jerry_active;
} M68K_INTERRUPTS;

typedef struct {
	int pit_value;
	int pit_current_value;
	DWORD pit_active;
	int pit1_prescale;
	int pit1_divider;
	int pit1_prescale_value;
	int pit1_divider_value;
	DWORD pit1_active;
	int pit2_prescale;
	int pit2_divider;
	int pit2_prescale_value;
	int pit2_divider_value;
	DWORD pit2_active;
} TIMERS;

typedef struct {
	DWORD external;
	DWORD dsp;
	DWORD pit1;
	DWORD pit2;
	DWORD asi;
	DWORD ssi;
	DWORD external_active;
	DWORD dsp_active;
	DWORD pit1_active;
	DWORD pit2_active;
	DWORD asi_active;
	DWORD ssi_active;
} JERRY_INTERRUPTS;