#include "stdafx.h"
#include "regs.h"
#include "iomem.h"
#include "op.h"
#include "gpu.h"
#include "mem.h"
#include <math.h>

int CLIP_XSTART_LINE = 0;
int CLIP_XEND_LINE   = 640;
int CLIP_YSTART_LINE = 0;
int CLIP_YEND_LINE   = 480;

#define MAX_OP_LOOPS 200
#define LOAD_CLUT(addr) *(WORD*)(MEM+0xF00400+addr)

extern WORD* screen;
extern int screen_depth;

extern BYTE* MEM;

DWORD* colortable;
DWORD* colortable_c;
DWORD* colortable_d;
DWORD* linecache;
BYTE* rmw_y;
BYTE* rmw_c;

void DrawObjectXLine(bitmap_object*,DWORD);
void DrawObject8Line(bitmap_object*,DWORD);
void DrawObject16Line(bitmap_object*, DWORD);
void DrawScaledObjectXLine(scaled_bitmap_object*, DWORD);
void DrawScaledObject16Line(scaled_bitmap_object*, DWORD);

void InitOp(void)
{
	linecache = new DWORD[0x1000];
	colortable_c = new DWORD[0x10000];
	colortable_d = new DWORD[0x10000];
	rmw_y = new BYTE[0x10000];
	rmw_c = new BYTE[0x10000];
	for(int i=0;i<0x10000;i++) {
		int x = (i>>12) & 0xF;
		int y = (i>>8) & 0xF;
		int l = i & 0xFF;
        int r = color_red[x][y];
		int g = color_green[x][y];
		int b = color_blue[x][y];
        int dr = (r * l) / 255;
		int dg = (g * l) / 255;
		int db = (b * l) / 255;
		//if(screen_depth == 32) 
			colortable_c[i] = 0xFF000000 | (dr<<16) | (dg<<8) | db;
		//else
		//	colortable_c[i] = ((dr >> 3) << 11) | ((dg >> 2) << 5) | (db >> 3);
		int d_r = ((i>>11)&0x1F)<<3;
		int d_b = ((i>>6)&0x1F)<<3;
		int d_g = (i&0x3F)<<2;
		//if(screen_depth == 32)
			colortable_d[i] = 0xFF000000 | d_r<<16 | d_g<<8 | d_b;
		//else
		//	colortable_d[i] = ((d_r >> 3) << 11) | ((d_g >> 2) << 5) | (d_b >> 3);
	}
	for(i=0;i<0x10000;i++) {
		int y1 = (i >> 8) & 0xFF;
		int y2 = (i & 0xFF);
		if(y2 & 0x80)
			y2 |= 0xFFFFFF00;
		y1 += y2;
		if(y1 < 0)
			y1 = 0;
		if(y1 > 255)
			y1 = 255;
		int c1a = (i >> 12) & 0xF;
		int c1b = (i >> 8) & 0xF;
		int c2a = (i >> 4) & 0xF;
		int c2b = (i & 0xF);
		if(c2a & 0x8)
			c2a |= 0xFFFFFFF0;
		if(c2b & 0x8)
			c2b |= 0xFFFFFFF0;
		c1a += c2a;
		c1b += c2b;
		if(c1a < 0)
			c1a = 0;
		if(c1a > 15)
			c1a = 15;
		if(c1b < 0)
			c1b = 0;
		if(c1b > 15)
			c1b = 15;
		rmw_y[i] = y1;
		rmw_c[i] = c1a << 4 | c1b;
	}
	colortable = colortable_c;
}

void EndOp(void)
{
	delete [] linecache;
	delete [] colortable_c;
	delete [] colortable_d;
	delete [] rmw_y;
	delete [] rmw_c;
}

void OpExecLine(DWORD scanline)
{
	int loops = 0;
	BOOL op_stopped = FALSE;
	DWORD olp = OLP & 0xFFFFFFF8;
	if(olp == NULL)
		return;
	DWORD hid,lod,hid2,lod2,lod3;
	DWORD cmode = VMODE;
	if(((cmode>>1)&0x3) == 0) {
		colortable = colortable_c;
	} else {
		colortable = colortable_d;
	}
	int pixel_width = ((VMODE >> 9) & 0x7);
	int hdb = ((HDE+0x400) - HDB1) / (pixel_width+1);
	//CLIP_XEND_LINE = 1280 / ((pixel_width+1));//hdb/2;
	do {
		hid = ReadMem32(olp);
		lod = ReadMem32(olp+4);
		switch(lod&0x7) {
		case 3: {
			branch_object brc;
			brc.link_address = (((hid & 0x1FFF)<<8) | ((lod>>24) & 0xFF)) * 8;
			brc.cc = (lod>>14) & 0x3;
			brc.vcnt = (lod>>3) & 0x7FF;
			WORD obf;
			obf = OBF;
			bool condition = false;
			switch(brc.cc) {
				case 0:
				{
					if(brc.vcnt == 0x7FF || brc.vcnt == scanline)
						condition = true;
					break;
				}
				case 1:
				{
					if(brc.vcnt > scanline)
						condition = true;
					break;
				}
				case 2:
				{
					if(brc.vcnt < scanline)
						condition = true;
					break;
				}
				case 3:
				{
					if(obf & 0x1)
						condition = true;
					break;
				}
				default:
				{
					op_stopped = TRUE;
					break;
				}
			}
			if(condition) {
				olp = brc.link_address;
			} else {
				olp += 8;
			}
			break;
		}
		case 4:
			op_stopped = TRUE;
			break;
		case 0:
			bitmap_object bmp;
			hid2 = ReadMem32(olp+8);
			lod2 = ReadMem32(olp+12);

			bmp.link_address = (((hid & 0x7FF)<<8) | (lod>>24) & 0xFF) * 8;
            bmp.data_address = (hid>>8) & 0x1FFFF8;
			bmp.height = (lod>>14) & 0x3FF;
			bmp.ypos = (lod>>3) & 0x7FF;
			bmp.firstpix = (hid2>>17) & 0x3F;
			bmp.flags = (hid2>>13) & 0xF;
			bmp.index = (hid2>>6) & 0x7F;
			bmp.iwidth = ((hid2 & 0x3F)<<4) | (lod2>>28) & 0xF;
			bmp.dwidth = (lod2>>18) & 0x3FF;
			bmp.pitch = (lod2>>15) & 0x7;
			bmp.depth = (lod2>>12) & 0x7;
			bmp.xpos = lod2 & 0xFFF;
			if(bmp.xpos & 0x800)
				bmp.xpos |= 0xFFFFF000;

			switch(bmp.depth) {
				case 0:case 1:case 2:
					DrawObjectXLine(&bmp,scanline);break;
				case 3:
					DrawObject8Line(&bmp,scanline);break;
				case 4:
					DrawObject16Line(&bmp,scanline);break;
				case 5:
					break;
				default:break;
			}
			olp = bmp.link_address;
			break;
		case 1:
			scaled_bitmap_object sbmp;
			hid2 = ReadMem32(olp+8);
			lod2 = ReadMem32(olp+12);
			lod3 = ReadMem32(olp+20);

			sbmp.link_address = (((hid & 0x7FF)<<8) | (lod>>24) & 0xFF) * 8;
			sbmp.data_address = (hid>>8) & 0x1FFFF8;
			sbmp.height = (lod>>14) & 0x3FF;
			sbmp.ypos = (lod>>3) & 0x7FF;
			sbmp.firstpix = (hid2>>17) & 0x3F;
			sbmp.flags = (hid2>>13) & 0xF;
			sbmp.index = (hid2>>6) & 0x7F;
			sbmp.iwidth = ((hid2 & 0x3F)<<4) | (lod2>>28) & 0xF;
			sbmp.dwidth = (lod2>>18) & 0x3FF;
			sbmp.pitch = (lod2>>15)&0x7;
			sbmp.depth = (lod2>>12)&0x7;
			sbmp.xpos = lod2&0xFFF;
			if(sbmp.xpos & 0x800)
				sbmp.xpos |= 0xFFFFF000;
			sbmp.remain = (lod3>>16) & 0xFF;
			sbmp.vscale = (lod3>>8) & 0xFF;
			sbmp.hscale = lod3 & 0xFF;
			switch(sbmp.depth) {
				case 0:case 1:case 2:case 3:
					DrawScaledObjectXLine(&sbmp,scanline);break;
				case 4:
					DrawScaledObject16Line(&sbmp,scanline);break;
				case 5:
					break;
			}
			olp = sbmp.link_address;
			break;
		case 2: {
			int ypos = (lod >> 3) & 0x7FF;
			//ypos <<= 1;
			ypos &= 0xFFFFFFFE;
			if(ypos == scanline) {
				*(DWORD*)(MEM+0xF00010) = DWORDBIG(lod);
				*(DWORD*)(MEM+0xF00014) = DWORDBIG(hid);
				//gpu_interrupt(3);
			}
			//gpu_interrupt(3);
			olp += 8;
			break;
		}
		default:
			op_stopped = TRUE;
			break;
		}
		loops++;
	} while(op_stopped != TRUE && loops<MAX_OP_LOOPS);
}

void DrawObjectXLine(bitmap_object* bmp,DWORD scanline)
{
	int ppp = 64 / pow2[bmp->depth];
	int bpp = pow2[bmp->depth];
	int width = bmp->iwidth * ppp;
	int y = bmp->ypos/2;
	int y2 = (scanline/2) - y;
	if(y2 < 0)
		return;
	if(y2 > CLIP_YEND_LINE || y2 >= bmp->height)
		return;
	int x,x2,ii2,iia;
	if(bmp->flags & 0x1) {
		x2 = bmp->xpos;
		x = x2 - width;
	} else {
		x = bmp->xpos;
		x2 = x + width;
	}
	int ii=0;
	int ij=0;

	if(x2 > CLIP_XEND_LINE)
		x2 = CLIP_XEND_LINE-1;
	if(x < CLIP_XSTART_LINE) {
        ii = abs(CLIP_XSTART_LINE-x);
		x = 0;
	}
	ii += bmp->firstpix;
	if(bmp->flags & 0x1) {
		ii2 = width - ii - 1;
		iia = -1;
	} else {
		ii2 = ii;
		iia = 1;
	}
	DWORD data = GetRealPointer(bmp->data_address);
	if(data == NULL)
		return;
	int index = (y2 * bmp->dwidth<<3);
	int s = (scanline/2)*SCREEN_WIDTH;
	for(int cl=0; cl<width; cl += ppp) {
		DWORD b1,b2;
		__asm {
			mov esi,[data]
			add esi,[index]
			mov eax,[esi]
			mov edx,[esi+4]
			ror eax,16
			ror edx,16
			mov [b1],eax
			mov [b2],edx
		}
		for(int h=0; h<ppp/2; h++) {
			int p = (b1 >> (((ppp/2)-1)-h) * bpp) & bitmask[bmp->depth];
			int c = LOAD_CLUT( (((bmp->index << 1) + p) << 1) );
			if(p==0)
				c |= 0x10000;
			linecache[cl+h] = c;
		}
		for(h=ppp/2; h<ppp; h++) {
			int p = (b2 >> (((ppp/2)-1)-h) * bpp) & bitmask[bmp->depth];
			int c = LOAD_CLUT( (((bmp->index << 1) + p) << 1) );
			if(p==0)
				c |= 0x10000;
			linecache[cl+h] = c;
		}
		index+=(bmp->pitch<<3);
	}
	int h2 = ii2;
	if(bmp->flags & 0x2) {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix & 0x10000 && bmp->flags & 0x4)) {
				WORD pix2 = pix;
				WORD oldpix = screen[s+i];
				WORD newpix = ((WORD)rmw_c[oldpix&0xFF00|(pix2>>8)]<<8) | rmw_y[((oldpix&0xFF)<<8)|(pix2&0xFF)];
				screen[s+i] = newpix;
			}
			h2+=iia;
		}
	} else {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix & 0x10000 && bmp->flags & 0x4)) {
				screen[s+i] = pix & 0xFFFF;
			}
			h2+=iia;
		}
	}
}

void DrawObject8Line(bitmap_object* bmp,DWORD scanline)
{
	int width = bmp->iwidth * 8;
	int y = bmp->ypos/2;
	int y2 = (scanline/2) - y;
	if(y2 < 0)
		return;
	if(y2 > CLIP_YEND_LINE || y2 >= bmp->height)
		return;
	int x,x2,ii2,iia;
	if(bmp->flags & 0x1) {
		x2 = bmp->xpos;
		x = x2 - width;
	} else {
		x = bmp->xpos;
		x2 = x + width;
	}
	int ii=0;
	int ij=0;

	if(x2 > CLIP_XEND_LINE)
		x2 = CLIP_XEND_LINE-1;
	if(x < CLIP_XSTART_LINE) {
        ii = abs(CLIP_XSTART_LINE-x);
		x = 0;
	}
	ii += bmp->firstpix;
	if(bmp->flags & 0x1) {
		ii2 = width - ii - 1;
		iia = -1;
	} else {
		ii2 = ii;
		iia = 1;
	}
	DWORD data = GetRealPointer(bmp->data_address);
	if(data == NULL)
		return;
	int index = (y2 * bmp->dwidth<<3);
	int s = (scanline/2)*SCREEN_WIDTH;
	for(int cl=0; cl<width; cl += 8) {
		DWORD b1,b2;
		__asm {
			mov esi,[data]
			add esi,[index]
			mov eax,[esi]
			mov edx,[esi+4]
			//ror eax,16
			//ror edx,16
			mov [b1],eax
			mov [b2],edx
		}
		DWORD p,c;
		p = (b1 >> 8) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl] = c;
		p = b1 & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+1] = c;
		p = (b1 >> 24) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+2] = c;
		p = (b1 >> 16) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+3] = c;
		p = (b2 >> 8) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+4] = c;
		p = b2 & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+5] = c;
		p = (b2 >> 24) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+6] = c;
		p = (b2 >> 16) & 0xFF;
		c = LOAD_CLUT( (p<<1) );
		if(p==0)
			c |= 0x10000;
		linecache[cl+7] = c;
		index+=(bmp->pitch<<3);
	}
	int h2 = ii2;
	if(bmp->flags & 0x2) {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix & 0x10000 && bmp->flags & 0x4)) {
				WORD pix2 = pix;
				WORD oldpix = screen[s+i];
				WORD newpix = (WORD)(rmw_c[(oldpix&0xFF00)|(pix2>>8)])<<8 | rmw_y[((oldpix&0xFF)<<8)|(pix2&0xFF)];
				screen[s+i] = newpix;
			}
			h2+=iia;
		}
	} else {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix & 0x10000 && bmp->flags & 0x4)) {
				screen[s+i] = pix & 0xFFFF;
			}
			h2+=iia;
		}
	}
}

void DrawScaledObjectXLine(scaled_bitmap_object* bmp,DWORD scanline)
{
	int ppp = 64 / pow2[bmp->depth];
	int bpp = pow2[bmp->depth];
	float yscale = ((bmp->vscale>>5)&0x7) + ((bmp->vscale&0x1F) / 31.0f);
	int ystep = (int)((1.0f / yscale) * 65536.0f);
	float xscale = ((bmp->hscale>>5)&0x7) + ((bmp->hscale&0x1F) / 31.0f);
	if(xscale == 0 || yscale == 0)
		return;
	int xstep = (int)((1.0f / xscale) * 65536.0f);
	int width = bmp->iwidth * ppp;
	int y = bmp->ypos/2;
	int y2 = (scanline / 2) - y;
	if(y2 < 0)
		return;
	if(y2 > CLIP_YEND_LINE || y2 >= (int)(bmp->height * yscale))
		return;
	int x,x2,ii2,iia;
	if(bmp->flags & 0x1) {
		x2 = bmp->xpos;
		x = x2 - (int)(width * xscale);
	} else {
		x = bmp->xpos;
		x2 = x + (int)(width * xscale);
	}
	int ii=0;
	int ij= ystep * y2;
	ii += (bmp->firstpix<<16);
	if(bmp->flags & 0x1) {
		ii2 = (width<<16) - ii - 0x10000;
		iia = -xstep;
	} else {
		ii2 = ii;
		iia = xstep;
	}
	DWORD data = GetRealPointer(bmp->data_address);
	int index=((ij>>16) * bmp->dwidth<<3);
	int s = (scanline/2)*SCREEN_WIDTH;
	for(int cl=0; cl<width; cl += ppp) {
		DWORD b1,b2;
		__asm {
			mov esi,[data]
			add esi,[index]
			mov eax,[esi]
			mov edx,[esi+4]
			ror eax,16
			ror edx,16
			mov [b1],eax
			mov [b2],edx
		}
		for(int h=0; h<ppp/2; h++) {
			int p = (b1 >> ((ppp-1)-h) * bpp) & bitmask[bmp->depth];
			int c = LOAD_CLUT( (((bmp->index << 1) + p) << 1) );
			if(p==0)
				c |= 0x10000;
			linecache[cl+h] = c;
		}
		for(h=ppp/2; h<ppp; h++) {
			int p = (b2 >> ((ppp-1)-h) * bpp) & bitmask[bmp->depth];
			int c = LOAD_CLUT( (((bmp->index << 1) + p) << 1) );
			if(p==0)
				c |= 0x10000;
			linecache[cl+h] = c;
		}
		index+=(bmp->pitch<<3);
	}
	int h2 = ii2;
	if(bmp->flags & 0x2) {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[(h2>>16)&0xFFF];
			if(!(pix & 0x10000 && bmp->flags & 0x4) && i>=0 && i<640) {
				WORD pix2 = pix;
				WORD oldpix = screen[s+i];
				WORD newpix = (WORD)(rmw_c[(oldpix&0xFF00)|(pix2>>8)])<<8 | rmw_y[((oldpix&0xFF)<<8)|(pix2&0xFF)];
				screen[s+i] = newpix;
			}
			h2+=iia;
		}
	} else {
		for(int i=x; i<x2; i++) {		
			DWORD pix = linecache[(h2>>16)&0xFFF];
			if(!(pix & 0x10000 && bmp->flags & 0x4) && i>=0 && i<640) {
				screen[s+i] = pix & 0xFFFF;
			}
			h2+=iia;
		}
	}
}

void DrawObject16Line(bitmap_object* bmp,DWORD scanline)
{
	int width = bmp->iwidth * 4;
	int y = bmp->ypos/2;
	int y2 = (scanline/2) - y;
	if(y2 < 0)
		return;
	if(y2 > CLIP_YEND_LINE || y2 >= bmp->height)
		return;
	int x,x2,ii2,iia;
	if(bmp->flags & 0x1) {
		x2 = bmp->xpos;
		x = x2 - width;
	} else {
		x = bmp->xpos;
		x2 = x + width;
	}
	int ii=0;
	int ij=0;
	if(x2 > CLIP_XEND_LINE)
		x2 = CLIP_XEND_LINE-1;
	if(x < CLIP_XSTART_LINE) {
        ii = abs(CLIP_XSTART_LINE-x);
		x = 0;
	}
	ii += bmp->firstpix;
	if(bmp->flags & 0x1) {
		ii2 = width - ii - 1;
		iia = -1;
	} else {
		ii2 = ii;
		iia = 1;
	}
	DWORD data = GetRealPointer(bmp->data_address);
	int index = (y2 * bmp->dwidth<<3);
	int s = (scanline/2)*SCREEN_WIDTH;
	for(int cl=0; cl<width; cl += 4) {
		DWORD b1,b2;
		__asm {
			mov esi,[data]
			add esi,[index]
			mov eax,[esi]
			mov edx,[esi+4]
			ror eax,16
			ror edx,16
			mov [b1],eax
			mov [b2],edx
		}
		linecache[cl] = b1 >> 16;
		linecache[cl+1] = b1 & 0xFFFF;
		linecache[cl+2] = b2 >> 16;
		linecache[cl+3] = b2 & 0xFFFF;
		index+=(bmp->pitch<<3);
	}
	int h2 = ii2;
	if(bmp->flags & 0x2) {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix & 0x10000 && bmp->flags & 0x4)) {
				WORD pix2 = pix;
				WORD oldpix = screen[s+i];
				WORD newpix = (WORD)(rmw_c[(oldpix&0xFF00)|(pix2>>8)])<<8 | rmw_y[((oldpix&0xFF)<<8)|(pix2&0xFF)];
				screen[s+i] = newpix;
			}
			h2+=iia;
		}
	} else {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[h2];
			if(!(pix == 0 && bmp->flags & 0x4))
				screen[s+i] = pix;
			h2+=iia;
		}
	}
}

void DrawScaledObject16Line(scaled_bitmap_object* bmp,DWORD scanline)
{
	float yscale = ((bmp->vscale>>5)&0x7) + ((bmp->vscale&0x1F) / 31.0f);
	int ystep = (int)((1.0f / yscale) * 65536.0f);
	float xscale = ((bmp->hscale>>5)&0x7) + ((bmp->hscale&0x1F) / 31.0f);
	if(xscale == 0 || yscale == 0)
		return;
	int xstep = (int)((1.0f / xscale) * 65536.0f);
	int width = bmp->iwidth * 4;
	int y = bmp->ypos/2;
	int y2 = (scanline / 2) - y;
	if(y2 < 0)
		return;
	if(y2 > CLIP_YEND_LINE || y2 >= (int)(bmp->height * yscale))
		return;
	int x,x2,ii2,iia;
	int ii=0;
	int ij = y2 * ystep;
	if(bmp->flags & 0x1) {
		x2 = bmp->xpos;
		x = x2 - (int)(width * xscale);
	} else {
		x = bmp->xpos;
		x2 = x + (int)(width * xscale);
	}
	//ii += (bmp->firstpix << 16);
	if(bmp->flags & 0x1) {
		ii2 = (width<<16) - ii - 0x10000;
		iia = -xstep;
	} else {
		ii2 = ii;
		iia = xstep;
	}
	DWORD data = GetRealPointer(bmp->data_address);
	int index=((ij>>16) * bmp->dwidth<<3);
	int s = (scanline / 2)*SCREEN_WIDTH;
	for(int cl=0; cl<width; cl += 4) {
		DWORD b1,b2;
		__asm {
			mov esi,[data]
			add esi,[index]
			mov eax,[esi]
			mov edx,[esi+4]
			ror eax,16
			ror edx,16
			mov [b1],eax
			mov [b2],edx
		}
		linecache[cl] = b1 >> 16;
		linecache[cl+1] = b1 & 0xFFFF;
		linecache[cl+2] = b2 >> 16;
		linecache[cl+3] = b2 & 0xFFFF;
		index+=(bmp->pitch<<3);
	}
	int h2 = ii2;
	if(bmp->flags & 0x2) {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[(h2>>16)&0xFFF];
			if(!(pix == 0 && bmp->flags & 0x4) && i>=0 && i<640) {
				WORD pix2 = pix;
				WORD oldpix = screen[s+i];
				WORD newpix = (WORD)(rmw_c[(oldpix&0xFF00)|(pix2>>8)])<<8 | rmw_y[((oldpix&0xFF)<<8)|(pix2&0xFF)];
				screen[s+i] = newpix;
			}
			h2+=iia;
		}
	} else {
		for(int i=x; i<x2; i++) {
			DWORD pix = linecache[(h2>>16)&0xFFF];
			if(!(pix == 0 && bmp->flags & 0x4) && i>=0 && i<640)
				screen[s+i] = pix;
			h2+=iia;
		}
	}
}