#include "stdafx.h"
#include "gfx.h"
#include "regs.h"
#include "input.h"

SDL_Surface* frontbuffer;

extern WORD* screen;
extern BYTE* MEM;
extern int pixel_expansion;
int screen_width,screen_height,screen_depth;
extern DWORD* colortable;
extern DWORD* colortable_c;
extern DWORD* colortable_d;

long InitSDL(int width, int height, int bpp, int fullscreen) {
	screen_width = width;
	screen_height = height;
	screen_depth = bpp / 8;

	int flags = SDL_HWSURFACE | SDL_ANYFORMAT;
	if(fullscreen)
		flags |= SDL_FULLSCREEN;
	frontbuffer = SDL_SetVideoMode(width, height, bpp, flags);
	if(frontbuffer == NULL) {
		printf("SDL Initialization failed. Error: %s\n",SDL_GetError());
		return E_FAIL;
	}
	SDL_ShowCursor(SDL_DISABLE);
	return S_OK;
}

void UpdateFrame(void)
{
	int mixed_mode = (VMODE >> 8) & 0x1;

	if ( SDL_MUSTLOCK(frontbuffer) ) {
        if ( SDL_LockSurface(frontbuffer) < 0 ) {
            fprintf(stderr, "Can't lock screen: %s\n", SDL_GetError());
            return;
        }
    }

	DWORD* pt = (DWORD*)frontbuffer->pixels;
	DWORD pitch = frontbuffer->pitch/4;

	int index=0;
	int pixel_width = ((VMODE >> 9) & 0x7)+1;
	int pix_size = pixel_width >> 1;
	switch(pixel_expansion)
	{
		case 0:default:
			if(!mixed_mode) {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH);
				for(int j=12;j<SCREEN_HEIGHT+12;j++) {
					int si = (j)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH;i++) {
						WORD c = screen[si+i];
						pt[index++] = colortable[c];
					}
					index += line_pitch;
				}
			} else {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH);
				for(int j=12;j<SCREEN_HEIGHT+12;j++) {
					int si = (j)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH;i++) {
						WORD c = screen[si+i];
						DWORD pix = (c & 0x1) ? colortable_d[c] : colortable_c[c];
						pt[index++] = pix;
					}
					index += line_pitch;
				}
			}
			break;
		case 1:
			if(!mixed_mode) {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH * 2);
				for(int j=12;j<SCREEN_HEIGHT*2+12;j++) {
					int si = (j>>1)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						WORD c = screen[si+(i>>1)];
						pt[index++] = colortable[c];
					}
					index += line_pitch;
				}
			} else {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH * 2);
				for(int j=12;j<SCREEN_HEIGHT*2+12;j++) {
					int si = (j>>1)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						WORD c = screen[si+(i>>1)];
						DWORD pix = (c & 0x1) ? colortable_d[c] : colortable_c[c];
						pt[index++] = pix;
					}
					index += line_pitch;
				}
			}
			break;
		case 2:
			if(!mixed_mode) {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH * 2);
				for(int j=12;j<SCREEN_HEIGHT*2+12;j+=2) {
					int si = (j>>1)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						WORD c = screen[si+(i>>1)];
						pt[index++] = colortable[c];
					}
					index += line_pitch;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						pt[index++] = 0;
					}
					index += line_pitch;
				}
			} else {
				DWORD line_pitch = (pitch - screen_width) + (screen_width - SCREEN_WIDTH * 2);
				for(int j=12;j<SCREEN_HEIGHT*2+12;j+=2) {
					int si = (j>>1)*SCREEN_WIDTH;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						WORD c = screen[si+(i>>1)];
						DWORD pix = (c & 0x1) ? colortable_d[c] : colortable_c[c];
						pt[index++] = pix;
					}
					index += line_pitch;
					for(int i=0;i<SCREEN_WIDTH*2;i++) {
						pt[index++] = 0;
					}
					index += line_pitch;
				}
			}
			break;
	}

    if ( SDL_MUSTLOCK(frontbuffer) ) {
        SDL_UnlockSurface(frontbuffer);
    }
    SDL_UpdateRect(frontbuffer, 0, 0, screen_width, screen_height);
}