#include "stdafx.h"
#include "zlib.h"
#include "main.h"
#include "turbo68k.h"
#include "gpu.h"
#include "dsp.h"
#include "regs.h"
#include <stdio.h>

const WORD pts_version = 0x11;
extern DSPSTATE dspstate;
extern GPUSTATE gpustate;
extern M68K_INTERRUPTS m68k_ints;
extern TIMERS timers;

extern BYTE* MEM;
extern DWORD reset_pc;
extern DWORD reset_sp;
extern char rom_filename[256];

long LoadRom(const char* filename,LPBYTE buffer)
{
	int b1,b2;
	FILE* file = fopen(filename,"rb");
	if(file == NULL)
		return E_FAIL;
	fseek(file,0,SEEK_END);
	int length = ftell(file);
	fseek(file,0,SEEK_SET);
	for(int i=0;i<length;i++) {
		b1 = fgetc(file);
		buffer[i^1] = b1;
	}
	return S_OK;
}

long LoadRomOffset(const char* filename,LPBYTE buffer,DWORD offset)
{
	int b1,b2;
	FILE* file = fopen(filename,"rb");
	if(file == NULL)
		return E_FAIL;
	fseek(file,offset,SEEK_SET);
	do {
		b1 = getc(file);
		b2 = getc(file);
		if(b2 != EOF)
			*buffer++ = b2;
		if(b1 != EOF)
			*buffer++ = b1;
	} while(b2 != EOF && b1 != EOF);
	return S_OK;
}
