#include "stdafx.h"
#include "mem.h"
#include "dsp.h"
#include "regs.h"
#include "gpu.h"
#include <stdio.h>

extern BYTE* MEM;

extern TIMERS timers;

DSPSTATE dspstate;

#define CLEAR_FLAG(x) mov [x],0x00
#define SET_FLAG(x) mov [x],0x01

extern int dsp_speed_hack;

BYTE* mirror_table = NULL;
//BYTE jump_condition_dsp[32][256];
BYTE jump_condition_dsp[32][8];

void dsp_init(void)
{
	memset(&dspstate,0,sizeof(DSPSTATE));
	dspstate.reg = dspstate.r0;
	dspstate.alt = dspstate.r1;
	for(int i=0;i<6;i++) {
		dspstate.irq_active[i] = 0;
		dspstate.irq_enable[i] = 0;
	}
	if(mirror_table != NULL) {
		delete [] mirror_table;
	}
	memset(dspstate.interrupt_stack,0,sizeof(DWORD)*8);
	dspstate.i_pointer = -1;
	mirror_table = new BYTE[256];
	for(i=0;i<0x100;i++) {
		int b[8];
		b[0] = (i & 0x1) << 7;
		b[1] = (i & 0x2) << 5;
		b[2] = (i & 0x4) << 3;
		b[3] = (i & 0x8) << 1;
		b[4] = (i & 0x10) >> 1;
		b[5] = (i & 0x20) >> 3;
		b[6] = (i & 0x40) >> 5;
		b[7] = (i & 0x80) >> 7;
		mirror_table[i] = b[0]|b[1]|b[2]|b[3]|b[4]|b[5]|b[6]|b[7];
	}
	/*memset(jump_condition_dsp,0,32*256*sizeof(BYTE));
	for(int j=0;j<32;j++) {
		for(int i=0;i<256;i++) {
			int cc = (((i>>6)&0x1)<<2) | (((i>>7)&0x1)<<1) | (i&0x1);
			if(jump_conditions[j][cc])
				jump_condition_dsp[j][i] = 0x1;
		}
	}*/
	memset(jump_condition_dsp,0,32*8*sizeof(BYTE));
	for(int j=0;j<32;j++) {
		for(int i=0;i<8;i++) {
			BYTE r = 1;
			if(j & 0x1) {
				if(i & 0x1)
					r = 0;
			}
			if(j & 0x2) {
				if(!(i & 0x1))
					r = 0;
			}
			if(j & 0x4) {
				if(i & (0x2 << (j >> 4)))
					r = 0;
			}
			if(j & 0x8) {
				if(!(i & (0x2 << (j >> 4))))
					r = 0;
			}
			jump_condition_dsp[j][i] = r;
		}
	}
}

void dsp_set_regbank(int bank)
{
	if(bank == 0) {
		dspstate.reg = dspstate.r0;
		dspstate.alt = dspstate.r1;
		dspstate.regbank = 0;
	} else {
		dspstate.reg = dspstate.r1;
		dspstate.alt = dspstate.r0;
		dspstate.regbank = 1;
	}
}

int dsp_get_regbank(void)
{
	return dspstate.regbank;
}

/*void dsp_interrupt(int irq)
{
	if(dspstate.imask == 0) {
		if(dspstate.irq_enable[irq] != 0) {
			dsp_set_regbank(0);
			dspstate.reg[31] -= 4;
			WriteMem32(dspstate.reg[31],dspstate.pc);
			dspstate.pc = 0xF1B000 + (irq * 0x10);
			dspstate.irq_active[irq] = 1;
			dspstate.imask = 1;
		}
	}
}*/

void dsp_interrupt(int irq)
{
	if(dspstate.irq_enable[irq] != 0) {
		if(dspstate.i_pointer < 7) {
			dspstate.i_pointer++;
			dspstate.interrupt_stack[dspstate.i_pointer] = irq;
		}
	}
}

void dsp_exec(int cycles)
{
	DWORD offset;
	DWORD delayed_jump = 0;
	DWORD delayed_jump_address = 0;
	DWORD c0,c1,c2,c3,c4;
	DWORD dw;
	int i = 0;
	int last_jump_address = 0;
	int jump_count = 0;
	int max_jump_count = 10;
	dspstate.pc &= 0xFFFFFF;
	while(i < cycles || delayed_jump != 0)
	{
		if( dspstate.active == 0)
			return;
		
		if(dspstate.i_pointer >= 0 && delayed_jump == 0) {
			if(dspstate.imask == 0) {
				int irq = dspstate.interrupt_stack[dspstate.i_pointer];
				dsp_set_regbank(0);
				dspstate.reg[31] -= 4;
				WriteMem32(dspstate.reg[31],dspstate.pc-2);
				dspstate.pc = 0xF1B000 + (irq * 0x10);
				dspstate.irq_active[irq] = 1;
				dspstate.imask = 1;
				dspstate.i_pointer--;
			}
		}
		WORD fetch = *(WORD*)(&MEM[dspstate.pc & 0xFFFFFE]);
		DWORD opcode = (fetch >> 10) & 0x3F;
		DWORD rs = (fetch >> 5) & 0x1F;
		DWORD rd = fetch & 0x1F;

		switch(opcode) {
		case 22:  // ABS
			{
				int d = dspstate.reg[rd];
				if(d & 0x80000000) {
					d = abs(d);
					dspstate.c = 1;
				} else {
					dspstate.c = 0;
				}
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = 0;
			}
			break;
		case 0:   // ADD
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				INT64 r = s + d;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 1:   // ADDC
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				int c = dspstate.c;
				INT64 r = s + d + c;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
		    break;
		case 2:   // ADDQ
			{
				int s = qtable[rs];
				int d = dspstate.reg[rd];
				INT64 r = s + d;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
		    break;
		case 63:  // ADDQMOD
			{
				int s = qtable[rs];
				int d = dspstate.reg[rd];
				INT64 r = s + d;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r & dspstate.mod;
				dspstate.z = r == 0 ? 1 : 0;
				dspstate.n = r & 0x80000000 ? 1 : 0;
			}
			break;
		case 3:   // ADDQT
			{
				dspstate.reg[rd] += qtable[rs];
			}
			break;
		case 9:   // AND
			{
				dspstate.reg[rd] &= dspstate.reg[rs];
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 15:  // BLCR
			{
				dspstate.reg[rd] &= ~(1 << rs);
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
		    break;
		case 14:  // BSET
			{
				dspstate.reg[rd] |= 1 << rs;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 13:  // BTST
			{
				dspstate.z = dspstate.reg[rd] & (1 << rs) ? 0 : 1;
			}
		    break;
		case 30:  // CMP
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				dspstate.c = (unsigned int)d < (unsigned int)s;
				d -= s;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 31:  // CMPQ
			{
				int s = sqtable[rs];
				int d = dspstate.reg[rd];
				dspstate.c = (unsigned int)d < (unsigned int)s;
				d -= s;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 21:  // DIV
			{
				if(dspstate.reg[rs] != 0) {
					if(dspstate.divide == 0) {
						DWORD q = dspstate.reg[rd];
						DWORD d = dspstate.reg[rs];
						DWORD r = q / d;
						DWORD r2 = q % d;
						dspstate.reg[rd] = r;
						dspstate.remain = r2;
					} else {
						UINT64 q = (UINT64)(dspstate.reg[rd])<<16;
						UINT64 d = (UINT64)(dspstate.reg[rs]);
						DWORD r = (UINT64)(q / d);
						DWORD r2 = (UINT64)(q % d);
						dspstate.reg[rd] = r;
						dspstate.remain = r2;
					}
				}
			}
			break;
		case 20:  // IMACN   
			{
				short s = dspstate.reg[rs];
				short d = dspstate.reg[rd];
				int r = s * d;
				dspstate.acc += r;
			}
			break;
		case 17:  // IMULT
			{
				short s = dspstate.reg[rs];
				short d = dspstate.reg[rd];
				int r = s * d;
				dspstate.reg[rd] = r;
				dspstate.z = r == 0 ? 1 : 0;
				dspstate.n = r & 0x80000000 ? 1 : 0;
			}
			break;
		case 18:  // IMULTN
			{
				short s = dspstate.reg[rs];
				short d = dspstate.reg[rd];
				int r = s * d;
				dspstate.acc = r;
				dspstate.z = r == 0 ? 1 : 0;
				dspstate.n = r & 0x80000000 ? 1 : 0;
			}
			break;
        case 53:  // JR;
			dw = (dspstate.z & 0x1) | ((dspstate.n & 0x1) << 2) | ((dspstate.c & 0x1) << 1);
			if(jump_condition_dsp[rd][dw]) {
				signed int offset = rs & 0x10 ? (0xFFFFFFF0 | (rs & 0xF)) : (rs & 0xF);
				delayed_jump_address = dspstate.pc + 2 + (offset * 2);
				delayed_jump = 1;
				if(dsp_speed_hack) {
					if(delayed_jump_address == last_jump_address) {
						jump_count++;
					}
					if(jump_count > max_jump_count)
						return;
					last_jump_address = delayed_jump_address;
				}
			}
			break;
		case 52:  // JUMP
			dw = (dspstate.z & 0x1) | ((dspstate.n & 0x1) << 2) | ((dspstate.c & 0x1) << 1);
			if(jump_condition_dsp[rd][dw]) {
				delayed_jump_address = dspstate.reg[rs] & 0xFFFFFE;
				delayed_jump = 1;
				if(dsp_speed_hack) {
					if(delayed_jump_address == last_jump_address) {
						jump_count++;
					}
					if(jump_count > max_jump_count)
						return;
					last_jump_address = delayed_jump_address;
				}
			}
			break;
		case 41:  // LOAD
			{
				DWORD address = dspstate.reg[rs];
				dspstate.reg[rd] = ReadMem32(address);
			}
			break;
		case 43:  // LOAD (R14+m)
			{
				DWORD address = dspstate.reg[14] + (qtable[rs] << 2);
				dspstate.reg[rd] = ReadMem32(address);
			}
			break;
		case 44:  // LOAD (R15+m)
			{
				DWORD address = dspstate.reg[15] + (qtable[rs] << 2);
				dspstate.reg[rd] = ReadMem32(address);
			}
			break; 
		case 58:  // LOAD (R14+Rm)
			{
				DWORD address = dspstate.reg[14] + dspstate.reg[rs];
				dspstate.reg[rd] = ReadMem32(address);
			}
			break;
		case 59:  // LOAD (R15+Rm)
			{
				DWORD address = dspstate.reg[15] + dspstate.reg[rs];
				dspstate.reg[rd] = ReadMem32(address);
			}
			break;
		case 39:  // LOADB
			if(dspstate.reg[rs] >= 0xF1B000 && dspstate.reg[rs] < 0xF1D000) {
				dspstate.reg[rd] = ReadMem32(dspstate.reg[rs]);
			} else {
				dspstate.reg[rd] = ReadMem8(dspstate.reg[rs]);
			}
			break;
		case 40:  // LOADW
			if(dspstate.reg[rs] >= 0xF1B000 && dspstate.reg[rs] < 0xF1D000) {
				dspstate.reg[rd] = ReadMem32(dspstate.reg[rs]);
			} else {
				dspstate.reg[rd] = ReadMem16(dspstate.reg[rs]);
			}
			break;
		case 48:  // MIRROR
			{
				int dd = dspstate.reg[rd];
				int b[4];
				b[0] = mirror_table[dd & 0xFF] << 24;
				b[1] = mirror_table[(dd>>8) & 0xFF] << 16;
				b[2] = mirror_table[(dd>>16) & 0xFF] << 8;
				b[3] = mirror_table[(dd>>24) & 0xFF];
				dspstate.reg[rd] = b[0] | b[1] | b[2] | b[3];
				dspstate.z = dspstate.reg[rd] == 0;
				dspstate.n = dspstate.reg[rd] < 0;
			}
			break;
		case 34:  // MOVE
			{
				dspstate.reg[rd] = dspstate.reg[rs];
			}
			break;
		case 51:  // MOVE PC,Rn
			{
				dspstate.reg[rd] = dspstate.pc;
			}
			break;
		case 37:  // MOVEFA
			{
				dspstate.reg[rd] = dspstate.alt[rs];
			}
			break;
		case 38:  // MOVEI
			{
				dspstate.reg[rd] = *(DWORD*)(&MEM[dspstate.pc+2]);
				dspstate.pc += 4;
			}
			break;
        case 35:  // MOVEQ
			{
				dspstate.reg[rd] = rs;
			}
			break;
		case 36:  // MOVETA
			{
				dspstate.alt[rd] = dspstate.reg[rs];
			}
			break;
		case 55:  // MTOI
			{
				int d = dspstate.reg[rd] & 0x7FFFFF;
				if(dspstate.reg[rd] & 0x80000000) {
					d |= 0xFF800000;
				}
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 16:  // MULT
			{
				unsigned short s = dspstate.reg[rs];
				unsigned short d = dspstate.reg[rd];
				int r = s * d;
				dspstate.reg[rd] = r;
				dspstate.z = r == 0 ? 1 : 0;
				dspstate.n = r & 0x80000000 ? 1 : 0;
			}
			break;
		case 54:  // MMULT
			{
				int size = dspstate.matrix_size & 0xF;
				int address = dspstate.matrix_address;
				int add;
				if(dspstate.matrix_size & 0x10)
					add = size * 4;
				else
					add = 4;
				int result = 0;
				for(int i=0; i<size; i++) {
					short m,r;
					m = ReadMem16(address+2);
					if(i & 0x1)
						r = dspstate.alt[rs+(i>>1)] >> 16;
					else
						r = (dspstate.alt[rs+(i>>1)] & 0xFFFF);
					//result += (int)(r * m);
					int mult = r*m;
					__asm {
						mov eax,[result]
						mov edx,[mult]
						add eax,edx
						setc [dspstate.c]
						mov [result],eax
					}

					address += add;
				}
				dspstate.reg[rd] = result;
				dspstate.n = (result < 0) ? 1 : 0;
				dspstate.z = (result == 0) ? 1 : 0;
			}
			break;
		case 8:   // NEG
			{
				int s = 0;
				int d = dspstate.reg[rd];
				dspstate.c = d - s < d;
				d = s - d;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 57:  // NOP
			break;
		case 56:  // NORMI
			{
				/*unsigned int d = gpustate.reg[rd];
				int r = 0;
				while ((d & 0xffc00000) == 0)
				{
					d <<= 1;
					r--;
				}
				while ((d & 0xff800000) != 0)
				{
					d >>= 1;
					r++;
				}
				gpustate.reg[rd] = r;
				gpustate.z = r == 0 ? 1 : 0;
				gpustate.n = r & 0x80000000 ? 1 : 0;*/
				dspstate.reg[rd] = 0;
			}
			break;
		case 12:  // NOT
			{
				int d = dspstate.reg[rd];
				d ^= 0xFFFFFFFF;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 10:  // OR
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				d |= s;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 19:  // RESMAC
			{
				dspstate.reg[rd] = dspstate.acc;
			}
			break;
		case 28:  // ROR
			{
				unsigned int d = dspstate.reg[rd];
				int shift = dspstate.reg[rs];
				dspstate.c = d & 0x80000000 ? 1 : 0;
				d = _rotr(d,shift);
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 29:  // RORQ
			{
				unsigned int d = dspstate.reg[rd];
				int shift = qtable[rs];
				dspstate.c = d & 0x80000000 ? 1 : 0;
				d = _rotr(d,shift);
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 33:  // SAT16S
			{
				int dd = dspstate.reg[rd];
				if(dd < -32768) {
					dd = -32768;
				} else if(dd > 32767) {
					dd = 32767;
				}
				dspstate.reg[rd] = dd;
				dspstate.z = dd == 0;
				dspstate.n = 0;
			}
			break;
		case 42:  // SAT32S
			{
				INT64 dd = dspstate.reg[rd] | dspstate.acc & 0xFFFFFFFF00000000;
				if(dd < -2147483648) {
					dd = -2147483648;
				} else if(dd > 2147483647) {
					dd = 2147483647;
				}
				dspstate.reg[rd] = dd & 0xFFFFFFFF;
				dspstate.z = dd == 0;
				dspstate.n = dd < 0;
			}
			break;
		case 23:  // SH
			{
				int shift = dspstate.reg[rs];
				if(shift & 0x80000000) {
					dspstate.c = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
					UINT32 d = dspstate.reg[rd];
					d <<= 0-shift;
					dspstate.reg[rd] = d;
					dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
					dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
				} else {
					dspstate.c = dspstate.reg[rd] & 0x1 ? 1 : 0;
					UINT32 d = dspstate.reg[rd];
					d >>= shift;
					dspstate.reg[rd] = d;
					dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
					dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
				}
			}
			break;
		case 26:  // SHA
			{
				int shift = dspstate.reg[rs];
				if(shift & 0x80000000) {
					dspstate.c = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
					INT32 d = dspstate.reg[rd];
					d <<= 0-shift;
					dspstate.reg[rd] = d;
					dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
					dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
				} else {
					dspstate.c = dspstate.reg[rd] & 0x1 ? 1 : 0;
					INT32 d = dspstate.reg[rd];
					d >>= shift;
					dspstate.reg[rd] = d;
					dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
					dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
				}
			}
			break;
		case 27:  // SHARQ
			{
				INT32 d = dspstate.reg[rd];
				int shift = qtable[rs];
				dspstate.c = d & 0x1 ? 1 : 0;
				d >>= shift;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 24:  // SHLQ
			{
				UINT32 d = dspstate.reg[rd];
				int shift = 32 - rs;
				dspstate.c = d & 0x80000000 ? 1 : 0;
				d <<= shift;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
        case 25:  // SHRQ
			{
				UINT32 d = dspstate.reg[rd];
				int shift = qtable[rs];
				dspstate.c = d & 0x1 ? 1 : 0;
				d >>= shift;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		case 47:  // STORE
			{
				DWORD address = dspstate.reg[rs];
				WriteMem32(address,dspstate.reg[rd]);
			}
			break;
		case 49:  // STORE (R14+m)
			{
				DWORD address = dspstate.reg[14] + (qtable[rs] << 2);
				WriteMem32(address,dspstate.reg[rd]);
			}
			break;
		case 50:  // STORE (R15+m)
			{
				DWORD address = dspstate.reg[15] + (qtable[rs] << 2);
				WriteMem32(address,dspstate.reg[rd]);
			}
			break;
		case 60:  // STORE (R14+Rm)
			{
				DWORD address = dspstate.reg[14] + dspstate.reg[rs];
				WriteMem32(address,dspstate.reg[rd]);
			}
			break;
		case 61:  // STORE (R15+Rm)
			{
				DWORD address = dspstate.reg[15] + dspstate.reg[rs];
				WriteMem32(address,dspstate.reg[rd]);
			}
			break;
		case 45:  // STOREB
			if(dspstate.reg[rs]>0xF1B000 && dspstate.reg[rs]<0xF1D000) {
				WriteMem32(dspstate.reg[rs],dspstate.reg[rd]);
			} else {
				WriteMem8(dspstate.reg[rs],(BYTE)dspstate.reg[rd]);
			}
			break;
		case 46:  // STOREW
			if(dspstate.reg[rs]>0xF1B000 && dspstate.reg[rs]<0xF1D000) {
				WriteMem32(dspstate.reg[rs],dspstate.reg[rd]);
			} else {
				WriteMem16(dspstate.reg[rs],(WORD)dspstate.reg[rd]);
			}
			break;
		case 4:   // SUB
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				INT64 r = d - s;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 5:   // SUBC
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				int c = dspstate.c;
				INT64 r = d - s - c;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 6:   // SUBQ
			{
				int s = qtable[rs];
				int d = dspstate.reg[rd];
				INT64 r = d - s;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r;
				dspstate.z = dspstate.reg[rd] == 0 ? 1 : 0;
				dspstate.n = dspstate.reg[rd] & 0x80000000 ? 1 : 0;
			}
			break;
		case 32:  // SUBQMOD
			{
				int s = qtable[rs];
				int d = dspstate.reg[rd];
				INT64 r = d - s;
				dspstate.c = r & 0x100000000 ? 1 : 0;
				dspstate.reg[rd] = r & dspstate.mod;
				dspstate.z = r == 0 ? 1 : 0;
				dspstate.n = r & 0x80000000 ? 1 : 0;
			}
		case 7:   // SUBQT
			{
				dspstate.reg[rd] -= qtable[rs];
			}
			break;
		case 11:  // XOR
			{
				int s = dspstate.reg[rs];
				int d = dspstate.reg[rd];
				d ^= s;
				dspstate.reg[rd] = d;
				dspstate.z = d == 0 ? 1 : 0;
				dspstate.n = d & 0x80000000 ? 1 : 0;
			}
			break;
		default:
			return;
		}
		dspstate.pc += 2;
		if(delayed_jump > 1) {
			dspstate.pc = delayed_jump_address;
			delayed_jump = 0;
		}
		if(delayed_jump == 1) {
			delayed_jump++;
		}
		i += dsp_opcode_times[opcode];
	}
}