/*******************************************

   Project Tempest v0.5 SDL
   Copyright (C) 2002 - 2003 Ville Linde

*******************************************/

#include "stdafx.h"
#include "pt_sdl.h"
//#include <commctrl.h>
#include "gfx.h"
#include "input.h"
#include "sound.h"
#include "file.h"
#include "main.h"
#include <stdio.h>

extern BYTE* MEM;

DWORD start_pc = 0x802000;
DWORD rom_start = 0x800000;
BOOL disable_dsp = TRUE;
BOOL lock_framerate = TRUE;
BOOL joypad_enable[2];
BOOL enable_sound = FALSE;
int blitter_version = 0;
BOOL dsp_speed_hack = FALSE;
BOOL fullscreen = TRUE;
BOOL show_fps = FALSE;
int pixel_expansion = 0;
int soundbuffer_position = 0;

extern JOYPAD joypad[2];

int res_x = 320;
int res_y = 240;

void parse_cmd_args(int argc, char* argv[])
{
	for(int i=2; i < argc; i++) {
		if(stricmp(argv[i],"-bnew") == 0) {
			blitter_version = 1;
		} else if(stricmp(argv[i],"-dsp") == 0) {
			disable_dsp = FALSE;
		} else if(stricmp(argv[i],"-w") == 0) {
			fullscreen = FALSE;
		} else if(stricmp(argv[i],"-noframelimit") == 0) {
			lock_framerate = FALSE;
		} else if(stricmp(argv[i],"-start") == 0) {
			sscanf(argv[i+1],"%X",&start_pc);
			rom_start = start_pc;
			i++;
		} else if(stricmp(argv[i],"-sound") == 0) {
			enable_sound = TRUE;
			disable_dsp = FALSE;
		} else if(stricmp(argv[i],"-showfps") == 0) {
			show_fps = TRUE;
		} else if(stricmp(argv[i],"-double") == 0) {
			pixel_expansion = 1;
		} else if(stricmp(argv[i],"-scanline") == 0) {
			pixel_expansion = 2;
		} else if(stricmp(argv[i],"-400x300") == 0) {
			res_x = 400;
			res_y = 300;
		} else if(stricmp(argv[i],"-640x480") == 0) {
			res_x = 640;
			res_y = 480;
		} else if(stricmp(argv[i],"-800x600") == 0) {
			res_x = 800;
			res_y = 600;
		} else if(stricmp(argv[i],"-1024x768") == 0) {
			res_x = 1024;
			res_y = 768;
		} else {
			printf("Unknown command line argument: %s\n",argv[i]);
			exit(1);
		}
	}
}

#ifndef XBOX_PLATFORM

void writexbox( char *msg) { }

int main(int argc, char* argv[])
#else

int tempest_main( char *filename, int dosound)
#endif
{
#ifndef XBOX_PLATFORM
	if(argc < 2) {
		printf("Usage:\n");
		printf("PT_SDL.EXE rom_filename\n");
		return 1;
	}

	parse_cmd_args(argc,argv);
	if(SDL_Init(SDL_INIT_VIDEO) < 0) {
		printf("SDL initialization failed.");
		exit(1);
	}
#else

	if ( dosound )
	{
		enable_sound = TRUE;
		disable_dsp = FALSE;
	}

	res_x = 320;
	res_y = 240;

#endif

	writexbox("main\r\n") ;
	if( FAILED( InitEmu() ) ) {
		writexbox("Emulator initialization failed.");
		return 0;
	}
	writexbox("main\r\n") ;
	
#ifndef XBOX_PLATFORM
	if( FAILED( LoadRom(argv[1],&MEM[rom_start]) ) ) {
		printf("Couldn't load file %s\n",argv[1]);
#else
	if( FAILED( LoadRom(filename,&MEM[rom_start]) ) ) {
#endif
		return 0;
	}

	writexbox("main\r\n") ;
	if( FAILED( InitSDL(res_x,res_y,32,fullscreen) ) ) {
		return 0;
	}

	writexbox("main\r\n") ;
#ifndef XBOX_PLATFORM
	SDL_WM_SetCaption("Project Tempest",NULL);
#endif

	writexbox("reset emu\r\n") ;
	ResetEmu(start_pc,0x1FFFFF);
//	for(;;) {
		MainLoop();
	//}
	EndEmu();

#ifndef XBOX_PLATFORM
	SDL_Quit();
#endif

	return 0;
}