#include "stdafx.h"
#include "iomem.h"

extern BYTE* MEM;

extern FILE* logfile;

DWORD GetRealPointer(DWORD address)
{
	address &= 0xFFFFFF;
	if(address >= 0xF0B000 && address<0xF0C000) {
		return (DWORD)&MEM[0xF03000+(address & 0xFFF)];
	} else {
		return (DWORD)&MEM[address];
	}
}

DWORD ReadMem32(DWORD address)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		return dsp_read32(address);
	} else if(address >= 0xF00000) {
		return gpu_read32(address);
	} else {
		return _rotl(*(DWORD*)(&MEM[address]),16);
	}
}
WORD ReadMem16(DWORD address)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		return dsp_read16(address);
	} else if(address >= 0xF00000) {
		return gpu_read16(address);
	} else {
		return *(WORD*)&MEM[address];
	}
}
BYTE ReadMem8(DWORD address)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		return dsp_read8(address);
	} else if(address >= 0xF00000) {
		return gpu_read8(address);
	} else {
		return *(BYTE*)&MEM[address^1];
	}
}
void WriteMem32(DWORD address,DWORD value)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		dsp_write32(address,value);
	} else if(address >= 0xF00000) {
		gpu_write32(address,value);
	} else {
		*(DWORD*)&MEM[address] = _rotl(value,16);
	}
}
void WriteMem16(DWORD address,DWORD value)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		dsp_write16(address,value);
	} else if(address >= 0xF00000) {
		gpu_write16(address,value);
	} else {
		*(WORD*)&MEM[address] = (WORD)value;
	}
}
void WriteMem8(DWORD address,DWORD value)
{
	address &= 0xFFFFFF;
	if(address >= 0xF10000) {
		dsp_write8(address,value);
	} else if(address >= 0xF00000) {
		gpu_write8(address,value);
	} else {
		*(BYTE*)&MEM[address^1] = (BYTE)value;
	}
}