#include "stdafx.h"

long MainLoop(void);
long InitEmu(void);
void EndEmu(void);
long ResetEmu(DWORD, DWORD);
long LoadState(FILE*,HWND);
long SaveState(FILE*,HWND);

#define SAVESTATE_OK					0
#define SAVESTATE_ERROR_COMPRESS_RAM	1
#define SAVESTATE_ERROR_COMPRESS_GPURAM	2
#define SAVESTATE_ERROR_COMPRESS_DSPRAM 3

const char savestate_errors[4][50] =
{"",
 "Save State Error: RAM compress error",
 "Save State Error: GPU RAM compress error",
 "Save State Error: DSP RAM compress error"};

#define LOADSTATE_OK					0
#define LOADSTATE_ERROR_PTS_ID			1
#define LOADSTATE_ERROR_RAM_ID			2
#define LOADSTATE_ERROR_VERSION			3
#define LOADSTATE_ERROR_GPURAM_ID		4
#define LOADSTATE_ERROR_DSPRAM_ID		5
#define LOADSTATE_ERROR_GPUSTATE_ID		6
#define LOADSTATE_ERROR_DSPSTATE_ID		7
#define LOADSTATE_ERROR_ROM_ID			8
#define LOADSTATE_ERROR_M68K_ID			9
#define LOADSTATE_ERROR_M68K_INTS_ID	10
#define LOADSTATE_ERROR_TIMERS_ID		11
#define LOADSTATE_ERROR_COMPRESS_RAM	12
#define LOADSTATE_ERROR_COMPRESS_GPURAM	13
#define LOADSTATE_ERROR_COMPRESS_DSPRAM	14

const char loadstate_errors[15][50] =
{"",
 "Load State Error: PTS ID not found",
 "Load State Error: RAM ID not found",
 "Load State Error: Invalid Version",
 "Load State Error: GPU RAM ID not found",
 "Load State Error: DSP RAM ID not found",
 "Load State Error: GPUSTATE ID not found",
 "Load State Error: DSPSTATE ID not found",
 "Load State Error: ROM ID not found",
 "Load State Error: M68K ID not found",
 "Load State Error: M68KINTS ID not found",
 "Load State Error: TIMERS ID not found",
 "Load State Error: RAM uncompress error",
 "Load State Error: GPU RAM uncompress error",
 "Load State Error: DSP RAM uncompress error"};

const char fps_text[22*9] =
{ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,
  1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,1,0,0,
  1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,
  1,1,1,1,0,0,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,
  1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
  1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,
  1,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

const char fps_numbers[6*9*10] = 
{ 0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,1,1,0,
  1,0,1,0,1,0,
  1,1,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,1,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  1,1,1,1,1,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,1,1,0,0,
  0,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  1,1,1,1,1,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  1,1,1,1,1,0,
  1,0,0,0,0,0,
  1,0,0,0,0,0,
  1,1,1,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  1,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,0,0,0,
  1,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  1,1,1,1,1,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0,

  0,0,0,0,0,0,
  0,1,1,1,0,0,
  1,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,1,0,
  0,0,0,0,1,0,
  1,0,0,0,1,0,
  0,1,1,1,0,0,
  0,0,0,0,0,0};