#include "stdafx.h"
#include "pt_sdl.h"
#include "file.h"
#include "regs.h"
#include "mem.h"
#include "iomem.h"
#include "op.h"
#include "gpu.h"
#include "dsp.h"
#include "sound.h"
#include "gfx.h"
#include "input.h"
#include "main.h"
#include <math.h>

#define DWORDBIG(x) ((x>>16)&0xFFFF)|(x<<16)

extern GPUSTATE gpustate;
extern DSPSTATE dspstate;
extern BOOL disable_dsp;
extern BOOL lock_framerate;

extern BOOL enable_sound;
extern BOOL show_fps;

M68K_INTERRUPTS m68k_ints;
JERRY_INTERRUPTS jerry_ints;
TIMERS timers;

DWORD m68k_pc = 0;

DWORD sample_rate;

WORD* screen;

BYTE* MEM;

WORD* EEPROM;

LONGLONG tFrequency, tStart, tEnd;
LONGLONG tLimitEnd,tLimitStart;

struct TURBO68K_FETCHREGION cpu_fetch[32];
struct TURBO68K_DATAREGION cpu_read8[32];
struct TURBO68K_DATAREGION cpu_read16[32];
struct TURBO68K_DATAREGION cpu_read32[32];
struct TURBO68K_DATAREGION cpu_write8[32];
struct TURBO68K_DATAREGION cpu_write16[32];
struct TURBO68K_DATAREGION cpu_write32[32];

void SetFetchRegion(TURBO68K_FETCHREGION* region, DWORD base, DWORD limit, DWORD ptr)
{
	region->base = base;
	region->limit = limit;
	region->ptr = ptr;
}

void SetDataRegion(TURBO68K_DATAREGION* region, DWORD base, DWORD limit, DWORD ptr, void* handler)
{
	region->base = base;
	region->limit = limit;
	region->ptr = ptr;
	region->handler = handler;
}

void EndEmu(void)
{
	delete [] screen;
	delete [] MEM;
}

long InitEmu(void)
{
	InitOp();
	screen = new WORD[SCREEN_WIDTH*SCREEN_HEIGHT];
	MEM = new BYTE[0x1000000];
	EEPROM = new WORD[0x40];

	memset(MEM,0,0x1000000);
	memset(screen,0,SCREEN_WIDTH*SCREEN_HEIGHT*2);

	memset(EEPROM,0x0,0x80);

	QueryPerformanceFrequency((LARGE_INTEGER*)&tFrequency);

	SetFetchRegion(&cpu_fetch[0],0x000000,0xFFFFFF,(DWORD)MEM-0x000000);
	SetFetchRegion(&cpu_fetch[1],-1,-1,TURBO68K_NULL);

	SetDataRegion(&cpu_read8[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_read8[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_read8);
	SetDataRegion(&cpu_read8[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_read8);
	SetDataRegion(&cpu_read8[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	SetDataRegion(&cpu_read16[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_read16[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_read16);
	SetDataRegion(&cpu_read16[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_read16);
	SetDataRegion(&cpu_read16[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	SetDataRegion(&cpu_read32[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_read32[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_read32);
	SetDataRegion(&cpu_read32[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_read32);
	SetDataRegion(&cpu_read32[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	SetDataRegion(&cpu_write8[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_write8[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_write8);
	SetDataRegion(&cpu_write8[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_write8);
	SetDataRegion(&cpu_write8[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	SetDataRegion(&cpu_write16[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_write16[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_write16);
	SetDataRegion(&cpu_write16[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_write16);
	SetDataRegion(&cpu_write16[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	SetDataRegion(&cpu_write32[0],0x000000,0xEFFFFF,(DWORD)&MEM[0],TURBO68K_NULL);
	SetDataRegion(&cpu_write32[1],0xF00000,0xF0FFFF,TURBO68K_NULL, &gpu_write32);
	SetDataRegion(&cpu_write32[2],0xF10000,0xF1FFFF,TURBO68K_NULL, &dsp_write32);
	SetDataRegion(&cpu_write32[3],-1,-1,TURBO68K_NULL,TURBO68K_NULL);

	Turbo68KInit();
	Turbo68KSetFetch(cpu_fetch, TURBO68K_NULL);
	Turbo68KSetReadByte(cpu_read8, TURBO68K_NULL);
	Turbo68KSetReadWord(cpu_read16, TURBO68K_NULL);
	Turbo68KSetReadLong(cpu_read32, TURBO68K_NULL);
	Turbo68KSetWriteByte(cpu_write8, TURBO68K_NULL);
	Turbo68KSetWriteWord(cpu_write16, TURBO68K_NULL);
	Turbo68KSetWriteLong(cpu_write32, TURBO68K_NULL);

	gpu_init();
	dsp_init();

	return S_OK;
}

long ResetEmu(DWORD pc,DWORD sp)
{
	memset(&MEM[0xF00000],0,0x10000);
	memset(&MEM[0xF10000],0,0x10000);
	memset(screen,0,SCREEN_WIDTH*SCREEN_HEIGHT*2);
	memcpy(&MEM[0xF1D000],wave_table,sizeof(char)*4096);
	memset(&m68k_ints,0,sizeof(M68K_INTERRUPTS));
	memset(&timers,0,sizeof(TIMERS));

	DWORD bpc = DWORDBIG(pc);
	DWORD bsp = DWORDBIG(sp);
	memcpy(&MEM[0],&bsp,4);
	memcpy(&MEM[4],&bpc,4);
	if(Turbo68KReset() != TURBO68K_OKAY)
		return E_FAIL;
	gpu_init();
	dsp_init();
	sample_rate = 22050;

	return S_OK;
}

void draw_number(int x,int y,int number,WORD color)
{
	char* numg = (char*)&fps_numbers[number*54];
	int index = 0;
	for(int sy=y; sy<y+9; sy++) {
		int screen_index = sy * SCREEN_WIDTH;
		for(int sx=x; sx<x+6; sx++) {
			if(numg[index++])
				screen[screen_index+sx] = color;
			else
				screen[screen_index+sx] = 0;
		}
	}
}

void draw_fps(int fps)
{
	WORD color;
	if(((VMODE >> 1) & 0x3) == 0) {
		color = 0x88FE;
	} else {
		color = 0xFFFE;
	}
	int index = 0;
	for(int y=16;y<16+9;y++) {
		int screen_index = y * SCREEN_WIDTH;
		for(int x=0;x<22;x++) {
			if(fps_text[index++])
				screen[screen_index+x] = color;
			else
				screen[screen_index+x] = 0;
		}
	}
	if(fps >= 100) {
		int f0 = fps / 100;
		int f1 = fps % 100;
		int f2 = f1 / 10;
		int f3 = f1 % 10;
		draw_number(22,16,f0,color);
		draw_number(28,16,f2,color);
		draw_number(34,16,f3,color);
	} else if(fps >= 10) {
		int f0 = fps / 10;
		int f1 = fps % 10;
		draw_number(22,16,f0,color);
		draw_number(28,16,f1,color);
	} else {
		int f0 = fps % 10;
		draw_number(22,16,f0,color);
	}
}

long MainLoop(void)
{
	UpdateKeys();
	QueryPerformanceCounter((LARGE_INTEGER*)&tLimitEnd);
	double time = (double)(tLimitEnd-tLimitStart)/tFrequency;
	bool frame_limit = true;
	if(lock_framerate) {
		frame_limit = time >= (double)(1.0/60.0);
	}
	if(frame_limit) {
		double fps = 1.0/((double)(tLimitEnd-tLimitStart)/tFrequency);
		QueryPerformanceCounter((LARGE_INTEGER*)&tLimitStart);

		int slices = 525;
		int sound_interrupts = sample_rate / 60;
		
		int pit1_rate = 26591000 / (timers.pit1_prescale + 1) / (timers.pit1_divider + 1);
		int pit1_interrupts = 443184 / pit1_rate;
		
		for(int c=0;c<slices;c++) {
			if((VMODE >> 7) & 0x1) {
				WORD color = BG; 
				DWORD pixels = SCREEN_WIDTH;
				DWORD pt = (DWORD)screen + (c * SCREEN_WIDTH);
				__asm {
					mov ecx,[pixels] 
					shr ecx,1
					mov ax,word ptr [color]
					ror eax,16
					mov ax,word ptr [color]			
					mov edi,[pt]
					rep stosd
				}
			}
			for(int c2=0;c2<10;c2++) {
				Turbo68KRun(221592/slices/10);
				gpu_exec(443184/slices/10);
				if(!enable_sound) {
					if(!disable_dsp)
						dsp_exec(443184/slices/10);
				}
			}
			if(enable_sound) {
				dsp_exec(443184/slices);
				if(sound_interrupts > 0) {
					dsp_interrupt(1);
					dsp_interrupt(2);
					sound_interrupts--;
				}
			}
			VC = (WORD)c & 0x7FF;
			if(timers.pit_active) {
				timers.pit_current_value -= (443184 / 8);
				if(timers.pit_current_value <= 0) {
					if( m68k_ints.timer ) {
						m68k_ints.timer_active = 1;
						Turbo68KInterrupt(2,TURBO68K_AUTOVECTOR);
					}
					if( gpustate.irq_enable[2] ) {
						gpu_interrupt(2);
					}
					timers.pit_current_value = timers.pit_value;
				}
			}
			if(c & 0x1)
				OpExecLine(c);
			if(c == VI) {
				if( m68k_ints.video) {
					m68k_ints.video_active = 1;
					Turbo68KInterrupt(2,TURBO68K_AUTOVECTOR);
				}
			}
		}
		if(show_fps) {
			draw_fps((int)ceil(fps));
		}
		DWORD pc = Turbo68KReadPC();
		m68k_pc = pc;
		UpdateFrame();
	}
	return S_OK;
}