#include "stdafx.h"
#include "input.h"
#include <stdio.h>

LPDIRECTINPUT8			pDI;
LPDIRECTINPUTDEVICE8	pKeyboard;
LPDIRECTINPUTDEVICE8	pMouse;

extern DWORD* screen;
extern BOOL joypad_enable[2];
char key_buffer[256];

int num_joystick = 0;
int current_axis = 0;

JOYSTICK_INFO* joystick_info;

JOYPAD joypad[2];

long GetKeyDown(BYTE key)
{
	return key_buffer[ key ] & 0x80;
}

long GetKeyUp(BYTE key)
{
	return !(key_buffer[ key ] & 0x80);
}

BOOL CheckButtonDown(int key)
{
	return joypad[0].button[key];
}

void UpdateKeys(void)
{
	SDL_Event event;
	while( SDL_PollEvent( &event ) ){
        switch( event.type ){
            /* Look for a keypress */
            case SDL_KEYDOWN:
                /* Check the SDLKey values and move change the coords */
                switch( event.key.keysym.sym ){
					case SDLK_ESCAPE:
                        exit(1);
                        break;
					case SDLK_a:
						joypad[0].button[BUTTON_A] = TRUE;
						break;
					case SDLK_s:
						joypad[0].button[BUTTON_B] = TRUE;
						break;
					case SDLK_d:
						joypad[0].button[BUTTON_C] = TRUE;
						break;
					case SDLK_o:
						joypad[0].button[BUTTON_OPTION] = TRUE;
						break;
					case SDLK_p:
						joypad[0].button[BUTTON_PAUSE] = TRUE;
						break;
					case SDLK_UP:
						joypad[0].button[BUTTON_UP] = TRUE;
						break;
					case SDLK_DOWN:
						joypad[0].button[BUTTON_DOWN] = TRUE;
						break;
					case SDLK_LEFT:
						joypad[0].button[BUTTON_LEFT] = TRUE;
						break;
					case SDLK_RIGHT:
						joypad[0].button[BUTTON_RIGHT] = TRUE;
						break;
					case SDLK_KP0:
						joypad[0].button[BUTTON_0] = TRUE;
						break;
					case SDLK_KP1:
						joypad[0].button[BUTTON_1] = TRUE;
						break;
					case SDLK_KP2:
						joypad[0].button[BUTTON_2] = TRUE;
						break;
					case SDLK_KP3:
						joypad[0].button[BUTTON_3] = TRUE;
						break;
					case SDLK_KP4:
						joypad[0].button[BUTTON_4] = TRUE;
						break;
					case SDLK_KP5:
						joypad[0].button[BUTTON_5] = TRUE;
						break;
					case SDLK_KP6:
						joypad[0].button[BUTTON_6] = TRUE;
						break;
					case SDLK_KP7:
						joypad[0].button[BUTTON_7] = TRUE;
						break;
					case SDLK_KP8:
						joypad[0].button[BUTTON_8] = TRUE;
						break;
					case SDLK_KP9:
						joypad[0].button[BUTTON_9] = TRUE;
						break;
					case SDLK_KP_MULTIPLY:
						joypad[0].button[BUTTON_ASTERISK] = TRUE;
						break;
					case SDLK_KP_DIVIDE:
						joypad[0].button[BUTTON_SHARP] = TRUE;
						break;
                    default:
                        break;
                }
				break;
			case SDL_KEYUP:
                /* Check the SDLKey values and move change the coords */
                switch( event.key.keysym.sym ){
					case SDLK_ESCAPE:
                        exit(1);
                        break;
					case SDLK_a:
						joypad[0].button[BUTTON_A] = FALSE;
						break;
					case SDLK_s:
						joypad[0].button[BUTTON_B] = FALSE;
						break;
					case SDLK_d:
						joypad[0].button[BUTTON_C] = FALSE;
						break;
					case SDLK_o:
						joypad[0].button[BUTTON_OPTION] = FALSE;
						break;
					case SDLK_p:
						joypad[0].button[BUTTON_PAUSE] = FALSE;
						break;
					case SDLK_UP:
						joypad[0].button[BUTTON_UP] = FALSE;
						break;
					case SDLK_DOWN:
						joypad[0].button[BUTTON_DOWN] = FALSE;
						break;
					case SDLK_LEFT:
						joypad[0].button[BUTTON_LEFT] = FALSE;
						break;
					case SDLK_RIGHT:
						joypad[0].button[BUTTON_RIGHT] = FALSE;
						break;
					case SDLK_KP0:
						joypad[0].button[BUTTON_0] = FALSE;
						break;
					case SDLK_KP1:
						joypad[0].button[BUTTON_1] = FALSE;
						break;
					case SDLK_KP2:
						joypad[0].button[BUTTON_2] = FALSE;
						break;
					case SDLK_KP3:
						joypad[0].button[BUTTON_3] = FALSE;
						break;
					case SDLK_KP4:
						joypad[0].button[BUTTON_4] = FALSE;
						break;
					case SDLK_KP5:
						joypad[0].button[BUTTON_5] = FALSE;
						break;
					case SDLK_KP6:
						joypad[0].button[BUTTON_6] = FALSE;
						break;
					case SDLK_KP7:
						joypad[0].button[BUTTON_7] = FALSE;
						break;
					case SDLK_KP8:
						joypad[0].button[BUTTON_8] = FALSE;
						break;
					case SDLK_KP9:
						joypad[0].button[BUTTON_9] = FALSE;
						break;
					case SDLK_KP_MULTIPLY:
						joypad[0].button[BUTTON_ASTERISK] = FALSE;
						break;
					case SDLK_KP_DIVIDE:
						joypad[0].button[BUTTON_SHARP] = FALSE;
						break;
                    default:
                        break;
                }
				break;
            }
        }
}

WORD ReadKeys(WORD sel)
{
	WORD value = 0xFFFF;
	switch(sel&0xF) {
	case 0xE: // 1110
		if(CheckButtonDown(BUTTON_RIGHT)) value &= 0xF7FF;
		if(CheckButtonDown(BUTTON_LEFT)) value &= 0xFBFF;
		if(CheckButtonDown(BUTTON_DOWN)) value &= 0xFDFF;
		if(CheckButtonDown(BUTTON_UP)) value &= 0xFEFF;
		break;
	case 0xD: // 1101
		if(CheckButtonDown(BUTTON_1)) value &= 0xF7FF;
		if(CheckButtonDown(BUTTON_4)) value &= 0xFBFF;		
		if(CheckButtonDown(BUTTON_7)) value &= 0xFDFF;
		if(CheckButtonDown(BUTTON_ASTERISK)) value &= 0xFEFF;
		break;
	case 0xB: // 1011
		if(CheckButtonDown(BUTTON_2)) value &= 0xF7FF;
		if(CheckButtonDown(BUTTON_5)) value &= 0xFBFF;
		if(CheckButtonDown(BUTTON_8)) value &= 0xFDFF;
		if(CheckButtonDown(BUTTON_0)) value &= 0xFEFF;
		break;
	case 0x7: // 0111
		if(CheckButtonDown(BUTTON_3)) value &= 0xF7FF;
		if(CheckButtonDown(BUTTON_6)) value &= 0xFBFF;
		if(CheckButtonDown(BUTTON_9)) value &= 0xFDFF;
		if(CheckButtonDown(BUTTON_SHARP)) value &= 0xFEFF;
		break;
	}
	return value;
}

WORD ReadButtons(WORD sel)
{
	WORD value = 0xFFFF;
	switch(sel&0xF) {
	case 0xE: // 1110
		if(CheckButtonDown(BUTTON_PAUSE)) value &= 0xFFFE;
		if(CheckButtonDown(BUTTON_A)) value &= 0xFFFD;
		break;
	case 0xD: // 1101
		if(CheckButtonDown(BUTTON_B)) value &= 0xFFFD;
		break;
	case 0xB: // 1011
		if(CheckButtonDown(BUTTON_C)) value &= 0xFFFD;
		break;
	case 0x7: // 0111
		if(CheckButtonDown(BUTTON_OPTION)) value &= 0xFFFD;
		break;
	}
	return value;
}