void gpu_exec(int);
void gpu_init(void);
void gpu_interrupt(int);
void gpu_set_regbank(int);
int gpu_get_regbank(void);

typedef struct {
	signed int r0[32];
	signed int r1[32];
	BYTE z;
	BYTE n;
	BYTE c;
	BYTE flags;
	DWORD pc;
	DWORD remain;
	int acc;
	DWORD hidata;
	DWORD matrix_address;
	DWORD matrix_size;
	DWORD irq_enable[6];
	DWORD irq_active[6];
	DWORD active;
	DWORD imask;
	DWORD regbank;
	DWORD bcmd;
	signed int* reg;
	signed int* alt;
	DWORD r;
	DWORD divide;
	DWORD single_step;
	DWORD interrupt_stack[8];
	int i_pointer;
} GPUSTATE;

const bool jump_conditions[32][8] = {
{ true, true, true, true, true, true, true, true },
{ true, true, true, true,false,false,false,false },
{false,false,false,false, true, true, true, true },
{false,false,false,false,false,false,false,false },
{ true,false, true,false, true,false, true,false },
{ true,false, true,false,false,false,false,false },
{false,false,false,false, true,false, true,false },
{false,false,false,false,false,false,false,false },
{false, true,false, true,false, true,false, true },
{false, true,false, true,false,false,false,false },
{false,false,false,false,false, true,false, true },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{ true, true, true, true, true, true, true, true },
{ true, true, true, true,false,false,false,false },
{false,false,false,false, true, true, true, true },
{false,false,false,false,false,false,false,false },
{ true, true,false,false, true, true,false,false },
{ true, true,false,false,false,false,false,false },
{false,false,false,false, true, true,false,false },
{false,false,false,false,false,false,false,false },
{false,false, true, true,false,false, true, true },
{false,false, true, true,false,false,false,false },
{false,false,false,false,false,false, true, true },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false },
{false,false,false,false,false,false,false,false }
};

const LONG qtable[32] = 
{ 32, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
const LONG sqtable[32] = 
{ 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,-16,-15,-14,-13,-12,-11,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1};

const BYTE gpu_opcode_times[64] =
{  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
   3, 3, 1, 3, 1,18, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
   3, 3, 2, 2, 2, 2, 3, 6, 6, 4, 6, 6, 6, 1, 1, 1,
   1, 2, 2, 2, 1, 1,20, 3, 3, 1, 6, 6, 2, 2, 3, 3 };
