////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#include "sound.h"
#include <math.h>
#include "./seal/audio.h"

#define DOORIG

uint8    sound_regs[2][4];
uint32   sound_channel_size[2];
uint32	sound_channel_pos[2];

int noisefreq;
int noisevol;
int fmfreq1;
int fmvol1;
int fmfreq2;
int fmvol2;

uint32 dmaoffset, dmalength, dmafreq, dmacartSpace;

int noisevolvoice;
int dmavolvoice;
int fmvolvoice1;
int fmvolvoice2;


//static int16    *sound_buffers[2];
uint8    audioDma_regs[8];

#define BPS			22050
#define BPSMAX		AUDIO_MAX_FREQUENCY
#define BPSMIN		AUDIO_MIN_FREQUENCY
#define BUFSIZE		(22050)
#define POFF		128
#define PDIV		3
#define PH			POFF+PDIV*8
#define PL			POFF-PDIV*7

#ifdef DOORIG
AUDIOINFO	audio_info;
AUDIOCAPS	audio_caps;
HAC			audio_FmVoice[2];
AUDIOWAVE	audio_FmWave[2];
HAC			audio_NoiseVoice;
AUDIOWAVE   audio_NoiseWave;
HAC			audio_AudioDmaVoice;
AUDIOWAVE   audio_AudioDmaWave;
int sealinit = 0 ;
extern "C" BOOL WINAPI DllEntryPoint(HINSTANCE hinstDLL,DWORD fdwReason, LPVOID lpvReserved) ;
#else
LPDIRECTSOUNDBUFFER audio_FmWave[2];						// Voice buffers
LPDIRECTSOUNDBUFFER audio_NoiseWave=NULL;						// Voice buffers
LPDIRECTSOUNDBUFFER audio_AudioDmaWave=NULL;						// Voice buffers
LPDIRECTSOUND lpds;									// DirectSound handle
#endif


bool		audio_FmVoicePlaying[2];
bool        audio_NoiseVoicePlaying;
bool        audio_AudioDmaVoicePlaying;

bool		audio_FmVoicePlayingOld[2];
bool        audio_NoiseVoicePlayingOld;
bool        audio_AudioDmaVoicePlayingOld;

uint8       RandData[BUFSIZE];
unsigned int audio_mrand(unsigned int Degree);

const long TblChVol[16]={				// n/15 n=0~15
	-10000,-2352,-1750,-1398,-1148,-954,-796,-662,
    -546,-444,-352,-269,-194,-124,-60,0
};

void audio_NoiseVoiceFreq(int freq, int volume)
{
	UCHAR *ptr1, *ptr2;
	unsigned long len1, len2, len;

	noisefreq = freq ;
	noisevol = volume ;

    for(int j=0;j<(BUFSIZE);j++)
		RandData[j] = ((audio_mrand(15)*volume)/127);

#ifdef DOORIG
	memcpy(audio_NoiseWave.lpData,		RandData, audio_NoiseWave.dwLength);
	AWriteAudioData(&audio_NoiseWave,	0, audio_NoiseWave.dwLength);
#else
	if (audio_NoiseWave->Lock(0, BUFSIZE, (void**)&ptr1, &len1, (void**)&ptr2, &len2, DSBLOCK_ENTIREBUFFER) == DS_OK)
	{
		memcpy(ptr1, RandData, BUFSIZE);
		audio_NoiseWave->Unlock(ptr1, len1, ptr2, len2);
	}
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_FmVoicePlay(int channel, bool bPlay)
{
	if (audio_FmVoicePlaying[channel] == bPlay)
		return;

	audio_FmVoicePlaying[channel] = bPlay;

#ifndef DOORIG
	if (bPlay)
		audio_FmWave[channel]->Play( 0, 0, DSBPLAY_LOOPING ) ;
	else
		audio_FmWave[channel]->Stop() ;

#else
	if (bPlay)
		APlayVoice(audio_FmVoice[channel], &audio_FmWave[channel]);
	else
		AStopVoice(audio_FmVoice[channel]);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_FmVoiceFreq(int channel, int freq, int volume)
{
	UCHAR *ptr1, *ptr2;
	unsigned long len1, len2, len;
	int size;
	DWORD          playPos  ;

	if ( channel )
	{
		fmfreq1 = freq ;
		fmvol1 = volume ;
	}
	else
	{
		fmfreq2 = freq ;
		fmvol2 = volume ;
	}

	volume = (127*volume)/15;

	//fprintf(log_get()," volume: %i\n", volume);
	if (freq==0)
	{
		audio_FmVoicePlay(channel, false);
		return;
	}
	size = (BPS/freq);
	
	if (size == 0)
	{
		audio_FmVoicePlay(channel, false);
		return;
	}
#if 1
    for(int j=0;j<(BUFSIZE);j++)
	{
		RandData[j] = (((uint32)(((j%size)<(size>>1))?127:-128))*volume)/127;
		//RandData[j] = (char)(127.0f*sin((((float)j)*((float)freq)*2*3.14159)/((float)BUFSIZE)));
	}
#endif
#if 0
    for(int j=0;j<(BUFSIZE);j++)
	{
		float k = j%size ;
		RandData[j] = (float)volume * sin(k*6.2831853f/(float)size) ;
	}
#endif
#if 0
    for(int j=0;j<(BUFSIZE);j++)
	{
		//RandData[j] = volume ;
		//RandData[j+1] = -128*volume/127 ;
		//j++ ;
		float f = ( sin( ((float)j*6.2831853f*2.0f)/(float)BUFSIZE ) )*(float)volume ;
		//RandData[j] = f ;
		//RandData[j] = (char)(127.0f*sin((((float)j)*((float)freq)*2*3.14159)/((float)BUFSIZE)));
	}
#endif
#ifndef DOORIG
	audio_FmWave[channel]->GetCurrentPosition( &playPos, NULL ) ;

	if (audio_FmWave[channel]->Lock(0, BUFSIZE, (void**)&ptr1, &len1, (void**)&ptr2, &len2, DSBLOCK_ENTIREBUFFER) == DS_OK)
	{
		memcpy(ptr1, RandData, len1);
		if ( ptr2 )
		{
			memcpy( ptr2, RandData+len1, len2 ) ;
		}

		audio_FmWave[channel]->Unlock(ptr1, len1, ptr2, len2);
	}
#else
	//audio_FmWave[channel]->SetFrequency( freq ) ;

	memcpy(audio_FmWave[channel].lpData,		RandData, audio_FmWave[channel].dwLength);
	AWriteAudioData(&audio_FmWave[channel],	0, audio_FmWave[channel].dwLength);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_AudioDmaSetSample(uint32 offset, uint32 length, uint32 freq, uint32 cartSpace)
{
	UCHAR *ptr1, *ptr2;
	unsigned long len1, len2, len;
	float scale = ((float)freq)/((float)BUFSIZE);

	dmaoffset = offset ;
	dmalength = length ;
	dmafreq = freq ;
	dmacartSpace = cartSpace ;

	for (int i = 0; i < BUFSIZE; i++)
	{
		int16 data;

		int offs = ((i>>1)*scale);
		if (offs>= (length>>1))
			data =0;
		else
			data = (cartSpace)?(memorymap_getRomPointer()[offset + offs]):Rd6502(offset + offs);
		
		if (i&0x01)
			data = ((data>>4)-8)*8;
		else
			data = ((data&0x0f)-8)*8;

		RandData[i] = (char)(data);
	}
#ifndef DOORIG
	if (audio_AudioDmaWave->Lock(0, BUFSIZE, (void**)&ptr1, &len1, (void**)&ptr2, &len2, DSBLOCK_ENTIREBUFFER) == DS_OK)
	{
		memcpy(ptr1, RandData, BUFSIZE);
		audio_AudioDmaWave->Unlock(ptr1, len1, ptr2, len2);
	}
#else
	memcpy(audio_AudioDmaWave.lpData, RandData, audio_AudioDmaWave.dwLength);
	AWriteAudioData(&audio_AudioDmaWave,	0, audio_AudioDmaWave.dwLength);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_NoiseVoiceVolume(int volume)
{
	noisevolvoice = volume ;

#ifndef DOORIG
	audio_NoiseWave->SetVolume( TblChVol[volume] + 10000) ;
#else
	ASetVoiceVolume(audio_NoiseVoice, TblChVol[volume]);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_AudioDmaVoiceVolume(int volume)
{
	dmavolvoice = volume ;
#ifndef DOORIG
	audio_AudioDmaWave->SetVolume( TblChVol[volume] + 10000) ;
#else
	ASetVoiceVolume(audio_AudioDmaVoice, TblChVol[volume]);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_NoiseVoicePlay(bool bPlay)
{
	if (audio_NoiseVoicePlaying == bPlay)
		return;

	audio_NoiseVoicePlaying = bPlay;

#ifndef DOORIG
	if (bPlay)
		audio_NoiseWave->Play( 0, 0, DSBPLAY_LOOPING ) ;
	else
		audio_NoiseWave->Stop() ;
#else
	if (bPlay)
		APlayVoice(audio_NoiseVoice, &audio_NoiseWave);
	else
		AStopVoice(audio_NoiseVoice);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_AudioDmaVoicePlay(bool bPlay)
{
	if (audio_AudioDmaVoicePlaying == bPlay)
		return;

	audio_AudioDmaVoicePlaying = bPlay;

#ifndef DOORIG
	if (bPlay)
		audio_AudioDmaWave->Play( 0, 0, DSBPLAY_LOOPING ) ;
	else
		audio_AudioDmaWave->Stop() ;
#else
	if (bPlay)
		APlayVoice(audio_AudioDmaVoice, &audio_AudioDmaWave);
	else
		AStopVoice(audio_AudioDmaVoice);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_FmVoiceVolume(int channel, int volume)
{
	if ( channel )
	{
		fmvolvoice1 = volume ;
	}
	else
	{
		fmvolvoice2 = volume ;
	}

#ifndef DOORIG
	audio_FmWave[channel]->SetVolume( TblChVol[volume] + 10000) ;
#else
	ASetVoiceVolume(audio_FmVoice[channel], TblChVol[volume]);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_turnSound(bool bOn)
{
	if (bOn)
	{
		audio_FmVoicePlay(0, audio_FmVoicePlayingOld[0]);
		audio_FmVoicePlay(1, audio_FmVoicePlayingOld[1]);
		audio_NoiseVoicePlay(audio_NoiseVoicePlayingOld);
		audio_AudioDmaVoicePlay(audio_AudioDmaVoicePlayingOld);
	} 
	else
	{
		audio_FmVoicePlayingOld[0] = audio_FmVoicePlaying[0];
		audio_FmVoicePlayingOld[1] = audio_FmVoicePlaying[1];
		audio_NoiseVoicePlayingOld = audio_NoiseVoicePlaying;
		audio_AudioDmaVoicePlayingOld = audio_AudioDmaVoicePlaying;
		audio_FmVoicePlay(0, false);
		audio_FmVoicePlay(1, false);
		audio_NoiseVoicePlay(false);
		audio_AudioDmaVoicePlay(false);
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
unsigned int audio_mrand(unsigned int Degree)
{
#define BIT(n) (1<<n)
	typedef struct {
		unsigned int N;
    	int InputBit;
    	int Mask;
	} POLYNOMIAL;

	static POLYNOMIAL TblMask[]=
	{
		{ 2,BIT(2) ,BIT(0)|BIT(1)},
		{ 3,BIT(3) ,BIT(0)|BIT(1)},
		{ 4,BIT(4) ,BIT(0)|BIT(1)},
		{ 5,BIT(5) ,BIT(0)|BIT(2)},
		{ 6,BIT(6) ,BIT(0)|BIT(1)},
		{ 7,BIT(7) ,BIT(0)|BIT(1)},
		{ 8,BIT(8) ,BIT(0)|BIT(2)|BIT(3)|BIT(4)},
		{ 9,BIT(9) ,BIT(0)|BIT(4)},
		{10,BIT(10),BIT(0)|BIT(3)},
		{11,BIT(11),BIT(0)|BIT(2)},
		{12,BIT(12),BIT(0)|BIT(1)|BIT(4)|BIT(6)},
		{13,BIT(13),BIT(0)|BIT(1)|BIT(3)|BIT(4)},
		{14,BIT(14),BIT(0)|BIT(1)|BIT(4)|BIT(5)},
		{15,BIT(15),BIT(0)|BIT(1)},
		{NULL,NULL,NULL},
	};

	static POLYNOMIAL *pTbl=TblMask;
	static int ShiftReg=pTbl->InputBit-1;
	int XorReg=0;
	int Masked;

    if(pTbl->N!=Degree)
    {
    	pTbl=TblMask;
		while(pTbl->N)
		{
			if(pTbl->N==Degree)
			{
				break;
			}
        	pTbl++;
		}
		if(!pTbl->N)
		{
			pTbl--;
		}

    	ShiftReg&=pTbl->InputBit-1;
		if(!ShiftReg)
		{
			ShiftReg=pTbl->InputBit-1;
		}
    }

	Masked=ShiftReg&pTbl->Mask;
	while(Masked)
	{
		XorReg^=Masked&0x01;
		Masked>>=1;
	}

	if(XorReg)
	{
		ShiftReg|=pTbl->InputBit;
	}
	else
	{
		ShiftReg&=~pTbl->InputBit;
	}
	ShiftReg>>=1;

	return ShiftReg;
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_createFmVoices()
{
#ifndef DOORIG

	WAVEFORMATEX pcmwf;
	DSBUFFERDESC dsbd;
	DSMIXBINS dsmb;
	UCHAR *ptr1, *ptr2;
	unsigned long len1, len2, len;

	DSMIXBINVOLUMEPAIR dsmbvp[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		
#endif

	for (int i = 0;i<2;i++)
	{
#ifndef DOORIG
		dsmb.dwMixBinCount = 8;
		dsmb.lpMixBinVolumePairs = dsmbvp;

		ZeroMemory(&pcmwf, sizeof(pcmwf));
		pcmwf.wFormatTag = WAVE_FORMAT_PCM;		// wave file
		pcmwf.nChannels=1;						// 1 channel (mono)
		pcmwf.nSamplesPerSec= 22050;			// 22khz
		pcmwf.nBlockAlign=1;					// 1 byte per sample * 1 channel
		pcmwf.nAvgBytesPerSec=pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
		pcmwf.wBitsPerSample=8;					// 8 bit samples
		pcmwf.cbSize=0;							// always zero;

		ZeroMemory(&dsbd, sizeof(dsbd));
		dsbd.dwSize=sizeof(dsbd);
		dsbd.dwFlags=DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY ; 
		dsbd.dwBufferBytes=BUFSIZE;	
		dsbd.lpwfxFormat=&pcmwf;
		dsbd.lpMixBins=&dsmb;

		if (lpds->CreateSoundBuffer(&dsbd, &audio_FmWave[i], NULL) == DS_OK)
		{
			audio_FmWave[i]->SetVolume(DSBVOLUME_MAX) ;
		}
#else
		ACreateAudioVoice(&audio_FmVoice[i]);
		ASetVoiceVolume  ( audio_FmVoice[i], AUDIO_MAX_VOLUME);
		ASetVoicePanning ( audio_FmVoice[i], AUDIO_MAX_PANNING>>1);
		ASetVoiceFrequency(audio_FmVoice[i],audio_info.nSampleRate);

		audio_FmWave[i].nSampleRate		= audio_info.nSampleRate;
		audio_FmWave[i].dwLength		= BUFSIZE;
		audio_FmWave[i].dwLoopStart		= 0;
		audio_FmWave[i].dwLoopEnd		= audio_FmWave[i].dwLength;
		audio_FmWave[i].wFormat			= AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO | AUDIO_FORMAT_LOOP;
		ACreateAudioData(&audio_FmWave[i]);
#endif
#if 0
		for(int j=0;j<(BUFSIZE);j++)
		{
			float f = ( sin( ((float)j*6.2831853f)/(float)BUFSIZE ) )*(float)127.0 ;
			RandData[j] = f ;
			//RandData[j] = (char)(127.0f*sin((((float)j)*((float)freq)*2*3.14159)/((float)BUFSIZE)));
		}

		if (audio_FmWave[i]->Lock(0, BUFSIZE, (void**)&ptr1, &len1, (void**)&ptr2, &len2, DSBLOCK_ENTIREBUFFER) == DS_OK)
		{
			memcpy(ptr1, RandData, BUFSIZE);
			audio_FmWave[i]->Unlock(ptr1, len1, ptr2, len2);
		}
#endif
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_createNoiseVoice()
{
#ifndef DOORIG
	WAVEFORMATEX pcmwf;
	DSBUFFERDESC dsbd;
	DSMIXBINS dsmb;

	DSMIXBINVOLUMEPAIR dsmbvp[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		

	dsmb.dwMixBinCount = 8;
	dsmb.lpMixBinVolumePairs = dsmbvp;

	ZeroMemory(&pcmwf, sizeof(pcmwf));
	pcmwf.wFormatTag = WAVE_FORMAT_PCM;		// wave file
	pcmwf.nChannels=1;						// 1 channel (mono)
	pcmwf.nSamplesPerSec= 22050;			// 22khz
	pcmwf.nBlockAlign=1;					// 1 byte per sample * 1 channel
	pcmwf.nAvgBytesPerSec=pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	pcmwf.wBitsPerSample=8;					// 8 bit samples
	pcmwf.cbSize=0;							// always zero;

	ZeroMemory(&dsbd, sizeof(dsbd));
	dsbd.dwSize=sizeof(dsbd);
	dsbd.dwFlags=DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY ; 
	dsbd.dwBufferBytes=BUFSIZE;	
	dsbd.lpwfxFormat=&pcmwf;
	dsbd.lpMixBins=&dsmb;

	if (lpds->CreateSoundBuffer(&dsbd, &audio_NoiseWave, NULL) == DS_OK)
	{
		audio_NoiseWave->SetVolume(DSBVOLUME_MAX) ;
	}

#else
	ACreateAudioVoice(&audio_NoiseVoice);
	ASetVoiceVolume  ( audio_NoiseVoice, AUDIO_MAX_VOLUME);
	ASetVoicePanning ( audio_NoiseVoice, AUDIO_MAX_PANNING>>1);
	ASetVoiceFrequency(audio_NoiseVoice,audio_info.nSampleRate);

	audio_NoiseWave.nSampleRate		= audio_info.nSampleRate;
	audio_NoiseWave.dwLength		= BUFSIZE;
	audio_NoiseWave.dwLoopStart		= 0;
	audio_NoiseWave.dwLoopEnd		= audio_NoiseWave.dwLength;
	audio_NoiseWave.wFormat			= AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO | AUDIO_FORMAT_LOOP;
	ACreateAudioData(&audio_NoiseWave);
#endif
	audio_NoiseVoiceFreq(50, 127);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_createAudioDmaVoice()
{
#ifndef DOORIG
	WAVEFORMATEX pcmwf;
	DSBUFFERDESC dsbd;
	DSMIXBINS dsmb;

	DSMIXBINVOLUMEPAIR dsmbvp[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		

	dsmb.dwMixBinCount = 8;
	dsmb.lpMixBinVolumePairs = dsmbvp;

	ZeroMemory(&pcmwf, sizeof(pcmwf));
	pcmwf.wFormatTag = WAVE_FORMAT_PCM;		// wave file
	pcmwf.nChannels=1;						// 1 channel (mono)
	pcmwf.nSamplesPerSec= 22050;			// 22khz
	pcmwf.nBlockAlign=1;					// 1 byte per sample * 1 channel
	pcmwf.nAvgBytesPerSec=pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	pcmwf.wBitsPerSample=8;					// 8 bit samples
	pcmwf.cbSize=0;							// always zero;

	ZeroMemory(&dsbd, sizeof(dsbd));
	dsbd.dwSize=sizeof(dsbd);
	dsbd.dwFlags=DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY ; 
	dsbd.dwBufferBytes=BUFSIZE;	
	dsbd.lpwfxFormat=&pcmwf;
	dsbd.lpMixBins=&dsmb;

	if (lpds->CreateSoundBuffer(&dsbd, &audio_AudioDmaWave, NULL) == DS_OK)
	{
		audio_AudioDmaWave->SetVolume(DSBVOLUME_MAX) ;
	}

#else

	ACreateAudioVoice(&audio_AudioDmaVoice);
	ASetVoiceVolume  ( audio_AudioDmaVoice, AUDIO_MAX_VOLUME);
	ASetVoicePanning ( audio_AudioDmaVoice, AUDIO_MAX_PANNING>>1);
	ASetVoiceFrequency(audio_AudioDmaVoice, audio_info.nSampleRate);

	audio_AudioDmaWave.nSampleRate		= audio_info.nSampleRate;
	audio_AudioDmaWave.dwLength		= BUFSIZE;
	audio_AudioDmaWave.dwLoopStart		= 0;
	audio_AudioDmaWave.dwLoopEnd		= audio_AudioDmaWave.dwLength;
	audio_AudioDmaWave.wFormat			= AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;// | AUDIO_FORMAT_LOOP;
	ACreateAudioData(&audio_AudioDmaWave);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_done()
{/*
	fprintf(log_get(), "sound: fm voice %i was %s\n", 0, (audio_FmVoicePlaying[0]?"playing":"not playing"));
	fprintf(log_get(), "sound: fm voice %i was %s\n", 1, (audio_FmVoicePlaying[1]?"playing":"not playing"));
	fprintf(log_get(), "sound: noise voice was %s\n", (audio_NoiseVoicePlaying?"playing":"not playing"));
	fprintf(log_get(), "sound: audio dma voice was %s\n", (audio_AudioDmaVoicePlaying?"playing":"not playing"));
*/
#ifdef DOORIG
	DllEntryPoint( 0, DLL_PROCESS_DETACH, NULL ) ;
	for (int i = 0;i<2;i++)
	{
		ADestroyAudioData(&audio_FmWave[i]);
		ADestroyAudioVoice(audio_FmVoice[i]);
	}
	ADestroyAudioData(&audio_NoiseWave);
	ADestroyAudioVoice(audio_NoiseVoice);
	ADestroyAudioData(&audio_AudioDmaWave);
	ADestroyAudioVoice(audio_AudioDmaVoice);
	ACloseVoices();
    ACloseAudio();
	sealinit = 0 ;
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void audio_init()
{
    UINT		rc;
	UINT		nDevId;
	static int didinit = 0 ;

#ifndef DOORIG
	if (didinit)
		return ;

	if (DirectSoundCreate(NULL, &lpds, NULL) != DS_OK)
	{
		lpds=NULL;		// no sound
		return;
	}

	didinit = 1 ;

#else
	//fprintf(log_get(),"audio: using seal audio library\n");
    /* initialize audio library */

	DllEntryPoint( 0, DLL_PROCESS_ATTACH, NULL ) ;

	//AInitialize();

    /* show registered device drivers */
    //fprintf(log_get(),"audio: registered sound devices:\n");
    for (nDevId = 0; nDevId < AGetAudioNumDevs(); nDevId++) {
        AGetAudioDevCaps(nDevId, &audio_caps);
        //fprintf(log_get(),"audio:   %2d. %s\n", nDevId, audio_caps.szProductName);
    }
    /* open audio device */
    audio_info.nDeviceId = AUDIO_DEVICE_MAPPER;
    audio_info.wFormat   = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;//|AUDIO_MIXER_BASS;
    audio_info.nSampleRate = 22050;
    if ((rc = AOpenAudio(&audio_info)) != AUDIO_ERROR_NONE) 
	{
        //CHAR szText[80];
        //AGetErrorText(rc, szText, sizeof(szText) - 1);
        //fprintf(log_get(),"audio: error: %s\n", szText);
        return;
    }
	
	AOpenVoices(4);
#endif

	audio_createFmVoices();
	audio_createNoiseVoice();
	audio_createAudioDmaVoice();
	sealinit = 1 ;
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_init()
{
	//fprintf(log_get(), "sound: init\n");
	//memory_malloc_secure((void**)&sound_buffers[0],  22050*sizeof(int16), "Right sound buffer");
	//memory_malloc_secure((void**)&sound_buffers[1],  22050*sizeof(int16), "Left sound buffer");
	
	//memset(sound_buffers[0], 0x00, 22050*sizeof(int16));
	//memset(sound_buffers[1], 0x00, 22050*sizeof(int16));

	audio_init();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_reset()
{
	//fprintf(log_get(), "sound: reset\n");
	memset(sound_regs, 0, 8);
	memset(sound_channel_size, 0, 2*sizeof(uint32));
	memset(sound_channel_pos,  0, 2*sizeof(uint32));
	memset(audioDma_regs, 0, 8);
	audio_FmVoicePlaying[0] = true;
	audio_FmVoicePlaying[1] = true;
	audio_FmVoicePlay(0, false);
	audio_FmVoicePlay(1, false);
	audio_NoiseVoicePlaying = true;
	audio_NoiseVoicePlay(false);
	audio_AudioDmaVoicePlaying = true;
	audio_AudioDmaVoicePlay(false);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_done()
{
	//fprintf(log_get(), "sound: done\n");
#ifndef DOORIG
	sound_reset() ;
#else
	audio_done();
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_audio_dma(uint32 Addr, uint8 data)
{
	// fprintf(log_get(), "sound: writing 0x%2x at 0x%.4x (audio dma voice)\n", data, Addr);
	
	audioDma_regs[Addr&0x07] = data;

	switch (Addr&0x07)
	{

	case 0x04: {
					if (data&0x80)
					{
						uint32 offset = ((uint16)audioDma_regs[0])|(((uint16)audioDma_regs[1])<<8);
						uint32 length = ((uint16)audioDma_regs[2])*32;
						audio_AudioDmaSetSample(offset, length, 12000/(1+(audioDma_regs[3]&0x03)), audioDma_regs[3]&(1<<5));
						if (Rd6502(0x2026)&0x04)
						{
							Wr6502(0x2027, Rd6502(0x2027)|0x02);
							interrupts_irq();
						}
						audio_AudioDmaVoicePlay(false);
						audio_AudioDmaVoicePlay(true);
					}
					else
						audio_AudioDmaVoicePlay(false);
					break;	
			   }
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_noise_write(uint32 Addr, uint8 data)
{
	// fprintf(log_get(), "sound: writing 0x%2x at 0x%.4x (noise voice)\n", data, Addr);

	switch (Addr)
	{
	case 0:
			if ((data&0x07)==0)
				audio_NoiseVoicePlay(false);
			else
			{
				audio_NoiseVoiceFreq((22050/16)*(15-((data>>4)&0x0f)), (127*(data&0x0f))/15);
				audio_NoiseVoicePlay(true);
			}
			break;
	case 2: if ((data&0x10)||((data&0x0c)!=0))
				audio_NoiseVoicePlay(true);
			else
				audio_NoiseVoicePlay(false);
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_write(uint32 Addr, uint8 data)
{
	uint32 channel = ((Addr&0x4)>>2);
	Addr&=0x03;
	sound_regs[channel][Addr] = data;

	 // fprintf(log_get(), "sound: writing 0x%.2x at 0x%.4x (channel %i)\n", data, Addr, channel);
	switch (Addr) 
	{
    case 0:
			// fprintf(log_get(),"sound: channel %i, freq 0x%.2x\n", channel, data);
    case 1:
	case 2: 
			if (sound_regs[channel][0]) 
			{
				uint32 v1 = sound_regs[channel][0];
				uint32 v2 = sound_regs[channel][1]&0x07;
				
				uint32 counter = (v1|(v2<<8));
				
				audio_FmVoiceFreq(channel, 4000000/(counter*32), sound_regs[channel][2]&0x0f);
				audio_FmVoicePlay(channel, true);
			}
			else 
				audio_FmVoicePlay(channel, false);
				
			sound_channel_pos[channel] = 0;
			break;
    }
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void sound_exec(uint32 cycles)
{
}
