////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
//#include "stdafx.h"
#include <time.h>
//#include <mmsystem.h>
#include <direct.h>
//#include <commctrl.h>
//#include <COMMDLG.H>
//#include "resource.h"

//#include "./src/sdl/include/sdl.h"
//#include "./src/sdl/include/sdlptc.h"
#include "supervision.h"
//#include "./src/2xSaI.h"

static char romLoadDialog_filePath[1024];
static char romLoadDialog_initialDirectory[1024];

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define		LOG_PATH "wswan.log"

#define		KEY_ENTER	0x0D
#define		KEY_SPACE	0x20
#define		KEY_ESC		0x1b
#define		KEY_UP		0x26
#define		KEY_DOWN	0x28
#define		KEY_LEFT	0x25
#define		KEY_RIGHT	0x27
#define		KEY_BUTTON1 0x57
#define		KEY_BUTTON2 0x58

#define		GUI_COMMAND_NONE				0
#define		GUI_COMMAND_RESET				1
#define		GUI_COMMAND_SCHEME_CHANGE		2
#define		GUI_COMMAND_FILTER_CHANGE		3

#define COLOUR_SCHEME_DEFAULT	0
#define COLOUR_SCHEME_AMBER		1
#define COLOUR_SCHEME_GREEN		2

char		*app_window_title="Potator 0.60 - Esc to return to GUI";
int			app_gameRunning=0;
int			app_terminate=0;
int			app_fullscreen=0;
//SDL_Event	app_input_event;
int			app_rotated=0;

int			gui_command=GUI_COMMAND_NONE;
int			gui_mainDialogRunning;
int			gui_controls_configuration_Running;
int			gui_get_key_Running;
int			gui_get_key_key;
//HINSTANCE	gui_hInstance;
//SDL_Joystick *joystick=NULL;

int			supervision_videoEnhancementType=0;
int			supervision_colourScheme=COLOUR_SCHEME_DEFAULT;
char		*supervision_rom_path;
char		old_rom_path[4096];

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
///////////////////////////////
/////////////////////////////////////////////////
#if 0
char *gui_getRomPath(HWND hWnd)
{
	
	static OPENFILENAME ofn;				// common dialog box structure
	static char			szFile[260];		// buffer for file name
	static char			oldDir[1024];

	InitCommonControls();
	_getcwd(oldDir,1024);
	szFile[0]=0;
	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "Supervision roms\0*.sv\0\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	ofn.hInstance=NULL;
	// Display the Open dialog box. 

	if (GetOpenFileName(&ofn)==TRUE)
		return(ofn.lpstrFile);
	chdir(oldDir);
	return(NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
char *gui_loadState(HWND hWnd)
{
	static OPENFILENAME ofn;				// common dialog box structure
	static char			szFile[260];		// buffer for file name
	static char			oldDir[1024];

	InitCommonControls();
	_getcwd(oldDir,1024);
	szFile[0]=0;
	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "Supervision state\0*.vss\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	ofn.hInstance=NULL;
	// Display the Open dialog box. 

	if (GetOpenFileName(&ofn)==TRUE)
		return(ofn.lpstrFile);
	chdir(oldDir);
	return(NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
char *gui_saveState(HWND hWnd)
{
	static OPENFILENAME ofn;				// common dialog box structure
	static char			szFile[260];		// buffer for file name
	static char			oldDir[1024];

	InitCommonControls();
	_getcwd(oldDir,1024);
	szFile[0]=0;
	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "Supervision state\0*.vss\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = 0;
	ofn.hInstance=NULL;
	// Display the Open dialog box. 

	if (GetSaveFileName(&ofn)==TRUE)
		return(ofn.lpstrFile);
	chdir(oldDir);
	return(NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK GuiMainDialogProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	static BOOL bButton = FALSE;


	switch(message)
	{
		case WM_INITDIALOG:
			break;
		
		case WM_CLOSE:
		{
			gui_mainDialogRunning=0;
			DestroyWindow(hWnd);
			return 1;
		}
		case WM_COMMAND:
		{
			
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_LOAD))
			{
					supervision_rom_path=gui_getRomPath(hWnd);
					if (supervision_rom_path)
						SendMessage(hWnd, WM_CLOSE, 0,0);
					return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_SAVESTATE))
			{
				char *path=gui_saveState(hWnd);
				if (path)
				{
					int err=0;//supervision_saveState(path);
					if (err==0)
						MessageBox(hWnd,"State cannot be saved","Error",MB_OK);
					else
						SendMessage(hWnd, WM_CLOSE, 0,0);
				}
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_LOADSTATE))
			{
				char *path=gui_loadState(hWnd);
				if (path)
				{
					int err=0;//supervision_loadState(path);
					if (err==0)
						MessageBox(hWnd,"State cannot be loaded","Error",MB_OK);
					else
					if (err==-1)
						MessageBox(hWnd,"Please load the correct rom first","Error",MB_OK);
					else
						SendMessage(hWnd, WM_CLOSE, 0,0);
				}
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_RESET))
			{
					gui_command=GUI_COMMAND_RESET;
					SendMessage(hWnd, WM_CLOSE, 0,0);
					return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_CONTINUE))
			{
				SendMessage(hWnd, WM_CLOSE, 0,0);
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON_EXIT))
			{
				SendMessage(hWnd, WM_CLOSE, 0,0);
				app_terminate=1;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_STANDARD_MODE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_STANDARD_MODE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=0;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_DOUBLESIZE_MODE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_DOUBLESIZE_MODE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=1;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_SCANLINES_MODE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_SCANLINES_MODE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=2;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_50PRCTSCANLINES_MODE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_50PRCTSCANLINES_MODE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=3;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_SPECIAL_MODE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_SPECIAL_MODE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=4;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_2XSAI))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_2XSAI),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=5;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_SUPER2XSAI))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_SUPER2XSAI),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=6;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_SUPEREAGLE))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_SUPEREAGLE),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_videoEnhancementType=7;
				gui_command=GUI_COMMAND_FILTER_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_FULLSCREEN))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_FULLSCREEN),BM_GETCHECK ,0,0)==BST_CHECKED)
					app_fullscreen=1;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_RADIO_WINDOWED))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_RADIO_WINDOWED),BM_GETCHECK ,0,0)==BST_CHECKED)
					app_fullscreen=0;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_COLOUR_DEFAULT))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_COLOUR_DEFAULT),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_colourScheme=COLOUR_SCHEME_DEFAULT;
				gui_command=GUI_COMMAND_SCHEME_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_COLOUR_AMBER))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_COLOUR_AMBER),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_colourScheme=COLOUR_SCHEME_AMBER;
				gui_command=GUI_COMMAND_SCHEME_CHANGE;
				return 1;
			}
			if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_COLOUR_GREEN))
			{	
				if (SendMessage(GetDlgItem(hWnd, IDC_COLOUR_GREEN),BM_GETCHECK ,0,0)==BST_CHECKED)
					supervision_colourScheme=COLOUR_SCHEME_GREEN;
				gui_command=GUI_COMMAND_SCHEME_CHANGE;
				return 1;
			}
		}
	}
	if(message == WM_INITDIALOG)
		return(TRUE);
	return (FALSE);
}
#endif

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gui_open(void)
{
#if 0
	//HWND	hwnd;
	//MSG		msg;

	gui_command=GUI_COMMAND_NONE;
	//InitCommonControls();
	supervision_rom_path=NULL;
	hwnd		= CreateDialog(gui_hInstance, MAKEINTRESOURCE(IDD_DIALOG_MAIN), NULL, (DLGPROC)GuiMainDialogProc);

	if (hwnd==NULL)
	{
		MessageBox(NULL,"Cannot create gui","Error",MB_OK);
		return;
	}
	if (supervision_colourScheme==COLOUR_SCHEME_DEFAULT)
		SendMessage(GetDlgItem(hwnd, IDC_COLOUR_DEFAULT),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_colourScheme==COLOUR_SCHEME_AMBER)
		SendMessage(GetDlgItem(hwnd, IDC_COLOUR_AMBER),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_colourScheme==COLOUR_SCHEME_GREEN)
		SendMessage(GetDlgItem(hwnd, IDC_COLOUR_GREEN),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);

	if (supervision_videoEnhancementType==0)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_STANDARD_MODE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==1)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_DOUBLESIZE_MODE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==2)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_SCANLINES_MODE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==3)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_50PRCTSCANLINES_MODE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==4)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_SPECIAL_MODE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==5)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_2XSAI),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==6)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_SUPER2XSAI),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
	if (supervision_videoEnhancementType==7)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_SUPEREAGLE),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);

	if (app_fullscreen)
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_FULLSCREEN),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);
	else
		SendMessage(GetDlgItem(hwnd, IDC_RADIO_WINDOWED),BM_SETCHECK ,(WPARAM)BST_CHECKED,0);

	gui_mainDialogRunning=1;
	ShowWindow(hwnd, SW_SHOWDEFAULT);
	UpdateWindow(hwnd);

	while(gui_mainDialogRunning)
	{
		if (GetMessage(&msg, hwnd, 0, 0))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	DestroyWindow(hwnd);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
//#include "./src/filters/standard.h"
//#include "./src/filters/doubled.h"
//#include "./src/filters/scanlines.h"
//#include "./src/filters/halfscanlines.h"
//#include "./src/filters/2xsai.h"
//#include "./src/filters/super2xsai.h"
//#include "./src/filters/supereagle.h"
//#include "./src/filters/special.h"
void supervision_emulate_standard(int isrotated);

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////
//Console console;
//Surface *surface;
//Format format(16,0x007c00,0x00003e0,0x0000001f);

bool bFullscreen = false;
bool bTerminate  = false;

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////
void main_set_window_title(char *szTitle)
{
	//SDL_WM_SetCaption(szTitle, szTitle);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////
void main_screen_switch(void)
{
#if 0
	bFullscreen=!bFullscreen;
	if (bFullscreen)
		console.option("fullscreen output");
	else
		console.option("windowed output");
	console.close();
	console.open("WIP VERSION",160,160,format);
#endif
}
//////////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////
#if 0
int main_open_rom(HWND hWnd,char *title,char *filterString)
{
	OPENFILENAME ofn;


	romLoadDialog_initialDirectory[0] = 0;


	romLoadDialog_filePath[0] = 0;

	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = romLoadDialog_filePath;
	ofn.nMaxFile = sizeof(romLoadDialog_filePath);
	ofn.lpstrFilter =  filterString;
	ofn.nFilterIndex = 0;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = (const char *)romLoadDialog_initialDirectory;
	ofn.lpstrTitle = title; 
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	if(GetOpenFileName(&ofn) == FALSE) 
	{
		DWORD res = CommDlgExtendedError();
		SendMessage(hWnd, WM_MOVE, 0,0);
		return 0;
	}


	SendMessage(hWnd, WM_MOVE, 0,0);
	return 1;
}
#endif
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_buildHalfBrightnessTable(void);

int potato_WinMain( char *filename, int color)
{
	unsigned int		 startTime, endTime, totalFrames;
	unsigned int nNormalLast=0;
	int			 nNormalFrac=0; 
	int			 nTime=0,nCount=0; int i=0;

	//log_init("watara.log");
	//Init_2xSaI(555);
	//SDL_Event	app_input_event;

	supervision_colourScheme = color ;

	memory_init();
	version_init();
	//version_display(log_get());
	//gui_hInstance=hInstance;
	//gui_open();
	//while (!app_terminate)
	{
//		if (supervision_rom_path)
		{
			supervision_init();
			if (supervision_load(filename))
			{
				app_rotated=false;
				app_gameRunning=1;
				supervision_buildHalfBrightnessTable();
				supervision_reset();
				supervision_set_colour_scheme(supervision_colourScheme);
				supervision_emulate_standard( app_rotated); 

#if 0
				switch (supervision_videoEnhancementType)
				{
				case 0: supervision_emulate_standard(); break;
				case 1: supervision_emulate_doubled(); break;
				case 2: supervision_emulate_scanlines(); break;
				case 3: supervision_emulate_halfBrightnessScanlines(); break;
				case 4: supervision_emulate_special(); break;
				case 5: supervision_emulate_2xSaI(); break;
				case 6: supervision_emulate_Super2xSaI(); break;
				case 7: supervision_emulate_SuperEagle(); break;
				}
#endif
			}
		}
	}
	version_done();
	memory_done();
	log_done();	return 0;
}



