//============================================================================
//
//   SSSS    tt          lll  lll       
//  SS  SS   tt           ll   ll        
//  SS     tttttt  eeee   ll   ll   aaaa 
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-1998 by Bradford W. Mott
//
// See the file "license" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: SndXBOX.cxx,v 1.1.1.1 2001/12/27 19:54:32 bwmott Exp $
//============================================================================


#include "SndXBOX.hxx"
#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif


int sounddanger ;


#ifdef __cplusplus
}
#endif

#include "src/seal/audio.h"

// the local buffer is what the stream buffer feeds from
// note that this needs to be large enough to buffer at frameskip 11
// for 30fps games like Tapper; we will scale the value down based
// on the actual framerate of the game
#define MAX_BUFFER_SIZE			(128 * 1024)

// this is the maximum number of extra samples we will ask for
// per frame (I know this looks like a lot, but most of the
// time it will generally be nowhere close to this)
#define MAX_SAMPLE_ADJUST		16

extern DWORD g_dwStartTime ;
extern DWORD g_dwTimePaused ;

/**
  Compute the buffer size to use based on the given sample rate

  @param The sample rate to compute the buffer size for
*/
static unsigned long computeBufferSize(int sampleRate)
{
  int t;

  for(t = 7; t <= 12; ++t)
  {
    if((1 << t) > (sampleRate / 60))
    {
      return (1 << (t - 1));
    }
  }

  return 256;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
SoundXBOX::SoundXBOX()
{
	dsound = NULL ;
	stream_buffer = NULL ;
	attenuation = 0 ;
	samples_to_read = 0 ;
	m_fps = 60 ;


}
 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
SoundXBOX::~SoundXBOX()
{
}

int SoundXBOX::dsound_init(void)
{
	HRESULT result;


	current_adjustment = 0 ;
	m_totalBytesWritten = 0 ;

	// make a format description for what we want
	stream_format.wBitsPerSample	= 16;
	stream_format.wFormatTag		= WAVE_FORMAT_PCM;
	stream_format.nChannels			= 1;
	stream_format.nSamplesPerSec	= 44100;
	stream_format.nBlockAlign		= stream_format.wBitsPerSample * stream_format.nChannels / 8;
	stream_format.nAvgBytesPerSec	= stream_format.nSamplesPerSec * stream_format.nBlockAlign;

	// compute the buffer sizes
	stream_buffer_size = (UINT64)MAX_BUFFER_SIZE ;
//	stream_buffer_size = ((UINT64)MAX_BUFFER_SIZE * (UINT64)stream_format.nSamplesPerSec) / 44100;
	stream_buffer_size = (stream_buffer_size * stream_format.nBlockAlign) / 4;
	stream_buffer_size = (stream_buffer_size * 30) / 60 ;
	stream_buffer_size = (stream_buffer_size / 1024) * 1024;
	stream_buffer_size = 21000;

	stream_buffer_in = 0 ;

	DSMIXBINVOLUMEPAIR dsmbvp[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		
	DSMIXBINS dsmb;
	dsmb.dwMixBinCount = 8;
	dsmb.lpMixBinVolumePairs = dsmbvp;
	
	// create a buffer desc for the stream buffer
	stream_desc.dwSize				= sizeof(stream_desc);
	stream_desc.dwFlags				= 0 ;
	stream_desc.dwBufferBytes 		= 0; //we'll specify our own data
//	stream_desc.dwBufferBytes 		= stream_buffer_size;
	stream_desc.lpwfxFormat			= &stream_format;
	stream_desc.lpMixBins			= &dsmb;
	
	// create the stream buffer
	if ((result = dsound->CreateSoundBuffer(&stream_desc, &stream_buffer, NULL)) != DS_OK)
	{
		stream_buffer = NULL ;
		return 1 ;
	}
	if ((result = dsound->CreateSoundBuffer(&stream_desc, &stream_buffer2, NULL)) != DS_OK)
	{
		stream_buffer2 = NULL ;
		return 1 ;
	}
	
	m_pSoundBufferData = (byte*)malloc( stream_buffer_size ) ;
	m_pSoundBufferData2 = (byte*)malloc( stream_buffer_size ) ;

	stream_buffer->SetBufferData( m_pSoundBufferData, stream_buffer_size ) ;
	stream_buffer->SetPlayRegion( 0, stream_buffer_size ) ;
	stream_buffer->SetLoopRegion( 0, stream_buffer_size ) ;

	memset( m_pSoundBufferData, 0, stream_buffer_size);
	
	stream_buffer->SetVolume( DSBVOLUME_MAX );
	stream_buffer->SetCurrentPosition( 0 ) ;

	m_dwWritePos = 0 ;


	stream_buffer2->SetBufferData( m_pSoundBufferData2, stream_buffer_size ) ;
	stream_buffer2->SetPlayRegion( 0, stream_buffer_size ) ;
	stream_buffer2->SetLoopRegion( 0, stream_buffer_size ) ;

	memset( m_pSoundBufferData2, 0, stream_buffer_size);
	
	stream_buffer2->SetVolume( DSBVOLUME_MAX );
	stream_buffer2->SetCurrentPosition( 0 ) ;

	m_dwWritePos2 = 0 ;

	return 0 ;
}


void SoundXBOX::init( )
{
	m_totalBytesWritten = 0 ;
	m_dwWritePos = 0 ;
	m_dwWritePos2 = 0 ;
	m_bDanger = 0 ;
	memset( m_pSoundBufferData, 0, stream_buffer_size ) ;
	stream_buffer->SetVolume( DSBVOLUME_MAX );
	stream_buffer->Stop() ;
	stream_buffer->SetCurrentPosition( 0 ) ;

	memset( m_pSoundBufferData2, 0, stream_buffer_size ) ;
	stream_buffer2->SetVolume( DSBVOLUME_MAX );
	stream_buffer2->Stop() ;
	stream_buffer2->SetCurrentPosition( 0 ) ;

	m_nVolume = DSBVOLUME_MAX ;
	sounddanger = 0 ;
}

void SoundXBOX::adjust_volume( int volchange ) 
{
	m_nVolume += volchange ;

	if ( m_nVolume > DSBVOLUME_MAX )
		m_nVolume = DSBVOLUME_MAX ;
	if ( m_nVolume < DSBVOLUME_MIN )
		m_nVolume = DSBVOLUME_MIN ;

	stream_buffer->SetVolume( m_nVolume ) ;
	stream_buffer2->SetVolume( m_nVolume ) ;

}


void SoundXBOX::cleanup()
{
	stream_buffer->SetVolume( DSBVOLUME_MIN );
	stream_buffer->Stop() ;
	stream_buffer2->SetVolume( DSBVOLUME_MIN );
	stream_buffer2->Stop() ;
}

int SoundXBOX::process( unsigned char *Buffer, int Count )
{
	unsigned char *sndbuf ;
	int            num_written ;
	float          numtowrite_f ;
	int            numtowrite ;
	float          waittime ;
	DWORD          waittime_ms ;
	float          elapsedTime ;
	DWORD          playPos  ;
	DWORD          bytesToEnd ;
	DWORD          distWritePlay ;
	DWORD          newWritePos ;
	byte           *bytebuf ;
	static int     evenodd = 0 ;
	static int numdanger= 0 ;

	stream_buffer->GetCurrentPosition( &playPos, NULL ) ;

	if ( m_dwWritePos > playPos )
	{
		distWritePlay = m_dwWritePos - playPos ;
	}
	else
	{
		distWritePlay = ( stream_buffer_size - playPos ) + m_dwWritePos ;
	}

	if ( distWritePlay > 10000 ) 
	{
		/*
		stream_buffer->GetCurrentPosition( &playPos, NULL ) ;

		if ( m_dwWritePos > playPos )
		{
			distWritePlay = m_dwWritePos - playPos ;
		}
		else
		{
			distWritePlay = ( stream_buffer_size - playPos ) + m_dwWritePos ;
		}
		*/
		sounddanger = 0 ;
		return 0; 
	}

	//evenodd = !evenodd ;
	//sprintfx( "sound bytes = %u\r\n", Count ) ;

	//if ( evenodd )
		numtowrite = Count ;
	//else
		//numtowrite = Count-4 ;

	bytebuf = (byte*)Buffer ;

	if ( numtowrite > 0 )
	{

		bytesToEnd = stream_buffer_size - m_dwWritePos ;

		if ( numtowrite > bytesToEnd )
		{
			memcpy( m_pSoundBufferData + m_dwWritePos, bytebuf, bytesToEnd ) ;
			memcpy( m_pSoundBufferData, bytebuf + bytesToEnd, numtowrite - bytesToEnd ) ;
		}
		else
		{
			memcpy( m_pSoundBufferData + m_dwWritePos, bytebuf, numtowrite ) ;
		}

		m_dwWritePos = ( m_dwWritePos + numtowrite ) % stream_buffer_size ;

		m_totalBytesWritten += numtowrite ;
/*
		do
		{
			stream_buffer->GetCurrentPosition( &playPos, NULL ) ;

			if ( m_dwWritePos > playPos )
			{
				distWritePlay = m_dwWritePos - playPos ;
			}
			else
			{
				distWritePlay = ( stream_buffer_size - playPos ) + m_dwWritePos ;
			}
		} while ( distWritePlay > 10000 ) ;
*/

		if ( distWritePlay < 3750 ) 
		{
			sounddanger = 1 ;
			//sprintfx( "sound danger %u\r\n", ++numdanger ) ;
			return 1 ;
		}

	}

	sounddanger = 0 ;

	return 0 ;

}

int SoundXBOX::process2( unsigned char *Buffer, int Count )
{
	unsigned char *sndbuf ;
	int            num_written ;
	float          numtowrite_f ;
	int            numtowrite ;
	float          waittime ;
	DWORD          waittime_ms ;
	float          elapsedTime ;
	DWORD          playPos  ;
	DWORD          bytesToEnd ;
	DWORD          distWritePlay ;
	DWORD          newWritePos ;
	byte           *bytebuf ;
	static int     evenodd = 0 ;
	static int numdanger= 0 ;

	stream_buffer2->GetCurrentPosition( &playPos, NULL ) ;

	if ( m_dwWritePos2 > playPos )
	{
		distWritePlay = m_dwWritePos2 - playPos ;
	}
	else
	{
		distWritePlay = ( stream_buffer_size - playPos ) + m_dwWritePos2 ;
	}

	if ( distWritePlay > 10000 ) 
	{
		sounddanger = 0 ;
		return 0; 
	}

	numtowrite = Count ;
	bytebuf = (byte*)Buffer ;

	if ( numtowrite > 0 )
	{

		bytesToEnd = stream_buffer_size - m_dwWritePos2 ;

		if ( numtowrite > bytesToEnd )
		{
			memcpy( m_pSoundBufferData2 + m_dwWritePos2, bytebuf, bytesToEnd ) ;
			memcpy( m_pSoundBufferData2, bytebuf + bytesToEnd, numtowrite - bytesToEnd ) ;
		}
		else
		{
			memcpy( m_pSoundBufferData2 + m_dwWritePos2, bytebuf, numtowrite ) ;
		}

		m_dwWritePos2 = ( m_dwWritePos2 + numtowrite ) % stream_buffer_size ;

		m_totalBytesWritten += numtowrite ;

		if ( distWritePlay < 3750 ) 
		{
			sounddanger = 1 ;
			//sprintfx( "sound danger %u\r\n", ++numdanger ) ;
			return 1 ;
		}

	}

	sounddanger = 0 ;

	return 0 ;

}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define DOORIG

#ifndef DOORIG
extern LPDIRECTSOUNDBUFFER audio_FmWave[2];						// Voice buffers
extern LPDIRECTSOUNDBUFFER audio_NoiseWave;						// Voice buffers
extern LPDIRECTSOUNDBUFFER audio_AudioDmaWave;						// Voice buffers
#else
extern HAC			audio_FmVoice[2];
extern AUDIOWAVE	audio_FmWave[2];
extern HAC			audio_NoiseVoice;
extern AUDIOWAVE   audio_NoiseWave;
extern HAC			audio_AudioDmaVoice;
extern AUDIOWAVE   audio_AudioDmaWave;
extern int sealinit ;
#endif

extern bool		audio_FmVoicePlaying[2];
extern bool     audio_NoiseVoicePlaying;
extern bool     audio_AudioDmaVoicePlaying;

void SoundXBOX::pause(bool state)
{

	if (stream_buffer)
	{
		if (state)
			stream_buffer->Stop() ;
		//else
			//stream_buffer->Play( 0, 0, DSBPLAY_LOOPING ) ;
	}
#ifndef DOORIG
	if ( audio_NoiseWave == NULL  )
		return ;
xxx
	if ( !state )
	{
		for ( int i = 0 ; i < 2 ; i++ )
		{
			if ( audio_FmVoicePlaying[i] )
				audio_FmWave[i]->Play( 0,0,DSBPLAY_LOOPING) ;
			else
				audio_FmWave[i]->Stop() ;
		}
		if ( audio_NoiseVoicePlaying )
			audio_NoiseWave->Play( 0,0,DSBPLAY_LOOPING) ;
		else
			audio_NoiseWave->Stop() ;

		if ( audio_AudioDmaVoicePlaying )
			audio_AudioDmaWave->Play( 0,0,DSBPLAY_LOOPING) ;
		else
			audio_AudioDmaWave->Stop() ;
	}
	else
	{
		audio_FmWave[0]->Stop() ;
		audio_FmWave[1]->Stop() ;
		audio_NoiseWave->Stop() ;
		audio_AudioDmaWave->Stop() ;
	}
#else
	if ( sealinit == 0 )
		return ;

	if ( !state )
	{
		for ( int i = 0 ; i < 2 ; i++ )
		{
			if ( audio_FmVoicePlaying[i] )
				APlayVoice(audio_FmVoice[i], &audio_FmWave[i]);
			else
				AStopVoice(audio_FmVoice[i]);
		}
		if ( audio_NoiseVoicePlaying )
			APlayVoice(audio_NoiseVoice, &audio_NoiseWave);
		else
			AStopVoice(audio_NoiseVoice);

		if ( audio_AudioDmaVoicePlaying )
			APlayVoice(audio_AudioDmaVoice, &audio_AudioDmaWave);
		else
			AStopVoice(audio_AudioDmaVoice);
	}
	else
	{
		AStopVoice(audio_FmVoice[0]);
		AStopVoice(audio_FmVoice[1]);
		AStopVoice(audio_NoiseVoice);
		AStopVoice(audio_AudioDmaVoice);
	}

#endif

}

