////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#include "supervision.h"

M6502	m6502_registers;

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
byte Loop6502(register M6502 *R)
{
	return(INT_QUIT);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_init(void)
{
	//fprintf(log_get(), "supervision: init\n");

	memorymap_init();
	io_init();
	gpu_init();
	timer_init();
	controls_init();
	sound_init();
	interrupts_init();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
bool supervision_load(char *szPath)
{
	uint32 supervision_programRomSize;
	uint8 *supervision_programRom = memorymap_rom_load(szPath, &supervision_programRomSize);

	memorymap_load(supervision_programRom, supervision_programRomSize);
	supervision_reset();

	return(true);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_reset(void)
{
	//fprintf(log_get(), "supervision: reset\n");


	memorymap_reset();
	io_reset();
	gpu_reset();
	timer_reset();
	controls_reset();
	sound_reset();
	interrupts_reset();

	Reset6502(&m6502_registers);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_reset_handler(void)
{
	//fprintf(log_get(), "supervision: reset handler\n");
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_done(void)
{
	//fprintf(log_get(), "supervision: done\n");
	memorymap_done();
	io_done();
	gpu_done();
	timer_done();
	controls_done();
	sound_done();
	interrupts_done();
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_set_colour_scheme(int ws_colourScheme)
{
	gpu_set_colour_scheme(ws_colourScheme);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
M6502	*supervision_get6502regs(void)
{
	return(&m6502_registers);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
bool supervision_update_input(void)
{
	return(controls_update());
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_exec(int16 *backbuffer, bool bRender)
{

	for (uint32 supervision_scanline = 0; supervision_scanline < 160; supervision_scanline++)
	{
		m6502_registers.ICount = 512;
		timer_exec(m6502_registers.ICount);
		sound_exec(22050/160);
		Run6502(&m6502_registers);
		gpu_render_scanline(supervision_scanline, backbuffer, bRender);
		backbuffer += 160;
	}

	if (Rd6502(0x2026)&0x01)
		interrupts_nmi();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_turnSound(bool bOn)
{
	audio_turnSound(bOn);
}


extern uint16	supervision_palette[4];
extern uint8    gpu_regs[4];

extern uint8 controls_state;


extern uint8 io_data;

extern uint32   memorymap_programRomSize;
extern uint8	*memorymap_programRom;
extern uint8	memorymap_lowerRam[0x2000];
extern uint8	memorymap_upperRam[0x2000];
extern uint8	*memorymap_lowerRomBank;  //(memorymap_programRom + ???)
extern uint8	*memorymap_upperRomBank;  //(/memorymap_programRom + ???)
extern uint8	memorymap_regs[0x2000];


extern uint8    sound_regs[2][4];
extern uint32   sound_channel_size[2];
extern uint32	sound_channel_pos[2];
extern uint8    audioDma_regs[8];

extern bool		audio_FmVoicePlaying[2];
extern bool        audio_NoiseVoicePlaying;
extern bool        audio_AudioDmaVoicePlaying;
extern bool		audio_FmVoicePlayingOld[2];
extern bool        audio_NoiseVoicePlayingOld;
extern bool        audio_AudioDmaVoicePlayingOld;


extern uint8 timer_regs[2];
extern int32 timer_cycles;
extern bool   timer_activated;

extern int noisefreq;
extern int noisevol;
extern int fmfreq1;
extern int fmvol1;
extern int fmfreq2;
extern int fmvol2;

extern uint32 dmaoffset, dmalength, dmafreq, dmacartSpace;

extern int noisevolvoice;
extern int dmavolvoice;
extern int fmvolvoice1;
extern int fmvolvoice2;




void sv_savestate( char *filename )
{
	FILE *sf ;
	uint32 dummy ;

	sf = fopen( filename, "wb" ) ;

	if ( sf == NULL )
		return ;


	fwrite( &audio_NoiseVoicePlaying, sizeof(bool), 1, sf ) ;
	fwrite( &audio_AudioDmaVoicePlaying, sizeof(bool), 1, sf ) ;
	fwrite( &audio_NoiseVoicePlayingOld, sizeof(bool), 1, sf ) ;
	fwrite( &audio_AudioDmaVoicePlayingOld, sizeof(bool), 1, sf ) ;
	fwrite( &timer_activated, sizeof(bool), 1, sf ) ;

	fwrite( &timer_cycles, sizeof(int32), 1, sf ) ;

	fwrite( &m6502_registers, sizeof(M6502), 1, sf ) ;

	fwrite( &controls_state, sizeof(uint8), 1, sf ) ;
	fwrite( &io_data, sizeof(uint8), 1, sf ) ;

	dummy = memorymap_lowerRomBank - memorymap_programRom ;
	fwrite( &dummy, sizeof(uint32), 1, sf ) ;
	dummy = memorymap_upperRomBank - memorymap_programRom ;
	fwrite( &dummy, sizeof(uint32), 1, sf ) ;

	fwrite( memorymap_lowerRam, sizeof(uint8), 0x2000, sf ) ;
	fwrite( memorymap_upperRam, sizeof(uint8), 0x2000, sf ) ;

	fwrite( supervision_palette, sizeof(uint16), 4, sf ) ;
	fwrite( gpu_regs, sizeof(uint8), 4, sf ) ;

	fwrite( memorymap_regs, sizeof(uint8), 0x2000, sf ) ;
	fwrite( sound_regs, sizeof(uint8), 2*4, sf ) ;
	fwrite( sound_channel_size, sizeof(uint32), 2, sf ) ;
	fwrite( sound_channel_pos, sizeof(uint32), 2, sf ) ;
	fwrite( audioDma_regs, sizeof(uint8), 8, sf ) ;
	fwrite( audio_FmVoicePlaying, sizeof(bool), 2, sf )  ;
	fwrite( audio_FmVoicePlayingOld, sizeof(bool), 2, sf );
	fwrite( timer_regs, sizeof(uint8), 2, sf ) ;


	fwrite( &noisefreq, sizeof(int), 1, sf ) ;
	fwrite( &noisevol, sizeof(int), 1, sf ) ;
	fwrite( &fmfreq1, sizeof(int), 1, sf ) ;
	fwrite( &fmvol1, sizeof(int), 1, sf ) ;
	fwrite( &fmfreq2, sizeof(int), 1, sf ) ;
	fwrite( &fmvol2, sizeof(int), 1, sf ) ;
	fwrite( &noisevolvoice, sizeof(int), 1, sf ) ;
	fwrite( &dmavolvoice, sizeof(int), 1, sf ) ;
	fwrite( &fmvolvoice1, sizeof(int), 1, sf ) ;
	fwrite( &fmvolvoice2, sizeof(int), 1, sf ) ;

	fwrite( &dmaoffset, sizeof(uint32), 1, sf ) ;
	fwrite( &dmalength, sizeof(uint32), 1, sf ) ;
	fwrite( &dmafreq, sizeof(uint32), 1, sf ) ;
	fwrite( &dmacartSpace, sizeof(uint32), 1, sf ) ;


	fclose( sf ) ;

}

void audio_FmVoicePlay(int channel, bool bPlay);
void audio_NoiseVoiceVolume(int volume);
void audio_AudioDmaSetSample(uint32 offset, uint32 length, uint32 freq, uint32 cartSpace);
void audio_FmVoiceFreq(int channel, int freq, int volume);
void audio_AudioDmaVoiceVolume(int volume);
void audio_NoiseVoicePlay(bool bPlay);
void audio_AudioDmaVoicePlay(bool bPlay);
void audio_FmVoiceVolume(int channel, int volume);

void sv_loadstate( char *filename )
{
	FILE *sf ;
	uint32 dummy ;

	sf = fopen( filename, "rb" ) ;

	if ( sf == NULL )
		return ;


	fread( &audio_NoiseVoicePlaying, sizeof(bool), 1, sf ) ;
	fread( &audio_AudioDmaVoicePlaying, sizeof(bool), 1, sf ) ;
	fread( &audio_NoiseVoicePlayingOld, sizeof(bool), 1, sf ) ;
	fread( &audio_AudioDmaVoicePlayingOld, sizeof(bool), 1, sf ) ;
	fread( &timer_activated, sizeof(bool), 1, sf ) ;

	fread( &timer_cycles, sizeof(int32), 1, sf ) ;

	fread( &m6502_registers, sizeof(M6502), 1, sf ) ;

	fread( &controls_state, sizeof(uint8), 1, sf ) ;
	fread( &io_data, sizeof(uint8), 1, sf ) ;

	fread( &dummy, sizeof(uint32), 1, sf ) ;
	memorymap_lowerRomBank = dummy + memorymap_programRom ;
	fread( &dummy, sizeof(uint32), 1, sf ) ;
	memorymap_upperRomBank = dummy + memorymap_programRom ;

	fread( memorymap_lowerRam, sizeof(uint8), 0x2000, sf ) ;
	fread( memorymap_upperRam, sizeof(uint8), 0x2000, sf ) ;

	fread( supervision_palette, sizeof(uint16), 4, sf ) ;
	fread( gpu_regs, sizeof(uint8), 4, sf ) ;

	fread( memorymap_regs, sizeof(uint8), 0x2000, sf ) ;
	fread( sound_regs, sizeof(uint8), 2*4, sf ) ;
	fread( sound_channel_size, sizeof(uint32), 2, sf ) ;
	fread( sound_channel_pos, sizeof(uint32), 2, sf ) ;
	fread( audioDma_regs, sizeof(uint8), 8, sf ) ;
	fread( audio_FmVoicePlaying, sizeof(bool), 2, sf )  ;
	fread( audio_FmVoicePlayingOld, sizeof(bool), 2, sf );
	fread( timer_regs, sizeof(uint8), 2, sf ) ;

	fread( &noisefreq, sizeof(int), 1, sf ) ;
	fread( &noisevol, sizeof(int), 1, sf ) ;
	fread( &fmfreq1, sizeof(int), 1, sf ) ;
	fread( &fmvol1, sizeof(int), 1, sf ) ;
	fread( &fmfreq2, sizeof(int), 1, sf ) ;
	fread( &fmvol2, sizeof(int), 1, sf ) ;
	fread( &noisevolvoice, sizeof(int), 1, sf ) ;
	fread( &dmavolvoice, sizeof(int), 1, sf ) ;
	fread( &fmvolvoice1, sizeof(int), 1, sf ) ;
	fread( &fmvolvoice2, sizeof(int), 1, sf ) ;

	fread( &dmaoffset, sizeof(uint32), 1, sf ) ;
	fread( &dmalength, sizeof(uint32), 1, sf ) ;
	fread( &dmafreq, sizeof(uint32), 1, sf ) ;
	fread( &dmacartSpace, sizeof(uint32), 1, sf ) ;

	audio_FmVoicePlaying[0] = !audio_FmVoicePlaying[0] ;
	audio_FmVoicePlay( 0, audio_FmVoicePlaying[0] ) ;
	audio_FmVoicePlaying[1] = !audio_FmVoicePlaying[1] ;
	audio_FmVoicePlay( 1, audio_FmVoicePlaying[1] ) ;
	audio_NoiseVoiceVolume( noisevolvoice ) ;
	audio_AudioDmaSetSample(dmaoffset, dmalength, dmafreq, dmacartSpace) ;
	audio_FmVoiceFreq( 0, fmfreq1, fmvol1 ) ;
	audio_FmVoiceFreq( 1, fmfreq2, fmvol2 ) ;
	audio_AudioDmaVoiceVolume( dmavolvoice ) ;
	audio_NoiseVoicePlaying = !audio_NoiseVoicePlaying ;
	audio_NoiseVoicePlay(audio_NoiseVoicePlaying) ;
	audio_AudioDmaVoicePlaying = !audio_AudioDmaVoicePlaying ;
	audio_AudioDmaVoicePlay(audio_AudioDmaVoicePlaying);
	audio_FmVoiceVolume(0, fmvolvoice1 ) ;
	audio_FmVoiceVolume(1, fmvolvoice2 ) ;


	fclose( sf ) ;
}

extern "C" size_t xbox_mfread( const void *buffer, size_t len1, size_t len2, void *st ) ;
extern "C" size_t xbox_mfwrite( const void *buffer, size_t len1, size_t len2, void *st ) ;

extern "C" void xbox_savestatemem( void *sf )
{
	uint32 dummy ;

	xbox_mfwrite( &audio_NoiseVoicePlaying, sizeof(bool), 1, sf ) ;
	xbox_mfwrite( &audio_AudioDmaVoicePlaying, sizeof(bool), 1, sf ) ;
	xbox_mfwrite( &audio_NoiseVoicePlayingOld, sizeof(bool), 1, sf ) ;
	xbox_mfwrite( &audio_AudioDmaVoicePlayingOld, sizeof(bool), 1, sf ) ;
	xbox_mfwrite( &timer_activated, sizeof(bool), 1, sf ) ;

	xbox_mfwrite( &timer_cycles, sizeof(int32), 1, sf ) ;

	xbox_mfwrite( &m6502_registers, sizeof(M6502), 1, sf ) ;

	xbox_mfwrite( &controls_state, sizeof(uint8), 1, sf ) ;
	xbox_mfwrite( &io_data, sizeof(uint8), 1, sf ) ;

	dummy = memorymap_lowerRomBank - memorymap_programRom ;
	xbox_mfwrite( &dummy, sizeof(uint32), 1, sf ) ;
	dummy = memorymap_upperRomBank - memorymap_programRom ;
	xbox_mfwrite( &dummy, sizeof(uint32), 1, sf ) ;

	xbox_mfwrite( memorymap_lowerRam, sizeof(uint8), 0x2000, sf ) ;
	xbox_mfwrite( memorymap_upperRam, sizeof(uint8), 0x2000, sf ) ;

	xbox_mfwrite( supervision_palette, sizeof(uint16), 4, sf ) ;
	xbox_mfwrite( gpu_regs, sizeof(uint8), 4, sf ) ;

	xbox_mfwrite( memorymap_regs, sizeof(uint8), 0x2000, sf ) ;
	xbox_mfwrite( sound_regs, sizeof(uint8), 2*4, sf ) ;
	xbox_mfwrite( sound_channel_size, sizeof(uint32), 2, sf ) ;
	xbox_mfwrite( sound_channel_pos, sizeof(uint32), 2, sf ) ;
	xbox_mfwrite( audioDma_regs, sizeof(uint8), 8, sf ) ;
	xbox_mfwrite( audio_FmVoicePlaying, sizeof(bool), 2, sf )  ;
	xbox_mfwrite( audio_FmVoicePlayingOld, sizeof(bool), 2, sf );
	xbox_mfwrite( timer_regs, sizeof(uint8), 2, sf ) ;

	xbox_mfwrite( &noisefreq, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &noisevol, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmfreq1, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmvol1, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmfreq2, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmvol2, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &noisevolvoice, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &dmavolvoice, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmvolvoice1, sizeof(int), 1, sf ) ;
	xbox_mfwrite( &fmvolvoice2, sizeof(int), 1, sf ) ;

	xbox_mfwrite( &dmaoffset, sizeof(uint32), 1, sf ) ;
	xbox_mfwrite( &dmalength, sizeof(uint32), 1, sf ) ;
	xbox_mfwrite( &dmafreq, sizeof(uint32), 1, sf ) ;
	xbox_mfwrite( &dmacartSpace, sizeof(uint32), 1, sf ) ;

}

extern "C" void xbox_loadstatemem( void *sf )
{
	uint32 dummy ;

	xbox_mfread( &audio_NoiseVoicePlaying, sizeof(bool), 1, sf ) ;
	xbox_mfread( &audio_AudioDmaVoicePlaying, sizeof(bool), 1, sf ) ;
	xbox_mfread( &audio_NoiseVoicePlayingOld, sizeof(bool), 1, sf ) ;
	xbox_mfread( &audio_AudioDmaVoicePlayingOld, sizeof(bool), 1, sf ) ;
	xbox_mfread( &timer_activated, sizeof(bool), 1, sf ) ;

	xbox_mfread( &timer_cycles, sizeof(int32), 1, sf ) ;

	xbox_mfread( &m6502_registers, sizeof(M6502), 1, sf ) ;

	xbox_mfread( &controls_state, sizeof(uint8), 1, sf ) ;
	xbox_mfread( &io_data, sizeof(uint8), 1, sf ) ;

	xbox_mfread( &dummy, sizeof(uint32), 1, sf ) ;
	memorymap_lowerRomBank = dummy + memorymap_programRom ;
	xbox_mfread( &dummy, sizeof(uint32), 1, sf ) ;
	memorymap_upperRomBank = dummy + memorymap_programRom ;

	xbox_mfread( memorymap_lowerRam, sizeof(uint8), 0x2000, sf ) ;
	xbox_mfread( memorymap_upperRam, sizeof(uint8), 0x2000, sf ) ;

	xbox_mfread( supervision_palette, sizeof(uint16), 4, sf ) ;
	xbox_mfread( gpu_regs, sizeof(uint8), 4, sf ) ;

	xbox_mfread( memorymap_regs, sizeof(uint8), 0x2000, sf ) ;
	xbox_mfread( sound_regs, sizeof(uint8), 2*4, sf ) ;
	xbox_mfread( sound_channel_size, sizeof(uint32), 2, sf ) ;
	xbox_mfread( sound_channel_pos, sizeof(uint32), 2, sf ) ;
	xbox_mfread( audioDma_regs, sizeof(uint8), 8, sf ) ;
	xbox_mfread( audio_FmVoicePlaying, sizeof(bool), 2, sf )  ;
	xbox_mfread( audio_FmVoicePlayingOld, sizeof(bool), 2, sf );
	xbox_mfread( timer_regs, sizeof(uint8), 2, sf ) ;

	xbox_mfread( &noisefreq, sizeof(int), 1, sf ) ;
	xbox_mfread( &noisevol, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmfreq1, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmvol1, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmfreq2, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmvol2, sizeof(int), 1, sf ) ;
	xbox_mfread( &noisevolvoice, sizeof(int), 1, sf ) ;
	xbox_mfread( &dmavolvoice, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmvolvoice1, sizeof(int), 1, sf ) ;
	xbox_mfread( &fmvolvoice2, sizeof(int), 1, sf ) ;

	xbox_mfread( &dmaoffset, sizeof(uint32), 1, sf ) ;
	xbox_mfread( &dmalength, sizeof(uint32), 1, sf ) ;
	xbox_mfread( &dmafreq, sizeof(uint32), 1, sf ) ;
	xbox_mfread( &dmacartSpace, sizeof(uint32), 1, sf ) ;

	audio_FmVoicePlaying[0] = !audio_FmVoicePlaying[0] ;
	audio_FmVoicePlay( 0, audio_FmVoicePlaying[0] ) ;
	audio_FmVoicePlaying[1] = !audio_FmVoicePlaying[1] ;
	audio_FmVoicePlay( 1, audio_FmVoicePlaying[1] ) ;
	audio_NoiseVoiceVolume( noisevolvoice ) ;
	audio_AudioDmaSetSample(dmaoffset, dmalength, dmafreq, dmacartSpace) ;
	audio_FmVoiceFreq( 0, fmfreq1, fmvol1 ) ;
	audio_FmVoiceFreq( 1, fmfreq2, fmvol2 ) ;
	audio_AudioDmaVoiceVolume( dmavolvoice ) ;
	audio_NoiseVoicePlaying = !audio_NoiseVoicePlaying ;
	audio_NoiseVoicePlay(audio_NoiseVoicePlaying) ;
	audio_AudioDmaVoicePlaying = !audio_AudioDmaVoicePlaying ;
	audio_AudioDmaVoicePlay(audio_AudioDmaVoicePlaying);
	audio_FmVoiceVolume(0, fmvolvoice1 ) ;
	audio_FmVoiceVolume(1, fmvolvoice2 ) ;
}
