////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#include "gpu.h"

uint16	supervision_palette[4];
uint8    gpu_regs[4];

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_init(void)
{
//	fprintf(log_get(), "gpu: init\n");
	//memory_malloc_secure((void**)&supervision_palette,  4*sizeof(int16), "Palette");
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_done(void)
{
//	fprintf(log_get(), "gpu: done\n");
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_reset(void)
{
//	fprintf(log_get(), "gpu: reset\n");
	supervision_palette[3] = 0x0000;
	supervision_palette[2] = (10<<11)|(10<<6)|10;
	supervision_palette[1] = (20<<11)|(20<<6)|20;
	supervision_palette[0] = 0xffff;
	memset(gpu_regs, 0, 4);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_set_colour_scheme(int ws_colourScheme)
{
	float greenf=1;
	float bluef=1;
	float redf=1;

	switch (ws_colourScheme)
	{
	case COLOUR_SCHEME_DEFAULT:
		break;
	case COLOUR_SCHEME_AMBER:
		greenf=0.61f;
		bluef=0.00f;
		redf=1.00f;
		break;
	case COLOUR_SCHEME_GREEN:
		greenf=0.90f;
		bluef=0.20f;
		redf=0.20f;
		break;
	}
	supervision_palette[3] = 0x0000;
	supervision_palette[2] = (((int)(10*redf))<<11)|(((int)(10*greenf))<<6)|((int)(10*bluef));
	supervision_palette[1] = (((int)(20*redf))<<11)|(((int)(20*greenf))<<6)|((int)(20*bluef));
	supervision_palette[0] = (((int)(30*redf))<<11)|(((int)(30*greenf))<<6)|((int)(30*bluef));
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_write(uint32 addr, uint8 data)
{
	gpu_regs[(addr&0x03)] = data;
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint8 gpu_read(uint32 addr)
{
	return(gpu_regs[(addr&0x03)]);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void gpu_render_scanline(uint32 scanline, int16 *backbuffer, bool bRender)
{
	uint8 *vram_line = &(memorymap_getUpperRamPointer())[(gpu_regs[2] / 4) + (scanline*0x30)];
	uint32 x;

	for (x = 0; x < 160; x += 4)
	{
		uint8 b = *(vram_line++);
		backbuffer[3] = supervision_palette[((b >> 6) & 0x03)];
		backbuffer[2] = supervision_palette[((b >> 4) & 0x03)];
		backbuffer[1] = supervision_palette[((b >> 2) & 0x03)];
		backbuffer[0] = supervision_palette[((b >> 0) & 0x03)];
		backbuffer += 4;
	}
}
