/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "init.h"
#include <xtl.h>
#include "iosupport.h"
CIoSupport m_io ;
#include "SDL.h"

SDL_Joystick *joysticks[4] ;

/*
Initalises a whole load of variables
*/
void initVars()
{
	srand(time(NULL));

	for (int i = 0 ; i < 200 ; i++)
	{
		star[i].x = rand() % 800;
		star[i].y = rand() % 600;
		star[i].speed = 1 + (rand() % 3);
	}

	// These are good values for sound and music

	if (engine.useAudio)
	{
		Mix_Volume(-1, 25);
		Mix_VolumeMusic((int)engine.musicVolume);
	}
}

/*
Something went wrong. This stops the game, present the error message and
prompts the user to press space or ctrl to exit the game. This is unlikely to
be seen by people unless something really stoopid happens!
*/
void showErrorAndExit(int errorId, char *name)
{
	graphics.clearScreen(graphics.black);

	if (errorId != 2)
	{
		graphics.drawString("A file error has occurred", -1, 200, FONT_RED);
	}
	else
	{
		printf("Couldn't create or write to directory '%s'\n", name);
		exit(1);
	}

	char string[255];

	switch(errorId)
	{
		case 0:
			strcpy(string, "");
			sprintf(string, "%s was not found in the Starfighter data package", name);
			graphics.drawString(string, -1, 250, FONT_WHITE);
			graphics.drawString("Please try again. If this error persists, contact Parallel Realities", -1, 275, FONT_WHITE);
			graphics.drawString("or reinstall the game", -1, 300, FONT_WHITE);
			break;
		case 1:
			graphics.drawString("Project: Starfighter encountered an error whilst", -1, 250, FONT_WHITE);
			graphics.drawString("attempting to load game data. Please try running", -1, 275, FONT_WHITE);
			graphics.drawString("the game again. If the errors persist, reinstall the game", -1, 300, FONT_WHITE);
			break;
		case 2:
			graphics.drawString("Project: Starfighter encountered a critical error", -1, 250, FONT_WHITE);
			graphics.drawString("while attempting to perform a required program function.", -1, 275, FONT_WHITE);
			graphics.drawString("Please contact Parallel Realities with details", -1, 300, FONT_WHITE);
			break;
	}

	graphics.drawString("Project: Starfighter will now exit", -1, 450, FONT_WHITE);
	graphics.drawString("Press Space to continue", -1, 475, FONT_WHITE);

	engine.keyState[SDLK_SPACE] = 0;

	while (!engine.keyState[SDLK_SPACE])
	{
		getPlayerInput();
		graphics.updateScreen();
	}

	exit(1);
}

/*
This bit is just for Linux users. It attempts to get the user's
home directory, then creates the .parallelrealities and .parallelrealities/starfighter
directories so that saves and temporary data files can be written there. Good, eh? :)
*/
#if LINUX
void setupUserHomeDirectory()
{
	char *userHome;

	char *name = getlogin();
	
	passwd *pass;

	if (name != NULL)
		pass = getpwnam(name);
	else
		pass = getpwuid(geteuid());

	if (pass == NULL)
	{
		printf("Couldn't determine the user home directory. Exitting.\n");
		exit(1);
	}

	userHome = pass->pw_dir;

	char dir[PATH_MAX];
	strcpy(dir, "");

	sprintf(dir, "%s/.parallelrealities", userHome);
	if ((mkdir(dir, S_IRWXU|S_IRWXG|S_IROTH|S_IXOTH) != 0) && (errno != EEXIST))
		showErrorAndExit(2, dir);

	sprintf(dir, "%s/.parallelrealities/starfighter", userHome);
	if ((mkdir(dir, S_IRWXU|S_IRWXG|S_IROTH|S_IXOTH) != 0) && (errno != EEXIST))
		showErrorAndExit(2, dir);

	sprintf(engine.userHomeDirectory, "%s/.parallelrealities/starfighter/", userHome);
}
#endif

/*
Chugg chugg chugg.... brrr... chugg chugg chugg...brrrrrr... chugg ch..
BRRRRRRRRRRRRRRRRRMMMMMMMMMMMMMMMMMMM!! Well, hopefully anyway! ;)
*/
void initSystem()
{
	m_io.Unmount("C:") ;
	m_io.Unmount("E:") ;
	m_io.Unmount("F:") ;
	m_io.Unmount("X:") ;
	m_io.Unmount("Y:") ;
	m_io.Unmount("Z:") ;
	m_io.Unmount("R:") ;
	m_io.Mount("C:", "Harddisk0\\Partition2");
	m_io.Mount("E:", "Harddisk0\\Partition1");
	m_io.Mount("F:", "Harddisk0\\Partition6");
	m_io.Mount("X:", "Harddisk0\\Partition3");
	m_io.Mount("Y:", "Harddisk0\\Partition4");
	m_io.Mount("Z:", "Harddisk0\\Partition5");
	m_io.Mount("R:","Cdrom0");

	CreateDirectory( "E:\\SAVES", NULL ) ;
	CreateDirectory( "E:\\SAVES\\STARFIGHTERX", NULL ) ;

	strcpy(engine.userHomeDirectory, "E:\\SAVES\\STARFIGHTERX\\");

	#if LINUX
		setupUserHomeDirectory();
	#endif

	/* Initialize the SDL library */
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK) < 0) {
		printf("Couldn't initialize SDL: %s\n", SDL_GetError());
		exit(1);
	}

	currentGame.useSound = 1;
	currentGame.useMusic = 1;
	currentGame.fullScreen = 0;

	char filename[PATH_MAX];
	int fullScreen = 0, useSound = 1, useMusic = 1;

	FILE *fp;
	sprintf(filename, "%sconf", engine.userHomeDirectory);
	fp = fopen(filename, "rb");

	if (fp != NULL)
	{
		fscanf(fp, "%d %d %d", &fullScreen, &useSound, &useMusic);
		fclose(fp);
	}

	currentGame.fullScreen = fullScreen;
	currentGame.useSound = useSound;
	currentGame.useMusic = useMusic;

	SDL_WM_SetCaption("Project: Starfighter", "starfighter");
	//SDL_WM_SetIcon(loadImage("gfx/alienDevice.png"), NULL);

	if (currentGame.fullScreen)
		graphics.screen = SDL_SetVideoMode(800, 600, 16, SDL_HWPALETTE|SDL_FULLSCREEN);
	else
		graphics.screen = SDL_SetVideoMode(800, 600, 0, SDL_HWPALETTE);

	if (graphics.screen == NULL) {
		printf("Couldn't set 800x600x16 video mode: %s\n", SDL_GetError());
		exit(1);
	}

	if (engine.useAudio)
	{
		if (Mix_OpenAudio(22050, AUDIO_S16, engine.useAudio, 1024) < 0)
		{
			printf("Warning: Couldn't set 22050 Hz 16-bit audio - Reason: %s\n", Mix_GetError());
			printf("Sound and Music will be disabled\n");
			engine.useAudio = 0;
		}
	}

	SDL_ShowCursor(SDL_DISABLE);
	SDL_EventState(SDL_MOUSEMOTION, SDL_DISABLE);

	for ( int i = 0 ; i < SDL_NumJoysticks() ; i++ )
	{
		joysticks[i] = SDL_JoystickOpen( i ) ;
	}

	SDL_JoystickEventState( SDL_ENABLE ) ;

	SDL_EventState(SDL_JOYHATMOTION, SDL_IGNORE);

}

/*
Removes [hopefully] all the resources that has been
loaded and created during the game. This is called by
atexit();
*/
void cleanUp()
{
	printf("Cleaning Up...\n");
	printf("Freeing Graphics\n");
	graphics.freeGraphics();
	printf("Freeing Background\n");
	SDL_FreeSurface(graphics.background);
	printf("Freeing Sounds\n");
	freeSound();
	printf("Resetting Lists\n");
	resetLists();
	delete(engine.bulletHead);
	delete(engine.explosionHead);
	delete(engine.collectableHead);
	delete(graphics.bufferHead);

	printf("Freeing Font\n");
	for (int i = 0 ; i < MAX_FONTSHAPES ; i++)
	{
		if (graphics.fontShape[i] != NULL)
			SDL_FreeSurface(graphics.fontShape[i]);
	}

	printf("Removing Mod\n");
	char filename[PATH_MAX];
	strcpy(filename, "");
	
	sprintf(filename, "%smusic.mod", engine.userHomeDirectory);
	remove(filename);

	sprintf(filename, "%smusic.s3m", engine.userHomeDirectory);
	remove(filename);

	if (engine.useAudio)
	{
		printf("Closing Audio\n");
		Mix_CloseAudio();
	}

	// Save the config using current settings
	FILE *fp;
	sprintf(filename, "%sconf", engine.userHomeDirectory);
	fp = fopen(filename, "wb");
	if (fp != NULL)
	{
		fprintf(fp, "%d %d %d\n", currentGame.fullScreen, currentGame.useSound, currentGame.useMusic);
		fclose(fp);
	}
	else
	{
		printf("Error saving config\n");
	}

	SDL_Quit();
	printf("Done Cleaning Up...\nThank You for playing Starfighter\n");
}

