//#include "allegro.h"
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/timeb.h>
//#include <sys/time.h>
#include "prototypes.h"
#include "vmu.xpm"
#include "vmu.5.xpm"
#include "memory.h"
#include "time.h"
#include <xtl.h>

unsigned short vmuscreen[48*48+100] ;
int sfreq = -1 ;

extern unsigned short gDebugMode,gFGColor,gBGColor;

void error_msg(char *fmt, ...)
{
  //va_list va;
  //va_start(va, fmt);
  //vfprintf(stderr, fmt, va);
  //fputc('\n', stderr);
  //va_end(va);
}



			  
int screeninited=0;

void vmputpixel(int x, int y, int p)
{
	int i;
   char s[256];
   unsigned short c;

   if ( !screeninited )
   {
	   for ( i = 0; i < sizeof(vmuscreen)/2 ; i++ )
	   {
		   *(vmuscreen+i) = gBGColor ;
	   }
	   screeninited = 1 ;
   }
   c=(p&1)?gFGColor:gBGColor;
   *(vmuscreen + (y*48) + x) = c ;
   //putpixel(vmuscreen,off_x+x     ,off_y+y     ,c);

}

void xbox_put_image( unsigned char *pix, int spitch ) ;

extern int didframe ;

void low_redrawlcd()
{
   //static int frame=0;

   //if(gDebugMode)
      //textprintf_centre(screen, font, SCREEN_W/2, 20, gFGColor,"Frame %d",frame++);
   xbox_put_image( (unsigned char*)vmuscreen, 48*2 ) ;
   didframe = 1 ;
}

void redrawlcd()
{
  low_redrawlcd();
}

#define KEY_UP 0
#define KEY_DOWN 1
#define KEY_LEFT 2
#define KEY_RIGHT 3
#define KEY_Z 4
#define KEY_X 5
#define KEY_S 6
#define KEY_M 7

#define JOY_UP 0x01
#define JOY_DOWN 0x02
#define JOY_LEFT 0x04
#define JOY_RIGHT 0x08
#define JOY_A     0x10
#define JOY_B     0x20
#define JOY_SLEEP 0x40
#define JOY_MODE  0x80
#define JOY_RESET 0x100


int xbox_check_events() ;
unsigned int xbox_read_port( int which ) ;
void resetcpu();

int checkevents()
{

   static old_up=0;
   static old_dn=0;
   static old_rt=0;
   static old_lt=0;
   static old_a=0;
   static old_b=0;
   static old_m=0;
   static old_s=0;
   char key[256];
   unsigned int portval ;
   int finish ;

   //Sleep( 1 ) ;

	finish = xbox_check_events() ;
	portval = xbox_read_port( 0 ) ;

	memset( key, 0, sizeof(key) ) ;

	if ( portval & JOY_UP )
		key[KEY_UP] = 1 ;
	if ( portval & JOY_DOWN )
		key[KEY_DOWN] = 1 ;
	if ( portval & JOY_LEFT )
		key[KEY_LEFT] = 1 ;
	if ( portval & JOY_RIGHT )
		key[KEY_RIGHT] = 1 ;
	if ( portval & JOY_A )
		key[KEY_Z] = 1 ;
	if ( portval & JOY_B )
		key[KEY_X] = 1 ;
	if ( portval & JOY_SLEEP )
		key[KEY_S] = 1 ;
	if ( portval & JOY_MODE )
		key[KEY_M] = 1 ;
	if ( portval & JOY_RESET )
		resetcpu() ;

   if(key[KEY_UP]   &&!old_up) {      
         old_up=1;
		   keypress(0);
   }
   if(key[KEY_DOWN] &&!old_dn) {      
         old_dn=1;
         keypress(1);
   }
   if(key[KEY_LEFT] &&!old_lt) {      
         old_lt=1;
         keypress(2);
   }
   if(key[KEY_RIGHT]&&!old_rt) {      
         old_rt=1;
         keypress(3);
   }
   if(key[KEY_Z]    &&!old_a) {      
         old_a=1;
         keypress(4);
   }
   if(key[KEY_X]    &&!old_b) {      
         old_b=1;
         keypress(5);
   }
   if(key[KEY_S]    &&!old_s) {      
         old_s=1;
         keypress(6);
   }
   if(key[KEY_M]    &&!old_m) {      
         old_m=1;
         keypress(7);
   }
   //if(key[KEY_ESC])
      //exit(0);

   if(!key[KEY_UP]   &&old_up) {      
         old_up=0;
         keyrelease(0);
   }
   if(!key[KEY_DOWN] &&old_dn) {      
         old_dn=0;
         keyrelease(1);
   }
   if(!key[KEY_LEFT] &&old_lt) {      
         old_lt=0;
         keyrelease(2);
   }
   if(!key[KEY_RIGHT]&&old_rt) {      
         old_rt=0;
         keyrelease(3);
   }
   if(!key[KEY_Z]    &&old_a) {      
         old_a=0;
         keyrelease(4);
   }
   if(!key[KEY_X]    &&old_b) {      
         old_b=0;
         keyrelease(5);
   }
   if(!key[KEY_S]    &&old_s) {      
         old_s=0;
         keyrelease(6);
   }
   if(!key[KEY_M]    &&old_m) {      
         old_m=0;
         keyrelease(7);
   }
   return finish ;
}


int gettimeofday(struct timeval *tv)
{
  struct _timeb timebuffer;
  _ftime( &timebuffer );
  tv->tv_sec = timebuffer.time;
  tv->tv_usec = timebuffer.millitm*1000;
  return 0;
}

typedef struct timeval ttt ;

unsigned int xbox_get_throttle() ;

void waitforevents(struct timeval *t)
{
   struct timeval now,dest;

   return ;
   if(!t)
      return;
   //if ( ( t->tv_sec > 0 ) || ( t->tv_usec > 0 ) )
   //{
	   //now.tv_sec = 0 ;
   //}
   gettimeofday(&dest, NULL);
   dest.tv_sec+=t->tv_sec;
   dest.tv_usec+=t->tv_usec;
   while(dest.tv_usec>1000000)
   {
      dest.tv_sec++;
      dest.tv_usec-=1000000;
   }         
   gettimeofday(&now, NULL);
//   printf("now=%d:%d\ndest=%d:%d\n",now.tv_sec,now.tv_usec,dest.tv_sec,dest.tv_usec);
   while(!xbox_get_throttle())
   {
      gettimeofday(&now, NULL);
      if(now.tv_sec>dest.tv_sec)
         return;
      if(now.tv_sec==dest.tv_sec && now.tv_usec>=dest.tv_usec)
         return;
   }      
}

void waitforevents2(struct timeval *tv)
{
	DWORD millis = 0 ;

  if(tv != NULL)
    millis = tv->tv_sec * 1000 + tv->tv_usec / 1000;
  Sleep( millis ) ;
#if 0
   ttt now,dest;

   if(!t)
      return;
   gettimeofday(&dest, NULL);
   dest.tv_sec+=t->tv_sec;
   dest.tv_usec+=t->tv_usec;
   while(dest.tv_usec>1000000)
   {
      dest.tv_sec++;
      dest.tv_usec-=1000000;
   }         
   gettimeofday(&now, NULL);
//   printf("now=%d:%d\ndest=%d:%d\n",now.tv_sec,now.tv_usec,dest.tv_sec,dest.tv_usec);
   while(1)
   {
      gettimeofday(&now, NULL);
      if(now.tv_sec>dest.tv_sec)
         return;
      if(now.tv_sec==dest.tv_sec && now.tv_usec>=dest.tv_usec)
         return;
   }      
#endif
}


void sound(int freq)
{
	xbox_feed_stream( NULL, freq ) ;
	//if ( ( didframe == 1 ) && ( freq != -1 ) )
	{
		sfreq = freq ;
		didframe = 0 ;
	}
}
