#define KEYBOARDMENU 0
#ifdef __cplusplus
extern "C" {
#endif
int* errno()
{
	return 0;
}

#ifdef __cplusplus
}
#endif

#define CHECKRUMBLECHEATS
#define NATIVEASPECT
#define CHECKGAMESCREENSIZE
#define BOOTXBOX
#define FLOATSTICK
//#define WEBSITE
#define EMU_VERSION 0
#define CHECKED_RESET_SOFTEN
#define NEWSAVEPOS2
#define SHOWFPS
#define CHECKAVAILROMS
#define FRSPRITES
#define XBOX_COMPAT_NAME
#define SAVE_SCREENSTATE
#define CHECKED_RESET_FLICKER
#define HARDFILTER_APPLY
#define NO_EXTRA_ZIP
#define NEWSAVEPOS

#define RELAXCASE
#define CHEAT5000
#define USE_NETPLAY

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <XBSound.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>
#include <vector>
//#include "zlib.h"
//#include "unzip.h"
#include "debugclient.h"
#include "Mp3Player.h"
#include "undocumented.h"
#include "iosupport.h"
#include "panel.h"
#include "fonthelper.h"
#include "plaything.h"
#include "smb++.h"
#include "custom_launch_params.h"
#include "colormap.h"
#include "arrow.h"
#include "numpad.h"
#include "png.h"
#include "lightgun.h"
#include "keyboard_api.h"
#include "gamescreen.h"
//#include "snes9x/snes9x.h"

//#define NEED_CDDA
//#define USE_DEBUGCLIENT

#define PAUSE_FREEZE_FILE (1 << 7)

void WinSetDefaultValues () ;
int emulating ;
extern unsigned int joypads[5] ;
void S9xSetPause (unsigned int mask);
extern "C" unsigned char S9xFreezeGame (const char *filename);
extern "C" unsigned char S9xUnfreezeGame (const char *filename);
void S9xClearPause (unsigned int mask);
extern "C" void S9xMovieStop( unsigned char suppress_message) ;
extern "C" void S9xSoftReset() ;
unsigned char SetupSound( long rate, unsigned char sixteen_bit, unsigned char stereo ) ;

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char bool8 ;

struct SSettings{
    /* CPU options */
    bool8  APUEnabled;
    bool8  Shutdown;
    uint8  SoundSkipMethod;
    long   H_Max;
    long   HBlankStart;
    long   CyclesPercentage;
    bool8  DisableIRQ;
    bool8  Paused;
    bool8  ForcedPause;
    bool8  StopEmulation;
    bool8  FrameAdvance;

    /* Tracing options */
    bool8  TraceDMA;
    bool8  TraceHDMA;
    bool8  TraceVRAM;
    bool8  TraceUnknownRegisters;
    bool8  TraceDSP;

    /* Joystick options */
    bool8  SwapJoypads;
    bool8  JoystickEnabled;

    /* ROM timing options (see also H_Max above) */
    bool8  ForcePAL;
    bool8  ForceNTSC;
    bool8  PAL;
    uint32 FrameTimePAL;
    uint32 FrameTimeNTSC;
    uint32 FrameTime;
    uint32 SkipFrames;

    /* ROM image options */
    bool8  ForceLoROM;
    bool8  ForceHiROM;
    bool8  ForceHeader;
    bool8  ForceNoHeader;
    bool8  ForceInterleaved;
    bool8  ForceInterleaved2;
    bool8  ForceNotInterleaved;

    /* Peripherial options */
    bool8  ForceSuperFX;
    bool8  ForceNoSuperFX;
    bool8  ForceDSP1;
    bool8  ForceNoDSP1;
    bool8  ForceSA1;
    bool8  ForceNoSA1;
    bool8  ForceC4;
    bool8  ForceNoC4;
    bool8  ForceSDD1;
    bool8  ForceNoSDD1;
    bool8  MultiPlayer5;
    bool8  Mouse;
    bool8  SuperScope;
    bool8  SRTC;
    uint32 ControllerOption;
    
    bool8  ShutdownMaster;
    bool8  MultiPlayer5Master;
    bool8  SuperScopeMaster;
    bool8  MouseMaster;
    bool8  SuperFX;
    bool8  DSP1Master;
    bool8  SA1;
    bool8  C4;
    bool8  SDD1;
	bool8  SPC7110;
	bool8  SPC7110RTC;
	bool8  OBC1;
    /* Sound options */
    uint32 SoundPlaybackRate;
    bool8  TraceSoundDSP;
    bool8  Stereo;
    bool8  ReverseStereo;
    bool8  SixteenBitSound;
    int    SoundBufferSize;
    int    SoundMixInterval;
    bool8  SoundEnvelopeHeightReading;
    bool8  DisableSoundEcho;
    bool8  DisableSampleCaching;
    bool8  DisableMasterVolume;
    bool8  SoundSync;
    bool8  InterpolatedSound;
    bool8  ThreadSound;
    bool8  Mute;
    bool8  NextAPUEnabled;
    uint8  AltSampleDecode;
    bool8  FixFrequency;
    
    /* Graphics options */
    bool8  SixteenBit;
    bool8  Transparency;
    bool8  SupportHiRes;
    bool8  Mode7Interpolate;

    /* SNES graphics options */
    bool8  BGLayering;
    bool8  DisableGraphicWindows;
    bool8  ForceTransparency;
    bool8  ForceNoTransparency;
    bool8  DisableHDMA;
    bool8  DisplayFrameRate;
    bool8  DisableRangeTimeOver; /* XXX: unused */

    /* Others */
    bool8  NetPlay;
    bool8  NetPlayServer;
    char   ServerName [128];
    int    Port;
    bool8  GlideEnable;
    bool8  OpenGLEnable;
    int32  AutoSaveDelay; /* Time in seconds before S-RAM auto-saved if modified. */
    bool8  ApplyCheats;
    bool8  TurboMode;
    uint32 TurboSkipFrames;
    uint32 AutoMaxSkipFrames;
    
/* Fixes for individual games */
    bool8  StarfoxHack;
    bool8  WinterGold;
    bool8  BS;	/* Japanese Satellite System games. */
    bool8  DaffyDuck;
    uint8  APURAMInitialValue;
    bool8  SampleCatchup;
	bool8  JustifierMaster;
	bool8  Justifier;
	bool8  SecondJustifier;
	int8   SETA;
    bool8  TakeScreenshot;
    int8   StretchScreenshots;
	uint16 DisplayColor;
    int    SoundDriver;
    int    AIDOShmId;
    bool8  SDD1Pack;
	bool8  NoPatch;
	bool8  ForceInterleaveGD24;
#ifdef DEBUG_MAXCOUNT
    unsigned int MaxCount;
#endif
};
extern struct SSettings Settings;


#include "writepng.h"

void _2xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void _2xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagle(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagleScanline(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super2xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super2xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Scale2x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScale(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScaleScanline(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Eagle(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void EagleScanline(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);

void Simple2x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanlines) ;
void AdMame2x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanline) ;

unsigned int psxfix_ff9 ;
unsigned int xbox_get_pitch();
unsigned char * xbox_get_screen_buffer() ;
int xbox_read_sector_type( unsigned int sector, unsigned int sector_type ) ;
void sprintfx( const char *fmt, ... );
int psx_WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) ;
extern int cdOpenCase;

char gxmsg[2000] ;


#ifdef __cplusplus
}
#endif

#pragma warning(disable:4244)
#pragma warning(disable:4018)
#pragma warning(disable:4101)

char *ASPECT_RATIO_NAMES[] = { "None", "Default (Best)", "SNES-TV" } ;
float ASPECT_RATIOS[] = { 1.0f, 1.0f, 320.0/240.0 } ;
#define NUM_ASPECT_RATIOS 3

#define DEFAULT_PATTERN_X 320
#define DEFAULT_PATTERN_Y 240


#define STATEMEM_SIZE 0xA0000
#define STATEMEM_CUTOFF 1024*1024*10

#define PLATFORM_NAME "SNES"
#define PLATFORM_SAV L"SNESSAV"
#define READING_ROMS_STRING L"Reading snesroms directory...please wait."
#define PLATFORM_INI "snes9xbox.ini"
#define PLAYTHING_INI "plaything.cfg"
#define PLATFORM_MEMORY_POINTER NULL
#define THEMEMUSIC "D:\\PSXTHEME.MP3"
#define PLATFORM_FILE_DIR m_defaultRomDir
#define DEFAULT_PARENT_DIR "D:\\SNESROMS\\*"
#define CD_BUF_SECTORS 1
#define CD_DATA_BUFFER_SIZE CD_BUF_SECTORS*2352
#define MLINE(x) ((float)( 80 + (( pmenuParams->lineHeight-2 ) * (x)) ))
#define PROJECTILE_DEF 4 
#define DEFAULT_SKIN "default_snes9xbox"
#define DEFAULT_SKIN_DIR "D:\\EMUSKINS"
#define DEFAULT_SAVE_PATH "E:\\SAVES\\SNES9XBOX"
#define MAIN_MENU_STRING L"SNES9XBox Main Menu"
#define EMU_RECORDING_SIZE ( sizeof(DWORD)*4*60*60*10 )
#define CD_SECS 60
#define CD_FRAMES 75


int CODE_LENGTHS[] = { 12 } ;

#define CONSOLE_MEMORY_SIZE 0x20000
unsigned char *m_memory_locations[] = { (unsigned char*)NULL  } ;
unsigned int  m_memory_sizes[] = { 0x20000 } ;
#define NUM_MEMORY_LOCATIONS 1

byte keyboard_keystate[256] ;


typedef struct
{

	unsigned int mapping ;
	unsigned int moves[32] ;
	unsigned char endmove ;
	unsigned char delay ;
	unsigned char currmove ;
	unsigned char currdelay ;
} COMBO ;

typedef struct
{
	unsigned int analog_sensitivity ;
	unsigned int emu_buttons[32] ;
	unsigned char emu_buttons_autofire[32] ;
	unsigned char emu_buttons_autofire_last[32] ;
	unsigned int emu_buttons_definition[32] ;
	unsigned int sfx_vol_up ;
	unsigned int sfx_vol_down ;
	unsigned int bgm_vol_up ;
	unsigned int bgm_vol_down ;
	unsigned int throttle ;
	unsigned int save_state ;
	unsigned int load_state ;
	unsigned int change_save_slot ;
	unsigned int screenshot ;
	unsigned int options_menu ;
	unsigned int change_gfx_filter;
	unsigned int toggle_bgm ;
	unsigned int start_recording ;
	unsigned int stop_recording ;
	unsigned int start_playing ;
	unsigned int stop_playing ;
	unsigned int capture_mode ;
	unsigned int virtual_keyboard ;
	unsigned int text_browser ;
	float        stick_sensitivity ;
	unsigned int rewind ;
	unsigned int toggle_rewind ;
	unsigned int toggle_slowdown ;
	COMBO combos[10] ;

} MAPPINGS ;

typedef struct _PLAYTHING_CONFIG
{
	SPRITE_PARAMS sprites[20] ;
	EFFECT_PARAMS effects[3] ;

} PLAYTHING_CONFIG ;

typedef struct _MENU_PARAMS
{
	char bkg[100] ;
	CPanel *panel ;
	int  transparency ;
	int  borderWidth ;
	int  halign ;
	int  valign ;
	int  offsetx ;
	int  offsety ;
	int  maxTextWidth ;
	int  maxNumLines ;
	DWORD normalColor ;
	DWORD selectedColor ;
	DWORD selectedAndNotedColor ;
	DWORD notedColor ;
	DWORD selectBarColor ;
	unsigned int  size ;
	unsigned int  lineHeight; 
	int screenshotX ;
	int screenshotY ;
	int screenshotW ;
	int screenshotH ;
	int screenshotTransparency ;
	int animationDelay ;

	PLAYTHING_CONFIG ptConfig ;

} MENU_PARAMS ;

typedef struct _SKIN_PARAMS
{
	char loadEmuSplash[100] ;
	char loadGameSplash[100] ;
	char menuMoveSound[100] ;
	char menuCancelSound[100] ;
	char menuSelectSound[100] ;
	char menuBkgMusic[100] ;
	char font[100] ;
	int  fade ;
	int  loopbgm ;
	int transition ;

	MENU_PARAMS mainMenu ;
	MENU_PARAMS gameSelectMenu ;
	MENU_PARAMS otherMenu ;
	MENU_PARAMS popupMenu ;
	MENU_PARAMS loadingMenu ;

} SKIN_PARAMS ;

typedef struct _BUTTON_DEFINITION
{
	char name[40] ;
	unsigned int  value ;
} BUTTON_DEFINITION ;


#define XBOX_DPAD_UP          0x00000001
#define XBOX_DPAD_DOWN        0x00000002
#define XBOX_DPAD_LEFT        0x00000004
#define XBOX_DPAD_RIGHT       0x00000008
#define XBOX_START            0x00000010
#define XBOX_BACK             0x00000020
#define XBOX_LEFT_THUMB       0x00000040
#define XBOX_RIGHT_THUMB      0x00000080

#define XBOX_A                0x00000100
#define XBOX_B                0x00000200
#define XBOX_X                0x00000400
#define XBOX_Y                0x00000800
#define XBOX_BLACK            0x00001000
#define XBOX_WHITE            0x00002000
#define XBOX_LEFT_TRIGGER     0x00004000
#define XBOX_RIGHT_TRIGGER    0x00008000

#define XBOX_LTHUMB_UP        0x00010000
#define XBOX_LTHUMB_DOWN      0x00020000
#define XBOX_LTHUMB_LEFT      0x00040000
#define XBOX_LTHUMB_RIGHT     0x00080000

#define XBOX_RTHUMB_UP        0x00100000
#define XBOX_RTHUMB_DOWN      0x00200000
#define XBOX_RTHUMB_LEFT      0x00400000
#define XBOX_RTHUMB_RIGHT     0x00800000


	BUTTON_DEFINITION g_xboxButtonDefinitions[] = {
		{ "DPad Up", XBOX_DPAD_UP },
		{ "DPad Down", XBOX_DPAD_DOWN },
		{ "DPad Left", XBOX_DPAD_LEFT },
		{ "DPad Right", XBOX_DPAD_RIGHT },
		{ "Start", XBOX_START },
		{ "Back", XBOX_BACK },
		{ "Left Thumb", XBOX_LEFT_THUMB },
		{ "Right Thumb", XBOX_RIGHT_THUMB },
		{ "A", XBOX_A },
		{ "B", XBOX_B },
		{ "X", XBOX_X },
		{ "Y", XBOX_Y },
		{ "Black", XBOX_BLACK },
		{ "White", XBOX_WHITE },
		{ "LTrigger", XBOX_LEFT_TRIGGER },
		{ "RTrigger", XBOX_RIGHT_TRIGGER },
		{ "LThumb Up", XBOX_LTHUMB_UP },
		{ "LThumb Down", XBOX_LTHUMB_DOWN },
		{ "LThumb Left", XBOX_LTHUMB_LEFT },
		{ "LThumb Right", XBOX_LTHUMB_RIGHT },
		{ "RThumb Up", XBOX_RTHUMB_UP },
		{ "RThumb Down", XBOX_RTHUMB_DOWN },
		{ "RThumb Left", XBOX_RTHUMB_LEFT },
		{ "RThumb Right", XBOX_RTHUMB_RIGHT },
		{ "Nothing", 0 },
	} ;

#define NUM_XBOX_BUTTONS ( sizeof( g_xboxButtonDefinitions ) / sizeof(BUTTON_DEFINITION) )

#define	JOY_R        0x0010
#define	JOY_L        0x0020
#define	JOY_X        0x0040
#define	JOY_A        0x0080
#define	JOY_RIGHT    0x0100
#define	JOY_LEFT     0x0200
#define	JOY_DOWN     0x0400
#define	JOY_UP       0x0800
#define	JOY_START    0x1000
#define	JOY_SELECT   0x2000
#define	JOY_Y        0x4000
#define	JOY_B        0x8000
#define JOY_RESET    0x10000

	BUTTON_DEFINITION g_emuButtonDefinitions[] = {
		{ "A", JOY_A },
		{ "B", JOY_B },
		{ "X", JOY_X },
		{ "Y", JOY_Y },
		{ "L", JOY_L },
		{ "R", JOY_R },
		{ "Up", JOY_UP },
		{ "Down", JOY_DOWN },
		{ "Left", JOY_LEFT },
		{ "Right", JOY_RIGHT },
		{ "Start", JOY_START },
		{ "Select", JOY_SELECT },
		{ "Reset", JOY_RESET },
		{ "Nothing", 0 },
	} ;

#define NUM_EMU_BUTTONS ( sizeof( g_emuButtonDefinitions ) / sizeof(BUTTON_DEFINITION) )



#define DEFAULT_BUTTON1  XBOX_B
#define DEFAULT_BUTTON2  XBOX_A
#define DEFAULT_BUTTON3  XBOX_Y
#define DEFAULT_BUTTON4  XBOX_X
#define DEFAULT_BUTTON5  XBOX_LEFT_TRIGGER
#define DEFAULT_BUTTON6  XBOX_RIGHT_TRIGGER
#define DEFAULT_BUTTON7  XBOX_DPAD_UP
#define DEFAULT_BUTTON8  XBOX_DPAD_DOWN
#define DEFAULT_BUTTON9  XBOX_DPAD_LEFT
#define DEFAULT_BUTTON10 XBOX_DPAD_RIGHT
#define DEFAULT_BUTTON11 XBOX_START
#define DEFAULT_BUTTON12 XBOX_BACK
#define DEFAULT_BUTTON13 0
#define DEFAULT_BUTTON14 0
#define DEFAULT_BUTTON15 0
#define DEFAULT_BUTTON16 0
#define DEFAULT_BUTTON17 0
#define DEFAULT_BUTTON18 0
#define DEFAULT_BUTTON19 0
#define DEFAULT_BUTTON20 0
#define DEFAULT_BUTTON21 0
#define DEFAULT_BUTTON22 0
#define DEFAULT_BUTTON23 0
#define DEFAULT_BUTTON24 0
#define DEFAULT_BUTTON25 0
#define DEFAULT_BUTTON26 0
#define DEFAULT_BUTTON27 0
#define DEFAULT_BUTTON28 0
#define DEFAULT_BUTTON29 0
#define DEFAULT_BUTTON30 0
#define DEFAULT_BUTTON31 0
#define DEFAULT_BUTTON32 0


typedef struct _cheat_code {
	char code[20] ;
	byte type ;
	UINT32 adr ;
	UINT32 val ;
	byte   enabled ;
	char desc[100] ;
} CHEAT_CODE;

typedef struct _NETPLAY_SERVER {
	char ip[16] ; 
} NETPLAY_SERVER;

typedef struct _favoritestruct {
	char filename[MAX_PATH] ;
} FAVORITE ;



//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual void    InitializeEmuSpecific();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx, int isFavorite, int forceConfig );
	virtual void    cleanupConsole( ) ;
	virtual int     handleEvents() ;
	virtual int     init_texture() ;
	virtual BOOL    SetRefreshRate(INT iRefreshRate);
	virtual int		init_white_texture();
	virtual int		render_to_texture(int w, int h, int pitch, unsigned char *surface) ;
	virtual void	FindAvailRoms(char *dir) ;
	void			renderMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, int firstisfirst, int lastislast ) ;
	int             renderMenuTextWrapper( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, CPanel *panel, int menuChoice, int dualColumn, int colSpacing ) ;
	void            renderDualMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, int colSpacing ) ;
	int             getValuePopup( char *title, int oldValue, int minval, int maxval, CPanel *panel );
	virtual void    doStartSearchMenu() ;
	virtual void	saveKeys( char *keyfile ) ;
	virtual void	loadKeys( char *keyfile ) ;
	virtual void    doCodeListMenu() ;
	virtual int     receiveNetworkData( );
	virtual void    xboxStartRecording() ;
	virtual void    xboxStopRecording() ;
	virtual void    xboxStartPlaying() ;
	virtual int     handleExtension( char *ext, char *newfilename, char *zipfilename, int *zipnumber )  ;
	virtual void    xboxStopPlaying() ;
	virtual void    xboxOptionsMenu() ;
	virtual void    doChangeHWFilter() ;
	virtual void    doChangeSWFilter() ;
	virtual void    doPlaythingClear( );
#ifdef LIGHTGUN
	virtual void    doCalibrateLightgun( );
#endif
	virtual void    saveSettings( char *filename );
	virtual int     loadSettings( char *filename );
	virtual void    doSearchGameshark() ;
	virtual void    doAutofireConfig( int port );
	virtual void    doMainMenu() ;
	virtual void    copyOldSaves();
	virtual int     validateCode( char *code, CHEAT_CODE *ccode, int codetype ) ;
	virtual void    checkGeneralEvents() ;
	void            renderScreenKeyboard( );
	virtual void    getKeyboardString( char *buf, int bufsize ) ;
	void            musicControlMenu( CPanel *panel );
	void            doDefaultDirs();
	virtual void    loadControllerSettings( char *buf ) ;
	virtual void    saveControllerSettings( FILE *outfile ) ;
	virtual void    doManageCheatCode( int selected );
	virtual void    doConfigureSkin() ;
	virtual void    doBrowseScreenshots( ) ;
	virtual void    performEmuSpecificOption( int start, int menuChoice ) ;
	int             addEmuSpecificOptions( int start ) ;
	virtual int		showScreenshot( int screenNum, int currSelection, int onlyFavorites, MENU_PARAMS *menu ) ;
	virtual void    saveGameSpecificSettings() ;
	virtual void    doGraphicsFiltering() ;
	virtual void    doSelectColor( DWORD *pColor, MENU_PARAMS *menuParams );
	virtual void    doTransition( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
	virtual void    updateEmuSpecificCheats( ) ;
	virtual void    emuLaunch( unsigned int gameSelected, unsigned int isFavorite, int forceConfig ) ;
	virtual void    getNewRoot( char *szRoot) ;
	void            loadMostRecentSaveState( );
	virtual void    doChangeVideoMode() ;
	virtual void    doSelectTransition() ;
	unsigned int    getNewDefinition( unsigned int oldMapping );
	unsigned int    doSelectGame( int onlyFavorites, int canChangeDir, int getPath=0 ) ;
	virtual void    doConfigureGame( char *settingsfile, char *keysfile ) ;
	virtual void    SetupPlaything( );
	virtual void    doSelectBackground( char *bkgfile, CPanel *ppanel ) ;
	virtual void    doSelectSound( char *soundfile, CXBSound *psound ) ;
	virtual void    doSelectBGM( char *bgmfile ) ;
	virtual void    doSelectFont( char *fontfile ) ;
	virtual void    doConfigureSkinMenu( MENU_PARAMS *menuparams, char *title ) ;
	virtual int     selectFile( char *filename, char *dirname, int canchangedir, int selectdir, int refreshlist, int initlist  );
	virtual void    viewPlaylist( );
	virtual void    managePlaylists( );
	virtual void    editPlaylist( char *filename );
	virtual void    doMenuBackgroundSettings( MENU_PARAMS *menuparams) ;
	virtual void    doMenuTextSettings( MENU_PARAMS *menuparams) ;
	virtual void    doMenuSpriteSettings( MENU_PARAMS *menuparams) ;
	virtual void    doScreenshotSize( MENU_PARAMS *menu );
	virtual void    doSavePlaything() ;
	virtual int     setupNetplay() ;
	virtual void    doLoadPlaything() ;
	virtual void    renderPopupBkg( int numlines ) ;
	unsigned int    getNewMapping( unsigned int oldMapping ) ;
	virtual void    doConfigureControllers() ;
	virtual void    doConfigureController( int port ) ;
	virtual void    doEmulatorDefinitions( int port ) ;
	virtual void    doJoypadMappings( int port ) ;
	unsigned int    getNewEmuMapping( unsigned int port, unsigned int combo, unsigned int oldMapping );
	virtual void    doChangeCombo( int port, int combo );
	virtual void    doChangeComboMoves( int port, int combo );
	virtual void    doComboConfig( int port );
	virtual void    doGameJoypadMappings( int port ) ;
	virtual void    doUIJoypadMappings( int port ) ;
	void            doAddGamesharkCodes( char *filepos, char *codedesc);
	void            doShowGamesharkCodes( int which);
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCodeListMenu2() ;
	virtual int     pollXBoxControllers( );
	virtual int     pollNetworkControllers( );
	virtual void    doAddFoundCodes2() ;
	virtual void    changeMenu( MENU_PARAMS *menuparams1, MENU_PARAMS *menuparams2 ) ;
	virtual void    doConfigureSprite( MENU_PARAMS *menuparams, int which ) ;
	virtual void    doConfigureEffects(MENU_PARAMS *menuparams, int which) ;
	virtual void    doEditCode2( int selected, int numpositions, int codetype  ) ;
	virtual void    doContinueSearchMenu2() ;
	virtual void	popupMsg( char *msg, CPanel *panel, int onetime=0 ) ;
	virtual void    doCheatMenu() ;
	virtual void    doEmulatorOptions() ;
	virtual void    doFontSize() ;
	virtual void    xboxSaveState() ;
	virtual void    xboxThrottle( int throttle ) ;
	virtual void    xboxLoadState() ;
	virtual void    xboxChangeFilter() ;
	virtual void    viewTextFile( char *filename ) ;
	virtual void    doSettings2();
	virtual void    createLocal( char *filename, char *newfilename, char* zipfilename, int *zipnumber );
	virtual void    applyHardwareFilter( ) ;
	virtual void    xboxScreenshot() ;
	virtual void    xboxChangeState() ;
	virtual void    doLoadSkin( char *skinname, int forceRoot ) ;
	virtual void    doSaveSkin( ) ;
	virtual void    loadSkinMenuSettings( char *szbuf, char *basesection, MENU_PARAMS *menu );
	virtual void    saveSkinMenuSettings( FILE *outfile, char *basesection, MENU_PARAMS *menu );
	virtual void    doSelectSkin() ;
	virtual void    doLoadIni( int forceRoot ) ;
	virtual void    doSaveIni() ;
	virtual void    doLoadEmuSpecificIni( char *szbuf) ;
	virtual void    doSaveEmuSpecificIni( FILE *outfile ) ;
	virtual void    doSaveConfig() ;
	virtual void    doScreenSize(int istext ) ;
	virtual void    doNetplayOptions();
	virtual void    addNewNetplayServer( );
	virtual void    saveFavorites();
	virtual void    addFavorite( char *favorite ) ;
	virtual void    removeFavorite( unsigned int whichfav) ;
	virtual void    loadFavorites();
	virtual int     yesNoMenu( char *msg, CPanel *panel ) ;
	virtual int     selectNetplayServer() ;
	virtual void    doTextOffset() ;
	void            ClearScreen() ;
	void            doSelectMemcards();
	virtual void    doConfiguration() ;
	virtual void    updateCheats() ;
	virtual void    updateCheats2() ;
	virtual void    processEmu( BOOL render ) ;
	virtual void    fillPresentationParams() ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    doUtilities( );
	virtual void	viewCheatMatches();
	virtual void	viewMemoryDump( unsigned int offset );
	virtual void	doRumbleConfigSelect( int port );
	virtual void	doRumbleConfig( void *rumble );
	virtual void    doHelp( );
	virtual void    doSettings( );
	virtual void    doCheatCodes( );
	virtual void    doGameUtilities( );
	virtual int     selectState( );
	virtual void    deleteSaveFiles( int which, int onlyFavorites ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip( char *hugozipfile ) ;
	virtual void    QuickSort( int start, int end ) ;
	void			MenuBar( int xpos, int ypos, int xlen, int ylen ) ;
	void			ColorBar( int xpos, int ypos, int xlen, int ylen, DWORD color ) ;

	

	DWORD m_xboxControllers[4] ;
	DWORD m_emuControllers[4] ;
	DWORD m_prevEmuControllers[4] ;
	DWORD m_networkEmuControllers[4] ;
	DWORD m_networkStatus ;
	NETPLAY_SERVER m_netplayServers[32] ;
	char m_screenshotDir[MAX_PATH] ;
	int m_defaultScreenshots ;

	D3DXVECTOR2 m_gameVecScale ; 
	D3DXVECTOR2 m_gameVecTranslate ; 
	RECT m_gameRectSource ;

	int m_throttle ;
	SMB m_smb;
	Util m_smbUtil ;
	int m_stateNumber ;
	int  m_smbCdFile ;
	int m_noconfigfile ;
	int  m_bUsingSamba ;
	int m_xboxHFilter ;
	int m_xboxSFilter ;
	char m_smbShare[500] ;
	float m_fFrameTime ;
	UINT32 m_numFrames ;
	int  m_scrollSpeed ; 
	int   keyTime ;
	unsigned int m_pitch ;
	DWORD  m_bRealCD ;
	DWORD  m_currentStartSector ;
	unsigned char *m_ptrCdBuf ;
	char m_cdromID[11]; 
	DWORD m_bitDepth ;
	DWORD m_lineHeight ;
	unsigned int m_biosMode ;
	unsigned int m_vandalFix ;
	unsigned int m_psxfix_Xa ;
	unsigned int m_psxfix_Sio ;
	unsigned int m_psxfix_Mdec ;
	unsigned int m_psxfix_Cdda ;
	unsigned int m_psxfix_Cpu ;
	unsigned int m_psxfix_SpuIrq ;
	unsigned int m_psxfix_VSyncWA ;
	CXBSocket m_sockListener ;
	CDebugClient m_sockNetplay;
	int       m_bNetplay ;
	unsigned int m_bNetworkCD ;
	char m_szSkin[100] ;
	char m_szSkinDir[MAX_PATH] ;
	SKIN_PARAMS m_skin ;
	MENU_PARAMS *pmenuParams ;


	unsigned int m_changedSettings ;
	WCHAR *m_menuText[200] ;

	CPlayThing m_plaything ;



	//PLAYTHING_CONFIG m_ptConfig ;

	PLAYTHING_CONFIG m_ptConfig ;


	MAPPINGS m_mappings[4] ;

	UINT32 topIdx  ;
	UINT32 curr  ;
	CDebugClient m_debugClient ;
	D3DPalette			*m_pd3dPalette ;
	BOOL m_bIsDDrive ;

    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen
	D3DPRESENT_PARAMETERS	m_origPP ;


    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface
	DWORD               m_graphicsFixes ;
	DWORD               m_frameskip, m_framelimit ;
	DWORD				m_numtracks ;
	int m_bMappingCircle ;
	int m_bMappingSquare ;
	int m_bMappingTriangle ;
	int m_bMappingCross ;
	int m_bMappingR1 ;
	int m_bMappingL1 ;
	int m_bMappingR2 ;
	int m_bMappingL2 ;
	int m_bMappingStart ;
	int m_bMappingSelect ;
	int m_bMappingThrottle ;
	CPanel m_pnlBackgroundMain ;
	CPanel m_pnlBackgroundSelect ;
	CPanel m_pnlBackgroundOther ;
	CPanel m_pnlSplashEmu ;
	CPanel m_pnlSplashGame ;
	CPanel m_pnlPopup ;
	CPanel m_pnlGameScreen ;

	CFontHelper m_Font ;

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;
	unsigned char *m_cdDataBuffer ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
		char isDir ;
	} FILENAME ;


	FILENAME *files ;
	FAVORITE *m_filesFavorites ;
	unsigned long m_numFavorites ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;
	DWORD    m_dwStartPause ;
	int		m_nbytes ;
	int		m_nXOffset, m_nYOffset, m_nFontHeight ;
	int		m_namesPerPage ;
	char    m_szCurrentDir[MAX_PATH];
	CIoSupport m_io ;
	HANDLE m_hCdrom ;
	unsigned char m_cdbuffer[2352*4] ;
	gzFile m_cdfile ;
	unsigned char m_memcard1[MAX_PATH] ;
	unsigned char m_memcard2[MAX_PATH] ;
	int m_memcardnum1, m_memcardnum2 ;
	unsigned char m_biosfile[100] ;


	LPDIRECT3DTEXTURE8	m_pd3dBackgroundTexture;
	LPDIRECT3DTEXTURE8	Texture;
	LPDIRECT3DTEXTURE8	WhiteTexture;
	LPD3DXSPRITE			Sprite;
	LPD3DXSPRITE			MenuSprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	byte*				g_pDeltaBuff ;
	int					m_droppedFrames ;	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	Mp3Player			m_mp3player;
	CXBSound			m_sfxMenuMove;
	CXBSound			m_sfxMenuSelect;
	CXBSound			m_sfxMenuCancel;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_bramfile[500] ;
	char				g_cuefile[500] ;
	char				g_rtcfile[500] ;
	char				g_chtfile[500] ;
	char				g_statefile[500] ;
	char				g_keysfile[500] ;
	char				g_settingsfile[500] ;
	FILE                *m_logfile ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;

	int					m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ;


	CHEAT_CODE *m_cheatCodes;

	typedef struct _cheatdbentry 
	{
		char gamename[100] ;
		char slus[11] ;
		unsigned int numcodes ;
		char *filepos ;
	} CHEATDBENTRY ;

	CHEATDBENTRY m_cheatDB[5000] ;

	char *m_cheatfile ;
	unsigned int m_numDBCheats ;

	UINT32 m_numCheats ;


};


#include "..\common\commonfuncs.cpp"


struct { char *keyname ; int keynum ; } validKeys[11] = 
{
	{ "XBOX A", 0 },
	{ "XBOX B", 1 },
	{ "XBOX X", 2 },
	{ "XBOX Y", 3 },
	{ "XBOX BLACK", 4 },
	{ "XBOX WHITE", 5 },
	{ "XBOX START", 6 },
	{ "XBOX BACK", 7 },
	{ "XBOX LTRIGGER", 8 },
	{ "XBOX RTRIGGER", 9 },
	{ "UNMAPPED", 10 },
};




void CXBoxSample::doLoadEmuSpecificIni( char *szbuf ) 
{

	m_biosMode = 1  ;
	m_vandalFix = 0 ;
	m_psxfix_Xa = 0  ;
	m_psxfix_Sio = 0  ;
	m_psxfix_Mdec = 0  ;
	m_psxfix_Cdda = 0  ;
	m_psxfix_Cpu = 0  ;
	m_psxfix_SpuIrq = 0  ;
	m_psxfix_VSyncWA = 0 ;
	m_memcardnum1 = 0  ;
	m_memcardnum2 = 1  ;
	m_graphicsFixes = 0  ;
	m_frameskip = 1  ;
	m_framelimit = 1  ;
	m_bitDepth = 16 ;
	psxfix_ff9 = 0  ;


	m_bitDepth = 16 ;

	if ( m_memcardnum1 > 9 )
		m_memcardnum1 = 0 ;
	if ( m_memcardnum1 < 0 )
		m_memcardnum1 = 0 ;
	if ( m_memcardnum2 > 9 )
		m_memcardnum2 = 0 ;
	if ( m_memcardnum2 < 0 )
		m_memcardnum2 = 0 ;
}

void CXBoxSample::doSaveEmuSpecificIni( FILE *outfile ) 
{




}


int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		return 1 ;
		Texture->Release();
		Texture = NULL;
	}
	
	theWidth = 512 ;
	theHeight = 512 ;

	if (D3DXCreateTextureFromFileInMemoryEx(m_pd3dDevice, GAMESCREEN_FILE, sizeof(GAMESCREEN_FILE),
		 theWidth, theHeight, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &Texture)==D3D_OK)
	{
		m_pnlGameScreen.m_pTexture = NULL ;
		if ( FAILED(m_pnlGameScreen.Create(m_pd3dDevice, Texture, FALSE, theWidth, theHeight)) )
		{
			popupMsg( "no create panel", &m_pnlBackgroundOther ) ;
		}
	}
	else
	{
		popupMsg( "no load texture", &m_pnlBackgroundOther ) ;
	}

	// Create the texture

	//if ( m_bitDepth == 16 )
		//D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_R5G6B5, D3DPOOL_DEFAULT, &Texture);
	//else
		//D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	


	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];


	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];

	if (g_pDeltaBuff != NULL)
	{
		delete [] g_pDeltaBuff;
		g_pDeltaBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pDeltaBuff = new byte[desc.Size];

	memset( g_pDeltaBuff, 0xFF, desc.Size ) ;

	D3DCOLOR			*color_palette;
	


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	m_pitch = d3dlr.Pitch ;

	// Unlock our texture
	Texture->UnlockRect(0);


	return 0;
}



unsigned long TAB_CONST2[256] = {
   0X0,
   0X77073096,
   0XEE0E612C,
   0X990951BA,
   0X76DC419,
   0X706AF48F,
   0XE963A535,
   0X9E6495A3,
   0XEDB8832,
   0X79DCB8A4,
   0XE0D5E91E,
   0X97D2D988,
   0X9B64C2B,
   0X7EB17CBD,
   0XE7B82D07,
   0X90BF1D91,
   0X1DB71064,
   0X6AB020F2,
   0XF3B97148,
   0X84BE41DE,
   0X1ADAD47D,
   0X6DDDE4EB,
   0XF4D4B551,
   0X83D385C7,
   0X136C9856,
   0X646BA8C0,
   0XFD62F97A,
   0X8A65C9EC,
   0X14015C4F,
   0X63066CD9,
   0XFA0F3D63,
   0X8D080DF5,
   0X3B6E20C8,
   0X4C69105E,
   0XD56041E4,
   0XA2677172,
   0X3C03E4D1,
   0X4B04D447,
   0XD20D85FD,
   0XA50AB56B,
   0X35B5A8FA,
   0X42B2986C,
   0XDBBBC9D6,
   0XACBCF940,
   0X32D86CE3,
   0X45DF5C75,
   0XDCD60DCF,
   0XABD13D59,
   0X26D930AC,
   0X51DE003A,
   0XC8D75180,
   0XBFD06116,
   0X21B4F4B5,
   0X56B3C423,
   0XCFBA9599,
   0XB8BDA50F,
   0X2802B89E,
   0X5F058808,
   0XC60CD9B2,
   0XB10BE924,
   0X2F6F7C87,
   0X58684C11,
   0XC1611DAB,
   0XB6662D3D,
   0X76DC4190,
   0X1DB7106,
   0X98D220BC,
   0XEFD5102A,
   0X71B18589,
   0X6B6B51F,
   0X9FBFE4A5,
   0XE8B8D433,
   0X7807C9A2,
   0XF00F934,
   0X9609A88E,
   0XE10E9818,
   0X7F6A0DBB,
   0X86D3D2D,
   0X91646C97,
   0XE6635C01,
   0X6B6B51F4,
   0X1C6C6162,
   0X856530D8,
   0XF262004E,
   0X6C0695ED,
   0X1B01A57B,
   0X8208F4C1,
   0XF50FC457,
   0X65B0D9C6,
   0X12B7E950,
   0X8BBEB8EA,
   0XFCB9887C,
   0X62DD1DDF,
   0X15DA2D49,
   0X8CD37CF3,
   0XFBD44C65,
   0X4DB26158,
   0X3AB551CE,
   0XA3BC0074,
   0XD4BB30E2,
   0X4ADFA541,
   0X3DD895D7,
   0XA4D1C46D,
   0XD3D6F4FB,
   0X4369E96A,
   0X346ED9FC,
   0XAD678846,
   0XDA60B8D0,
   0X44042D73,
   0X33031DE5,
   0XAA0A4C5F,
   0XDD0D7CC9,
   0X5005713C,
   0X270241AA,
   0XBE0B1010,
   0XC90C2086,
   0X5768B525,
   0X206F85B3,
   0XB966D409,
   0XCE61E49F,
   0X5EDEF90E,
   0X29D9C998,
   0XB0D09822,
   0XC7D7A8B4,
   0X59B33D17,
   0X2EB40D81,
   0XB7BD5C3B,
   0XC0BA6CAD,
   0XEDB88320,
   0X9ABFB3B6,
   0X3B6E20C,
   0X74B1D29A,
   0XEAD54739,
   0X9DD277AF,
   0X4DB2615,
   0X73DC1683,
   0XE3630B12,
   0X94643B84,
   0XD6D6A3E,
   0X7A6A5AA8,
   0XE40ECF0B,
   0X9309FF9D,
   0XA00AE27,
   0X7D079EB1,
   0XF00F9344,
   0X8708A3D2,
   0X1E01F268,
   0X6906C2FE,
   0XF762575D,
   0X806567CB,
   0X196C3671,
   0X6E6B06E7,
   0XFED41B76,
   0X89D32BE0,
   0X10DA7A5A,
   0X67DD4ACC,
   0XF9B9DF6F,
   0X8EBEEFF9,
   0X17B7BE43,
   0X60B08ED5,
   0XD6D6A3E8,
   0XA1D1937E,
   0X38D8C2C4,
   0X4FDFF252,
   0XD1BB67F1,
   0XA6BC5767,
   0X3FB506DD,
   0X48B2364B,
   0XD80D2BDA,
   0XAF0A1B4C,
   0X36034AF6,
   0X41047A60,
   0XDF60EFC3,
   0XA867DF55,
   0X316E8EEF,
   0X4669BE79,
   0XCB61B38C,
   0XBC66831A,
   0X256FD2A0,
   0X5268E236,
   0XCC0C7795,
   0XBB0B4703,
   0X220216B9,
   0X5505262F,
   0XC5BA3BBE,
   0XB2BD0B28,
   0X2BB45A92,
   0X5CB36A04,
   0XC2D7FFA7,
   0XB5D0CF31,
   0X2CD99E8B,
   0X5BDEAE1D,
   0X9B64C2B0,
   0XEC63F226,
   0X756AA39C,
   0X26D930A,
   0X9C0906A9,
   0XEB0E363F,
   0X72076785,
   0X5005713,
   0X95BF4A82,
   0XE2B87A14,
   0X7BB12BAE,
   0XCB61B38,
   0X92D28E9B,
   0XE5D5BE0D,
   0X7CDCEFB7,
   0XBDBDF21,
   0X86D3D2D4,
   0XF1D4E242,
   0X68DDB3F8,
   0X1FDA836E,
   0X81BE16CD,
   0XF6B9265B,
   0X6FB077E1,
   0X18B74777,
   0X88085AE6,
   0XFF0F6A70,
   0X66063BCA,
   0X11010B5C,
   0X8F659EFF,
   0XF862AE69,
   0X616BFFD3,
   0X166CCF45,
   0XA00AE278,
   0XD70DD2EE,
   0X4E048354,
   0X3903B3C2,
   0XA7672661,
   0XD06016F7,
   0X4969474D,
   0X3E6E77DB,
   0XAED16A4A,
   0XD9D65ADC,
   0X40DF0B66,
   0X37D83BF0,
   0XA9BCAE53,
   0XDEBB9EC5,
   0X47B2CF7F,
   0X30B5FFE9,
   0XBDBDF21C,
   0XCABAC28A,
   0X53B39330,
   0X24B4A3A6,
   0XBAD03605,
   0XCDD70693,
   0X54DE5729,
   0X23D967BF,
   0XB3667A2E,
   0XC4614AB8,
   0X5D681B02,
   0X2A6F2B94,
   0XB40BBE37,
   0XC30C8EA1,
   0X5A05DF1B,
   0X2D02EF8D
};

int CXBoxSample::handleExtension( char *ext, char *newfilename, char *zipfilename, int *zipnumber )  
{

	return 0 ;
}








void CXBoxSample::emuLaunch( unsigned int gameSelected, unsigned int isFavorite, int forceConfig )
{
	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;


	initConsole(gameSelected, isFavorite, forceConfig) ;

	if ( g_autoLaunchGame )
	{
		changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
		//doTransition( &m_pnlBackgroundOther, &m_pnlBackgroundMain, m_skin.fade, 1 ) ;
	}
	else
	{
		changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
		//doTransition( &m_pnlBackgroundOther, &m_pnlBackgroundSelect, m_skin.fade, 1 ) ;
	}

	if ( !m_bBgmInGame )
	{
		m_mp3player.pause( FALSE ) ;
	}

	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;

}



void CXBoxSample::doConfigureGame( char *settingsname, char *keysname )
{
	int menuChoice ;

	menuChoice = 0 ;

	loadSettings( settingsname ) ;
	loadKeys( keysname ) ;


	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"Game Configuration" );
		swprintf( m_menuText[1], L"Configure Controllers"  );
		swprintf( m_menuText[2], L"Set Graphics Filter"  );
		
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
	        XBInput_GetInput();
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : doConfigureControllers() ; break ;
				case 1 : doChangeSWFilter() ; break ;
				default : break ;
			}
		}


	}

	saveSettings( settingsname ) ;
	saveKeys( keysname ) ;

}







void CXBoxSample::saveSettings( char *filename )
{
	FILE *setfile ;

	m_changedSettings = 0 ;

	setfile = fopen( filename, "wb" ) ;

	if ( !setfile )
		return ;


	fwrite( &m_vandalFix, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_Xa, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_Sio, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_Mdec, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_Cdda, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_Cpu, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_SpuIrq, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_psxfix_VSyncWA, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_graphicsFixes, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_frameskip, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_framelimit, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_bitDepth, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_biosMode, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_xboxSFilter, sizeof(int), 1, setfile ) ;
	fwrite( &psxfix_ff9, sizeof(unsigned int), 1, setfile ) ;
	fwrite( &m_memcardnum1, sizeof(int), 1, setfile ) ;
	fwrite( &m_memcardnum2, sizeof(int), 1, setfile ) ;

	fclose( setfile ) ;

}

int CXBoxSample::loadSettings( char *filename )
{
	FILE *setfile ;

	m_changedSettings = 0 ;

	setfile = fopen( filename, "rb" ) ;

	if ( !setfile )
	{
		saveSettings( filename ) ;
		return 1 ;
	}

	psxfix_ff9 = 0 ;

	fread( &m_vandalFix, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_Xa, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_Sio, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_Mdec, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_Cdda, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_Cpu, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_SpuIrq, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_psxfix_VSyncWA, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_graphicsFixes, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_frameskip, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_framelimit, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_bitDepth, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_biosMode, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_xboxSFilter, sizeof(int), 1, setfile ) ;
	fread( &psxfix_ff9, sizeof(unsigned int), 1, setfile ) ;
	fread( &m_memcardnum1, sizeof(int), 1, setfile ) ;
	fread( &m_memcardnum2, sizeof(int), 1, setfile ) ;

	if ( ( m_xboxSFilter >= NUM_SOFTWARE_FILTERS ) || ( m_xboxSFilter < 0 ) )
	{
		m_xboxSFilter = 0 ;
	}

	fclose( setfile ) ;

	return 0 ;
}









void CXBoxSample::doAddGamesharkCodes( char *filepos, char *codedesc)
{
	char *line ;
	int finished ;
	WCHAR str[500] ;
	int checkit ;
	char cstr[300] ;

	finished = 0 ;


	line = filepos+1 ;

	//sprintfx( "line = %s\r\n", line ) ;

	while ( 1 )
	{
		while ( ( *line != 0 ) && ( *line != 127 ) )
		{
			line++ ;
		}

		if ( *line == 127 )
			break ;

		line++ ;

		if ( *line == 127 )
			break ;

		//sprintfx( "line = %s\r\n", line ) ;
		checkit = 1 ;

		while ( checkit )
		{

			switch ( *line )
			{
				case '\r' : line++ ; break ;
				case '\n' : line++ ; break ;
				case '#' :
				case '"' :  //code name
				case '' :  //joker command followed by N or R (normal, reversed) or A = master code, M=
				{
					checkit = 0 ;
					finished = 1 ;
					break ;
				}
				case '$' :  //discrete/named values for ?? codes
				{
					checkit = 0 ;
					break ;
				}
				case '?' :  //range of acceptable values for ?? codes
				{
					checkit = 0 ;
					break ;
				}
				case '1' :
				case '2' :
				case '3' :
				//case '5' :
				case '8' :
				//case 'C' :
				case 'D' :
				case 'E' :
				{
					CHEAT_CODE code ;
					char holder[10] ;

					checkit = 0 ;
					memset(code.code, 0, sizeof(code.code) ) ;

					strncpy(code.code, line, 13 ) ;

					//writexbox("readcode\r\n") ;
					while ( strchr( code.code, '?' ) )
						*strchr( code.code, '?' ) = '0' ;

					strncpy( holder, code.code, 8 ) ;
					holder[8] = 0 ;
					
					code.adr = strtoul( holder, NULL, 16 ) ;

					strncpy( holder, code.code+9, 4 ) ;
					holder[4] = 0 ;
					
					code.val = strtoul( holder, NULL, 16 ) ;

					//writexbox("readcode\r\n") ;
					//sscanf( code.code, "%6.6X %4.4X", code.adr, code.val ) ;
					//writexbox("readcode\r\n") ;

					code.type = ( code.adr >> 24 ) & 0xFF ;
					code.adr = code.adr & 0xFFFFFF ;
					code.enabled = 1 ;
					strcpy(code.desc, codedesc ) ;
					sprintf( code.code, "%02.2X%06.6X %04.4X", code.type, code.adr, code.val & 0xFFFF ) ;
					sprintf( cstr, "%s was added to your list", codedesc  ) ;

					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
					//writexbox("readcode\r\n") ;

					break ;
				}
				default : checkit = 0 ; break ;
			}
		}

		if ( finished )
			break ;
	}



	popupMsg( cstr, &m_pnlBackgroundOther ) ;

}




void CXBoxSample::doShowGamesharkCodes( int which)
{

	unsigned int selected  ;
	unsigned int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;
	int codesPerPage ;
	int keytime ;
	char c ;
	int lcv ;
	CHEATDBENTRY *entries ;
	char *line ;
	char *ptr ;
	int numitems ;
	DWORD iTime = 0 ;

	keytime = 0 ;

	pmenuParams = &m_skin.otherMenu ;

	codesPerPage =  pmenuParams->maxNumLines ;

	selected = cheatTopIdx = 0 ;

	if ( m_cheatDB[which].numcodes == 0 )
	{
		popupMsg( "No codes found for this game.", &m_pnlBackgroundOther ) ;
	}

	entries = (CHEATDBENTRY*)malloc( sizeof(CHEATDBENTRY) * m_cheatDB[which].numcodes ) ;

	line = m_cheatDB[which].filepos ;

	for ( int i = 0 ; i < m_cheatDB[which].numcodes ; i++ )
	{
		while ( ( *line != '"' ) && ( *line != '' ) && ( *line != 127 ) )
		{
			while ( ( *line != 0) && ( *line != 127 ) && ( *line != '' ) && ( *line != '"' ) )
				line++ ;

			if ( *line == 0 )
				line++ ;
		}

		if ( *line == 127 )
		{
			m_cheatDB[which].numcodes = i ;
			break ;
		}

		strcpy( entries[i].gamename, line+1 ) ;
		entries[i].filepos = line ;
		line++ ;
	}

	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu);

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
		//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
		pmenuParams->panel->Render( );
		Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;

		m_mp3player.process() ;
		m_plaything.Render( 0,0,0 ) ;

		swprintf( m_menuText[0], L"Search Gameshark Codes" );

		numitems = 1 ;


		for ( unsigned int idx = cheatTopIdx ; ( idx < m_cheatDB[which].numcodes ) && ( idx < cheatTopIdx+codesPerPage) ; idx++ )
		{
			swprintf( m_menuText[idx-cheatTopIdx+1], L"%S", entries[idx].gamename ) ;
			numitems++ ;
			
			//if ( selected == idx )
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 4+(idx-cheatTopIdx))), pmenuParams->selectedColor, str, pmenuParams->selectBarColor, 1 );
			//else
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 4+(idx-cheatTopIdx))), pmenuParams->normalColor, str );
		}
		

		renderMenuText( 1, selected-cheatTopIdx, m_menuText, numitems, 0 ) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			doAddGamesharkCodes( entries[selected].filepos, entries[selected].gamename ) ;
		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + codesPerPage < m_cheatDB[which].numcodes )
			{
				m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				cheatTopIdx += codesPerPage ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= codesPerPage )
			{
				m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				cheatTopIdx -= codesPerPage ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (codesPerPage-1) )
			{
				if ( selected < m_cheatDB[which].numcodes - 1 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_cheatDB[which].numcodes-1 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					selected++ ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					selected-- ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx + (codesPerPage-1) )
				{
					if ( selected < m_cheatDB[which].numcodes - 1 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						cheatTopIdx++ ;
						selected++ ;
					}
				}
				else
				{
					if ( selected < m_cheatDB[which].numcodes-1 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						selected++ ;
					}
				}

			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx )
				{
					if ( selected > 0 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						cheatTopIdx-- ;
						selected-- ;
					}
				}
				else
				{
					if ( selected > 0 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						selected-- ;
					}
				}

			}
		}

		
	}

	free(entries) ;
}



void CXBoxSample::doSearchGameshark()
{

	unsigned int selected  ;
	unsigned int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;
	int codesPerPage ;
	int keytime ;
	char c ;
	int lcv ;
	int numitems ;
	int iTime =0 ;

	keytime = 0 ;

	pmenuParams = &(m_skin.otherMenu) ;

	codesPerPage =  pmenuParams->maxNumLines ;

	selected = cheatTopIdx = 0 ;

	for ( int i = 0 ; i < m_numDBCheats ; i++ )
	{
		//sprintfx( "%s %s\r\n", m_cdromID, m_cheatDB[i].slus ) ;

		if ( stricmp( m_cdromID, m_cheatDB[i].slus ) == 0 )
		{
			selected = cheatTopIdx = i ;
			break ;
		}
	}

	if ( m_numDBCheats == 0 )
	{
		popupMsg( "Error - the database codelist.inf is not in D:\\", &m_pnlBackgroundOther ) ;
		return ;
	}

	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu);

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
		//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
		pmenuParams->panel->Render( );
		Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;

		m_mp3player.process() ;
		m_plaything.Render( 0,0,0 ) ;

		swprintf( m_menuText[0], L"Search Gameshark Code Database" );

		numitems = 1 ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numDBCheats ) && ( idx < cheatTopIdx+codesPerPage) ; idx++ )
		{
			numitems++ ;

			swprintf( m_menuText[idx-cheatTopIdx+1], L"%S (%S)", m_cheatDB[idx].gamename, m_cheatDB[idx].slus ) ;
			
			//if ( selected == idx )
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 4+(idx-cheatTopIdx))), pmenuParams->selectedColor, str, pmenuParams->selectBarColor, 1 );
			//else
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 4+(idx-cheatTopIdx))), pmenuParams->normalColor, str );
		}
		
		renderMenuText( 1, selected-cheatTopIdx, m_menuText, numitems, 0 ) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			doShowGamesharkCodes( selected ) ;
		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + codesPerPage < m_numDBCheats )
			{
				cheatTopIdx += codesPerPage ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= codesPerPage )
			{
				m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				cheatTopIdx -= codesPerPage ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (codesPerPage-1) )
			{
				if ( selected < m_numDBCheats - 1 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numDBCheats-1 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					selected++ ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
				{
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					selected-- ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx + (codesPerPage-1) )
				{
					if ( selected < m_numDBCheats - 1 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						cheatTopIdx++ ;
						selected++ ;
					}
				}
				else
				{
					if ( selected < m_numDBCheats-1 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						selected++ ;
					}
				}

			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx )
				{
					if ( selected > 0 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						cheatTopIdx-- ;
						selected-- ;
					}
				}
				else
				{
					if ( selected > 0 )
					{
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
						selected-- ;
					}
				}

			}
		}
		
	}
}



int CXBoxSample::addEmuSpecificOptions( int start )
{

		return start ;

}

void CXBoxSample::saveGameSpecificSettings( )
{
	saveKeys( g_keysfile ) ;
	saveSettings( g_settingsfile ) ;

}

void CXBoxSample::performEmuSpecificOption( int start, int menuChoice ) 
{
}

int charToHex( char c )
{
	if ( ( c >= '0' ) && ( c <= '9' ) )
		return c-'0' ;
	else
		return c-'A'+10 ;
}

int strToHex( char *str, int len )
{
	int base ;
	int val ;

	base = 1 ;

	val = 0 ;

	for ( int i = len-1 ; i >= 0 ; i-- )
	{
		val += charToHex(str[i])*base ;
		base *= 16 ;
	}

	return val ;
}

int CXBoxSample::validateCode( char *code, CHEAT_CODE *ccode, int codetype )
{
	ccode->type = strToHex( code, 2 ) ;
	ccode->adr = strToHex( code+2, 6 ) ;
	ccode->val = strToHex( code+8, 4 ) ;


	sprintf( ccode->code, "%02.2X%06.6X %04.4X", ccode->type, ccode->adr, ccode->val & 0xFFFF ) ;

	if ( ( ccode->adr >= CONSOLE_MEMORY_SIZE ) )
	{
		return 0 ;
	}
	else if ( ! ( ( ccode->type == 0x80 ) || ( ccode->type == 0x30 ) || ( ccode->type == 0xD0 ) || ( ccode->type == 0xD1 ) || 
				        ( ccode->type == 0xD2 ) || ( ccode->type == 0xD3 ) || ( ccode->type == 0xE0 ) || ( ccode->type == 0xE1 ) || 
				        ( ccode->type == 0xE2 ) || ( ccode->type == 0xE3 ) || ( ccode->type == 0x10 ) || ( ccode->type == 0x11 ) || 
				        ( ccode->type == 0x20 ) || ( ccode->type == 0x21 ) ) )
	{
		return 0 ;
	}

	return 1 ;
}





void CXBoxSample::doSelectMemcards()
{

	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Set Memory Card Slots" );
		swprintf( m_menuText[1], L"Memory Card 1" );
		if ( m_memcardnum1 == 10 )
			swprintf( m_menuText[2], L"Game-specific #1" );
		else
			swprintf( m_menuText[2], L"%u", m_memcardnum1 );

		swprintf( m_menuText[3], L"Memory Card 2" );

		if ( m_memcardnum2 == 10 )
			swprintf( m_menuText[4], L"Game-specific #2" );
		else
			swprintf( m_menuText[4], L"%u", m_memcardnum2 );


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 0, &m_pnlBackgroundOther, menuChoice, 1, 200 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( menuChoice == 0 )
			{
				m_memcardnum1 = getValuePopup( "Memory Card Slot 1", m_memcardnum1, 0, 10, &m_pnlBackgroundOther ) ; 
			}
			else
			{
				m_memcardnum2 = getValuePopup( "Memory Card Slot 2", m_memcardnum2, 0, 10, &m_pnlBackgroundOther ) ; 
			}
		}

	}
}




//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	InitializeWithScreen() ;

    return S_OK;
}


int CXBoxSample::render_to_texture(int w, int h, int pitch, unsigned char *surface)
{

	//DOXXX
	RECT src, dst;
	byte *curr1, *curr2 ;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	if ( w == 0 )
		return 1;

	//sprintfx( "render w=%u\r\n", w ) ;

	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight - 1 ;
	rectSource.right  = theWidth  - 1;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	//sprintf(xmsg, "h=%u,w=%u\r\n", io.screen_h, io.screen_w) ;
	//writexbox( xmsg) ;

	//curr1 = g_pBlitBuff ;
	//DOXXX
	//curr2 = NULL ;

	//for ( unsigned int y = 0 ; y < theHeight ; y++ )
	//{
		//curr1 = ((byte*)g_pBlitBuff) + ( y*d3dlr.Pitch ) ;
		//curr2 = ((byte*)osd_gfx_buffer) + ( y*(320+64+40) ) + ( ( (320+64+40)-io.screen_w ) /2 )  ;
		//memcpy( curr1, curr2, io.screen_w ) ;
	//}
	


	//sprintfx( "going to sai %08.8X %08.8X %08.8X\r\n", g_pBlitBuff, g_pDeltaBuff, g_pAlignBuff) ;
	//_2xSaI( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;
	//SuperEagle( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;
	//Super2xSaI( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;
	//SuperScale( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;
	//SuperScale( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 1 ) ;
	//Eagle( g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;
	//AdMame2x(g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, g_pAlignBuff, m_pitch, w, h, 0 ) ;

	//sprintfx( "finished to sai\r\n") ;
	



	float mx, my ;

	if ( m_xboxSFilter )
	{
		 //BlitScreen(g_pBlitBuff, blitx, blity ) ;
		SOFTWARE_FILTERS[m_xboxSFilter].blitfunc(g_pBlitBuff+m_pitch, m_pitch, g_pDeltaBuff+m_pitch, (unsigned char*)d3dlr.pBits, m_pitch, w, h, 0 ) ;
		//XGSwizzleRect(g_pAlignBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, m_bitDepth/8);
		Texture->UnlockRect(0);
		g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
		g_pd3dDevice->BeginScene();

		//memset( g_pDeltaBuff, 0xFF, m_pitch*512 ) ;
		//memcpy( g_pDeltaBuff, g_pBlitBuff, m_pitch*512 ) ;
		mx = (float)m_nScreenMaxX / ((float)w*2.0f) ;
		my = (float)m_nScreenMaxY / ((float)h*2.0f);

		m_gameRectSource.top = 0;
		m_gameRectSource.left = 0;
		m_gameRectSource.bottom = (h )*2 ;
		m_gameRectSource.right  = (w )*2;
	}
	else
	{
		for ( unsigned int y = 0 ; y < h ; y++ )
		{
			curr1 = ((byte*)d3dlr.pBits) + ( y*d3dlr.Pitch ) ;
			curr2 = ((byte*)surface) + ( y*pitch )  ;
			memcpy( curr1, curr2, w<<1 ) ;
		}

		 //BlitScreen((unsigned char*)d3dlr.pBits, blitx, blity ) ;
		//XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, m_bitDepth/8);
		Texture->UnlockRect(0);
		g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
		g_pd3dDevice->BeginScene();

		mx = (float)m_nScreenMaxX / ((float)w) ;
		my = (float)m_nScreenMaxY / ((float)h);

		m_gameRectSource.top = 0;
		m_gameRectSource.left = 0;
		m_gameRectSource.bottom = (h) ;
		m_gameRectSource.right  = (w);
	}


/*

    struct VERTEX { D3DXVECTOR4 p; D3DCOLOR col; FLOAT tu, tv; };
    LPDIRECT3DVERTEXBUFFER8 pVB;
    m_pd3dDevice->CreateVertexBuffer( 4*sizeof(VERTEX), D3DUSAGE_WRITEONLY, 
                                      0L, D3DPOOL_DEFAULT, &pVB );

	VERTEX* v;
    pVB->Lock( 0, 0, (BYTE**)&v, 0L );

	FLOAT fWidth  = 640 ;
	FLOAT fHeight = 480 ;

    v[0].p = D3DXVECTOR4( 0 - 0.5f,			0 - 0.5f,			0, 0 );
	v[0].tu = 0;
	v[0].tv = 0;
	v[0].col= 0xFFFFFFFF;
    
	v[1].p = D3DXVECTOR4( fWidth - 0.5f,	0 - 0.5f,			0, 0 );
	v[1].tu = 640;
	v[1].tv = 0;
	v[1].col= 0xFFFFFFFF;

    v[2].p = D3DXVECTOR4( fWidth - 0.5f,	fHeight - 0.5f,	0, 0 );
	v[2].tu = 640;
	v[2].tv = 480;
	v[2].col= 0xFFFFFFFF;

    v[3].p = D3DXVECTOR4( 0 - 0.5f,			fHeight - 0.5f,	0, 0 );
	v[3].tu = 0;
	v[3].tv = 480;
	v[3].col= 0xFFFFFFFF;

	pVB->Unlock();

    m_pd3dDevice->SetTexture( 0, Texture );
    m_pd3dDevice->SetStreamSource( 0, pVB, sizeof(VERTEX) );
    m_pd3dDevice->DrawPrimitive( D3DPT_QUADLIST, 0, 1 );


	m_pnlGameScreen.Render( 0,0,640,480 ) ;
	//m_pnlGameScreen.Render( m_nScreenX, m_nScreenY, mx, my ) ;
*/

	m_gameVecScale.x = mx ; m_gameVecScale.y = my;
	m_gameVecTranslate.x = m_nScreenX ; m_gameVecTranslate.y = m_nScreenY ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);

	m_pnlGameScreen.Render( m_gameRectSource.left, m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
	//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);

	if ( g_bShowFPS )
	{
		sprintf( global_error_message, "fps=%.1f", (float)m_numFrames*1000.0/((float)(GetTickCount() - g_dwStartTime)) );
		m_msgDelay = 3 ;

		if ( GetTickCount() - g_dwStartTime > 1000 )
		{
			g_dwStartTime = GetTickCount() ;
			m_numFrames = 0 ;
		}
	}
	if ( global_error_message[0] )
	{
		if ( m_msgDelay > 0 )
		{
			WCHAR msg[500] ;
			m_msgDelay-- ;
			swprintf( msg, L"%S", global_error_message ) ;

			m_Font.DrawText( 48, 48, 0xFFFFFFFF, msg, 0x00000000, 1, 0, 640, 480, pmenuParams->size   ) ;
		}
	}

	// End the scene.
	g_pd3dDevice->EndScene();




	//if ( ( !m_throttle ) && ( m_framelimit ) )
		//g_pd3dDevice->BlockUntilVerticalBlank() ;

	g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

void CXBoxSample::InitializeEmuSpecific()
{
	m_changedSettings = 0 ;



	//XSetFileCacheSize( 0x200000 ) ;

}


//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{



    return S_OK;
}

/*
void CXBoxSample::doEmulatorOptions()
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Emulator Specific Options" );
		swprintf( m_menuText[1], L"Set Memory Card Slot");
		swprintf( m_menuText[2], L"Set Graphics Fixes");
		swprintf( m_menuText[3], L"Set CPU Fixes");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 4, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : doSelectMemcards() ; break ;
				case 1 : doGraphicsFixes() ; break ;
				case 2 : doCPUFixes() ; break ;
				default : break ;
			}
		}


	}

}
*/



/**
  This routine should be called regularly to handle events
*/

int CXBoxSample::handleEvents()
{

    INT32 resistance ;
	float newRes ;
	static int doInsert = 0 ;
	static int doChange = 0 ;

	//xbox_print_memory() ;

	updateCheats2() ;

	if ( g_app->pollXBoxControllers() )
	{
		m_state = MAIN_MENU ;
		emulating = 0 ;
		return 0;
	}
	
	g_app->checkGeneralEvents() ;	

	if ( m_state == MAIN_MENU )
	{
		emulating = 0 ;
		return 0;
	}

	if ( g_app->m_bNetplay )
	{
		if ( m_netplayCurr == m_netplaySkip ) //we have read some network data
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_emuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}
		else //we did not poll network - use last values
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[0] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}
	}


//	m_joypad = ( g_app->m_emuControllers[0] & 0xFF ) | ( ( g_app->m_emuControllers[1] & 0xFF ) << 8 )  | 
				//( ( g_app->m_emuControllers[2] & 0xFF ) << 16 ) | ( ( g_app->m_emuControllers[3] & 0xFF ) << 24 ) ;


	for ( int i = 0 ; i < 4 ; i++ )
	{
		if ( m_emuControllers[i] & JOY_RESET )
		{
			S9xMovieStop (TRUE);
			S9xSoftReset ();
			SetupSound (Settings.SoundPlaybackRate, Settings.SixteenBitSound, Settings.Stereo);

			m_emuControllers[i] &= ~JOY_RESET ;
		}
		joypads[i] = m_emuControllers[i] | 0x80000000 ;
	}

#ifdef LIGHTGUN
	if ( m_zapperNum )
	{
		doZapper() ;
	}
#endif

	return 0 ;
}





void CXBoxSample::xboxSaveState() 
{
	if ( m_bStateMenu )
	{
		int statenum ;
		g_app->m_state = IN_GAME_PAUSED ;
		g_app->m_sound.pause( TRUE ) ;

		#ifdef NEED_CDDA
		g_app->m_cdda.pause(TRUE) ;
		#endif

		statenum = selectState() ;

		freeTextures() ;
		m_sound.pause( FALSE ) ;

		#ifdef NEED_CDDA
		m_cdda.pause(FALSE) ;
		#endif

		m_state = IN_GAME ;

		if ( statenum >= 0 )
		{
			m_stateNumber = statenum ;
		}
		else
		{
			return ;
		}
	}

	if ( g_statefile && strlen( g_statefile ) )
	{
		if ( m_bScreenshotSavestate )
		{
			xboxScreenshot() ;

			g_statefile[ strlen(g_statefile)-2 ] = 'p' ;

			MoveFileEx( g_szLastScreenshot, g_statefile, MOVEFILE_COPY_ALLOWED|MOVEFILE_REPLACE_EXISTING ) ;

			g_statefile[ strlen(g_statefile)-2 ] = 't' ;
		}

		g_statefile[ strlen(g_statefile)-1 ] = '0' + m_stateNumber ;


		S9xSetPause (PAUSE_FREEZE_FILE);
		S9xFreezeGame (g_statefile);
		S9xClearPause (PAUSE_FREEZE_FILE);

		//SaveState( g_app->g_statefile ) ;

		sprintf( global_error_message, "State %u Saved", m_stateNumber+1 ) ;
		m_msgDelay = 120 ;
	}
}

void CXBoxSample::xboxLoadState() 
{
	char szholder[500] ;

	if ( m_bStateMenu )
	{
		int statenum ;
		g_app->m_state = IN_GAME_PAUSED ;
		g_app->m_sound.pause( TRUE ) ;

		#ifdef NEED_CDDA
		g_app->m_cdda.pause(TRUE) ;
		#endif

		statenum = selectState() ;

		freeTextures() ;
		m_sound.pause( FALSE ) ;

		#ifdef NEED_CDDA
		m_cdda.pause(FALSE) ;
		#endif

		m_state = IN_GAME ;

		if ( statenum >= 0 )
		{
			m_stateNumber = statenum ;
		}
		else
		{
			return ;
		}
	}

	if ( g_statefile && strlen( g_statefile ) )
	{
		if ( m_stateNumber == 0 )
		{
			g_statefile[ strlen(g_statefile)-1 ] = 'A' ;
			strcpy( szholder, g_statefile ) ;
			g_statefile[ strlen(g_statefile)-1 ] = '0' ;
			MoveFileEx( szholder, g_statefile, MOVEFILE_REPLACE_EXISTING ) ;
		}

		g_statefile[ strlen(g_statefile)-1 ] = '0' + m_stateNumber ;


	    S9xSetPause (PAUSE_FREEZE_FILE);
        S9xUnfreezeGame (g_statefile) ;
	    S9xClearPause (PAUSE_FREEZE_FILE);

		sprintf( global_error_message, "State %u Loaded", m_stateNumber+1 ) ;
		m_msgDelay = 120 ;
	}
}

void CXBoxSample::xboxChangeFilter() 
{
	if ( g_app->m_bitDepth == 16 )
		g_app->m_xboxSFilter = (g_app->m_xboxSFilter+1)%NUM_SOFTWARE_FILTERS ;
	else
		g_app->m_xboxSFilter = 0 ;

	memset( g_pDeltaBuff, 0xFF, m_pitch*512 ) ;

	sprintf( global_error_message, "%s Filtering", SOFTWARE_FILTERS[m_xboxSFilter].name ) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxScreenshot() 
{
	mainprog_info wpng_info;
	char scr_filename[MAX_PATH] ;
	char scr_prefix[MAX_PATH] ;
	char dir[MAX_PATH] ;
	int maxnum = 0 ;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;

	g_szLastScreenshot[0] = 0 ;

	if ( m_bitDepth != 16 )
		return ;

	CreateDirectory( m_screenshotDir, NULL ) ;

	sprintf( scr_prefix, "%s\\%s", m_screenshotDir, PLATFORM_NAME ) ; 

	CreateDirectory( scr_prefix, NULL ) ;

	sprintf( scr_prefix, "%s\\%s\\%s", m_screenshotDir, PLATFORM_NAME, strrchr(g_saveprefix, '\\')+1 ) ;

	CreateDirectory( scr_prefix, NULL ) ;

	sprintf( dir, "%s\\*.png", scr_prefix ) ;

	hFind = FindFirstFile( dir, &oFindData);

	if ( hFind != INVALID_HANDLE_VALUE) 
	{
		do
		{
			strcpy( scr_filename, oFindData.cFileName ) ;

			if ( strchr( scr_filename, '.' ) == NULL )
				continue ;

			*(strchr( scr_filename, '.' )) = 0 ;

			//sprintfx( "%s %u %s\r\n", scr_filename, strlen(scr_prefix), scr_filename + strlen(scr_prefix) ) ;

			if ( atoi( scr_filename ) > maxnum )
			{
				maxnum = atoi( scr_filename ) ;
			}
			
		} while (FindNextFile(hFind, &oFindData) ) ;
		FindClose( hFind );
	}

	maxnum++ ;

	if ( maxnum > 9999 )
		return ;

	sprintf( scr_filename, "%s\\%04.4u.png", scr_prefix, maxnum ) ;


	memset( &wpng_info, 0, sizeof( wpng_info ) ) ;

	wpng_info.width = ((float)m_nScreenMaxX/m_gameVecScale.x);
	wpng_info.height = ((float)m_nScreenMaxY/m_gameVecScale.y) ;

	wpng_info.sample_depth = 8;

	wpng_info.bpp = 24 ;

	wpng_info.outfile = NULL;
	wpng_info.image_data = NULL;
	wpng_info.row_pointers = NULL;
	wpng_info.interlaced = false;
	wpng_info.have_bg = false;
	wpng_info.have_time = false;
	wpng_info.have_text = 0;
	wpng_info.gamma = 1.0;

    /* open the output file, or register an error and abort */
	if ((wpng_info.outfile = fopen( scr_filename, "wb") ) == NULL)
	{
		return ;
    }
	
	// allocate libpng stuff, initialize transformations, write pre-IDAT data
	

	int rc ;
	if ((rc=writepng_init(&wpng_info)) != 0)
	{
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		switch (rc)
		{
			case 2:
				fprintf(stderr, "WritePNG: libpng initialization problem (longjmp)\n");
			break;
			case 4:
				fprintf(stderr, "WritePNG: insufficient memory\n");
				break;
			case 11:
				fprintf(stderr, "WritePNG: internal logic error (unexpected PNM type)\n");
				break;
			default:
				fprintf(stderr, "WritePNG: unknown writepng_init() error\n");
				break;
        }
        exit(rc); */
    }
	
	long j;
	
	wpng_info.image_data = (unsigned char *)malloc( (wpng_info.bpp/8) * wpng_info.width);
		
	if (wpng_info.image_data == NULL)
	{
		writepng_cleanup(&wpng_info);
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		fprintf(stderr, "WritePNG:  insufficient memory for row data\n");
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(5);
		*/
	}
		
	unsigned char *data ;
	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);


	data = (unsigned char*)d3dlr.pBits;


	WORD pixel ;
		
	for (j = wpng_info.height;  j > 0L;  --j)
	{
		unsigned char* img_data = wpng_info.image_data;
		WORD *wdata = (WORD*)data;

		int i=0;

		for ( i = 0 ; i < wpng_info.width ; i++ )
		{
			pixel = wdata[i] ;
			img_data[2] = (pixel<<3) & 0xFF ;
			img_data[1] = ((pixel>>5)<<2) & 0xFF ;
			img_data[0] = ((pixel>>11)<<3) & 0xFF ;
			img_data += 3 ;
		}

		data += xbox_get_pitch();
			
	
			
		if( writepng_encode_row(&wpng_info) != 0)
		{
			writepng_cleanup(&wpng_info);
			free(wpng_info.image_data) ;
			fclose( wpng_info.outfile )  ;
			Texture->UnlockRect(0) ;
			return ; 

/*			fprintf(stderr, "WritePNG:  libpng problem (longjmp) while writing row %ld\n",
			wpng_info.height-j);
			++error;
			break;*/
		}
	}
	Texture->UnlockRect(0) ;
		
		/*
	if (error)
	{
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(2);
	}
	*/
	if (writepng_encode_finish(&wpng_info) != 0)
	{
		//fprintf(stderr, "WritePNG:  error on final libpng call\n");
		writepng_cleanup(&wpng_info);
		free(wpng_info.image_data) ;
		fclose( wpng_info.outfile )  ;
		return ;
	}
	
	/* OK, we're done (successfully):  clean up all resources and quit */

	writepng_cleanup(&wpng_info);
	free(wpng_info.image_data) ;
	fclose( wpng_info.outfile )  ;

	sprintf( global_error_message, "%s", scr_filename) ;
	m_msgDelay = 120 ;

	strcpy( g_szLastScreenshot, scr_filename ) ;

}

void CXBoxSample::xboxThrottle( int xthrottle ) 
{
	if ( xthrottle ) 
	{
		//change_framerate( m_throttleSpeed ) ;
		if ( m_throttle <= 0 )
			m_throttle = m_throttleSpeed ;
	}
	else
	{
		m_throttle = 0 ;
		//change_framerate( g_properties.gfx_framerate ) ;
	}
}

void CXBoxSample::xboxChangeState() 
{
	m_stateNumber = (m_stateNumber+1)%10 ;

	sprintf( global_error_message, "Switched to State Slot %u", m_stateNumber+1 ) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::xboxOptionsMenu( )
{
	g_app->m_state = IN_GAME_PAUSED ;
	g_app->m_sound.pause( TRUE ) ;
	//g_app->m_mp3player.pause( TRUE ) ;
	g_app->m_dwStartPause = GetTickCount();
	g_app->doCheatMenu() ;

	m_numFrames = 0 ;
	g_dwStartTime = GetTickCount() ;
}

void CXBoxSample::xboxStartRecording( )
{
	if ( m_emuRecording || m_emuPlaying )
		return ;


	m_sound.pause(TRUE ) ;
	FILE *checkfile ;

	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Confirm Start Recording" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"WARNING" ) ;
		swprintf( m_menuText[3], L"This function is going to load the currently" ) ;
		swprintf( m_menuText[4], L"selected save state and start recording."   ) ;
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"Press B if you want to cancel this action." ) ;
		swprintf( m_menuText[7], L"Press Y to load the state and start recording.") ;

		renderPopupBkg( 8 ) ;
		renderMenuText( 0, 0, m_menuText, 8, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			m_sound.pause(FALSE) ;
			return ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
	}

	xboxLoadState() ;

	checkfile = fopen( g_statefile, "rb" ) ;

	if ( checkfile == NULL )
	{
		xboxSaveState() ;
	}
	else
	{
		fclose( checkfile ) ;
	}

	m_emuRecordSlot = m_stateNumber ;
	m_emuRecordPosition = 0 ;
	m_emuRecording = 1 ;

	m_sound.pause(FALSE) ;

	sprintf( global_error_message, "Started Recording at Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;

}

void CXBoxSample::xboxStopRecording( )
{
	if ( ! m_emuRecording )
		return ;

	char recname[500] ;
	FILE *recfile ;

	sprintf( recname, "%s.sr0", g_saveprefix ) ;

	recname[ strlen(recname)-1 ] = '0' + m_emuRecordSlot  ;


	recfile = fopen( recname, "wb") ;

	if ( recfile == NULL )
	{
		sprintf( global_error_message, "Could not open %s for writing", recname ) ;
		m_msgDelay = 120 ;
		return ;
	}

	fwrite( m_szEmuRecorder, sizeof(char), m_emuRecordPosition, recfile  ) ;
	fclose( recfile ) ;

	m_emuRecording = 0 ;

	sprintf( global_error_message, "Stopped Recording at Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;
}
void CXBoxSample::xboxStartPlaying( )
{
	if ( m_emuPlaying || m_emuRecording )
		return ;

	char recname[500] ;
	FILE *recfile ;
	unsigned int filesize ;

	m_sound.pause(TRUE) ;
	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Confirm Start Playing" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"WARNING" ) ;
		swprintf( m_menuText[3], L"This function is going to load the currently" ) ;
		swprintf( m_menuText[4], L"selected save state and start playing the recording."   ) ;
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"Press B if you want to cancel this action." ) ;
		swprintf( m_menuText[7], L"Press Y to load the state and start playing.") ;

		renderPopupBkg( 8 ) ;
		renderMenuText( 0, 0, m_menuText, 8, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			m_sound.pause(FALSE) ;
			return ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
	}

	m_emuRecordSlot = m_stateNumber ;

	sprintf( recname, "%s.sr0", g_saveprefix ) ;

	recname[ strlen(recname)-1 ] = '0' + m_emuRecordSlot  ;


	recfile = fopen( recname, "rb") ;

	if ( recfile == NULL )
	{
		sprintf( global_error_message, "Could not open %s for reading", recname ) ;
		m_msgDelay = 120 ;
		m_sound.pause(FALSE) ;
		return ;
	}

	fseek( recfile, 0, SEEK_END ) ;
	m_emuPlaySize = ftell( recfile ) ;
	fseek( recfile, 0, SEEK_SET ) ;

	fread( m_szEmuRecorder, sizeof(char), m_emuPlaySize, recfile ) ;
	fclose( recfile ) ;

	m_emuPlayPosition = 0 ;

	m_emuPlaying = 1 ;

	xboxLoadState() ;

	m_sound.pause(FALSE) ;

	sprintf( global_error_message, "Started Playing Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;
}
void CXBoxSample::xboxStopPlaying( )
{
	if ( ! m_emuPlaying )
		return ;

	m_emuPlaying = 0 ;

	sprintf( global_error_message, "Stopped Playing Slot %u", m_emuRecordSlot+1 ) ;
	m_msgDelay = 120 ;
}
/*
void CXBoxSample::checkGeneralEvents( )
{

	static int did_save_state[4] = { 0, 0, 0, 0} ;
	static int did_load_state[4] = { 0, 0, 0, 0} ;
	static int did_change_state[4] = { 0, 0, 0, 0} ;
	static int did_screenshot[4] = { 0, 0, 0, 0} ;
	static int did_change_gfx[4] = { 0, 0, 0, 0} ;
	static int did_toggle_bgm[4] = { 0, 0, 0, 0} ;

	int throttle ;

	throttle = 0 ;


	for ( int i = 0; i < 4 ; i++ )
	{

		for ( int j = 0 ; j < 10 ; j++ )
		{
			if ( ( m_mappings[i].combos[j].mapping ) && ( ( m_xboxControllers[i] & m_mappings[i].combos[j].mapping ) == m_mappings[i].combos[j].mapping ) )
			{
				if ( m_mappings[i].combos[j].currmove == 0 )
				{
					m_mappings[i].combos[j].currmove = 1 ;
					m_mappings[i].combos[j].currdelay = m_mappings[i].combos[j].delay ;
				}
			}
			if ( m_mappings[i].combos[j].currmove )
			{
				if ( m_mappings[i].combos[j].currdelay )
				{
					m_mappings[i].combos[j].currdelay-- ;
					m_emuControllers[i] = m_mappings[i].combos[j].moves[ m_mappings[i].combos[j].currmove - 1] ;
				}
				else
				{
					m_mappings[i].combos[j].currmove++ ;
					if ( m_mappings[i].combos[j].currmove == m_mappings[i].combos[j].endmove + 1 )
					{
						m_mappings[i].combos[j].currmove = 0 ;
					}
					else
					{
						m_mappings[i].combos[j].currdelay = m_mappings[i].combos[j].delay ;
						m_emuControllers[i] = m_mappings[i].combos[j].moves[ m_mappings[i].combos[j].currmove - 1] ;
					}
				}
			}
		}

		if ( ( m_mappings[i].options_menu ) && ( ( m_xboxControllers[i] & m_mappings[i].options_menu ) == m_mappings[i].options_menu ) )
		{
			xboxOptionsMenu() ;
		}

		if ( ( m_mappings[i].save_state ) && ( ( m_xboxControllers[i] & m_mappings[i].save_state ) == m_mappings[i].save_state ) )
		{
			if ( ! did_save_state[i] )
			{
				xboxSaveState() ;
			}
			did_save_state[i] = 1 ;
		}
		else
		{
			did_save_state[i] = 0 ;
		}

		if ( ( m_mappings[i].load_state ) && ( ( m_xboxControllers[i] & m_mappings[i].load_state ) == m_mappings[i].load_state ) )
		{
			if ( ! did_load_state[i] )
			{
				xboxLoadState() ;
			}
			did_load_state[i] = 1 ;
		}
		else
		{
			did_load_state[i] = 0 ;
		}

		if ( ( m_mappings[i].change_save_slot ) && ( ( m_xboxControllers[i] & m_mappings[i].change_save_slot ) == m_mappings[i].change_save_slot ) )
		{
			if ( ! did_change_state[i] )
			{
				xboxChangeState() ;
			}
			did_change_state[i] = 1 ;
		}
		else
		{
			did_change_state[i] = 0 ;
		}


		if ( ( m_mappings[i].screenshot ) && ( ( m_xboxControllers[i] & m_mappings[i].screenshot ) == m_mappings[i].screenshot ) )
		{
			if ( ! did_screenshot[i] )
			{
				xboxScreenshot() ;
			}
			did_screenshot[i] = 1 ;
		}
		else
		{
			did_screenshot[i] = 0 ;
		}

		if ( ( m_mappings[i].change_gfx_filter ) && ( ( m_xboxControllers[i] & m_mappings[i].change_gfx_filter ) == m_mappings[i].change_gfx_filter ) )
		{
			if ( ! did_change_gfx[i] )
			{
				xboxChangeFilter() ;
			}
			did_change_gfx[i] = 1 ;
		}
		else
		{
			did_change_gfx[i] = 0 ;
		}

		if ( ( m_mappings[i].toggle_bgm ) && ( ( m_xboxControllers[i] & m_mappings[i].toggle_bgm ) == m_mappings[i].toggle_bgm ) )
		{
			if ( ! did_toggle_bgm[i] )
			{
				m_mp3player.pause( ! m_mp3player.m_bPaused ) ;
			}
			did_toggle_bgm[i] = 1 ;
		}
		else
		{
			did_toggle_bgm[i] = 0 ;
		}


		if ( ( m_mappings[i].sfx_vol_up ) && ( ( m_xboxControllers[i] & m_mappings[i].sfx_vol_up ) == m_mappings[i].sfx_vol_up ) )
		{
			m_sound.adjust_volume( 5 ) ;
		}
		if ( ( m_mappings[i].sfx_vol_down ) && ( ( m_xboxControllers[i] & m_mappings[i].sfx_vol_down ) == m_mappings[i].sfx_vol_down ) )
		{
			m_sound.adjust_volume( -5 ) ;
		}
		if ( ( m_mappings[i].bgm_vol_up ) && ( ( m_xboxControllers[i] & m_mappings[i].bgm_vol_up ) == m_mappings[i].bgm_vol_up ) )
		{
			m_mp3player.adjust_volume( 5 ) ;
		}
		if ( ( m_mappings[i].bgm_vol_down ) && ( ( m_xboxControllers[i] & m_mappings[i].bgm_vol_down ) == m_mappings[i].bgm_vol_down ) )
		{
			m_mp3player.adjust_volume( -5 ) ;
		}

		if ( ( m_mappings[i].throttle ) && ( ( m_xboxControllers[i] & m_mappings[i].throttle ) == m_mappings[i].throttle ) )
			throttle = 1 ;

	
	
	}

	xboxThrottle( throttle ) ;
}
*/

int ReadJoypad( int port )
{

	unsigned int value ;
	char xmsg[100] ;


	value = 0xFFFF ;

	if ( g_app->pollXBoxControllers() )
	{
		g_app->m_state = MAIN_MENU ;
		return value ;
	}

	g_app->updateCheats2() ;

	g_app->checkGeneralEvents() ;	

	if ( g_app->m_bNetplay )
	{
		if ( m_netplayCurr == m_netplaySkip ) //we have read some network data
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_emuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}
		else //we did not poll network - use last values
		{
			if ( g_app->m_bNetplay == 2 )  //server
			{
				g_app->m_emuControllers[0] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[1] = g_app->m_networkEmuControllers[0] ;
			}
			else //client
			{
				g_app->m_emuControllers[1] = g_app->m_prevEmuControllers[0] ;
				g_app->m_emuControllers[0] = g_app->m_networkEmuControllers[0] ;
			}
		}

	}

	value = ( ~(g_app->m_emuControllers[port] ) ) & 0xFFFF ;

	if ( g_app->m_state == MAIN_MENU )
	{
		value |= 0x10000 ;
	}
/*	
	
	XBInput_GetInput();

	if ( g_Gamepads[port].hDevice )
	{

		if(g_Gamepads[port].wButtons & XINPUT_GAMEPAD_LEFT_THUMB )
		{
			g_app->m_state = IN_GAME_PAUSED ;
			g_app->m_sound.pause( TRUE ) ;
			g_app->m_cdda.pause(TRUE) ;
			g_app->m_mp3player.pause( TRUE ) ;
			g_app->m_dwStartPause = GetTickCount();
			g_app->doCheatMenu() ;

			if ( g_app->m_state == MAIN_MENU )
			{
				value |= 0x10000 ;
				Running = 0 ;
			}
		}
		if(g_Gamepads[port].wPressedButtons & XINPUT_GAMEPAD_RIGHT_THUMB )
		{
			if ( g_app->m_bitDepth == 16 )
				g_app->m_xboxSFilter = (g_app->m_xboxSFilter+1)%NUM_SOFTWARE_FILTERS ;
			else
				g_app->m_xboxSFilter = 0 ;
		}

		if ( g_app->getButtonState( port, g_app->m_bMappingCross ) )
			value &= ~JOY_CROSS ;
		if ( g_app->getButtonState( port, g_app->m_bMappingSquare ) )
			value &= ~JOY_SQUARE ;
		if ( g_app->getButtonState( port, g_app->m_bMappingTriangle ) )
			value &= ~JOY_TRIANGLE ;
		if ( g_app->getButtonState( port, g_app->m_bMappingCircle ) )
			value &= ~JOY_CIRCLE ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_LEFT )
			value &= ~JOY_LEFT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_UP )
			value &= ~JOY_UP ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
			value &= ~JOY_RIGHT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_DOWN )
			value &= ~JOY_DOWN ;
		if ( g_app->getButtonState( port, g_app->m_bMappingStart ) )
			value &= ~JOY_START ;
		if ( g_app->getButtonState( port, g_app->m_bMappingSelect ) )
			value &= ~JOY_SELECT ;

		if ( g_app->getButtonState( port, g_app->m_bMappingR1 ) )
			value &= ~JOY_R1 ;
		if ( g_app->getButtonState( port, g_app->m_bMappingL1 ) )
			value &= ~JOY_L1 ;
		if ( g_app->getButtonState( port, g_app->m_bMappingR2 ) )
			value &= ~JOY_R2 ;
		if ( g_app->getButtonState( port, g_app->m_bMappingL2 ) )
			value &= ~JOY_L2 ;

		
		if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			LoadState( g_app->g_statefile ) ;
		}
		else if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			SaveState( g_app->g_statefile ) ;
		}

		//sprintf( xmsg, "x=%d,y=%d,x=%d,y=%d\r\n", g_Gamepads[port].sThumbRX, g_Gamepads[port].sThumbRX, g_Gamepads[port].fX2, g_Gamepads[port].fY2 ) ;

		if ( fabs(g_Gamepads[port].fX2) > 0.10f )
		{
			g_app->m_sound.adjust_volume( (int) ( g_Gamepads[port].fX2 * 25.0 ) ) ;
		}
		if ( fabs( g_Gamepads[port].fY2 ) > 0.10f )
		{
			g_app->m_cdda.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
			g_app->m_mp3player.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
		}

		if ( g_Gamepads[port].fX1 > 0.05f )
			value &= ~JOY_RIGHT ;

		if ( g_Gamepads[port].fX1 < -0.05f )
			value &= ~JOY_LEFT ;

		if ( g_Gamepads[port].fY1 > 0.05f)
			value &= ~JOY_UP ;
		
		if ( g_Gamepads[port].fY1 < -0.05f)
			value &= ~JOY_DOWN ;

	}

	if ( g_app->getButtonState( 0, g_app->m_bMappingThrottle ) > 200 )
	{
		iFastFwd = 1 ;
	}
	else
	{
		iFastFwd = 0 ;
	}
*/

	value = ((value>>8)&0xFF) | ( (value<<8) & 0xFF00 );
	return value ;
}







void CXBoxSample::updateEmuSpecificCheats( ) 
{
}


void CXBoxSample::initConsole( UINT32 idx, int isFavorite, int forceConfig )
{
	char                filename[500] ;
	char				localfile[512] ;
	char				zipfile[512] ;
	char				*usefile ;
	char				*ext ;
	int					zipnumber ;
	char                uprfilename[500] ;
	char				shortpath[100] ;
	unsigned char       *gimage ;
	int                 ntsccol ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	int isOther ;
	char *disks[2] ;


	localfile[0] = zipfile[0] = 0 ;
	zipnumber = 0 ;

	sprintfx( "begin initcons\r\n") ;

	xbox_print_memory() ;

	isOther = 0 ;
	m_throttle = 0 ;

	for ( int i = 0 ; i < 4 ; i++ )
	{
		m_emuControllers[i] = 0 ;
	}


	if ( isFavorite )
	{
		strcpy( (char*)filename, m_filesFavorites[idx].filename ) ;
	}
	else
	{
		if ( g_autoLaunchGame )
		{
			strcpy( (char*)filename, g_launchData.szFilename ) ;
		}
		else
		{
			if ( idx == 0xFFFFFFFF )
			{
				strcpy((char*)filename, "Z:\\CDGAME.CDG") ;
			}
			else
			{
				strcpy((char*)filename, m_szCurrentDir ) ;
				strcat( (char*)filename, (const char*)files[idx].filename ) ;
			}
		}
	}

	m_bUsingSamba = ( strncmp( filename, "SMB:", 4 ) == 0 ) || ( strncmp( filename, "smb:", 4 ) == 0 ) ;
	m_bUsingRelax = ( strncmp( filename, "RLX:", 4 ) == 0 ) || ( strncmp( filename, "rlx:", 4 ) == 0 ) ;

	xbox_print_memory() ;
	if ( (strstr (filename, ".MP3")) || (strstr (filename, ".mp3")) )
	{
		m_state = MAIN_MENU ;
		return  ;
	}

	if ( (strstr (filename, ".M3U")) || (strstr (filename, ".m3u")) )
	{
		m_state = MAIN_MENU ;
		return  ;
	}

	xbox_print_memory() ;

	char *p ;

	sprintfx("init\r\n") ;

	xbox_compatible_name( filename, shortpath ) ;



	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, shortpath ) ;
	p = strrchr(g_saveprefix, '.');
	if (p) *p = 0;

	CreateDirectory( g_saveprefix, NULL ) ;

	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, shortpath ) ;
	p = strrchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_settingsfile, g_saveprefix);
	strcat(g_settingsfile, ".stg");

	strcpy(g_keysfile, g_saveprefix);
	strcat(g_keysfile, ".key");

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_statefile, g_saveprefix);
	strcat(g_statefile, ".st0");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintfx("init\r\n") ;


	if ( g_bIsBoot )
	{
		g_bIsBoot = 0 ;
		struct stat s ;

		if ( stat( g_keysfile, &s ) != 0 )
		{
			if ( stat( "d:\\boot.key", &s ) == 0 )
			{
				CopyFile( "d:\\boot.key", g_keysfile, TRUE ) ;
			}
			else
			{
				saveKeys( g_keysfile ) ;
			}
		}
		if ( stat( g_settingsfile, &s ) != 0 )
		{
			if ( stat( "d:\\boot.stg", &s ) == 0 )
			{
				CopyFile( "d:\\boot.stg", g_settingsfile, TRUE ) ;
			}
			else
			{
				loadSettings( g_settingsfile ) ;
			}
		}
	}



	//memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	xbox_print_memory() ;

	WinSetDefaultValues ();

	m_noconfigfile = loadSettings( g_settingsfile ) ;


	if ( idx == 0xFFFFFFFF )
		forceConfig = 1 ;



	if ( forceConfig || m_noconfigfile )
	{
		changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
		doConfigureGame( g_settingsfile, g_keysfile ) ;
		isOther = 1 ;
	}

	//memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	xbox_print_memory() ;
	sprintfx("init\r\n") ;

	global_error_message[0] = 0 ;




	if ( g_autoLaunchGame )
	{
		m_pnlSplashGame.Render() ;
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else
	{
#ifndef NO_NETWORK
		if ( m_bNetplay )
		{
			changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
			if ( setupNetplay() )
				return ;
			doTransition( &m_pnlBackgroundOther, &m_pnlSplashGame, m_skin.fade, 1 ) ;
		}
		else
#endif
		{
			if ( isOther )
			{
				doTransition( &m_pnlBackgroundOther, &m_pnlSplashGame, m_skin.fade, 1 ) ;
			}
			else
			{
				doTransition( &m_pnlBackgroundSelect, &m_pnlSplashGame, m_skin.fade, 1 ) ;
			}
		}
	}

	xbox_print_memory() ;
	//memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size) ;

	if ( !m_bBgmInGame )
	{
		//m_mp3player.pause( TRUE ) ;
	}



	if ( !isOther )
	{
		loadKeys( g_keysfile ) ;
	}


	xbox_print_memory() ;


	m_numFrames = 0 ;

	//xbox_set_RAM_location() ;

	sprintfx("init\r\n") ;

	//PaletteChanged = 0 ;


	m_sound.init() ;


	sprintfx("init\r\n") ;

	xbox_print_memory() ;
	// Create our texture
	init_texture();

	//popupMsg( "is this panel on?", &m_pnlBackgroundOther) ;
	//popupMsg( "is this panel on?", &m_pnlGameScreen2) ;

	//m_pnlGameScreen.m_pTexture = NULL ;
	//m_pnlGameScreen.Create( m_pd3dDevice, Texture, FALSE, theWidth, theHeight ) ;

	sprintfx("init\r\n") ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	

	sprintfx("init\r\n") ;




	cht_load();


	m_state = IN_GAME ;



	sprintfx("init\r\n") ;

	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;

	m_steps = 0 ;
	m_sound.pause( FALSE ) ;


	strcpy( uprfilename, filename ) ;
	strupr( uprfilename ) ;


	int numdisks = 0 ;


	sprintfx( "about to vba_main %s\r\n", filename ) ;



	//m_plaything.FreeSprites() ;
	freeTextures() ;


	if ( Keyboard_Init( 25, 500, 50 ) )
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard success\n" );
	}
	else
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard failure\n" );
	}

	memset(keyboard_keystate, 0, 256 ) ;

	QueryPerformanceCounter((union _LARGE_INTEGER *) m_performancePrev);

	//xbox_set_refreshrate( pProperties->ntscmode ? 60 : 50 ) ;


	D3DPRESENT_PARAMETERS newpp ;

	memcpy( &newpp, &m_d3dpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		DWORD videoFlags = XGetVideoFlags();
		
		if ( 1 ) //NTSC or PAL setting?
		{
			if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			{
				newpp.FullScreen_RefreshRateInHz = 60 ;
			}
		}
		else
		{
			newpp.FullScreen_RefreshRateInHz = 50 ;
		}
	}

	
	if ( newpp.FullScreen_RefreshRateInHz  != m_d3dpp.FullScreen_RefreshRateInHz  )
	{

		memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

		recreate( &m_d3dpp ) ;
		memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;
		m_pd3dDevice->Reset(&newpp);
		memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

		g_app->m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 0.0f, 0L );
		g_app->m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_pd3dDevice->SetFlickerFilter( m_nFlickerLevel ) ;
		if ( m_bSoften )
			g_app->m_pd3dDevice->SetSoftDisplayFilter( TRUE ) ;

	}


	applyHardwareFilter() ;

#ifdef VIRTUAL_MEM
    __try {
#endif
		memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
		m_currentMemMatches = CONSOLE_MEMORY_SIZE ;

		int snes_WinMain( char *romfilename );

		createLocal( filename, filename, NULL, &zipnumber ) ;
		snes_WinMain( filename ) ;

#ifdef VIRTUAL_MEM
    } __except(ExceptionFilter(GetExceptionInformation())) {
		popupMsg( "Exception occurred - you should probably restart.", &m_pnlBackgroundOther ) ;
    };
#endif


	saveKeys( g_keysfile ) ;
	cleanupConsole() ;

	char tmpfilename[1024] ;

	//sprintf( tmpfilename, "%s\\%s\\SPRITES\\*", m_szSkinDir, m_szSkin) ;
	//m_plaything.LoadSprites( tmpfilename ) ;

	m_sound.cleanup() ;
	sprintfx( "done bliss\r\n") ;
	m_state = MAIN_MENU ;
#ifdef USE_NETPLAY
	m_sockNetplay.m_debugClientSock.Close() ;
#endif
	sprintfx( "done bliss\r\n") ;

}



void CXBoxSample::cleanupConsole( )
{
	//sram_save();
	//rtc_save();
	cht_save() ;


	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}

	if ( g_rumbleCodes != NULL )
	{
		free( g_rumbleCodes ) ;
		g_rumbleCodes = NULL ;
	}


}



#ifdef __cplusplus
extern "C" {
#endif


void sprintfx( const char *fmt, ... )
{
    va_list	va;
    va_start(va, fmt);
	vsprintf( gxmsg, fmt, va);
	va_end( va ) ;
	writexbox(gxmsg) ;
}


unsigned int xbox_getfix_Xa()  //disable xa
{
	return g_app->m_psxfix_Xa ;
}
unsigned int xbox_getfix_Sio()  //always sio irq on
{
	return g_app->m_psxfix_Sio ;
}
unsigned int xbox_getfix_Mdec()   //b/w movies
{
	return g_app->m_psxfix_Mdec ;
}
unsigned int xbox_getfix_Cdda()  //disable cdda
{
	return g_app->m_psxfix_Cdda ;
}
unsigned int xbox_getfix_Cpu()   //cpu interpreter (slow, maybe more compatible)
{
	return g_app->m_psxfix_Cpu ;
}
unsigned int xbox_getfix_SpuIrq()  //always spu irq on
{
	return g_app->m_psxfix_SpuIrq ;
}
unsigned int xbox_getfix_VSyncWA()   // InuYasha Sengoku Battle fix
{
	return g_app->m_psxfix_VSyncWA ;
}




long xbox_stop_cdda() 
{
	//writexbox("stop cdda\r\n") ;
	return 0 ;
}

unsigned int xbox_get_vandal_heart_fix() 
{
	return g_app->m_vandalFix ;
}

DWORD xbox_get_bit_depth() 
{
	return g_app->m_bitDepth ;

}

void xbox_set_memory_ptr( unsigned char *ptr )
{
	m_memory_locations[0] = ptr ;
}

unsigned int xbox_get_framelimit() 
{
	return g_app->m_framelimit ;
}
unsigned int xbox_get_frameskip() 
{
	return g_app->m_frameskip ;
}
unsigned int xbox_get_graphics_fixes() 
{
	//sprintfx("graphicfix=%02.2X\r\n", g_app->m_graphicsFixes ) ;

	return g_app->m_graphicsFixes ;
}

void xbox_clear_screen()
{
	g_app->ClearScreen() ;
}

unsigned char* xbox_get_biosfile() 
{
	return g_app->m_biosfile ;
}

unsigned char* xbox_get_memcard1() 
{
	return g_app->m_memcard1 ;
}

unsigned char* xbox_get_memcard2() 
{
	return g_app->m_memcard2 ;
}

unsigned char* xbox_get_saveprefix()
{
	return (unsigned char*)g_app->g_saveprefix ;
}

unsigned long xbox_get_bytes_buffered() 
{
	//return g_app->m_sound.get_buffered_bytes() ;
	return 0 ;
}

unsigned int xbox_get_pitch()
{
	return g_app->m_pitch ;
}

unsigned char *xbox_cdbuffer() 
{

	return (g_app->m_ptrCdBuf)+12 ;
}


void xbox_get_tn(unsigned char *ptr) 
{
	ptr[0]=1 ;
	ptr[1]=g_app->m_numtracks ;

}
void xbox_feed_stream(unsigned char* pSound,long lBytes) 
{
	g_app->m_sound.process(pSound, lBytes, g_app->m_throttle ) ;
	g_app->m_mp3player.process() ;
}
unsigned int getstatebuflen( void *sm )
{
	return ((StateMem*)sm)->len ;
}

int xbox_read_sector_type( unsigned int sector, unsigned int sector_type ) 
{
	unsigned char szbuf[6] ;
	DWORD numread ;
	//DWORD begintime, endtime ;
	//static DWORD totaltime = 1 ;
	//static DWORD iters = 0 ;
	//static DWORD cacheiters = 0 ;
	//static float avg = 0.0 ;

	//begintime = GetTickCount() ;

	//sprintfx("read sector %u\r\n", sector  ) ;

	if ( ( sector < g_app->m_currentStartSector ) || ( sector >= g_app->m_currentStartSector + CD_BUF_SECTORS ) )
	{
		if ( g_app->m_bRealCD )
		{
			memset( g_app->m_cdDataBuffer,0,2352) ;
			//for ( int i = 0 ; i < CD_BUF_SECTORS ; i++ )
				g_app->m_io.ReadXASector( g_app->m_hCdrom, sector, CD_BUF_SECTORS, g_app->m_cdDataBuffer ) ;
				//g_app->m_io.ReadXASector2( sector, CD_BUF_SECTORS, g_app->m_cdDataBuffer ) ;

			sprintfx( "read sector %u \r\n", sector ) ;

		}
		else
		{
			if ( g_app->m_bNetworkCD )
			{
				memcpy( szbuf, &sector, 4 ) ;
				szbuf[4] = 2 + sector_type ; //psx is all XA data (2) + 1 for data or 0 for cdda

				g_app->m_sockNetplay.Send( szbuf, 5 ) ;
				numread = g_app->m_sockNetplay.Recv( g_app->m_cdDataBuffer, 2352 ) ;

//				sprintfx("read sector %u bytes %u\r\n", sector, numread ) ;

				while ( numread < 2352 )
				{
					numread += g_app->m_sockNetplay.Recv( g_app->m_cdDataBuffer+numread, 2352-numread ) ;
					//sprintfx("read sector %u bytes %u\r\n", sector, numread ) ;
				}

			}
			else
			{
				if ( g_app->m_bUsingSamba )
				{
					g_app->m_smb.lseek(g_app->m_smbCdFile,sector*2352,SEEK_SET);
					g_app->m_smb.read(g_app->m_smbCdFile,g_app->m_cdDataBuffer, 2352*CD_BUF_SECTORS ) ;
				}
				else if ( m_bUsingRelax )
				{
					m_relax.Seek(sector*2352,SEEK_SET);
					m_relax.ReadAll(g_app->m_cdDataBuffer, 2352*CD_BUF_SECTORS ) ;
				}
				else
				{
					gzseek( g_app->m_cdfile, 2352*sector, SEEK_SET ) ;
					gzread( g_app->m_cdfile , g_app->m_cdDataBuffer, 2352*CD_BUF_SECTORS ) ;
				}
			}
		}


		g_app->m_currentStartSector = sector ;
	}
	else
	{
		//cacheiters++ ;
		//sprintfx("read sector %u from cache\r\n", sector  ) ;
	}
/*
	if ( sector==16 ) 
	{
		unsigned char dumpsec[200] ;

		for ( int i = 0 ; i < 16 ; i++ )
		{
			for ( int j = 0 ; j < 16 ; j++ )
			{
				sprintf( (char*)(dumpsec+3*j), "%2.2X ", *(g_app->m_cdDataBuffer+(i*16)+j) ) ;
			}
			dumpsec[48] = 0 ;
			sprintfx( "%s \r\n",dumpsec ) ;
		}
	}
*/
	g_app->m_ptrCdBuf = g_app->m_cdDataBuffer + ((sector-g_app->m_currentStartSector)*2352) ;

/*
	for ( int ii = 0 ; ii < 16 ; ii++ )
	{
		char msg[100] ;

		sprintf(msg, "%02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X %02.2X \r\n",
			g_app->m_ptrCdBuf[(ii*16)+0], g_app->m_ptrCdBuf[(ii*16)+1], g_app->m_ptrCdBuf[(ii*16)+2], g_app->m_ptrCdBuf[(ii*16)+3], g_app->m_ptrCdBuf[(ii*16)+4], 
			g_app->m_ptrCdBuf[(ii*16)+5], g_app->m_ptrCdBuf[(ii*16)+6], g_app->m_ptrCdBuf[(ii*16)+7], g_app->m_ptrCdBuf[(ii*16)+8], g_app->m_ptrCdBuf[(ii*16)+9], 
			g_app->m_ptrCdBuf[(ii*16)+10], g_app->m_ptrCdBuf[(ii*16)+11], g_app->m_ptrCdBuf[(ii*16)+12], g_app->m_ptrCdBuf[(ii*16)+13], g_app->m_ptrCdBuf[(ii*16)+14], g_app->m_ptrCdBuf[(ii*16)+15] ) ;
		writexbox(msg) ;
	}
*/
	/*
	for ( unsigned int i = 0 ; i < 60000 ; i++ )
	{
		numread = (5+numread) * (numread+1) ;
		avg = (avg+4.234) / ( avg+1.23) ;
	}

	iters++ ;
	endtime = GetTickCount() ;

	totaltime += (endtime - begintime ) ;

	avg = (float)totaltime / (float)iters ; 

	if ( ( begintime%1000 >= 0 ) && ( begintime%1000 < 10 ) )
		sprintfx( "avgreadtime = %f, citer/iter = %u/%u %f\r\n", avg, cacheiters, iters, (float)cacheiters/(float)iters ) ;
*/
	return 0 ;
	//memset(g_app->m_cdbuffer, 0, 2352) ;

	//return ( g_app->m_io.ReadSectorMode2( g_app->m_hCdrom, sector, (LPSTR)g_app->m_cdbuffer ) == -1 ) ;
}

int xbox_read_sector( unsigned int sector ) 
{
	return xbox_read_sector_type( sector,1 ) ;
}

int xbox_read_sector_cdda( unsigned int sector ) 
{
	return xbox_read_sector_type( sector,0 ) ;
}

unsigned long xbox_gettime()
{
	
	FILETIME ft ;

	GetSystemTimeAsFileTime( &ft ) ;

	return 0 ;
	//return ft.dwLowDateTime / 100 ;
	
	//return GetTickCount() ;
}
unsigned long xbox_gettime2()
{
	
	return GetTickCount() ;
}

void xbox_loading_msg( LPCTSTR msg ) 
{
//	g_app->WriteLoadMessage(msg) ;

}

void xbox_exception_msg( LPCTSTR msg ) 
{
	//g_app->WriteExceptionMessage(msg) ;

}

unsigned int xbox_read_input(int port) 
{
	//writexbox( "before readinput") ;

	//return 0 ;

	//MEMORYSTATUS stat;

    // Get the memory status.
    //GlobalMemoryStatus( &stat );

	//sprintfx("available memory = %u\r\n", stat.dwAvailPhys  ) ;


	return ReadJoypad( port ) ;

	//writexbox( "after readinput") ;
	//return 0 ;
}

unsigned char * xbox_get_screen_buffer()
{
	return g_app->g_pBlitBuff ;

}
int xbox_check_events()
{
	//writexbox( "before events") ;
	return g_app->handleEvents() ;
	//writexbox( "after events") ;
	return 0 ;
}
int xbox_get_throttlespeed()
{
	return m_throttleSpeed ;
}

void xbox_put_image(int w, int h, int pitch, unsigned char *surface ) 
{
	//writexbox( "before render") ;
	//g_mp3player->process() ;
	//g_app->m_cdda.process() ;

	//g_app->m_numFrames++ ;

	//if ( (g_app->m_numFrames % 180) == 0 )
		//sprintfx( "frames %u secs %u fps %.1f\r\n", g_app->m_numFrames, GetTickCount() - g_dwStartTime, ((float)g_app->m_numFrames*1000.0f)/((float)((GetTickCount() - g_dwStartTime) + 1)) );

	//g_app->handleEvents() ;
	//ReadJoypad(0) ;
	g_sound->process( NULL, 0, g_app->m_throttle ) ;

	if ( g_app->m_throttle )
	{
		g_app->m_throttle-- ;
	}

	if ( g_app->m_throttle == 0 )
		g_app->render_to_texture(w,h,pitch,surface) ;
	//writexbox( "after render") ;
}

void xbox_open_zip( char *hugozipfile )
{
	//writexbox( "before zip") ;
	//g_app->rom_load_zip( hugozipfile ) ;
	//writexbox( "after zip") ;
}

void xbox_set_RAM_location()
{
	m_memory_locations[0] = (unsigned char*)NULL ;
}

#ifdef __cplusplus
}
#endif

void CXBoxSample::processEmu( BOOL render )
{
			
			handleEvents();
			updateCheats() ;


//			doneFrame = 0 ;

			//m_nbytes = update_sound_main() ;



			if ( render )
			{
				//render_to_texture();
				m_numFrames++ ;
			}


//			m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;

			while ( m_sound.m_bDanger )
			{
				handleEvents();
				updateCheats() ;
//				doneFrame = 0 ;
				//m_nbytes = update_sound_main() ;


				//m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;
			}



}


int CXBoxSample::rom_load_zip( char *hugozipfile )
{
	return 1;
}

