/*
    Copyright (C) 1998, 1999, 2000  Charles Mac Donald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include "shared.h"
#include "unzip.h"

extern char *g_sramfile ;

t_bitmap bitmap;
t_cart cart;                
t_snd snd;
t_input input;
FM_OPL *ym3812;

#ifndef NULL
#define NULL 0
#endif

void system_init(int rate, int frequency)
{
    /* Initialize the VDP emulation */
    vdp_init();

    /* Initialize the SMS emulation */
    sms_init();

    /* Initialize the look-up tables and related data */
    render_init();

    /* Enable sound emulation if the sample rate was specified */
    audio_init(rate, frequency);

    /* Don't save SRAM by default */
    sms.save = 0;

    /* Clear emulated button state */
    memset(&input, 0, sizeof(t_input));
}

void audio_init(int rate, int frequency)
{
    /* Clear sound context */
    memset(&snd, 0, sizeof(t_snd));

    /* Reset logging data */
    snd.log = 0;
    snd.callback = NULL;

    /* Oops.. sound is disabled */
    if(!rate) return;

    /* Calculate buffer size in samples */
    snd.bufsize = (rate / frequency);

    /* Sound output */
    snd.buffer = (signed short int *)malloc(snd.bufsize * 4);
    if(!snd.buffer) return;

    /* YM3812/YM2413 sound stream */
    snd.fm_buffer = (signed short int *)malloc(snd.bufsize * 2);
    if(!snd.fm_buffer) return;

    /* SN76489 sound stream */
    snd.psg_buffer[0] = (signed short int *)malloc(snd.bufsize * 2);
    snd.psg_buffer[1] = (signed short int *)malloc(snd.bufsize * 2);
    if(!snd.psg_buffer[0] || !snd.psg_buffer[1]) return;

    /* Set up SN76489 emulation */
    SN76496_init(0, MASTER_CLOCK, 255, rate);

    /* Set up YM3812 emulation */
    ym3812 = OPLCreate(OPL_TYPE_YM3812, MASTER_CLOCK, rate);
    if(!ym3812) return;

    /* Set up YM2413 emulation */
    ym2413_init(1);

    /* Inform other functions that we can use sound */
    snd.enabled = 1;
}


void system_shutdown(void)
{
    if(snd.enabled) OPLDestroy(ym3812);
}


void LoadSRAM(char *filename)
{
	FILE *f ;

	f = fopen( filename, "rb" ) ;

	if ( !f )
		return ;

	fread( sms.sram, sizeof(char), 0x8000, f ) ;
	fclose( f ) ;

	sms.save = 1;
}
char* xbox_get_sramfile();

void system_reset(void)
{
    cpu_reset();
    vdp_reset();
    sms_reset();
    render_reset();
    LoadSRAM( xbox_get_sramfile() );
    if(snd.enabled)
    {
        OPLResetChip(ym3812);
        ym2413_reset(0);
    }
}

void OpenROMZip( char *zipname )
{

	int FileSize ;
	char filename[132];
	int port ; 
	unz_file_info info;
	char name[132];
	unzFile file ;

	FileSize = 0 ;

    file = unzOpen(zipname);

    if(file == NULL)
		return ;

	port = unzGoToFirstFile(file);

    while(port == UNZ_OK)
    {
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ((int) info.uncompressed_size > FileSize)
		{
			strcpy(filename,name);
			FileSize = info.uncompressed_size;
		}
		port = unzGoToNextFile(file);
    }

    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || FileSize == 0)
    {
		unzClose(file) ;
		return ;
    }

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		return ;
    }

	FileSize = info.uncompressed_size  ;
	
	if (info.uncompressed_size < 0x8000) 
	{
		free(cart.rom) ;
	    unzClose(file);
		return;
	}

	if ((FileSize / 512) & 1)
	{
		//fseek( f, 512, SEEK_SET ) ;
		FileSize -= 512;
	}

	if (!stricmp(&filename[strlen(filename) - 2], "gg"))
	{
		cart.type  = TYPE_GG;
	}
	else
	{
		cart.type  = TYPE_SMS;
	}

	cart.pages = (FileSize / 0x4000);

	if (cart.rom) 
		free(cart.rom);

	cart.rom = (byte*)malloc( info.uncompressed_size ) ;

	unzReadCurrentFile(file,cart.rom,info.uncompressed_size);

	
	
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(cart.rom) ;
	    unzClose(file);
		return ;
	}

    unzClose(file);

	if ( FileSize != info.uncompressed_size )
	{
		memmove( cart.rom, cart.rom + 512, FileSize ) ;
	}
}

void UpdateSoundRecording(int Data)
{
}

void OpenROM(char *pROM)
{
	FILE *f ;
	int				FileSize;
	int				BytesRead;
	int				i;
	char			*Filename ;

	Filename = pROM ;

	if (!stricmp(&Filename[strlen(Filename) - 3], "zip"))
	{
		OpenROMZip( pROM ) ;
	}
	else
	{
		f = fopen( Filename, "rb" ) ;

		if ( !f )
			return ;

		fseek( f, 0, SEEK_END ) ;
		FileSize = ftell( f ) ;
		fseek( f, 0, SEEK_SET ) ;

		if (FileSize < 0x8000) 
		{
			fclose(f) ;
			return;
		}

		if ((FileSize / 512) & 1)
		{
			fseek( f, 512, SEEK_SET ) ;
			FileSize -= 512;
		}

		if (!stricmp(&Filename[strlen(Filename) - 2], "gg"))
		{
			cart.type  = TYPE_GG;
		}
		else
		{
			cart.type  = TYPE_SMS;
		}

		cart.pages = (FileSize / 0x4000);
    
		if (cart.rom) free(cart.rom);
		cart.rom = malloc(FileSize);
    
		if (!cart.rom)
		{
			fclose(f) ;
			return;
		}

		fread( cart.rom, sizeof(char), FileSize, f ) ;
		fclose( f ) ;
	}


}


void SaveSRAM(char *fname)
{
	FILE	*f ;



	if (sms.save )
	{
		f = fopen ( fname, "wb" ) ;

		if ( !f )
			return ;

		fwrite( sms.sram, sizeof(char), 0x8000, f ) ;
		fclose( f ) ;
	}
}

