#include <windows.h>
#include "shared.h"
#include "dinput.h"
#include "main.h"
#include "input.h"
#include "registry.h"

REGISTRY_INFO								RegistryInfo;

// Sets up the default registry entries, either for first time use
// or incase the load registry entries fails
void InitRegistryEntries(void)
{
	unsigned char	ButtonMap[MAX_PLAYERS][NO_OF_BUTTONS] = REGISTRY_DEFAULT_BUTTON_MAP;
	char			TempPath[MAX_PATH];
	int				i, j;

	GetTempPath(MAX_PATH, TempPath);

	memset(&RegistryInfo, 0, sizeof(REGISTRY_INFO));

	RegistryInfo.ScreenScale	 = REGISTRY_DEFAULT_SCREEN_SCALE;
	RegistryInfo.UpdateFrequency = REGISTRY_DEFAULT_UPDATE_FREQUENCY;
	RegistryInfo.FrameSkip		 = REGISTRY_DEFAULT_FRAME_SKIP;
	memcpy(RegistryInfo.ButtonMap, ButtonMap, sizeof(ButtonMap));
	strcpy(RegistryInfo.ROMPath, REGISTRY_DEFAULT_ROM_PATH);
	strcpy(RegistryInfo.SRAMPath, TempPath);
	strcpy(RegistryInfo.ScreenshotPath, REGISTRY_DEFAULT_SCREENSHOT_PATH);
	strcpy(RegistryInfo.SaveStatePath, REGISTRY_DEFAULT_SAVESTATE_PATH);
	strcpy(RegistryInfo.SoundRecordPath, REGISTRY_DEFAULT_SOUND_PATH);

	for (j = 0 ; j < 2 ; j++)
	{
		for (i = 0 ; i < sizeof(RegistryInfo.JoystickMap) ; i++)
		{
			RegistryInfo.JoystickMap[j][i] = i;
		}

		strcpy(RegistryInfo.Joystick[j], "");
		RegistryInfo.DisableKeys[j]   = REGISTRY_DEFAULT_DISABLE_KEYS;
		RegistryInfo.RapidFireRate[j] = REGISTRY_DEFAULT_RAPID_FIRE_RATE;
	}

	RegistryInfo.EnableSound	 = REGISTRY_DEFAULT_SOUND_ENABLE;
	RegistryInfo.EnableFMSound	 = REGISTRY_DEFAULT_SOUND_ENABLE;
	RegistryInfo.SoundFrequency	 = REGISTRY_DEFAULT_SOUND_FREQUENCY;
	memset(RegistryInfo.RapidFire, 0, sizeof(RegistryInfo.RapidFire));
	RegistryInfo.Region			 = REGISTRY_DEFAULT_REGION;
	RegistryInfo.SingleSaveState = REGISTRY_DEFAULT_SINGLE_SAVESTATE;
	RegistryInfo.Gamma			 = REGISTRY_DEFAULT_GAMMA;
	RegistryInfo.ScreenSmoothing = REGISTRY_DEFAULT_SCREEN_SMOOTHING;
	RegistryInfo.FullScreenMode  = REGISTRY_DEFAULT_FULL_SCREEN_MODE;
	RegistryInfo.FullScreen		 = REGISTRY_DEFAULT_FULL_SCREEN;
	RegistryInfo.EnableDirectDraw= REGISTRY_DEFAULT_DIRECT_DRAW_ENABLE;
	RegistryInfo.EnableScanLines = REGISTRY_DEFAULT_SCANLINES;
	RegistryInfo.FMVolume		 = REGISTRY_DEFAULT_FM_VOLUME;
}

// Loads the settings from the registry
BOOL LoadRegistryEntries(void)
{
	char			Key[_MAX_PATH];
	int				Result;
	HKEY			hkey;
	unsigned long	DataSize;

	wsprintf(Key, "Software%s", REGISTRY_KEY);
	
	Result = RegOpenKeyEx(HKEY_CURRENT_USER,	// handle
						  Key,					// subkey
						  0,
						  KEY_READ,				// access mask
						  &hkey);				// pointer to recieving handle

	if (Result != ERROR_SUCCESS) return FALSE;

	DataSize = sizeof(RegistryInfo.ScreenScale);
	RegQueryValueEx(hkey, REGISTRY_SCREEN_SCALE, NULL, NULL, (LPBYTE)&RegistryInfo.ScreenScale, &DataSize);
	DataSize = sizeof(RegistryInfo.UpdateFrequency);
	RegQueryValueEx(hkey, REGISTRY_UPDATE_FREQUENCY, NULL, NULL, (LPBYTE)&RegistryInfo.UpdateFrequency, &DataSize);
	DataSize = sizeof(RegistryInfo.FrameSkip);
	RegQueryValueEx(hkey, REGISTRY_FRAME_SKIP, NULL, NULL, (LPBYTE)&RegistryInfo.FrameSkip, &DataSize);
	DataSize = sizeof(RegistryInfo.ButtonMap);
	RegQueryValueEx(hkey, REGISTRY_BUTTON_MAP, NULL, NULL, (LPBYTE)&RegistryInfo.ButtonMap, &DataSize);
	DataSize = sizeof(RegistryInfo.ROMPath);
	RegQueryValueEx(hkey, REGISTRY_ROM_PATH, NULL, NULL, (LPBYTE)&RegistryInfo.ROMPath, &DataSize);
	DataSize = sizeof(RegistryInfo.SRAMPath);
	RegQueryValueEx(hkey, REGISTRY_SRAM_PATH, NULL, NULL, (LPBYTE)&RegistryInfo.SRAMPath, &DataSize);
	DataSize = sizeof(RegistryInfo.ScreenshotPath);
	RegQueryValueEx(hkey, REGISTRY_SCREENSHOT_PATH, NULL, NULL, (LPBYTE)&RegistryInfo.ScreenshotPath, &DataSize);
	DataSize = sizeof(RegistryInfo.SaveStatePath);
	RegQueryValueEx(hkey, REGISTRY_SAVESTATE_PATH, NULL, NULL, (LPBYTE)&RegistryInfo.SaveStatePath, &DataSize);
	DataSize = sizeof(RegistryInfo.SoundRecordPath);
	RegQueryValueEx(hkey, REGISTRY_SOUND_PATH, NULL, NULL, (LPBYTE)&RegistryInfo.SoundRecordPath, &DataSize);
	DataSize = sizeof(RegistryInfo.Joystick);
	RegQueryValueEx(hkey, REGISTRY_JOYSTICK, NULL, NULL, (LPBYTE)&RegistryInfo.Joystick, &DataSize);
	DataSize = sizeof(RegistryInfo.JoystickMap);
	RegQueryValueEx(hkey, REGISTRY_JOYSTICK_MAP, NULL, NULL, (LPBYTE)&RegistryInfo.JoystickMap, &DataSize);
	DataSize = sizeof(RegistryInfo.EnableSound);
	RegQueryValueEx(hkey, REGISTRY_SOUND_ENABLE, NULL, NULL, (LPBYTE)&RegistryInfo.EnableSound, &DataSize);
	DataSize = sizeof(RegistryInfo.EnableFMSound);
	RegQueryValueEx(hkey, REGISTRY_SOUND_FM_ENABLE, NULL, NULL, (LPBYTE)&RegistryInfo.EnableFMSound, &DataSize);
	DataSize = sizeof(RegistryInfo.SoundFrequency);
	RegQueryValueEx(hkey, REGISTRY_SOUND_FREQUENCY, NULL, NULL, (LPBYTE)&RegistryInfo.SoundFrequency, &DataSize);
	DataSize = sizeof(RegistryInfo.RapidFire);
	RegQueryValueEx(hkey, REGISTRY_RAPID_FIRE, NULL, NULL, (LPBYTE)&RegistryInfo.RapidFire, &DataSize);
	DataSize = sizeof(RegistryInfo.RapidFireRate);
	RegQueryValueEx(hkey, REGISTRY_RAPID_FIRE_RATE, NULL, NULL, (LPBYTE)&RegistryInfo.RapidFireRate, &DataSize);
	DataSize = sizeof(RegistryInfo.DisableKeys);
	RegQueryValueEx(hkey, REGISTRY_DISABLE_KEYS, NULL, NULL, (LPBYTE)&RegistryInfo.DisableKeys, &DataSize);
	DataSize = sizeof(RegistryInfo.Region);
	RegQueryValueEx(hkey, REGISTRY_REGION, NULL, NULL, (LPBYTE)&RegistryInfo.Region, &DataSize);
	DataSize = sizeof(RegistryInfo.SingleSaveState);
	RegQueryValueEx(hkey, REGISTRY_SINGLE_SAVESTATE, NULL, NULL, (LPBYTE)&RegistryInfo.SingleSaveState, &DataSize);
	DataSize = sizeof(RegistryInfo.Gamma);
	RegQueryValueEx(hkey, REGISTRY_GAMMA, NULL, NULL, (LPBYTE)&RegistryInfo.Gamma, &DataSize);
	DataSize = sizeof(RegistryInfo.ScreenSmoothing);
	RegQueryValueEx(hkey, REGISTRY_SCREEN_SMOOTHING, NULL, NULL, (LPBYTE)&RegistryInfo.ScreenSmoothing, &DataSize);
	DataSize = sizeof(RegistryInfo.FullScreenMode);
	RegQueryValueEx(hkey, REGISTRY_FULL_SCREEN_MODE, NULL, NULL, (LPBYTE)&RegistryInfo.FullScreenMode, &DataSize);
	DataSize = sizeof(RegistryInfo.FullScreen);
	RegQueryValueEx(hkey, REGISTRY_FULL_SCREEN, NULL, NULL, (LPBYTE)&RegistryInfo.FullScreen, &DataSize);
	DataSize = sizeof(RegistryInfo.EnableDirectDraw);
	RegQueryValueEx(hkey, REGISTRY_DIRECT_DRAW_ENABLE, NULL, NULL, (LPBYTE)&RegistryInfo.EnableDirectDraw, &DataSize);
	DataSize = sizeof(RegistryInfo.EnableScanLines);
	RegQueryValueEx(hkey, REGISTRY_SCANLINES, NULL, NULL, (LPBYTE)&RegistryInfo.EnableScanLines, &DataSize);
	DataSize = sizeof(RegistryInfo.FMVolume);
	RegQueryValueEx(hkey, REGISTRY_FM_VOLUME, NULL, NULL, (LPBYTE)&RegistryInfo.FMVolume, &DataSize);

	RegCloseKey(hkey);			

	return TRUE;
}

// Saves the settings to the registry
BOOL SaveRegistryEntries(void)
{
	char			Key[_MAX_PATH];
	HKEY			hkey;
	DWORD			dwdisp;
	int				Result;

	wsprintf(Key, "Software%s", REGISTRY_KEY);

	Result = RegCreateKeyEx(HKEY_CURRENT_USER,			// handle
							Key,						// subkey
							0,							// reserved
							"",							// class string
							REG_OPTION_NON_VOLATILE,	// flags
							KEY_ALL_ACCESS,				// access mask	
							NULL,						// security attributes ptr
							&hkey,						// pointer to recieving handle
							&dwdisp);					// pointer to recieving disposition

	if (Result != ERROR_SUCCESS) return FALSE;

	RegSetValueEx(hkey, REGISTRY_SCREEN_SCALE, 0, REG_BINARY, (BYTE *)&RegistryInfo.ScreenScale, sizeof(RegistryInfo.ScreenScale));
	RegSetValueEx(hkey, REGISTRY_UPDATE_FREQUENCY, 0, REG_BINARY, (BYTE *)&RegistryInfo.UpdateFrequency, sizeof(RegistryInfo.UpdateFrequency));
	RegSetValueEx(hkey, REGISTRY_FRAME_SKIP, 0, REG_BINARY, (BYTE *)&RegistryInfo.FrameSkip, sizeof(RegistryInfo.FrameSkip));
	RegSetValueEx(hkey, REGISTRY_BUTTON_MAP, 0, REG_BINARY, (BYTE *)&RegistryInfo.ButtonMap, sizeof(RegistryInfo.ButtonMap));
	RegSetValueEx(hkey, REGISTRY_ROM_PATH, 0, REG_SZ, (BYTE *)RegistryInfo.ROMPath, strlen(RegistryInfo.ROMPath) + 1);
	RegSetValueEx(hkey, REGISTRY_SRAM_PATH, 0, REG_SZ, (BYTE *)RegistryInfo.SRAMPath, strlen(RegistryInfo.SRAMPath) + 1);
	RegSetValueEx(hkey, REGISTRY_SCREENSHOT_PATH, 0, REG_SZ, (BYTE *)RegistryInfo.ScreenshotPath, strlen(RegistryInfo.ScreenshotPath) + 1);
	RegSetValueEx(hkey, REGISTRY_SAVESTATE_PATH, 0, REG_SZ, (BYTE *)RegistryInfo.SaveStatePath, strlen(RegistryInfo.SaveStatePath) + 1);
	RegSetValueEx(hkey, REGISTRY_SOUND_PATH, 0, REG_SZ, (BYTE *)RegistryInfo.SoundRecordPath, strlen(RegistryInfo.SoundRecordPath) + 1);
	RegSetValueEx(hkey, REGISTRY_JOYSTICK, 0, REG_BINARY, (BYTE *)RegistryInfo.Joystick, sizeof(RegistryInfo.Joystick));
	RegSetValueEx(hkey, REGISTRY_JOYSTICK_MAP, 0, REG_BINARY, (BYTE *)&RegistryInfo.JoystickMap, sizeof(RegistryInfo.JoystickMap));
	RegSetValueEx(hkey, REGISTRY_SOUND_ENABLE, 0, REG_BINARY, (BYTE *)&RegistryInfo.EnableSound, sizeof(RegistryInfo.EnableSound));
	RegSetValueEx(hkey, REGISTRY_SOUND_FM_ENABLE, 0, REG_BINARY, (BYTE *)&RegistryInfo.EnableFMSound, sizeof(RegistryInfo.EnableFMSound));
	RegSetValueEx(hkey, REGISTRY_SOUND_FREQUENCY, 0, REG_BINARY, (BYTE *)&RegistryInfo.SoundFrequency, sizeof(RegistryInfo.SoundFrequency));
	RegSetValueEx(hkey, REGISTRY_RAPID_FIRE, 0, REG_BINARY, (BYTE *)&RegistryInfo.RapidFire, sizeof(RegistryInfo.RapidFire));
	RegSetValueEx(hkey, REGISTRY_RAPID_FIRE_RATE, 0, REG_BINARY, (BYTE *)&RegistryInfo.RapidFireRate, sizeof(RegistryInfo.RapidFireRate));
	RegSetValueEx(hkey, REGISTRY_DISABLE_KEYS, 0, REG_BINARY, (BYTE *)&RegistryInfo.DisableKeys, sizeof(RegistryInfo.DisableKeys));
	RegSetValueEx(hkey, REGISTRY_REGION, 0, REG_BINARY, (BYTE *)&RegistryInfo.Region, sizeof(RegistryInfo.Region));
	RegSetValueEx(hkey, REGISTRY_SINGLE_SAVESTATE, 0, REG_BINARY, (BYTE *)&RegistryInfo.SingleSaveState, sizeof(RegistryInfo.SingleSaveState));
	RegSetValueEx(hkey, REGISTRY_GAMMA, 0, REG_BINARY, (BYTE *)&RegistryInfo.Gamma, sizeof(RegistryInfo.Gamma));
	RegSetValueEx(hkey, REGISTRY_SCREEN_SMOOTHING, 0, REG_BINARY, (BYTE *)&RegistryInfo.ScreenSmoothing, sizeof(RegistryInfo.ScreenSmoothing));
	RegSetValueEx(hkey, REGISTRY_FULL_SCREEN_MODE, 0, REG_BINARY, (BYTE *)&RegistryInfo.FullScreenMode, sizeof(RegistryInfo.FullScreenMode));
	RegSetValueEx(hkey, REGISTRY_FULL_SCREEN, 0, REG_BINARY, (BYTE *)&RegistryInfo.FullScreen, sizeof(RegistryInfo.FullScreen));
	RegSetValueEx(hkey, REGISTRY_DIRECT_DRAW_ENABLE, 0, REG_BINARY, (BYTE *)&RegistryInfo.EnableDirectDraw, sizeof(RegistryInfo.EnableDirectDraw));
	RegSetValueEx(hkey, REGISTRY_SCANLINES, 0, REG_BINARY, (BYTE *)&RegistryInfo.EnableScanLines, sizeof(RegistryInfo.EnableScanLines));
	RegSetValueEx(hkey, REGISTRY_FM_VOLUME, 0, REG_BINARY, (BYTE *)&RegistryInfo.FMVolume, sizeof(RegistryInfo.FMVolume));
	
	RegCloseKey(hkey);

	return TRUE;
}

void SetFileAssociations(void)
{
	HKEY			hkey;
	DWORD			dwdisp;
	char			Filename[MAX_PATH];
	char			String[MAX_PATH];

	GetModuleFileName(GetModuleHandle(NULL), Filename, MAX_PATH);

	RegDeleteKey(HKEY_CLASSES_ROOT, ".sms");
	RegDeleteKey(HKEY_CLASSES_ROOT, "smsfile");
	RegDeleteKey(HKEY_CLASSES_ROOT, ".gg");
	RegDeleteKey(HKEY_CLASSES_ROOT, "ggfile");

	strcpy(String, "smsfile");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, ".sms", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	strcpy(String, "MasterSystem");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "smsfile", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	strcpy(String, "");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "smsfile\\Shell", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	String[0] = '"';
	memcpy(&String[1], Filename, strlen(Filename) + 1);
	strcat(String, "\" %1");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "smsfile\\Shell\\Emulate MasterSystem\\command", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	memcpy(String, Filename, strlen(Filename) + 1);
	strcat(String, ",0");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "smsfile\\DefaultIcon", 0, "",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	strcpy(String, "ggfile");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, ".gg", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	strcpy(String, "GameGear");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "ggfile", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	strcpy(String, "");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "ggfile\\Shell", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	String[0] = '"';
	memcpy(&String[1], Filename, strlen(Filename) + 1);
	strcat(String, "\" %1");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "ggfile\\Shell\\Emulate GameGear\\command", 0,	"",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);

	memcpy(String, Filename, strlen(Filename) + 1);
	strcat(String, ",0");
	RegCreateKeyEx(HKEY_CLASSES_ROOT, "ggfile\\DefaultIcon", 0, "",	REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &dwdisp);
	RegSetValueEx(hkey, "", 0, REG_SZ, (BYTE *)String, strlen(String) + 1);
	RegCloseKey(hkey);
}
