/*Shippy 1984 by Ryan Broomfield
Source code and graphics are copyright Ryan Broomfield 2004.
Music is copyright neoblaze 2004.
http://ship84.sourceforge.net
*/

#include <stdio.h>
#include "shippy.h"
#include "xtl.h"

#define TEXT_WHITE 0
#define TEXT_RED 1
#define TEXT_YELLOW 2
#define TEXT_CYAN 3


#define SHIPPY 0
#define BULLET 1
#define BULLWAVE 2
#define ORB 3
#define ENEMYSHIPPY 4
#define ENEMYHEART 5
#define ENEMYBULLET 6
#define ENEMYBHEART 7
#define EXPLOSION 8
#define POWERUP 9
#define STAR 10
#define PARTICLE 11
#define LEVELMESSAGE 12
#define MESSAGE 13
#define ANGRYFEZ 14
#define FEZBOMB 15
#define SPLASH -1
#define TITLE 1
#define DEMO 2
#define GAME 3
#define SCORES 4
#define INITIALS 5
#define POWER_RAPID 0
#define POWER_HELIX 1


struct SHIPPYINFO
{
    int x;
    int y;
    int dx;
    int dy;
    int type;
    int used;
    int special;
    int level;
    int health;
    int lives;
    char *msg;
};

struct HISCORE
{
    char name[4];
    int score;
    int level;
    int last;
};

//Shippy-related stuff here.
#define MAXSCORE 15
struct HISCORE winners[MAXSCORE];
#define MAXSHIPPY 384
struct SHIPPYINFO ShippyObjects[MAXSHIPPY];


int timeattack = 0;
int timelimit = 0;
int diedlast = 0;
int fps = 0;
int frames = 0;
int countframes = 0;
int BELATED = 0;
int gamestate = SPLASH;
int powerup = 0;
int powerupframe = 0;
int extralife = 50000;
int shipwait = 0;
int leftmonsters = 0;
int level = 0;
int gameover = 0;
int shots = 0;
int score = 0;
int highscore;
char acc[32];
char eff[32];
char bon[64];
char tim[64];
int aiwavelet[240];

char currchar = 'A';
int operational = 0;
int missedshots = 0;
int firedshots = 0;

int compare(const void *a, const void *b)
{
    struct HISCORE *test = (struct HISCORE *)a;
    struct HISCORE *test2 = (struct HISCORE *)b;
    return (*test2).score - (*test).score;
}

void PrintChar(char text, int x, int y, int textcolor)
{

    if(text>='A' && text<='Z')
    {
        SYSTEM_BLIT((text-'A')*8,textcolor*8,x,y,8,8);
    }
    else if(text>='0' && text<='9')
    {
        SYSTEM_BLIT(208 + ((text-'0') * 8),textcolor*8,x,y,8,8);
    }
    else if(text=='!')
    {
        SYSTEM_BLIT(288,textcolor*8,x,y,8,8);
    }
 
}

void PrintMessage(char *text, int x, int y, int textcolor)
{
    while(*text!=0)
    {
        if(*text>='A' && *text<='Z')
        {
            SYSTEM_BLIT((*text-'A')*8,textcolor*8,x,y,8,8);
        }
        else if(*text>='0' && *text<='9')
        {
            SYSTEM_BLIT(208 + ((*text-'0') * 8),textcolor*8,x,y,8,8);
        }
        else if(*text=='!')
        {
        SYSTEM_BLIT(288,textcolor*8,x,y,8,8);
        }
        
        ++text;
        x+=8;
    }
}


void DrawOverlay()
{
    int increment;
    char buf[64];
    int test;

    if(BELATED==1)
    {
        PrintMessage("GAME BELATED!",56,56,TEXT_YELLOW);
        PrintMessage("PRESS BUTTON 2 TO UNBELATE!",8,64,TEXT_WHITE);
        PrintMessage("PRESS BACKSPACE TO UNBELATE!",8,72,TEXT_WHITE);
    }
    switch(gamestate)
    {
        case DEMO:
            PrintMessage("DEMO MODE!",88,112,TEXT_YELLOW);
        case GAME:
	    
		if(timeattack>=0 && timelimit-timeattack>=0)
		{
		    sprintf(buf,"%i",timelimit-timeattack);
	            PrintMessage(buf,200,144,TEXT_WHITE);
		}
            
	   

            for(increment=0;increment<ShippyObjects[0].lives;++increment)
            {
                SYSTEM_BLIT(0,64,increment*16,144,16,16);
            }

            sprintf(buf,"%i",score);
            PrintMessage("1UP",0,0,TEXT_RED);
            PrintMessage(buf,0,8,TEXT_WHITE);
            PrintMessage("HIGH SCORE",80,0,TEXT_RED);
            sprintf(buf,"%i",highscore);
            PrintMessage(buf,((30-strlen(buf))/2)*8,8,TEXT_WHITE);
        
            if(powerupframe>0)
            {
                switch(powerup)
                {
                    case POWER_RAPID:
                        PrintMessage("GO UNLIMITED BULLETS!",64,152,TEXT_CYAN);
                    break;
                    
                    case POWER_HELIX:
                        PrintMessage("GO GO POWERUP HELIX!",64,152,TEXT_CYAN);
                    break;
        
                    default:
                        PrintMessage("GO GO POWERUP ERROR!",64,152,TEXT_CYAN);
                    break;
                }
            }
            break;
        case TITLE:
            PrintMessage("SHIPPY 1984!",56,16,TEXT_YELLOW);
            PrintMessage("PRESS BUTTON 1 TO START",24,24,TEXT_WHITE);
            PrintMessage("PRESS CTRL TO START",24,32,TEXT_WHITE);
            SYSTEM_BLIT(32,64,32,48,16,16);
            PrintMessage(" 100 POINTS PLUS BONUS",56,48,TEXT_CYAN);
            SYSTEM_BLIT(48,64,32,64,16,16);
            PrintMessage(" 500 POINTS PLUS BONUS",56,64,TEXT_CYAN);
            SYSTEM_BLIT(64,64,32,80,16,16);
            PrintMessage("2000 POINTS PLUS BONUS",56,80,TEXT_CYAN);
            PrintMessage("    ARE DANGEROUS",40,128,TEXT_WHITE);
            SYSTEM_BLIT(0,88,40,128,24,8);
            PrintMessage("  IS GOOD FOR YOU",40,136,TEXT_WHITE);      
            SYSTEM_BLIT(24,88,40,136,8,8);
            break;
        case INITIALS:
            PrintMessage("ENTER YOUR INITIALS!",48,64,TEXT_WHITE);
            PrintMessage("LEFT AND RIGHT CHANGE LETTER!",12,128,TEXT_WHITE);
            PrintMessage("BUTTON 1 CHOOSES A LETTER!",24,136,TEXT_WHITE);
            PrintMessage("BUTTON 2 DELETES A LETTER!",24,144,TEXT_WHITE);
            if(operational==2)
            {
                PrintChar(winners[14].name[0],48,80,TEXT_WHITE);
            }
            else if(operational==3)
            {
                PrintChar(winners[14].name[0],48,80,TEXT_WHITE);
                PrintChar(winners[14].name[1],56,80,TEXT_WHITE);
            }
            
            PrintChar(currchar,48+((operational-1)*8),80,TEXT_YELLOW);
            SYSTEM_BLIT(0,96,48+((operational-1)*8),88,8,8);
        break;

        case SCORES:
            PrintMessage("ALL TIME BEST PLAYERS",40,8,TEXT_YELLOW);      
            PrintMessage("NAME  LEVEL  SCORE",40,24,TEXT_CYAN);
            for(increment=0;increment<MAXSCORE-1;++increment)
            {
                  if(winners[increment].last==1) SYSTEM_BLIT(0,64,32,36+(8*increment),16,16);
                  sprintf(buf,"%i",winners[increment].score);
                  test = strlen(buf);
                  PrintMessage(buf,192-(test*8),40+(8*increment),TEXT_WHITE);
                  sprintf(buf,"%i",winners[increment].level);
                  test = strlen(buf);
                  PrintMessage(buf,130-(test*8),40+(8*increment),TEXT_WHITE);

                  PrintMessage(winners[increment].name,48,40+(8*increment),TEXT_WHITE);
            }
            break;
    }
}





int IsHit(int x1, int y1, int r1, int x2, int y2, int r2)
{
    int d = r1 + r2;
    int a = x2 - x1;
    int b = y2 - y1;
    if( a > d || a < -d || b > d || b < -d) return 0;
    return a*a + b*b < d*d;
}

int AddObject(int type, int x, int y, int level, int special, int health, char *msg, int dx, int dy)
{
    int increment;
    
    for(increment=0;increment<MAXSHIPPY;++increment)
    {
        if(ShippyObjects[increment].used==0)
        {
            ShippyObjects[increment].type = type;
            ShippyObjects[increment].x = x;
            ShippyObjects[increment].y = y;
            ShippyObjects[increment].used = 1;
            ShippyObjects[increment].special = special;
            ShippyObjects[increment].level = level;
            ShippyObjects[increment].dy = dy;
            ShippyObjects[increment].dx = dx;
            ShippyObjects[increment].msg = msg;
            ShippyObjects[increment].health = health;
            ShippyObjects[increment].lives = 2;
            return 1;            
        }
    }
    //Uh-oh
    return 0;
}


void NewGame(int mlevel)
{
    int increment;
    int adder;
    int accuracy;
    int courage;
    int bonus;
    float floatop;

    shots = 0;
    powerupframe = 0;
    switch(mlevel)
    {
        case -1:
            score = 0;
            for(increment=0;increment<MAXSHIPPY;++increment)
            {
                ShippyObjects[increment].used = 0;    
            }
            for(increment=0;increment<20;++increment)
            {
                AddObject(STAR,rand()%232+8,rand()%152+8,rand()%200+40,rand()%4+2,100,NULL,0,0);
            }
            shipwait = 900;
            break;
        case 1:
            score = 0;
            diedlast = 0;
            for(increment=0;increment<MAXSHIPPY;++increment)
            {
                ShippyObjects[increment].used = 0;    
            }
            AddObject(SHIPPY,128,300,0,0,100,NULL,0,0);
            AddObject(LEVELMESSAGE,0,0,mlevel,180,0,NULL,0,0);
            for(increment=0;increment<20;++increment)
            {
                AddObject(STAR,rand()%232+8,rand()%152+8,rand()%200+40,rand()%4+2,100,NULL,0,0);
            }
            for(increment=0;increment<15;++increment)
            {
                AddObject(ENEMYSHIPPY,8+((increment%15)*16),16+((increment/15)*32),1,50+rand()%100,10,NULL,0,0);
            }
            leftmonsters=15;
            AddObject(MESSAGE,0, 96,300,300,0,"PRESS BUTTON 1 TO FIRE GUNS!",0,0);
            AddObject(MESSAGE,0, 88,300,300,0,"PRESS CTRL TO FIRE GUNS!",0,0);
            AddObject(MESSAGE,0, 80,300,300,0,"READY",0,0);
            AddObject(MESSAGE,0, 80,180,480,0,"GO!",0,0);
            extralife = 50000;
            shipwait = 300;            
	    timelimit = (72 * 9) + (72 * mlevel);
            timeattack = -shipwait;
            missedshots = 0;
            firedshots = 0;

            break;
        default:
            for(increment=1;increment<MAXSHIPPY;++increment)
            {
                ShippyObjects[increment].used = 0;    
            }
            AddObject(LEVELMESSAGE,0,0,mlevel,300,0,NULL,0,0);

            for(increment=0;increment<20;++increment)
            {
                AddObject(STAR,rand()%232+8,rand()%152+8,rand()%200+40,rand()%4+2,100,NULL,0,0);
            }
            adder = 15 + (2*mlevel);
            if(adder>30) adder = 30;
            for(increment=0;increment<adder;++increment)
            {
                AddObject(ENEMYSHIPPY,8+((increment%15)*16),16+((increment/15)*32),1,50+rand()%100,10,NULL,0,0);
            }
            leftmonsters=adder;
            if(mlevel>5)
            {
                adder = mlevel - 5;
                if(adder>10) adder=10;
                for(increment=0;increment<adder;++increment)
                {
                    AddObject(ENEMYHEART,8+(increment*16),(rand()%110) + 16,(rand()%2)?-1:1,50+rand()%100,10,NULL,rand()%220+8,rand()%110+8);
                    
                }
                leftmonsters+=adder;
            }
            if(mlevel>10)
            {
                adder = mlevel - 10;
                if(adder>10) adder=10;
                for(increment=0;increment<adder;++increment)
                {
                    AddObject(ANGRYFEZ,(rand()%15)*16,(rand()%60)+32,(rand()%2)?-1:1,50+rand()%100,10,NULL,rand()%220+8,rand()%120+8);
                    
                }
                leftmonsters+=adder;
            }
            
            if(diedlast==1)
            {
	            AddObject(MESSAGE,0, 92,120,300,0,"READY",0,0);
	            AddObject(MESSAGE,0, 92,180,480,0,"GO!",0,0);
	
	            shipwait = 300;            
		    timelimit = (72 * 9) + (36*mlevel);
		    timeattack = -shipwait;
	            missedshots = 0;
	            firedshots = 0;
	            diedlast = 0;
		return;
            }

	    bonus = 0;
	    
            if(firedshots==0)
            {
      
	            bonus = 0;
        	    sprintf(acc,"COWARD AWARD! 0 SHOTS FIRED!");
            }
	    else if(firedshots==missedshots)
            {
	            bonus = 0;
        	    sprintf(acc,"TRIGGERHAPPY! HIT NO ENEMIES!");

            }

            else if(firedshots>=1 && missedshots>=1)
            {
	            bonus = ((firedshots*100)/(firedshots-missedshots))*20;
        	    sprintf(acc,"ACCURACY %i OF %i!",firedshots-missedshots,firedshots);
            }
            else if(firedshots>=1 && missedshots==0)
            {
	            bonus = 5000;
        	    sprintf(acc,"MARKSMAN 5000 POINTS");
            }
	    
            if(timeattack>=timelimit)
            {
                sprintf(eff,"NO TIME LEFT!");
		sprintf(bon,"TOTAL BONUS %i!",bonus);

            }
            else
            {
                sprintf(eff,"TIME LEFT %i",timelimit-timeattack);
                bonus+=(timelimit-timeattack)*10;
		sprintf(bon,"TOTAL TIME ATTACK BONUS %i!",bonus);
            }
            
            score+=bonus;
            AddObject(MESSAGE,0,32,180,180,0,acc,0,0);
            AddObject(MESSAGE,0,40,180,180,0,eff,0,0);
            AddObject(MESSAGE,0,48,180,180,0,bon,0,0);
            AddObject(MESSAGE,0, 92,120,300,0,"READY",0,0);
            AddObject(MESSAGE,0, 92,180,480,0,"GO!",0,0);

            shipwait = 300;            
	    timelimit = (72 * 9) + (36*mlevel);
	    timeattack = -shipwait;
            missedshots = 0;
            firedshots = 0;
            diedlast = 0;

            break;        
    }


}


void RenderShippy(int objnumber)
{

    char buf[30];
    if(ShippyObjects[objnumber].used==0) return;
    switch(ShippyObjects[objnumber].type)
    {
        case SHIPPY:
            if(ShippyObjects[objnumber].health > 0)
            {
                SYSTEM_BLIT(0,64,ShippyObjects[objnumber].x-8,ShippyObjects[objnumber].y-8,16,16);            
            }
        break;
        case ENEMYSHIPPY:
            if(shipwait<300) SYSTEM_BLIT(32,64,ShippyObjects[objnumber].x-8,ShippyObjects[objnumber].y-8,16,16);
            
        break;
        case ANGRYFEZ:
            if(shipwait<300) SYSTEM_BLIT(64,64,ShippyObjects[objnumber].x-8,ShippyObjects[objnumber].y-8,16,16);        
        break;
        case ENEMYHEART:
            if(shipwait<300) SYSTEM_BLIT(48,64,ShippyObjects[objnumber].x-8,ShippyObjects[objnumber].y-8,16,16);
        break;
        case EXPLOSION:
            if(ShippyObjects[objnumber].special<=31)
            {
                SYSTEM_BLIT((ShippyObjects[objnumber].special/8)*8,80,ShippyObjects[objnumber].x-8,ShippyObjects[objnumber].y-8,8,8);
            }
        break;
        
        case STAR:
            SYSTEM_BLIT((ShippyObjects[objnumber].level/64),104,ShippyObjects[objnumber].x,ShippyObjects[objnumber].y,1,1);
        break;

        case PARTICLE:
            SYSTEM_BLIT(((255-ShippyObjects[objnumber].level)/64),105,ShippyObjects[objnumber].x/64, ShippyObjects[objnumber].y/64,1,1);
        break;

        case POWERUP:
            SYSTEM_BLIT(24,88,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;    
        case LEVELMESSAGE:
            if(shipwait<300 && BELATED!=1)
            {
                sprintf(buf,"LEVEL %i",ShippyObjects[objnumber].level);
                PrintMessage(buf,((31-strlen(buf))/2)*8,104,TEXT_CYAN);
            }
        break;
        
        case MESSAGE:
            if(ShippyObjects[objnumber].special<ShippyObjects[objnumber].level && BELATED!=1) PrintMessage(ShippyObjects[objnumber].msg,((31-strlen(ShippyObjects[objnumber].msg))/2)*8,ShippyObjects[objnumber].y,TEXT_WHITE);
        break;

        case ENEMYBULLET:
            SYSTEM_BLIT(0,88,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;

        case FEZBOMB:
            SYSTEM_BLIT(16,88,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;


        case ENEMYBHEART:
            SYSTEM_BLIT(8,88,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;


        case BULLET:
            SYSTEM_BLIT(0,96,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;

        case BULLWAVE:
            SYSTEM_BLIT(8,96,ShippyObjects[objnumber].x-4,ShippyObjects[objnumber].y-4,8,8);
        break;

    }
}

int analyze()
{
	int tx;
	int checksum=0;	
	int checksum2=0;
	int movement=0;
	int distance,distance2;


	ShippyObjects[0].dx=1;

	for(tx=ShippyObjects[0].x-12;tx<ShippyObjects[0].x+12;++tx)
	{
		if(tx>=0 && tx<=239) checksum+=aiwavelet[tx];
	}
	if(checksum>256)
	{
			checksum=0;
			checksum2=0;

			distance=ShippyObjects[0].x-8;
			distance2=232-ShippyObjects[0].x;
			if(distance>distance2) distance=distance2;
			for(tx=ShippyObjects[0].x;tx>=ShippyObjects[0].x-distance;--tx)
			{
				if(tx>=0 && tx<=239) checksum+=aiwavelet[tx]+((ShippyObjects[0].x-tx));
			}
			for(tx=ShippyObjects[0].x;tx<=ShippyObjects[0].x+distance;++tx)
			{
				if(tx>=0 && tx<=239) checksum2+=aiwavelet[tx]+((tx-ShippyObjects[0].x));
			}
			if(checksum<checksum2) movement = -2;
			else movement=2;

	}
	else movement = 0;

        memset(aiwavelet,0,240*sizeof(int));
	return movement;

}

void DoAi(int number)
{
    int increment;
    int runsim;
    int tx,ty;
    if(ShippyObjects[number].used==0) return;

    switch(ShippyObjects[number].type)
    {
        case LEVELMESSAGE:
            --ShippyObjects[number].special;
            if(ShippyObjects[number].special<0) ShippyObjects[number].used=0;
        break;
        
        case MESSAGE:
            --ShippyObjects[number].special;
            if(ShippyObjects[number].special<0) ShippyObjects[number].used=0;
        break;
            
        case SHIPPY:

            if(ShippyObjects[number].health==0)
            {
                ShippyObjects[number].x = 150;
                ShippyObjects[number].y = 144;
                ShippyObjects[number].health=-180;
                --ShippyObjects[number].lives;
                if(ShippyObjects[number].lives<0)
                {
                    AddObject(MESSAGE,0, 48,360,480,0,"THE ANGRY FEZ HAS WON!",0,0);
                    AddObject(MESSAGE,0, 56,240,480,0,"GOOD LUCK NEXT TRY!",0,0);
                    AddObject(MESSAGE,0, 80,360,720,0,"THANK YOU FOR PLAYING!",0,0);
                    waitforkey=480;
                    
                    
                    
                    gameover=1;
                }
                return;
            }
            if(ShippyObjects[number].health<0)
            {
                ++ShippyObjects[number].health;
                if(ShippyObjects[number].health>=-1)
                {
                    ShippyObjects[number].health=10;
                    NewGame(level);
                }
                return;
            }

	    if(gamestate==GAME) runsim=jaction;
	    else
	    {
		if(rand()%60>30) runsim=1; else runsim=0;

	    }

            if(runsim && shipwait==0)
            {
                if(powerupframe>0)
                {
                
                    switch(powerup)
                    {
                        case POWER_RAPID:
                                if(ShippyObjects[number].special==0)
                                {
                                    if(shots<10)
                                    {
                                        AddObject(BULLET, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
										audio_play("d:\\data\\shot.wav");
                                        ++shots;
                                        ++firedshots;
                                    }
                                    ShippyObjects[number].special=1;
                                }

                        break;
                        
                        case POWER_HELIX:
                                if(ShippyObjects[number].special==0)
                                {
                                    if(shots<6)
                                    {
										audio_play("d:\\data\\helix.wav");
                                        AddObject(BULLWAVE, ShippyObjects[number].x-6, ShippyObjects[number].y-8,0,-16,0,NULL,0,0);
                                        AddObject(BULLWAVE, ShippyObjects[number].x+6, ShippyObjects[number].y-8,0,16,0,NULL,0,0);
                                        shots+=2;
                                        firedshots+=2;

                                
                                    }
                                    ShippyObjects[number].special=1;
                                }
    
                        break;
                    
                    }
                    
                }
                else
                {
                        if(ShippyObjects[number].special==0)
                        {
                            if(shots<3)
                            {
                                AddObject(BULLET, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
								audio_play("d:\\data\\shot.wav");
                                ++shots;
                                ++firedshots;
                            }
                            ShippyObjects[number].special=1;
                        }
                }
            }
            else
            {
                ShippyObjects[number].special=0;
            }
            
            if(gamestate==GAME)
            {

                ShippyObjects[number].x += jdirx;
                ShippyObjects[number].y += jdiry;
            }
            else
            {
		
		if(shipwait==0)	ShippyObjects[number].x+=analyze();
		else
		{
			if(ShippyObjects[number].x>118) ShippyObjects[number].x-=2;
			if(ShippyObjects[number].x<118) ShippyObjects[number].x+=2;
		}
		
            }

            if(ShippyObjects[number].x<8) ShippyObjects[number].x=8;
            if(ShippyObjects[number].y<96) ShippyObjects[number].y=96;
            if(ShippyObjects[number].x>232) ShippyObjects[number].x=232;
            if(ShippyObjects[number].y>144) ShippyObjects[number].y=144;
        break;

        case ENEMYHEART:
        case ENEMYSHIPPY:
        case ANGRYFEZ:
            if(shipwait>300) return;
            

            if(ShippyObjects[number].type==ENEMYHEART)
            {
                if(IsHit(ShippyObjects[number].dx,ShippyObjects[number].dy,32,ShippyObjects[number].x,ShippyObjects[number].y,8))
                {
                    ShippyObjects[number].dx = (rand()%220)+8;
                    ShippyObjects[number].dy = (rand()%100)+8;
                
                }
                else
                {
                    if(ShippyObjects[number].x<ShippyObjects[number].dx) ShippyObjects[number].x++;
                    else if(ShippyObjects[number].x>ShippyObjects[number].dx) ShippyObjects[number].x--;
                    if(ShippyObjects[number].y<ShippyObjects[number].dy) ShippyObjects[number].y++;
                    else if(ShippyObjects[number].y>ShippyObjects[number].dy) ShippyObjects[number].y--;
                }
            }
            else if(ShippyObjects[number].type==ENEMYSHIPPY)
            {
                ShippyObjects[number].x+=ShippyObjects[number].level;

            }
            else if(ShippyObjects[number].type==ANGRYFEZ)
            {

                if(IsHit(ShippyObjects[number].dx,ShippyObjects[number].dy,64,ShippyObjects[number].x,ShippyObjects[number].y,8))
                {
                    ShippyObjects[number].dx = (rand()%15)*16;
                    ShippyObjects[number].dy = ((rand()%6)*16)+32;
                    ShippyObjects[number].lives = 0;
                
                }
                else
                {
                    if(ShippyObjects[number].lives != 0)
                    {
                        if(ShippyObjects[number].x<ShippyObjects[0].x-48) ShippyObjects[number].x++;
                        else if(ShippyObjects[number].x>ShippyObjects[0].x+48) ShippyObjects[number].x--;
                        if(ShippyObjects[number].y<ShippyObjects[number].dy) ShippyObjects[number].y++;
                        else if(ShippyObjects[number].y>ShippyObjects[number].dy) ShippyObjects[number].y--;
                    }
                }

            }


            if(ShippyObjects[number].special<=0)
            {
                if(shipwait==0)
                {
                    if(ShippyObjects[number].type==ENEMYHEART) AddObject(ENEMYBHEART, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
                    else if(ShippyObjects[number].type==ENEMYSHIPPY) AddObject(ENEMYBULLET, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
                    else if(ShippyObjects[number].type==ANGRYFEZ)
                    {
                        AddObject(ENEMYBULLET, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
                        AddObject(FEZBOMB, ShippyObjects[number].x, ShippyObjects[number].y,0,0,0,NULL,0,0);
                        ShippyObjects[number].lives = 1;
                    }
                }
                
                ShippyObjects[number].special=200+(rand()%400);
            }
            else
            {
                --ShippyObjects[number].special;
            }

            if(ShippyObjects[number].x<-7 || ShippyObjects[number].x>247 && ShippyObjects[number].type==ENEMYSHIPPY)
            {
                ShippyObjects[number].y+=16;
                ShippyObjects[number].level=-ShippyObjects[number].level;
                if((ShippyObjects[number].y>120 && ShippyObjects[number].y<=130) || leftmonsters<5+level)
                {
                    if((ShippyObjects[number].y/4)&1)
                    {
                        if(ShippyObjects[number].level<0) --ShippyObjects[number].level;
                        else ++ShippyObjects[number].level;
                    }
                }
                
            }
            if(IsHit(ShippyObjects[number].x, ShippyObjects[number].y, 8, ShippyObjects[0].x, ShippyObjects[0].y, 8))
            {
                    #ifndef GODMODE
                    if(ShippyObjects[0].health>0 && shipwait==0)
                    {
                        ShippyObjects[0].health=0;
                        for(runsim=0;runsim<MAXSHIPPY;++runsim)
                        {
                            AddObject(PARTICLE,
                                                    ShippyObjects[number].x*64,
                                                    ShippyObjects[number].y*64,
                                                    (rand()%3>1)?255:0,
                                                    255,
                                                    0,
                                                    NULL,
                                                    ((rand()%3)-1)*(64+(rand()%256)),
                                                    ((rand()%3)-1)*(64+(rand()%256))
                                                    );
                        }
                        diedlast = 1;
                    
						audio_play("d:\\data\\die.wav");
                        ShippyObjects[number].type=EXPLOSION;
                        ShippyObjects[number].special=4;
                    }
                    #endif

            }
            
            if(ShippyObjects[number].y<8) ShippyObjects[number].y=8;
            if(ShippyObjects[number].y>147)
            {
                ShippyObjects[number].used=0;
                --leftmonsters;
            }
            
            
        break;



        case EXPLOSION:
            --ShippyObjects[number].special;
            if(ShippyObjects[number].special<0)
            {
                if((rand()%100)>1)
                {
                    ShippyObjects[number].used=0;
                }
                else
                {
                    ShippyObjects[number].type=POWERUP;
                    ShippyObjects[number].dx=rand()%2;
                }
            }
        break;

        case BULLET:
        case BULLWAVE:
        
            if(ShippyObjects[number].type==BULLET)
            {
                ShippyObjects[number].y-=2;
                
            }
            if(ShippyObjects[number].type==BULLWAVE)
            {
                ShippyObjects[number].y-=2;
                if(ShippyObjects[number].special==1 || ShippyObjects[number].special==-1)
                {
                    ShippyObjects[number].special=-ShippyObjects[number].special*32;
                }
                if(ShippyObjects[number].special<0)
                {
                    --ShippyObjects[number].x;
                    ++ShippyObjects[number].special;
                }
                else
                {
                    ++ShippyObjects[number].x;
                    --ShippyObjects[number].special;
                }
            }
    
            if(ShippyObjects[number].y<0 || ShippyObjects[number].x<0 || ShippyObjects[number].x>239 || ShippyObjects[number].y>159)
            {
                ShippyObjects[number].used=0;
                --shots;
                ++missedshots;
                return;
            }
            else
            {
                for(increment=0;increment<MAXSHIPPY;++increment)
                {
                    if((ShippyObjects[increment].type==ENEMYSHIPPY || ShippyObjects[increment].type == ANGRYFEZ || ShippyObjects[increment].type==ENEMYHEART || ShippyObjects[increment].type==ENEMYBHEART ||  ShippyObjects[increment].type==FEZBOMB) && ShippyObjects[increment].used==1)
                    {
                        if(IsHit(ShippyObjects[number].x, ShippyObjects[number].y, 2, ShippyObjects[increment].x, ShippyObjects[increment].y, 8))
                        {
                            ShippyObjects[increment].used=0;
                            ShippyObjects[number].used=0;

                            if(ShippyObjects[increment].type==ENEMYSHIPPY || ShippyObjects[increment].type==ENEMYHEART || ShippyObjects[increment].type==ANGRYFEZ) --leftmonsters;
                            switch(ShippyObjects[increment].type)
                            {
                                case ANGRYFEZ:
                                    score+=2000+ShippyObjects[increment].y;
                                    --shots;
                                    for(runsim=0;runsim<3;++runsim)
                                    {
                                        AddObject(EXPLOSION,
                                                 ShippyObjects[increment].x + ((rand()%3)-1)*4,
                                                 ShippyObjects[increment].y + ((rand()%3)-1)*4,
                                                 0,
                                                 rand()%48,
                                                 0,
                                                 NULL,
                                                 0,
                                                 0);
                                         
                                     }
									audio_play("d:\\data\\hit.wav");
                                break;

                                case ENEMYSHIPPY:
                                    score+=100+ShippyObjects[increment].y;
                                    --shots;
                                    for(runsim=0;runsim<3;++runsim)
                                    {
                                        AddObject(EXPLOSION,
                                                 ShippyObjects[increment].x + ((rand()%3)-1)*4,
                                                 ShippyObjects[increment].y + ((rand()%3)-1)*4,
                                                 0,
                                                 rand()%48,
                                                 0,
                                                 NULL,
                                                 0,
                                                 0);
                                     }
									audio_play("d:\\data\\hit.wav");
                                     break;

				 case FEZBOMB:
					AddObject(ENEMYBHEART, ShippyObjects[number].x, ShippyObjects[number].y-16,0,0,0,NULL,0,0);
                                 case ENEMYHEART:
                                    if(ShippyObjects[increment].type==ENEMYHEART) score+=500+ShippyObjects[increment].y;
                                 case ENEMYBHEART:
                                    --shots;
                                    for(runsim=0;runsim<3;++runsim)
                                    {
                                        AddObject(EXPLOSION,
                                                 ShippyObjects[increment].x + ((rand()%3)-1)*4,
                                                 ShippyObjects[increment].y + ((rand()%3)-1)*4,
                                                 0,
                                                 rand()%48,
                                                 0,
                                                 NULL,
                                                 0,
                                                 0);
                                     }
									audio_play("d:\\data\\hit.wav");
                                    break;
                            
                            }
                            return;
                        }
                    }
                        
                }

            }
        break;

        case STAR:
            ShippyObjects[number].y+=ShippyObjects[number].special;
            if(ShippyObjects[number].y>159) ShippyObjects[number].y=0;
        break;
        
        case PARTICLE:
            ShippyObjects[number].y+=ShippyObjects[number].dy;
            ShippyObjects[number].x+=ShippyObjects[number].dx;
            ShippyObjects[number].special-=4;
            ShippyObjects[number].level-=4;
            
            if(ShippyObjects[number].y<0 || ShippyObjects[number].y>20416 || ShippyObjects[number].x<0 || ShippyObjects[number].x>15296 || (ShippyObjects[number].special < 0 || ShippyObjects[number].level < 0 )) ShippyObjects[number].used=0;
        break;

        case POWERUP:
            ShippyObjects[number].y+=1;
            if(ShippyObjects[number].y>144) ShippyObjects[number].y=144;
            if(IsHit(ShippyObjects[number].x, ShippyObjects[number].y, 4, ShippyObjects[0].x, ShippyObjects[0].y, 8) && ShippyObjects[0].health>0)
            {
                ++ShippyObjects[0].level;
                ShippyObjects[number].used=0;
                powerup = ShippyObjects[number].dx;
                powerupframe = 360;
                return;
            }
                
        break;


        case FEZBOMB:
        case ENEMYBHEART:
        case ENEMYBULLET:

            if(ShippyObjects[number].type==ENEMYBHEART)
            {
                if(ShippyObjects[number].x<ShippyObjects[0].x) ++ShippyObjects[number].x;
                else --ShippyObjects[number].x;
            
            
            }
            if(ShippyObjects[number].type==FEZBOMB)
            {
                if(ShippyObjects[number].x<ShippyObjects[0].x-6) ++ShippyObjects[number].x;
                else if(ShippyObjects[number].x>ShippyObjects[0].x+6) --ShippyObjects[number].x;
            }
            ++ShippyObjects[number].y;

            if(gameover==0)
            {
                if(IsHit(ShippyObjects[number].x, ShippyObjects[number].y, 2, ShippyObjects[0].x, ShippyObjects[0].y, 8))
                {
                    #ifndef GODMODE
                    if(ShippyObjects[0].health>0)
                    {
                        ShippyObjects[0].health=0;
                        for(runsim=0;runsim<MAXSHIPPY;++runsim)
                        {
                            AddObject(PARTICLE,
                                                    ShippyObjects[number].x*64,
                                                    ShippyObjects[number].y*64,
                                                    (rand()%3>1)?255:0,
                                                    255,
                                                    0,
                                                    NULL,
                                                    ((rand()%3)-1)*(64+(rand()%256)),
                                                    ((rand()%3)-1)*(64+(rand()%256))
                                                    );
                        }

                        diedlast = 1;                    
						audio_play("d:\\data\\die.wav");
                        ShippyObjects[number].type=EXPLOSION;
                        ShippyObjects[number].special=4;
                        return;
                    }
                    #endif
                }
            }    
            if(ShippyObjects[number].x>0 && ShippyObjects[number].x<239)
            {
            	if(ShippyObjects[number].y>159) ShippyObjects[number].used=0;

		    if(ShippyObjects[0].y-ShippyObjects[number].y > -8 && ShippyObjects[number].type==ENEMYBULLET)
		    {
			if(ShippyObjects[0].y-ShippyObjects[number].y <=8 && ShippyObjects[0].y-ShippyObjects[number].y>=-8)
			{
					aiwavelet[ShippyObjects[number].x]+=65536;
					aiwavelet[ShippyObjects[number].x+1]+=65536;
					aiwavelet[ShippyObjects[number].x-1]+=65536;
			}
			else if(ShippyObjects[0].y-ShippyObjects[number].y > aiwavelet[ShippyObjects[number].x])
		 	{
				aiwavelet[ShippyObjects[number].x]+=240-(ShippyObjects[0].y-ShippyObjects[number].y);
				aiwavelet[ShippyObjects[number].x+1]+=240-(ShippyObjects[0].y-ShippyObjects[number].y);
				aiwavelet[ShippyObjects[number].x-1]+=240-(ShippyObjects[0].y-ShippyObjects[number].y);
			}
        	    }
	    }

        break;
    
    
    }

}

void StoreHS()
{
    FILE *savehs = NULL;


	savehs = fopen("e:\\saves\\xshippy\\scores.lst","wb");

    if(savehs==NULL) return;

    fwrite(winners,sizeof(struct HISCORE), 14, savehs);
    fclose(savehs);
    return;


}


void RestoreHS()
{
    int i;    
    FILE *loadhs = NULL;
    
	loadhs = fopen("e:\\saves\\xshippy\\scores.lst","rb");

    if(loadhs!=NULL)
    {
        if(fread(winners,sizeof(struct HISCORE), 14, loadhs)==14)
        {
            fclose(loadhs);
            highscore=winners[0].score;
            return;
        }
        else
        {
            fclose(loadhs);
        }
    
    
    }


    strcpy(winners[0].name,"RAB");
    winners[0].level = 14;
    winners[0].score = 250000;

    highscore=winners[0].score;
    
    strcpy(winners[1].name,"SCM");
    winners[1].level = 12;
    winners[1].score = 240000;
    
    strcpy(winners[2].name,"BDH");
    winners[2].level = 11;
    winners[2].score = 230000;
    
    strcpy(winners[3].name,"JRP");
    winners[3].level = 9;
    winners[3].score = 200000;

    strcpy(winners[4].name,"JDE");
    winners[4].level = 8;
    winners[4].score = 175000;

    strcpy(winners[5].name,"BJM");
    winners[5].level = 8;
    winners[5].score = 150000;

    strcpy(winners[6].name,"RML");
    winners[6].level = 7;
    winners[6].score = 125000;

    strcpy(winners[7].name,"JDW");
    winners[7].level = 7;
    winners[7].score = 100000;

    strcpy(winners[8].name,"NPC");
    winners[8].level = 4;
    winners[8].score = 75000;

    strcpy(winners[9].name,"CDC");
    winners[9].level = 4;
    winners[9].score = 65000;

    strcpy(winners[10].name,"OMG");
    winners[10].level = 4;
    winners[10].score = 60000;

    strcpy(winners[11].name,"BMB");
    winners[11].level = 4;
    winners[11].score = 55000;

    strcpy(winners[12].name,"EJP");
    winners[12].level = 4;
    winners[12].score = 50000;
    
    strcpy(winners[13].name,"SCB");
    winners[13].level = 1;
    winners[13].score = 40000;
    for(i=0;i<14;++i) winners[i].last = 0;


}



void InitShippy()
{

    RestoreHS();
    
  
    gamestate = SPLASH;
    waitforkey=700;
    done = 0;
    level = 0;
    shipwait = 0;
    gameover = 0;
    operational=600;

}

void ExecShippy()
{
    int increment;
    if(gamestate!=SPLASH) SYSTEM_CLEARSCREEN();
    switch(gamestate)
    {

        case SPLASH:

            if(operational==600)
            {
				SYSTEM_BG("d:\\data\\splash.bmp");
            }
            
            if(operational>0)
            {
                --operational;
				if(operational==0) audio_play("d:\\data\\splash.wav");
            }
            if(operational==120)
            {
				SYSTEM_BG("d:\\data\\splash2.bmp");
            }
            if(waitforkey==0)
            {
                PrintMessage("PRESS CTRL OR BUTTON 1",32,98,TEXT_WHITE);
            
            }
            if(jaction || jsecond)
            {
                gamestate=TITLE;
                done = 0;
                level = 0;
                shipwait = 0;
                gameover = 0;
                waitforkey=60;
                SYSTEM_CLEARSCREEN();
                operational = 0;
                
            }
        break;

        case INITIALS:
            

            if(operational==0)
            {
                winners[14].score = score;
                winners[14].level = level;
                strcpy(winners[14].name,"   ");
                operational = 1;
                waitforkey=15;
                currchar = 'A';
            }

            if(operational==4)
            {
                winners[14].name[3] = 0;
                winners[14].level = level;
                winners[14].last = 1;
                qsort(winners,MAXSCORE,sizeof(struct HISCORE),compare);
                waitforkey=360;
                gamestate=SCORES;
                powerupframe = 0;
                shipwait = 0;
                leftmonsters = 0;
                level = 0;
                gameover = 0;
                operational = 0;
                return;
            }
            
           
            if(jdirx == -2)
            {
                --currchar;
                if(currchar<'A') currchar = 'Z';
                waitforkey=15;
            }
            if(jdirx == 2)
            {
                ++currchar;
                if(currchar>'Z') currchar = 'A';
                waitforkey=15;
            }

            if(jaction)
            {
                winners[14].name[operational-1] = currchar;
                ++operational;
                currchar = 'A';
                waitforkey=20;
            }

            if(jsecond)
            {
                winners[14].name[operational-1] = ' ';
                --operational;
                if(operational<1) operational = 1;
                currchar = 'A';
                waitforkey=20;
            }
            
        break;
        
        case GAME:

#ifdef GODMODE
	if(jsecond) leftmonsters = 0;
#else

        if(jsecond && BELATED>=0)
        {
            BELATED = 1-BELATED;
            if(BELATED==1) waitforkey=60;
            else BELATED=-15;
        }
        if(BELATED==1) return;
        if(BELATED<0) ++BELATED;
#endif

        if(score > extralife)
        {
            ShippyObjects[0].lives++;
            extralife *= 2;
			audio_play("d:\\data\\fanfare.wav");
        
        }
        if(leftmonsters>0 && done == 0 && gameover==0)
        {
	    ++timeattack;
            for(increment=0;increment<MAXSHIPPY;++increment)
            {
     
                DoAi(increment);
            }
            if(shipwait>0) --shipwait;
            if(powerupframe>0) --powerupframe;
            if(score>highscore) highscore=score;
            return;
        }
        
        if(gameover==0)
        {
            shots = 0;
            ++level;
            NewGame(level);
        }
        else
        {
        
            for(increment=1;increment<MAXSHIPPY;++increment)
            {
                DoAi(increment);
            }
            
            if(score>highscore) highscore = score;
            PrintMessage("GAME OVER!",88,112,TEXT_RED);
            if(jaction)
            {
		if(score<=winners[13].score)
		{
	                waitforkey=360;
	                gamestate=SCORES;
	                powerupframe = 0;
	                shipwait = 0;
	                leftmonsters = 0;
	                level = 0;
	                gameover = 0;
	                operational = 0;
	                return;
		}
		for(increment=0;increment<14;++increment) winners[increment].last=0;
                gamestate = INITIALS;
				audio_music("d:\\data\\score.xm");
                waitforkey=30;
                operational = 0;
            }
        }
        break;
                
        case TITLE:
        case SCORES:
            if(operational==0)
            {
                NewGame(-1);
                operational = 1;
				if(gamestate==TITLE) audio_music("d:\\data\\title.xm");
            }
            
            if(done==0 && operational==1)
            {
                for(increment=0;increment<MAXSHIPPY;++increment)
                {
                    DoAi(increment);
                }
                if(shipwait>0) --shipwait;
                
                if(jaction)
                {
                    if(gamestate==SCORES)
                    {
                        gamestate=TITLE;
                        powerupframe = 0;
                        shipwait = 0;
                        leftmonsters = 0;
                        level = 0;
                        gameover = 0;
                        operational = 0;
                        waitforkey=30;
                        return;
                    }
                    else
                    {
    
						audio_music("d:\\data\\shippy.xm");
                        gamestate = GAME;
                        operational = 0;
                    }
                }
                if(shipwait==0)
                {
                    shipwait = 0;
                    if(gamestate==TITLE)
                    {
                        gamestate = SCORES;
                        operational = 0;
                        powerupframe = 0;
                        shipwait = 0;
                        leftmonsters = 0;
                        level = 0;
                        gameover = 0;
     
                    }
                    else
                    {
                        for(increment=0;increment<14;++increment)
                        {
                            if(winners[increment].level==-1) winners[increment].level=0;
                        }
                        gamestate = DEMO;
                        operational = 1800;
			powerupframe=0;
			shipwait=0;
                    }
                }
            }
            break;
        case DEMO:
        if(score > extralife)
        {
            ShippyObjects[0].lives++;
            extralife *= 2;
			audio_play("d:\\data\\fanfare.wav");
        
        }


            if(leftmonsters>0 && done == 0 && gameover==0 && operational>0)
            {
		++timeattack;
                for(increment=0;increment<MAXSHIPPY;++increment)
                {
                    DoAi(increment);
                }
                if(shipwait>0) --shipwait;
                if(powerupframe>0) --powerupframe;
                if(score>highscore) highscore=score;
                --operational;
                if(jaction)
                {
                    operational = 0;
                    waitforkey=30;
                }
                return;
            }
            if(gameover==0)
            {
                shots = 0;
                ++level;
                NewGame(level);
            }
            if(operational<=0)
            {
                gamestate=TITLE;
                powerupframe = 0;
                shipwait = 0;
                leftmonsters = 0;
                level = 0;
                gameover = 0;
                operational = 0;
            }
            break;
    }
}
int XMount(const char* szDrive, char* szDevice);
int XUnmount(const char* szDrive);

void SHIPPY_MAIN()
{
    int increment;
    srand(GetTickCount());

	XGetCustomLaunchData() ;
	XUnmount("C:") ;
	XUnmount("E:") ;
	XUnmount("F:") ;
	XUnmount("G:") ;
	XUnmount("X:") ;
	XUnmount("Y:") ;
	XUnmount("Z:") ;
	XUnmount("R:") ;
	XMount("C:", "Harddisk0\\Partition2");
	XMount("E:", "Harddisk0\\Partition1");
	XMount("F:", "Harddisk0\\Partition6");
	XMount("G:", "Harddisk0\\Partition7");
	XMount("X:", "Harddisk0\\Partition3");
	XMount("Y:", "Harddisk0\\Partition3");
	XMount("Z:", "Harddisk0\\Partition3");
	XMount("R:","Cdrom0");

    if(SYSTEM_INIT()!=0) return;
    InitShippy();
    while(done==0)
    {
        SYSTEM_IDLE();
        if(objectsynch>0)
        {
            SYSTEM_POLLINPUT();
            audio_exec();
            ExecShippy();
        	--objectsynch;
        	++countframes;
		   	if(countframes>=60)
           	{
                fps = frames;
                frames = 0;
                countframes=0;
        	}

            for(increment=0;increment<MAXSHIPPY;++increment)
            {
                if(gamestate!=INITIALS) RenderShippy(increment);
            }
            DrawOverlay();
            SYSTEM_FINISHRENDER();
    		++frames;
        }
    }
    StoreHS();
    SYSTEM_CLEAN();
	XReturnToLaunchingXBE() ;
}


