// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Pokmon-mini CPU core emulator, v0.6.4 (Retail)
//
// Coded by JustBurn, 2004

#ifndef POKECPU_C
#define POKECPU_C

#define S8_Jump(a)     (a & 0x00000080 ? a | 0xFFFFFF00 : a )
#define S16_Jump(a)    (a & 0x00008000 ? a | 0xFFFF0000 : a )

#define ClearFlags(a)  {  \
  PokeCPU.F &= ~(a);      \
}

#define SetFlags(a)  {    \
  PokeCPU.F |= (a);       \
}

#define O_Flag_ADD(src1, src2, ret) {                                      \
  if (~((src2) ^ (src1)) & ((src2) ^ (ret)) & 0x80) PokeCPU.F |= O_FLAG;   \
}

#define O_Flag_SUB(src1, src2, ret) {                                      \
  if (((src2) ^ (src1)) & ((src2) ^ (ret)) & 0x80) PokeCPU.F |= O_FLAG;    \
}

#define O_Flag_ADD16(src1, src2, ret) {                                    \
  if (~((src2) ^ (src1)) & ((src2) ^ (ret)) & 0x8000) PokeCPU.F |= O_FLAG; \
}

#define O_Flag_SUB16(src1, src2, ret) {                                    \
  if (((src2) ^ (src1)) & ((src2) ^ (ret)) & 0x8000) PokeCPU.F |= O_FLAG;  \
}

INLINE unsigned short ReadPC16()    {return (ReadPokeCPU(PokeCPU.PC.W.l) | (ReadPokeCPU(PokeCPU.PC.W.l + 1) << 8));}
INLINE unsigned long  ReadNNOfs8()  {return (PokeCPU.HL.B.x << 24) | PokeCPU.NN.W.l | ReadPokeCPU(PokeCPU.PC.W.l);}
INLINE unsigned long  ReadHLOfs16() {return (PokeCPU.HL.B.x << 24) | ReadPC16();}
INLINE unsigned long  ReadX1Add()   {return (PokeCPU.X1.D + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l))) & 0xFFFFF;}
INLINE unsigned long  ReadX2Add()   {return (PokeCPU.X2.D + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l))) & 0xFFFFF;}
INLINE unsigned long  ReadX1AddL()  {return (PokeCPU.X1.D + S8_Jump(PokeCPU.HL.B.l)) & 0xFFFFF;}
INLINE unsigned long  ReadX2AddL()  {return (PokeCPU.X2.D + S8_Jump(PokeCPU.HL.B.l)) & 0xFFFFF;}
INLINE unsigned long  ReadSPAdd()   {return (PokeCPU.SP.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l))) & 0xFFFF;}

unsigned char PokeCPUCycles[256] = { 8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,  // 00 - 0F
                                     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,  // 10 - 1F
                                     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,  // 20 - 2F
                                     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,  // 30 - 3F
                                     4, 4, 4, 4,12, 8, 8, 8, 4, 4, 4, 4,12, 8, 8, 8,  // 40 - 4F
                                     4, 4, 4, 4,12, 8, 8, 8, 4, 4, 4, 4,12, 8, 8, 8,  // 50 - 5F
                                     8, 8, 8, 8,16,12,12,12, 8, 8, 8, 8,16,12,12,12,  // 60 - 6F
                                     8, 8, 8, 8,16,12,12,12,12,12,12,12,32,16,16,16,  // 70 - 7F
                                     8, 8, 8, 8, 8,16,12, 8, 8, 8, 8, 8, 8,16,12, 8,  // 80 - 8F

                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // 90 - 9F
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // A0 - AF
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // B0 - BF
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // C0 - CF
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // D0 - DF
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  // E0 - EF
                                    16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16}; // F0 - FF

void ResetPokeCPU()
{
  PokeCPU.BA.D = 0x0000;
  PokeCPU.HL.D = 0x000000;
  PokeCPU.X1.D = 0x000000;
  PokeCPU.X2.D = 0x000000;
  PokeCPU.NN.D = 0x0000;
  PokeCPU.F = 0x00;
  PokeCPU.SP.D = 0x2000;
  PokeCPU.PC.D = 0x009A;
  PokeCPU.U = 0x01;
  PokeCPU.V = 0x01;
  PokeCPU.LCount = PokeCPU.LPeriod;
  PokeCPU.Halt = false;
}

void RunPokeCPU()
{
  register unsigned char Instruction;
  int startcount;

  if (PokeCPU.Halt) return;

  while (PokeCPU.LCount > 0) {
    startcount = PokeCPU.LCount;

    Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
    PokeCPU.LCount -= PokeCPUCycles[Instruction];
    switch(Instruction) {
      #include "PokeCPUCodes.h"
      case 0xCE:
        Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
        switch(Instruction) {
          #include "PokeCPUCodesCE.h"
        }
        break;
      case 0xCF:
        Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
        switch(Instruction) {
          #include "PokeCPUCodesCF.h"
        }
        break;
    }

    if (PokeCPU.UT < 0) {
      PokeCPU.U = PokeCPU.V;
    } else {
      PokeCPU.UT--;
    }

    if (PokeCPU.Halt) return;
    ExecutePokeCPU(startcount - PokeCPU.LCount);

  }

  PokeCPU.LCount += PokeCPU.LPeriod;
  LCountPokeCPU();
}

void ExecPokeCPU()
{
  register unsigned char Instruction;
  int startcount;

  if (PokeCPU.Halt) return;
  startcount = PokeCPU.LCount;

  Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
  PokeCPU.LCount -= PokeCPUCycles[Instruction];
  switch(Instruction) {
    #include "PokeCPUCodes.h"
    case 0xCE:
      Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
      switch(Instruction) {
        #include "PokeCPUCodesCE.h"
      }
      break;
    case 0xCF:
      Instruction = ReadPokeCPU(PokeCPU.PC.W.l++);
      switch(Instruction) {
        #include "PokeCPUCodesCF.h"
      }
      break;
  }

  if (PokeCPU.UT < 0) {
    PokeCPU.U = PokeCPU.V;
  } else {
    PokeCPU.UT--;
  }

  ExecutePokeCPU(startcount - PokeCPU.LCount);

  if (PokeCPU.LCount < 0) {
    PokeCPU.LCount += PokeCPU.LPeriod;
    LCountPokeCPU();
  }
}

#endif
