// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Pokmon-mini CPU core emulator, v0.6.4 (Debug / Retail)
//
// Coded by JustBurn, 2004

// CF 00       - ADD BA, BA
case 0x00:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 01       - ADD BA, HL
case 0x01:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 02       - ADD BA, X1
case 0x02:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 03       - ADD BA, X2
case 0x03:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 04       - ADC BA, BA
case 0x04:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.BA.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 05       - ADC BA, HL
case 0x05:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.HL.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 06       - ADC BA, X1
case 0x06:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.X1.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 07       - ADC BA, X2
case 0x07:
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.X2.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 08       - SUB BA, BA
case 0x08:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 09       - SUB BA, HL
case 0x09:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0A       - SUB BA, X1
case 0x0A:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0B       - SUB BA, X2
case 0x0B:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0C       - SBC BA, BA
case 0x0C:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.BA.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0D       - SBC BA, HL
case 0x0D:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.HL.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0E       - SBC BA, X1
case 0x0E:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X1.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 0F       - SBC BA, X2
case 0x0F:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X2.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 10       - ? [INVALID] ?
case 0x10:
  IllegalPokeCPU(0xCF10);
  break;

// CF 11       - ? [INVALID] ?
case 0x11:
  IllegalPokeCPU(0xCF11);
  break;

// CF 12       - ? [INVALID] ?
case 0x12:
  IllegalPokeCPU(0xCF12);
  break;

// CF 13       - ? [INVALID] ?
case 0x13:
  IllegalPokeCPU(0xCF13);
  break;

// CF 14       - ? [INVALID] ?
case 0x14:
  IllegalPokeCPU(0xCF14);
  break;

// CF 15       - ? [INVALID] ?
case 0x15:
  IllegalPokeCPU(0xCF15);
  break;

// CF 16       - ? [INVALID] ?
case 0x16:
  IllegalPokeCPU(0xCF16);
  break;

// CF 17       - ? [INVALID] ?
case 0x17:
  IllegalPokeCPU(0xCF17);
  break;

// CF 18       - CMP BA, BA
case 0x18:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 19       - CMP BA, HL
case 0x19:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 1A       - CMP BA, X1
case 0x1A:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 1B       - CMP BA, X2
case 0x1B:
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 1C       - ? [INVALID] ?
case 0x1C:
  IllegalPokeCPU(0xCF1C);
  break;

// CF 1D       - ? [INVALID] ?
case 0x1D:
  IllegalPokeCPU(0xCF1D);
  break;

// CF 1E       - ? [INVALID] ?
case 0x1E:
  IllegalPokeCPU(0xCF1E);
  break;

// CF 1F       - ? [INVALID] ?
case 0x1F:
  IllegalPokeCPU(0xCF1F);
  break;

// CF 20       - ADD HL, BA
case 0x20:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 21       - ADD HL, HL
case 0x21:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 22       - ADD HL, X1
case 0x22:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 23       - ADD HL, X2
case 0x23:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 24       - ADC HL, BA
case 0x24:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.BA.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 25       - ADC HL, HL
case 0x25:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.HL.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 26       - ADC HL, X1
case 0x26:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.X1.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 27       - ADC HL, X2
case 0x27:
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.X2.W.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 28       - SUB HL, BA
case 0x28:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 29       - SUB HL, HL
case 0x29:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2A       - SUB HL, X1
case 0x2A:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2B       - SUB HL, X2
case 0x2B:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2C       - SBC HL, BA
case 0x2C:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.BA.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2D       - SBC HL, HL
case 0x2D:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.HL.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2E       - SBC HL, X1
case 0x2E:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X1.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 2F       - SBC HL, X2
case 0x2F:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X2.W.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 30       - ? [INVALID] ?
case 0x30:
  IllegalPokeCPU(0xCF30);
  break;

// CF 31       - ? [INVALID] ?
case 0x31:
  IllegalPokeCPU(0xCF31);
  break;

// CF 32       - ? [INVALID] ?
case 0x32:
  IllegalPokeCPU(0xCF32);
  break;

// CF 33       - ? [INVALID] ?
case 0x33:
  IllegalPokeCPU(0xCF33);
  break;

// CF 34       - ? [INVALID] ?
case 0x34:
  IllegalPokeCPU(0xCF34);
  break;

// CF 35       - ? [INVALID] ?
case 0x35:
  IllegalPokeCPU(0xCF35);
  break;

// CF 36       - ? [INVALID] ?
case 0x36:
  IllegalPokeCPU(0xCF36);
  break;

// CF 37       - ? [INVALID] ?
case 0x37:
  IllegalPokeCPU(0xCF37);
  break;

// CF 38       - CMP HL, BA
case 0x38:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 39       - CMP HL, HL
case 0x39:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 3A       - CMP HL, X1
case 0x3A:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X1.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X1.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 3B       - CMP HL, X2
case 0x3B:
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.X2.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.X2.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 3C       - ? [INVALID] ?
case 0x3C:
  IllegalPokeCPU(0xCF3C);
  break;

// CF 3D       - ? [INVALID] ?
case 0x3D:
  IllegalPokeCPU(0xCF3D);
  break;

// CF 3E       - ? [INVALID] ?
case 0x3E:
  IllegalPokeCPU(0xCF3E);
  break;

// CF 3F       - ? [INVALID] ?
case 0x3F:
  IllegalPokeCPU(0xCF3F);
  break;

// CF 40       - ADD X1, BA
case 0x40:
  PokeCPU.tmp = PokeCPU.X1.W.l + PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X1.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 41       - ADD X1, HL
case 0x41:
  PokeCPU.tmp = PokeCPU.X1.W.l + PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X1.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 42       - ADD X2, BA
case 0x42:
  PokeCPU.tmp = PokeCPU.X2.W.l + PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X2.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 43       - ADD X2, HL
case 0x43:
  PokeCPU.tmp = PokeCPU.X2.W.l + PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X2.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 44       - ADD SP, BA
case 0x44:
  PokeCPU.tmp = PokeCPU.SP.W.l + PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.SP.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 45       - ADD SP, HL
case 0x45:
  PokeCPU.tmp = PokeCPU.SP.W.l + PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.SP.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 46       - ? [INVALID] ?
case 0x46:
  IllegalPokeCPU(0xCF46);
  break;

// CF 47       - ? [INVALID] ?
case 0x47:
  IllegalPokeCPU(0xCF47);
  break;

// CF 48       - SUB X1, BA
case 0x48:
  PokeCPU.tmp = PokeCPU.X1.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X1.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 49       - SUB X1, HL
case 0x49:
  PokeCPU.tmp = PokeCPU.X1.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X1.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 4A       - SUB X2, BA
case 0x4A:
  PokeCPU.tmp = PokeCPU.X2.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X2.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 4B       - SUB X2, HL
case 0x4B:
  PokeCPU.tmp = PokeCPU.X2.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X2.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 4C       - SUB SP, BA
case 0x4C:
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 4D       - SUB SP, HL
case 0x4D:
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CF 4E       - ? [INVALID] ?
case 0x4E:
  IllegalPokeCPU(0xCF4E);
  break;

// CF 4F       - ? [INVALID] ?
case 0x4F:
  IllegalPokeCPU(0xCF4F);
  break;

// CF 50       - ? [INVALID] ?
case 0x50:
  IllegalPokeCPU(0xCF50);
  break;

// CF 51       - ? [INVALID] ?
case 0x51:
  IllegalPokeCPU(0xCF51);
  break;

// CF 52       - ? [INVALID] ?
case 0x52:
  IllegalPokeCPU(0xCF52);
  break;

// CF 53       - ? [INVALID] ?
case 0x53:
  IllegalPokeCPU(0xCF53);
  break;

// CF 54       - ? [INVALID] ?
case 0x54:
  IllegalPokeCPU(0xCF54);
  break;

// CF 55       - ? [INVALID] ?
case 0x55:
  IllegalPokeCPU(0xCF55);
  break;

// CF 56       - ? [INVALID] ?
case 0x56:
  IllegalPokeCPU(0xCF56);
  break;

// CF 57       - ? [INVALID] ?
case 0x57:
  IllegalPokeCPU(0xCF57);
  break;

// CF 58       - ? [INVALID] ?
case 0x58:
  IllegalPokeCPU(0xCF58);
  break;

// CF 59       - ? [INVALID] ?
case 0x59:
  IllegalPokeCPU(0xCF59);
  break;

// CF 5A       - ? [INVALID] ?
case 0x5A:
  IllegalPokeCPU(0xCF5A);
  break;

// CF 5B       - ? [INVALID] ?
case 0x5B:
  IllegalPokeCPU(0xCF5B);
  break;

// CF 5C       - CMP SP, BA
case 0x5C:
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.BA.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.BA.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 5D       - CMP SP, HL
case 0x5D:
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.HL.W.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.HL.W.l, PokeCPU.tmp & 0xFF);
  break;

// CF 5E       - ? [INVALID] ?
case 0x5E:
  IllegalPokeCPU(0xCF5E);
  break;

// CF 5F       - ? [INVALID] ?
case 0x5F:
  IllegalPokeCPU(0xCF5F);
  break;

// CF 60 nn nn - CMPNC BA, #nnnn
case 0x60:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// CF 61 nn nn - CMPNC HL, #nnnn
case 0x61:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// CF 62 nn nn - CMPNC X1, #nnnn
case 0x62:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X1.W.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X1.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// CF 63 nn nn - CMPNC X2, #nnnn
case 0x63:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X2.W.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X2.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// CF 64       - ? [INVALID] ?
case 0x64:
  IllegalPokeCPU(0xCF64);
  break;

// CF 65       - ? [INVALID] ?
case 0x65:
  IllegalPokeCPU(0xCF65);
  break;

// CF 66       - ? [INVALID] ?
case 0x66:
  IllegalPokeCPU(0xCF66);
  break;

// CF 67       - ? [INVALID] ?
case 0x67:
  IllegalPokeCPU(0xCF67);
  break;

// CF 68 nn nn - ADD SP, #nnnn
case 0x68:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.SP.W.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.SP.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// CF 69       - ? [INVALID] ?
case 0x69:
  IllegalPokeCPU(0xCF69);
  break;

// CF 6A nn nn - SUB SP, #nnnn
case 0x6A:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// CF 6B       - ? [INVALID] ?
case 0x6B:
  IllegalPokeCPU(0xCF6B);
  break;

// CF 6C nn nn - CMP SP, #nnnn
case 0x6C:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.SP.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// CF 6D       - ? [INVALID] ?
case 0x6D:
  IllegalPokeCPU(0xCF6D);
  break;

// CF 6E nn nn - MOV SP, #nnnn
case 0x6E:
  PokeCPU.SP.W.l = ReadPC16();
  PokeCPU.PC.W.l += 2;
  break;

// CF 6F       - ? [INVALID] ?
case 0x6F:
  IllegalPokeCPU(0xCF6F);
  break;

// CF 70 nn    - MOV BA, [SP + #nn]
case 0x70:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadSPAdd());
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadSPAdd() + 1);
  PokeCPU.PC.W.l += 2;
  break;

// CF 71 nn    - MOV HL, [SP + #nn]
case 0x71:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadSPAdd());
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadSPAdd() + 1);
  PokeCPU.PC.W.l += 2;
  break;

// CF 72 nn    - MOV X1, [SP + #nn]
case 0x72:
  PokeCPU.X1.B.l = ReadPokeCPUEx(ReadSPAdd());
  PokeCPU.X1.B.h = ReadPokeCPUEx(ReadSPAdd() + 1);
  PokeCPU.PC.W.l += 2;
  break;

// CF 73 nn    - MOV X2, [SP + #nn]
case 0x73:
  PokeCPU.X2.B.l = ReadPokeCPUEx(ReadSPAdd());
  PokeCPU.X2.B.h = ReadPokeCPUEx(ReadSPAdd() + 1);
  PokeCPU.PC.W.l += 2;
  break;

// CF 74 nn    - MOV [SP + #nn], BA
case 0x74:
  WritePokeCPUEx(ReadSPAdd(), PokeCPU.BA.B.l);
  WritePokeCPUEx(ReadSPAdd() + 1, PokeCPU.BA.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CF 75 nn    - MOV [SP + #nn], HL
case 0x75:
  WritePokeCPUEx(ReadSPAdd(), PokeCPU.HL.B.l);
  WritePokeCPUEx(ReadSPAdd() + 1, PokeCPU.HL.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CF 76 nn    - MOV [SP + #nn], X1
case 0x76:
  WritePokeCPUEx(ReadSPAdd(), PokeCPU.X1.B.l);
  WritePokeCPUEx(ReadSPAdd() + 1, PokeCPU.X1.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CF 77 nn    - MOV [SP + #nn], X2
case 0x77:
  WritePokeCPUEx(ReadSPAdd(), PokeCPU.X2.B.l);
  WritePokeCPUEx(ReadSPAdd() + 1, PokeCPU.X2.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CF 78       - MOV SP, [Y + #nnnn]
case 0x78:
  // ADD ME!
  IllegalPokeCPU(0xCF78);
  break;

// CF 79       - ? [INVALID] ?
case 0x79:
  IllegalPokeCPU(0xCF79);
  break;

// CF 7A       - ? [INVALID] ?
case 0x7A:
  IllegalPokeCPU(0xCF7A);
  break;

// CF 7B       - ? [INVALID] ?
case 0x7B:
  IllegalPokeCPU(0xCF7B);
  break;

// CF 7C       - MOV [Y + #nnnn], SP
case 0x7C:
  // ADD ME!
  IllegalPokeCPU(0xCF7C);
  break;

// CF 7D       - ? [INVALID] ?
case 0x7D:
  IllegalPokeCPU(0xCF7D);
  break;

// CF 7E       - ? [INVALID] ?
case 0x7E:
  IllegalPokeCPU(0xCF7E);
  break;

// CF 7F       - ? [INVALID] ?
case 0x7F:
  IllegalPokeCPU(0xCF7F);
  break;

// CF 80       - ? [INVALID] ?
case 0x80:
  IllegalPokeCPU(0xCF80);
  break;

// CF 81       - ? [INVALID] ?
case 0x81:
  IllegalPokeCPU(0xCF81);
  break;

// CF 82       - ? [INVALID] ?
case 0x82:
  IllegalPokeCPU(0xCF82);
  break;

// CF 83       - ? [INVALID] ?
case 0x83:
  IllegalPokeCPU(0xCF83);
  break;

// CF 84       - ? [INVALID] ?
case 0x84:
  IllegalPokeCPU(0xCF84);
  break;

// CF 85       - ? [INVALID] ?
case 0x85:
  IllegalPokeCPU(0xCF85);
  break;

// CF 86       - ? [INVALID] ?
case 0x86:
  IllegalPokeCPU(0xCF86);
  break;

// CF 87       - ? [INVALID] ?
case 0x87:
  IllegalPokeCPU(0xCF87);
  break;

// CF 88       - ? [INVALID] ?
case 0x88:
  IllegalPokeCPU(0xCF88);
  break;

// CF 89       - ? [INVALID] ?
case 0x89:
  IllegalPokeCPU(0xCF89);
  break;

// CF 8A       - ? [INVALID] ?
case 0x8A:
  IllegalPokeCPU(0xCF8A);
  break;

// CF 8B       - ? [INVALID] ?
case 0x8B:
  IllegalPokeCPU(0xCF8B);
  break;

// CF 8C       - ? [INVALID] ?
case 0x8C:
  IllegalPokeCPU(0xCF8C);
  break;

// CF 8D       - ? [INVALID] ?
case 0x8D:
  IllegalPokeCPU(0xCF8D);
  break;

// CF 8E       - ? [INVALID] ?
case 0x8E:
  IllegalPokeCPU(0xCF8E);
  break;

// CF 8F       - ? [INVALID] ?
case 0x8F:
  IllegalPokeCPU(0xCF8F);
  break;

// CF 90       - ? [INVALID] ?
case 0x90:
  IllegalPokeCPU(0xCF90);
  break;

// CF 91       - ? [INVALID] ?
case 0x91:
  IllegalPokeCPU(0xCF91);
  break;

// CF 92       - ? [INVALID] ?
case 0x92:
  IllegalPokeCPU(0xCF92);
  break;

// CF 93       - ? [INVALID] ?
case 0x93:
  IllegalPokeCPU(0xCF93);
  break;

// CF 94       - ? [INVALID] ?
case 0x94:
  IllegalPokeCPU(0xCF94);
  break;

// CF 95       - ? [INVALID] ?
case 0x95:
  IllegalPokeCPU(0xCF95);
  break;

// CF 96       - ? [INVALID] ?
case 0x96:
  IllegalPokeCPU(0xCF96);
  break;

// CF 97       - ? [INVALID] ?
case 0x97:
  IllegalPokeCPU(0xCF97);
  break;

// CF 98       - ? [INVALID] ?
case 0x98:
  IllegalPokeCPU(0xCF98);
  break;

// CF 99       - ? [INVALID] ?
case 0x99:
  IllegalPokeCPU(0xCF99);
  break;

// CF 9A       - ? [INVALID] ?
case 0x9A:
  IllegalPokeCPU(0xCF9A);
  break;

// CF 9B       - ? [INVALID] ?
case 0x9B:
  IllegalPokeCPU(0xCF9B);
  break;

// CF 9C       - ? [INVALID] ?
case 0x9C:
  IllegalPokeCPU(0xCF9C);
  break;

// CF 9D       - ? [INVALID] ?
case 0x9D:
  IllegalPokeCPU(0xCF9D);
  break;

// CF 9E       - ? [INVALID] ?
case 0x9E:
  IllegalPokeCPU(0xCF9E);
  break;

// CF 9F       - ? [INVALID] ?
case 0x9F:
  IllegalPokeCPU(0xCF9F);
  break;

// CF A0       - ? [INVALID] ?
case 0xA0:
  IllegalPokeCPU(0xCFA0);
  break;

// CF A1       - ? [INVALID] ?
case 0xA1:
  IllegalPokeCPU(0xCFA1);
  break;

// CF A2       - ? [INVALID] ?
case 0xA2:
  IllegalPokeCPU(0xCFA2);
  break;

// CF A3       - ? [INVALID] ?
case 0xA3:
  IllegalPokeCPU(0xCFA3);
  break;

// CF A4       - ? [INVALID] ?
case 0xA4:
  IllegalPokeCPU(0xCFA4);
  break;

// CF A5       - ? [INVALID] ?
case 0xA5:
  IllegalPokeCPU(0xCFA5);
  break;

// CF A6       - ? [INVALID] ?
case 0xA6:
  IllegalPokeCPU(0xCFA6);
  break;

// CF A7       - ? [INVALID] ?
case 0xA7:
  IllegalPokeCPU(0xCFA7);
  break;

// CF A8       - ? [INVALID] ?
case 0xA8:
  IllegalPokeCPU(0xCFA8);
  break;

// CF A9       - ? [INVALID] ?
case 0xA9:
  IllegalPokeCPU(0xCFA9);
  break;

// CF AA       - ? [INVALID] ?
case 0xAA:
  IllegalPokeCPU(0xCFAA);
  break;

// CF AB       - ? [INVALID] ?
case 0xAB:
  IllegalPokeCPU(0xCFAB);
  break;

// CF AC       - ? [INVALID] ?
case 0xAC:
  IllegalPokeCPU(0xCFAC);
  break;

// CF AD       - ? [INVALID] ?
case 0xAD:
  IllegalPokeCPU(0xCFAD);
  break;

// CF AE       - ? [INVALID] ?
case 0xAE:
  IllegalPokeCPU(0xCFAE);
  break;

// CF AF       - ? [INVALID] ?
case 0xAF:
  IllegalPokeCPU(0xCFAF);
  break;

// CF B0       - PUSH A
case 0xB0:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.BA.B.l);
  break;

// CF B1       - PUSH B
case 0xB1:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.BA.B.h);
  break;

// CF B2       - PUSH L
case 0xB2:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.HL.B.l);
  break;

// CF B3       - PUSH H
case 0xB3:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.HL.B.h);
  break;

// CF B4       - POP A
case 0xB4:
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// CF B5       - POP B
case 0xB5:
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// CF B6       - POP L
case 0xB6:
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// CF B7       - POP H
case 0xB7:
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// CF B8       - PUSHA
case 0xB8:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 9;
  WritePokeCPU(PokeCPU.SP.W.l + 8, PokeCPU.BA.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 7, PokeCPU.BA.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 6, PokeCPU.HL.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 5, PokeCPU.HL.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 4, PokeCPU.X1.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 3, PokeCPU.X1.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.X2.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.X2.B.l);
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.NN.B.h);
  break;

// CF B9       - PUSHAX
case 0xB9:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 12;
  WritePokeCPU(PokeCPU.SP.W.l + 11, PokeCPU.BA.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 10, PokeCPU.BA.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 9, PokeCPU.HL.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 8, PokeCPU.HL.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 7, PokeCPU.X1.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 6, PokeCPU.X1.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 5, PokeCPU.X2.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 4, PokeCPU.X2.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 3, PokeCPU.NN.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.HL.B.x);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.X1.B.x);
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.X2.B.x);
  break;

// CF BA       - ? [INVALID] ?
case 0xBA:
  IllegalPokeCPU(0xCFBA);
  break;

// CF BB       - ? [INVALID] ?
case 0xBB:
  IllegalPokeCPU(0xCFBB);
  break;

// CF BC       - POPA
case 0xBC:
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 8);
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 7);
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 6);
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 5);
  PokeCPU.X1.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 4);
  PokeCPU.X1.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 3);
  PokeCPU.X2.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 2);
  PokeCPU.X2.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.NN.B.h = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 9;
  break;

// CF BD       - POPAX
case 0xBD:
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 11);
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 10);
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 9);
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 8);
  PokeCPU.X1.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 7);
  PokeCPU.X1.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 6);
  PokeCPU.X2.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 5);
  PokeCPU.X2.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 4);
  PokeCPU.NN.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 3);
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 2);
  PokeCPU.X1.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.X2.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 12;
  break;

// CF BE       - ? [INVALID] ?
case 0xBE:
  IllegalPokeCPU(0xCFBE);
  break;

// CF BF       - ? [INVALID] ?
case 0xBF:
  IllegalPokeCPU(0xCFBF);
  break;

// CF C0       - MOV BA, [HL]
case 0xC0:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.HL.D + 1);
  break;

// CF C1       - MOV HL, [HL]
case 0xC1:
  PokeCPU.tmp = PokeCPU.HL.D;
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  break;

// CF C2       - MOV X1, [HL]
case 0xC2:
  PokeCPU.X1.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.X1.B.h = ReadPokeCPUEx(PokeCPU.HL.D + 1);
  break;

// CF C3       - MOV X2, [HL]
case 0xC3:
  PokeCPU.X2.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.X2.B.h = ReadPokeCPUEx(PokeCPU.HL.D + 1);
  break;

// CF C4       - MOV [HL], BA
case 0xC4:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.BA.B.l);
  WritePokeCPUEx(PokeCPU.HL.D + 1, PokeCPU.BA.B.h);
  break;

// CF C5       - MOV [HL], HL
case 0xC5:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.HL.B.l);
  WritePokeCPUEx(PokeCPU.HL.D + 1, PokeCPU.HL.B.h);
  break;

// CF C6       - MOV [HL], X1
case 0xC6:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.X1.B.l);
  WritePokeCPUEx(PokeCPU.HL.D + 1, PokeCPU.X1.B.h);
  break;

// CF C7       - MOV [HL], X2
case 0xC7:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.X2.B.l);
  WritePokeCPUEx(PokeCPU.HL.D + 1, PokeCPU.X2.B.h);
  break;

// CF C8       - ? [INVALID] ?
case 0xC8:
  IllegalPokeCPU(0xCFC8);
  break;

// CF C9       - ? [INVALID] ?
case 0xC9:
  IllegalPokeCPU(0xCFC9);
  break;

// CF CA       - ? [INVALID] ?
case 0xCA:
  IllegalPokeCPU(0xCFCA);
  break;

// CF CB       - ? [INVALID] ?
case 0xCB:
  IllegalPokeCPU(0xCFCB);
  break;

// CF CC       - ? [INVALID] ?
case 0xCC:
  IllegalPokeCPU(0xCFCC);
  break;

// CF CD       - ? [INVALID] ?
case 0xCD:
  IllegalPokeCPU(0xCFCD);
  break;

// CF CE       - ? [INVALID] ?
case 0xCE:
  IllegalPokeCPU(0xCFCE);
  break;

// CF CF       - ? [INVALID] ?
case 0xCF:
  IllegalPokeCPU(0xCFCF);
  break;

// CF D0       - MOV BA, [X1]
case 0xD0:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.X1.D + 1);
  break;

// CF D1       - MOV HL, [X1]
case 0xD1:
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.X1.D + 1);
  break;

// CF D2       - MOV X1, [X1]
case 0xD2:
  PokeCPU.tmp = PokeCPU.X1.D;
  PokeCPU.X1.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.X1.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  break;

// CF D3       - MOV X2, [X1]
case 0xD3:
  PokeCPU.X2.B.l = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.X2.B.h = ReadPokeCPUEx(PokeCPU.X1.D + 1);
  break;

// CF D4       - MOV [X1], BA
case 0xD4:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.BA.B.l);
  WritePokeCPUEx(PokeCPU.X1.D + 1, PokeCPU.BA.B.h);
  break;

// CF D5       - MOV [X1], HL
case 0xD5:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.HL.B.l);
  WritePokeCPUEx(PokeCPU.X1.D + 1, PokeCPU.HL.B.h);
  break;

// CF D6       - MOV [X1], X1
case 0xD6:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.X1.B.l);
  WritePokeCPUEx(PokeCPU.X1.D + 1, PokeCPU.X1.B.h);
  break;

// CF D7       - MOV [X1], X2
case 0xD7:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.X2.B.l);
  WritePokeCPUEx(PokeCPU.X1.D + 1, PokeCPU.X2.B.h);
  break;

// CF D8       - MOV BA, [X2]
case 0xD8:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.X2.D + 1);
  break;

// CF D9       - MOV HL, [X2]
case 0xD9:
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.X2.D + 1);
  break;

// CF DA       - MOV X1, [X2]
case 0xDA:
  PokeCPU.X1.B.l = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.X1.B.h = ReadPokeCPUEx(PokeCPU.X2.D + 1);
  break;

// CF DB       - MOV X2, [X2]
case 0xDB:
  PokeCPU.tmp = PokeCPU.X2.D;
  PokeCPU.X2.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.X2.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  break;

// CF DC       - MOV [X2], BA
case 0xDC:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.BA.B.l);
  WritePokeCPUEx(PokeCPU.X2.D + 1, PokeCPU.BA.B.h);
  break;

// CF DD       - MOV [X2], HL
case 0xDD:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.HL.B.l);
  WritePokeCPUEx(PokeCPU.X2.D + 1, PokeCPU.HL.B.h);
  break;

// CF DE       - MOV [X2], X1
case 0xDE:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.X1.B.l);
  WritePokeCPUEx(PokeCPU.X2.D + 1, PokeCPU.X1.B.h);
  break;

// CF DF       - MOV [X2], X2
case 0xDF:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.X2.B.l);
  WritePokeCPUEx(PokeCPU.X2.D + 1, PokeCPU.X2.B.h);
  break;

// CF E0       - MOV BA, BA
case 0xE0:
  break;

// CF E1       - MOV BA, HL
case 0xE1:
  PokeCPU.BA.W.l = PokeCPU.HL.W.l;
  break;

// CF E2       - MOV BA, X1
case 0xE2:
  PokeCPU.BA.W.l = PokeCPU.X1.W.l;
  break;

// CF E3       - MOV BA, X2
case 0xE3:
  PokeCPU.BA.W.l = PokeCPU.X2.W.l;
  break;

// CF E4       - MOV HL, BA
case 0xE4:
  PokeCPU.HL.W.l = PokeCPU.BA.W.l;
  break;

// CF E5       - MOV HL, HL
case 0xE5:
  break;

// CF E6       - MOV HL, X1
case 0xE6:
  PokeCPU.HL.W.l = PokeCPU.X1.W.l;
  break;

// CF E7       - MOV HL, X2
case 0xE7:
  PokeCPU.HL.W.l = PokeCPU.X2.W.l;
  break;

// CF E8       - MOV X1, BA
case 0xE8:
  PokeCPU.X1.W.l = PokeCPU.BA.W.l;
  break;

// CF E9       - MOV X1, HL
case 0xE9:
  PokeCPU.X1.W.l = PokeCPU.HL.W.l;
  break;

// CF EA       - MOV X1, X1
case 0xEA:
  break;

// CF EB       - MOV X1, X2
case 0xEB:
  PokeCPU.X1.W.l = PokeCPU.X2.W.l;
  break;

// CF EC       - MOV X2, BA
case 0xEC:
  PokeCPU.X2.W.l = PokeCPU.BA.W.l;
  break;

// CF ED       - MOV X2, HL
case 0xED:
  PokeCPU.X2.W.l = PokeCPU.HL.W.l;
  break;

// CF EE       - MOV X2, X1
case 0xEE:
  PokeCPU.X2.W.l = PokeCPU.X1.W.l;
  break;

// CF EF       - MOV X2, X2
case 0xEF:
  break;

// CF F0       - MOV SP, BA
case 0xF0:
  PokeCPU.SP.W.l = PokeCPU.BA.W.l;
  break;

// CF F1       - MOV SP, HL
case 0xF1:
  PokeCPU.SP.W.l = PokeCPU.HL.W.l;
  break;

// CF F2       - MOV SP, X1
case 0xF2:
  PokeCPU.SP.W.l = PokeCPU.X1.W.l;
  break;

// CF F3       - MOV SP, X2
case 0xF3:
  PokeCPU.SP.W.l = PokeCPU.X2.W.l;
  break;

// CF F4       - MOV HL, SP
case 0xF4:
  PokeCPU.HL.W.l = PokeCPU.SP.W.l;
  break;

// CF F5       - MOV HL, PC
case 0xF5:
  PokeCPU.HL.W.l = PokeCPU.PC.W.l;
  break;

// CF F6       - ? [INVALID] ?
case 0xF6:
  IllegalPokeCPU(0xCFF6);
  break;

// CF F7       - ? [INVALID] ?
case 0xF7:
  IllegalPokeCPU(0xCFF7);
  break;

// CF F8       - MOV BA, SP
case 0xF8:
  PokeCPU.BA.W.l = PokeCPU.SP.W.l;
  break;

// CF F9       - MOV BA, PC
case 0xF9:
  PokeCPU.BA.W.l = PokeCPU.PC.W.l;
  break;

// CF FA       - MOV X1, SP
case 0xFA:
  PokeCPU.X1.W.l = PokeCPU.SP.W.l;
  break;

// CF FB       - ? [INVALID] ?
case 0xFB:
  IllegalPokeCPU(0xCFFB);
  break;

// CF FC       - ? [INVALID] ?
case 0xFC:
  IllegalPokeCPU(0xCFFC);
  break;

// CF FD       - ? [INVALID] ?
case 0xFD:
  IllegalPokeCPU(0xCFFD);
  break;

// CF FE       - MOV X2, SP
case 0xFE:
  PokeCPU.X2.W.l = PokeCPU.SP.W.l;
  break;

// CF FF       - ? [INVALID] ?
case 0xFF:
  IllegalPokeCPU(0xCFFF);
  break;

default:
  IllegalPokeCPU(0xFFFFCFFF);
  break;

