// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "resource.h"

#include <xtl.h>
#include <stdio.h>
//#include <commdlg.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdio.h>
//#include <commctrl.h>
//#include <Shellapi.h>

// Current Debugger Version
const char *Version = "0.3.0\0";              // Current version
char *ApplicationPath="D:\\";                    // Application Directory without '\'
int W_Argc;                                   // Number of arguments
char **W_Argv;                                // Arguments

// Global Variables:
//HWND hMainWnd;                                // Current window
//RECT rMainWnd;                                // Size of current window
//HMENU hMainMenu;                              // Current menu
//HWND hStatusbar;                              // Status window
//RECT rStatusbar;                              // Size of Status window
char StatusText[256];                         // Status text
//HINSTANCE hInst;                              // Current instance

// Include CORE & Support
#include "core\pokecpu.h"
#include "core\pokecpu.c"
#include "dummybios.h"

// Foward declarations of functions included in this code module:
void PokeDebugRegisterClasses(HINSTANCE hInstance);
BOOL InitInstance(HINSTANCE, int);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);
__inline void ProcessSound(bool EnableSnd);
__inline void PulseSound(bool EnableSnd);
void DoPMReset();
void DoCallInterrupt(unsigned char BIOSIntr);
void RenderScreen(unsigned char *screen, bool forceenable, int id);
void RenderTiles(unsigned char *tiles);
void SetStatusBarText(char *text, int part);
void SetRumbleAnim(bool rumbleactivated);
unsigned long GreyEmulation(unsigned char *dataaddr, int x, int y, int id);

// PokeMini Variables
unsigned char MINData[0x100000];              // MIN File Data (R/W)
unsigned char ScreenArea[96 * 64];            // Screen Data
unsigned char GreyEmu[2][96 * 64];            // For Grey-Emulation

bool FullSpeedEmu = false;                    // Running Full-Speed?
HANDLE FullSpeedHandle;                       // Full-Speed Thread-Handle
int RegDisplayColor = 0;                      // Type of color
bool DoGreyEmu = true;                        // Do grey emulation?
bool ApplicationTerminate = false;            // TRUE when application wants to close
HANDLE DSoundHandle;                          // DirectSound Thread-Handle
int GameWidth, GameHeight;                    // Width & Height of the Screen

//#include <MMSystem.h>
#include <DSound.h>

#define SND_PLAYBACK    32768                 // Frequency of Playback
#define SND_BUFFERSIZE  4096                  // Size of sound buffer
#define SND_SBUFFSIZE   1024                  // Small buffer size
LPDIRECTSOUND DirectS;
LPDIRECTSOUNDBUFFER DirectSBB;
LPDIRECTSOUNDBUFFER DirectSB1;                // DirectSound Classes
WAVEFORMATEX Wavf;                            // Wave-Format
unsigned char *PlayBuffer;                    // Samples Data
bool EnableSoundOut = true;                   // Enable Sound Output?
int SndNextWriteOffset = 0;                   // Pointer to next small buffer
UINT_PTR FPSHandle;                           // Frames per second timer
int FPSCounter = 0;                           // Frames per second counter

int IntSoundCount;                            // Internal Sound
int SoundTrueFrequency = 440;                 // Real Sound Frequency
int SoundPulseWd = 7;                         // Pulse-Width
int SoundVolume = 3;                          // Sound Volume

DWORD InstCount;                              // Count for Secs Counter
DWORD InstCount2;                             // Count for 256Hz Counter

DWORD Timer1Cont;                             // Count for Timer 1 overflow
unsigned char Timer1Scal = 0;                 // Timer 1 Pre-Scale
DWORD Timer2Cont;                             // Count for Timer 2 overflow
unsigned char Timer2Scal = 0;                 // Timer 2 Pre-Scale
DWORD Timer3Cont;                             // Count for Timer 3 overflow
unsigned char Timer3Scal = 0;                 // Timer 3 Pre-Scale

DWORD TimersPreScaling[8] = {0x0002, 0x0008, 0x0020, 0x0040,
                             0x0080, 0x0100, 0x0400, 0x1000};

DWORD TimerFrequencyTab[8] = {4000000, 1000000, 250000, 125000,
                              62500, 31250, 7812, 1952};

unsigned char LCDCommand = 0x00;              // Unknown
unsigned char LCDLen = 0x00;                  // Unknown
unsigned char LCDCur = 0x00;                  // Unknown
int Contrast = 0x1F;                          // Contrast of LCD
int Move_X = 0;                               // X Movement of BG
int Move_Y = 0;                               // Y Movement of BG
int ScanLine = 0;                             // Current Scanline

unsigned long ScnColors[8][3] = {{0x4A5542, 0x788A75, 0x8EAD92},  // Original
                                 {0x000000, 0xA0A0A0, 0xFFFFFF},  // Black & White
                                 {0x00FFFF, 0xFFFF00, 0xFF00FF},  // CGA Special 1
                                 {0xFF00FF, 0xFFFF00, 0x00FFFF},  // CGA Special 2
                                 {0x000000, 0x00C000, 0x00FF00},  // Green Pal
                                 {0x00FF00, 0x00C000, 0x000000},  // Green Vector
                                 {0x0000FF, 0xFF0000, 0x00FF00},  // B-R-G
                                 {0x808080, 0x808080, 0x808080}}; // Custom

unsigned char DefaultRegIO[256] = {0x83, 0x20, 0x5C, 0x45, 0x45, 0x45, 0x45, 0x45,  // 00 - 07
                                   0x01, 0x00, 0x00, 0x00, 0x45, 0x45, 0x45, 0x45,  // 08 - 0F
                                   0x03, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 10 - 17
                                   0xFF, 0x03, 0xD0, 0x00, 0x08, 0x00, 0x45, 0x45,  // 18 - 1F
                                   0x00, 0x30, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,  // 20 - 27
                                   0x00, 0x00, 0x00, 0x45, 0x45, 0x45, 0x45, 0x45,  // 28 - 2F
                                   0x84, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x3F, 0xE3,  // 30 - 37
                                   0x00, 0x04, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xE3,  // 38 - 3F
                                   0x00, 0xC4, 0x45, 0x45, 0x00, 0x00, 0xFF, 0x00,  // 40 - 47
                                   0x84, 0x00, 0xFE, 0x0B, 0xFE, 0x05, 0x80, 0x04,  // 48 - 4F
                                   0xFF, 0x00, 0xFF, 0x00, 0x01, 0x01, 0x45, 0x45,  // 50 - 57
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 58 - 5F
                                   0x32, 0x64, 0x00, 0x45, 0x45, 0x45, 0x45, 0x45,  // 60 - 67
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 68 - 6F
                                   0x00, 0x00, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 70 - 77
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 78 - 7F
                                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 80 - 87
                                   0x00, 0x00, 0x00, 0x45, 0x45, 0x45, 0x45, 0x45,  // 88 - 8F
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 90 - 97
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // 98 - 9F
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // A0 - A7
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // A8 - AF
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // B0 - B7
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // B8 - BF
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // C0 - C7
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // C8 - CF
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // D0 - D7
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // D8 - DF
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // E0 - E7
                                   0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,  // E8 - EF
                                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // F0 - F7
                                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xFF}; // F8 - FF

// Executed in each Opcode/Block of Opcodes ran
static void ExecutePokeCPU(int CyclesRan)
{
  // 256 Hz Counter
  InstCount += CyclesRan;
  if (InstCount >= 15625) {
    InstCount = 0;
    if (MINData[0x2040] & 1) MINData[0x2041]++;
  }
  // Seconds Counter
  InstCount2 += CyclesRan;
  if (InstCount2 >= 4000000) {
    InstCount2 = 0;
    if (MINData[0x2008] & 1) {
      MINData[0x2009]++;
      if (MINData[0x2009] == 0) {
        MINData[0x200A]++;
        if (MINData[0x200A] == 0) {
          MINData[0x200B]++;
        }
      }
    }
  } 
  // Process Timers
  if (MINData[0x2019] & 0x20) {
    // Timer 1
    if ((MINData[0x2018] & 0x08) && (MINData[0x2030] & 0x80)) {
      Timer1Cont += CyclesRan;
      redo_timer1:
      if (Timer1Cont >= TimersPreScaling[Timer1Scal]) {
        Timer1Cont -= TimersPreScaling[Timer1Scal];
        MINData[0x2036]--;
        if (MINData[0x2036] == 0xFF) {
          MINData[0x2037]--;
          if (MINData[0x2037] == 0xFF) {
            MINData[0x2036] = MINData[0x2032];
            MINData[0x2037] = MINData[0x2033];
            MINData[0x2027] = MINData[0x2027] | 0x08;
          }
        }
        goto redo_timer1;
      }
    }
    // Timer 2
    if ((MINData[0x201A] & 0x08) && (MINData[0x2038] & 0x80)) {
      Timer2Cont += CyclesRan;
      redo_timer2:
      if (Timer2Cont >= TimersPreScaling[Timer2Scal]) {
        Timer2Cont -= TimersPreScaling[Timer2Scal];
        MINData[0x203E]--;
        if (MINData[0x203E] == 0xFF) {
          MINData[0x203F]--;
          if (MINData[0x203F] == 0xFF) {
            MINData[0x203E] = MINData[0x203A];
            MINData[0x203F] = MINData[0x203B];
            MINData[0x2027] = MINData[0x2027] | 0x20;
          }
        }
        goto redo_timer2;
      }
    }
    // Timer 3   
    if ((MINData[0x201C] & 0x08) && (MINData[0x2048] & 0x80)) {
      Timer3Cont += CyclesRan;
      redo_timer3:
      if (Timer3Cont >= TimersPreScaling[Timer3Scal]) {
        Timer3Cont -= TimersPreScaling[Timer3Scal];
        MINData[0x204E]--;
        if (MINData[0x204E] == 0xFF) {
          MINData[0x204F]--;
          if (MINData[0x204F] == 0xFF) {
            MINData[0x204E] = MINData[0x204A];
            MINData[0x204F] = MINData[0x204B];
            MINData[0x2027] = MINData[0x2027] | 0x03;
          }
        }
        goto redo_timer3;
      }
    }
  }
  // Process Interrupts
  if ((PokeCPU.F & 0xC0) != 0xC0) {
    // Interrupt #1-#8
    if (MINData[0x2020]) {
      // Interrupt #1-#2
      if ((MINData[0x2020] & 0x40) && (MINData[0x2020] & 0x80)) {
        // Interrupt #1
        if ((MINData[0x2023] & 0x80) && (MINData[0x2027] & 0x80)) DoCallInterrupt(0x06);
        // Interrupt #2
        if ((MINData[0x2023] & 0x40) && (MINData[0x2027] & 0x40)) DoCallInterrupt(0x08);
      }
      // Interrupt #3-#4
      if ((MINData[0x2020] & 0x10) && (MINData[0x2020] & 0x20)) {
        // Interrupt #3
        if ((MINData[0x2023] & 0x20) && (MINData[0x2027] & 0x20)) DoCallInterrupt(0x0A);
        // Interrupt #4
        if ((MINData[0x2023] & 0x10) && (MINData[0x2027] & 0x10)) DoCallInterrupt(0x0C);
      }
      // Interrupt #5-#6
      if ((MINData[0x2020] & 0x08) && (MINData[0x2020] & 0x04)) {
        // Interrupt #5
        if ((MINData[0x2023] & 0x08) && (MINData[0x2027] & 0x08)) DoCallInterrupt(0x0E);
        // Interrupt #6
        if ((MINData[0x2023] & 0x04) && (MINData[0x2027] & 0x04)) DoCallInterrupt(0x10);
      }
      // Interrupt #7-#8
      if ((MINData[0x2020] & 0x02) && (MINData[0x2020] & 0x01)) {
        // Interrupt #7
        if ((MINData[0x2023] & 0x02) && (MINData[0x2027] & 0x02)) DoCallInterrupt(0x12);
        // Interrupt #8
        if ((MINData[0x2023] & 0x01) && (MINData[0x2027] & 0x01)) DoCallInterrupt(0x14);
      }
    }
    // Interrupt #13-#14
    if (MINData[0x2022]) {
      // Interrupt #13-#14
      if ((MINData[0x2022] & 0x01) && (MINData[0x2022] & 0x02)) {
        // Interrupt #13
        if ((MINData[0x2026] & 0x80) && (MINData[0x202A] & 0x80)) DoCallInterrupt(0x1E);
        // Interrupt #14
        if ((MINData[0x2026] & 0x40) && (MINData[0x202A] & 0x40)) DoCallInterrupt(0x20);
      }
    }
    // Interrupt #15-#22
    if (MINData[0x2021]) {
      // Interrupt #15-#22
      if ((MINData[0x2021] & 0x04) && (MINData[0x2021] & 0x08)) {
        // Interrupt #15
        if ((MINData[0x2025] & 0x80) && (MINData[0x2029] & 0x80)) DoCallInterrupt(0x2A);
        // Interrupt #16
        if ((MINData[0x2025] & 0x40) && (MINData[0x2029] & 0x40)) DoCallInterrupt(0x2C);
        // Interrupt #17
        if ((MINData[0x2025] & 0x20) && (MINData[0x2029] & 0x20)) DoCallInterrupt(0x2E);
        // Interrupt #18
        if ((MINData[0x2025] & 0x10) && (MINData[0x2029] & 0x10)) DoCallInterrupt(0x30);
        // Interrupt #19
        if ((MINData[0x2025] & 0x08) && (MINData[0x2029] & 0x08)) DoCallInterrupt(0x32);
        // Interrupt #20
        if ((MINData[0x2025] & 0x04) && (MINData[0x2029] & 0x04)) DoCallInterrupt(0x34);
        // Interrupt #21
        if ((MINData[0x2025] & 0x02) && (MINData[0x2029] & 0x02)) DoCallInterrupt(0x36);
        // Interrupt #22
        if ((MINData[0x2025] & 0x01) && (MINData[0x2029] & 0x01)) DoCallInterrupt(0x38);
      }
    }
  }
}

// Called when LCount is refilled
static void LCountPokeCPU()
{
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  PulseSound(FullSpeedEmu);
  ScanLine++;
  if (ScanLine >= 128) {
    ScanLine = 0;
    ProcessSound(FullSpeedEmu && EnableSoundOut);
    FPSCounter++;
  }
  if (ScanLine >= 64) {
    MINData[0x208A] = MINData[0x208A] | 0xFF;
  } else {
    MINData[0x208A] = MINData[0x208A] & ~0xFF;
  }
  if (ScanLine == 0) MINData[0x2027] = MINData[0x2027] | 0x40;  // Set VDraw
  if (ScanLine == 64) MINData[0x2027] = MINData[0x2027] | 0x80; // Set VBlank
}

// Read Memory entire range
static unsigned char ReadPokeCPUEx(unsigned long address)
{
  unsigned char data;

  data = 0xFF;
  if (address < 0x01000) {                            // BIOS
    data = MINData[address & 0xFFFFF];
  }
  if ((address >= 0x01000) && (address < 0x02000)) {  // RAM
    data = MINData[address & 0xFFFFF];
  }
  if ((address >= 0x02000) && (address < 0x02100)) {  // Registers IO
    switch (address & 0xFFFFF) {
      case 0x2000: // CPU Related
      case 0x2001: // CPU Related
      case 0x2002: // CPU Related
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2003:
      case 0x2004:
      case 0x2005:
      case 0x2006:
      case 0x2007: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2008: // Seconds Counter Control
        data = MINData[0x2008] & 0x01;
        break;
      case 0x2009: // Seconds Counter (1)
        data = MINData[0x2009];
        break;
      case 0x200A: // Seconds Counter (2)
        data = MINData[0x200A];
        break;
      case 0x200B: // Seconds Counter (3)
        data = MINData[0x200B];
        break;
      case 0x200C:
      case 0x200D:
      case 0x200E:
      case 0x200F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2010: // Low Power (And more stuff)
        data = MINData[0x2010] & 0x1F;
        break;
      case 0x2011:
      case 0x2012:
      case 0x2013:
      case 0x2014:
      case 0x2015:
      case 0x2016:
      case 0x2017: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2018: // Timer 1 Speed
        data = MINData[0x2018];
        break;
      case 0x2019: // Timers Enabler + Timer 1 PS Mode
        data = MINData[0x2019] & 0x33;
        break;
      case 0x201A: // Timer 2 Speed
        data = MINData[0x201A];
        break;
      case 0x201B: // Timer 2 PS Mode
        data = MINData[0x201B] & 0x03;
        break;
      case 0x201C: // Timer 3 Speed (Assigned to Sound)
        data = MINData[0x201C];
        break;
      case 0x201D: // Timer 3 PS Mode (Assigned to Sound)
        data = MINData[0x201D] & 0x03;
        break;
      case 0x201E:
      case 0x201F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2020: // Interrupts #1-#8 Enable (1)
        data = MINData[0x2020];
        break;
      case 0x2021: // Interrupt Related (!?)
        data = MINData[0x2021];
        break;
      case 0x2022: // Interrupt Related (!?)
        data = MINData[0x2022] & 0x03;
        break;
      case 0x2023: // Interrupts #1-#8 Enable (2)
        data = MINData[0x2023];
        break;
      case 0x2024: // Interrupt Related (!?)
        data = MINData[0x2024] & 0x3F;
        break;
      case 0x2025: // Keypad Enable Interrupt
        data = MINData[0x2025];
        break;
      case 0x2026: // Interrupt #9-#14 Enable (!?)
        data = MINData[0x2026] & 0xF7;
        break;
      case 0x2027: // Interrupt #1-#8 Flags
        data = MINData[0x2027];
        break;
      case 0x2028: // Interrupt #9-#14 Flags
        data = MINData[0x2028];
        break;
      case 0x2029: // Interrupt #15-#22 Flags
        data = MINData[0x2029];
        break;
      case 0x202A: // Interrupt Related (!?)
        data = MINData[0x202A];
        break;
      case 0x202B:
      case 0x202C:
      case 0x202D:
      case 0x202E:
      case 0x202F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2030: // Counter 1 Control 1
        data = MINData[0x2030] & 0x85;
        break;
      case 0x2031: // Counter 1 Control 2
        data = MINData[0x2031] & 0x08;
        break;
      case 0x2032:
      case 0x2033: // Counter 1 Frequency
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2034:
      case 0x2035: // Counter 1 Modulo
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2036:
      case 0x2037: // Counter 1 Counter
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2038: // Counter 2 Control 1
        data = MINData[0x2038] & 0x85;
        break;
      case 0x2039: // Counter 2 Control 2
        data = MINData[0x2039] & 0x08;
        break;
      case 0x203A:
      case 0x203B: // Counter 1 Frequency
        data = MINData[address & 0xFFFFF];
        break;
      case 0x203C:
      case 0x203D: // Counter 1 Modulo
        data = MINData[address & 0xFFFFF];
        break;
      case 0x203E:
      case 0x203F: // Counter 1 Counter
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2040: // 256 Hz Timer Control
        data = MINData[0x2040] & 0x01;
        break;
      case 0x2041: // 256 Hz Timer Counter
        data = MINData[0x2041];
        break;
      case 0x2042:
      case 0x2043: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2044: // Unknown
        data = MINData[0x2044] & 0xF7;
        break;
      case 0x2045: // Unknown
        data = MINData[0x2045] & 0x0F;
        break;
      case 0x2046: // Unknown
        data = MINData[0x2046];
        break;
      case 0x2047: // Unknown
        data = MINData[0x2047] & 0x0F;
        break;
      case 0x2048: // Counter 3 Control 1
        data = MINData[0x2048] & 0x85;
        break;
      case 0x2049: // Counter 3 Control 2
        data = MINData[0x2049] & 0x08;
        break;
      case 0x204A:
      case 0x204B: // Counter 3 Frequency
        data = MINData[address & 0xFFFFF];
        break;
      case 0x204C:
      case 0x204D: // Counter 3 Modulo
        data = MINData[address & 0xFFFFF];
        break;
      case 0x204E:
      case 0x204F: // Counter 3 Counter
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2050: // Unknown
        data = MINData[0x2050];
        break;
      case 0x2051: // Unknown
        data = MINData[0x2051] & 0x01;
        break;
      case 0x2052: // Keypad Status
        data = MINData[0x2052];
        break;
      case 0x2053: // Unknown
        data = 0x00;
        break;
      case 0x2054: // Unknown
        data = MINData[0x2054] & 0x77;
        break;
      case 0x2055: // Unknown
        data = MINData[0x2055] & 0x07;
        break;
      case 0x2056:
      case 0x2057:
      case 0x2058:
      case 0x2059:
      case 0x205A:
      case 0x205B:
      case 0x205C:
      case 0x205D:
      case 0x205E:
      case 0x205F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2060: // I/O Peripheral Address
        // ADDME!
        data = MINData[0x2060];
        break;
      case 0x2061: // I/O Peripheral Data
        // ADDME!
        data = MINData[0x2061];
        if (MINData[0x2060] & 0x10) {
          SetRumbleAnim(data & 0x10 ? true : false);
        }
        break;
      case 0x2062: // Unknown
        data = MINData[0x2062] & 0xF0;
        break;
      case 0x2063:
      case 0x2064:
      case 0x2065:
      case 0x2066:
      case 0x2067:
      case 0x2068:
      case 0x2069:
      case 0x206A:
      case 0x206B:
      case 0x206C:
      case 0x206D:
      case 0x206E:
      case 0x206F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2070: // Unknown
        data = MINData[0x2070];
        break;
      case 0x2071: // Sound Volume
        data = MINData[0x2071];
        break;
      case 0x2072:
      case 0x2073:
      case 0x2074:
      case 0x2075:
      case 0x2076:
      case 0x2077:
      case 0x2078:
      case 0x2079:
      case 0x207A:
      case 0x207B:
      case 0x207C:
      case 0x207D:
      case 0x207E:
      case 0x207F: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x2080: // LCD Control 0
        data = MINData[0x2080] & 0x3F;
        break;
      case 0x2081: // LCD Control 1
        data = MINData[0x2081];
        break;
      case 0x2082:
      case 0x2083:
      case 0x2084: // BG Tile Data Memory-Offset
        data = MINData[address & 0xFFFFF];
        break;
      case 0x2085: // Vertical Move
        data = MINData[0x2085] & 0x7F;
        break;
      case 0x2086: // Horizontal Move
        data = MINData[0x2086] & 0x7F;
        break;
      case 0x2087:
      case 0x2088:
      case 0x2089: // Sprite Tile Data Memory-Offset
        data = MINData[address & 0xFFFFF];
        break;
      case 0x208A: // LCD Status
        data = MINData[0x208A] & 0x7F;
        break;
      case 0x208B:
      case 0x208C:
      case 0x208D:
      case 0x208E:
      case 0x208F: // UNUSED 0x00
        data = 0x00;
        break;
      case 0x2090:
      case 0x2091:
      case 0x2092:
      case 0x2093:
      case 0x2094:
      case 0x2095:
      case 0x2096:
      case 0x2097:
      case 0x2098:
      case 0x2099:
      case 0x209A:
      case 0x209B:
      case 0x209C:
      case 0x209D:
      case 0x209E:
      case 0x209F:
      case 0x20A0:
      case 0x20A1:
      case 0x20A2:
      case 0x20A3:
      case 0x20A4:
      case 0x20A5:
      case 0x20A6:
      case 0x20A7:
      case 0x20A8:
      case 0x20A9:
      case 0x20AA:
      case 0x20AB:
      case 0x20AC:
      case 0x20AD:
      case 0x20AE:
      case 0x20AF:
      case 0x20B0:
      case 0x20B1:
      case 0x20B2:
      case 0x20B3:
      case 0x20B4:
      case 0x20B5:
      case 0x20B6:
      case 0x20B7:
      case 0x20B8:
      case 0x20B9:
      case 0x20BA:
      case 0x20BB:
      case 0x20BC:
      case 0x20BD:
      case 0x20BE:
      case 0x20BF:
      case 0x20C0:
      case 0x20C1:
      case 0x20C2:
      case 0x20C3:
      case 0x20C4:
      case 0x20C5:
      case 0x20C6:
      case 0x20C7:
      case 0x20C8:
      case 0x20C9:
      case 0x20CA:
      case 0x20CB:
      case 0x20CC:
      case 0x20CD:
      case 0x20CE:
      case 0x20CF:
      case 0x20D0:
      case 0x20D1:
      case 0x20D2:
      case 0x20D3:
      case 0x20D4:
      case 0x20D5:
      case 0x20D6:
      case 0x20D7:
      case 0x20D8:
      case 0x20D9:
      case 0x20DA:
      case 0x20DB:
      case 0x20DC:
      case 0x20DD:
      case 0x20DE:
      case 0x20DF:
      case 0x20E0:
      case 0x20E1:
      case 0x20E2:
      case 0x20E3:
      case 0x20E4:
      case 0x20E5:
      case 0x20E6:
      case 0x20E7:
      case 0x20E8:
      case 0x20E9:
      case 0x20EA:
      case 0x20EB:
      case 0x20EC:
      case 0x20ED:
      case 0x20EE:
      case 0x20EF: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x20F0:
      case 0x20F1:
      case 0x20F2:
      case 0x20F3:
      case 0x20F4:
      case 0x20F5:
      case 0x20F6:
      case 0x20F7: // UNUSED 0x00
        data = 0x00;
        break;
      case 0x20F8:
      case 0x20F9:
      case 0x20FA:
      case 0x20FB:
      case 0x20FC:
      case 0x20FD: // UNUSED 0x45
        data = 0x45;
        break;
      case 0x20FE: // Direct-LCD Control / Data
        // ADDME!
        data = MINData[0x20FE];
        break;
      case 0x20FF: // Direct-LCD Data
        // ADDME!
        data = MINData[0x20FF];
        break;
      default:
        data = MINData[address & 0xFFFFF];
        break;
    }
  }
  if (address >= 0x02100) {
    data = MINData[address & 0xFFFFF];
  }
  return data;
}

// Read Memory from PC
static unsigned char ReadPokeCPU(unsigned short address)
{
  if (address <= 0x7FFF) {  // Bank 0 + Special Stuff
    return ReadPokeCPUEx(address);
  }
  if (address >= 0x8000) {  // Bank 1..31
    return ReadPokeCPUEx((address & 0x7FFF) | ((PokeCPU.V & 0x1F) << 15));
  }
  return 0xFF;
}

// Write Memory entire range
static void WritePokeCPUEx(unsigned long address, unsigned char data)
{
  if (address < 0x001000) return;
  if ((address >= 0x001000) && (address < 0x002000)) MINData[address] = data;
  if ((address >= 0x002000) && (address < 0x002100)) {
    switch (address) {
      case 0x2000: // CPU Related
        MINData[0x2000] = data;
        break;
      case 0x2001: // CPU Related
        MINData[0x2001] = data;
        break;
      case 0x2002: // CPU Related
        MINData[0x2002] = data;
        break;
      case 0x2003:
      case 0x2004:
      case 0x2005:
      case 0x2006:
      case 0x2007: // UNUSED 0x45
        break;
      case 0x2008: // Seconds Counter Control
        if (data & 0x02) {
          MINData[0x2009] = 0x00;
          MINData[0x200A] = 0x00;
          MINData[0x200B] = 0x00;
        }
        MINData[0x2008] = data & 0x01;
        break;
      case 0x2009: // Seconds Counter (1)
      case 0x200A:
      case 0x200B:
        break;
      case 0x200C:
      case 0x200D:
      case 0x200E:
      case 0x200F: // UNUSED 0x45
        break;
      case 0x2010: // Unknown
        MINData[0x2010] = (data & 0x1F) | 0x20;
        break;
      case 0x2011:
      case 0x2012:
      case 0x2013:
      case 0x2014:
      case 0x2015:
      case 0x2016:
      case 0x2017: // UNUSED 0x45
        break;
      case 0x2018: // Timer 1 Scale + Enable
        Timer1Scal = data & 0x07;
        MINData[0x2018] = data;
        break;
      case 0x2019: // All Timers Enabler
        MINData[0x2019] = data & 0x33;
        break;
      case 0x201A: // Timer 2 Scale + Enable
        Timer2Scal = data & 0x07;
        MINData[0x201A] = data;
        break;
      case 0x201B: // Unused
        MINData[0x201B] = data & 0x03;
        break;
      case 0x201C: // Timer 3 Scale + Enable
        Timer3Scal = data & 0x07;
        MINData[0x201C] = data;
        break;
      case 0x201D: // Unused
        MINData[0x201C] = data & 0x03;
        break;
      case 0x201E:
      case 0x201F: // UNUSED 0x45
        break;
      case 0x2020: // Interrupt #1-#8 Enable (1)
        MINData[0x2020] = data;
        break;
      case 0x2021: // Interrupt Related (!?)
        // ADDME!
        MINData[0x2021] = data;
        break;
      case 0x2022: // Interrupt Related (!?)
        // ADDME!
        MINData[0x2022] = data & 0x03;
        break;
      case 0x2023: // Interrupt #1-#8 Enable (2)
        // ADDME!
        MINData[0x2023] = data;
        break;
      case 0x2024: // Interrupt Related (!?)
        // ADDME!
        MINData[0x2024] = data;
        break;
      case 0x2025: // Keypad Enable Intr
        // ADDME!
        MINData[0x2025] = data;
        break;
      case 0x2026: // Interrupt #9-#14 Enable (!?)
        // ADDME!
        MINData[0x2026] = data;
        break;
      case 0x2027: // Interrupt #1-#8 Flags
        MINData[0x2027] = MINData[0x2027] & ~data;
        break;
      case 0x2028: // Interrupt #9-#14 Flags
        MINData[0x2028] = MINData[0x2028] & ~data;
        break;
      case 0x2029: // Interrupt #15-#22 Flags
        MINData[0x2029] = MINData[0x2029] & ~data;
        break;
      case 0x202A: // Interrupt #9-#14 Flags
        MINData[0x202A] = MINData[0x202A] & ~data;
        break;
      case 0x202B:
      case 0x202C:
      case 0x202D:
      case 0x202E:
      case 0x202F: // UNUSED 0x45
        break;
      case 0x2030: // Counter 1 Control 1
        // ADDME!
        MINData[0x2030] = data & 0x85;
        break;
      case 0x2031: // Counter 1 Control 2
        // ADDME!
        MINData[0x2031] = data & 0x08;
        break;
      case 0x2032:
      case 0x2033: // Counter 1 Frequency
        // ADDME!
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x2034:
      case 0x2035: // Counter 1 Frequency Modulo (Unused)
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x2036:
      case 0x2037: // Counter 1 Counter
        break;
      case 0x2038: // Counter 2 Control 1
        // ADDME!
        MINData[0x2038] = data & 0x85;
        break;
      case 0x2039: // Counter 2 Control 2
        // ADDME!
        MINData[0x2039] = data & 0x08;
        break;
      case 0x203A:
      case 0x203B: // Counter 2 Frequency
        // ADDME!
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x203C:
      case 0x203D: // Counter 2 Frequency Modulo (Unused)
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x203E:
      case 0x203F: // Counter 2 Counter
        break;
      case 0x2040: // 256 Hz Timer Control
        if (data & 0x02) {
          MINData[0x2041] = 0x00;
        }
        MINData[0x2040] = data & 0x01;
        break;
      case 0x2041: // 256 Hz Timer Counter
        break;
      case 0x2042:
      case 0x2043: // UNUSED 0x45
        break;
      case 0x2044: // Unknown
        MINData[0x2044] = data & 0xF7;
      case 0x2045: // Unknown
        MINData[0x2045] = data & 0x0F;
      case 0x2046: // Unknown
        MINData[0x2046] = data;
      case 0x2047: // Unknown
        MINData[0x2047] = data & 0x0F;
      case 0x2048: // Counter 3 / Sound Control 1
        // ADDME!
        MINData[0x2048] = data & 0x85;
        break;
      case 0x2049: // Counter 3 / Sound Control 2
        // ADDME!
        MINData[0x2049] = data & 0x08;
        break;
      case 0x204A:
      case 0x204B: // Counter 3 / Sound Frequency
        // ADDME!
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x204C:
      case 0x204D: // Counter 3 / Sound Frequency Modulo (Unused)
        MINData[address & 0xFFFFF] = data;
        break;
      case 0x204E:
      case 0x204F: // Counter 1 Counter
        break;
      case 0x2050: // Unknown
        MINData[0x2050] = data & 0x08;
        break;
      case 0x2051: // Value 0x02 do a Hardware/Software Reset (?!)
        if (data & 0x02) {
          //DoPMReset();
        }
        MINData[0x2051] = data & 0x01;
        break;
      case 0x2052: // Keypad Status
        break;
      case 0x2053: // Unknown
        break;
      case 0x2054: // Unknown
        MINData[0x2054] = data & 0x77;
        break;
      case 0x2055: // Unknown
        MINData[0x2055] = data & 0x07;
        break;
      case 0x2056:
      case 0x2057:
      case 0x2058:
      case 0x2059:
      case 0x205A:
      case 0x205B:
      case 0x205C:
      case 0x205D:
      case 0x205E:
      case 0x205F: // UNUSED 0x45
        break;
      case 0x2060: // I/O Peripheral Address
        // ADDME!
        MINData[0x2060] = data;
        break;
      case 0x2061: // I/O Peripheral Data
        // ADDME!
        MINData[0x2061] = data;
        break;
      case 0x2062: // Unknown
        MINData[0x2062] = data & 0xF0;
        break;
      case 0x2063:
      case 0x2064:
      case 0x2065:
      case 0x2066:
      case 0x2067:
      case 0x2068:
      case 0x2069:
      case 0x206A:
      case 0x206B:
      case 0x206C:
      case 0x206D:
      case 0x206E:
      case 0x206F: // UNUSED 0x45
        break;
      case 0x2070: // Unknown
        MINData[0x2070] = data & 0x03;
        break;
      case 0x2071: // Sound Volume
        SoundVolume = data & 0x03;
        MINData[0x2071] = data & 0x03;
        break;
      case 0x2072:
      case 0x2073:
      case 0x2074:
      case 0x2075:
      case 0x2076:
      case 0x2077:
      case 0x2078:
      case 0x2079:
      case 0x207A:
      case 0x207B:
      case 0x207C:
      case 0x207D:
      case 0x207E:
      case 0x207F: // UNUSED 0x45
        break;
      case 0x2080: // LCD Control 0
        MINData[0x2080] = data & 0x3F;
        switch (MINData[0x2080] & 0x30) {
          case 0x00: Move_X = 0x00; break;
          case 0x10: if (Move_X > 0x20) Move_X = 0x20; break;
          case 0x20: if (Move_X > 0x60) Move_X = 0x60; break;
          case 0x30: if (Move_X > 0x60) Move_X = 0x60; break;
        }
        switch (MINData[0x2080] & 0x30) {
          case 0x00: if (Move_Y > 0x40) Move_Y = 0x40; break;
          case 0x10: if (Move_Y > 0x20) Move_Y = 0x20; break;
          case 0x20: Move_Y = 0x00; break;
          case 0x30: Move_Y = 0x00; break;
        }
        break;
      case 0x2081: // LCD Control 1
        MINData[0x2081] = (MINData[0x2081] & 0xF0) | (data & 0x0F);
        break;
      case 0x2082: // BG Tile Data Memory-Offset (Low Byte)
        MINData[0x2082] = data & 0xFC;
        break;
      case 0x2083: // BG Tile Data Memory-Offset (High Byte)
        MINData[0x2083] = data;
        break;
      case 0x2084: // BG Tile Data Memory-Offset (Bank)
        MINData[0x2084] = data & 0x1F;
        break;
      case 0x2085: // Vertical Move (Depends of Map Size)
        switch (MINData[0x2080] & 0x30) {
          case 0x00: if ((data & 0x7F) <= 0x40) Move_Y = data & 0x7F; break;
          case 0x10: if ((data & 0x7F) <= 0x20) Move_Y = data & 0x7F; break;
          case 0x20: break;
          case 0x30: break;
        }
        MINData[0x2085] = data & 0x7F;
        break;
      case 0x2086: // Horizontal Move (Depends of Map Size)
        switch (MINData[0x2080] & 0x30) {
          case 0x00: break;
          case 0x10: if ((data & 0x7F) <= 0x20) Move_X = data & 0x7F; break;
          case 0x20: if ((data & 0x7F) <= 0x60) Move_X = data & 0x7F; break;
          case 0x30: if ((data & 0x7F) <= 0x60) Move_X = data & 0x7F; break;
        }
        MINData[0x2086] = data & 0x7F;
        break;
      case 0x2087: // Sprite Tile Data Memory-Offset (Low Byte)
        MINData[0x2087] = data & 0xC0;
        break;
      case 0x2088: // Sprite Tile Data Memory-Offset (High Byte)
        MINData[0x2088] = data;
        break;
      case 0x2089: // Sprites Tile Data Memory-Offset (Bank)
        MINData[0x2089] = data & 0x1F;
        break;
      case 0x208A: // LCD Status
        break;
      case 0x208B:
      case 0x208C:
      case 0x208D:
      case 0x208E:
      case 0x208F:
      case 0x2090:
      case 0x2091:
      case 0x2092:
      case 0x2093:
      case 0x2094:
      case 0x2095:
      case 0x2096:
      case 0x2097:
      case 0x2098:
      case 0x2099:
      case 0x209A:
      case 0x209B:
      case 0x209C:
      case 0x209D:
      case 0x209E:
      case 0x209F:
      case 0x20A0:
      case 0x20A1:
      case 0x20A2:
      case 0x20A3:
      case 0x20A4:
      case 0x20A5:
      case 0x20A6:
      case 0x20A7:
      case 0x20A8:
      case 0x20A9:
      case 0x20AA:
      case 0x20AB:
      case 0x20AC:
      case 0x20AD:
      case 0x20AE:
      case 0x20AF:
      case 0x20B0:
      case 0x20B1:
      case 0x20B2:
      case 0x20B3:
      case 0x20B4:
      case 0x20B5:
      case 0x20B6:
      case 0x20B7:
      case 0x20B8:
      case 0x20B9:
      case 0x20BA:
      case 0x20BB:
      case 0x20BC:
      case 0x20BD:
      case 0x20BE:
      case 0x20BF:
      case 0x20C0:
      case 0x20C1:
      case 0x20C2:
      case 0x20C3:
      case 0x20C4:
      case 0x20C5:
      case 0x20C6:
      case 0x20C7:
      case 0x20C8:
      case 0x20C9:
      case 0x20CA:
      case 0x20CB:
      case 0x20CC:
      case 0x20CD:
      case 0x20CE:
      case 0x20CF:
      case 0x20D0:
      case 0x20D1:
      case 0x20D2:
      case 0x20D3:
      case 0x20D4:
      case 0x20D5:
      case 0x20D6:
      case 0x20D7:
      case 0x20D8:
      case 0x20D9:
      case 0x20DA:
      case 0x20DB:
      case 0x20DC:
      case 0x20DD:
      case 0x20DE:
      case 0x20DF:
      case 0x20E0:
      case 0x20E1:
      case 0x20E2:
      case 0x20E3:
      case 0x20E4:
      case 0x20E5:
      case 0x20E6:
      case 0x20E7:
      case 0x20E8:
      case 0x20E9:
      case 0x20EA:
      case 0x20EB:
      case 0x20EC:
      case 0x20ED:
      case 0x20EE:
      case 0x20EF:
      case 0x20F0:
      case 0x20F1:
      case 0x20F2:
      case 0x20F3:
      case 0x20F4:
      case 0x20F5:
      case 0x20F6:
      case 0x20F7:
      case 0x20F8:
      case 0x20F9:
      case 0x20FA:
      case 0x20FB:
      case 0x20FC:
      case 0x20FD:
      case 0x20FE:
        LCDCommand = data;
        break;
      case 0x20FF:
        if (LCDCommand == 0x81) Contrast = data & 0x3F;
        break;
      default:
        MINData[address & 0xFFFFF] = data;
        break;
    }
  }
  if (address >= 0x002100) return;
}

// Write Memory from PC
static void WritePokeCPU(unsigned short address, unsigned char data)
{
  if (address <= 0x7FFF) {  // Bank 0 + Special Stuff
    WritePokeCPUEx(address, data);
    return;
  }
  if (address >= 0x8000) {  // Bank 1..31
    WritePokeCPUEx((address & 0x7FFF) | ((PokeCPU.V & 0x1F) << 15), data);
    return;
  }
  return;
}

// Illegal Opcode
static void IllegalPokeCPU(unsigned long address)
{
  // Todo....
}

// Game-Screen Display Variables
//BITMAPINFO ScreenView_BitmapInfo;
//HBITMAP ScreenView_Bitmap;
//HDC ScreenView_HDC;
unsigned short ScreenView_VideoBuffer[96*64] ;

#define COLOR16(v) ( (((v&0xFF)>>3)<<11)| ((((v>>8)&0xFF)>>2)<<5) | ((v>>19)&0x3F) )
// Init Game-Screen
bool ScreenView_Init()
{
#if 0
  int i;
  ScreenView_BitmapInfo.bmiHeader.biSize = sizeof(ScreenView_BitmapInfo.bmiHeader);
  ScreenView_BitmapInfo.bmiHeader.biWidth = 96;
  ScreenView_BitmapInfo.bmiHeader.biHeight = -64;
  ScreenView_BitmapInfo.bmiHeader.biPlanes = 1;
  ScreenView_BitmapInfo.bmiHeader.biBitCount = 32;
  ScreenView_BitmapInfo.bmiHeader.biCompression = BI_RGB;
  ScreenView_BitmapInfo.bmiHeader.biSizeImage = 0;
  ScreenView_BitmapInfo.bmiHeader.biXPelsPerMeter = 96;
  ScreenView_BitmapInfo.bmiHeader.biYPelsPerMeter = 96;
  ScreenView_BitmapInfo.bmiHeader.biClrUsed = 0;
  ScreenView_BitmapInfo.bmiHeader.biClrImportant = 0;
  ScreenView_HDC = CreateCompatibleDC(NULL);
  if (ScreenView_HDC == NULL) return false;
  ScreenView_Bitmap = CreateDIBSection(ScreenView_HDC, &ScreenView_BitmapInfo, DIB_RGB_COLORS, (void **)&ScreenView_VideoBuffer, NULL, 0);
  if (ScreenView_Bitmap == NULL) {
    DeleteDC(ScreenView_HDC);
    return false;
  }
  GdiFlush();
  SelectObject(ScreenView_HDC, ScreenView_Bitmap);
#endif
  for (int i=0; i<96 * 64; i++) ScreenView_VideoBuffer[i] = COLOR16(0x8EAD92);
  return true;
}

// Destroy Game-Screen
void ScreenView_Destroy()
{
  //DeleteObject(ScreenView_Bitmap);
  //DeleteDC(ScreenView_HDC);
}

// Do a Pokmon-Mini Reset
void DoPMReset()
{
  int x, y;
  for (x=0; x<96 * 64; x++) ScreenArea[x] = 0x01;
  for (x=0; x<96 * 64; x++) GreyEmu[0][x] = 0x01;
  for (x=0; x<96 * 64; x++) GreyEmu[1][x] = 0x01;
  if (ScreenView_VideoBuffer != NULL) {
    for (x=0; x<96; x++) {
      for (y=0; y<64; y++) {
        ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(ScnColors[RegDisplayColor][1]);
      }
    }
  }
  ResetPokeCPU();
  ScanLine = 0;
  Contrast = 0x1F;
  for (x=0; x<256; x++) MINData[0x2000 + x] = DefaultRegIO[x];
  SetStatusBarText("Pokmon-Mini Emulation as been reset", 0);
}

// Call a Interrupt (kinda like CINT #nn)
void DoCallInterrupt(unsigned char BIOSIntr)
{
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 4;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.F);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.PC.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 3, PokeCPU.V);
  PokeCPU.F = 0xC0;
  PokeCPU.V = 0x00;
  PokeCPU.tmp = BIOSIntr & 0x000FE;
  PokeCPU.PC.W.l = ReadPokeCPU((unsigned short)PokeCPU.tmp) | (ReadPokeCPU((unsigned short)PokeCPU.tmp + 1) << 8);
  PokeCPU.Halt = false;
}

#define GetRValue(rgb) ((BYTE)(rgb)) 
#define GetGValue(rgb) ((BYTE)(((WORD)(rgb))>>8))
#define GetBValue(rgb) ((BYTE)((rgb)>>16))
#define RGB(r,g,b)     ((COLORREF)(((BYTE)(r)|((WORD)(g)<<8))|(((DWORD)(BYTE)(b))<<16)))

// Interpolate 24-Bit Red-Green-Blue into 3 Colors
static unsigned long RGBInterpolate3(unsigned long color1, unsigned long color2, unsigned long color3, unsigned long cursor)
{
  if (cursor < 0x10) {
    int r = GetRValue(color1) + (GetRValue(color2) - GetRValue(color1)) * cursor / 0x10;
    int g = GetGValue(color1) + (GetGValue(color2) - GetGValue(color1)) * cursor / 0x10;
    int b = GetBValue(color1) + (GetBValue(color2) - GetBValue(color1)) * cursor / 0x10;
    return RGB(r, g, b);
  }
  int r = GetRValue(color2) + (GetRValue(color3) - GetRValue(color2)) * (cursor - 0x10) / 0x10;
  int g = GetGValue(color2) + (GetGValue(color3) - GetGValue(color2)) * (cursor - 0x10) / 0x10;
  int b = GetBValue(color2) + (GetBValue(color3) - GetBValue(color2)) * (cursor - 0x10) / 0x10;
  return RGB(r, g, b);
}

// Make Grey Emulation
unsigned long GreyEmulation(unsigned char *dataaddr, int x, int y, int id)
{
  unsigned char eeLCDOldBit = GreyEmu[id][(y * 96) + x] ? 1 : 0;
  unsigned char eeLCDNewBit = dataaddr[(y * 96) + x] ? 1 : 0;
  int IntContrast;

  if (id == 0) eeLCDOldBit = eeLCDNewBit;

  GreyEmu[id][(y * 96) + x] = eeLCDNewBit;

  switch (eeLCDNewBit + eeLCDOldBit) {
    case 0: // 0%
      dataaddr[(y * 96) + x] = eeLCDNewBit;
      IntContrast = Contrast;
      if (IntContrast < 0) IntContrast = 0;
      if (IntContrast > 0x1F) IntContrast = 0x1F;
      return RGBInterpolate3(ScnColors[RegDisplayColor][2], ScnColors[RegDisplayColor][1], ScnColors[RegDisplayColor][0], IntContrast);
    case 1: // 50%
      dataaddr[(y * 96) + x] = eeLCDNewBit;
      IntContrast = Contrast - 0x10;
      if (IntContrast < 0) IntContrast = 0;
      if (IntContrast > 0x1F) IntContrast = 0x1F;
      return RGBInterpolate3(ScnColors[RegDisplayColor][2], ScnColors[RegDisplayColor][1], ScnColors[RegDisplayColor][0], IntContrast);
    case 2: // 100%
      dataaddr[(y * 96) + x] = eeLCDNewBit;
      IntContrast = Contrast - 0x1F;
      if (IntContrast < 0) IntContrast = 0;
      return RGBInterpolate3(ScnColors[RegDisplayColor][2], ScnColors[RegDisplayColor][1], ScnColors[RegDisplayColor][0], IntContrast);
  }
  return 0xFF00FF;
}

// Convert cords. to 1bpp
static unsigned char Convert1bppToPixel(unsigned char *dataaddr, int tileid, int x, int y)
{
  return ((dataaddr[(tileid * 8) + x] >> y) & 0x01) ? 0 : 1;
}

// 16 x 16 Block of Mask
const unsigned char vTileMask[4][4] = {{0, 1, 4, 5},
                                       {4, 5, 0, 1},
                                       {1, 0, 5, 4},
                                       {5, 4, 1, 0}};

// 16 x 16 Block of Draw
const unsigned char vTileDraw[4][4] = {{2, 3, 6, 7},
                                       {6, 7, 2, 3},
                                       {3, 2, 7, 6},
                                       {7, 6, 3, 2}};

// Vertical Flip values
const unsigned char vFlipVertically[512] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                                            0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
                                            0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
                                            0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
                                            0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
                                            0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
                                            0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
                                            0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
                                            0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
                                            0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
                                            0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
                                            0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
                                            0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
                                            0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,

                                            0x00, 0x80, 0x40, 0xC0, 0x20, 0xA0, 0x60, 0xE0, 0x10, 0x90, 0x50, 0xD0, 0x30, 0xB0, 0x70, 0xF0,
                                            0x08, 0x88, 0x48, 0xC8, 0x28, 0xA8, 0x68, 0xE8, 0x18, 0x98, 0x58, 0xD8, 0x38, 0xB8, 0x78, 0xF8,
                                            0x04, 0x84, 0x44, 0xC4, 0x24, 0xA4, 0x64, 0xE4, 0x14, 0x94, 0x54, 0xD4, 0x34, 0xB4, 0x74, 0xF4,
                                            0x0C, 0x8C, 0x4C, 0xCC, 0x2C, 0xAC, 0x6C, 0xEC, 0x1C, 0x9C, 0x5C, 0xDC, 0x3C, 0xBC, 0x7C, 0xFC,
                                            0x02, 0x82, 0x42, 0xC2, 0x22, 0xA2, 0x62, 0xE2, 0x12, 0x92, 0x52, 0xD2, 0x32, 0xB2, 0x72, 0xF2,
                                            0x0A, 0x8A, 0x4A, 0xCA, 0x2A, 0xAA, 0x6A, 0xEA, 0x1A, 0x9A, 0x5A, 0xDA, 0x3A, 0xBA, 0x7A, 0xFA,
                                            0x06, 0x86, 0x46, 0xC6, 0x26, 0xA6, 0x66, 0xE6, 0x16, 0x96, 0x56, 0xD6, 0x36, 0xB6, 0x76, 0xF6,
                                            0x0E, 0x8E, 0x4E, 0xCE, 0x2E, 0xAE, 0x6E, 0xEE, 0x1E, 0x9E, 0x5E, 0xDE, 0x3E, 0xBE, 0x7E, 0xFE,
                                            0x01, 0x81, 0x41, 0xC1, 0x21, 0xA1, 0x61, 0xE1, 0x11, 0x91, 0x51, 0xD1, 0x31, 0xB1, 0x71, 0xF1,
                                            0x09, 0x89, 0x49, 0xC9, 0x29, 0xA9, 0x69, 0xE9, 0x19, 0x99, 0x59, 0xD9, 0x39, 0xB9, 0x79, 0xF9,
                                            0x05, 0x85, 0x45, 0xC5, 0x25, 0xA5, 0x65, 0xE5, 0x15, 0x95, 0x55, 0xD5, 0x35, 0xB5, 0x75, 0xF5,
                                            0x0D, 0x8D, 0x4D, 0xCD, 0x2D, 0xAD, 0x6D, 0xED, 0x1D, 0x9D, 0x5D, 0xDD, 0x3D, 0xBD, 0x7D, 0xFD,
                                            0x03, 0x83, 0x43, 0xC3, 0x23, 0xA3, 0x63, 0xE3, 0x13, 0x93, 0x53, 0xD3, 0x33, 0xB3, 0x73, 0xF3,
                                            0x0B, 0x8B, 0x4B, 0xCB, 0x2B, 0xAB, 0x6B, 0xEB, 0x1B, 0x9B, 0x5B, 0xDB, 0x3B, 0xBB, 0x7B, 0xFB,
                                            0x07, 0x87, 0x47, 0xC7, 0x27, 0xA7, 0x67, 0xE7, 0x17, 0x97, 0x57, 0xD7, 0x37, 0xB7, 0x77, 0xF7,
                                            0x0F, 0x8F, 0x4F, 0xCF, 0x2F, 0xAF, 0x6F, 0xEF, 0x1F, 0x9F, 0x5F, 0xDF, 0x3F, 0xBF, 0x7F, 0xFF};


// Render Pokmon-mini Screen
void RenderScreen(unsigned char *screen, bool forceenable, int id)
{
  unsigned char *address, *pm_vram, *pm_tiles, *DovFlipVertically;
  int s, x, y, tileid, mapsiz;
  int sprite_x, sprite_y;
  unsigned char offx, offy;
  unsigned char mask, draw, tiledraw, tilemask, invert_x;

  pm_vram = &MINData[0x1000];

  if ((MINData[0x2080] & 0x08) || (forceenable)) {

    // Specify Map Size in Width
    switch (MINData[0x2080] & 0x30) {
      case 0x00: mapsiz = 12; break;
      case 0x10: mapsiz = 16; break;
      case 0x20: mapsiz = 24; break;
      case 0x30: mapsiz = 24; break;
    }

    // Render Tiles to $1000 (Only if Renderer Enabled)
    if ((MINData[0x2080] & 0x02) || (forceenable)) {
      pm_tiles = &MINData[0x1360];
      address = &MINData[(MINData[0x2082] | (MINData[0x2083] << 8) | (MINData[0x2084] << 16)) & 0xFFFF8];
      for (y=0; y<8; y++) {
        offy = y + (Move_Y >> 3);
        for (x=0; x<96; x++) {
          offx = x + Move_X;
          tileid = (offx >> 3) + (offy * mapsiz);
          pm_vram[(y * 96) + x] = address[(pm_tiles[tileid] << 3) + (offx & 7)] >> (Move_Y & 7);
        }
        for (x=0; x<96; x++) {
          offx = x + Move_X;
          tileid = (offx >> 3) + (offy * mapsiz) + mapsiz;
          pm_vram[(y * 96) + x] = pm_vram[(y * 96) + x] | (address[(pm_tiles[tileid] << 3) + (offx & 7)] << (8 - (Move_Y & 7)));
        }
      }
      if (MINData[0x2080] & 0x01) {
        for (x=0; x<768; x++) {
          pm_vram[x] = ~pm_vram[x];
        }
      }
    }

    // Render Sprites
    if ((MINData[0x2080] & 0x04) || (forceenable)) {
      address = &MINData[(MINData[0x2087] | (MINData[0x2088] << 8) | (MINData[0x2089] << 16)) & 0xFFFC0];
      for (s=1; s>=0; s--) {
        pm_tiles = &MINData[0x1300 + (s << 2)];
        if (!(pm_tiles[3] & 0x08)) continue;
        sprite_x = (pm_tiles[0] - 0x10) & 0x7F;
        sprite_y = (pm_tiles[1] - 0x10) & 0x7F;
        // Draw 1st Sprite
        offy = (sprite_y >> 3) & 0x0F;
        tiledraw = vTileDraw[pm_tiles[3] & 0x03][0];
        tilemask = vTileMask[pm_tiles[3] & 0x03][0];
        invert_x = (pm_tiles[3] & 0x01) ? 0x07 : 0x00;
        DovFlipVertically = (unsigned char *)&vFlipVertically[(pm_tiles[3] & 0x02) ? 256 : 0];
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) << (sprite_y & 7));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] << (sprite_y & 7));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        offy = ((sprite_y >> 3) + 1) & 0x0F;
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x) & 0x7F;
          if (offx > 95) continue;
          if (offy > 7) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) >> (8 - (sprite_y & 7)));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] >> (8 - (sprite_y & 7)));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        // Draw 2st Sprite
        offy = ((sprite_y >> 3) + 1) & 0x0F;
        tiledraw = vTileDraw[pm_tiles[3] & 0x03][1];
        tilemask = vTileMask[pm_tiles[3] & 0x03][1];
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) << (sprite_y & 7));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] << (sprite_y & 7));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        offy = ((sprite_y >> 3) + 2) & 0x0F;
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) >> (8 - (sprite_y & 7)));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] >> (8 - (sprite_y & 7)));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        // Draw 3rd Sprite
        offy = (sprite_y >> 3) & 0x0F;
        tiledraw = vTileDraw[pm_tiles[3] & 0x03][2];
        tilemask = vTileMask[pm_tiles[3] & 0x03][2];
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x + 8) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) << (sprite_y & 7));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] << (sprite_y & 7));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        offy = ((sprite_y >> 3) + 1) & 0x0F;
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x + 8) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) >> (8 - (sprite_y & 7)));
          draw = (DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] >> (8 - (sprite_y & 7)));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        // Draw 4th Sprite
        offy = ((sprite_y >> 3) + 1) & 0x0F;
        tiledraw = vTileDraw[pm_tiles[3] & 0x03][3];
        tilemask = vTileMask[pm_tiles[3] & 0x03][3];
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x + 8) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) << (sprite_y & 7));
          draw = DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] << (sprite_y & 7);
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
        offy = ((sprite_y >> 3) + 2) & 0x0F;
        if (offy < 8) for (x=0; x<8; x++) {
          offx = (x + sprite_x + 8) & 0x7F;
          if (offx > 95) continue;
          mask = ~((DovFlipVertically[address[((pm_tiles[2] + tilemask) << 3) + (x ^ invert_x)]] ^ 0xFF) >> (8 - (sprite_y & 7)));
          draw = DovFlipVertically[address[((pm_tiles[2] + tiledraw) << 3) + (x ^ invert_x)]] >> (8 - (sprite_y & 7));
          if (pm_tiles[3] & 0x04) draw = ~draw;
          pm_vram[(offy * 96) + offx] = (pm_vram[(offy * 96) + offx] & mask) | (draw & ~mask);
        }
      }
    }

    // Convert $1000 to Display
    for (y=0; y<64; y++) {
      for (x=0; x<96; x++) {
        tileid = (x >> 3) + ((y >> 3) * 12);
        screen[(y * 96) + x] = Convert1bppToPixel(pm_vram, tileid, x & 7, y & 7);
      }
    }
  }
}

void StopSound()
{
  int i;

  for (i=0; i<SND_SBUFFSIZE; i++) PlayBuffer[i] = 0x80;

//  int hr;
  LPVOID pData1;
  DWORD dwData1Size;
  LPVOID pData2;
  DWORD dwData2Size;
  DWORD play;
  DWORD dwStatus;
  
  for (i=0; i<SND_BUFFERSIZE / SND_SBUFFSIZE; i++) {
    DirectSB1->GetStatus(&dwStatus);

    //if (dwStatus && DSBSTATUS_BUFFERLOST) {
//      do {
        //hr = DirectSB1->Restore();
        //if (hr == DSERR_BUFFERLOST) Sleep(10);
      //} while ((hr = DirectSB1->Restore()) == DSERR_BUFFERLOST);
    //}

    if (dwStatus && DSBSTATUS_PLAYING) {
      while(true) {
        DirectSB1->GetCurrentPosition(&play, NULL);

        if (play < ((DWORD)SndNextWriteOffset) ||
            play > ((DWORD)SndNextWriteOffset + SND_SBUFFSIZE)) {
          break;
        }
      }
    }

    DirectSB1->Lock(SndNextWriteOffset, SND_SBUFFSIZE, &pData1, &dwData1Size, &pData2, &dwData2Size, 0);
    CopyMemory(pData1, PlayBuffer, dwData1Size);
    CopyMemory(pData2, (void *)(((DWORD)PlayBuffer) + dwData1Size), dwData2Size);

    SndNextWriteOffset += dwData1Size;
    SndNextWriteOffset %= SND_BUFFERSIZE; // Circular buffer

    DirectSB1->Unlock(pData1, dwData1Size, pData2, dwData2Size);
  }
}

int SndPulsePosition = 0;
unsigned char SoundVolConv[4] = {0x80, 0xB0, 0xB0, 0xFF};

__inline void PulseSound(bool EnableSnd)
{
  int timerct1, timerct2;

  PlayBuffer[SndPulsePosition] = 0x80;
  if (EnableSnd) {
    timerct1 = MINData[0x204A] + (MINData[0x204B] << 8);
    timerct2 = MINData[0x204C] + (MINData[0x204D] << 8);
    if (timerct1) {
      SoundTrueFrequency = TimerFrequencyTab[Timer3Scal] / timerct1;
      if (SoundTrueFrequency > 32767) SoundTrueFrequency = 0;
      SoundPulseWd = timerct2 * 16 / timerct1;
      if (SoundPulseWd > 15) SoundPulseWd = 0;
    } else {
      SoundTrueFrequency = 0;
      SoundPulseWd = 0;
    }
    if ((MINData[0x2019] & 0x20) && (MINData[0x201C] & 0x08) && (MINData[0x2048] & 0x80)) {
      IntSoundCount += SoundTrueFrequency;
      if (((IntSoundCount & 0xF000) >> 12) >= (SoundPulseWd & 15)) {
        PlayBuffer[SndPulsePosition] = SoundVolConv[SoundVolume];
      }
    }
  }

  SndPulsePosition++;
}

__inline void ProcessSound(bool EnableSnd)
{
//  int hr;
  LPVOID pData1;
  DWORD dwData1Size;
  LPVOID pData2;
  DWORD dwData2Size;
  DWORD play;
  DWORD dwStatus;

  SndPulsePosition = 0;

  DirectSB1->GetStatus(&dwStatus);

//  if (dwStatus && DSBSTATUS_BUFFERLOST) {
    //do {
//      hr = DirectSB1->Restore();
      //if (hr == DSERR_BUFFERLOST) Sleep(10);
    //} while ((hr = DirectSB1->Restore()) == DSERR_BUFFERLOST);
  //}

  if (dwStatus && DSBSTATUS_PLAYING) {
    while(true) {
      DirectSB1->GetCurrentPosition(&play, NULL);

      if (play < ((DWORD)SndNextWriteOffset) ||
          play > ((DWORD)SndNextWriteOffset + SND_SBUFFSIZE)) {
        break;
      }
    }
  }

  DirectSB1->Lock(SndNextWriteOffset, SND_SBUFFSIZE, &pData1, &dwData1Size, &pData2, &dwData2Size, 0);

  CopyMemory(pData1, PlayBuffer, dwData1Size);
  CopyMemory(pData2, (void *)(((DWORD)PlayBuffer) + dwData1Size), dwData2Size);

  SndNextWriteOffset += dwData1Size;
  SndNextWriteOffset %= SND_BUFFERSIZE; // Circular buffer

  DirectSB1->Unlock(pData1, dwData1Size, pData2, dwData2Size);
}

void MessageBox( int i, char *c, char*c2, int j ) 
{
}

// Initialize DirectX
bool StartUpDirectX(HWND window)
{
  WAVEFORMATEX pcmwf;
  DSBUFFERDESC dsbdesc;
  if FAILED(DirectSoundCreate(NULL, &DirectS, NULL)) {
//    MessageBox(0, "DirectSoundCreate() Failed", "", 0);
    return false;
  }
  if FAILED(DirectS->SetCooperativeLevel(window, DSSCL_EXCLUSIVE)) {
    MessageBox(0, "Failed SetCooperativeLevel", "", 0);
    return false;
  }
  memset(&dsbdesc, 0, sizeof(DSBUFFERDESC));
  dsbdesc.dwSize = sizeof(DSBUFFERDESC);
  dsbdesc.dwFlags = 0 ; //DSBCAPS_PRIMARYBUFFER;
  memset(&pcmwf, 0, sizeof(WAVEFORMATEX));
  pcmwf.wFormatTag = WAVE_FORMAT_PCM;
  pcmwf.nChannels = 1;
  pcmwf.nSamplesPerSec = SND_PLAYBACK;
  pcmwf.wBitsPerSample = 8;
  pcmwf.nBlockAlign = (unsigned short)(((unsigned short)pcmwf.nChannels * (unsigned short)pcmwf.wBitsPerSample) / 8);
  pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
  dsbdesc.lpwfxFormat = &pcmwf ;

  if FAILED(DirectS->CreateSoundBuffer(&dsbdesc, &DirectSBB, NULL)) {
    MessageBox(0, "Failed CreateSoundBuffer", "", 0);
    return false;
  }
  //if FAILED(DirectSBB->SetFormat(&pcmwf)) {
//    MessageBox(0, "Failed SetFormat", "", 0);
    //return false;
  //}
  dsbdesc.dwSize = sizeof(DSBUFFERDESC);
  dsbdesc.dwFlags = DSBCAPS_CTRLVOLUME ; //| DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS;
  dsbdesc.dwBufferBytes = SND_BUFFERSIZE;
  dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;
  if FAILED(DirectS->CreateSoundBuffer(&dsbdesc, &DirectSB1, NULL)) {
    MessageBox(0, "Failed CreateSoundBuffer 2", "", 0);
    return false;
  }
  LPVOID pData1;
  DWORD dwData1Size;
  LPVOID pData2;
  DWORD dwData2Size;
  PlayBuffer = new unsigned char [SND_BUFFERSIZE + 8];
  unsigned int Loop;
  for (Loop=0; Loop<SND_BUFFERSIZE + 8; Loop++) {
    PlayBuffer[Loop] = 0x80;
  }
  DirectSB1->Lock(0, SND_BUFFERSIZE, &pData1, &dwData1Size, &pData2, &dwData2Size, 0);
  CopyMemory(pData1, PlayBuffer, dwData1Size);
  CopyMemory(pData2, (void *)(((int)PlayBuffer)+dwData1Size), dwData2Size);
  DirectSB1->Unlock(pData1, dwData1Size, pData2, dwData2Size);
  DirectSB1->SetCurrentPosition(0);
  DirectSB1->Play(0, 0, DSBPLAY_LOOPING);
  return true;
}

// Terminate DirectX
void EndUpDirectX()
{
  if (DirectS != NULL) DirectS->Release();
  if (DirectSBB != NULL) DirectSBB->Release();
  if (DirectSB1 != NULL) DirectSB1->Release();
  delete[] PlayBuffer;
}

#define VK_UP 'R' 
#define VK_DOWN 'S' 
#define VK_LEFT 'T' 
#define VK_RIGHT 'U' 
#define VK_RETURN 'P' 

// When Key is Released on Main Window
void OnKeyUpEvent(unsigned long VKey)
{
  // Process Game Keys
  if (VKey == 'Y') MINData[0x2052] = MINData[0x2052] | 0x01;
  if (VKey == 'Z') MINData[0x2052] = MINData[0x2052] | 0x01;
  if (VKey == 'X') MINData[0x2052] = MINData[0x2052] | 0x02;
  if (VKey == 'C') MINData[0x2052] = MINData[0x2052] | 0x04;
  if (VKey == VK_UP) MINData[0x2052] = MINData[0x2052] | 0x08;
  if (VKey == VK_DOWN) MINData[0x2052] = MINData[0x2052] | 0x10;
  if (VKey == VK_LEFT) MINData[0x2052] = MINData[0x2052] | 0x20;
  if (VKey == VK_RIGHT) MINData[0x2052] = MINData[0x2052] | 0x40;
  if (VKey == VK_RETURN) MINData[0x2052] = MINData[0x2052] | 0x80;
}

// When Key is Pressed on Main Window
void OnKeyDownEvent(unsigned long VKey)
{
  // Process Game Keys
  if (VKey == 'V') MINData[0x202A] = MINData[0x202A] | 0x40;
  if (VKey == 'Y') {MINData[0x2052] = MINData[0x2052] & ~0x01; MINData[0x2029] = MINData[0x2029] | 0x01;}
  if (VKey == 'Z') {MINData[0x2052] = MINData[0x2052] & ~0x01; MINData[0x2029] = MINData[0x2029] | 0x01;}
  if (VKey == 'X') {MINData[0x2052] = MINData[0x2052] & ~0x02; MINData[0x2029] = MINData[0x2029] | 0x02;}
  if (VKey == 'C') {MINData[0x2052] = MINData[0x2052] & ~0x04; MINData[0x2029] = MINData[0x2029] | 0x04;}
  if (VKey == VK_UP) {MINData[0x2052] = MINData[0x2052] & ~0x08; MINData[0x2029] = MINData[0x2029] | 0x08;}
  if (VKey == VK_DOWN) {MINData[0x2052] = MINData[0x2052] & ~0x10; MINData[0x2029] = MINData[0x2029] | 0x10;}
  if (VKey == VK_LEFT) {MINData[0x2052] = MINData[0x2052] & ~0x20; MINData[0x2029] = MINData[0x2029] | 0x20;}
  if (VKey == VK_RIGHT) {MINData[0x2052] = MINData[0x2052] & ~0x40; MINData[0x2029] = MINData[0x2029] | 0x40;}
  if (VKey == VK_RETURN) {MINData[0x2052] = MINData[0x2052] & ~0x80; MINData[0x2029] = MINData[0x2029] | 0x80;}
}

// Display Game-LCD to the Window
void DisplayGameLCD(HDC hdc)
{
//  int x, y;
  //x = (rMainWnd.right - GameWidth) / 2;
  //y = (rMainWnd.bottom - GameHeight) / 2;
  //StretchBlt(hdc, x, y, GameWidth, GameHeight, ScreenView_HDC, 0, 0, 96, 64, SRCCOPY);
}

// When Main Window need to be painted
void OnWindowPaint(HWND hWnd)
{
#if 0
  PAINTSTRUCT ps;
  HDC hdc;
  // Get HC / Begin Paint
  if (hWnd != NULL) {
    hdc = BeginPaint(hWnd, &ps);
  } else {
    hdc = GetDC(hMainWnd);
    if (!hdc) return;
  }
  // Draw to the window
  FillRect(hdc, &rMainWnd, CreateSolidBrush(0));
  DisplayGameLCD(hdc);
  // Release HC / End Paint
  if (hWnd != NULL) {
    EndPaint(hWnd, &ps);
  } else {
    ReleaseDC(hMainWnd, hdc);
  }
#endif
}

// Redraw all visible Windows
void OnRedrawAll()
{
  OnWindowPaint(NULL);
}

// When Main Window change size
void OnResize(int Width, int Height)
{
#if 0
  int iStatusPart[2];
  rMainWnd.bottom = Height - rStatusbar.bottom;
  rMainWnd.right = Width;
  iStatusPart[0] = rMainWnd.right - 32;
  iStatusPart[1] = -1;
  SendMessage(hStatusbar, SB_SETPARTS, (WPARAM)2, (LPARAM)&iStatusPart);
  SendMessage(hStatusbar, WM_SIZE, (WPARAM)SIZE_RESTORED, (Width << 16) + Height);
  GameWidth = (rMainWnd.right / 96) * 96;
  GameHeight = (rMainWnd.bottom / 64) * 64;
  if (GameWidth <= 0) GameWidth = 96;
  if (GameHeight <= 0) GameHeight = 64;
  OnWindowPaint(NULL);
#endif
}

// Limit the minimum/maximum size of the window
void OnSizing(DWORD sizedtype, LPRECT area)
{ 
  if ((area->right - area->left) < 192) area->right = area->left + 192;
  if ((area->bottom - area->top) < 192) area->bottom = area->top + 192;
}

extern "C" void xbox_put_image( unsigned char *pix, int spitch ) ;
extern "C" int xbox_check_events() ;
extern "C" unsigned int xbox_read_port( int which ) ;

void handleport( unsigned int pval )
{
	unsigned char pdata = pval&0xFF ;
	unsigned char pinvert = pdata^0xFF ;

	MINData[0x2052] = pinvert ;
	MINData[0x2029] = pdata ;

	if ( pval & 0x100 )
		MINData[0x202A] = MINData[0x202A] | 0x40; 

}


// Full-Speed Emulation Thread
DWORD WINAPI FullSpeedEmulationTh(LPVOID lpParameter)
{
  HDC hdc;
  DWORD lastclk;
  int x, y;
  unsigned int emuport ;
  FullSpeedEmu = true;
  //RedrawWindow(hMainWnd, &rMainWnd, NULL, RDW_INVALIDATE);
  lastclk = GetTickCount();
  //hdc = GetDC(hMainWnd);
  while (FullSpeedEmu) {
    RenderScreen(ScreenArea, false, 1);
    for (y=0; y<64; y++) {
      for (x=0; x<96; x++) {
        ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, DoGreyEmu ? 1 : 0));
      }
    }
    //StretchBlt(hdc, 0, 0, rMainWnd.right, rMainWnd.bottom, ScreenView_HDC, 0, 0, 96, 64, SRCCOPY);
    //DisplayGameLCD(hdc);
	xbox_put_image( (unsigned char*)ScreenView_VideoBuffer, 96*2 ) ;
	if ( xbox_check_events() )
		break ;

	//emuport = xbox_read_port( 0 ) ;
	handleport( xbox_read_port(0) ) ;

    for (y=0; y<128; y++) {
      PokeCPU.LPeriod = 1042;
      PokeCPU.LCount = 1042;
      RunPokeCPU();
    }
    //while (GetTickCount() < lastclk);
    //lastclk = GetTickCount() + 31;
  }
  for (y=0; y<64; y++) {
    for (x=0; x<96; x++) {
      ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
    }
  }
  //ReleaseDC(hMainWnd, hdc);
  //RedrawWindow(hMainWnd, &rMainWnd, NULL, RDW_INVALIDATE);
  return 0;
}

// Run Full-Speed Emulation
void DoFullSpeedEmu()
{
  DWORD ThID;
  if (!FullSpeedEmu) {
    SetStatusBarText("Full-Speed Emulation started", 0);
    FullSpeedHandle = CreateThread(NULL, 4096, FullSpeedEmulationTh, NULL, 0, &ThID);
  }
}

// Stop Emulation
void StopEmu()
{
  if (FullSpeedEmu) {
    FullSpeedEmu = false;
    Sleep(25);
    WaitForSingleObject(FullSpeedHandle, INFINITE);
    StopSound();
    OnRedrawAll();
    SetStatusBarText("Full-Speed Emulation stopped", 0);
    return;
  }
}

// Reset Emulation
void ResetEmu()
{
  DoPMReset();
  OnRedrawAll();
}

char FPSText[80];

// Frames Per Second Timer
VOID CALLBACK FPSTimerTh(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  if (FPSCounter == 0) {
    sprintf(FPSText, "PokeMini %s", Version);
  } else {
    sprintf(FPSText, "PokeMini %s - %d%%", Version, FPSCounter * 100 / 30);
  }
//  SetWindowText(hMainWnd, FPSText);
  FPSCounter = 0;
}

// Start-Up Trigger (Full-Speed)
VOID CALLBACK StartUpRunFullTh(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  DWORD ThID;
  //KillTimer(hwnd, idEvent);
  FullSpeedHandle = CreateThread(NULL, 4096, FullSpeedEmulationTh, NULL, 0, &ThID);
  SetStatusBarText("Full-Speed Emulation started", 0);
}

#include "pokebios.h"

// New .MIN file
void NewMinFile(HWND hWnd)
{
  int bioshand, i;
  char tmpstr[256];
  StopEmu();
  DoPMReset();
  PokeCPU.LPeriod = 1042;
  PokeCPU.LCount = 1042;
  for (i=0; i<0x100000; i++) MINData[i] = 0xFF;
  for (i=0x1000; i<0x2000; i++) MINData[i] = 0x00;
  for (i=0; i<256; i++) MINData[0x2000 + i] = DefaultRegIO[i]; 
  memcpy( MINData, pokeminibios, 0x1000 ) ;

#if 0
  sprintf(tmpstr, "%s\\BIOS.MIN", ApplicationPath);
  if ((bioshand = open(tmpstr, _O_BINARY | O_RDONLY)) != -1) {
    read(bioshand, &MINData, 0x1000);
    close(bioshand);
  } else {
    for (i=0; i<sizeof(DummyBIOS); i++) MINData[i] = DummyBIOS[i];
  }
#endif
  SetStatusBarText("PokeMini cleared all Memory", 0);
  if (hWnd) {
    OnRedrawAll();
  }
}

// Add a string after Null-Termination into a Dirty implementation
char *strcat2(char *strDestination, const char *strSource)
{
  int i;
  for (i=0; i<256; i++) {
    if ((strDestination[i] == 0x00) && (strDestination[i + 1] == 0x00)) break;
  }
  int a = i + 1;
  int b = strlen(strSource);
  for (i=a; i<a + b; i++) {
    strDestination[i] = strSource[i - a];
  }
  return strDestination; 
}

HWND hMainWnd ;

// Open & Read .MIN File
void OpenMinFileX(char *filename)
{
  int handle, i, bioshand;
  char tmpstr[256];
  if ((handle = open(filename, O_RDONLY | O_BINARY)) == -1)
  {
    sprintf(StatusText,"Failed to load file: %s", filename);
    //MessageBox(hMainWnd, "Error Opening File", "Error", 0);
    return;
  }
  NewMinFile(hMainWnd);
  read(handle, MINData, 0x100000);
  close(handle);
  for (i=0x1000; i<0x2000; i++) MINData[i] = 0x00;
  for (i=0; i<256; i++) MINData[0x2000 + i] = DefaultRegIO[i];

  memcpy( MINData, pokeminibios, 0x1000 ) ;
#if 0
  sprintf(tmpstr, "%s\\BIOS.MIN", ApplicationPath);
  if ((bioshand = open(tmpstr, _O_BINARY | O_RDONLY)) != -1) {
    read(bioshand, &MINData, 0x1000);
    close(bioshand);
  }
#endif
  OnRedrawAll();
  sprintf(tmpstr, "File Loaded: %s", filename);
  SetStatusBarText(tmpstr, 0);
}

// Open a .MIN file...
void OpenMinFile(HWND hWnd, bool Execute)
{
#if 0
  char TotalFileName[256];
  char FileNameAlone[256];
  char StrsFilters[256];
  StopEmu();
  ZeroMemory(&StrsFilters, sizeof(StrsFilters));
  strcpy(StrsFilters, "MIN File (*.MIN)");
  strcat2(StrsFilters, "*.MIN");
  strcat2(StrsFilters, "All Files (*.*)");
  strcat2(StrsFilters, "*.*");
  OPENFILENAME myopenfile;
  ZeroMemory(&myopenfile, sizeof(myopenfile));
  ZeroMemory(&TotalFileName, 256);
  ZeroMemory(&FileNameAlone, 256);
  myopenfile.lStructSize = sizeof(myopenfile);
  myopenfile.hwndOwner = hWnd;
  myopenfile.hInstance = hInst;
  myopenfile.lpstrFilter = StrsFilters;
  myopenfile.lpstrCustomFilter = NULL;
  myopenfile.nMaxCustFilter = 0;
  myopenfile.nFilterIndex = 1;
  myopenfile.lpstrFile = TotalFileName;
  myopenfile.nMaxFile = 256;
  myopenfile.lpstrFileTitle = FileNameAlone;
  myopenfile.nMaxFileTitle = 256;
  myopenfile.lpstrInitialDir = NULL;
  myopenfile.lpstrTitle = "Open .MIN";
  myopenfile.Flags = OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
  myopenfile.nFileOffset = NULL;
  myopenfile.nFileExtension = NULL;
  myopenfile.lpstrDefExt = "MIN";
  myopenfile.lCustData = NULL;
  myopenfile.lpfnHook = NULL;
  myopenfile.lpTemplateName = NULL; 
  if (GetOpenFileName(&myopenfile)) {
    OpenMinFileX(TotalFileName);
    if (Execute) SetTimer(NULL, 0, 250, StartUpRunFullTh);
  }
#endif
}

// Capture the screen
void CaptureScreen(HWND hWnd)
{
#if 0
  int x, y, handle;
  unsigned long ScreenContent[96 * 64];
  char TotalFileName[256];
  char FileNameAlone[256];
  char StrsFilters[256];
  BITMAPINFOHEADER bih;
	BITMAPFILEHEADER bfh;
  unsigned long rgba;
  for (y=0; y<64; y++) {
    for (x=0; x<96; x++) {
      ScreenContent[(y * 96) + x] = ScreenView_VideoBuffer[((63-y) * 96) + x];
    }
  }
  ZeroMemory(&StrsFilters, sizeof(StrsFilters));
  strcpy(StrsFilters, "Bitmap File (*.BMP)");
  strcat2(StrsFilters, "*.BMP");
  OPENFILENAME myopenfile;
  ZeroMemory(&myopenfile, sizeof(myopenfile));
  ZeroMemory(&TotalFileName, 256);
  ZeroMemory(&FileNameAlone, 256);
  myopenfile.lStructSize = sizeof(myopenfile);
  myopenfile.hwndOwner = hWnd;
  myopenfile.hInstance = hInst;
  myopenfile.lpstrFilter = StrsFilters;
  myopenfile.lpstrCustomFilter = NULL;
  myopenfile.nMaxCustFilter = 0;
  myopenfile.nFilterIndex = 1;
  myopenfile.lpstrFile = TotalFileName;
  myopenfile.nMaxFile = 256;
  myopenfile.lpstrFileTitle = FileNameAlone;
  myopenfile.nMaxFileTitle = 256;
  myopenfile.lpstrInitialDir = NULL;
  myopenfile.lpstrTitle = "Save Screen Capture";
  myopenfile.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
  myopenfile.nFileOffset = NULL;
  myopenfile.nFileExtension = NULL;
  myopenfile.lpstrDefExt = "MIN";
  myopenfile.lCustData = NULL;
  myopenfile.lpfnHook = NULL;
  myopenfile.lpTemplateName = NULL;
  if (GetSaveFileName(&myopenfile)) {
    if ((handle = open(TotalFileName, O_WRONLY | O_BINARY | O_TRUNC | O_CREAT, S_IREAD | S_IWRITE)) == -1)
    {
      sprintf(StatusText,"Failed to save screen-capture: %s", TotalFileName);
      SetStatusBarText(StatusText, 0);
      MessageBox(hWnd, "Error Saving File", "Error", 0);
      return;
    }
    bfh.bfType = ('M' << 8) | 'B';
    bfh.bfReserved1 = 0;
    bfh.bfReserved2 = 0;
    bfh.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof (BITMAPINFOHEADER);
    bfh.bfSize = sizeof(BITMAPFILEHEADER) + sizeof (BITMAPINFOHEADER) + 18432;
	  write(handle, &bfh, sizeof(BITMAPFILEHEADER));
    bih.biSize = sizeof(BITMAPINFOHEADER);
    bih.biWidth = 96;
    bih.biHeight = 64;
    bih.biPlanes = 1;
    bih.biBitCount = 24;
    bih.biCompression = BI_RGB;
    bih.biSizeImage = 0;
    bih.biXPelsPerMeter = 92;
    bih.biYPelsPerMeter = 92;
    bih.biClrUsed = 0;
    bih.biClrImportant = 0;
	  write(handle, &bih, sizeof(BITMAPINFOHEADER));
    for (y=0; y<64; y++) {
      for (x=0; x<96; x++) {
        rgba = ScreenContent[(y * 96) + x];
        write(handle, &rgba, 1);
        rgba = rgba >> 8;
        write(handle, &rgba, 1);
        rgba = rgba >> 8;
        write(handle, &rgba, 1);
      }
    }
    close(handle);
    sprintf(StatusText, "Screen-Capture Saved...");
    SetStatusBarText(StatusText, 0);
  }
#endif
}

// Windows Start Point
int pokemain(char *filename, int usebios )
{
  int i, NumArgs;
//  MSG msg;
//  HACCEL hAccelTable;
#if 0
  // Create Main Window
  PokeDebugRegisterClasses(hInstance);

  // Get argc/argv paramters
  LPWSTR *pathnam;
  pathnam = CommandLineToArgvW(GetCommandLineW(), &NumArgs);
  W_Argc = NumArgs;
  W_Argv = new char *[W_Argc];
  for (i=0; i<NumArgs; i++) {
    W_Argv[i] = new char [wcslen(pathnam[i])];
    wcstombs(W_Argv[i], pathnam[i], 256);
  }
  GlobalFree(pathnam);

  // Get application path
  strcpy(ApplicationPath, W_Argv[0]); 
  for (i=strlen(ApplicationPath); i>=0; i--) {
    if (ApplicationPath[i] == '\\') {
      ApplicationPath[i] = 0;
      break;
    }
  }
#endif
  // Reset Pokmon-Mini memory & stuff
  NewMinFile(NULL);

  // Perform application initialization:
  if (!InitInstance(0, 0)) return FALSE;
 
  // Read Accelerator
  //hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_POKEKAMINI);

  // Inform that application as been started
  //SetStatusBarText("PokeMini application started", 0);
#if 0
  // Open & Execute
  if (W_Argc > 1) {
    OpenMinFileX(W_Argv[1]);
  }
  if (W_Argc > 2) {
    char tmpstrx[256];
    strcpy(tmpstrx, W_Argv[2]);
    strupr(tmpstrx);
    if (strcmp(tmpstrx, "RUN") == 0) {
      SetTimer(NULL, 0, 1000, StartUpRunFullTh);
    }
    if (strcmp(tmpstrx, "FULL") == 0) {
      SetTimer(NULL, 0, 1000, StartUpRunFullTh);
    }
  }
#endif
	OpenMinFileX(filename);
	FullSpeedEmulationTh( 0 ) ;
	//StartUpRunFullTh( 0, 0, 0, 0 ) ;
  return 0 ;
}

// Register Main Window Class
void PokeDebugRegisterClasses(HINSTANCE hInstance)
{
#if 0
  WNDCLASSEX wcex;

  // Register Main Window Class
  wcex.cbSize = sizeof(WNDCLASSEX); 
  wcex.style          = 0;
  wcex.lpfnWndProc    = (WNDPROC)WndProc;
  wcex.cbClsExtra     = 0;
  wcex.cbWndExtra     = 0;
  wcex.hInstance      = hInstance;
  wcex.hIcon          = LoadIcon(hInstance, (LPCTSTR)IDI_POKEKAMINI);
  wcex.hCursor        = LoadCursor(NULL, IDC_ARROW);
  wcex.hbrBackground  = (HBRUSH)(COLOR_BTNFACE+1);
  wcex.lpszMenuName   = (LPCSTR)IDC_POKEKAMINI;
  wcex.lpszClassName  = "POKEMINI";
  wcex.hIconSm        = LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
  RegisterClassEx(&wcex);
#endif
}

char PreStatusText[2][256];  // Prevent flicker over repeated messages

// Set StatusBar Text
void SetStatusBarText(char *text, int part)
{
  //if (strcmp(PreStatusText[part], text) != 0) {
//    strcpy(PreStatusText[part], text);
    //SendMessage(hStatusbar, SB_SETTEXT, (WPARAM)part, (LPARAM)(LPSTR)text);
  //}
}

// Set Rumble Animation
void SetRumbleAnim(bool rumbleactivated)
{
  if (rumbleactivated) {
    //SetStatusBarText("R!", 1);
  } else {
    //SetStatusBarText("", 1);
  }
}

// Resize Client Area
void MainWndSize(HWND hWnd, int Width, int Height)
{
#if 0
  rMainWnd.left = 0;
  rMainWnd.top = 0;
  rMainWnd.right = Width;
  rMainWnd.bottom = Height + rStatusbar.bottom;

  AdjustWindowRect(&rMainWnd, WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_SIZEBOX, true);

  Width = -rMainWnd.left + rMainWnd.right;
  Height = -rMainWnd.top + rMainWnd.bottom;

  SystemParametersInfo(SPI_GETWORKAREA, 0, (PVOID)&rMainWnd, 0);
   
  rMainWnd.left = (rMainWnd.right - Width) / 2;
  rMainWnd.top = (rMainWnd.bottom - Height) / 2;
  rMainWnd.right = Width;
  rMainWnd.bottom = Height;

  if (hWnd != NULL) {
    SetWindowPos(hWnd, NULL, 0, 0, rMainWnd.right, rMainWnd.bottom, SWP_NOMOVE | SWP_NOOWNERZORDER);
    GetClientRect(hMainWnd, &rMainWnd);
    OnResize(rMainWnd.right, rMainWnd.bottom);
  }
#endif
}

// Init Instance
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
  char szTitle[100];

  if (ScreenView_Init() == false) { 
    MessageBox(0, "Error init Screen_View()", "Error", 0);
    return false;
  }
#if 0
  rStatusbar.left = 0;
  rStatusbar.top = 0;
  rStatusbar.right = 192;
  rStatusbar.bottom = 23;
  MainWndSize(NULL, 288, 192);
  hInst = hInstance; // Store instance handle in our global variable

  sprintf(szTitle, "PokeMini %s", Version);
  hMainWnd = CreateWindow("POKEMINI", szTitle, WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_SIZEBOX | WS_MINIMIZEBOX | WS_MAXIMIZEBOX, rMainWnd.left, rMainWnd.top, rMainWnd.right, rMainWnd.bottom, NULL, NULL, hInstance, NULL);

  if (!hMainWnd) return FALSE;

  hMainMenu = GetMenu(hMainWnd);
  if (!hMainWnd) return FALSE;

  ShowWindow(hMainWnd, nCmdShow);
  UpdateWindow(hMainWnd);
#endif

  if (StartUpDirectX(hMainWnd) == false) {
    MessageBox(0, "Cannot init DirectSound", "Error", 0);
    return false;
  }
#if 0
  // Create and configure a Status Bar
  hStatusbar = CreateStatusWindow(WS_CHILD | WS_BORDER | WS_VISIBLE, NULL, hMainWnd, IDC_STATUSBAR);
  if (hStatusbar == NULL) return FALSE;
  GetClientRect(hStatusbar, &rStatusbar);
  MainWndSize(hMainWnd, 288, 192);

  // Start Timer to count FPS
  FPSHandle = SetTimer(NULL, 0, 1000, FPSTimerTh);
#endif
  return TRUE;
}

// Destroy Instance
void PokeMiniDestroy()
{
  StopEmu();
  ApplicationTerminate = true;
  WaitForSingleObject(DSoundHandle, INFINITE);
  ScreenView_Destroy();
  EndUpDirectX();
  //DestroyMenu(hMainMenu);
  //KillTimer(NULL, FPSHandle);
}

// Main Window callcacks
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#if 0
  int x, y;
  int wmId, wmEvent;
  char about_txt[256];

  switch (message) {
    case WM_COMMAND:
      wmId    = LOWORD(wParam); 
      wmEvent = HIWORD(wParam); 
      switch (wmId) {
        case IDM_FILE_NEWMIN:
          NewMinFile(hWnd);
          break;
        case IDM_FILE_OPENMIN:
          OpenMinFile(hWnd, true);
          break;
        case IDM_FILE_OPENMINONLY:
          OpenMinFile(hWnd, false);
          break;
        case IDM_CAPTURESCREEN:
          CaptureScreen(hWnd);
          break;
        case IDM_DEBUGGER_STOPEMULATION:
          StopEmu();
          break;
        case IDM_DEBUGGER_FULLSPEEDRUN:
          DoFullSpeedEmu();
          break;
        case IDM_DEBUGGER_RESET:
          ResetEmu();
          break;
        case IDM_OPTIONS_COLORSPALETTE_1:
          RegDisplayColor = 0;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_2:
          RegDisplayColor = 1;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_3:
          RegDisplayColor = 2;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_4:
          RegDisplayColor = 3;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_5:
          RegDisplayColor = 4;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_6:
          RegDisplayColor = 5;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_7:
          RegDisplayColor = 6;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_OPTIONS_COLORSPALETTE_8:
          RegDisplayColor = 7;
          if (!FullSpeedEmu) {
            for (y=0; y<64; y++) {
              for (x=0; x<96; x++) {
                ScreenView_VideoBuffer[(y * 96) + x] = COLOR16(GreyEmulation(ScreenArea, x, y, 0));
              }
            }
          }
          OnRedrawAll();
          break;
        case IDM_VIEWERS_TOGGLEGREYEMULATION:
          DoGreyEmu = !DoGreyEmu;
          if (DoGreyEmu) {
            SetStatusBarText("Grey-Emulation Enabled", 0);
          } else {
            SetStatusBarText("Grey-Emulation Disabled", 0);
          }
          OnRedrawAll();          
          break;
        case IDM_OPTIONS_WINDOWSIZE_1X:
          MainWndSize(hWnd, 192-5, 128-5);
          break;
        case IDM_OPTIONS_WINDOWSIZE_2X:
          MainWndSize(hWnd, 96 * 2, 64 * 2);
          break;
        case IDM_OPTIONS_WINDOWSIZE_3X:
          MainWndSize(hWnd, 96 * 3, 64 * 3);
          break;
        case IDM_OPTIONS_WINDOWSIZE_4X:
          MainWndSize(hWnd, 96 * 4, 64 * 4);
          break;
        case IDM_OPTIONS_WINDOWSIZE_6X:
          MainWndSize(hWnd, 96 * 6, 64 * 6);
          break;
        case IDM_OPTIONS_WINDOWSIZE_8X:
          MainWndSize(hWnd, 96 * 8, 64 * 8);
          break;
        case IDM_OPTIONS_ENABLEDISABLESOUND:
          EnableSoundOut = !EnableSoundOut;
          if (EnableSoundOut) {
            SetStatusBarText("Sound Output Enabled", 0);
          } else {
            SetStatusBarText("Sound Output Disabled", 0);
          }
          break;
        case IDM_HELP_ABOUT:
          MSGBOXPARAMS MsgBox;
          strcpy(about_txt, "TEAM POKEME PRESENTS:\n");
          sprintf(about_txt, "PokeMini Homebrew-Emulator %s\n", Version);
          strcat(about_txt, "Coded by JustBurn\n");
          strcat(about_txt, "Special Thank's to p0p, Dave|X, Onori\n");
          strcat(about_txt, "goldmomo, asterick and everyone else\n");
          strcat(about_txt, "Visit us at http://pokeme.shizzle.it\n");
          strcat(about_txt, "And my website at http://jb.shizzle.it");
          MsgBox.cbSize = sizeof(MSGBOXPARAMS);
          MsgBox.hwndOwner = hWnd;
          MsgBox.hInstance = hInst;
          MsgBox.lpszText = about_txt;
          MsgBox.lpszCaption = "About";
          MsgBox.dwStyle = MB_USERICON;
          MsgBox.lpszIcon = (LPCTSTR)IDI_POKEKAMINI;
          MsgBox.dwContextHelpId = 0;
          MsgBox.lpfnMsgBoxCallback = NULL;
          MsgBox.dwLanguageId = LANG_ENGLISH;
          MessageBoxIndirect(&MsgBox);
          break;
        case IDM_FILE_EXIT:
          DestroyWindow(hWnd);
          break;
        default:
          return DefWindowProc(hWnd, message, wParam, lParam);
			}
      break;   
    case WM_KEYUP:
      OnKeyUpEvent(wParam);
      break;
    case WM_KEYDOWN:
      OnKeyDownEvent(wParam);
      break;
    case WM_PAINT:
      OnWindowPaint(hWnd);
      break;
    case WM_SIZE:
      OnResize(LOWORD(lParam), HIWORD(lParam));
      break;
    case WM_SIZING:
      OnSizing(wParam, (RECT *)lParam);
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    default:
      return DefWindowProc(hWnd, message, wParam, lParam);
  }
#endif
  return 0;
}
