// Minimon Copyright (c) 2004-2005 by Robert Bryon Vandiver
//
// This is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
// 

#ifndef __MINIBUS_H
#define __MINIBUS_H

#define CPU_FREQ			4000000
#define FRAME_RATE			40
#define FRAME_CYCLES		(CPU_FREQ / FRAME_RATE)
#define FRAME_DRAW_TIME		(FRAME_CYCLES / 16)
#define FRAME_TICKS			(1000 / FRAME_RATE)

#define SAMPLE_RATE			40000		// 1/100th the CPU clock speed
#define CLOCKS_PER_SAMPLE	(CPU_FREQ/SAMPLE_RATE)

enum
{
	PAD_A = 0x01,
	PAD_B = 0x02,
	PAD_C = 0x04,
	PAD_UP = 0x08,
	PAD_DOWN = 0x10,
	PAD_LEFT = 0x20,
	PAD_RIGHT = 0x40,
	PAD_POWER = 0x80,
	PAD_SHAKE = 0x100,
	PAD_THROTTLE = 0x200
};


const static long m_ScalarTicks[8] = {
	15, 
	14,
	11,
	10,
	9,
	8,
	6,
	4
};

const static long m_ScalarTicksSound[8] = {
	15+1, 
	14+1,
	11+1,
	10+1,
	9+1,
	8+1,
	6+1,
	4+1
};

const static long m_ScalarMultiplier[8] = {	
	1-1, 
	3-1, 
	5-1, 
	6-1, 
	7-1, 
	8-1, 
	10-1, 
	12-1
};


/*
const static long m_ScalarMultiplier[8] = {	
	1, 
	3, 
	5, 
	6, 
	7, 
	8, 
	10, 
	12
};*/

class Mini : public MinxCore
{
public:
	Mini::Mini();
	Mini::~Mini();

	void Mini::SetConsole( HWND errorConsole );
	void Mini::Error( const char *error, int errc, int *errv );

	void Mini::LoadRom( const char *filename );
	void Mini::VPURender();
	void Mini::UpdateFrame();
	void Mini::PeekReg( unsigned char reg, unsigned char &value );
	void Mini::PokeReg( unsigned char reg, unsigned char value );
	void Mini::LogBranch( long addr );
	void Mini::EmulateGray( bool emulate );
	
	void Mini::SetTime( int seconds );
	void Mini::Shake();
	void Mini::PressPad( unsigned char buttons );
	void Mini::ReleasePad( unsigned char buttons );

	void Mini::Stream( char* buffer, int length );

	int Mini::PredictIRQ( int maxCycles );
	void Mini::Clock( int cycles );
	void Mini::DoIRQs();
	void Mini::FireIRQ( long bit );
	
	unsigned char *Mini::SafePointer( long addr );
	unsigned char Mini::SafeRead( long addr, bool paged  );
	void Mini::DebugWrite( long addr, unsigned char data, bool paged );
public:
	// Storage for hardware registers
	unsigned char m_HardReg[0x100];
	unsigned long m_RegAccessMeter[0x100];
	EEPROM m_EEPROM;

	unsigned char m_AudioBuffer[0x4000];	// 4k buffer
	unsigned long m_AudClock;
	unsigned long m_AudReadCursor;
	unsigned long m_AudWriteCursor;
	unsigned long m_core ;

	// Timers
	long m_LCDClock;
	unsigned long m_Timer0Clock;
	unsigned long m_Timer1Clock;
	unsigned long m_Timer2Clock;	

	// IRQ stuff
	long m_IRQFire;

	// Base addresses for tile memory
	int m_TileBase;
	int m_SpriteBase;

	int m_FractSecondCount;
	int m_SecondCount;

	// Audio Settings
	int m_StreamSample;
	int m_Volume;

	// Tile map modifiers
	int m_MapWidth, m_MapHeight;
	int m_MapX, m_MapY;

	// Video settings
	bool m_LCDInverted;
	bool m_LCDEnable1;
	bool m_LCDEnable2;
	bool m_MAPActive;
	bool m_SPRActive;
	bool m_Rumble;
	bool m_GrayEmulation;
	unsigned char m_Contrast;
	unsigned char m_IOCommand;

	// Stuff used for rendering
	unsigned char m_FrameBuffer[64][96];
	unsigned char m_Frame[96*8];
	unsigned char m_PrevFrame[96*8];	

	// Stuff used for debugging
	long m_LastBranch;

	HWND m_ErrorConsole;
};

#ifdef EXPORT

unsigned char RegReadMask[0x100] = {
//   00    01    02    03    04    05    06    07    08    09    0A    0B    0C    0D    0E    0F
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 00
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 10
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 20
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 30
	0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 40
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 50
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 60
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 70
	0x3F, 0xFF, 0xFC, 0xFF, 0x1F, 0x7F, 0x7F, 0xC0, 0xFF, 0x1F, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 80
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 90
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // A0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // B0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // C0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // D0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // E0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // F0
	};
unsigned char RegWriteMask[0x100] = {
//   00    01    02    03    04    05    06    07    08    09    0A    0B    0C    0D    0E    0F
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, // 00
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 10
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 20
	0x85, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x85, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, // 30
	0x01, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, // 40
	0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 50
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 60
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 70
	0x3F, 0x0F, 0xFC, 0xFF, 0x1F, 0x7F, 0x7F, 0xC0, 0xFF, 0x1F, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 80
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 90
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // A0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // B0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // C0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // D0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // E0
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // F0
	};
unsigned char RegOrMask[0x100] = {
//   00    01    02    03    04    05    06    07    08    09    0A    0B    0C    0D    0E    0F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 00
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 10
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 20
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 30
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 40
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // A0
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // B0
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // C0
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // D0
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // E0
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // F0
	};
#else

extern unsigned char RegReadMask[0x100];
extern unsigned char RegWriteMask[0x100];
extern unsigned char RegOrMask[0x100];

#endif

#endif