/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __CONFIGURATION_H
#define __CONFIGURATION_H

enum
{
	NOT_FOUND,
	NO_VARIABLE,
	VALUE_NUMBER,
	VALUE_TEXT,
	FORMAT_HEX,
	FORMAT_DECIMAL,
	FORMAT_NOQUOTE,
	FORMAT_SINGLEQUOTE,
	FORMAT_DOUBLEQUOTE
};

struct Property
{
	char *m_Name;	
	char *m_Text;
	int m_Value;
	int m_Format;
};

struct XMLNode
{
	char *m_Name;

	int m_Properties;
	Property *m_Prop;

	XMLNode *m_Parent;
	XMLNode *m_Next;
	XMLNode *m_Child;
};

class Configuration
{
public:
	Configuration::Configuration();
	Configuration::~Configuration();

	bool Configuration::Seek( char *address );
	bool Configuration::Create( char *address );
	int Configuration::Read( char *var, int &val, char *text );
	int Configuration::Write( char *var, int val );
	int Configuration::Write( char *var, char *text );

	void Configuration::WriteConfig();
	void Configuration::ReadConfig();
private:
	void Configuration::DeleteNode( XMLNode *node );
	bool Configuration::CreateNode( XMLNode **node, char *proto );
	void Configuration::Preformat( char *proto );
	void DumpNode( HANDLE fo, XMLNode *node, int tabs = 0 );

	char *m_SeekName;
	XMLNode *m_SeekNode;

	XMLNode *m_Root;

	HANDLE m_Cfg;
};

#endif