/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "Minimon.h"

int doaudio = 0 ;

DWORD WINAPI StreamThread( LPVOID lpParameter )
{
	DWORD playpos, writepos, dist, dummy ;
	AudioDriver *ad = (AudioDriver*) lpParameter;

	DWORD dwResult;

	writepos = 0xFFFFFFFF ;

	doaudio = 1 ;
	while( doaudio )
	{
		//dwResult = WaitForSingleObject( ad->m_EventHandle, INFINITE ) ;
		//dwResult = MsgWaitForMultipleObjects( 1, &ad->m_EventHandle, FALSE, INFINITE, QS_POSTMESSAGE );

		//if( dwResult == WAIT_OBJECT_0 )
		{
			Sleep(1) ;
			ad->m_Primary->GetCurrentPosition( NULL, &playpos ) ;

			if ( writepos == 0xFFFFFFFF )
			{
				writepos = (playpos+150)%ad->m_BufferSize  ;
			}

			if ( writepos > playpos )
			{
				dist = writepos - playpos ;
			}
			else
			{
				dist = ( ad->m_BufferSize - playpos ) + writepos ;
			}

			if ( dist < 200 )
			{
				ad->Stream( writepos, 250 );
				writepos = (writepos+250)%ad->m_BufferSize ;
			}
		}
	}

	doaudio = 2 ;
	return 0;
}

void AudioDriver::CheckStream(  )
{
	DWORD playpos, dist, dummy ;
	DWORD dwResult;

	m_Primary->GetCurrentPosition( NULL, &playpos ) ;

	if ( m_writepos == 0xFFFFFFFF )
	{
		m_writepos = (playpos+200)%m_BufferSize ;
	}
	else
	{
		if ( m_writepos > playpos )
		{
			dist = m_writepos - playpos ;
		}
		else
		{
			dist = ( m_BufferSize - playpos ) + m_writepos ;
		}

		if ( dist > 1500 )
		{
			m_writepos = (playpos+200)%m_BufferSize ;
		}
	}

	Stream( m_writepos, 1000 );
	m_writepos = (m_writepos+1000)%m_BufferSize ;

}

AudioDriver::AudioDriver( HWND hWnd, Mini *mini )
{
	m_hWnd = hWnd;

	m_Enabled = false;
	m_SampleRate = SAMPLE_RATE;
	m_BufferSize = AUDIO_BUFFER_SIZE;
	m_writepos = 0xFFFFFFFF ;

	if( mini == NULL )
	{
		return ;
	}

	m_Mini = mini;

	if( DirectSoundCreate(NULL,&lpDS,NULL) != DS_OK )
	{
		lpDS = NULL;
		return ;
	}

	//if ( lpDS->SetCooperativeLevel(m_hWnd, DSSCL_EXCLUSIVE) != DS_OK )
	//{
		//lpDS->Release();
		//lpDS = NULL;
		//return ;
	//}

    WAVEFORMATEX wfx;
    ZeroMemory( &wfx, sizeof(WAVEFORMATEX) ); 
    wfx.wFormatTag      = (WORD) WAVE_FORMAT_PCM; 
    wfx.nChannels       = (WORD) 1;
    wfx.nSamplesPerSec  = (DWORD) m_SampleRate;
    wfx.wBitsPerSample  = (WORD) 8; 
    wfx.nBlockAlign     = (WORD) (wfx.wBitsPerSample / 8 * wfx.nChannels);
    wfx.nAvgBytesPerSec = (DWORD) (wfx.nSamplesPerSec * wfx.nBlockAlign);

	DSBUFFERDESC dsbd;
	ZeroMemory( &dsbd, sizeof( DSBUFFERDESC ) );
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = 0 ; //DSBCAPS_CTRLPOSITIONNOTIFY  ; //DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_CTRLPOSITIONNOTIFY ;
	dsbd.dwBufferBytes = m_BufferSize;
	dsbd.lpwfxFormat = &wfx;

	if( lpDS->CreateSoundBuffer( &dsbd, &m_Primary, NULL ) != DS_OK )
	{
		//MessageBox( hWnd, "Failed to initalize audio", g_AppTitle, MB_OK );
		lpDS->Release();
		lpDS = NULL;
		return ;
	}
#if 0
	if( m_Primary->QueryInterface( IID_IDirectSoundNotify, (VOID**)&lpDSN ) != DS_OK )
	{
		MessageBox( hWnd, "Failed to create notification interface", g_AppTitle, MB_OK );
		m_Primary->Release();
		lpDS->Release();
		lpDS = NULL;
		return;
	}
#endif
	//m_EventHandle = CreateEvent( NULL, FALSE, FALSE, NULL );

	char *bt1;
	long bc1;
	if ( m_Primary->Lock( 0, m_BufferSize,
		(LPVOID*)&bt1, (LPDWORD)&bc1,
		NULL, NULL,
		0 ) == DS_OK )
	{
		memset( bt1, 0, bc1 ) ;
		//m_Mini->Stream( bt1, bc1 );

		m_Primary->Unlock((LPVOID)bt1, bc1, NULL, 0);
	}


	for( int i = 0; i < AUDIO_NOTIFIES; i++ )
	{
		dsPos[i].dwOffset = AUDIO_CLIP_SIZE * i + AUDIO_NOTIFY_OFFSET;
		//dsPos[i].hEventNotify = m_EventHandle;
	}

	//if( m_Primary->SetNotificationPositions( AUDIO_NOTIFIES, dsPos ) != DS_OK )
	if ( 0 )
	{
		//MessageBox( hWnd, "Failed to create notification interface", g_AppTitle, MB_OK );

		//CloseHandle( m_EventHandle );
		//lpDSN->Release();
		m_Primary->Release();
		lpDS->Release();

		lpDSN = NULL;
		m_Primary = NULL;
		lpDS = NULL;
		return;
	}	

	//m_NotifyThreadHandle = CreateThread( NULL, 0, StreamThread, this, 0, &m_NotifyThreadID );
}

AudioDriver::~AudioDriver()
{
	doaudio = 0 ;

	Sleep( 250 ) ;
	//while ( doaudio == 0 )
		//;

	doaudio = 0 ;

	//KillThread( m_NotifyThreadHandle, 0 );

	if( lpDS != NULL )
	{		
		//CloseHandle( m_EventHandle );
		//lpDSN->Release();
		m_Primary->Release();
		lpDS->Release();
	}
}

void AudioDriver::Enable( bool enable )
{
	if( m_Primary == NULL )
	{
		return ;
	}

	if( enable )
	{
		m_Primary->Play( 0, 0, DSBPLAY_LOOPING );
	}
	else
	{
		m_Primary->Stop();
	}
}

unsigned char sbuf[2000] ;
void AudioDriver::Stream( DWORD wpos, DWORD len)
{	
	char *bt1=NULL;
	long bc1=0;
	char *bt2=NULL;
	long bc2=0;
	
	int play;

	if( m_Primary == NULL )
	{
		return ;
	}

	//m_Primary->GetCurrentPosition( (DWORD*)&play, NULL );

	//play = (play + AUDIO_BUFFER_INDEX) & AUDIO_BUFFER_INDEX;

	//if ( m_Primary->Lock( wpos, AUDIO_CLIP_SIZE,
	if ( m_Primary->Lock( wpos, len,
		(LPVOID*)&bt1, (LPDWORD)&bc1,
		(LPVOID*)&bt2, (LPDWORD)&bc2,
		0 ) == DS_OK )
	{
		m_Mini->Stream( (char*)sbuf, len ) ;

		memcpy( bt1, sbuf, bc1 ) ;
		if ( bt2 )
			memcpy( bt2, sbuf+bc1, bc2 ) ;

		m_Primary->Unlock((LPVOID)bt1, bc1, bt2, bc2);
	}
}
