/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define DIRECTINPUT_VERSION 0x0800
#define DIRECTSOUND_VERSION 0x0800
#define _USE_MATH_DEFINES

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <ddraw.h>
#include <dinput.h>
#include <dsound.h>
#include <math.h>
#include <time.h>

#include "resource.h"

#ifndef __MINIMON_H
#define __MINIMON_H

#define MINIMON_VERSION		0x05011900

#ifdef EXPORT
const char *g_AppTitle = "Minimon Debugger 2005:01:19";
HINSTANCE g_hInstance;
#else
extern const char *g_AppTitle;
extern HINSTANCE g_hInstance;
#endif

#define WM_REFRESH			WM_USER
#define WM_POINTER			(WM_USER+1)
#define WM_INPUTPRESS		(WM_USER+2)
#define WM_INPUTRELEASE		(WM_USER+3)
#define WM_COLOR			(WM_USER+4)
#define WM_GRADIENT			(WM_USER+5)
#define WM_UPDATE_PALETTE	(WM_USER+6)
#define WM_INPUTHIT			(WM_USER+7)
#define WM_CONFIG			(WM_USER+8)
#define WM_VALUE			(WM_USER+9)
#define WM_SET_VIDEO_FILTER	(WM_USER+11)
#define WM_GET_VIDEO_FILTER	(WM_USER+12)
#define WM_GUI_MODE_CHANGE	(WM_USER+13)

enum TileViewModes
{
	TILE_TILES,
	TILE_MAP,
	TILE_SPRITES,
	TILE_OAM,
	TILE_REGACCESS,
	TILE_VIEW_MODES
};

enum DisasmViewModes
{
	DASM_USER,
	DASM_PC,
	DASM_SPLIT
};

enum SymbolProcModes
{
	SYMPROC_SYMBOL    = 0x01,
	SYMPROC_WATCH     = 0x02,
	SYMPROC_BREAK     = 0x03,
	SYMPROC_NO_VAL    = 0x00,
	SYMPROC_DATASIZE  = 0x10
};

union LongColor
{
	long RGB;
	struct 
	{
		unsigned char B;
		unsigned char G;
		unsigned char R;
	} color;
};

struct ColorSet
{
	HBRUSH m_brMnemonic;
	HBRUSH m_brComment;
	HBRUSH m_brLable;

	HBRUSH m_brSymbol;
	HBRUSH m_brRegister;
	HBRUSH m_brOperator;
	HBRUSH m_brText;
	HBRUSH m_brLiteral;
	
	HBRUSH m_brRead;
	HBRUSH m_brWrite;

	HBRUSH m_brClear;
};

#include "autoupdater.h"
#include "configuration.h"
#include "cpucore.h"
#include "eeprom.h"
#include "CpuCore.h"
#include "MiniBus.h"
#include "Audio.h"
#include "Executor.h"
#include "InputHandler.h"
#include "Disassembly.h"

enum
{
	FILTER_NONE,
	FILTER_DOTMASK,
	FILTER_HQ2X,
	FILTER_HQ3X,
	FILTER_HQ4X,
	FILTER_INTERLEAVE,
	FILTER_COUNT,
};

struct LCDViewData
{
	Mini *m_Emulator;
	Configuration *m_Cfg;

	LPDIRECTDRAW7			lpDD;
	LPDIRECTDRAWSURFACE7	lpDDSPrimary;
	LPDIRECTDRAWSURFACE7	lpDDSBack;
	LPDIRECTDRAWCLIPPER		lpClipper;
	DDSCAPS2				ddscaps;
	DDPIXELFORMAT			ddpf;		

	int						m_VideoFilter;

	long					*m_32bppColors;
	short					*m_16bppColors;
	LongColor				m_Palette[256];
};

struct EmuWindowData
{
	HWND m_LCD;
	HWND m_Memory;
	HWND m_Disassembly;
	HWND m_CpuStat;
	HWND m_CodePoints;
	HWND m_TileViewer;
	HWND m_ErrorConsole;

	Mini *m_Emulator;
	Executor *m_Executor;

	ColorSet m_Colors;
	HBITMAP m_Font;

	InputHandle *m_Input;
	Configuration *m_Cfg;
	AudioDriver *m_Audio;

	int  m_DataSize;

	int m_MemoryAddress;
	int m_WatchIndex;

	int m_TileViewMode;
	int m_SpriteSelected;

	char m_RomFile[1024];
	char m_SymFile[1024];

	bool m_EnableDebugger;
	bool m_EnableAudio;
	bool m_Active;
	bool m_Rumble;
	bool m_Throttle;

	RECT m_DebugSize;
	RECT m_LCDSize;

	struct {
		BITMAPINFOHEADER bmiHeader; 
		long             bmiColors[8];
	} m_TileBitmapInfo;	
};

void DrawLine( HDC dest, HDC font, HBRUSH brush, long &x, int y, char *data );
LRESULT CALLBACK LCDViewerProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
LRESULT CALLBACK TileViewerProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
LRESULT CALLBACK ErrorProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ValueProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK SymbolProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK AddSymProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK CpuStatProc( HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam );

#endif
