/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __INPUTHANDLER_H
#define __INPUTHANDLER_H

BOOL CALLBACK InputHandleEnum( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef );
BOOL CALLBACK InputRumbleEnum( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef );

struct InputMap
{
	char name[64];

	int Device;
	int Button;

	int bind;
	int press;
	int release;
	int lParam;

	InputMap *m_Next;
};

struct InputDevice
{
	LPDIRECTINPUTDEVICE8 m_Device;
	GUID m_GUID;
	BYTE m_Buttons[256];
	char m_Name[1024];
	bool m_Rumble;
	InputDevice *m_Next;
};

class InputHandle
{
public:
	InputHandle::InputHandle( HWND hWnd );
	InputHandle::~InputHandle();

	void InputHandle::Process( bool broadcast = true );
	void InputHandle::Configure( Configuration *cfg );
	void InputHandle::Configure();
	void InputHandle::Register( GUID diGUID, char* name );
	void InputHandle::Bind( int address, int device, int button );
	void InputHandle::SetRumble( int device );
	void InputHandle::Rumble( bool enable );
	void InputHandle::CreateRumble();

	HWND m_ConfigWnd;
	bool m_Listen;
	InputMap *m_Map;
	InputDevice *m_Devices;
	int m_RumbleDev;
private:
	LPDIRECTINPUT8 lpDI;
	LPDIRECTINPUTEFFECT lpDIE;
	Configuration *m_Cfg;

	HWND m_hWnd;

	bool m_Active;

	void InputHandle::ReleaseDevice( InputDevice *dev );
	void InputHandle::ReleaseMap( InputMap *map );
};

#endif