// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Pokmon-mini CPU core emulator, v0.6.4 (Debug / Retail)
//
// Coded by JustBurn, 2004

// 00          - ADD A, A
case 0x00:
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 01          - ADD A, B
case 0x01:
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 02 nn       - ADD A, #nn
case 0x02:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 03          - ADD A, [HL]
case 0x03:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 04 nn       - ADD A, [NN + #nn]
case 0x04:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 05 nn nn    - ADD A, [Y + #nnnn]
case 0x05:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadHLOfs16());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// 06          - ADD A, [X1]
case 0x06:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 07          - ADD A, [X2]
case 0x07:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 08          - ADC A, A
case 0x08:
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.BA.B.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 09          - ADC A, B
case 0x09:
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.BA.B.h + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 0A nn       - ADC A, #nn
case 0x0A:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 0B          - ADC A, [HL]
case 0x0B:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 0C nn       - ADC A, [NN + #nn]
case 0x0C:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 0D nn nn    - ADC A, [Y + #nnnn]
case 0x0D:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadHLOfs16());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// 0E          - ADC A, [X1]
case 0x0E:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 0F          - ADC A, [X2]
case 0x0F:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 10          - SUB A, A
case 0x10:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 11          - SUB A, B
case 0x11:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 12 nn       - SUB A, #nn
case 0x12:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 13          - SUB A, [HL]
case 0x13:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 14 nn       - SUB A, [NN + #nn]
case 0x14:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 15 nn nn    - SUB A, [Y + #nnnn]
case 0x15:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadHLOfs16());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// 16          - SUB A, [X1]
case 0x16:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 17          - SUB A, [X2]
case 0x17:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 18          - SBC A, A
case 0x18:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 19          - SBC A, B
case 0x19:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.h - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 1A nn       - SBC A, #nn
case 0x1A:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 1B          - SBC A, [HL]
case 0x1B:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 1C nn       - SBC A, [NN + #nn]
case 0x1C:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// 1D nn nn    - SBC A, [Y + #nnnn]
case 0x1D:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadHLOfs16());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// 1E          - SBC A, [X1]
case 0x1E:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 1F          - SBC A, [X2]
case 0x1F:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 20          - AND A, A
case 0x20:
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 21          - AND A, B
case 0x21:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 22 nn       - AND A, #nn
case 0x22:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 23          - AND A, [HL]
case 0x23:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(PokeCPU.HL.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 24 nn       - AND A, [NN + #nn]
case 0x24:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadNNOfs8());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 25 nn nn    - AND A, [Y + #nnnn]
case 0x25:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadHLOfs16());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// 26          - AND A, [X1]
case 0x26:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(PokeCPU.X1.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 27          - AND A, [X2]
case 0x27:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(PokeCPU.X2.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 28          - OR A, A
case 0x28:
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 29          - OR A, B
case 0x29:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 2A nn       - OR A, #nn
case 0x2A:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 2B          - OR A, [HL]
case 0x2B:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(PokeCPU.HL.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 2C nn       - OR A, [NN + #nn]
case 0x2C:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadNNOfs8());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 2D nn nn    - OR A, [Y + #nnnn]
case 0x2D:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadHLOfs16());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// 2E          - OR A, [X1]
case 0x2E:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(PokeCPU.X1.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 2F          - OR A, [X2]
case 0x2F:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(PokeCPU.X2.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 30          - CMP A, A
case 0x30:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// 31          - CMP A, B
case 0x31:
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  break;

// 32 nn       - CMP A, #nn
case 0x32:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// 33          - CMP A, [HL]
case 0x33:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// 34 nn       - CMP A, [NN + #nn]
case 0x34:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// 35 nn nn    - CMP A, [Y + #nnnn]
case 0x35:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadHLOfs16());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l += 2;
  break;

// 36          - CMP A, [X1]
case 0x36:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// 37          - CMP A, [X2]
case 0x37:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// 38          - XOR A, A
case 0x38:
  PokeCPU.BA.B.l = 0x00;
  ClearFlags(S_FLAG | Z_FLAG);
  SetFlags(Z_FLAG);
  break;

// 39          - XOR A, B
case 0x39:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 3A nn       - XOR A, #nn
case 0x3A:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 3B          - XOR A, [HL]
case 0x3B:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(PokeCPU.HL.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 3C nn       - XOR A, [NN + #nn]
case 0x3C:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadNNOfs8());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 3D nn nn    - XOR A, [Y + #nnnn]
case 0x3D:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadHLOfs16());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// 3E          - XOR A, [X1]
case 0x3E:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(PokeCPU.X1.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 3F          - XOR A, [X2]
case 0x3F:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(PokeCPU.X2.D);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 40          - MOV A, A
case 0x40:
  break;

// 41          - MOV A, B
case 0x41:
  PokeCPU.BA.B.l = PokeCPU.BA.B.h;
  break;

// 42          - MOV A, L
case 0x42:
  PokeCPU.BA.B.l = PokeCPU.HL.B.l;
  break;

// 43          - MOV A, H
case 0x43:
  PokeCPU.BA.B.l = PokeCPU.HL.B.h;
  break;

// 44 nn       - MOV A, [NN + #nn]
case 0x44:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.PC.W.l++;
  break;

// 45          - MOV A, [HL]
case 0x45:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  break;

// 46          - MOV A, [X1]
case 0x46:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.X1.D);
  break;

// 47          - MOV A, [X2]
case 0x47:
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.X2.D);
  break;

// 48          - MOV B, A
case 0x48:
  PokeCPU.BA.B.h = PokeCPU.BA.B.l;
  break;

// 49          - MOV B, B
case 0x49:
  break;

// 4A          - MOV B, L
case 0x4A:
  PokeCPU.BA.B.h = PokeCPU.HL.B.l;
  break;

// 4B          - MOV B, H
case 0x4B:
  PokeCPU.BA.B.h = PokeCPU.HL.B.h;
  break;

// 4C nn       - MOV B, [NN + #nn]
case 0x4C:
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.PC.W.l++;
  break;

// 4D          - MOV B, [HL]
case 0x4D:
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.HL.D);
  break;

// 4E          - MOV B, [X1]
case 0x4E:
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.X1.D);
  break;

// 4F          - MOV B, [X2]
case 0x4F:
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.X2.D);
  break;

// 50          - MOV L, A
case 0x50:
  PokeCPU.HL.B.l = PokeCPU.BA.B.l;
  break;

// 51          - MOV L, B
case 0x51:
  PokeCPU.HL.B.l = PokeCPU.BA.B.h;
  break;

// 52          - MOV L, L
case 0x52:
  break;

// 53          - MOV L, H
case 0x53:
  PokeCPU.HL.B.l = PokeCPU.HL.B.h;
  break;

// 54 nn       - MOV L, [NN + #nn]
case 0x54:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.PC.W.l++;
  break;

// 55          - MOV L, [HL]
case 0x55:
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  break;

// 56          - MOV L, [X1]
case 0x56:
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.X1.D);
  break;

// 57          - MOV L, [X2]
case 0x57:
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.X2.D);
  break;

// 58          - MOV H, A
case 0x58:
  PokeCPU.HL.B.h = PokeCPU.BA.B.l;
  break;

// 59          - MOV H, B
case 0x59:
  PokeCPU.HL.B.h = PokeCPU.BA.B.h;
  break;

// 5A          - MOV H, L
case 0x5A:
  PokeCPU.HL.B.h = PokeCPU.HL.B.l;
  break;

// 5B          - MOV H, H
case 0x5B:
  break;

// 5C nn       - MOV H, [NN + #nn]
case 0x5C:
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.PC.W.l++;
  break;

// 5D          - MOV H, [HL]
case 0x5D:
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.HL.D);
  break;

// 5E          - MOV H, [X1]
case 0x5E:
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.X1.D);
  break;

// 5F          - MOV H, [X2]
case 0x5F:
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.X2.D);
  break;

// 60          - MOV [X1], A
case 0x60:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.BA.B.l);
  break;

// 61          - MOV [X1], B
case 0x61:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.BA.B.h);
  break;

// 62          - MOV [X1], L
case 0x62:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.HL.B.l);
  break;

// 63          - MOV [X1], H
case 0x63:
  WritePokeCPUEx(PokeCPU.X1.D, PokeCPU.HL.B.h);
  break;

// 64 nn       - MOV [X1], [NN + #nn]
case 0x64:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(ReadNNOfs8()));
  PokeCPU.PC.W.l++;
  break;

// 65          - MOV [X1], [HL]
case 0x65:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(PokeCPU.HL.D));
  break;

// 66          - MOV [X1], [X1]
case 0x66:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(PokeCPU.X1.D));
  break;

// 67          - MOV [X1], [X2]
case 0x67:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(PokeCPU.X2.D));
  break;

// 68          - MOV [HL], A
case 0x68:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.BA.B.l);
  break;

// 69          - MOV [HL], B
case 0x69:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.BA.B.h);
  break;

// 6A          - MOV [HL], L
case 0x6A:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.HL.B.l);
  break;

// 6B          - MOV [HL], H
case 0x6B:
  WritePokeCPUEx(PokeCPU.HL.D, PokeCPU.HL.B.h);
  break;

// 6C nn       - MOV [HL], [NN + #nn]
case 0x6C:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(ReadNNOfs8()));
  PokeCPU.PC.W.l++;
  break;

// 6D          - MOV [HL], [HL]
case 0x6D:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(PokeCPU.HL.D));
  break;

// 6E          - MOV [HL], [X1]
case 0x6E:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(PokeCPU.X1.D));
  break;

// 6F          - MOV [HL], [X2]
case 0x6F:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(PokeCPU.X2.D));
  break;

// 70          - MOV [X2], A
case 0x70:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.BA.B.l);
  break;

// 71          - MOV [X2], B
case 0x71:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.BA.B.h);
  break;

// 72          - MOV [X2], L
case 0x72:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.HL.B.l);
  break;

// 73          - MOV [X2], H
case 0x73:
  WritePokeCPUEx(PokeCPU.X2.D, PokeCPU.HL.B.h);
  break;

// 74 nn       - MOV [X2], [NN + #nn]
case 0x74:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(ReadNNOfs8()));
  PokeCPU.PC.W.l++;
  break;

// 75          - MOV [X2], [HL]
case 0x75:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(PokeCPU.HL.D));
  break;

// 76          - MOV [X2], [X1]
case 0x76:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(PokeCPU.X1.D));
  break;

// 77          - MOV [X2], [X2]
case 0x77:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(PokeCPU.X2.D));
  break;

// 78 nn       - MOV [NN + #nn], A
case 0x78:
  WritePokeCPUEx(ReadNNOfs8(), PokeCPU.BA.B.l);
  PokeCPU.PC.W.l++;
  break;

// 79 nn       - MOV [NN + #nn], B
case 0x79:
  WritePokeCPUEx(ReadNNOfs8(), PokeCPU.BA.B.h);
  PokeCPU.PC.W.l++;
  break;

// 7A nn       - MOV [NN + #nn], L
case 0x7A:
  WritePokeCPUEx(ReadNNOfs8(), PokeCPU.HL.B.l);
  PokeCPU.PC.W.l++;
  break;

// 7B nn       - MOV [NN + #nn], H
case 0x7B:
  WritePokeCPUEx(ReadNNOfs8(), PokeCPU.HL.B.h);
  PokeCPU.PC.W.l++;
  break;

// 7C nn nn    - [INVALID]
case 0x7C:
  IllegalPokeCPU(0x7C);
  PokeCPU.PC.W.l += 2;
  break;

// 7D nn       - MOV [NN + #nn], [HL]
case 0x7D:
  WritePokeCPUEx(ReadNNOfs8(), ReadPokeCPUEx(PokeCPU.HL.D));
  PokeCPU.PC.W.l++;
  break;

// 7E nn       - MOV [NN + #nn], [X1]
case 0x7E:
  WritePokeCPUEx(ReadNNOfs8(), ReadPokeCPUEx(PokeCPU.X1.D));
  PokeCPU.PC.W.l++;
  break;

// 7F nn       - MOV [NN + #nn], [X2]
case 0x7F:
  WritePokeCPUEx(ReadNNOfs8(), ReadPokeCPUEx(PokeCPU.X2.D));
  PokeCPU.PC.W.l++;
  break;

// 80          - INC A
case 0x80:
  PokeCPU.tmp = PokeCPU.BA.B.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.BA.B.l, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 81          - INC B
case 0x81:
  PokeCPU.tmp = PokeCPU.BA.B.h + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.BA.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 82          - INC L
case 0x82:
  PokeCPU.tmp = PokeCPU.HL.B.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.HL.B.l, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 83          - INC H
case 0x83:
  PokeCPU.tmp = PokeCPU.HL.B.h + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.HL.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 84          - INC N
case 0x84:
  PokeCPU.tmp = PokeCPU.NN.B.h + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.NN.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.NN.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 85 nn       - INC [NN + #nn]
case 0x85:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.tmp2 + 1;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.tmp2, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// 86          - INC [HL]
case 0x86:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + 1;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD(PokeCPU.tmp2, 1, PokeCPU.tmp & 0xFF);
  break;

// 87          - INC SP
case 0x87:
  PokeCPU.tmp = PokeCPU.SP.W.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD16(PokeCPU.SP.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 88          - DEC A
case 0x88:
  PokeCPU.tmp = PokeCPU.BA.B.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 89          - DEC B
case 0x89:
  PokeCPU.tmp = PokeCPU.BA.B.h - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 8A          - DEC L
case 0x8A:
  PokeCPU.tmp = PokeCPU.HL.B.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.HL.B.l, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.B.l = (unsigned char)PokeCPU.tmp;
  break;

// 8B          - DEC H
case 0x8B:
  PokeCPU.tmp = PokeCPU.HL.B.h - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.HL.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.HL.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 8C          - DEC N
case 0x8C:
  PokeCPU.tmp = PokeCPU.NN.B.h - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.NN.B.h, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.NN.B.h = (unsigned char)PokeCPU.tmp;
  break;

// 8D nn       - DEC [NN + #nn]
case 0x8D:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.tmp2 - 1;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, 1, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// 8E          - DEC [HL]
case 0x8E:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - 1;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFF) != 0xFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, 1, PokeCPU.tmp & 0xFF);
  break;

// 8F          - DEC SP
case 0x8F:
  PokeCPU.tmp = PokeCPU.SP.W.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) != 0xFFFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.SP.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.SP.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 90          - INC BA
case 0x90:
  PokeCPU.tmp = PokeCPU.BA.W.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD16(PokeCPU.BA.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 91          - INC HL
case 0x91:
  PokeCPU.tmp = PokeCPU.HL.W.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD16(PokeCPU.HL.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 92          - INC X1
case 0x92:
  PokeCPU.tmp = PokeCPU.X1.W.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD16(PokeCPU.X1.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 93          - INC X2
case 0x93:
  PokeCPU.tmp = PokeCPU.X2.W.l + 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) {PokeCPU.F |= C_FLAG; PokeCPU.F |= Z_FLAG;}
  O_Flag_ADD16(PokeCPU.X2.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 94          - TST A, B
case 0x94:
  PokeCPU.tmp = PokeCPU.BA.B.l & PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// 95 nn       - TST [HL], #nn
case 0x95:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 96 nn       - TST A, #nn
case 0x96:
  PokeCPU.tmp = PokeCPU.BA.B.l & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 97 nn       - TST B, #nn
case 0x97:
  PokeCPU.tmp = PokeCPU.BA.B.h & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// 98          - DEC BA
case 0x98:
  PokeCPU.tmp = PokeCPU.BA.W.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) != 0xFFFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 99          - DEC HL
case 0x99:
  PokeCPU.tmp = PokeCPU.HL.W.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) != 0xFFFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 9A          - DEC X1
case 0x9A:
  PokeCPU.tmp = PokeCPU.X1.W.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) != 0xFFFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X1.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 9B          - DEC X2
case 0x9B:
  PokeCPU.tmp = PokeCPU.X2.W.l - 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) != 0xFFFF) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X2.W.l, 1, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  break;

// 9C nn       - AND F, #nn
case 0x9C:
  PokeCPU.F = PokeCPU.F & ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// 9D nn       - OR F, #nn
case 0x9D:
  PokeCPU.F = PokeCPU.F | ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// 9E nn       - XOR F, #nn
case 0x9E:
  PokeCPU.F = PokeCPU.F ^ ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// 9F nn       - MOV F, #nn
case 0x9F:
  PokeCPU.F = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// A0          - PUSH BA
case 0xA0:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.BA.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.BA.B.h);
  break;

// A1          - PUSH HL
case 0xA1:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.HL.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.HL.B.h);
  break;

// A2          - PUSH X1
case 0xA2:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.X1.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.X1.B.h);
  break;

// A3          - PUSH X2
case 0xA3:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.X2.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.X2.B.h);
  break;

// A4          - PUSH N
case 0xA4:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.NN.B.h);
  break;

// A5          - PUSHH HL
case 0xA5:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.HL.B.x);
  break;

// A6          - PUSHHXX
case 0xA6:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.X2.B.x);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.X1.B.x);
  break;

// A7          - PUSH F
case 0xA7:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.F);
  break;

// A8          - POP BA
case 0xA8:
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 2;
  break;

// A9          - POP HL
case 0xA9:
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 2;
  break;

// AA          - POP X1
case 0xAA:
  PokeCPU.X1.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.X1.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 2;
  break;

// AB          - POP X2
case 0xAB:
  PokeCPU.X2.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.X2.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 2;
  break;

// AC          - POP N
case 0xAC:
  PokeCPU.NN.B.h = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// AD          - POPH HL
case 0xAD:
  PokeCPU.HL.B.x = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// AE          - POPHXX
case 0xAE:
  PokeCPU.X2.B.x = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.X1.B.x = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 2;
  break;

// AF          - POP F
case 0xAF:
  PokeCPU.F = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 1;
  break;

// B0 nn       - MOV A, #nn
case 0xB0:
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// B1 nn       - MOV B, #nn
case 0xB1:
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// B2 nn       - MOV L, #nn
case 0xB2:
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// B3 nn       - MOV H, #nn
case 0xB3:
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// B4 nn       - MOV N, #nn
case 0xB4:
  PokeCPU.NN.B.h = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// B5 nn       - MOV [HL], #nn
case 0xB5:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPU(PokeCPU.PC.W.l));
  PokeCPU.PC.W.l++;
  break;

// B6 nn       - MOV [X1], #nn
case 0xB6:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPU(PokeCPU.PC.W.l));
  PokeCPU.PC.W.l++;
  break;

// B7 nn       - MOV [X2], #nn
case 0xB7:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPU(PokeCPU.PC.W.l));
  PokeCPU.PC.W.l++;
  break;

// B8 nn nn    - MOV BA, [Y + #nnnn]
case 0xB8:
  PokeCPU.tmp = ReadHLOfs16();
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.BA.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  PokeCPU.PC.W.l += 2;
  break;

// B9 nn nn    - MOV HL, [Y + #nnnn]
case 0xB9:
  PokeCPU.tmp = ReadHLOfs16();
  PokeCPU.HL.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.HL.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  PokeCPU.PC.W.l += 2;
  break;

// BA nn nn    - MOV X1, [Y + #nnnn]
case 0xBA:
  PokeCPU.tmp = ReadHLOfs16();
  PokeCPU.X1.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.X1.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  PokeCPU.PC.W.l += 2;
  break;

// BB nn nn    - MOV X2, [Y + #nnnn]
case 0xBB:
  PokeCPU.tmp = ReadHLOfs16();
  PokeCPU.X2.B.l = ReadPokeCPUEx(PokeCPU.tmp);
  PokeCPU.X2.B.h = ReadPokeCPUEx(PokeCPU.tmp + 1);
  PokeCPU.PC.W.l += 2;
  break;

// BC nn nn    - MOV [Y + #nnnn], BA
case 0xBC:
  PokeCPU.tmp = ReadHLOfs16();
  WritePokeCPUEx(PokeCPU.tmp, PokeCPU.BA.B.l);
  WritePokeCPUEx(PokeCPU.tmp + 1, PokeCPU.BA.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// BD nn nn    - MOV [Y + #nnnn], HL
case 0xBD:
  PokeCPU.tmp = ReadHLOfs16();
  WritePokeCPUEx(PokeCPU.tmp, PokeCPU.HL.B.l);
  WritePokeCPUEx(PokeCPU.tmp + 1, PokeCPU.HL.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// BE nn nn    - MOV [Y + #nnnn], X1
case 0xBE:
  PokeCPU.tmp = ReadHLOfs16();
  WritePokeCPUEx(PokeCPU.tmp, PokeCPU.X1.B.l);
  WritePokeCPUEx(PokeCPU.tmp + 1, PokeCPU.X1.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// BF nn nn    - MOV [Y + #nnnn], X2
case 0xBF:
  PokeCPU.tmp = ReadHLOfs16();
  WritePokeCPUEx(PokeCPU.tmp, PokeCPU.X2.B.l);
  WritePokeCPUEx(PokeCPU.tmp + 1, PokeCPU.X2.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// C0 nn nn    - ADD BA, #nnnn
case 0xC0:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.BA.W.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.BA.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// C1 nn nn    - ADD HL, #nnnn
case 0xC1:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.HL.W.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.HL.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// C2 nn nn    - ADD X1, #nnnn
case 0xC2:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X1.W.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X1.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// C3 nn nn    - ADD X2, #nnnn
case 0xC3:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X2.W.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD16(PokeCPU.X2.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// C4 nn nn    - MOV BA, #nnnn
case 0xC4:
  PokeCPU.BA.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.BA.B.h = ReadPokeCPU(PokeCPU.PC.W.l + 1);
  PokeCPU.PC.W.l += 2;
  break;

// C5 nn nn    - MOV HL, #nnnn
case 0xC5:
  PokeCPU.HL.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.HL.B.h = ReadPokeCPU(PokeCPU.PC.W.l + 1);
  PokeCPU.PC.W.l += 2;
  break;

// C6 nn nn    - MOV X1, #nnnn
case 0xC6:
  PokeCPU.X1.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.X1.B.h = ReadPokeCPU(PokeCPU.PC.W.l + 1);
  PokeCPU.PC.W.l += 2;
  break;

// C7 nn nn    - MOV X2, #nnnn
case 0xC7:
  PokeCPU.X2.B.l = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.X2.B.h = ReadPokeCPU(PokeCPU.PC.W.l + 1);
  PokeCPU.PC.W.l += 2;
  break;

// C8          - XCHG BA, HL
case 0xC8:
  PokeCPU.tmp = PokeCPU.HL.W.l;
  PokeCPU.HL.W.l = PokeCPU.BA.W.l;
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// C9          - XCHG BA, X1
case 0xC9:
  PokeCPU.tmp = PokeCPU.X1.W.l;
  PokeCPU.X1.W.l = PokeCPU.BA.W.l;
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CA          - XCHG BA, X2
case 0xCA:
  PokeCPU.tmp = PokeCPU.X2.W.l;
  PokeCPU.X2.W.l = PokeCPU.BA.W.l;
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CB          - XCHG BA, SP
case 0xCB:
  PokeCPU.tmp = PokeCPU.SP.W.l;
  PokeCPU.SP.W.l = PokeCPU.BA.W.l;
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CC          - XCHG A, B
case 0xCC:
  PokeCPU.tmp = PokeCPU.BA.B.l;
  PokeCPU.BA.B.l = PokeCPU.BA.B.h;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CD          - XCHG A, [HL]
case 0xCD:
  PokeCPU.tmp = PokeCPU.BA.B.l;
  PokeCPU.BA.B.l = ReadPokeCPUEx(PokeCPU.HL.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  break;

// CE          - [EXPAND 0]

// CF          - [EXPAND 1]

// D0 nn nn    - SUB BA, #nnnn
case 0xD0:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.BA.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// D1 nn nn    - SUB HL, #nnnn
case 0xD1:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// D2 nn nn    - SUB X1, #nnnn
case 0xD2:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X1.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X1.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X1.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// D3 nn nn    - SUB X2, #nnnn
case 0xD3:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X2.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X2.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.X2.W.l = (unsigned short)PokeCPU.tmp;
  PokeCPU.PC.W.l += 2;
  break;

// D4 nn nn    - CMP BA, #nnnn
case 0xD4:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.BA.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.BA.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// D5 nn nn    - CMP HL, #nnnn
case 0xD5:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.HL.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.HL.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// D6 nn nn    - CMP X1, #nnnn
case 0xD6:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X1.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X1.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// D7 nn nn    - CMP X2, #nnnn
case 0xD7:
  PokeCPU.tmp2 = ReadPC16();
  PokeCPU.tmp = PokeCPU.X2.W.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFF0000) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.X2.W.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// D8 nn nn    - AND [NN + #nn], #nn
case 0xD8:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) & ReadPokeCPU(PokeCPU.PC.W.l + 1);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// D9 nn nn    - OR [NN + #nn], #nn
case 0xD9:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) | ReadPokeCPU(PokeCPU.PC.W.l + 1);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// DA nn nn    - XOR [NN + #nn], #nn
case 0xDA:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) ^ ReadPokeCPU(PokeCPU.PC.W.l + 1);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// DB nn nn    - CMP [NN + #nn], #nn
case 0xDB:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l + 1);
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB16(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFFFF);
  PokeCPU.PC.W.l += 2;
  break;

// DC nn nn    - TST [NN + #nn], #nn
case 0xDC:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) & ReadPokeCPU(PokeCPU.PC.W.l + 1);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l += 2;
  break;

// DD nn nn    - MOV [NN + #nn], #nn
case 0xDD:
  WritePokeCPUEx(ReadNNOfs8(), ReadPokeCPU(PokeCPU.PC.W.l + 1));
  PokeCPU.PC.W.l += 2;
  break;

// DE          - BCDE (Unsure)
case 0xDE:
  IllegalPokeCPU(0xDE);
  break;

// DF          - BCDD (Unsure)
case 0xDF:
  IllegalPokeCPU(0xDF);
  break;

// E0 nn       - CALLBC, +/-#nn
case 0xE0:
  if (PokeCPU.F & C_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E1 nn       - CALLBNC, +/-#nn
case 0xE1:
  if (!(PokeCPU.F & C_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E2 nn       - CALLBZ, +/-#nn
case 0xE2:
  if (PokeCPU.F & Z_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E3 nn       - CALLBNZ, +/-#nn
case 0xE3:
  if (!(PokeCPU.F & C_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E4 nn       - JBC, +/-#nn
case 0xE4:
  if (PokeCPU.F & C_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E5 nn       - JBNC, +/-#nn
case 0xE5:
  if (!(PokeCPU.F & C_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E6 nn       - JBZ, +/-#nn
case 0xE6:
  if (PokeCPU.F & Z_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E7 nn       - JBNZ, +/-#nn
case 0xE7:
  if (!(PokeCPU.F & Z_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// E8 nn nn    - CALLWC, +/-#nnnn
case 0xE8:
  if (PokeCPU.F & C_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l += 2;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l -= 2;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// E9 nn nn    - CALLWNC, +/-#nnnn
case 0xE9:
  if (!(PokeCPU.F & C_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l += 2;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l -= 2;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// EA nn nn    - CALLWZ, +/-#nnnn
case 0xEA:
  if (PokeCPU.F & Z_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l += 2;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l -= 2;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// EB nn nn    - CALLWNZ, +/-#nnnn
case 0xEB:
  if (!(PokeCPU.F & Z_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l += 2;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l -= 2;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// EC nn nn    - JWC +/-#nnnn
case 0xEC:
  if (PokeCPU.F & C_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// ED nn nn    - JWNC +/-#nnnn
case 0xED:
  if (!(PokeCPU.F & C_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// EE nn nn    - JWZ +/-#nnnn
case 0xEE:
  if (PokeCPU.F & Z_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// EF nn nn    - JWNZ +/-#nnnn
case 0xEF:
  if (!(PokeCPU.F & Z_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  } else PokeCPU.PC.W.l += 2;
  break;

// F0 nn       - CALLB +/-#nn
case 0xF0:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
  PokeCPU.PC.W.l++;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
  PokeCPU.PC.W.l--;
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  break;

// F1 nn       - JB +/-#nn
case 0xF1:
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  break;

// F2 nn nn    - CALLW +/-#nnnn
case 0xF2:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
  PokeCPU.PC.W.l += 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
  PokeCPU.PC.W.l -= 2;
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  break;

// F3 nn nn    - JW +/-#nnnn
case 0xF3:
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = PokeCPU.PC.W.l + S16_Jump(ReadPC16() + 1);
  break;

// F4          - JW HL
case 0xF4:
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = PokeCPU.HL.W.l;
  break;

// F5 nn       - JDBNZ +/-#nn
case 0xF5:
  PokeCPU.BA.B.h = PokeCPU.BA.B.h - 1;
  if (PokeCPU.BA.B.h) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// F6          - BCDX A
case 0xF6:
  IllegalPokeCPU(0xF6);
  break;

// F7          - BCDX [HL]
case 0xF7:
  IllegalPokeCPU(0xF7);
  break;

// F8          - RET
case 0xF8:
  PokeCPU.PC.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.PC.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.V = ReadPokeCPU(PokeCPU.SP.W.l + 2);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 3;
  break;

// F9          - RETI
case 0xF9:
  PokeCPU.F = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.PC.B.l = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.PC.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 2);
  PokeCPU.V = ReadPokeCPU(PokeCPU.SP.W.l + 3);
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 4;
  break;

// FA          - RETSKIP
case 0xFA:
  PokeCPU.PC.B.l = ReadPokeCPU(PokeCPU.SP.W.l);
  PokeCPU.PC.B.h = ReadPokeCPU(PokeCPU.SP.W.l + 1);
  PokeCPU.V = ReadPokeCPU(PokeCPU.SP.W.l + 2);
  PokeCPU.PC.W.l = PokeCPU.PC.W.l + 2;
  PokeCPU.SP.W.l = PokeCPU.SP.W.l + 3;
  break;

// FB nn nn    - CALL [Y + #nnnn]
case 0xFB:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
  PokeCPU.PC.W.l += 2;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
  PokeCPU.PC.W.l -= 2;
  PokeCPU.V = PokeCPU.U;
  PokeCPU.UT = POKECPU_VREGPRESET;
  PokeCPU.PC.W.l = ReadPokeCPUEx(ReadHLOfs16()) + (ReadPokeCPUEx(ReadHLOfs16() + 1) << 8);
  break;

// FC nn       - CINT #nn
case 0xFC:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 4;
  PokeCPU.PC.W.l++;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.F);
  WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.l);
  WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.PC.B.h);
  WritePokeCPU(PokeCPU.SP.W.l + 3, PokeCPU.V);
  PokeCPU.V = 0x00;
  PokeCPU.tmp = ReadPokeCPU(PokeCPU.PC.W.l - 1);
  PokeCPU.PC.B.l = ReadPokeCPU((unsigned short)PokeCPU.tmp);
  PokeCPU.PC.B.h = ReadPokeCPU((unsigned short)PokeCPU.tmp + 1);
#ifdef POKECPU_DEBUG
  if (PokeCPU.tmp == 0x0042) PokeCPU.Terminate = true;
  if (PokeCPU.tmp == 0x0048) PokeCPU.Terminate = true;
#endif
  break;

// FD nn       - JINT #nn
case 0xFD:
  PokeCPU.SP.W.l = PokeCPU.SP.W.l - 1;
  WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.F);
  PokeCPU.V = 0x00;
  PokeCPU.tmp = ReadPokeCPU(PokeCPU.PC.W.l) & 0x000FE;
  PokeCPU.PC.B.l = ReadPokeCPU((unsigned short)PokeCPU.tmp);
  PokeCPU.PC.B.h = ReadPokeCPU((unsigned short)PokeCPU.tmp + 1);
#ifdef POKECPU_DEBUG
  if (PokeCPU.tmp == 0x42) PokeCPU.Terminate = true;
  if (PokeCPU.tmp == 0x48) PokeCPU.Terminate = true;
#endif
  break;

// FE          - [INVALID]
case 0xFE:
  IllegalPokeCPU(0xFE);
  break;

// FF          - NOP
case 0xFF:
  break;

default:
  IllegalPokeCPU(0xFFFFFFFF);
  break;

