/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "minimon.h"

void MinxCore::ExecCodeCF()
{
	unsigned char code;

	Fetch( code );

	switch( code )
	{
	case 0x00: // addw BA,BA
		Add( m_CpuReg.word.BA, m_CpuReg.word.BA, false );
		break ;
	case 0x01: // addw BA,HL
		Add( m_CpuReg.word.BA, m_CpuReg.word.HL, false );
		break ;
	case 0x02: // addw BA,X1
		Add( m_CpuReg.word.BA, m_CpuReg.word.X, false );
		break ;
	case 0x03: // addw BA,X2
		Add( m_CpuReg.word.BA, m_CpuReg.word.Y, false );
		break ;
	case 0x04: // addcw BA,BA
		Add( m_CpuReg.word.BA, m_CpuReg.word.BA, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x05: // addcw BA,HL
		Add( m_CpuReg.word.BA, m_CpuReg.word.HL, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x06: // addcw BA,X1
		Add( m_CpuReg.word.BA, m_CpuReg.word.X, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x07: // addcw BA,X2
		Add( m_CpuReg.word.BA, m_CpuReg.word.Y, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x08: // subw BA,BA
		Sub( m_CpuReg.word.BA, m_CpuReg.word.BA, false );
		break ;
	case 0x09: // subw BA,HL
		Sub( m_CpuReg.word.BA, m_CpuReg.word.HL, false );
		break ;
	case 0x0A: // subw BA,X1
		Sub( m_CpuReg.word.BA, m_CpuReg.word.X, false );
		break ;
	case 0x0B: // subw BA,X2
		Sub( m_CpuReg.word.BA, m_CpuReg.word.Y, false );
		break ;
	case 0x0C: // subcw BA,BA
		Sub( m_CpuReg.word.BA, m_CpuReg.word.BA, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x0D: // subcw BA,HL
		Sub( m_CpuReg.word.BA, m_CpuReg.word.HL, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x0E: // subcw BA,X1
		Sub( m_CpuReg.word.BA, m_CpuReg.word.X, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x0F: // subcw BA,X2
		Sub( m_CpuReg.word.BA, m_CpuReg.word.Y, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x18: // cmpw BA,BA
		{
			unsigned short left = m_CpuReg.word.BA;
			Sub( left, m_CpuReg.word.BA, false );
		}
		break;
	case 0x19: // cmpw BA,HL
		{
			unsigned short left = m_CpuReg.word.BA;
			Sub( left, m_CpuReg.word.HL, false );
		}
		break;
	case 0x1A: // cmpw BA,X1
		{
			unsigned short left = m_CpuReg.word.BA;
			Sub( left, m_CpuReg.word.X, false );
		}
		break;
	case 0x1B: // cmpw BA,X2
		{
			unsigned short left = m_CpuReg.word.BA;
			Sub( left, m_CpuReg.word.Y, false );
		}
		break;
	case 0x20: // addw HL,BA
		Add( m_CpuReg.word.HL, m_CpuReg.word.BA, false );
		break ;
	case 0x21: // addw HL,HL
		Add( m_CpuReg.word.HL, m_CpuReg.word.HL, false );
		break ;
	case 0x22: // addw HL,X1
		Add( m_CpuReg.word.HL, m_CpuReg.word.X, false );
		break ;
	case 0x23: // addw HL,X2
		Add( m_CpuReg.word.HL, m_CpuReg.word.Y, false );
		break ;
	case 0x24: // addcw HL,BA
		Add( m_CpuReg.word.HL, m_CpuReg.word.BA, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x25: // addcw HL,HL
		Add( m_CpuReg.word.HL, m_CpuReg.word.HL, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x26: // addcw HL,X1
		Add( m_CpuReg.word.HL, m_CpuReg.word.X, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x27: // addcw HL,X2
		Add( m_CpuReg.word.HL, m_CpuReg.word.Y, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x28: // subw HL,BA
		Sub( m_CpuReg.word.HL, m_CpuReg.word.BA, false );
		break ;
	case 0x29: // subw HL,HL
		Sub( m_CpuReg.word.HL, m_CpuReg.word.HL, false );
		break ;
	case 0x2A: // subw HL,X1
		Sub( m_CpuReg.word.HL, m_CpuReg.word.X, false );
		break ;
	case 0x2B: // subw HL,X2
		Sub( m_CpuReg.word.HL, m_CpuReg.word.Y, false );
		break ;
	case 0x2C: // subcw HL,BA
		Sub( m_CpuReg.word.HL, m_CpuReg.word.BA, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x2D: // subcw HL,HL
		Sub( m_CpuReg.word.HL, m_CpuReg.word.HL, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x2E: // subcw HL,X1
		Sub( m_CpuReg.word.HL, m_CpuReg.word.X, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x2F: // subcw HL,X2
		Sub( m_CpuReg.word.HL, m_CpuReg.word.Y, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		break ;
	case 0x38: // cmpw HL,BA
		{
			unsigned short left = m_CpuReg.word.HL;
			Sub( left, m_CpuReg.word.BA, false );
		}
		break ;
	case 0x39: // cmpw HL,HL
		{
			unsigned short left = m_CpuReg.word.HL;
			Sub( left, m_CpuReg.word.HL, false );
		}
		break ;
	case 0x3A: // cmpw HL,X1
		{
			unsigned short left = m_CpuReg.word.HL;
			Sub( left, m_CpuReg.word.X, false );
		}
		break ;
	case 0x3B: // cmpw HL,X2
		{
			unsigned short left = m_CpuReg.word.HL;
			Sub( left, m_CpuReg.word.Y, false );
		}
		break ;
	case 0x40: // addw X1,BA
		Add( m_CpuReg.word.X, m_CpuReg.word.BA, false );
		break ;
	case 0x41: // addw X1,HL
		Add( m_CpuReg.word.X, m_CpuReg.word.HL, false );
		break ;
	case 0x42: // addw X2,BA
		Add( m_CpuReg.word.Y, m_CpuReg.word.BA, false );
		break ;
	case 0x43: // addw X2,HL
		Add( m_CpuReg.word.Y, m_CpuReg.word.HL, false );
		break ;
	case 0x44: // addw SP,BA
		Add( m_CpuReg.word.SP, m_CpuReg.word.BA, false );
		break ;
	case 0x45: // addw SP,HL
		Add( m_CpuReg.word.SP, m_CpuReg.word.HL, false );
		break ;
	case 0x48: // subw X1,BA
		Sub( m_CpuReg.word.X, m_CpuReg.word.BA, false );
		break ;
	case 0x49: // subw X1,HL
		Sub( m_CpuReg.word.X, m_CpuReg.word.HL, false );
		break ;
	case 0x4A: // subw X2,BA
		Sub( m_CpuReg.word.Y, m_CpuReg.word.BA, false );
		break ;
	case 0x4B: // subw X2,HL
		Sub( m_CpuReg.word.Y, m_CpuReg.word.HL, false );
		break ;
	case 0x4C: // subw SP,BA
		Sub( m_CpuReg.word.SP, m_CpuReg.word.BA, false );
		break ;
	case 0x4D: // subw SP,HL
		Sub( m_CpuReg.word.SP, m_CpuReg.word.HL, false );
		break ;
	case 0x5C: // cmpw SP,BA
		{
			unsigned short left = m_CpuReg.word.SP;
			Sub( left, m_CpuReg.word.BA, false );
		}
		break ;
	case 0x5D: // cmpw SP,HL
		{
			unsigned short left = m_CpuReg.word.SP;
			Sub( left, m_CpuReg.word.HL, false );
		}
		break ;
	case 0x60: // cmpnw BA, %(i16)s
		{
			unsigned short right;
			unsigned short left = m_CpuReg.word.BA;
			Fetch( right );
			Add( left, right, ( m_CpuReg.byte.F & FLAG_CARRY ) != 0 );
		}
		break ;
	case 0x61: // cmpnw HL, %(i16)s
		{
			unsigned short right;
			unsigned short left = m_CpuReg.word.HL;
			Fetch( right );
			Add( left, right, ( m_CpuReg.byte.F & FLAG_CARRY ) != 0 );
		}
		break ;
	case 0x62: // cmpnw X1, %(i16)s
		{
			unsigned short right;
			unsigned short left = m_CpuReg.word.X;
			Fetch( right );
			Add( left, right, ( m_CpuReg.byte.F & FLAG_CARRY ) != 0 );
		}
		break ;
	case 0x63: // cmpnw X2, %(i16)s
		{
			unsigned short right;
			unsigned short left = m_CpuReg.word.Y;
			Fetch( right );
			Add( left, right, ( m_CpuReg.byte.F & FLAG_CARRY ) != 0 );
		}
		break ;
	case 0x68: // addw SP,%(i16)s
		{
			unsigned short right;
			Fetch( right );
			Add( m_CpuReg.word.SP, right, false );
		}
		break ;
	case 0x6A: // subw SP,%(i16)s
		{
			unsigned short right;
			Fetch( right );
			Sub( m_CpuReg.word.SP, right, false );
		}
		break ;
	case 0x6C: // cmpw SP,%(i16)s
		{
			unsigned short right;
			unsigned short left = m_CpuReg.word.SP;
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
	case 0x6E: // movw SP,%(i16)s
 		Fetch( m_CpuReg.word.SP );
		break ;
	case 0x70: // movw BA, [SP%(s8)s]
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Peek( addr, m_CpuReg.word.BA );
		}
		break ;
	case 0x71: // movw HL, [SP%(s8)s]
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Peek( addr, m_CpuReg.word.HL );
		}
		break ;
	case 0x72: // movw X1, [SP%(s8)s]
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Peek( addr, m_CpuReg.word.X );
		}
		break ;
	case 0x73: // movw X2, [SP%(s8)s]
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Peek( addr, m_CpuReg.word.Y );
		}
		break ;
	case 0x74: // movw [SP%(s8)s], BA
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Poke( addr, m_CpuReg.word.BA );
		}
		break ;
	case 0x75: // movw [SP%(s8)s], HL
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Poke( addr, m_CpuReg.word.HL );
		}
		break ;
	case 0x76: // movw [SP%(s8)s], X1
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Poke( addr, m_CpuReg.word.X );
		}
		break ;
	case 0x77: // movw [SP%(s8)s], X2
		{
			unsigned char byte;
			unsigned short addr;
			
			Fetch( byte );
			
			addr = (signed char) byte + m_CpuReg.word.SP;
			Poke( addr, m_CpuReg.word.Y );
		}
		break ;
	case 0x78: // movw SP, [%(i16)s]
		{
			unsigned short addr;
			Fetch( addr );
			Peek( (m_CpuReg.byte.I << 16) | addr, m_CpuReg.word.SP );
		}
		break ;
	case 0x7C: // movw [%(i16)s], SP
		{
			unsigned short addr;
			Fetch( addr );
			Poke( (m_CpuReg.byte.I << 16) | addr, m_CpuReg.word.SP );
		}
		break ;
	case 0xB0: // pushb A
		Push( m_CpuReg.byte.A );
		break ;
	case 0xB1: // pushb B
		Push( m_CpuReg.byte.B );
		break ;
	case 0xB2: // pushb L
		Push( m_CpuReg.byte.L );
		break ;
	case 0xB3: // pushb H
		Push( m_CpuReg.byte.H );
		break ;
	case 0xB4: // popb A
		Pop( m_CpuReg.byte.A );
		break ;
	case 0xB5: // popb B
		Pop( m_CpuReg.byte.B );
		break ;
	case 0xB6: // popb L
		Pop( m_CpuReg.byte.L );
		break ;
	case 0xB7: // popb H
		Pop( m_CpuReg.byte.H );
		break ;
	case 0xB8: // pusha
		Push( m_CpuReg.word.BA );
		Push( m_CpuReg.word.HL );
		Push( m_CpuReg.word.X );
		Push( m_CpuReg.word.Y );
		Push( m_CpuReg.byte.N );
		break ; 
	case 0xB9: // pushax
		Push( m_CpuReg.word.BA );
		Push( m_CpuReg.word.HL );
		Push( m_CpuReg.word.X );
		Push( m_CpuReg.word.Y );
		Push( m_CpuReg.byte.N );
		Push( m_CpuReg.byte.I );
		Push( m_CpuReg.byte.XI );
		Push( m_CpuReg.byte.YI );
		break ; 
	case 0xBC: // popa
		Pop( m_CpuReg.byte.N );
		Pop( m_CpuReg.word.Y );
		Pop( m_CpuReg.word.X );
		Pop( m_CpuReg.word.HL );
		Pop( m_CpuReg.word.BA );
		break ; 
	case 0xBD: // popax
		Pop( m_CpuReg.byte.YI );
		Pop( m_CpuReg.byte.XI );
		Pop( m_CpuReg.byte.I );
		Pop( m_CpuReg.byte.N );
		Pop( m_CpuReg.word.Y );
		Pop( m_CpuReg.word.X );
		Pop( m_CpuReg.word.HL );
		Pop( m_CpuReg.word.BA );
		break ; 
	case 0xC0: // movw BA, [HL]
		Peek( m_CpuReg.addr.HLA, m_CpuReg.word.BA );
		break ;
	case 0xC1: // movw HL, [HL]
		Peek( m_CpuReg.addr.HLA, m_CpuReg.word.HL );
		break ;
	case 0xC2: // movw X1, [HL]
		Peek( m_CpuReg.addr.HLA, m_CpuReg.word.X );
		break ;
	case 0xC3: // movw X2, [HL]
		Peek( m_CpuReg.addr.HLA, m_CpuReg.word.Y );
		break ;
	case 0xC4: // movw [HL], BA
		Poke( m_CpuReg.addr.HLA, m_CpuReg.word.BA );
		break ;
	case 0xC5: // movw [HL], HL
		Poke( m_CpuReg.addr.HLA, m_CpuReg.word.HL );
		break ;
	case 0xC6: // movw [HL], X1
		Poke( m_CpuReg.addr.HLA, m_CpuReg.word.X );
		break ;
	case 0xC7: // movw [HL], X2
		Poke( m_CpuReg.addr.HLA, m_CpuReg.word.Y );
		break ;
	case 0xD0: // movw BA, [X1]
		Peek( m_CpuReg.addr.XA, m_CpuReg.word.BA );
		break ;
	case 0xD1: // movw HL, [X1]
		Peek( m_CpuReg.addr.XA, m_CpuReg.word.HL );
		break ;
	case 0xD2: // movw X1, [X1]
		Peek( m_CpuReg.addr.XA, m_CpuReg.word.X );
		break ;
	case 0xD3: // movw X2, [X1]
		Peek( m_CpuReg.addr.XA, m_CpuReg.word.Y );
		break ;
	case 0xD4: // movw [x1], BA
		Poke( m_CpuReg.addr.XA, m_CpuReg.word.BA );
		break ;
	case 0xD5: // movw [x1], HL
		Poke( m_CpuReg.addr.XA, m_CpuReg.word.HL );
		break ;
	case 0xD6: // movw [x1], X1
		Poke( m_CpuReg.addr.XA, m_CpuReg.word.X );
		break ;
	case 0xD7: // movw [x1], X2
		Poke( m_CpuReg.addr.XA, m_CpuReg.word.Y );
		break ;
	case 0xD8: // movw BA, [X2]
		Peek( m_CpuReg.addr.YA, m_CpuReg.word.BA );
		break ;
	case 0xD9: // movw HL, [X2]
		Peek( m_CpuReg.addr.YA, m_CpuReg.word.HL );
		break ;
	case 0xDA: // movw X1, [X2]
		Peek( m_CpuReg.addr.YA, m_CpuReg.word.X );
		break ;
	case 0xDB: // movw X2, [X2]
		Peek( m_CpuReg.addr.YA, m_CpuReg.word.Y );
		break ;
	case 0xDC: // movw [x2], BA
		Poke( m_CpuReg.addr.YA, m_CpuReg.word.BA );
		break ;
	case 0xDD: // movw [x2], HL
		Poke( m_CpuReg.addr.YA, m_CpuReg.word.HL );
		break ;
	case 0xDE: // movw [x2], X1
		Poke( m_CpuReg.addr.YA, m_CpuReg.word.X );
		break ;
	case 0xDF: // movw [x2], X2
		Poke( m_CpuReg.addr.YA, m_CpuReg.word.Y );
		break ;
	case 0xE0: // movw BA, BA
		m_CpuReg.word.BA = m_CpuReg.word.BA;
		break ;
	case 0xE1: // movw BA, HL
		m_CpuReg.word.BA = m_CpuReg.word.HL;
		break ;
	case 0xE2: // movw BA, X1
		m_CpuReg.word.BA = m_CpuReg.word.X;
		break ;
	case 0xE3: // movw BA, X2
		m_CpuReg.word.BA = m_CpuReg.word.Y;
		break ;
	case 0xE4: // movw HL, BA
		m_CpuReg.word.HL = m_CpuReg.word.BA;
		break ;
	case 0xE5: // movw HL, HL
		m_CpuReg.word.HL = m_CpuReg.word.HL;
		break ;
	case 0xE6: // movw HL, X1
		m_CpuReg.word.HL = m_CpuReg.word.X;
		break ;
	case 0xE7: // movw HL, X2
		m_CpuReg.word.HL = m_CpuReg.word.Y;
		break ;
	case 0xE8: // movw X1, BA
		m_CpuReg.word.X = m_CpuReg.word.BA;
		break ;
	case 0xE9: // movw X1, HL
		m_CpuReg.word.X = m_CpuReg.word.HL;
		break ;
	case 0xEA: // movw X1, X1
		m_CpuReg.word.X = m_CpuReg.word.X;
		break ;
	case 0xEB: // movw X1, X2
		m_CpuReg.word.X = m_CpuReg.word.Y;
		break ;
	case 0xEC: // movw X2, BA
		m_CpuReg.word.Y = m_CpuReg.word.BA;
		break ;
	case 0xED: // movw X2, HL
		m_CpuReg.word.Y = m_CpuReg.word.HL;
		break ;
	case 0xEE: // movw X2, X1
		m_CpuReg.word.Y = m_CpuReg.word.X;
		break ;
	case 0xEF: // movw X2, X2
		m_CpuReg.word.Y = m_CpuReg.word.Y;
		break ;
	case 0xF0: // movw SP, BA
		m_CpuReg.word.SP = m_CpuReg.word.BA;
		break ;
	case 0xF1: // movw SP, HL
		m_CpuReg.word.SP = m_CpuReg.word.HL;
		break ;
	case 0xF2: // movw SP, X1
		m_CpuReg.word.SP = m_CpuReg.word.X;
		break ;
	case 0xF3: // movw SP, X2
		m_CpuReg.word.SP = m_CpuReg.word.Y;
		break ;
	case 0xF4: // movw HL, SP
		m_CpuReg.word.HL = m_CpuReg.word.SP;
		break ;
	case 0xF5: // movw HL, PC
		m_CpuReg.word.HL = m_CpuReg.word.PC;
		break ;
	case 0xF8: // movw BA, SP
		m_CpuReg.word.BA = m_CpuReg.word.SP;
		break ;
	case 0xF9: // movw BA, PC
		m_CpuReg.word.BA = m_CpuReg.word.PC;
		break ;
	case 0xFA: // movw X1, SP
		m_CpuReg.word.X = m_CpuReg.word.SP;
		break ;
	case 0xFE: // movw X2, SP
		m_CpuReg.word.Y = m_CpuReg.word.SP;
		break ;
	default:
		{
			int errorCode[] = {0xCF | code};
			this->Error( "Unknown opcode", 1, errorCode );
		}
		break ;
	}

	m_Clock += CycleTable[ code | 0x200 ];
	Clock( CycleTable[ code | 0x200 ] );
}