/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Minimon.h"

InputHandle::InputHandle( HWND hWnd )
{
	//HRESULT hr;

	m_hWnd = hWnd;

	//hr = DirectInput8Create( g_hInstance, DIRECTINPUT_VERSION, IID_IDirectInput8, (LPVOID*)&lpDI, NULL );

	//if( FAILED( hr ) )
	//{
		//lpDI = NULL;
		//m_Active = false;
	//}	

	m_ConfigWnd = NULL;
	m_Devices = NULL;
	m_Map = NULL;
	//lpDIE = NULL;

	//Register( GUID_SysKeyboard, "System keyboard" );
	//lpDI->EnumDevices( DI8DEVCLASS_GAMECTRL, InputHandleEnum, this, DIEDFL_ATTACHEDONLY );
	//lpDI->EnumDevices( DI8DEVCLASS_GAMECTRL, InputRumbleEnum, this, DIEDFL_FORCEFEEDBACK | DIEDFL_ATTACHEDONLY );

	m_Active = true;
	m_Listen = false;
}

InputHandle::~InputHandle()
{	
	if( !m_Active )
	{
		return ;
	}

	//if( lpDIE != NULL )
	//{
		//lpDIE->Stop();
		//lpDIE->Release();		
	//}

	ReleaseMap(m_Map);

	//if( lpDI )
	//{
		//ReleaseDevice( m_Devices );
		//lpDI->Release();
	//}
}

void InputHandle::ReleaseMap( InputMap *map )
{
	if( map == NULL )
		return ;

	ReleaseMap( map->m_Next );
	delete map;
}

void InputHandle::ReleaseDevice( InputDevice *dev )
{
	if( dev == NULL )
	{
		return ;
	}

	ReleaseDevice(dev->m_Next);
	//dev->m_Device->Unacquire();
	//dev->m_Device->Release();
	delete dev;
}

#if 0
BOOL CALLBACK InputHandleEnum( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef )
{	
	InputHandle* ih = (InputHandle*) pvRef;
	
	ih->Register( lpddi->guidInstance, (char*)lpddi->tszInstanceName );
	return DIENUM_CONTINUE;
}

BOOL CALLBACK InputRumbleEnum( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef )
{	
	InputHandle* ih = (InputHandle*) pvRef;
	InputDevice* dev = ih->m_Devices;

	while( dev != NULL )
	{
		if( dev->m_GUID == lpddi->guidInstance )
		{
			dev->m_Rumble = true ;
		}
		dev = dev->m_Next;
	}

	return DIENUM_CONTINUE;
}

#endif
void InputHandle::Configure( Configuration *cfg )
{
#if 0
	InputMap *map;
	int result;

	m_Cfg = cfg;

	result = cfg->Seek( "config.input.inputmap" );
	while( result != NOT_FOUND )
	{
		if( m_Map == NULL )
		{
			m_Map = map = new InputMap;
		}
		else
		{
			map = map->m_Next = new InputMap;
		}

		cfg->Read( "press", map->press, NULL );
		cfg->Read( "release", map->release, NULL );
		cfg->Read( "lParam", map->lParam, NULL );
		cfg->Read( "address", map->bind, NULL );
		cfg->Read( "title", result, map->name );
		map->Button = map->Device = -1;
		map->m_Next = NULL;

		result = cfg->Seek( NULL ) ;
	}


	InputDevice *dev = m_Devices;
	GUID guid;
	long *devl = (long*)&guid;
	char device[44];

	// Read rumble configuration
	result = cfg->Seek("config.input.rumble" );

	if( result != NOT_FOUND )
	{
		m_RumbleDev = 0;
		cfg->Read( "device", result, device );
		sscanf( device, "%li-%li-%li-%li", &devl[0], &devl[1], &devl[2], &devl[3] );

		while( dev != NULL ) //&& dev->m_GUID != guid )
		{
			m_RumbleDev++;
			dev = dev->m_Next;
		}
		
		if( dev == NULL )
		{
			m_RumbleDev = -1;
		}
		else
		{
			CreateRumble();
		}
	}
	else
	{
		m_RumbleDev = -1;
	}

	// Read key bindings
	result = cfg->Seek( "config.input.bind" );
	while( result != NOT_FOUND )
	{
		int button;
		int bind;
		int dID;

		cfg->Read( "device", result, device );
		cfg->Read( "button", button, NULL );
		cfg->Read( "address", bind, NULL );

		sscanf( device, "%li-%li-%li-%li", &devl[0], &devl[1], &devl[2], &devl[3] );

		dev = m_Devices;
		dID = 0;

		while( dev != NULL ) //&& dev->m_GUID != guid )
		{
			dID++;
			dev = dev->m_Next;
		}

		if( dev == NULL )
		{
			dID = -1;
		}

		map = m_Map;

		while( map != NULL )
		{
			if( map->bind == bind )
			{
				map->Device = dID;
				map->Button = button;
				break ;
			}

			map = map->m_Next;
		}

		result = cfg->Seek( NULL );
	}
#endif
}

BOOL CALLBACK InputCfgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
#if 0
	InputHandle *input = (InputHandle*) GetWindowLongPtr( hDlg, GWLP_USERDATA );

	switch( message )
	{
	case WM_INITDIALOG:
		{
			input = (InputHandle*) lParam;

			if( input->m_ConfigWnd != NULL )
			{
				EndDialog( hDlg, 0 );
				return true;
			}

			InputDevice *dev = input->m_Devices;
			InputMap *map = input->m_Map;

			HWND list;
			int idx, device, rumble = -1;

			SetWindowLongPtr( hDlg, GWLP_USERDATA, (LONG_PTR) lParam );

			list = GetDlgItem( hDlg, IDC_RUMBLE );

			idx = SendMessage( list, CB_ADDSTRING, NULL, (LPARAM) "No rumble" );
			SendMessage( list, CB_SETITEMDATA, idx, -1 );
			device = 0;

			while( dev != NULL )
			{
				if( dev->m_Rumble )
				{
					idx = SendMessage( list, CB_ADDSTRING, NULL, (LPARAM) dev->m_Name );
					SendMessage( list, CB_SETITEMDATA, idx, device );

					if( input->m_RumbleDev == device )
					{
						rumble = device;
					}
				}
				device++;

				dev = dev->m_Next;
			}

			SendMessage( list, CB_SETCURSEL, rumble, 0 );

			list = GetDlgItem( hDlg, IDC_BIND );

			if( map != NULL && map->Device >= 0 )
			{
				char output[32];
				sprintf( output, "%i:%i", map->Device, map->Button );
				SetDlgItemText( hDlg, IDC_DEVICE, output );
			}
			else
			{
				SetDlgItemText( hDlg, IDC_DEVICE, "---" );
			}

			while( map != NULL )
			{
				idx = SendMessage( list, LB_ADDSTRING, NULL, (LPARAM) map->name );
				SendMessage( list, LB_SETITEMDATA, idx, map->bind );
				map = map->m_Next;
			}

			SendMessage( list, LB_SETCURSEL, 0, 0 );
		}		
		return true;
	case WM_COMMAND:
		switch( LOWORD( wParam ) )
		{
		case IDC_RUMBLE:
			if( HIWORD( wParam ) == LBN_SELCHANGE )
			{
				HWND item = GetDlgItem( hDlg, IDC_RUMBLE );
				int idx;
				idx = SendMessage( item, CB_GETCURSEL, 0, 0 );
				idx = SendMessage( item, CB_GETITEMDATA, idx, 0 );
				input->SetRumble( idx );
				input->Rumble( true );
				SetTimer( hDlg, NULL, 1000, NULL );
			}
			return true;
		case IDC_BIND:
			if( HIWORD( wParam ) == LBN_SELCHANGE )
			{
				HWND item = GetDlgItem( hDlg, IDC_BIND );
				InputMap *map = input->m_Map;
				int idx;

				idx = SendMessage( item, LB_GETCURSEL, 0, 0 );
				idx = SendMessage( item, LB_GETITEMDATA, idx, 0 );

				while( map != NULL && map->bind != idx )
				{
					map = map->m_Next;
				}

				if( map == NULL )
				{
					return true;
				}

				if( map->Device >= 0 )
				{
					char output[32];
					sprintf( output, "%i:%i", map->Device, map->Button );
					SetDlgItemText( hDlg, IDC_DEVICE, output );
				}
				else
				{
					SetDlgItemText( hDlg, IDC_DEVICE, "---" );
				}
			}
			return true;
		case IDOK:
			input->m_Listen = false;
			input->m_ConfigWnd = NULL;
			EndDialog( hDlg, 0 );
			return true;
		case IDC_ABORT:
			input->m_Listen = false;
			return true;
		case IDC_CLEAR:
			{
				HWND item = GetDlgItem( hDlg, IDC_BIND );
				int idx;
				idx = SendMessage( item, LB_GETCURSEL, 0, 0 );
				idx = SendMessage( item, LB_GETITEMDATA, idx, 0 );

				input->Bind( idx, -1, 0 );
				SetDlgItemText( hDlg, IDC_DEVICE, "---" );
			}
			return true;
		case ID_MAP:
			input->m_Listen = true;
			return true;
		}
		return true;
	case WM_TIMER:
		input->Rumble( false );
		KillTimer( hDlg, NULL );
		return true;
	case WM_CLOSE:
		input->m_Listen = false;
		input->m_ConfigWnd = NULL;
		EndDialog( hDlg, 0 );
		return true;
	case WM_INPUTHIT:
		{
			HWND item = GetDlgItem( hDlg, IDC_BIND );
			InputMap *map = input->m_Map;
			int idx;
			char output[32];

			idx = SendMessage( item, LB_GETCURSEL, 0, 0 );
			idx = SendMessage( item, LB_GETITEMDATA, idx, 0 );

			input->Bind( idx, wParam, lParam );

			sprintf( output, "%i:%i", wParam, lParam );
			SetDlgItemText( hDlg, IDC_DEVICE, output );

			input->m_Listen = false;
		}
		return true;
	}
#endif
	return false;
}

void InputHandle::Configure()
{
#if 0
	if( m_ConfigWnd == NULL )
	{
		m_ConfigWnd = CreateDialogParam( g_hInstance, MAKEINTRESOURCE( IDD_CFGINPUT ), m_hWnd, InputCfgProc, (LPARAM) this );	
		ShowWindow( m_ConfigWnd, SW_SHOW );
	}
#endif
}

void InputHandle::Register( char* name )
{
	InputDevice *dev;

	if( m_Devices == NULL )
	{
		m_Devices = dev = new InputDevice;
	}
	else
	{
		dev = m_Devices;
		while ( m_Devices->m_Next != NULL )
		{
			m_Devices = m_Devices->m_Next;
		}

		dev = m_Devices->m_Next = new InputDevice;
	}

	dev->m_Next = NULL;

#if 0
	// TODO: Add error checking here...
	lpDI->CreateDevice( diGUID, &dev->m_Device, NULL );

	if( diGUID != GUID_SysKeyboard )
	{
		dev->m_Device->SetDataFormat(&c_dfDIJoystick);
	}
	else
	{
		dev->m_Device->SetDataFormat(&c_dfDIKeyboard);
	}
#endif

	strcpy( dev->m_Name, name );
#if 0
	dev->m_Device->SetCooperativeLevel( m_hWnd, DISCL_BACKGROUND | DISCL_EXCLUSIVE );
	dev->m_Device->Acquire();
	dev->m_GUID = diGUID;
#endif
	dev->m_Rumble = false;
	ZeroMemory( dev->m_Buttons, sizeof(dev->m_Buttons) );
}

void InputHandle::SetRumble( int device )
{
#if 0
	InputDevice *dev = m_Devices;
	char guid[44];
	int result;

	for( int i = device; i > 0; i-- )
	{
		if ( dev == NULL )
			break ;

		dev = dev->m_Next;
	}
	
	if( dev != NULL && i == 0 )
	{
		//long *devl = (long*)&dev->m_GUID;
		//sprintf( guid, "%li-%li-%li-%li", devl[0], devl[1], devl[2], devl[3] );
		m_RumbleDev = device;
	}
	else
	{
		strcpy( guid, "0-0-0-0" );
		m_RumbleDev = -1;
	}

	CreateRumble();

	result = m_Cfg->Seek("config.input.rumble");

	if( result != NOT_FOUND )
	{
		m_Cfg->Write( "device", guid );
		return ;
	}

	m_Cfg->Create( "config.input.rumble" );
	m_Cfg->Write( "device", guid );
#endif
}

void InputHandle::Bind( int address, int device, int button )
{
#if 0
	InputMap *map = m_Map;
	InputDevice *dev = m_Devices;
	int result;
	char guid[44];

	while( map != NULL )
	{
		if( map->bind == address )
		{
			map->Device = device;
			map->Button = button;
			break ;
		}

		map = map->m_Next;
	}
	
	if( map == NULL )
	{
		return ;
	}

	for( int i = device; i > 0; i-- )
	{
		if ( dev == NULL )
			break ;

		dev = dev->m_Next;
	}
	
	if( dev != NULL && i == 0 )
	{
		//long *devl = (long*)&dev->m_GUID;
		//sprintf( guid, "%li-%li-%li-%li", devl[0], devl[1], devl[2], devl[3] );
	}
	else
	{
		strcpy( guid, "0-0-0-0" );
	}
		strcpy( guid, "0-0-0-0" );

	result = m_Cfg->Seek("config.input.bind");

	while( result != NOT_FOUND )
	{
		int bind;

		m_Cfg->Read( "address", bind, NULL );

		if( bind == address )
		{
			m_Cfg->Write( "button", button );
			m_Cfg->Write( "device", guid );
			return ;
		}

		result = m_Cfg->Seek( NULL );
	}

	m_Cfg->Create( "config.input.bind" );
	m_Cfg->Write( "address", address );
	m_Cfg->Write( "button", button );
	m_Cfg->Write( "device", guid );
#endif
}

#define slider( buttons, button, value ) { buttons[button]=(value>0x9000)?0x80:0; buttons[button+1]=(value<0x7000)?0x80:0; }

void InputHandle::Process( bool broadcast )
{
#if 0
	InputDevice *dev = m_Devices;
	DIJOYSTATE js;
		
	BYTE buttons[256];

	ZeroMemory( buttons, sizeof(buttons) );

	int device = 0;
	if( dev != NULL )
	{		
		dev->m_Device->Poll();
		dev->m_Device->GetDeviceState( sizeof(unsigned char[256]), &buttons );
		
		for( int button = 0; button < sizeof( dev->m_Buttons ); button++ )
		{
			if( dev->m_Buttons[button] != buttons[button] )
			{
				dev->m_Buttons[button] = buttons[button];
				
				InputMap *map = m_Map;

				while( map != NULL )
				{
					if( map->Device == device && map->Button == button && broadcast )
					{
						SendMessage( 
							m_hWnd, 
							WM_COMMAND,
							(buttons[button]&0x80)?map->press:map->release, 
							map->lParam );
					}
					if( m_Listen && m_ConfigWnd != NULL )
					{
						SendMessage( m_ConfigWnd, WM_INPUTHIT, device, button );
						m_Listen = false;
					}

					map = map->m_Next;
				}
			}			
		}

		memcpy( dev->m_Buttons, buttons, sizeof( dev->m_Buttons ) );
		dev = dev->m_Next;
		device++;
	}

	while( dev != NULL )
	{
		dev->m_Device->Poll();
		dev->m_Device->GetDeviceState( sizeof(DIJOYSTATE), &js );

		memcpy( buttons, js.rgbButtons, 32 );
		slider( buttons, 128, js.lX );
		slider( buttons, 130, js.lY );
		slider( buttons, 132, js.lZ );
		slider( buttons, 134, js.lRx );
		slider( buttons, 136, js.lRy );
		slider( buttons, 138, js.lRz );

		if( (signed) js.rgdwPOV[0] >= 0 )
		{
			int angle = (js.rgdwPOV[0] / 4500) % 8;
			buttons[33] = ( angle == 7 || angle <= 1 ) ? 0x80 : 0x00;
			buttons[34] = ( angle >= 1 && angle <= 3 ) ? 0x80 : 0x00;
			buttons[35] = ( angle >= 3 && angle <= 5 ) ? 0x80 : 0x00;
			buttons[36] = ( angle >= 5 && angle <= 7 ) ? 0x80 : 0x00;
		}
		else
		{
			buttons[33] = 0;
			buttons[34] = 0;
			buttons[35] = 0;
			buttons[36] = 0;
		}

		for( int button = 0; button < sizeof( dev->m_Buttons ); button++ )
		{
			if( dev->m_Buttons[button] != buttons[button] )
			{
				dev->m_Buttons[button] = buttons[button];
				
				InputMap *map = m_Map;

				while( map != NULL )
				{
					if( map->Device == device && map->Button == button )
					{
						SendMessage( 
							m_hWnd, 
							WM_COMMAND,
							(buttons[button]&0x80)?map->press:map->release, 
							map->lParam );
					}
					if( m_Listen && m_ConfigWnd != NULL )
					{
						SendMessage( m_ConfigWnd, WM_INPUTHIT, device, button );
					}

					map = map->m_Next;
				}
			}
		}

		memcpy( dev->m_Buttons, buttons, sizeof(dev->m_Buttons) );		
		dev = dev->m_Next;
		device++;
	}
#endif
}

void InputHandle::CreateRumble( )
{
#if 0
	if( lpDIE != NULL )
	{
		lpDIE->Stop();
		lpDIE->Release();		
		lpDIE = NULL;
	}

	if( m_RumbleDev >= 0 )
	{
		InputDevice *dev = m_Devices;

		for( int i = m_RumbleDev; i > 0; i-- )
		{
			if( dev == NULL )
				return ;

			dev = dev->m_Next;
		}

		DIEFFECT eff;
		DWORD           rgdwAxes     = DIJOFS_X;
		LONG            rglDirection = 0;
		DICONSTANTFORCE cf           = { 10000 };

		ZeroMemory( &eff, sizeof(eff) );
		eff.dwSize                  = sizeof(DIEFFECT);
		eff.dwFlags                 = DIEFF_CARTESIAN | DIEFF_OBJECTOFFSETS;
		eff.dwDuration              = INFINITE;
		eff.dwSamplePeriod          = 0;
		eff.dwGain                  = DI_FFNOMINALMAX;
		eff.dwTriggerButton         = DIEB_NOTRIGGER;
		eff.dwTriggerRepeatInterval = 0;
		eff.cAxes                   = 1;
		eff.rgdwAxes                = &rgdwAxes;
		eff.rglDirection            = &rglDirection;
		eff.lpEnvelope              = 0;
		eff.cbTypeSpecificParams    = sizeof(DICONSTANTFORCE);
		eff.lpvTypeSpecificParams   = &cf;
		eff.dwStartDelay            = 0;		

		int res = dev->m_Device->CreateEffect( GUID_ConstantForce, &eff, &lpDIE, NULL );
	}
#endif
}

void InputHandle::Rumble( bool enable )
{
#if 0
	if( lpDIE != NULL )
	{
		if( enable )
		{
			lpDIE->Start( 1, 0 );
		}
		else
		{
			lpDIE->Stop();
		}
	}
#endif
}