/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "minimon.h"

static const char *m_UpdateHost = "www.sublab.net";
static const char *m_VersionFile = "/minimon/minimon.version";
static const char *m_ExecutableFile = "/minimon/minimon_update.exe";

DWORD WINAPI ThreadProc( LPVOID lpParameter )
{
	AutoUpdater *updater = (AutoUpdater *) lpParameter;
	
	updater->Thread();
	
	return 0;
}

char *AutoUpdater::GetHTTP( SOCKADDR_IN *addr, const char *file, long &size )
{
	char request[2048];
	SOCKET sock;
	char *data, *loadBuffer;
	int nret;
	
	sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );

	connect( sock, (LPSOCKADDR) addr, sizeof( SOCKADDR_IN ) );

	if( sock == INVALID_SOCKET )
	{
		return NULL;
	}

	sprintf( request, "GET %s HTTP/1.1\r\nHost: %s\r\n\r\n", file, m_UpdateHost );

	nret = send( sock, request, strlen(request), 0 );

	if( nret == SOCKET_ERROR )
	{
		closesocket(sock);
		return NULL ;
	}

	nret = recv( sock, request, sizeof(request), 0 );

	if( nret <= 0 )
	{
		closesocket(sock);
		return NULL;
	}

	// Parse header
	char *token = strtok( request, "\n" );
	long dataSize = -1;

	while( token != NULL )
	{
		int tmpret = strncmp( "Content-Length", token, 14 );
		if( *token == '\r' )
		{
			break ;
		}
		else if( strncmp( "Content-Length", token, 14 ) == 0 )
		{
			sscanf( token, "Content-Length: %i", &dataSize );
		}

		token = strtok( NULL, "\n" );
	}

	token += 2;

	if( dataSize == -1 )
	{
		closesocket( sock );
		return NULL;
	}

	loadBuffer = data = new char[dataSize+1];
	data[dataSize] = 0;
	size = dataSize;

	int copySize = nret - (token - request);

	// Copy preexisting data...
	memcpy( data, token, copySize );
	dataSize -= copySize;
	loadBuffer += copySize;

	while ( dataSize > 0 )
	{
		nret = recv( sock, loadBuffer, dataSize, 0 );

		if( nret < 0 )
		{
			delete data;
			closesocket(sock);
			return NULL;			
		}

		loadBuffer += nret;
		dataSize -= nret;
	}

	closesocket( sock );
	return data;
}

bool AutoUpdater::Thread()
{
	SOCKADDR_IN sockaddr;
	LPHOSTENT hostEntry;

	hostEntry = gethostbyname(m_UpdateHost);

	if( hostEntry == NULL )
	{
		return true;
	}

	sockaddr.sin_family = AF_INET;
	sockaddr.sin_addr = *((LPIN_ADDR)*hostEntry->h_addr_list);
	sockaddr.sin_port = htons( HTTP_PORT );

	// Check version
	long size;

	char *versionRecv = GetHTTP( &sockaddr, m_VersionFile, size );
	char *token;
	long version;
	long latestVersion = 0;

	if( versionRecv == NULL )
	{
		m_ThreadHandle = NULL;
		return false;
	}

	char *output = new char[size+2048];
	token = strtok( versionRecv, "#" );
	*output = 0;

	while( token != NULL )
	{
		sscanf( token, "%8x", &version );

		if( version <= MINIMON_VERSION )
		{
			break ;
		}
		else if( version > latestVersion )
		{
			latestVersion = version;
		}

		strcat( output, token + 8 );
		token = strtok( NULL, "#" );
	}

	if( latestVersion == 0 )
	{
		m_ThreadHandle = NULL;
		delete versionRecv;
		delete output;
		return false;
	}

	sprintf( versionRecv, "Version %4x:%2x:%2x%c is available for download\n\r\n\r%s\n\rWould you like to update to this version?", 
		((latestVersion >> 24) & 0xFF) + 0x2000,
		(latestVersion >> 16) & 0xFF,
		(latestVersion >>  8) & 0xFF,
		((latestVersion & 0xFF) > 0) ? ((version & 0xFF) + 'a' - 1) : ' ',
		output );

	// Ask if we really want to update
	
	if( MessageBox( NULL, versionRecv, g_AppTitle, MB_YESNO ) == IDYES )
	{
		// Download update if nessessary
		char *exec = GetHTTP( &sockaddr, m_ExecutableFile, size );

		if( exec != NULL )
		{
			FILE *outFile = fopen( m_AppFileName, "wb" );

			if( outFile != NULL )
			{
				fwrite( exec, size, 1, outFile );
				fclose(outFile);
				
				MessageBox( NULL, "Minimon has finished downloading the update.\n\nMinimon will now execute the update, reboot when it is complete", g_AppTitle, MB_OK );

				char path[MAX_PATH], *file = path;
				strcpy(path, m_AppFileName);
				file += strlen(m_AppFileName);
				while(*(file-1) != '\\') file--;
				*file = 0;

			    STARTUPINFO si;
				PROCESS_INFORMATION pi;

				ZeroMemory( &si, sizeof(si) );
				si.cb = sizeof(si);
				ZeroMemory( &pi, sizeof(pi) );

				CreateProcess( m_AppFileName, NULL, NULL, NULL, false, 0, NULL, path, &si, &pi );
				exit(0);
			}
			else
			{
				MessageBox( NULL, "Failed to write file", g_AppTitle, MB_OK );
			}

			delete exec;
		}
	}

	delete versionRecv;
	delete output;

	m_ThreadHandle = NULL;
	return false;
}

void AutoUpdater::Update()
{
	m_ThreadHandle = CreateThread( NULL, 0, ThreadProc, this, 0, &m_ThreadID );	
}

AutoUpdater::AutoUpdater( char *appFileName )
{
	WORD sockVersion;
	WSADATA wsaData;

	sockVersion = MAKEWORD(1, 1);
	WSAStartup(sockVersion, &wsaData);

	strcpy(m_AppFileName, appFileName);
	
	appFileName = m_AppFileName + strlen(m_AppFileName) - 4;
	strcpy( appFileName, "_update.exe" );

	m_ThreadHandle = NULL;
}

AutoUpdater::~AutoUpdater()
{	
	while( m_ThreadHandle != NULL )
	{
		Sleep(100);
	}
	WSACleanup();
}


