/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __EEPROM_H
#define __EEPROM_H

enum EEPROMModes
{
	EEPROM_IDLE,
	EEPROM_WRITE_CONTROL,
	EEPROM_WRITE_ADDRESS_HI,
	EEPROM_WRITE_ADDRESS_LO,
	EEPROM_WRITE_BYTE,
	EEPROM_READ_BYTE
};

class EEPROM
{
public:
	EEPROM::EEPROM();
	EEPROM::~EEPROM();
	void EEPROM::Load( const char *romName );

	void EEPROM::HardWrite( unsigned short address, unsigned char byte );
	unsigned char EEPROM::HardRead( unsigned short address );
	void EEPROM::Clock( bool clock );
	void EEPROM::Write( bool din );
	bool EEPROM::Read();
private:
	bool m_ClockBit;
	bool m_DataBit;
	bool m_Scanning;
	bool m_DataLoaded;

	unsigned char m_ReadData;
	
	int m_Address;
	int m_Mode;
	int m_Bit;

	char m_DataStore[1024];
	unsigned char m_Rom[0x2000];
};

#endif