/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __CPUCORE_H
#define __CPUCORE_H

#ifdef EXPORT
unsigned char CycleTable[0x300] = {
//  00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F
	 8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,   // 0x00
     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,   // 0x10
     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,   // 0x20
     8, 8, 8, 8,12,16, 8, 8, 8, 8, 8, 8,12,16, 8, 8,   // 0x30
     4, 4, 4, 4,12, 8, 8, 8, 4, 4, 4, 4,12, 8, 8, 8,   // 0x40
     4, 4, 4, 4,12, 8, 8, 8, 4, 4, 4, 4,12, 8, 8, 8,   // 0x50
     8, 8, 8, 8,16,12,12,12, 8, 8, 8, 8,16,12,12,12,   // 0x60
     8, 8, 8, 8,16,12,12,12,12,12,12,12,32,16,16,16,   // 0x70
     8, 8, 8, 8, 8,16,12, 8, 8, 8, 8, 8, 8,16,12, 8,   // 0x80

     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0x90
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xA0
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xB0
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xC0
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xD0
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xE0
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,   // 0xF0

	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE00
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE10
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE20
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE30
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE40
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE50
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE60
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE70
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE80
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCE90
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCEA0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCEB0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCEC0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCED0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCEE0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCEF0

	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF00
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF10
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF20
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF30
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF40
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF50
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF60
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF70
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF80
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCF90
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFA0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFB0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFC0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFD0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFE0
	  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,   // 0xCFF0
	};

#else
extern unsigned char CycleTable[0x300];
#endif


union RegSet
{
	struct
	{
		unsigned char	A, B, IndexN, N;
		unsigned char	L, H, I, HZ;

		unsigned char	XL, XH, XI, XZ;
		unsigned char	YL, YH, YI, YZ;

		unsigned short  PC;
		unsigned short  SP;

		unsigned char   E, F, U, V;
	} byte;

	struct
	{
		unsigned short	BA, N;
		unsigned short	HL, I;
		unsigned short	X, XI;
		unsigned short	Y, YI;

		unsigned short  PC;
		unsigned short  SP;

		unsigned char   E, F, U, V;
	} word;

	struct 
	{
		unsigned short	BA, N;

		unsigned long	HLA;
		unsigned long	XA;
		unsigned long	YA;

		unsigned short  PC;
		unsigned short  SP;

		unsigned char   E, F, U, V;
	} addr;
} ;

typedef void (*cpuCode)( RegSet & );

class MinxCore
{
public:
	MinxCore::MinxCore();
	MinxCore::~MinxCore();

	virtual void MinxCore::Error( const char *error, int errc, int *errv );

	void MinxCore::Add( unsigned char &left, unsigned char right, bool carry );
	void MinxCore::Add( unsigned short &left, unsigned short right, bool carry );
	void MinxCore::Sub( unsigned char &left, unsigned char right, bool carry );
	void MinxCore::Sub( unsigned short &left, unsigned short right, bool carry );

	void MinxCore::LoadBios( const char *bios );
	void MinxCore::LoadRom( const char *filename );
	void MinxCore::FreeRom();

	void MinxCore::Flag( int flag, bool set );
	void MinxCore::Flags8( int flagMask, int value );
	void MinxCore::Flags16( int flagMask, int value );

	void MinxCore::Fetch( unsigned char &value );
	void MinxCore::Fetch( unsigned short &value );

	virtual void MinxCore::LogRead( long addr ) {}
	virtual void MinxCore::LogWrite( long addr ) {}
	virtual void MinxCore::LogBranch( long addr ) {}
	virtual void MinxCore::PokeReg( unsigned char reg, unsigned char value ) {}
	virtual void MinxCore::PeekReg( unsigned char reg, unsigned char &value ) {}

	virtual int MinxCore::PredictIRQ( int maxCycles ) { return maxCycles; }
	virtual void MinxCore::Clock( int cycles ) {}

	void MinxCore::Peek( long addr, unsigned char &value );
	void MinxCore::Peek( long addr, unsigned short &value );
	void MinxCore::Poke( long addr, unsigned char value );
	void MinxCore::Poke( long addr, unsigned short value );
	void MinxCore::Push( unsigned char value );
	void MinxCore::Push( unsigned short value );
	void MinxCore::Pop( unsigned char &value );
	void MinxCore::Pop( unsigned short &value );
	
	void MinxCore::ForceIRQ( unsigned char IRQ );

	void MinxCore::ExecCode();
	void MinxCore::ExecCodeCE();
	void MinxCore::ExecCodeCF();

	RegSet m_CpuReg;
	unsigned char *m_Rom;
	unsigned char m_Bios[0x1000];
	unsigned char m_Ram[0x1000];
	
	bool m_Halted;

	long m_RomSize;
	long m_RomMask;
	long m_Clock;
};

enum FlagMask
{
	FLAG_ZERO     = 0x01,
	FLAG_CARRY    = 0x02,
	FLAG_OVERFLOW = 0x04,
	FLAG_SIGN     = 0x08,

	FLAG_BCD      = 0x10,
	FLAG_MASKLOW  = 0x20,
	FLAG_IE       = 0x80
};

#endif