#define DEBUG_KEYBOARD
#include "keyboard_api.h"
#include "types.h"
#include "vdc.h"

#define KEY_0 '0'
#define KEY_1 '1'
#define KEY_2 '2'
#define KEY_3 '3'
#define KEY_4 '4'
#define KEY_5 '5'
#define KEY_6 '6'
#define KEY_7 '7'
#define KEY_8 '8'
#define KEY_9 '9'
#define KEY_SPACE VK_SPACE
#define KEY_SLASH VK_OEM_2
#define KEY_L 'L'
#define KEY_P 'P'
#define KEY_PLUS_PAD VK_ADD
#define KEY_W 'W'
#define KEY_E 'E'
#define KEY_R 'R'
#define KEY_T 'T'
#define KEY_U 'U'
#define KEY_I 'I'
#define KEY_O 'O'
#define KEY_Q 'Q'
#define KEY_S 'S'
#define KEY_D 'D'
#define KEY_F 'F'
#define KEY_G 'G'
#define KEY_H 'H'
#define KEY_J 'J'
#define KEY_K 'K'
#define KEY_A 'A'
#define KEY_Z 'Z'
#define KEY_X 'X'
#define KEY_C 'C'
#define KEY_V 'V'
#define KEY_B 'B'
#define KEY_M 'M'
#define KEY_STOP VK_ESCAPE
#define KEY_MINUS VK_SUBTRACT
#define KEY_ASTERISK VK_MULTIPLY
#define KEY_SLASH_PAD VK_DIVIDE
#define KEY_EQUALS VK_OEM_PLUS
#define KEY_Y 'Y'
#define KEY_N 'N'
#define KEY_DEL VK_DELETE
#define KEY_ENTER VK_RETURN


typedef struct AUDIOSTREAM_struct
{
	int dummy ;
} AUDIOSTREAM ;


typedef struct RGB
{
   unsigned char r, g, b;
   unsigned char filler;
} RGB;

#define PAL_SIZE     256

typedef RGB PALETTE[PAL_SIZE];

typedef struct BITMAP            /* a bitmap structure */
{
   int w, h;                     /* width and height in pixels */
   //int clip;                     /* flag if clipping is turned on */
   //int cl, cr, ct, cb;           /* clip left, right, top and bottom values */
//   GFX_VTABLE *vtable;           /* drawing functions */
   //void *write_bank;             /* C func on some machines, asm on i386 */
   //void *read_bank;              /* C func on some machines, asm on i386 */
   unsigned char dat[BMPW*BMPH];                    /* the memory we allocated for the bitmap */
   //unsigned long id;             /* for identifying sub-bitmaps */
   //void *extra;                  /* points to a structure with more info */
   //int x_ofs;                    /* horizontal offset (for sub-bitmaps) */
   //int y_ofs;                    /* vertical offset (for sub-bitmaps) */
   //int seg;                      /* bitmap segment */
   unsigned char *line[400];
} BITMAP;


typedef struct SAMPLE                  /* a sample */
{
   int bits;                           /* 8 or 16 */
   int stereo;                         /* sample type flag */
   int freq;                           /* sample frequency */
   int priority;                       /* 0-255 */
   unsigned long len;                  /* length (in samples) */
   unsigned long loop_start;           /* loop start position */
   unsigned long loop_end;             /* loop finish position */
   unsigned long param;                /* for internal use by the driver */
   void *data;                         /* sample data */
} SAMPLE;
