#include <stdio.h>
#include <xtl.h>
#include "z80.h"
#include "Cpu_Z80.h"
#include "Mem_M68K.h"
#include "Mem_Z80.h"


UINT32 FASTCALL z80_Set_IN(Z80_CONTEXT *z80, Z80_RB *Func);
UINT32 FASTCALL z80_Set_OUT(Z80_CONTEXT *z80, Z80_WB *Func);

/*** Z80_Reset - reset z80 sub-unit ***/

//typedef UINT8 FASTCALL Z80_RB(UINT32 adr);
//typedef void FASTCALL Z80_WB(UINT32 adr, UINT8 data);
//	Z80_RB *IN_C;
	//Z80_WB *OUT_C;

Z80_RB *origIN ;
Z80_WB *origOUT ;
Z80_RB *lookIN ;
Z80_WB *lookOUT ;


void FASTCALL myOUT(UINT32 adr, UINT8 data)
{
	origOUT( adr, data ) ;
}

UINT32 FASTCALL myIN(UINT32 adr)
{
	return origIN( adr ) ;
}

void Z80_Reset(void)
{
	// Reset Z80

	memset(Ram_Z80, 0, 8 * 1024);

//	Bank_Z80 = 0x000000;
	Bank_Z80 = 0xFF8000;

	Z80_State &= 1;
//	Z80_State |= 2;		// RZWL needs it but Breath of Fire 3 don't want it...

	Last_BUS_REQ_Cnt = 0;
	Last_BUS_REQ_St = 0;

	z80_Reset(&M_Z80);
}

/*** Z80_Init - initialise this sub-unit ***/

int Z80_Init(void)
{
	// Init Z80

	z80_Init(&M_Z80);

	z80_Add_Fetch(&M_Z80, 0x00, 0x1F, &Ram_Z80[0]);
	z80_Add_Fetch(&M_Z80, 0x20, 0x3F, &Ram_Z80[0]);
	
	z80_Add_ReadB(&M_Z80, 0x00, 0xFF, Z80_ReadB_Bad);
	z80_Add_ReadB(&M_Z80, 0x00, 0x3F, Z80_ReadB_Ram);
	z80_Add_ReadB(&M_Z80, 0x40, 0x5F, Z80_ReadB_YM2612);
	z80_Add_ReadB(&M_Z80, 0x60, 0x6F, Z80_ReadB_Bank);
	z80_Add_ReadB(&M_Z80, 0x70, 0x7F, Z80_ReadB_PSG);
	z80_Add_ReadB(&M_Z80, 0x80, 0xFF, Z80_ReadB_68K_Ram);

	z80_Add_ReadW(&M_Z80, 0x00, 0xFF, Z80_ReadW_Bad);
	z80_Add_ReadW(&M_Z80, 0x00, 0x3F, Z80_ReadW_Ram);
	z80_Add_ReadW(&M_Z80, 0x40, 0x5F, Z80_ReadW_YM2612);
	z80_Add_ReadW(&M_Z80, 0x60, 0x6F, Z80_ReadW_Bank);
	z80_Add_ReadW(&M_Z80, 0x70, 0x7F, Z80_ReadW_PSG);
	z80_Add_ReadW(&M_Z80, 0x80, 0xFF, Z80_ReadW_68K_Ram);
	
	z80_Add_WriteB(&M_Z80, 0x00, 0xFF, Z80_WriteB_Bad);
	z80_Add_WriteB(&M_Z80, 0x00, 0x3F, Z80_WriteB_Ram);
	z80_Add_WriteB(&M_Z80, 0x40, 0x5F, Z80_WriteB_YM2612);
	z80_Add_WriteB(&M_Z80, 0x60, 0x6F, Z80_WriteB_Bank);
	z80_Add_WriteB(&M_Z80, 0x70, 0x7F, Z80_WriteB_PSG);
	z80_Add_WriteB(&M_Z80, 0x80, 0xFF, Z80_WriteB_68K_Ram);

	z80_Add_WriteW(&M_Z80, 0x00, 0xFF, Z80_WriteW_Bad);
	z80_Add_WriteW(&M_Z80, 0x00, 0x3F, Z80_WriteW_Ram);
	z80_Add_WriteW(&M_Z80, 0x40, 0x5F, Z80_WriteW_YM2612);
	z80_Add_WriteW(&M_Z80, 0x60, 0x6F, Z80_WriteW_Bank);
	z80_Add_WriteW(&M_Z80, 0x70, 0x7F, Z80_WriteW_PSG);
	z80_Add_WriteW(&M_Z80, 0x80, 0xFF, Z80_WriteW_68K_Ram);

	//lightgun
	//origOUT = M_Z80.OUT_C ;
	//origIN = M_Z80.IN_C ;

	//z80_Set_IN( &M_Z80, myIN ) ;
	//z80_Set_OUT( &M_Z80, myOUT ) ;

	//lookOUT = M_Z80.OUT_C ;
	//lookIN = M_Z80.IN_C ;

	//lightgun end

	Z80_Reset();

	return 1;
}



#include "cd_sys.h"


void Write_To_Bank(int val)
{
#ifdef DEBUG_CD
	fprintf(debug_SCD_file, "Z80 write bank : %d     Bank = %.8X\n", val, Bank_Z80);
#endif
}

void Read_To_68K_Space(int adr)
{
#ifdef DEBUG_CD
	fprintf(debug_SCD_file, "Z80 read in 68K space : $(%.8X)\n", adr);
#endif
}

void Write_To_68K_Space(int adr, int data)
{
#ifdef DEBUG_CD
	fprintf(debug_SCD_file, "Z80 write in 68K space : $(%.8X) = %.8X\n", adr, data);
#endif
}
