#include "mapinc.h"

static uint32 regchr[9];

static uint8 IRQa , lastV;
static int32 IRQCount, IRQLatch ;
static uint32 lastA ;

static void VROM_BANK1(uint32 A,uint32 V)
{
 setchr1(A,V);
 //CHRBankList[(A)>>10]=V;
}

static void ROM_BANK8(uint32 A, uint32 V)
{
 setprg8(A,V);
 //if(A>=0x8000)
  //PRGBankList[((A-0x8000)>>13)]=V;
}

static DECLFW(Mapper27_write)
{
	lastA = A ;
	lastV = V ;
 A&=0xF00F;
 int regnum;
 if((A>=0xB000) && (A<=0xE003)) {
    regnum=((((A>>12)+1)&0x03)<<1)|((A&0x02)>>1);
    if(A&1)
       regchr[regnum]=(regchr[regnum]&0x0F)|(V<<4);
    else
       regchr[regnum]=(regchr[regnum]&0xFF0)|(V&0xF);
    VROM_BANK1(regnum<<10,regchr[regnum]);
 }
 switch(A)
 {
  case 0x8000: if(regchr[8]&2)
                  ROM_BANK8(0xc000,V);
               else
                  ROM_BANK8(0x8000,V);
               break;
  case 0xA000: ROM_BANK8(0xa000,V); break;
  case 0x9000:
               switch(V&3){
                  case 0:setmirror(MI_V);break;
                  case 1:setmirror(MI_H);break;
                  case 2:setmirror(MI_0);break;
                  case 3:setmirror(MI_1);break;
               }
  case 0x9002: regchr[8]=V; break;
  case 0xF000: //X6502_IRQEnd(FCEU_IQEXT);
               IRQLatch=(IRQLatch&0xF0)|(V&0x0F);
                           break;
  case 0xF001: //X6502_IRQEnd(FCEU_IQEXT);
               IRQLatch=(IRQLatch&0x0F)|((V&0xF)<<4);
                           break;
  case 0xF003: IRQa=((IRQa&0x1)<<1)|(IRQa&0x1);
                           X6502_IRQEnd(MDFN_IQEXT);
               break;
  case 0xF002: IRQa=V&3;
                           if(IRQa&0x02) IRQCount=IRQLatch;
                           X6502_IRQEnd(MDFN_IQEXT);
                           break;
 }
// if((A&0xF000)==0xF000) FCEU_printf("$%04x:$%02x, %d\n",A,V, scanline);
}

static void Mapper27_hb(void)
{
//   FCEU_printf("%02x-%d,%d,%d\n",scanline,IRQa,IRQCount,IRQLatch);
        if(IRQa&0x2){
           if(IRQCount==0xFF){
             X6502_IRQBegin(MDFN_IQEXT);
              IRQCount=IRQLatch+1;
         } else {
           IRQCount++;
           }
        }
}
static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(IRQa),
  SFVAR(lastA),
  SFVAR(lastV),
  SFVAR(IRQCount),
  SFVAR(IRQLatch),
  SFARRAY32( regchr, 9),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper27_write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
  int i;
  for (i=0; i<9; i++) {
    regchr[i]=0;
  }
  IRQa=0;
  IRQCount=IRQLatch=0;
  lastA = 0 ;
  lastV = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
}

int Mapper27_Init(CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

  int i;
  for (i=0; i<9; i++) {
    regchr[i]=0;
  }
  IRQa=0;
  IRQCount=IRQLatch=0;
  lastA = 0 ;
  lastV = 0 ;


	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

  SetWriteHandler(0x8000,0xffff,Mapper27_write);
  GameHBIRQHook=Mapper27_hb;

  return 1 ;
}

