/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint32 lastA ;
static uint8 lastV ;


DECLFW(Mapper240_write)
{
	lastA = A ;
	lastV = V ;

	if ( ( A == 0x4800 ) || ( A == 0x4120 ) || ( A > 0x7FFF ) )
 //if(A<0x8000)
 {
  setprg32(0x8000, V>>4);
  setchr8(V&0xF);
 }
}

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFVAR(lastV),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper240_write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = lastV = 0 ;
}

int Mapper240_Init(CartInfo *info)
{
	info->Power = Power ;
	info->StateAction = StateAction;

	setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

  SetWriteHandler(0x4020,0x5fff,Mapper240_write);
  SetWriteHandler(0x8000,0xffff,Mapper240_write);

  return 1 ;
}

