void MDFN_DrawRectangle(uint32 *XBuf, int pitch, int xpos, int ypos, uint32 color, uint32 width, uint32 height)
{
 uint32 x;
 uint32 y;

 XBuf += pitch * ypos + xpos;
 /* Draw top and bottom horiz */
 for(x=0;x<width;x++)
 {
  XBuf[x] = color;
  XBuf[x + (height-1) * pitch] = color;
 }

 for(y=0;y<height;y++)
 {
  XBuf[y * pitch] = color;
  XBuf[y * pitch + width-1] = color;
 }
}

void MDFN_DrawRectangleAlpha(uint32 *XBuf, int pitch, int xpos, int ypos, uint32 color, uint32 width, uint32 height)
{
 uint32 x;
 uint32 y;

 XBuf += pitch * ypos + xpos;
 /* Draw top and bottom horiz */
 for(x=0;x<width;x++)
 {
  XBuf[x] = color;
  XBuf[x + (height-1) * pitch] = color;
 }

 for(y=0;y<height;y++)
 {
  XBuf[y * pitch] = color;
  XBuf[y * pitch + width-1] = color;
 }

 /* Now draw inner transparency area. */
 XBuf += 1 + 1 * pitch;

 for(y=0;y<height-2;y++)
  for(x=0;x<width-2;x++)
  {
   XBuf[y*pitch+x] = MK_COLORA(0x00, 0x00, 0x00, 0x80);
  }
}

void MDFN_DrawRectangleFill(uint32 *XBuf, int pitch, int xpos, int ypos, uint32 color, uint32 fillcolor, uint8 width, uint8 height)
{
 int x;
 int y;

 XBuf += pitch * ypos + xpos;
 /* Draw top and bottom horiz */
 for(x=0;x<width;x++)
 {
  XBuf[x] = color;
  XBuf[x + (height-1) * pitch] = color;
 }

 for(y=0;y<height;y++)
 {
  XBuf[y * pitch] = color;
  XBuf[y * pitch + width-1] = color;
 }

 /* Now draw innerarea. */
 XBuf += 1 + 1 * pitch;

 for(y=0;y<height-2;y++)
  for(x=0;x<width-2;x++)
  {
   XBuf[y*pitch+x] = fillcolor;
  }
}

void DrawTextLineBG(uint32 *dest, const MDFN_Rect *OSDRect)
{
 int x,y;
 uint32 pitch32 = OSDRect->w;

 for(y=0;y<14;y++)
  for(x=0;x<OSDRect->w;x++)
   dest[y * pitch32 + x] = MK_COLORA(0x00, 0x00, 0x00, 0x80);
}       

static bool DrawMessage(uint32 *fb, const MDFN_Rect *OSDRect)
{
 if(howlong < MDFND_GetTime())
 {
  if(CurrentMessage)
  {
   free(CurrentMessage);
   CurrentMessage = NULL;
  }
  return(0);
 }

 uint32 *t;
 uint32 pitch32 = OSDRect->w;

 t = fb + OSDRect->x + (OSDRect->y + OSDRect->h - 17) * pitch32;
 if(t < fb)
  t = fb;

 DrawTextLineBG(t, OSDRect);
 DrawTextTrans(t + 1 + pitch32, pitch32 << 2, OSDRect->w, CurrentMessage, MK_COLORA(0x00,0x00,0x00, 0xFF), 1);
 DrawTextTrans(t, pitch32 << 2,OSDRect->w, CurrentMessage, MK_COLORA(0xFF,0xFF,0xFF, 0xFF), 1);

 return(1);
}

void MDFN_DrawStateMovieRow(uint32 *XBuf, const MDFN_Rect *OSDRect, uint32 *preview, uint32 preview_width, uint32 preview_height, int *nstatus, int cur, uint8 *text)
{
 uint32 ymax = preview_height;
 uint32 xmax = preview_width;
 uint32 pitch32 = OSDRect->w;

 if(ymax > OSDRect->h - 3 - 37) ymax = OSDRect->h - 3 - 37;
 if(xmax > OSDRect->w - 2) xmax = OSDRect->w - 3;
 int dpsizemult = 1;

 if(ymax * 2 <= (OSDRect->h - 3 - 37) && xmax * 2 <= (OSDRect->w - 2))
  dpsizemult = 2;

 ymax *= dpsizemult;
 xmax *= dpsizemult;

 uint32 *XBaf;
 int x,y;
 int width = OSDRect->w;

 int rx = OSDRect->x + (width - xmax) / 2;
 int ry = (OSDRect->h - ymax - 37 ) + OSDRect->y;

 if(rx < 0) rx = 0;
 if(ry < 0) ry = 0;
 
 if((ry + 3 + 32) > OSDRect->h)
  ry = 0;

 MDFN_DrawRectangleAlpha(XBuf, pitch32, rx, ry, MK_COLORA(0x00, 0x00, 0x9F, 0xFF), xmax + 2, ymax + 2);

 XBaf = XBuf + 1 + (ry + 1) * pitch32;
 XBaf += rx;

 if(preview)
 {
  if(dpsizemult == 2)
  {
   for(y = 0; y < ymax; y++)
   {
    for(x = 0; x < xmax; x++)
    {
     XBaf[x] = preview[(y >> 1) * preview_width + (x >> 1)];
    }
    XBaf += pitch32;
   }
  }
  else
   for(y=0;y<ymax;y++)
   {
    memcpy(XBaf, preview + y * preview_width, xmax * sizeof(uint32));
    XBaf += pitch32;
   }
 }
 XBaf = XBuf + (3 + ry + ymax) * pitch32;

 /* Center it: */
 XBaf += OSDRect->x + (width - 150) / 2;

 for(y=0; y<32; y++)
  for(x=0;x<150;x++)
   XBaf[x + y * pitch32] = MK_COLORA(0x00, 0x00, 0x00, 0x80); 


 // nstatus
 for(int i = 1; i < 11; i++)
 {
  char stringie[2];
  uint32 bordercol;
  
  if(cur == (i % 10))
   bordercol = MK_COLORA(0x60, 0x20, 0xb0, 0xFF);
  else
   bordercol = MK_COLORA(0, 0, 0, 0xFF);

  stringie[0] = '0' + (i % 10);
  stringie[1] = 0;

  if(nstatus[i % 10])
   MDFN_DrawRectangleFill(XBaf, pitch32, (i - 1) * 15, 0, bordercol, MK_COLORA(0x00, 0x30, 0x20, 0xFF), 15, 14);
  else
   MDFN_DrawRectangle(XBaf, pitch32, (i - 1) * 15, 0, bordercol, 15, 14);
  DrawTextTrans(XBaf + (i - 1) * 15 + 5 + 1 + pitch32, pitch32 << 2, 150, (UTF8*)stringie, MK_COLORA(0x00, 0x00, 0x00, 0xFF), 0);
  DrawTextTrans(XBaf + (i - 1)* 15 + 5, pitch32 << 2, 150, (UTF8*)stringie, MK_COLORA(0xE0, 0xFF, 0xE0, 0xFF), 0);
 }
 DrawTextTrans(XBaf + 1 + 16 * pitch32, pitch32 << 2, 150, text, MK_COLORA(0x00, 0x00, 0x00, 0xFF), 1);
 DrawTextTrans(XBaf + 15 * pitch32, pitch32 << 2, 150, text, MK_COLORA(0xE0, 0xFF, 0xE0, 0xFF), 1);
}

