/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2005 CaH4e3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "mapinc.h"

static uint16 IRQCount;
static uint8 IRQa;
static uint8 prg_reg[2];
static uint8 chr_reg[8];

static SFORMAT StateRegs[]=
{
  {&IRQCount, 2, "IRQC"},
  {&IRQa, 2, "IRQA"},
  {prg_reg, 2, "PRG"},
  {chr_reg, 8, "CHR"},
  {0}
};

static void M222IRQ(void)
{
  if(IRQa)
  {
    IRQCount++;
    if(IRQCount>=240)
    {
      X6502_IRQBegin(FCEU_IQEXT);
      IRQa=0;
    }
  }
}

static void Sync(void)
{
  setprg8(0x8000,prg_reg[0]);
  setprg8(0xA000,prg_reg[1]);
  setchr1(0x0000,chr_reg[0]);
  setchr1(0x0400,chr_reg[1]);
  setchr1(0x0800,chr_reg[2]);
  setchr1(0x0c00,chr_reg[3]);
  setchr1(0x1000,chr_reg[4]);
  setchr1(0x1400,chr_reg[5]);
  setchr1(0x1800,chr_reg[6]);
  setchr1(0x1c00,chr_reg[7]);
}

static DECLFW(M222Write)
{
  switch(A&0xF003)
  {
    case 0x8000: prg_reg[0]=V; break;
    case 0xA000: prg_reg[1]=V; break;
    case 0xB000: chr_reg[0]=V; break;
    case 0xB002: chr_reg[1]=V; break;
    case 0xC000: chr_reg[2]=V; break;
    case 0xC002: chr_reg[3]=V; break;
    case 0xD000: chr_reg[4]=V; break;
    case 0xD002: chr_reg[5]=V; break;
    case 0xE000: chr_reg[6]=V; break;
    case 0xE002: chr_reg[7]=V; break;
    case 0xF000: IRQCount=IRQa=V;
                 X6502_IRQEnd(FCEU_IQEXT);
                 break;
  }
  Sync();
}

static void M222Power(void)
{
  setprg16(0xC000,~0);
  SetReadHandler(0x8000,0xFFFF,CartBR);
  SetWriteHandler(0x8000,0xFFFF,M222Write);
}

static void StateRestore(int version)
{
  Sync();
}

void Mapper222_Init(CartInfo *info)
{
  info->Power=M222Power;
  GameHBIRQHook=M222IRQ;
  GameStateRestore=StateRestore;
  AddExState(&StateRegs, ~0, 0, 0);
}
